<?php
class Autoloader
{
    /**
     * Metodo encargado de ejecutar nuestro autoload
     *
     * @return void 
     * 
     */
    public static function init(){
        spl_autoload_register([__CLASS__,'autoload']);
    }

    private static function autoload($className){
        if(is_file(CLASSES.$className.'.php')){
            require_once CLASSES.$className.'.php';
        }else if(is_file(CONTROLLERS.$className.'.php')){
            require_once CONTROLLERS.$className.'.php';
        }else if(is_file(MODELS.$className.'.php')){
            require_once MODELS.$className.'.php';
        }

        return;
    }
}