<?php

class Codi
{
    //Propiedades del Framework CodificandoMX

    private $framework = 'CodificandoMx Framework';
    private $version = '1.2.1';
    private $uri = [];

    //Función Principal al instanciar nuestra clase

    function __construct()
    {
        $this->init();
    }

    /**
     * 
     * Método para ejecutar cada "método" de forma subsecuente
     * 
     */

    private function init()
    {
        //Todos los metodos que queremos ejecutar consecutivamente
        $this->init_session();
        $this->init_load_config();
        $this->init_load_function();
        $this->init_autoload();
        //$this->init_csrf();
        $this->dispatch();
    }

    /**
     * Metodo para iniciar la sesión en el sistema
     * 
     * @return void
     */

    private function init_session()
{
    if (session_status() !== PHP_SESSION_ACTIVE) {

        session_set_cookie_params([
            'lifetime' => 0,
            'path' => '/admin',   // 🔥 ESTE ES EL CAMBIO CLAVE
            'secure' => true,
            'httponly' => true,
            'samesite' => 'Lax'
        ]);

        session_start();


    }
}

    /**
     * Metodo para cargar la configuración del sistema
     * 
     * @return void
     */

    private function init_load_config()
    {

        $file = 'codi_config.php';
        if (!is_file('app/config/' . $file)) {
            die(sprintf('El archivo %s no se encuentra, es necesario para que %s funcione', $file, $this->framework));
        }

        // Carga el archivo de configuraciones
        require_once 'app/config/' . $file;

        return;
    }

    /**
     * Metodo para cargar las funciones del sistema y del usuario
     * 
     * @return void
     */
    private function init_load_function()
    {

        $file = 'codi_core_functions.php';
        if (!is_file(FUNCTIONS . $file)) {
            die(sprintf('El archivo %s no se encuentra, es necesario para que %s funcione', $file, $this->framework));
        }
        // Carga el archivo core
        require_once FUNCTIONS . $file;

        $file = 'codi_custom_functions.php';
        if (!is_file(FUNCTIONS . $file)) {
            die(sprintf('El archivo %s no se encuentra, es necesario para que %s funcione', $file, $this->framework));
        }
        // Carga el archivo custom
        require_once FUNCTIONS . $file;

        return;
    }

    /**
     * Metodo para cargar los archivos de forma automatica
     * 
     * @return void
     */

    private function init_autoload()
    {
        //ini_set('error_reporting', E_ALL);
        //ini_set('display_errors', true);
        require_once CLASSES . 'Autoloader.php';
        Autoloader::init();
        /*require_once CLASSES.'Db.php';
        require_once CLASSES.'Model.php';
        require_once CLASSES.'View.php';
        require_once CLASSES.'Controller.php';
        require_once CONTROLLERS.DEFAULT_CONTROLLER.'Controller.php';
        require_once CONTROLLERS.DEFAULT_ERROR_CONTROLLER.'Controller.php';
        require_once CONTROLLERS.DEFAULT_USERS_CONTROLLER.'Controller.php';
        require_once CONTROLLERS.DEFAULT_CLIENTES_CONTROLLER.'Controller.php';
        require_once CONTROLLERS.DEFAULT_PRODUCTOS_CONTROLLER.'Controller.php';
        require_once CONTROLLERS.DEFAULT_AUTHS_CONTROLLER.'Controller.php';
        require_once CONTROLLERS.DEFAULT_ALMACENES_CONTROLLER.'Controller.php';*/
        require_once PHPQR . "qrlib.php";
        require_once PHPMAILER . 'autoload.php';
        require_once PLUGIN_TCPDF . 'tcpdf_include.php';

        return;
    }

    /**
     * Metodo para crear un nuevo token de la sesion de usuario
     * @return void
     */

    private function init_csrf()
    {
        $csrf = new Csrf();
    }

    /**
     * Metodo para filtrar y descomponer los elementos de nuestra url y uri
     * 
     * @return void
     */
    private function filter_url()
    {
        if (isset($_GET['uri'])) {
            $this->uri = $_GET['uri'];
            $this->uri = rtrim($this->uri, '/');
            $this->uri = filter_var($this->uri, FILTER_SANITIZE_URL);
            $this->uri = explode('/', strtolower($this->uri));
            return $this->uri;
        }
    }

    /**
     * Metodo para ejecutar de forma automatica el controlador solicitado por el usuario
     * su método y pasar parametros a él
     * @return void
     */

    private function dispatch()
    {

        // Filtrar La URL y separar la URI
        $this->filter_url();

        // Validar si estamos pasando el nombre de un controlador en nuesto URI
        // $this->uri[0]

        if (isset($this->uri[0])) {
            $current_controller = $this->uri[0]; // se asigna el uri 0 del URL
            unset($this->uri[0]);
        } else {
            $current_controller = DEFAULT_CONTROLLER; // Home; 
        }

        // Ejecución del controlador
        // Verificamos si existe una clase con el controlador solicitado

        $controller = $current_controller . 'Controller';

        if (!class_exists($controller)) {
            $controller = DEFAULT_ERROR_CONTROLLER . 'Controller'; // errorController
            $current_controller = DEFAULT_ERROR_CONTROLLER;
        }

        // Ejecucion del Método

        if (isset($this->uri[1])) {
            $method = str_replace('-', '_', $this->uri[1]);

            // Existe el metodo dentro de la clase (controlador)

            if (!method_exists($controller, $method)) {
                $controller = DEFAULT_ERROR_CONTROLLER . 'Controller'; // Error Controller
                $current_method = DEFAULT_METHOD; // index
                $current_controller = DEFAULT_ERROR_CONTROLLER;
            } else {
                $current_method = $method;
            }
            unset($this->uri[1]);
        } else {
            $current_method = DEFAULT_METHOD;
        }

        // Creando constantes

        define('CONTROLLER', $current_controller);
        define('METHOD', $current_method);

        // Ejecutando controlador y método según se haga la petición

        $controller = new $controller;


        // Obteniendo los parametros del URI

        $params = array_values(empty($this->uri) ? [] : $this->uri);

        // Llamada al metodo que solicita el usuario

        if (empty($params)) {
            call_user_func([$controller, $current_method]);
        } else {
            call_user_func_array([$controller, $current_method], $params);
        }

        return; // Linea final de la ejecución

    }

    /**
     * Correo nuestro framework
     * 
     * @return void
     */
    public static function codificando()
    {
        $codi = new self();
        return;
    }
}
