<?php
class Flasher{
    private $valid_types = ['primary','secondary','success','danger','warning','info','light','dark'];
    private $default = 'primary';
    private $type;
    private $msg;

    /**
     * 
     * 
     * Método para guardar una notificación flash
     * @param string array $msg
     * @param string $type
     * @return void
     * 
     * 
     */

    public static function new($msg, $type=null){
        $self = new self();

        // Setear el tipo de notificación por defecto
        if($type === null){
            $self->type = $self->default;
        }

            $self->type = in_array($type, $self->valid_types) ? $type : $self->default;


        // Guardar la notificación en un array de sesion

        if(is_array($msg)){

            foreach ($msg as $m){
                $_SESSION[$self->type][] = $m;
            }

            return true;

        }

        $_SESSION[$self->type][] = $msg;

        return true;
    }

     /**
     * 
     * Renderiza las notificaciones flash
     * @return void
     * 
     */
    public static function flash(){
        $self = new self();
        $output = '';

        foreach ($self ->valid_types as $type){
            if(isset($_SESSION[$type]) && !empty($_SESSION[$type])){
                
                foreach($_SESSION[$type] as $m){
                    $output .= '<div class="alert alert-pro alert-'.$type.' alert-dismissible">
                    <div class="alert-text">
                        <h6>Your Order Placed</h6>
                        <p>'.$m.'</p>
                    </div>
                    <button class="close" data-bs-dismiss="alert"></button>
                </div>';
                }
              unset($_SESSION[$type]);
            }
        }
        return $output;
    }
}