<?php

// Configuracion de forma local o remota
define('IS_LOCAL', in_array($_SERVER['REMOTE_ADDR'], ['127.0.0.1', '::1']));

// Defenir el TimeZone del Sistema
date_default_timezone_set('America/Mexico_City');

// Lenguaje
define('LANG', 'es');

// Ruta base del proyecto
define('BASEPATH', IS_LOCAL ? './codiframe/' : './');

// Sal del Sistema
define('AUTH_SALT', 'c4ndo<3lat!0');

// Puerto y la url del sitio
define('PORT', '80');
define('URL', IS_LOCAL ? 'https://site.test/codiframe/' : 'https://grupoxtinfire.com/admin/');

// Las rutas de directorios y archivos ROOT
define('DS', DIRECTORY_SEPARATOR);
define('ROOT', getcwd() . DS);

define('APP', ROOT . 'app' . DS); /*c://xampp/htdocs/codificando/app/*/
define('CLASSES', APP . 'classes' . DS); /*c://xampp/htdocs/codificando/app/classes/*/
define('CONFIG', APP . 'config' . DS);
define('CONTROLLERS', APP . 'controllers' . DS);
define('FUNCTIONS', APP . 'functions' . DS);
define('MODELS', APP . 'models' . DS);

define('TEMPLATES', ROOT . 'templates' . DS);
define('INCLUDES', TEMPLATES . 'include' . DS);
define('MODULES', TEMPLATES . 'modules' . DS);
define('VIEWS', TEMPLATES . 'views' . DS);

define('MICROSITIO', VIEWS . 'micrositio' . DS);

// Las rutas de directorios y archivos URL
define('ASSETS', URL . 'assets/');
define('CSS', ASSETS . 'css/');
define('FAVICON', ASSETS . 'favicon/');
define('FONTS', ASSETS . 'fonts/');
define('IMAGES', ASSETS . 'img' . DS);
define('JS', ASSETS . 'js/');
define('PLUGINS', ASSETS . 'plugins/');
define('UPLOADS', ASSETS . 'uploads/');
define('UPLOADSPDF',  ROOT . 'assets/pdf/facturaprov/');
define('UPLOADSPDFORD',  ROOT . 'assets/pdf/facturaord/');
define('PRODUCTS_FRONT', ASSETS . 'img/products/');
define('FIRMAS_FRONT', ASSETS . 'img/firmas/');
define('PRODUCTS', ROOT . 'assets/img/products/');
define('FIRMAS', ROOT . 'assets/img/firmas/');
define('FACTURAPROV', ROOT . 'assets/pdf/facturaprov/');
define('SELECT2', JS . 'select/');

//Plugins 
define('ASSETS_PLUGINS', ROOT . 'assets' . DS);
define('PLUGINS_ROOT', ASSETS_PLUGINS . 'plugins/');
define('PHPQR', PLUGINS_ROOT . 'phpqrcode/');
define('PHPMAILER', PLUGINS_ROOT . 'vendor/');
define('PLUGIN_TCPDF', PLUGINS_ROOT . 'TCPDF/examples/');
define('WHATSAPP', ASSETS_PLUGINS . 'vendor/');

// Las rutas de directorios y archivos URL Secundarias
define('ICONS', IMAGES . 'icons/');
define('IMAGESSUB', IMAGES . 'images' . DS);
define('JSCALENDAR', JS . 'calendar/');

// Credenciales DB 
//Set para conexión Serividor o produccion
define('DB_ENGINE', 'mysql');
define('DB_HOST', 'localhost');
define('DB_NAME', 'xtinfire_fire25');
define('DB_USER', 'xtinfire_garu');
define('DB_PASS', 'Garuycow21');
define('DB_CHARSET', 'utf8');

// El controlador por defecto / el método por defecto y el controlador de errores por defecto

define('DEFAULT_CONTROLLER', 'home');
define('DEFAULT_ERROR_CONTROLLER', 'error');
define('DEFAULT_METHOD', 'index');
//define('DEFAULT_USERS_CONTROLLER','users');
//define('DEFAULT_CLIENTES_CONTROLLER','clientes');
//define('DEFAULT_PRODUCTOS_CONTROLLER','productos');
//define('DEFAULT_CATEGORIAS_CONTROLLER','categorias');
//define('DEFAULT_ALMACENES_CONTROLLER','almacenes');
//define('DEFAULT_AUTHS_CONTROLLER','auths');


//Correos electrónicos
define('GUSER', 'admin@grupoxtinfire.com');
define('GPWD', '!Garuycow1');