<?php
class ajaxController extends Controller
{
    private $accepted_actions = ['add', 'get', 'load', 'update', 'delete'];
    private $required_params = ['hook', 'action'];
    private $required_llave = ['contpai5F18B7AB1DC7C8A7F37E221F1C60A6'];
    function __construct()
    {
        foreach ($this->required_params as $param) {
            if (!isset($_POST[$param])) {
                json_output(json_build(403));
            }
        }

        if (!in_array($_POST['action'], $this->accepted_actions)) {
            json_output(json_build(403));
        }
    }

    function index()
    {
        json_output(json_build(403));
    }


    function codi_login_auth()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $usuario  = new authModel;
            $usuario->correo = $_POST['correo'];
            $usuario->password = $_POST['password'];

            $arr = $usuario->login();
            json_output(json_build($arr[0], $arr[1], $arr[2]));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_login_theme()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $usuario  = new authModel;
            $arr = $usuario->codi_theme();
            json_output(json_build(201,$arr,"Tema cargado"));  
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_validarcontra()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $usuario  = new authModel;
            $usuario->idUsuario = $_POST['idsolicitante'];
            $usuario->password = $_POST['contrasena'];

            if (!$json = $usuario->codi_autorizar_accion()) {

                json_output(json_build(400, null, 'Hubo un error al validar la contraseña'));
            }

            json_output(json_build($json[0], $json[1], $json[2]));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_validartiempo()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        $regresarbool = false;
        try {
            if(Csrf::validate($_SESSION['token'],true)){
              $regresarbool = true;
            }
            json_output(json_build(201, $regresarbool, 'consulta exitosa'));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_add_usuario()
    {

        try {
            $usuario = new usuariosModel();
            $usuario->Usuario = $_POST['Usuario'];
            $usuario->Correo = $_POST['Correo'];
            $usuario->Telefono = $_POST['Telefono'];
            $usuario->Departamento = $_POST['Departamento'];
            $usuario->NombreUsuario = $_POST['NombreUsuario'];
            $usuario->Contra = $_POST['Contra'];

            if (!$id = $usuario->add()) {

                json_output(json_build(400, null, 'Hubo un error al guardar el registro'));
            }

            $usuario->IdUsuario = $id;
            json_output(json_build(201, $usuario->one(), 'Usuario agregado con exito'));
        } catch (Exception $e) {
            throw json_output(json_build(400, null, $e->getMessage()));
        }
    }


    function codi_add_meta()
    {
        try {
                $usuario = new usuariosModel();
                $filas = json_decode($_POST['meta'], true);
                $idUsu = $filas[0]["idUsuarioVen"];
                $idFi = $filas[0]["PeriodoInicial"];
                $idFf = $filas[0]["PeriodoFinal"];
                $usuario->usuvalRegistro = $idUsu;
                $usuario->usuvalidFi = $idFi;
                $usuario->usuvalidFf = $idFf;
                $validarregistro = $usuario->valregistro_meta();
                if($validarregistro){
                    json_output(json_build(201, null, 'Ya existen fechas asignas para este equipo'));
                    
                }else{
                    foreach ($filas as $fila) {

                    $usuario->IdGrupoUsMeta = $fila['IdGrupoUsMeta'];
                    $usuario->idUsuarioVen = $fila['idUsuarioVen'];
                    $usuario->NombreVendedor = $fila['NombreVendedor'];
                    $usuario->TipodeUsuario = $fila['TipodeUsuario'];
                    $usuario->PeriodoInicial = $fila['PeriodoInicial'];
                    $usuario->PeriodoFinal = $fila['PeriodoFinal'];
                    $usuario->MetaDinero = $fila['MetaDinero'];
                    $usuario->MetaTotal = $fila['MetaTotal'];
                    $usuario->MetaFacturas = $fila['MetaFacturas'];

                    $metas = $usuario->add_meta();
                        if (!$metas) {
                            json_output(json_build(201, null, 'Hubo un error al guardar el grupo.'));
                        }
                    }
            
                    json_output(json_build(200, null, 'Grupo agregado con exito'));
                }
                
             
        } catch (Exception $e) {
            throw json_output(json_build(400, null, $e->getMessage()));
        }
    }

    function codi_add_ancla()
    {
ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $ordenes = new ordenesModel();
            $filas = json_decode($_POST['anclasstring'],true);
            $filas2 = $_POST['anclasstring'];
            
            foreach ($filas as $fila) {

                $ordenes->ancla = $filas2;
                $ordenes->IdOrden = $fila['anclas'];
                $IdAncla = $ordenes->insert_ancla();
                if (!$IdAncla) {
                    json_output(json_build(400, null, 'Hubo un error al guardar el grupo.'));
                }
            }
        
            // $usuario->IdUsuario = $id;
            json_output(json_build(200, null, 'Grupo agregado con exito'));
        } catch (Exception $e) {
            throw json_output(json_build(400, null, $e->getMessage()));
        }
    }

    function insertar_fechas_pipc()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $ordenes = new ordenesModel();
            $ordenes->FechaInicioPipc = $_POST['fechainipipc'];
            $ordenes->FechaTerminoPipc = $_POST['fechafinpipc'];
            $ordenes->IdOrden = $_POST['IdOrden'];
            $id = $ordenes->insert_fecha_pipc();
            if (!$id) {
                json_output(json_build(400, null, 'Hubo un error al guardar la fecha.'));
            }
            $notifi2 = new notificacionesModel();
            $notifi2->Departamento = 23;
            $notifi2->Tipo = 1;
            $notifi2->Descripcion = "Tu departamento recibio una solicitud:  " . $_POST['IdOrden'] . ".";
            $notifi2->Folio = $_POST['IdOrden'];
            $notifi2->Usuario = 
            $notifi2->add();
            if (!$notifi2) {
                json_output(json_build(400, null, 'Hubo un error al guardar la notifiacion.'));
            }
            $ordenes2 = new ordenesModel();
            $ordenes2->IdOrden = $_POST['IdOrden'];
            $ordenes2->update_estatus_transito_por_fechas();
            if (!$ordenes2) {
                json_output(json_build(400, null, 'Hubo un error al guardar el estatus transito.'));
            }
            // $usuario->IdUsuario = $id;
            json_output(json_build(200, null, 'Fecha agregado con exito'));
        } catch (Exception $e) {
            throw json_output(json_build(400, null, $e->getMessage()));
        }
    }

    

    function codi_add_producto()
    {
        //ini_set('display_errors', 1);
        //ini_set('display_startup_errors', 1);

        //error_reporting(E_ALL);
        try {
            $usuario = new productosModel();
            $imgs = new imagenesproductoModel();
            $usuario->proTitulo = $_POST['proTitulo'];
            $usuario->proPreciocosto = $_POST['proPreciocosto'];
            $usuario->proPrecioventa = $_POST['proPrecioventa'];
            $usuario->proExistencia = $_POST['proExistencia'];
            $usuario->proCapacidad = $_POST['proCapacidad'];
            $usuario->proMarca = $_POST['proMarca'];
            $usuario->proTipoExtintor = $_POST['proTipoExtintor'];
            $usuario->proSku = $_POST['proSku'];
            $usuario->proCatId = $_POST['proCatId'];
            $usuario->proAlmId = $_POST['proAlmacen'];
            $usuario->proMax = $_POST['proMax'];
            $usuario->proMin = $_POST['proMin'];
            $usuario->proTipoCambio = $_POST['proTipoCambio'];
            $usuario->proSubCategoria = $_POST['proSubCategoria'];
            $usuario->proMoneda = $_POST['proMoneda'];
            $usuario->actventas = $_POST['activoventas'];
            $usuario->temporal = $_POST['temporal'];
            $usuario->online = $_POST['online'];
            $usuario->clavesat = $_POST['clavesat'];
            $usuario->unidadsat = $_POST['unidadsat'];

            $filas = json_decode($_POST['proImagen'], true);
            
            if (count($filas) > 0) {
                $usuario->proImagen = $filas[0];
            }else{
    
                $usuario->proImagen = "";
            }

            $id = $usuario->add();
            if (!$id) {
                json_output(json_build(400, null, 'Hubo un error al guardar el registro'));
            }

            foreach ($filas as $fila) {
                $imgs->IdProducto = $id;
                $imgs->b64 = $fila;
                $idimg = $imgs->add();
                if (!$idimg) {
                    json_output(json_build(400, null, 'Hubo un error al guardar la imagen del producto.'));
                }
            }

            $pdf = $_FILES['customFile']['name'];
            if($pdf){
                $img2 = new imagenesproductoModel();
                $img2->filename = $_FILES['customFile']['name'];
                $img2->temppath=$_FILES["customFile"]["tmp_name"];
                $img2->IdProducto = $id;
                $fileNameid = $img2->addpdf();
                if(!$fileNameid){
                    json_output(json_build(400, null, 'Hubo un error al guardar la ficha tecnica'));
                }
            }
        
            // $usuario->IdUsuario = $id;
            json_output(json_build(201, null, 'Producto agregado con exito'));
        } catch (Exception $e) {
            throw json_output(json_build(400, null, $e->getMessage()));
        }
    }

    function codi_crear_grupo()
    {ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $usuario = new usuariosModel();
            $filas = json_decode($_POST['vendedoresS'], true);
            $filas = $filas['vendedores'];
            $usuario->nomgrupo = $_POST['nomGrupo'];
            $usuario->idGrupo = $_POST['IdGrupo'];
            foreach ($filas as $fila) {

                $usuario->IdUsuario = $fila['idVendedor'];
                $usuario->NombreVendedor = $fila['NombreVendedor'];
                $usuario->TipoIntegrante = $fila['TipoIntegrante'];
                $usuario->PartidaIntegrante = $fila['PartidaIntegrante'];
                
                $IdUsu = $usuario->add_grupo();
                if (!$IdUsu) {
                    json_output(json_build(400, null, 'Hubo un error al guardar el grupo.'));
                }
            }
        
            // $usuario->IdUsuario = $id;
            json_output(json_build(200, null, 'Grupo agregado con exito'));
        } catch (Exception $e) {
            throw json_output(json_build(400, null, $e->getMessage()));
        }
    }

    function codi_crear_grupo_uno()
    {ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $usuario = new usuariosModel();
            $usuario->nomgrupo = $_POST['nomGrupo'];
            $usuario->idGrupo = $_POST['IdGrupo'];
            $usuario->IdUsuario = $_POST['idVendedor'];
            $usuario->NombreVendedor = $_POST['NombreVendedor'];
            $usuario->TipoIntegrante = $_POST['TipoIntegrante'];
            $usuario->PartidaIntegrante = $_POST['PartidaIntegrante'];
            $IdUsu = $usuario->add_grupo();
            if (!$IdUsu) {
                json_output(json_build(400, null, 'Hubo un error al guardar el grupo.'));
            }
        
            // $usuario->IdUsuario = $id;
            json_output(json_build(200, null, 'Grupo agregado con exito'));
        } catch (Exception $e) {
            throw json_output(json_build(400, null, $e->getMessage()));
        }
    }

    function codi_add_factura(){
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        $id = $_POST['idc'];
        $pdf = $_FILES['pdf']['name'];
            if($pdf){
                $arpdf = new facturaspdfModel();
                $arpdf->filename = $_FILES['pdf']['name'];
                $arpdf->temppath=$_FILES["pdf"]["tmp_name"];
                $arpdf->Id = $id;
                $fileNameid = $arpdf->addpdfac();
                if(!$fileNameid){
                    json_output(json_build(400, null, 'Hubo un error al guardar la ficha tecnica'));
                }
            }

            $xml = $_FILES['xml']['name'];
            if($xml){
                $xml = new facturaspdfModel();
                $xml->filename = $_FILES['xml']['name'];
                $xml->temppath=$_FILES["xml"]["tmp_name"];
                $xml->Id = $id;
                $fileNameidxml = $xml->addpdfac();
                if(!$fileNameidxml){
                    json_output(json_build(400, null, 'Hubo un error al guardar la ficha tecnica'));
                }
            }

        json_output(json_build(201, null, 'Factura subida con exito'));
    }


    function codi_add_factura_orden(){
/*ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);*/

        error_reporting(E_ALL);
        $id = $_POST['idc'];
        $pdf = $_FILES['pdf']['name'];
            if($pdf){
                $arpdf = new facturaspdfModel();
                $arpdf->filename = $_FILES['pdf']['name'];
                $arpdf->temppath=$_FILES["pdf"]["tmp_name"];
                $arpdf->Id = $id;
                $fileNameid = $arpdf->addpdfacord();
                if(!$fileNameid){
                    json_output(json_build(400, null, 'Hubo un error al guardar la ficha tecnica'));
                }
            }

            /*$xml = $_FILES['xml']['name'];
            if($xml){
                $xml = new facturaspdfModel();
                $xml->filename = $_FILES['xml']['name'];
                $xml->temppath=$_FILES["xml"]["tmp_name"];
                $xml->Id = $id;
                $fileNameidxml = $xml->addpdfacord();
                if(!$fileNameidxml){
                    json_output(json_build(400, null, 'Hubo un error al guardar la ficha tecnica'));
                }
            }*/

        json_output(json_build(201, null, 'Constancia subida con exito'));
    }

    function codi_add_factura_orden_pago(){

        $id = $_POST['idc'];
        $pdf = $_FILES['pdfpago']['name'];
            if($pdf){
                $arpdf = new facturaspdfModel();
                $arpdf->filename = $_FILES['pdfpago']['name'];
                $arpdf->temppath=$_FILES["pdfpago"]["tmp_name"];
                $arpdf->Id = $id;
                $fileNameid = $arpdf->addpdfacord_pago();
                if(!$fileNameid){
                    json_output(json_build(400, null, 'Hubo un error al guardar la ficha tecnica'));
                }
            }

        json_output(json_build(201, null, 'pago subida con exito'));
    }

    function codi_add_factura_orden_pago_cotizacion(){

        $id = $_POST['idc'];
        $pdf = $_FILES['pdfpago']['name'];
    
            if($pdf){
                $arpdf = new facturaspdfModel();
                $arpdf->filename = $_FILES['pdfpago']['name'];
                $arpdf->temppath=$_FILES["pdfpago"]["tmp_name"];
                $arpdf->idCotizacion = $id;
                $fileNameid = $arpdf->addpdfacord_pago_cotizacion();

                if(!$fileNameid){
                    json_output(json_build(400, null, 'Hubo un error al guardar la ficha tecnica'));
                }
            }

        json_output(json_build(201, null, 'pago subida con exito'));
    }


    function codi_add_factura_orden_croquis(){

        $id = $_POST['idc'];
        $pdf = $_FILES['pdfcroquis']['name'];
            if($pdf){
                $arpdf = new facturaspdfModel();
                $arpdf->filename = $_FILES['pdfcroquis']['name'];
                $arpdf->temppath=$_FILES["pdfcroquis"]["tmp_name"];
                $arpdf->Id = $id;
                $fileNameid = $arpdf->addpdfacord_croquis();
                if(!$fileNameid){
                    json_output(json_build(400, null, 'Hubo un error al guardar la imagen tecnica'));
                }
            }

        json_output(json_build(201, null, 'Croquis subida con exito'));
    }

    

    function codi_delete_usuario()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);

        try {
            $usuario  = new usuariosModel;
            $usuario->IdUsuario = $_POST['idUsuario'];
            $usuario->activo = $_POST['activo'];

            if (!$usuario->delete()) {
                json_output(json_build(400, null, 'Hubo error al guardar los cambios'));
            }

            // se guardó con éxito
            json_output(json_build(200, null, 'Usuario eliminado con éxito'));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function eliminar_vendedores_metas()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);

        try {
            $usuario  = new usuariosModel;
            $usuario->IdUsuario = $_POST['IdUsuario'];
            $usuario->idGrupo = $_POST['IdGrupoUs'];

            if (!$usuario->delete_usuario_meta()) {
                json_output(json_build(400, null, 'Hubo error al guardar los cambios'));
            }

            // se guardó con éxito
            json_output(json_build(200, null, 'Usuario eliminado con éxito'));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function eliminarGrp_metas()
        {
            ini_set('display_errors', 1);
            ini_set('display_startup_errors', 1);

            error_reporting(E_ALL);

            try {
                $usuario  = new usuariosModel;
                $usuario->idGrupo = $_POST['IdGrupoUs'];

                if (!$usuario->delete_gpr_meta()) {
                    json_output(json_build(400, null, 'Hubo error al guardar los cambios'));
                }

                // se guardó con éxito
                json_output(json_build(200, null, 'Usuario eliminado con éxito'));
            } catch (Exception $e) {
                json_output(json_build(400, $e->getMessage()));
            }
        }

    function codi_get_usuarios()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $usuario  = new usuariosModel;
            $usuarios = $usuario->all();
            $data = get_module('tablausuarios', $usuarios);
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_usuarios_reporte()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $usuario  = new usuariosModel;
            $usuarios = $usuario->all();
            json_output(json_build(200, $usuarios));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_usuarios_vales()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $usuario  = new usuariosModel;
            $usuarios = $usuario->all();
            $data = get_module('selectusuarios', $usuarios);
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_usuarios_tipo_insumos()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $insumos  = new almacenesModel;
            $insumos = $insumos->insumos();
            $data = get_module('selectusuariosinsumos', $insumos);
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_usuarios_tipo_productos()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $insumos  = new productosModel;
            $insumos = $insumos->productos_vale();
            $data = get_module('selectproductos', $insumos);
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_usuarios_tipo_salida()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $salidas  = new almacenesModel;
            $salidas = $salidas->salidas();
            $data = get_module('selectusuariossalida', $salidas);
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_rfc()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $clientes  = new clientesModel;
            $clientes->RFC = $_POST['rfc'];
            $data = $clientes->rfc();
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_vendedores_select()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $usuario  = new usuariosModel;
            $usuarios = $usuario->vendedores();
            $data = get_module('selectvendedores', $usuarios);
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_vendedores_json()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $usuario  = new usuariosModel;
            $usuarios = $usuario->vendedores();
            json_output(json_build(200, $usuarios));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_vendedore_activo()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        $idvendedor = $_POST['vendedoractivo'];
        try {
            $usuario  = new usuariosModel;
            $usuario->IdUsuario = $idvendedor;
            $usuarios = $usuario->vendedorescheck();
            json_output(json_build(200, $usuarios));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_numerogrupos()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $usuario  = new usuariosModel;
            $usuarios = $usuario->numerogrupos();
            json_output(json_build(200, $usuarios));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_grupounit()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        $Idgroup = $_POST['editarId'];
        
        try {
            $usuario  = new usuariosModel;
            $usuario->idGrupo = $Idgroup;
            $usuarios = $usuario->traergrupouni();
            json_output(json_build(200, $usuarios));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_vendedores_select_grupo()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $usuario  = new usuariosModel;
            $usuarios = $usuario->vendedores();
            $data = get_module('selectvendedoresgrupo', $usuarios);
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_facturacion_select()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $usuario  = new usuariosModel;
            $usuarios = $usuario->userfacturas();
            $data = get_module('selectfacturacionuser', $usuarios);
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_instructores_select()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $usuario  = new usuariosModel;
            $usuarios = $usuario->instructores();
            $data = get_module('selectinstructores', $usuarios);
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_instructores_json()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $usuario  = new usuariosModel;
            $usuarios = $usuario->instructores();
            json_output(json_build(200, $usuarios));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_partidas_select()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $partidas  = new cotizacionesModel;
            $partidas->IdCotizacion = $_POST['IdCotizacion'];
            $partidas = $partidas->detalle();
            $data = get_module('selectpartidas', $partidas);
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }


    function codi_get_partidas_select_orden()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $partidas  = new ordenesModel;
            $partidas->IdOrden = $_POST['IdOrden'];
            $partidas = $partidas->detalle();
            $data = get_module('selectpartidas', $partidas);
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }


    function codi_get_productos()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $producto  = new productosModel;
            $productos = $producto->all();
            $data = get_module('tablaproductos', $productos);
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_vales()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $vales = new almacenesModel;
            $vales = $vales->allvales();
            json_output(json_build(200, $vales));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_productos2()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $usuario  = new productosModel;
            $usuarios = $usuario->all2();
            json_output(json_build(200, $usuarios));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_productos3()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $usuario  = new productosModel;
            $usuarios = $usuario->all3();
            json_output(json_build(200, $usuarios));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_seisvendidos()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);
        error_reporting(E_ALL);
        $fechaInicio =date("Y-m-01");
        $fechafin =date("Y-m-d");

        try {
            $usuario  = new productosModel;
            $usuario->fechainicial = $fechaInicio;
            $usuario->fechafinal = $fechafin;
            $usuarios = $usuario->seisvendidos();
            json_output(json_build(200, $usuarios));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_productos_select()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $productos  = new productosModel;
            $productos = $productos->all();
            $data = get_module('selectproductos', $productos);
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_productos_almacen_select()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $almacen = $_POST['almacen'];
            $productos  = new productosModel;
            $productos->proAlmId = $almacen;
            $productos = $productos->all_almacen();
            $data = get_module('selectproductos', $productos);
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_productos_almacen_select_ind()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $almacen = $_POST['almacen'];
            $tipoods = $_POST['tipoods'];
            $productos  = new productosModel;
            $productos->proAlmId = $almacen;
            $productos->tipo = $tipoods;
            $productos = $productos->all_almacen_ind();
            $data = get_module('selectproductos', $productos);
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_categoriap_select()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $producto  = new productosModel;
            $productos = $producto->categorias();
            $data = get_module('selectcategoria', $productos);
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_subcategoriap_select()
        {
            ini_set('display_errors', 1);
            ini_set('display_startup_errors', 1);

            error_reporting(E_ALL);
            try {
                $producto  = new productosModel;
                $productos = $producto->subcategoria();
                $data = get_module('selectsubcategoria', $productos);
                json_output(json_build(200, $data));
            } catch (Exception $e) {
                json_output(json_build(400, $e->getMessage()));
            }
        }
    function codi_get_subcategoriap_select2()
        {
            ini_set('display_errors', 1);
            ini_set('display_startup_errors', 1);

            error_reporting(E_ALL);
            try {
                $producto  = new productosModel;
                $sub = $_POST['sub'];
                $producto->proSubCategoria = $sub;
                $productos = $producto->subcategoria2();
                $data = get_module('selectsubcategoria', $productos);
                json_output(json_build(200, $data));
            } catch (Exception $e) {
                json_output(json_build(400, $e->getMessage()));
            }
        }
    function codi_get_departamento_select()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $departamento  = new usuariosModel;
            $departamentos = $departamento->departamento();
            $data = get_module('selectdepartamento', $departamentos);
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_departamento_json()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $departamento  = new usuariosModel;
            $departamentos = $departamento->departamento();
            json_output(json_build(200, $departamentos));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_proveedores_select()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $proveedor  = new proveedoresModel;
            $proveedores = $proveedor->all();
            $data = get_module('selectproveedores', $proveedores);
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_producto()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);

        try {

            $productos  = new productosModel;
            $productos->proId = $_POST['proId'];
            $producto = $productos->oneAll();
            json_output(json_build(200, $producto));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_proveedor()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);

        try {

            $proveedores  = new proveedoresModel;
            $proveedores->id = $_POST['id'];
            $proveedor = $proveedores->one();
            json_output(json_build(200, $proveedor));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_update_usuario()
    {
        //ini_set('display_errors', 1);
        //ini_set('display_startup_errors', 1);

        //error_reporting(E_ALL);
        try {
            $usuario  = new usuariosModel;
            $usuario->IdUsuario = $_POST['IdUsuE'];
            $usuario->Telefono = $_POST['ETelefono'];
            $usuario->Departamento = $_POST['EDepartamento'];
            $usuario->Contra = $_POST['EContra'];
            if (!$usuario->update()) {
                json_output(json_build(400, null, 'Hubo error al guardar los cambios'));
            }

            // se guardó con éxito
            json_output(json_build(200, $usuario->one(), 'Usuario actualizado con exito'));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }


    function codi_update_estatus_pago_fact()
    {
        //ini_set('display_errors', 1);
        //ini_set('display_startup_errors', 1);

        //error_reporting(E_ALL);
        try {
             $pagoupdate = new ComplementosModel;
            $pagoupdate->NMes = $_POST['mespartida'];
            $pagoupdate->IdOrden = $_POST['ordeninvoice'];
            $pagoupdate->Estatus = $_POST['estatus'];
            if (!$pagoupdate->updatepagar()) {
                json_output(json_build(400, null, 'Hubo error al guardar los cambios'));
            }

            // se guardó con éxito
            json_output(json_build(200, null, 'Actualizado con exito'));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }


    function codi_update_facturador_grupo()
    {
        //ini_set('display_errors', 1);
        //ini_set('display_startup_errors', 1);

        //error_reporting(E_ALL);
        try {
            $facturador = new usuariosModel;
            $facturador->idVendedor = $_POST['idFacturador'];
            $facturador->NombreVendedor = $_POST['NombreFacturador'];
            $facturador->idGrupo = $_POST['IdGrupo'];
            
            if (!$facturador->update_facturador_uni()) {
                json_output(json_build(400, null, 'Hubo error al guardar los cambios'));
            }

            // se guardó con éxito
            json_output(json_build(200, null, 'Actualizado con exito'));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_update_eliminar_pago()
    {
        //ini_set('display_errors', 1);
        //ini_set('display_startup_errors', 1);

        //error_reporting(E_ALL);
        try {
             $pagoupdate = new ComplementosModel;
            $pagoupdate->IdOrden = $_POST['ordeninvoice'];
            if (!$pagoupdate->deletepagar()) {
                json_output(json_build(400, null, 'Hubo error al eliminar los pagos'));
            }

            // se guardó con éxito
            json_output(json_build(200, null, 'Eliminado con exito'));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }


    function codi_get_ganancia()
    {
        try {

            $productos  = new productosModel;
            $productos->proMoneda = $_POST['moneda'];
            $producto = $productos->ganancia();
            json_output(json_build(200, $producto));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }


    function codi_update_producto()
    {
        /*ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);*/

        error_reporting(E_ALL);
        try {
            $usuario = new productosModel();
            $usuario->proTitulo = $_POST['edTitulo'];
            $usuario->proPreciocosto = $_POST['edPreciocosto'];
            $usuario->proPrecioventa = $_POST['edPrecioventa'];
            $usuario->precioventaoriginal = $_POST['Precioventaoriginal'];
            $usuario->proExistencia = $_POST['edExistencia'];
            $usuario->proCapacidad = $_POST['Edcapacidad'];
            $usuario->proMarca = $_POST['Edmarca'];
            $usuario->proTipoExtintor = $_POST['EdTipoExtintor'];
            $usuario->proSku = $_POST['edSku'];
            $usuario->proCatId = $_POST['edCatId'];
            //$usuario->proImagen = $_POST['proImagen'];
            $usuario->proAlmId = $_POST['edAlmacen'];
            $usuario->proId = $_POST['edid'];
            $usuario->proMax = $_POST['proMaxe'];
            $usuario->proMin = $_POST['proMine'];
            $usuario->proTipoCambio = $_POST['proTipoCambio'];
            $usuario->proMoneda = $_POST['proMoneda'];
            $usuario->proSubCategoria = $_POST['proSubCategoria'];
            $usuario->actventas = $_POST['activoventas'];
            $usuario->temporal = $_POST['temporal'];
            $usuario->online = $_POST['online'];
            $usuario->clavesat = $_POST['clavesatedi'];
            $usuario->unidadsat = $_POST['unidadsatedi'];

            $imgs = new imagenesproductoModel();
            $filas = json_decode($_POST['proImagen'], true);
            if (count($filas) > 0) {
                $usuario->proImagen = $filas[0];
            }


            if (!$usuario->update()) {
                json_output(json_build(400, null, 'Hubo error al guardar los cambios'));
            }

            foreach ($filas as $fila) {
                $imgs->IdProducto = $_POST['edid'];
                $imgs->b64 = $fila;
                $idimg = $imgs->add();
                if (!$idimg) {
                    json_output(json_build(400, null, 'Hubo un error al guardar la imagen del producto.'));
                }
            }

            $pdf = $_FILES['customFile']['name'];
            if($pdf){
                $img2 = new imagenesproductoModel();
                $img2->filename = $_FILES['customFile']['name'];
                $img2->temppath=$_FILES["customFile"]["tmp_name"];
                $img2->IdProducto = $_POST['edid'];
                $fileNameid = $img2->addpdf();
                if(!$fileNameid){
                    json_output(json_build(400, null, 'Hubo un error al guardar la ficha tecnica'));
                }
            }

            // se guardó con éxito
            json_output(json_build(200, null, 'Producto actualizado con éxito'));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function guardarfirma(){
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);
        $base64 = $_POST['img64'];
        $IdOrden = $_POST['IdOrden'];
        $Nombrerecibe = $_POST['Nombrerecibe'];
        $imgs = new imagenesproductoModel();
        $imgs->Idorden = $IdOrden;
        $imgs->b64 = $base64;
        $imgs->Nombrerecibe = $Nombrerecibe;
        $idimg = $imgs->add_firma();
        if (!$idimg) {
            json_output(json_build(400, null, 'Hubo un error al guardar la imagen de la firmaS.'));
        }

        json_output(json_build(200, null, 'Firma guardada con éxito'));
    }

    function guardar_vale_firma_estatus(){
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);
        $base64 = $_POST['img64'];
        $IdVale = $_POST['IdVale'];
        $imgs = new imagenesproductoModel();
        $imgs->IdVale = $IdVale;
        $imgs->b64 = $base64;
        $idimg = $imgs->add_firma_vale();
        if (!$idimg) {
            json_output(json_build(400, null, 'Hubo un error al guardar la imagen de la firmaS.'));
        }

        json_output(json_build(200, null, 'Firma guardada con éxito'));
    }

    function codi_asignar_producto()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);
        $edida = $_POST['edida'];
        $FolioOrden = $_POST['FolioOrden'];
        $edTituloa = $_POST['edTituloa'];
        $edSkua = $_POST['edSkua'];
        $edPreciocostoa = $_POST['edPreciocostoa'];
        $edPrecioventaa = $_POST['edPrecioventaa'];
        $edExistenciaa = $_POST['edExistenciaa'];
        $edAlmacena = $_POST['edAlmacena'];
        $edCatIda = $_POST['edCatIda'];
        $selectorden = $_POST['selectorden'];
        $IIdOrden = $_POST['IIdOrden'];
        $IIdCliente = $_POST['IIdCliente'];
        $IIdDomicilio = $_POST['IIdDomicilio'];
        $Cantidadpa = $_POST['Cantidadpa'];
        $Motivo = $_POST['Motivo']; 
        error_reporting(E_ALL);
        try {


            $asignarproducto = new productosModel();
            $asignarproducto->proSku = $edSkua;
            $asignarproducto->proId = $edida;
            $asignarproducto->folioOrden = $FolioOrden;
            $asignarproducto->proTitulo = $edTituloa;
            $asignarproducto->cantidad = $Cantidadpa;
            $asignarproducto->promotivo = $Motivo;
            if (!$asignarproducto->asginarproducto()) {
                json_output(json_build(400, null, 'Hubo error al guardar los cambios'));
            }
            $updateasignarproducto = new productosModel();
            $updateasignarproducto->proId = $edida;
            $updateasignarproducto->cantidad = $Cantidadpa;
            if(!$updateasignarproducto->update_producto_asignar()){
                json_output(json_build(400, null, 'Se asigno la cantidad de producto a la orden pero no se pudo atualizar la cantidad de stock en el producto'));
            }
            // se guardó con éxito
            json_output(json_build(200, null, 'Producto actualizado con éxito'));

        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_traspasar_producto()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);

        $usuario  = new productosModel;
        $usuario->proId = $_POST['trId'];
        $usuario->proTitulo = $_POST['trNombre'];
        $usuario->proSku = $_POST['trSku'];
        $usuario->proPreciocosto = $_POST['trPreciocosto'];
        $usuario->proPrecioventa = $_POST['trPrecioventa'];

        $usuario->proExistencia = $_POST['trExistencia'];
        $usuario->proCatId = $_POST['trCategoria'];
        $usuario->proAlmId = $_POST['trAlmId'];

        $usuario->proMarca = $_POST['trmarca'];
        $usuario->proCapacidad = $_POST['trcapacidad'];
        $usuario->proTipoExtintor = $_POST['trTipoExtintor'];

        $usuario->proImagen = $_POST['trImagen'];
        $usuario->trAlmacen = $_POST['trAlmacen'];
        $usuario->trCantidad = $_POST['trCantidad'];
        $usuario->trUsuario = $_POST['trUsuario'];
        $usuario->trPassword = $_POST['trPassword'];
        $usuario->proMoneda = $_POST['trmoneda'];
        $usuario->proTipoCambio = $_POST['trtipocambiovalor'];
        $usuario->proSubCategoria = $_POST['trSubCategoria'];
        


        try {
            if (!$usuario->traspasar()) {
                json_output(json_build(400, null, 'Hubo error al guardar los cambios'));
            }

            if ($_POST['trAlmId'] !== $_POST['trAlmacen']) {
                json_output(json_build(200, 'Producto traspasado con éxito'));
            } else {
                json_output(json_build(400, null, 'Eliga un almacen distinto al que tiene el producto seleccionado'));
            }

            // se guardó con éxito
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_delete_producto()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $usuario  = new productosModel;
            $usuario->proId = $_POST['proId'];
            $usuario->proAlmId = $_POST['proAlmId'];
            $usuario->proEstatus = $_POST['proEstatus'];

            if (!$usuario->delete()) {
                json_output(json_build(400, null, 'Hubo error al guardar los cambios'));
            }

            // se guardó con éxito
            json_output(json_build(200, null, 'Producto eliminado con éxito'));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_crear_promocion()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);
        error_reporting(E_ALL);
        try {
            $usuario  = new productosModel;
            $usuario->proId = $_POST['proIdpromo'];
            $usuario->preciopromo = $_POST['preciopromo'];
            $usuario->fechafinal = $_POST['fechafinal'];
            $usuario->fechainicial = $_POST['fechainicial'];

            if (!$usuario->codi_promocion_update()) {
                json_output(json_build(400, null, 'Hubo error al guardar los cambios'));
            }

            // se guardó con éxito
            json_output(json_build(200, null, 'Producto eliminado con éxito'));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    //Clientes

    function codi_get_clientes()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $usuario  = new clientesModel;
            $usuarios = $usuario->all();
            $data = get_module('tablaclientes', $usuarios);
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_clientes2()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $usuario  = new clientesModel;
            $usuarios = $usuario->all2();
            json_output(json_build(200, $usuarios));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }


    function codi_get_one_orden()
    {

        try {
            $usuario  = new ordenesModel;
            $usuario->IdCliente = $_POST['IdCliente'];
            $usuario->IdOrden = $_POST['IdOrden'];
             $usuario->tabla = $_POST['tabla'] ? $_POST['tabla'] : "ordenes";
            $usuarios = $usuario->one_orden();
            json_output(json_build(200, $usuarios));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_one_cliente()
    {
      
        try {
            $usuario  = new clientesModel;
            $usuario->RFC = $_POST['rfc'] ? $_POST['rfc']: "";
             $usuario->Nombre = $_POST['nombre'] ? $_POST['nombre']: "";
            $usuarios = $usuario->one_busqueda();
            json_output(json_build(200, $usuarios));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }
    
    function codi_get_buscaronline()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $usuario  = new clientesModel;
            $usuario->busqueda = $_POST['q'];
            $usuarios = $usuario->buscaronline();
            json_output(json_build(200, $usuarios));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_visitas()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $visitas  = new visitasModel;
            $visitas = $visitas->all2();
            json_output(json_build(200, $visitas));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_duplicados()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $duplicados  = new ordenesModel;
            $duplicados->TipoOrden = $_POST['CTipoOrden'];
            $duplicados->IdCliente = $_POST['IdCliente'];
            $duplicados = $duplicados->codiget_ondenes_duplicadas();
            json_output(json_build(200, $duplicados));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_cliente()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {

            if(Csrf::validate($_SESSION['token'],true)){
                $clientes  = new clientesModel;
                $clientes->IdCliente = $_POST['IdCliente'];
                $cliente = $clientes->one();
                json_output(json_build(200, $cliente));
            }else{
                json_output(json_build(201, false, 'consulta exitosa'));
            }

            
            
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_todos_dom()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {

            $clientes  = new clientesModel;
            $clientes->IdCliente = $_POST['IdCliente'];
            $cliente = $clientes->all_dom();
            json_output(json_build(200, $cliente));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_dom()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {

            $clientes  = new clientesModel;
            $clientes->IdDomicilio = $_POST['idDomicilio'];
            $cliente = $clientes->one_dom();
            json_output(json_build(200, $cliente));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_add_cliente()
    {

        try {
            $clientes = new clientesModel();
            $clientes->Nombre = $_POST['CNombre'];
            $clientes->RFC = $_POST['CRFC'];
            $clientes->FisTelefono = $_POST['CFisTelefono'];
            $clientes->FisEmail = $_POST['CFisEmail'];

            $clientes->Persona = $_POST['CRazonSocial'];
            $clientes->CFDI = $_POST['Ccfdi'];
            $clientes->RegimenFiscal = $_POST['CRegimenFiscal'];
            $clientes->TipoPago = $_POST['CTipoPago'];
            //Domicilio Fiscal
            $clientes->FisCalle = $_POST['CFisCalle'];
            $clientes->FisNExt = $_POST['CFisNExt'];
            $clientes->FisNInt = $_POST['CFisNInt'];
            $clientes->FisColonia = $_POST['CFisColonia'];
            $clientes->FisCP = $_POST['CFisCP'];
            $clientes->FisMunicipio = $_POST['CFisMunicipio'];
            $clientes->FisEstado = $_POST['CFisEstado'];
            //Domicilio Entrega
            $clientes->EntCalle = $_POST['CEntCalle'];
            $clientes->EntNExt = $_POST['CEntNExt'];
            $clientes->EntNInt = $_POST['CEntNInt'];
            $clientes->EntColonia = $_POST['CEntColonia'];
            $clientes->EntCP = $_POST['CEntCP'];
            $clientes->EntMunicipio = $_POST['CEntMunicipio'];
            $clientes->EntEstado = $_POST['CEntEstado'];
            $clientes->EntGiro = $_POST['CEntGiro'];
            $clientes->EntDesde = $_POST['CEntDesde'];
            $clientes->EntHasta = $_POST['CEntHasta'];
            $clientes->EntCruces = $_POST['CEntCruces'];
            $clientes->EntObservaciones = $_POST['CEntObservaciones'];

            $IdCliente = $clientes->add();
            if (!$IdCliente) {
                json_output(json_build(400, null, 'Hubo un error al guardar el registro'));
            } else {
                $clientes->IdCliente = $IdCliente;
                if (!$id = $clientes->add_domicilio()) {
                    json_output(json_build(400, null, 'Hubo un error al guardar el domicilio de entrega'));
                }
                $clientes->IdDomicilio = $id;
                json_output(json_build(201, $clientes->one(), 'Usuario agregado con exito'));
            }
        } catch (Exception $e) {
            throw json_output(json_build(400, null, $e->getMessage()));
        }
    }

    function codi_update_cliente()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $clientes = new clientesModel();
            $clientes->IdCliente = $_POST['ECIdCliente'];
            $clientes->Nombre = $_POST['ECNombre'];
            $clientes->RFC = $_POST['ECRFC'];
            $clientes->FisTelefono = $_POST['ECFisTelefono'];
            $clientes->FisEmail = $_POST['ECFisEmail'];

            $clientes->Persona = $_POST['ECRazonSocial'];
            $clientes->CFDI = $_POST['ECcfdi'];
            $clientes->RegimenFiscal = $_POST['ECRegimenFiscal'];
            $clientes->TipoPago = $_POST['ECTipoPago'];
            //Domicilio Fiscal
            $clientes->FisCalle = $_POST['ECFisCalle'];
            $clientes->FisNExt = $_POST['ECFisNExt'];
            $clientes->FisNInt = $_POST['ECFisNInt'];
            $clientes->FisColonia = $_POST['ECFisColonia'];
            $clientes->FisCP = $_POST['ECFisCP'];
            $clientes->FisMunicipio = $_POST['ECFisMunicipio'];
            $clientes->FisEstado = $_POST['ECFisEstado'];
            //Domicilio Entrega
            $clientes->IdDomicilio = $_POST['ECIdDomicilio'];
            $clientes->EntCalle = $_POST['ECEntCalle'];
            $clientes->EntNExt = $_POST['ECEntNExt'];
            $clientes->EntNInt = $_POST['ECEntNInt'];
            $clientes->EntColonia = $_POST['ECEntColonia'];
            $clientes->EntCP = $_POST['ECEntCP'];
            $clientes->EntMunicipio = $_POST['ECEntMunicipio'];
            $clientes->EntEstado = $_POST['ECEntEstado'];
            $clientes->EntGiro = $_POST['ECEntGiro'];
            $clientes->EntDesde = $_POST['ECEntDesde'];
            $clientes->EntHasta = $_POST['ECEntHasta'];
            $clientes->EntCruces = $_POST['ECEntCruces'];
            $clientes->EntObservaciones = $_POST['ECEntObservaciones'];
            if (!$clientes->update()) {
                json_output(json_build(400, null, 'Hubo error al guardar los cambios'));
            } else {
                if (!$clientes->update_domicilio()) {
                    json_output(json_build(400, null, 'Hubo error al guardar los cambios del domicilio'));
                }
                // se guardó con éxito
                json_output(json_build(200, $clientes->one(), 'Cliente actualizado con éxito'));
            }
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_delete_cliente()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);

        try {
            $usuario  = new clientesModel;
            $usuario->IdCliente = $_POST['idCliente'];
            $usuario->activo = $_POST['activo'];

            if (!$usuario->delete()) {
                json_output(json_build(400, null, 'Hubo error al guardar los cambios'));
            }

            // se guardó con éxito
            json_output(json_build(200, null, 'Usuario eliminado con éxito'));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }


    function codi_delete_orden()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);

        try {
            $usuario  = new ordenesModel;
            $usuario->IdOrden = $_POST['idOrden'];
            $usuario->Estatus = 6; //$_POST['activo'];

            if (!$usuario->delete()) {
                json_output(json_build(400, null, 'Hubo error al guardar los cambios'));
            }

            // se guardó con éxito
            json_output(json_build(200, null, 'Orden eliminada con éxito'));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_clientes_select()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $usuario  = new clientesModel;
            $usuarios = $usuario->all();
            $data = get_module('selectclientes', $usuarios);
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_clientes_select_keyup()
    {
        try {
            $usuario  = new clientesModel;
            $usuario->Nombre = $_POST['nombre'];
            $usuarios = $usuario->onekeyup();
            $data2 = get_module('keyupclientes', $usuarios);
            json_output(json_build(200, $data2));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_clientes_select_keyup2()
    {
        try {
            $usuario  = new clientesModel;
            $usuario->Nombre = $_POST['nombre'];
            $usuarios = $usuario->onekeyup();
            $data2 = get_module('keyupclientesvisita', $usuarios);
            json_output(json_build(200, $data2));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }


    //-------------------------------Ordenes-------------------------
    function codi_get_orden()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {

            $ordenes = new ordenesModel();
            $ordenes->IdOrden = $_POST['IdOrden'];
            $orden = $ordenes->one();
            json_output(json_build(200, $orden));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }


    function codi_get_orden_calendario()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {

            $ordenes = new ordenesModel();
            $ordenes->IdOrden = $_POST['IdOrden'];
            $orden = $ordenes->one_calendario();
            $data = get_module('selectordenescalendario', $orden);
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }
    //otro evento unico
    function codi_get_orden_calendario_unico()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {

            $ordenes = new ordenesModel();
            $ordenes->IdOrden = $_POST['IdOrden'];
            $orden = $ordenes->one_calendario();
            json_output(json_build(200, $orden));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    

    function codi_get_ordenes()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $orden  = new ordenesModel;
            $ordenes = $orden->all();
            $data = get_module('tablaordenes', $ordenes);
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_ordenesv2()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $orden  = new ordenesModel;
            $orden->departamento = $_POST['departamento'];
            $orden->filtrado = $_POST['filtartodo'];
            $ordenes = $orden->all2();
            json_output(json_build(200, $ordenes));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_ordenes_entrega_fecha()
    {
        /*ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);*/
        try {
            $orden  = new ordenesModel;
            $ordenes = $orden->all_entregadasx_fechas();
            $data = get_module('tablaordenes', $ordenes);
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_ordenes_contpaq()
    {

        if (!in_array($_POST['contpaqkey'], $this->required_llave)) {
                    json_output(json_build(403));
                }
        try {
            $orden  = new ordenesModel;
            $ordenes = $orden->all();
            json_output(json_build(200, $ordenes));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_ordenes_departamentos()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $orden  = new ordenesModel;
            $tipousu = $_SESSION['usuario']['tipousoval'];
            $orden->EstadoTransito = $tipousu;
            $ordenes = $orden->all_departamento();
            $data = get_module('tablaordenes', $ordenes);
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_cotizaciones_departamentos()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $orden  = new cotizacionesModel;
            $tipousu = $_SESSION['usuario']['tipousoval'];
            $usuarioID = 
            $orden->EstadoTransito = $tipousu;
            $orden->IdUsuario = $usuarioID;
            $ordenes = $orden->all_departamento();

            $data = get_module('tablacotizaciones', $ordenes);
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_detalleorden()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $valfuncion = $_POST['IdCompraphp'];
            $contador = $_POST['contador'];
            $contadororiginal = $_POST['contadororiginal'];
            $orden  = new ordenesModel;
            $orden->IdOrden = $_POST['IdOrden'];
            $contadorproductos = 0;
            
            if($valfuncion != 0){
                if($contador == $contadororiginal){
                  
                    $ordenes = $orden->detalle_con_compra();
                    $contadorproductos= $orden->contarproductos();
                    //echo "entre en detalle_con_compra";
                }else{
                  
                   $ordenes = $orden->detallediferente();
                   $contadorproductos= $orden->contarproductos(); 
                   //echo "entre en detallediferente";
                }
                
            }else{
                $ordenes = $orden->detalle();
                $contadorproductos= $orden->contarproductos();
                //echo "entre en detalle";
                
            }
            
            $data = get_module('tablaordendetalle', $ordenes);
            json_output(json_build(200, $data, $contadorproductos));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

function codi_get_detalleorden_factura()
    {
        //ini_set('display_errors', 1);
        //ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $valfuncion = $_POST['IdCompraphp'];
            $contador = $_POST['contador'];
            $ordenrelacionada = $_POST['ordenrelacionada'];
            $contadororiginal = $_POST['contadororiginal'];
            $orden  = new ordenesModel;
            $orden->IdOrden = $_POST['IdOrden'];
            $orden->pdfval = 1;
            $orden->suma = $_POST['suma'];
            $orden->separar = $_POST['nounir'];
            $orden->PartidaInvoce = $_POST['partidainvoice'] ? $_POST['partidainvoice'] : 1;
            $orden->ordenRelacionada = $ordenrelacionada;
            if($valfuncion != 0){
                if($contador == $contadororiginal){
                  
                    $ordenes = $orden->detalle_con_compra();
                    //echo "entre en detalle_con_compra";
                }else{
                  
                   $ordenes = $orden->detallediferente(); 
                   //echo "entre en detallediferente";
                }
                
            }else{
                $ordenes = $orden->detalle_para_invoice();
                //echo "entre en detalle";
            }
            
            $data = get_module('tablaordendetallefactura', $ordenes);
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_comision()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $usuarioId = $_POST['usuarioId'];
            $usuval = $_POST['usuval'];
            $grupo = $_POST['grupo'];
            $grupousuarios = $_POST['grupousuarios'];
            $comision = new comisionModel();
            $comision->Iduser = $usuarioId;
            $comision->grupometa = $grupo;
            $comision->gruposusu = $grupousuarios;

            if($usuval == 8){
                $comi = $comision->comisionind();
            }else if($grupo != 0){
                $comi = $comision->comision_leer_grupo();
            }else{
                $comi = $comision->comision_leer_todos();
            }
            

            $data = get_module('tablacomisiones', $comi);
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }


    function codi_get_comision_porpagar()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $usuarioId = $_POST['usuarioId'];
            $usuval = $_POST['usuval'];
            $grupo = $_POST['grupo'];
            $grupousuarios = $_POST['grupousuarios'];
            $comision = new comisionModel();
            $comision->Iduser = $usuarioId;
            $comision->grupometa = $grupo;
            $comision->gruposusu = $grupousuarios;
            if($usuval == 8){
                $comi = $comision->comisionpagar_ind();
            }else if($grupo != 0){
                $comi = $comision->comisionpagar_grupo();
            }else{
                $comi = $comision->comisionpagar();
            }
            

            $data = get_module('tablacomisiones', $comi);
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_comision_porpagardash()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $usuarioId = $_POST['usuarioId'];
            $comision = new comisionModel();
            $comision->Iduser = $usuarioId;
            $comi = $comision->comisionpagar_ind2();

            json_output(json_build(200, $comi));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_comision_porpagardash_tres()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $usuarioId = $_POST['usuarioId'];
            $comision = new comisionModel();
            $comision->Iduser = $usuarioId;
            $comi = $comision->comisionpagar_ind3();

            json_output(json_build(200, $comi));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_comision_yaaprobado()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $usuarioId = $_POST['usuarioId'];
            $fechainicio = $_POST['fechainicio'];
            $comision = new comisionModel();
            $comision->Iduser = $usuarioId;
            $comision->fechaIni = $fechainicio;
            $comi = $comision->comisionpagar_yaaprobado();

            json_output(json_build(200, $comi));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function aceptar_comision_dash()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $usuarioId = $_POST['IdUsuario'];
            $saldoapagar = $_POST['saldoapagar'];
            $comision = new comisionModel();
            $comision->Iduser = $usuarioId;
            $comision->cantidadaceptada = $saldoapagar;
            $comi = $comision->historialcomisiones();

            json_output(json_build(200, $comi));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_comision_porpagarpendientes()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $usuarioId = $_POST['usuarioId'];
            $usuval = $_POST['usuval'];
            $grupo = $_POST['grupo'];
            $grupousuarios = $_POST['grupousuarios'];
            $comision = new comisionModel();
            $comision->Iduser = $usuarioId;
            $comision->grupometa = $grupo;
            $comision->gruposusu = $grupousuarios;
            if($usuval == 8){
                $comi = $comision->comisionpagar_indpendiente();
            }else if($grupo != 0){
                $comi = $comision->comisionpagarpendiente_grupo();
            }else{
                $comi = $comision->comisionpagarpendiente();
            }
            

            $data = get_module('tablacomisiones', $comi);
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_comision_porpagar_total()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $usuarioId = $_POST['usuarioId'];
            $usuval = $_POST['usuval'];
            $grupo = $_POST['grupo'];
            $grupousuarios = $_POST['grupousuarios'];
            $comision = new comisionModel();
            $comision->Iduser = $usuarioId;
            $comision->grupometa = $grupo;
            $comision->gruposusu = $grupousuarios;

            if($usuval == 8){
                $comi = $comision->comitotalindi();
            }else if($grupo != 0){
                $comi = $comision->comitotalgrupo();
            }else{
                $comi = $comision->comitotal();
            }
            json_output(json_build(200, $comi, 'todook'));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_metas_total()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $usuarioId = $_POST['vendedor'];
            $usuval = $_POST['tipousu'];
            $fechameta = $_POST['fechameta'];
            $grupo = intval($_POST['grupo']);
            $comision = new comisionModel();
            $comision->Iduser = $usuarioId;
            $comision->fechaIni = $fechameta;
            $comision->grupometa = $grupo;
            if($usuval == 8){
                $comi = $comision->metatotalindi();
            }else if($grupo != 0){
                $comi = $comision->metatotalgrupo();
            }else{
                $comi = $comision->metatotal();
            }
            json_output(json_build(200, $comi, 'todook'));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function metas_ordenes_dinero_creado()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $usuarioId = $_POST['vendedor'];
            $usuval = $_POST['tipousu'];
            $fechameta = $_POST['fechameta'];
            $grupo = $_POST['grupo'];
            $grupousuarios = $_POST['grupousuarios'];
            $comision = new comisionModel();
            $comision->Iduser = $usuarioId;
            $comision->fechaIni = $fechameta;
            $comision->grupometa = $grupo;
            $comision->gruposusu = $grupousuarios;
            if($usuval == 8){
                $comi = $comision->metaordenesdineroindi();
            }else if($grupo != 0){
                $comi = $comision->metaordenesdinerogrupo();
            }else{
                $comi = $comision->metaordenesdinerototal();
            }
            json_output(json_build(200, $comi, 'todook'));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }


    function metas_ordenes_dinero_pagado()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $usuarioId = $_POST['vendedor'];
            $usuval = $_POST['tipousu'];
            $fechameta = $_POST['fechameta'];
            $grupo = $_POST['grupo'];
            $grupousuarios = $_POST['grupousuarios'];
            $comision = new comisionModel();
            $comision->Iduser = $usuarioId;
            $comision->fechaIni = $fechameta;
            $comision->grupometa = $grupo;
            $comision->gruposusu = $grupousuarios;
            if($usuval == 8){
                $comi = $comision->metapagadasdineroindi();
            }else if($grupo != 0){
                $comi = $comision->metapagadasdinerototalgrupo();
            }else{
                $comi = $comision->metapagadasdinerototal();
            }
            json_output(json_build(200, $comi, 'todook'));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_ordenes_total_in()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $usuarioId = $_POST['vendedor'];
            $usuval = $_POST['tipousu'];
            $fechameta = $_POST['fechameta'];
            $grupo = $_POST['grupo'];
            $grupousuarios = $_POST['grupousuarios'];
            $comision = new comisionModel();
            $comision->Iduser = $usuarioId;
            $comision->fechaIni = $fechameta;
            $comision->grupometa = $grupo;
            $comision->gruposusu = $grupousuarios;

            if($usuval == 8){
                $comi = $comision->metatotalordenesinindi();
            }else if($grupo != 0){
                $comi = $comision->metaordenesintotalgrupo();
            }else{
                $comi = $comision->metaordenesintotal();
            }
            json_output(json_build(200, $comi, 'todook'));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_ordenes_cobradas_in()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $usuarioId = $_POST['vendedor'];
            $usuval = $_POST['tipousu'];
            $fechameta = $_POST['fechameta'];
            $grupo = $_POST['grupo'];
            $grupousuarios = $_POST['grupousuarios'];
            $comision = new comisionModel();
            $comision->Iduser = $usuarioId;
            $comision->fechaIni = $fechameta;
            $comision->grupometa = $grupo;
            $comision->gruposusu = $grupousuarios;
            if($usuval == 8){
                $comi = $comision->metatotalcobradasinindi();
            }else if($grupo != 0){
                $comi = $comision->metacobradasintotalgrupo();
            }else{
                $comi = $comision->metacobradasintotal();
            }
            json_output(json_build(200, $comi, 'todook'));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    
    function codi_get_comision_pendiente_total()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $usuarioId = $_POST['usuarioId'];
            $usuval = $_POST['usuval'];
            $grupo = $_POST['grupo'];
            $grupousuarios = $_POST['grupousuarios'];
            $comision = new comisionModel();
            $comision->Iduser = $usuarioId;
            $comision->grupometa = $grupo;
            $comision->gruposusu = $grupousuarios;
            if($usuval == 8){
                $comi = $comision->comitotalpendienteindi();
            }else if($grupo != 0){
                $comi = $comision->comitotalpendientegrupo();
            }else{
                $comi = $comision->comitotalpendiente();
            }
            json_output(json_build(200, $comi, 'todook'));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }


    function codi_add_pagocomisiones()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $usuarioId = $_POST['usuarioId'];
            $usuval = $_POST['usuval'];
            $filas = $_POST['filas'];
            $comision = new comisionModel();
            $comision->Iduser = $usuarioId;

            foreach ($filas as $fila) {
                $comision->Id = $fila['id'];
                $comision->Comitotal = $fila['comisionInd'];

                if (!$comision->comipagar()) {
                json_output(json_build(400, null, 'Hubo un error al guardar el registro'));
                }
            }
            json_output(json_build(200, $comision, 'todook'));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_talleres_activos_fechas()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $taller = new ordenesModel();
            $taller->FechaInicio = $_POST['fechainiciotaller'];
            $taller->FechaTermino = $_POST['fechafintaller'];
            $taller = $taller->talleractivosfechas();

            json_output(json_build(200, $taller));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_talleres_activos()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $taller = new ordenesModel();
            $taller = $taller->talleractivos();

            json_output(json_build(200, $taller));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function cantidad_ordenes_almacen()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $almacen = new ordenesModel();
            $almacen = $almacen->cantidad_ordenes_almacen();

            json_output(json_build(200, $almacen));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_reparto_datos()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $reparto = new ordenesModel();
            $reparto->FechaInicio = $_POST['fechainiciotaller'];
            $reparto->FechaTermino = $_POST['fechafintaller'];
            $reparto = $reparto->reparto_datos();

            json_output(json_build(200, $reparto));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function desglose_reparto()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $reparto = new ordenesModel();
            $reparto->FechaInicio = $_POST['fechainiciotaller'];
            $reparto->FechaTermino = $_POST['fechafintaller'];
            $reparto = $reparto->reparto_statusreparto();

            json_output(json_build(200, $reparto));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_datos_pipc()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $pipc = new ordenesModel();
            $pipc = $pipc->pipc_traer_datos();

            json_output(json_build(200, $pipc));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_datos_capacitaciones()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $cap = new ordenesModel();
            $cap = $cap->capa_traer_datos();

            $cap2 = new ordenesModel();
            $cap2 = $cap2->capa_traer_datos_detalle();
            $data = [
            "ordenes" => $cap,
            "ordenesdetalle" => $cap2
        ];
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function cantidad_productos_sinstock()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $productos = new productosModel();
            $productos = $productos->productos_sinstock();

            json_output(json_build(200, $productos));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function cantidad_vales_almacen()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $almacen = new almacenesModel();
            $almacen = $almacen->vales_almacen();

            json_output(json_build(200, $almacen));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function cantidad_comprasporautorizar()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $compras = new comprasModel();
            $compras = $compras->compras_por_autorizar();

            json_output(json_build(200, $compras));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }


    function codi_solicitudes_activos_fechas()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $soli = new cotizacionesModel();
            $soli->FechaInicio = $_POST['fechainiciotaller'];
            $soli->FechaTermino = $_POST['fechafintaller'];
            $soli = $soli->solicitudesctivosfechas();

            json_output(json_build(200, $soli));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }


    function codi_talleres_activos_almacen()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $taller = new cotizacionesModel();
            $taller = $taller->talleractivos_almacen();

            json_output(json_build(200, $taller));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_talleres_activos_capacitaciones()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $taller = new cotizacionesModel();
            $taller = $taller->talleractivos_capacitaciones();

            json_output(json_build(200, $taller));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function solicitudes_almacen_dehoy()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $taller = new cotizacionesModel();
            $taller = $taller->almacen_talleratendidashoy();

            json_output(json_build(200, $taller));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function solicitudes_capacitaciones_dehoy()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $taller = new cotizacionesModel();
            $taller = $taller->capacitaciones_talleratendidashoy();

            json_output(json_build(200, $taller));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function taller_atendidas_mes()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $taller = new ordenesModel();
            $taller->FechaInicio = $_POST['fechainiciotaller'];
            $taller->FechaTermino = $_POST['fechafintaller'];
            $taller = $taller->talleratendidasmes();

            json_output(json_build(200, $taller));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function cantidad_atendidas_hoy()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $taller = new ordenesModel();
            $taller = $taller->talleratendidashoy();

            json_output(json_build(200, $taller));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_facturaciondinero_cobrado()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            
            $factura = new invoicesModel();
            $factura->FechaInicio = $_POST['fechaInicio'];
            $factura->FechaTermino = $_POST['fechaFinal'];
            $factura = $factura->codi_factura_dinero_cobrado();

            json_output(json_build(200, $factura));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_ordenes_cobradas()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            
            $factura = new ordenesModel();
            $factura->FechaInicio = $_POST['fechaInicio'];
            $factura->FechaTermino = $_POST['fechaFinal'];
            $factura = $factura->codi_factura_cobradas();

            json_output(json_build(200, $factura));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_facturaciondinero_sincobrar()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            
            $factura = new invoicesModel();
            $factura->FechaInicio = $_POST['fechaInicio'];
            $factura->FechaTermino = $_POST['fechaFinal'];
            $factura = $factura->codi_factura_dinero_sincobrar();

            json_output(json_build(200, $factura));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_ordenes_pendientes_x_cobrar()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            
            $factura = new ordenesModel();
            $factura->FechaInicio = $_POST['fechaInicio'];
            $factura->FechaTermino = $_POST['fechaFinal'];
            $factura = $factura->codi_factura_x_cobrar();

            json_output(json_build(200, $factura));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function cantidad_disperas()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $taller = new ordenesModel();
            $taller = $taller->cantidades_disperas();

            json_output(json_build(200, $taller));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }


    function codi_get_status(){
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $orden  = new ordenesModel;
            $ordenes = $orden->estatus();
            json_output(json_build(200, $ordenes));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_ordenes_ventas_individual(){
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        $usuario = $_POST["IdUsuario"];
        try {
            $orden  = new ordenesModel;
            $orden->sentencia = "SELECT
    o.IdOrden,
    od1.Partida                  AS PartidaProducto,          -- solo la Partida 1
    od1.IdProducto,
    od1.DescripcionNueva         AS ProductoDescripcion,
    p.proImagen                  AS ProductoImagen,           -- imagen desde productos
    e.Descripcion                AS Estatus,                  -- nombre del estatus
    d.DeptoDescripcion           AS EstadoTransito,           -- nombre del departamento
    o.PagadoCompleto,
    COALESCE(tot.TotalOrden, 0)  AS TotalOrden,               -- suma de Neto (sin Eliminado=1)

    /* === Total de ENTREGADAS (solo estatus 24 y 14 del MES EN CURSO) para este usuario === */
    (
      SELECT COUNT(*)
      FROM ordenes o2
      WHERE o2.IdUsuario = o.IdUsuario
        AND o2.Estatus IN (24, 14)
        AND o2.Fecha >= DATE_FORMAT(CURDATE(), '%Y-%m-01')
        AND o2.Fecha <  DATE_FORMAT(CURDATE() + INTERVAL 1 MONTH, '%Y-%m-01')
    ) AS TotalEntregadasMes

FROM ordenes o
INNER JOIN estatus e
    ON e.IdEstatus = o.Estatus
INNER JOIN departamentos d
    ON d.IdDepto = o.EstadoTransito
LEFT JOIN (
    SELECT od.IdOrden, SUM(od.Neto) AS TotalOrden
    FROM ordenesdetalle od
    WHERE od.Eliminado = 0
    GROUP BY od.IdOrden
) tot
    ON tot.IdOrden = o.IdOrden
LEFT JOIN ordenesdetalle od1
    ON od1.IdOrden = o.IdOrden
   AND od1.Eliminado = 0
   AND CAST(od1.Partida AS UNSIGNED) = 1                  -- fija solo Partida 1
LEFT JOIN productos p
    ON p.proId = od1.IdProducto                           -- relación con productos
WHERE o.IdUsuario = $usuario                               -- recibido por POST
  AND o.Estatus NOT IN (27, 29, 5, 6)                      -- excluir estatus solicitados
ORDER BY o.IdOrden DESC;
";
            $ordenes = $orden->codi_get_ordenes_ventas_individual();
            json_output(json_build(200, $ordenes));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_estado_transito(){
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $orden  = new ordenesModel;
            $ordenes = $orden->departamentos();
            json_output(json_build(200, $ordenes));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_ordenes_select()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $orden  = new ordenesModel;
            $ordenes = $orden->all();
            $data = get_module('selectordenes', $ordenes);
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_ordenesfolio_select()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $orden  = new ordenesModel;
            $ordenes = $orden->all();
            $data = get_module('selectordenesfolio', $ordenes);
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function generarCodigo($longitud) {
    $caracteres = array("0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z");
    $codigo = '';

    for ($i = 1; $i <= $longitud; $i++) {
        $codigo .= $caracteres[$this->numero_aleatorio(0, 35)];
    }

        return $codigo;
    }

    function numero_aleatorio ($ninicial, $nfinal) {
        $numero = rand($ninicial, $nfinal);

        return $numero;
    } 

    function codi_add_orden()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);
        error_reporting(E_ERROR);
        if(Csrf::validate($_SESSION['token'],true)){
            $valtoken = Csrf::validate($_SESSION['token'],true);
            //var_dump($valtoken);
        }else{
            $valtoken = Csrf::validate($_SESSION['token'],true);
            //var_dump($valtoken);
            Redirect::to('auths/logout');
        }
        try {
            $hist = new historialOrdenModel();
            $usu = new usuariosModel();
            $notifi = new notificacionesModel();
            $email = new emailModel();
            $clientes = new clientesModel();
            $extintores = new extintoresModel();
            $calendario = new calendarioModel();

            $tipo = $_POST['ctipo'];
            $llaveuno = $_POST['llaveuno'];
            $llavelarga = $_POST['llavelarga'];
            $CtipoPago = isset($_POST['CTipoPago']) ? $_POST['CTipoPago'] : null;
            $cfdi = isset($_POST['cfdi']) ? $_POST['cfdi'] : null;
            $regimenfiscal = isset($_POST['regimenfiscal']) ? $_POST['regimenfiscal'] : null;
            $CTipoOrden = isset($_POST['CTipoOrden']) ? $_POST['CTipoOrden'] : null;
            $CTipoServicio = isset($_POST['CTipoServicio']) ? $_POST['CTipoServicio'] : null;
            $CFisNInt = isset($_POST['CFisNInt']) ? $_POST['CFisNInt'] : 0;
            $CEntNInt = isset($_POST['CEntNInt']) ? $_POST['CEntNInt'] : 0;
            $comagentetotal = isset($_POST['comagentetotal']) ? $_POST['comagentetotal'] : 0;
            $comagenteind = isset($_POST['comagenteind']) ? $_POST['comagenteind'] : 0;
            $EstadoTransito = $_SESSION['usuario']['tipousoval'];
            $descuentototalFinal = isset($_POST['descuentototalFinal']) ? $_POST['descuentototalFinal'] : null;
            $duplicadoorden = isset($_POST['duplicadoorden']) ? $_POST['duplicadoorden'] : 0;
            $contadorjson = isset($_POST['contadorjson']) ? $_POST['contadorjson'] : 0;
            $porcentajejson = isset($_POST['porcentajejson']) ? $_POST['porcentajejson'] : 0;
            $movconvertida = $_POST['modconvertida'];
            $subcategoID = $_POST['subcategoID'];
            $usuarioCreado = $_SESSION['usuario']['idusu'];
            $usuariodep = $_SESSION['usuario']['tipousoval'];
            $alimentosli = isset($_POST['alimentosli']) ? $_POST['alimentosli'] : 0;
            $transporteli = isset($_POST['transporteli']) ? $_POST['transporteli'] : 0;
            $dc3li = isset($_POST['dc3li']) ? $_POST['dc3li'] : 0;
            $textocursos = isset($_POST['textocursos']) ? $_POST['textocursos'] : "";
            $folioconvertir = $_POST['folioconvertir'] ? $_POST['folioconvertir'] : 0;
            $fechacheked = $_POST['fechacheked'] ? $_POST['fechacheked'] : 0;
            $nounir = $_POST['nounir'] ? $_POST['nounir'] : 0;
            $cambdireccioncot = $_POST['cambdireccioncot'] ? $_POST['cambdireccioncot'] : 0;
            
            if ($tipo == "orden") {
                $val = 1;
                $ordenes = new ordenesModel();
                $ordenes->FolioOrden = $ordenes->folio(8);
                if ($CTipoOrden == 2) {
                    $EstadoTransito = 25;
                }else if($CTipoOrden == 1) {
                    $EstadoTransito = 12;
                }else if($CTipoOrden == 3){
                    $EstadoTransito = 19;
                }else if($CTipoOrden == 6){
                    $EstadoTransito = 19;
                }else if($CTipoOrden == 7){
                    $EstadoTransito = 15;
                }
                $ordenes->duplicadoorden = $duplicadoorden;
                $ordenes->contadorjson = $contadorjson;
                $ordenes->porcentajejson = $porcentajejson;
                $ordenes->alimentosli = $alimentosli;
                $ordenes->transporteli = $transporteli;
                $ordenes->dc3li = $dc3li;
                $ordenes->textocursos = $textocursos;
                $ordenes->IdCotizacion = $folioconvertir;

                $ordenes->Domprogramaintero = $_POST['domprogramaintero'];
                $ordenes->Percontacto = $_POST['percontacto'];
                $ordenes->Telecontacto = $_POST['Telecontacto'];
                $ordenes->Mailcontacto = $_POST['mailcontacto'];


            } else {
                $val = 2;
                $ordenes = new cotizacionesModel();
                $ordenes->alimentosli = $alimentosli;
                $ordenes->transporteli = $transporteli;
                $ordenes->dc3li = $dc3li;
                $ordenes->textocursos = $textocursos;
                $ordenes->FolioCotizacion = $ordenes->folio(8);
            }

            $ordenes->movconvertida = $movconvertida;

            $ordenes->TipoOrden = $CTipoOrden;
            if ($CTipoServicio == "") {
                $ordenes->TipoServicio = 0;
            } else {
                $ordenes->TipoServicio = $CTipoServicio;
            }
            $ordenes->IdCliente = $_POST['CIdCliente'];
            $ordenes->IdDomicilio = $_POST['CIdDomicilio'];
            $ordenes->Fecha = date('Y-m-d h:m:s');
            $ordenes->Tipo = $_POST['CTipo'];
            $ordenes->Descripcion = $_POST['CDescripcion'];
            $ordenes->TipoPago = $CtipoPago;
            $ordenes->Descuento = $descuentototalFinal;
            $ordenes->IdUsuario = $usuarioCreado;
            $ordenes->MaxDescuento = $_POST['valdescuento'];
            $llave = $this->generarCodigo(12);
            $ordenes->llaveOrden = $llave;
            $ordenes->comagentetotal = $comagentetotal;
            $MaxDescuento = $_POST['valdescuento'];

            $filas = json_decode($_POST['productos'], true);
            if (count($filas) < 1) {
                throw json_output(json_build(400, null, "Por favor seleccione un producto."));
            }

            $descuentofor = 0;
            $estatus = 1;
            foreach ($filas as $filadesc) {
                $filadescuento = $filadesc['descuento'];
                if($filadescuento>30){
                    $EstadoTransito = 25;
                    $descuentofor = $filadescuento;
                    $estatus = 7;
                }
            }

            if($usuariodep == 9){
                $EstadoTransito = 9;
            }

            if($usuariodep == 12){
                $EstadoTransito = 3;
            }

            if($usuariodep == 2){
                $EstadoTransito = 3;
            }

            $ordenes->EstadoTransito = $EstadoTransito;
            $ordenes->Estatus = $estatus;
            //Clientes
            $clientes->IdCliente = $_POST['CIdCliente'];
            $clientes->Nombre = $_POST['CNombre'];
            $clientes->RFC = $_POST['CRFC'];
            $clientes->Persona = $_POST['razonsocial'];
            $clientes->CFDI = $cfdi;
            $clientes->RegimenFiscal = $regimenfiscal;
            $clientes->TipoPago = $CtipoPago;
            //Domicilio Fiscal
            $clientes->FisTelefono = $_POST['CFisTelefono'];
            $clientes->FisEmail = $_POST['CFisEmail'];
            $clientes->FisCalle = $_POST['CFisCalle'];
            $clientes->FisNExt = $_POST['CFisNExt'];
            $clientes->FisNInt = $CFisNInt;
            $clientes->FisColonia = $_POST['CFisColonia'];
            $clientes->FisCP = $_POST['CFisCP'];
            $clientes->FisMunicipio = $_POST['CFisMunicipio'];
            $clientes->FisEstado = $_POST['CFisEstado'];
            //Domicilio Entrega
            $valparanuevocliente = $_POST['numeroparanuevo'];
            $clientes->IdDomicilio = $_POST['CIdDomicilio'];
            $clientes->EntCalle = $_POST['CEntCalle'];
            $clientes->EntNExt = $_POST['CEntNExt'];
            $clientes->EntNInt = $CEntNInt;
            $clientes->EntColonia = $_POST['CEntColonia'];
            $clientes->EntCP = $_POST['CEntCP'];
            $clientes->EntMunicipio = $_POST['CEntMunicipio'];
            $clientes->EntEstado = $_POST['CEntEstado'];
            $clientes->EntGiro = $_POST['CEntGiro'];
            $clientes->EntDesde = $_POST['CEntDesde'];
            $clientes->EntHasta = $_POST['CEntHasta'];
            $clientes->EntCruces = $_POST['CEntCruces'];
            $clientes->EntObservaciones = $_POST['CEntObservaciones'];
            $clientes->numdomicilio = $_POST['contardomi'];
 
            if ($_POST['CIdCliente'] != "") {
                //Editar Cliente
                if($valparanuevocliente == 0){
                    $clientes->update();
                }
                
            } else {
                //Agregar Cliente
                $IdClte = $clientes->add();
                $clientes->IdCliente = $IdClte;
                $ordenes->IdCliente = $IdClte;
            }

            if ($_POST['CIdDomicilio'] != "") {
                //Editar domicilio del Cliente
                if($valparanuevocliente == 0){
                    $clientes->update_domicilio();
                }else{
                   $iddom = $clientes->add_domicilio();
                    $ordenes->IdDomicilio = $iddom; 
                }
                
            } else {
                //Agregar domicilio del Cliente
                $iddom = $clientes->add_domicilio();
                $ordenes->IdDomicilio = $iddom;
            }

            if($llaveuno == 1 AND $llavelarga != ''){
             
                $ordenes->autorizacionOrden = $llaveuno;
                $ordenes->llaveOrdenAutorizacion = $llavelarga;
                $ordenes->Estatus = 20;
            }else{

                $ordenes->autorizacionOrden = 0;
                $ordenes->llaveOrdenAutorizacion = "";
            }
            $ordenes->separar = $nounir;
            //Función para añadir la orden o la cotización
            $IdOrden = $ordenes->add();
            
            //No se creó la orden
            if (!$IdOrden) {
                json_output(json_build(400, null, 'Hubo un error al guardar el registro'));
            } else {
                //Se creó la orden

                $ordenes->IdOrden = $IdOrden;
                $one = $ordenes->one();
                if ($tipo == "orden") {
                    $ordenes->FolioOrden = $one['FolioOrden'];
                    $extintores->FolioOrden = $one['FolioOrden'];

                    //Historial de la orden
                    $hist->IdDepartamento = $EstadoTransito;
                    $hist->FolioOrden = $IdOrden;
                    $hist->IdUsuario =  
                    $hist->Fecha = date('Y-m-d');
                    $hist->Hora = date('h:m:s');
                    $hist->Nota = "Creación de la orden.";
                    $noti = $hist->add();
                    if (!$noti) {
                        json_output(json_build(400, null, 'Hubo un error al guardar el historial de la orden'));
                    }
                } else {
                    $ordenes->FolioCotizacion = $one['FolioCotizacion'];
                }
				$mandaralerta = 0;
                //Agregar detalles y extintores
                foreach ($filas as $fila) {
                    //Extintor
                    $claveExtin = "0";
                    if ($fila['extintor'] != "") {
                        $extintor = json_decode($fila['extintor'], true);
                        $claveExtin =  $extintor['claveselect'];
                        $FechaEntrega = $extintor['fechaentrega'];
                        $Vencimiento = $extintor['fechagarantia'];

                        if ($claveExtin == "") {
                            $claveExtin = 0;
                        }
                        if ($FechaEntrega == "") {
                            $FechaEntrega = '0000-00-00';
                        }
                        if ($Vencimiento == "") {
                            $Vencimiento =  '0000-00-00';
                        }

                        $extintores->ClaveExtintor = $claveExtin;
                        $extintores->IdProducto = $extintor['clave'];
                        $extintores->Marca = $extintor['prodmarca'];
                        $extintores->Capacidad = $extintor['prodcapacidad'];
                        $extintores->TipoExtintor = $extintor['prodtipoextintor'];
                        $extintores->Agentes = json_encode($extintor['agentes']);
                        $extintores->Ubicacion = $extintor['ubicacion'];
                        $extintores->IdCliente = $extintor['cliente'];
                        $extintores->FechaEntrega = $FechaEntrega;
                        $extintores->Vencimiento = $Vencimiento;
                        $extintores->Estatus = 2;

                        if (!$id = $extintores->add()) {
                            json_output(json_build(400, null, 'Hubo un error al guardar el extintor'));
                        }
                    }

                    //Detalle
                    $cantidad = $fila['cantidad'];
                    if ($cantidad == null || $cantidad == "" || $cantidad == 0) {
                        $cantidad = 1;
                    }
                    $ordenes->Partida = $fila['partida'];
                    $ordenes->IdProducto = $fila['id'];
                    $ordenes->Cantidad = $cantidad;
                    $ordenes->PrecioVenta = $fila['precio'];
                    $ordenes->Entregados = 0;
                    $ordenes->ClaveExtintor = $claveExtin;
                    $ordenes->DescuentoDetalle = $fila['descuento'];
                    $ordenes->DescPesos = $fila['descuentopesos'];
                    $ordenes->Neto = $fila['neto'];
                    $ordenes->comagenteind = $fila['comagenteind'];
                    $ordenes->compracreada = 0;
                    $ordenes->eliminado = 0;
                    $ordenes->datetentativo = $fila['datetentativo'];
                    $ordenes->descripciondetalle = $fila['descripcion'];
                    $ordenes->tipoordendetalle = $fila['tipo_orden'];
                    $agendaCap = 0;
                    if($CTipoOrden == 3 ){
                    if($fechacheked == 1){
                        if($folioconvertir > 1){
                            $calendario->IdOrden = $IdOrden;
                            $calendario->IdCotizaciones = $folioconvertir;
                            $calendario->eventPartida = $fila['partida'];
                            $calendario->datetentativo = $fila['datetentativo'];
                            if (!$cal = $calendario->update_en_orden()) {
                                $agendaCap = 0;
                                $ordenes->agendaCap = $agendaCap;
                            json_output(json_build(400, null, 'Hubo un error al guardar el detalle de la orden'));
                             }else{
                                $agendaCap = 1;
                                $ordenes->agendaCap = $agendaCap;
                             }
                        }
                    }
                    
                }

                    if (!$id = $ordenes->add_detalle()) {
                        json_output(json_build(400, null, 'Hubo un error al guardar el detalle de la orden'));
                    }

                    // dentro de orden detalle validar para crear la compra
					
						$mandaralerta = 0;
                }

                if ($val == 1 &&  $mandaralerta == 1) {
                    //No eviar correo y cambiar el texto de la notificación
                    //Enviar notificación
                    $notifi->Tipo = 3;
                    $notifi->Descripcion = "Se creó una orden pendiente de autorización. Orden: " . $IdOrden . ".";
                    $notifi->Folio = $IdOrden;
                    $notifi->Usuario = $EstadoTransito;
                    $notifi->Departamento = $EstadoTransito;
                    $notifi->add();
                } else {
                    //Enviar notificación
                    $notifi->Tipo = $val;
                    $notifi->Descripcion = "Se creó la " . $tipo . " número " . $IdOrden . ".";
                    $notifi->Folio = $IdOrden;
                    $notifi->Usuario = $EstadoTransito;
                    $notifi->Departamento = $EstadoTransito;
                    $notifi->add();

                if($descuentofor<=30 && $movconvertida == 0){
                    //Enviar correo
                        $email->subcategoID = $subcategoID;
                        $email->CTipoOrden = $CTipoOrden;
                        $email->llavelarga = $llavelarga;
                        $email->llaveuno = $llaveuno;
                        $email->folio = $IdOrden;
                        $email->correoe = $_SESSION['usuario']['correo'];
                        $email->llaveorden = 00000000000;
                        $email->tipo = $_POST['ctipo'];
                        $email->movconvertida = $movconvertida;
                        $email->enviarcorreo();
                    
                 }
                    
                }
       
                if($descuentofor<=30 && $movconvertida == 0 ){
                   //Enviar correo al cliente
                    $email->subcategoID = $subcategoID;
                    $email->CTipoOrden = $CTipoOrden;
                    $email->llavelarga = $llavelarga;
                    $email->llaveuno = $llaveuno;
                    $email->folio = $IdOrden;
                    $email->correoe = $usuariodep == 19 ? $_SESSION['usuario']['correo'] : $_POST['CFisEmail'];
                    $email->tipo = $_POST['ctipo'];
                    $email->llaveorden = $llave;
                    $email->movconvertida = $movconvertida;
                    $email->enviarcorreo(); 
                }else{
                    $email = new emailModel();
                    $email->subcategoID = $subcategoID;
                    $email->CTipoOrden = $CTipoOrden;
                        $email->llavelarga = "";
                        $email->llaveuno = 0;
                        $email->folio = $IdOrden;
                        $email->correoe = $usuariodep == 19 ? $_SESSION['usuario']['correo'] : $_POST['CFisEmail'];
                        $email->tipo = "orden";
                        $email->movconvertida = $movconvertida;
                        $email->llaveorden = $llave;
                        $email->enviarcorreo(); 
                }
				
				
                json_output(json_build(201, $one, 'La ' . $tipo . ' fue agregada con exito'));
            }
        } catch (Exception $e) {
            throw json_output(json_build(400, null, $e->getMessage()));
        }
    }

    function codi_fact_correo(){
        $email = new emailModel();
        $email->correoe = $_SESSION['usuario']['correo'];
        $email->pdf64 =  $_POST['pdf64'];
        $email->xml64 = $_POST['xml64'];
        $email->rfcdocpago = $_POST['rfcdocpago'];
        $email->folio = $_POST['IdOrden'];
        $email->Nombre = $_POST['Nombre'];
        $email->correocliente = $_POST['correocliente'];
        $email->correovendedor = $_POST['correovendedor'];
        $email->telfact = $_POST['telfact'];
        $email->nombrevendedor = $_POST['nombrevendedor'];
        $comple = $_POST['comple'];
        $email->comentarioscorreo = $_POST['comentarioscorreo'];
        
        $email->enviarcorreofactura();

        json_output(json_build(201, $email, "Correo enviado correctamente fue agregada con exito"));
    }

    function codi_transformar_orden()
    {
        //ini_set('display_errors', 1);
        //ini_set('display_startup_errors', 1);
        /*
    error_reporting(E_ERROR);
    try {
      $usu = new usuariosModel();
      $notifi = new notificacionesModel();
      $email = new emailModel();

      $ordenes = new ordenesModel();
      $ordenes->FolioOrden = $ordenes->folio(8);
      $ordenes->IdCliente = $_POST['IdCliente'];
      $ordenes->IdDomicilio = $_POST['IdDomicilio'];
      $ordenes->Fecha = date("Y-m-d");
      $ordenes->Tipo = $_POST['Tipo'];
      $ordenes->Descripcion = $_POST['Descripcion'];
      $ordenes->TipoPago = $_POST['TipoPago'];
      $ordenes->Descuento = $_POST['Descuento'];

      $filas = json_decode($_POST['productos'], true);
      if (count($filas) < 1) {
        throw json_output(json_build(400, null, "Por favor seleccione un producto."));
      }

      $IdOrden = $ordenes->add();
      if (!$IdOrden) {
        json_output(json_build(400, null, 'Hubo un error al guardar el registro'));
      } else {
        //Este apartado copia el detalle de la cotización
        $ordenes->IdOrden = $IdOrden;
        $one = $ordenes->one();
        $ordenes->FolioOrden = $one['FolioOrden'];

        foreach ($filas as $fila) {
          $cantidad = $fila['cantidad'];
          if ($cantidad == null || $cantidad == "" || $cantidad == 0) {
            $cantidad = 1;
          }
          $ordenes->Partida = $fila['partida'];
          $ordenes->IdProducto = $fila['id'];
          $ordenes->Cantidad = $cantidad;
          $ordenes->PrecioVenta = $fila['precio'];

          if (!$id = $ordenes->add_detalle()) {
            json_output(json_build(400, null, 'Hubo un error al guardar el detalle de la orden'));
          }
        }

        //Este apartado cera una notificación
        $notifi->Tipo = 1;
        $notifi->Descripcion = "Se creó la orden número " . $IdOrden . ".";
        $notifi->Folio = $IdOrden;
        $notifi->Usuario = 1;
        $notifi->add();

        //Este apartado envía correos
        $correos = $usu->correos();
        foreach (to_object($correos) as $correo) {
          $email->folio = $IdOrden;
          $email->correoe = $correo->Correo;
          $email->enviarcorreo();
        }

        //Respuesta de que se creó la orden
        json_output(json_build(201, $one, 'La orden fue agregada con exito'));
      }
    } catch (Exception $e) {
      throw json_output(json_build(400, null, $e->getMessage()));
    }
    */
    }

    function codi_add_detalleorden()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        try {
            $ordenes = new ordenesModel();
            $ordenes->IdOrden = $_POST['IdOrden'];
            $ordenes->FolioOrden = $_POST['FolioOrden'];
            $ordenes->Partida = $_POST['Partida'];
            $ordenes->IdProducto = $_POST['IdProducto'];
            $ordenes->Cantidad = $_POST['Cantidad'];
            $ordenes->PrecioVenta = $_POST['PrecioVenta'];
            $ordenes->Entregados = 0;
			$ordenes->DescuentoDetalle = 0;
			$ordenes->DescPesos = 0;
			$ordenes->Neto = $_POST['PrecioVenta'] * $_POST['Cantidad'];
            $ordenes->comagenteind = 0;
            $ordenes->eliminado = 0;
            if ($_POST['IdProducto'] == "") {
                throw json_output(json_build(400, null, "Por favor seleccione un producto."));
            }

            if (!$detalle = $ordenes->add_detalle()) {
                json_output(json_build(400, null, 'Hubo un error al guardar el detalle de la orden'));
            }
            json_output(json_build(201, $detalle, 'Orden agregada con exito'));
        } catch (Exception $e) {
            throw json_output(json_build(400, null, $e->getMessage()));
        }
    }


    function codi_crear_visita()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        try {
            $visitas = new visitasModel();
            $visitas->tipovisita = $_POST['tipovisita'];
            $visitas->motivovisita = $_POST['motivovisita'];
            $visitas->cliente = $_POST['cliente'];
            $visitas->nombrecontacto = $_POST['nombrecontacto'];
            $visitas->telcontacto = $_POST['telcontacto'];
            $fecha = strtotime($_POST['fechapicker']);
            $visitas->fechapicker = date("Y-m-d",$fecha);
            $visitas->horapicker = $_POST['horapicker'];
            $visitas->descripcion = $_POST['descripcion'];
            $visitas->idcliente = $_POST['idcliente'];
            $visitas->domicilio = $_POST['domicilio'];
            $visitas->usuid = $_POST['usuid'];
    

            if (!$detalle = $visitas->add()) {
                json_output(json_build(400, null, 'Hubo un error al guardar la visita'));
            }
            json_output(json_build(201, $detalle, 'Visita agregada con exito'));
        } catch (Exception $e) {
            throw json_output(json_build(400, null, $e->getMessage()));
        }
    }


    function codi_buscar_visita()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        try {
            $visitas = new visitasModel();
            $visitas->idcliente = $_POST['idcliente'];
    
            if (!$detalle = $visitas->buscarone()) {
                json_output(json_build(200, null, 'No pudimos generar la busqueda'));
            }
            json_output(json_build(201, $detalle, 'Visita encontrada con exito'));
        } catch (Exception $e) {
            throw json_output(json_build(400, null, $e->getMessage()));
        }
    }

    function codi_actualizar_visita()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        try {
            $visitas = new visitasModel();
            $visitas->idvisita = $_POST['idvisita'];
            $visitas->motivovisita = $_POST['motivovisita'];
            $visitas->nombrecontacto = $_POST['nombrecontacto'];
            $visitas->cliente = $_POST['cliente'];
            $visitas->telcontacto = $_POST['telcontacto'];
            $visitas->fechapicker = $_POST['fechapicker'];
            $visitas->horapicker = $_POST['horapicker'];
            $visitas->descripcion = $_POST['descripcion'];
            $visitas->domicilio = $_POST['domicilio'];
    
            if (!$detalle = $visitas->updatevisita()) {
                json_output(json_build(200, null, 'No pudimos actualizar la visita'));
            }
            json_output(json_build(201, $detalle, 'Visita encontrada y actualizada'));
        } catch (Exception $e) {
            throw json_output(json_build(400, null, $e->getMessage()));
        }
    }

    function suma_de_productos_invoice()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        try {
            $sumainvoice = new invoicesModel();
            $sumainvoice->IdInvoice = $_POST['IdInvoice'];
            $sumainvoice->suma = $_POST['suma'];
    
            if (!$detalle = $sumainvoice->update_invoice_productos()) {
                json_output(json_build(200, null, 'No pudimos actualizar la visita'));
            }
            json_output(json_build(201, $detalle, 'Visita encontrada y actualizada'));
        } catch (Exception $e) {
            throw json_output(json_build(400, null, $e->getMessage()));
        }
    }

    
    function codi_fragmentar_detalleorden()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        try {
            $ordenes = new ordenesModel();
            $ordenes->IdDetalle = $_POST['IdOrden'];
            $ordenes->PartidaInvoce = $_POST['PartidaInvoce'];
            $ordenes->IdProducto = $_POST['IdProducto'];

            if (!$detalle = $ordenes->desfragmentar_detalleorden()) {
                json_output(json_build(400, null, 'Hubo un error al guardar el detalle de la orden'));
            }
            json_output(json_build(200, $detalle, 'Orden agregada con exito'));
        } catch (Exception $e) {
            throw json_output(json_build(400, null, $e->getMessage()));
        }
    }

    function codi_fragmentar_detalleorden_cincuenta()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        try {
            $ordenes = new ordenesModel();
            $ordenes->IdDetalle = $_POST['IdOrden'];
            $ordenes->PrecioVenta = $_POST['precioamitad'];
            $ordenes->IdProducto = $_POST['IdProducto'];

            if (!$detalle = $ordenes->desfragmentar_detalleorden_cincuenta()) {
                json_output(json_build(400, null, 'Hubo un error al guardar el detalle de la orden'));
            }
            json_output(json_build(200, $detalle, 'Orden agregada con exito'));
        } catch (Exception $e) {
            throw json_output(json_build(400, null, $e->getMessage()));
        }
    }

    function codi_update_baja_danado()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        try {

            $productos  = new productosModel;
            $productos->proId = $_POST['idproductoorden'];
            $productos->proTitulo = $_POST['trNombre']; 
            $productos->proSku = $_POST['trSku'];
            $productos->proPreciocosto = $_POST['trPreciocosto'];
            $productos->proPrecioventa = $_POST['trPrecioventa'];

            $productos->proExistencia = $_POST['trExistencia'];
            $productos->proCatId = $_POST['trCategoria'];
            $productos->proAlmId = $_POST['trAlmId']; // Actual

            $productos->proImagen = $_POST['trImagen'];
            $productos->trAlmacen = $_POST['trAlmacen']; // A donde va
            $productos->trCantidad = $_POST['cantidadeliminar'];
            $productos->trUsuario = $_POST['trUsuario'];
            $productos->trPassword = $_POST['trPassword'];
            $productos->proSubCategoria = $_POST['trSubCategoria'];
            $productos->proMoneda = $_POST['proMoneda'];
         $productos->proTipoCambio = "";
            $productos->proMarca = "";
            $productos->proCapacidad = "";
            $productos->proTipoExtintor = "";
            if (!$productos = $productos->traspasar()) {
                json_output(json_build(400, null, $productos));
            }   

            $ordenes = new ordenesModel();
            $ordenes->Descripcion = $_POST['bobservacion'];
            $ordenes->Motivo = $_POST['bmotivo'];
            $ordenes->Partida = $_POST['partida'];
            $ordenes->IdOrden = $_POST['idordeno'];
            $ordenes->FolioOrden = $_POST['folioorden'];
            $ordenes->IdProducto = $_POST['idproductoorden'];
            $ordenes->Cantidad = $_POST['cantidado'];
            $ordenes->CantidadEliminar = $_POST['cantidadeliminar'];

            if (!$baja = $ordenes->historalBaja()) {
                json_output(json_build(400, null, 'Hubo un error al guardar el historial de la baja'));
            }

            json_output(json_build(201, $baja, 'Baja realizada  con exito'));
        } catch (Exception $e) {
            throw json_output(json_build(400, null, $e->getMessage()));
        }
    }

    function codi_update_orden()
    {
        /*ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);*/
        try {
            $hist = new historialOrdenModel();
            $usu = new usuariosModel();
            $orden  = new ordenesModel;
            $notifi = new notificacionesModel();
            $email = new emailModel();
            $productos = new productosModel();
            $movimientos = new cajaModel(); 
            $EstatusOriginal = $_POST['EstatusOriginal'];
            $Estatus = $_POST['estatus'];
            $orden->Estatus = $_POST['estatus'];
            $orden->Descripcion = $_POST['Descripcion'];
            $orden->EstadoTransito = $_POST['transito'];
            $orden->IdOrden = $_POST['idorden'];
            $orden->FolioOrden = $_POST['folioorden'];
            $orden->TipoOrden = $_POST['tipo_orden'];
            $valentregados = $_POST['valentregados'] ? $_POST['valentregados'] : 0;
            $tipousuval = $_SESSION['usuario']['tipousoval'];
            $estatusval = $_POST['estatus'];
            $orden->pagocompleto = $_POST['pagadoono'];
            $orden->TipoPago = $_POST['tpago'];
            $movimientos->Idusuariomoviemientos = 1;
            $movimientos->Estatus = $_POST['estatus'];;
            $movimientos->Tipopago = $_POST['tpago'];

             if($tipousuval == 9 AND $estatusval == 11){
                $orden->pagocompleto = $_POST['estatus'];
             }else if( $tipousuval == 9 AND $estatusval == 12){
                $orden->pagocompleto = $_POST['estatus'];
             }else if($tipousuval == 9 AND $estatusval == 25){
                $orden->pagocompleto = $_POST['estatus'];
             }else if($tipousuval == 9 AND $estatusval == 2){
                $orden->pagocompleto = $_POST['estatus'];
             }

            if ($_POST['tipo_servicio'] == "") {    
                $orden->TipoServicio = 0;
            } else {
                $orden->TipoServicio = $_POST['tipo_servicio'];
            }

            $filas = json_decode($_POST['productos'], true);

            if (count($filas) < 1) {
                throw json_output(json_build(400, null, "Por favor seleccione un producto."));
            }

            $IdOrden = $orden->update();
            if (!$IdOrden) {
                json_output(json_build(400, null, 'Hubo error al guardar los cambios'));
            } else {

                //Historial de la orden
                $hist->IdDepartamento = $_POST['transito'];
                $hist->FolioOrden = $_POST['folioorden'];
                $hist->IdUsuario =  
                $hist->Fecha = date('Y-m-d');
                $hist->Hora = date('h:m:s');
                $hist->Nota = $_POST['Descripcion'];
                $noti = $hist->add();
                //Cuando estaba en espera de autorización pero se cambió a autorizada, 
                //se crea la notificación y se envía el correo
                if ($EstatusOriginal == 7 && $Estatus == 8) {
                    //Enviar notificación
                    $notifi->Departamento = $_POST['transito'];
                    $notifi->Tipo = 1;
                    $notifi->Descripcion = "Se autorizó la orden número " . $_POST['idorden'] . ".";
                    $notifi->Folio = $_POST['idorden'];
                    $notifi->Usuario = 
                    $notifi->add();

                    //Enviar correo
                    $correos = $usu->correos();
                    foreach (to_object($correos) as $correo) {
                        $email->folio = $_POST['idorden'];
                        $email->correoe = $correo->Correo;
                        $email->enviarcorreo();
                    }
                }
                //Crear las notificaciones especiales
                $notifi2 = new notificacionesModel();
                $transitooriginal = $_POST['transitooriginal'];
                $transitomodi = $_POST['transito'];
                if($transitooriginal != $transitomodi){
                    $notifi2->Departamento = $_POST['transito'];
                    $notifi2->Tipo = 1;
                    $notifi2->Descripcion = "Tu departamento recibio una solicitud:  " . $_POST['idorden'] . ".";
                    $notifi2->Folio = $_POST['idorden'];
                    $notifi2->Usuario = 
                    $notifi2->add();
                }

                //Detalle de la orden
                $orden->IdOrden = $_POST['idorden'];
                $one = $orden->one();
                $orden->FolioOrden = $one['FolioOrden'];
                /*if (!$id = $orden->update_detalle()) {
                    json_output(json_build(400, null, 'Hubo un error al actualizar el detalle de la orden'));
                }*/

                foreach ($filas as $fila) {
                    $orden->Partida = $fila['partida'];
                    $orden->IdProducto = $fila['id'];
                    $orden->Cantidad = $fila['cantidad'];
                    $orden->PrecioVenta = $fila['precio'];
                    $orden->Entregados = $fila['entregados'];
                    $orden->ClaveExtintor = $fila['extintor'];
					$orden->DescuentoDetalle = $fila['descuento'];
                    $orden->DescPesos = $fila['descuentopesos'];
                    $orden->Neto = $fila['neto'];
                    $orden->compracreada = $fila['tienecompra'];
                    $orden->comagenteind = $fila['comisionind'];
                    $orden->eliminado = $fila['eliminar'];
					$orden->datetentativo = $fila['datetentativo'] ? $fila['datetentativo'] : date("Y-m-d");
                    $orden->IdDetalle = $fila['iddetalle'];
    
                    if($valentregados == 1){
                        $productos->proId = $fila['id'];
                        $productos->trCantidad = $fila['cantidad'];
                        if (!$nuevaexistencia = $productos->update_producto_orden()) {
                        json_output(json_build(400, null, 'Hubo un error al guardar el detalle de la orden'));
                        }


                    } 

                    if (!$id = $orden->update_detallereal()) {
                        json_output(json_build(400, null, 'Hubo un error al guardar el detalle de la orden'));
                    }
                }

                // se guardó con éxito
                json_output(json_build(200, $orden->one(), 'Orden actualizada con éxito'));
            }
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_update_detalleorden()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        try {
            $ordenes = new ordenesModel();
            $ordenes->IdOrden = $_POST['IdOrden'];
            $ordenes->FolioOrden = $_POST['FolioOrden'];
            $ordenes->IdDetalle = $_POST['IdDetalle'];
            $ordenes->Partida = $_POST['Partida'];
            $ordenes->IdProducto = $_POST['IdProducto'];
            $ordenes->Cantidad = $_POST['Cantidad'];
            $ordenes->PrecioVenta = $_POST['PrecioVenta'];
            $ordenes->Entregados = 0;


            if ($_POST['IdProducto'] == "") {
                throw json_output(json_build(400, null, "Por favor seleccione un producto."));
            }

            if (!$detalle = $ordenes->add_detalle()) {
                json_output(json_build(400, null, 'Hubo un error al guardar el detalle de la orden'));
            }
            json_output(json_build(201, $detalle, 'Orden agregada con exito'));
        } catch (Exception $e) {
            throw json_output(json_build(400, null, $e->getMessage()));
        }
    }

    //------------------------------INVOICE-----------------------------------
    function codi_transformar_invoice()
    {
        //ini_set('display_errors', 1);
        //ini_set('display_startup_errors', 1);

        try {
            $invoice = new invoicesModel();
            //Obtención del id de la orden
            $idorden = $_POST['idorden'];
            $invoice->FolioOrden = $idorden;

            //Buscar la información de la orden para pasarla al invoice
            $ordenes = new ordenesModel;
            $ordenes->IdOrden = $idorden;
            $orden = $ordenes->one();
            $invoice->FolioInvoice = random_strings(8);
            $invoice->IdUsuario = $orden['IdUsuario'];
            $invoice->IdCliente = $orden['IdCliente'];
            $invoice->IdDomicilio =  $orden['IdDomicilio'];
            $invoice->Fecha =  $orden['Fecha'];
            $invoice->Tipo =  $orden['Tipo'];
            $invoice->Descripcion =  $orden['Descripcion'];
            $invoice->Descuento =  $orden['Descuento'];
            $invoice->Estatus =  $orden['Estatus'];
            $invoice->TipoPago =  $orden['TipoPago'];
            $invoice->TipoOrden =  $orden['TipoOrden'];
            $invoice->TipoServicio =  $orden['TipoServicio'];
            $invoice->EstadoTransito =  $orden['EstadoTransito'];
            $invoice->Partida = $_POST['partidanueva'] ? $_POST['partidanueva'] : 1;
            $invoice->partidacincuenta = $_POST['partidacincuenta'] ? $_POST['partidacincuenta'] : 0;

            //Insertar la información de la orden en el invoice
            if (!$inv = $invoice->add()) {
                //Error
                json_output(json_build(400, null, 'Hubo un error al momento de transformar la orden en un invoice.'));
            }
            //Respuesta
            json_output(json_build(200, $inv, 'Orden transformada en invoice con éxito.'));
        } catch (Exception $e) {
            throw json_output(json_build(400, null, $e->getMessage()));
        }
    }

    function codi_orden_nueva_invoice()
    {
        //ini_set('display_errors', 1);
        //ini_set('display_startup_errors', 1);

        try {
            $invoice = new invoicesModel();
            //Obtención del id de la orden
            $idordennueva = $_POST['ordenfacturanueva'];
            $IdInvoice = $_POST['IdInvoice'];
            $ordrelacionado = $_POST['ordrelacionado'];
            $invoice->FolioOrden = $idordennueva;
            if($ordrelacionado != 0){
                $idordennueva = $ordrelacionado .",". $idordennueva;
            }
            //Buscar la información de la orden para pasarla al invoice
            $ordenes = new ordenesModel;
            $ordenes->IdOrden = $idordennueva;
            $ordenes->IdInvoice = $IdInvoice;
            $orden = $ordenes->relacionar_invoice_orden();
            $invoice->FolioOrden = $idordennueva;
            $invoice->IdInvoice = $IdInvoice;

            //Insertar la información de la orden en el invoice
            if (!$inv = $invoice->relacionar_orden_invoice()) {
                //Error
                json_output(json_build(400, null, 'Hubo un error al momento de transformar la orden en un invoice.'));
            }
            //Respuesta
            json_output(json_build(200, $inv, 'Orden transformada en invoice con éxito.'));
        } catch (Exception $e) {
            throw json_output(json_build(400, null, $e->getMessage()));
        }
    }

    function codi_orden_buscar_uuid()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        try {
            $invoice = new invoicesModel();
            //Obtención del id de la orden
            $idordennueva = $_POST['ordenfacturanueva'];
            $IdInvoice = $_POST['IdInvoice'];
            $invoice->FolioOrden = $idordennueva;
            $cancelado = $_POST['cancelado'];
            $valeliminado = $_POST['valeliminado'];
            $cpagosRel = $_POST['cpagosRel'];
            $invoice->Pago = $cpagosRel;
            $invoice->cancelado = $cancelado;
            $invoice->valeliminadoinvoice = $valeliminado;
            //Insertar la información de la orden en el invoice
            if (!$inv = $invoice->invoice_orden_complemento()) {
                //Error
                json_output(json_build(400, null, 'No se encontro orden facturada.'));
            }
            //Respuesta
            json_output(json_build(200, $inv, 'Orden encontrada.'));
        } catch (Exception $e) {
            throw json_output(json_build(400, null, $e->getMessage()));
        }
    }

    function codi_orden_buscar_partidas_invoice()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        try {
            $invoice = new invoicesModel();
            $IdInvoice = $_POST['IdInvoice'];
            $invoice->FolioOrden = $IdInvoice;

            //Insertar la información de la orden en el invoice
            if (!$inv = $invoice->invoice_orden_partidas_invoice()) {
                //Error
                json_output(json_build(400, null, 'No se encontro orden facturada.'));
            }
            //Respuesta
            json_output(json_build(200, $inv, 'Orden encontrada.'));
        } catch (Exception $e) {
            throw json_output(json_build(400, null, $e->getMessage()));
        }
    }

    function codi_update_invoice()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);
        try {
            $invoice = new invoicesModel();
            $comp = new ComplementosModel();
            $odenes = new ordenesModel();
            $notifi = new notificacionesModel();

            //Obtención del id de la orden
            $IdOrden = $_POST['IdOrden'];
            $IdInvoice = $_POST['IdInvoice'];
            $Pago = $_POST['Pago'];
            $tipoOrden = $_POST['tipoOrden'];
            //$InicioPeriodoPago = $_POST['InicioPeriodoPago'];
            $InicioPeriodoPago = date('Y-m-d');
            $Factura = $_POST['Factura'];
            $GenerarComprobante = $_POST['GenerarComprobante'];
            $Estatus = $_POST['Estatus'];
            $EstadoTransito = $_POST['EstadoTransito'];
            $filas = json_decode($_POST['filas'], true);

            $invoice->IdInvoice = $IdInvoice;
            $invoice->Pago = $Pago;
            $invoice->InicioPeriodoPago = $InicioPeriodoPago;
            $invoice->Factura = $Factura;
            $invoice->GenerarComprobante = $GenerarComprobante;
            $invoice->Estatus = $Estatus;
            $invoice->EstadoTransito = $EstadoTransito;
            //Actualizar la información de la orden en el invoice
            if (!$inv = $invoice->update()) {
                //Error
                json_output(json_build(400, null, 'Hubo un error al momento de actualizar el invoice.'));
            }
            //Actualizar orden
            $odenes->IdOrden = $IdOrden;
            $odenes->Estatus = $Estatus;
            if($tipoOrden == 3){
                $odenes->EstadoTransito = 2;
            }else{
                $odenes->EstadoTransito = 19;
            }
            
            if (!$ord = $odenes->update_estatus()) {
                //Error
                json_output(json_build(400, null, 'Hubo un error al momento de actualizar el invoice.'));
            }

            //Crear las mensualidades
            $notificar = 0;
            foreach ($filas as $fila) {
                $notificar = 1;
                $numero = $fila['numero'];
                $fecha = $fila['fecha'];
                $cantidad = $fila['cantidad'];
                $nota = $fila['nota'];
                if ($cantidad == "") {
                    $cantidad = 0;
                }
                $comp->IdOrden = $IdInvoice;
                $comp->NMes = $numero;
                $comp->Fecha = $fecha;
                $comp->Cantidad = $cantidad;
                $comp->Nota = $nota;
                $comp->Estatus = 1;

                if (!$com = $comp->create()) {
                    //Error
                    json_output(json_build(400, null, 'Hubo un error al momento de crear los complementos de pago del invoice.'));
                }
            }
            if ($notificar == 1) {
                //Enviar notificación
                $notifi->Tipo = 4;
                $notifi->Descripcion = "Se agregaron pagos parciales al invoice " . $IdInvoice . " de la orden " . $IdOrden . ".";
                $notifi->Folio = $IdInvoice;
                $notifi->Usuario = 
                $notifi->add();
            }
            //Respuesta
            json_output(json_build(201, $inv, 'Invoice actualizado con éxito.'));
        } catch (Exception $e) {
            throw json_output(json_build(400, null, $e->getMessage()));
        }
    }


    function codi_factura_facturama()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        $IdOrden = $_POST['IdOrden'];
        $Idcfdi = $_POST['Idcfdi'];
        $Pgeneral = $_POST['pgeneral'];
        $tipopago = $_POST['tipopago'];
        $rfcemisor = $_POST['rfcemisor'];
        $CfdiU = $_POST['CfdiU'];
        $metodopago = $_POST['metodopago'];
        $tipoFactura = $_POST['tipoFactura'];
        $partida = $_POST['partida'];
        $IdInvoice = $_POST['IdInvoice'];
        $foliofiscal = $_POST['foliofiscal'];
        $cancelado = $_POST['cancelado'];
        $folionuevo = $_POST['folionuevo'];
        $letrafolio = $_POST['letrafolio'];
        $folioanteriorasignado = $_POST['folioanteriorasignado'];
        try {
            $invoice  = new ordenesModel;
            $invoice2  = new invoicesModel;
            $invoice->IdOrden = $IdOrden;
            $invoice->IdFactura = $Idcfdi;
            $invoice->Pgeneral = $Pgeneral;
            $invoice->Tipo = $tipopago;
            $invoice->rfcEmisor = $rfcemisor;
            $invoice->usoCfdi = $CfdiU;
            $invoice->MP = $metodopago;
            $invoice->tipoFactura = $tipoFactura;
            $invoice->Partida = $partida;
            $invoice2->IdInvoice = $IdInvoice;
            if($partida != 1){
                
                $invoice2->Factura = $foliofiscal;
                $invoice2->Partida = $partida;
                $invoice2->IdFactura = $Idcfdi;
                
                $invoices2 = $invoice2->actualizarfolio_fiscal2();

            }
            $invoice2->folionuevo = $folionuevo;
            $invoice2->cancelado = $cancelado;
            $invoice2->folioanteriorasignado = $folioanteriorasignado;
            $invoicesconteo = $invoice2->update_asignar_folios();
            $invoicesconteo = $invoice2->conteo_invoice();
            

            $invoice->Foliofiscal = $foliofiscal;
            $invoices = $invoice->update_factura_Id();
            json_output(json_build(200, $invoices));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_factura_facturama_complemento()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        $IdOrden = $_POST['IdOrden'];
        $Idcfdi = $_POST['Idcfdi'];
        $numeropago = $_POST['numeropago'];
        $AmountPaid = $_POST['AmountPaid'];
        $ImpSaldoInsoluto = $_POST['ImpSaldoInsoluto'];
        $date = $_POST['date'];
        $PreviousBalanceAmount = $_POST['PreviousBalanceAmount'];
        $folioinvoice = $_POST['folioinvoice'];
        $folionuevo = $_POST['folionuevo'];

        try {
            $invoice  = new ordenesModel;
            $invoice->IdOrden = $IdOrden;
            $invoice->IdFactura = $Idcfdi;
            $invoice->folionuevo = $folionuevo;
            $invoice->numeropago = $numeropago;
            $invoice->AmountPaid = $AmountPaid;
            $invoice->ImpSaldoInsoluto = $ImpSaldoInsoluto;
            $invoice->Fecha = $date;
            $invoice->PreviousBalanceAmount = $PreviousBalanceAmount;
            $invoice->IdInvoice = $folioinvoice;
            $invoices = $invoice->insert_factura_complemento();
            $invoices = $invoice->conteo_invoice();
            json_output(json_build(200, $invoices));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_factura_buscar_folio()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);

        try {
            $foliocomplemento = new invoicesModel;
            $conteo = $foliocomplemento->buscarfolio();
            json_output(json_build(200, $conteo));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_factura_buscar_folio_factura()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);

        try {
            $foliocomplemento = new invoicesModel;
            $conteo = $foliocomplemento->buscarfoliofactura();
            json_output(json_build(200, $conteo));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_factura_facturama_detalle()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        $IdOrden = $_POST['IdOrden'];
        $items = $_POST['items'];
        $invoice  = new ordenesModel;
        try {
            foreach ($items as $fila) {
                
                $invoice->Partida = $fila['Partida'];
                $invoice->IdDetalle = $IdOrden;
                $invoice->ObjImpuesto = $fila['TaxObject'];
                $invoices = $invoice->update_factura_Id_detalle();
                
            }
            json_output(json_build(200, $invoices));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_actualizar_folios()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);

        $idFoliosnuevo = $_POST['idFoliosnuevo'];
        $serie = $_POST['serie'];
        $folioactual = $_POST['folioactual'];
        $invoice  = new invoicesModel;
        try {
                $invoice->serie = $serie;
                $invoice->folionuevo = $folioactual;
                $invoices = $invoice->conteo_invoice_leido();
            json_output(json_build(200, $invoices));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_cancelar_factura_facturama()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        $IdOrden = $_POST['IdOrden'];
        $IdFactAnterior = $_POST['Idcfdi'];
        $Idcfdi = $_POST['_uuidReplacement'];
        $motivo = $_POST['motivo'];
        $folioCancelacion = $_POST['folioCancelacion'];
        if($Idcfdi == null){
            $Idcfdi = $IdFactAnterior;
        }
        try {
            $invoice  = new ordenesModel;
            $invoice->IdOrden = $IdOrden;
            $invoice->IdFactura = $Idcfdi;
            $invoice->IdFactAnterior = $IdFactAnterior;
            $invoice->Motivo = $motivo;
            $invoice->IdCancelada = $folioCancelacion;
            $invoices = $invoice->update_factura_Id_cancelar();
            json_output(json_build(200, $invoices));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_cancelar_complemento()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        $IdOrden = $_POST['IdOrden'];
        $IdFactAnterior = $_POST['Idcfdi'];
        $Idcfdi = $_POST['_uuidReplacement'];
        $motivo = $_POST['motivo'];
        $folioCancelacion = $_POST['folioCancelacion'];
        if($Idcfdi == null){
            $Idcfdi = $IdFactAnterior;
        }
        try {
            $invoice  = new ordenesModel;
            $invoice->IdOrden = $IdOrden;
            $invoice->IdFactura = $Idcfdi;
            $invoice->IdFactAnterior = $IdFactAnterior;
            $invoice->Motivo = $motivo;
            $invoice->IdCancelada = $folioCancelacion;
            $invoices = $invoice->update_factura_Id_cancelar_comple();
            json_output(json_build(200, $invoices));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_invoices()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);

        try {
            $invoice  = new invoicesModel;
            $invoices = $invoice->all();
            $data = get_module('tablainvoices', $invoices);
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_invoices2()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $invoice  = new invoicesModel;
            $invoices = $invoice->all2();
            json_output(json_build(200, $invoices));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }
    //------------------------------COTIZACIONES------------------------------
    function codi_get_cotizacion()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $IdCotizacion = $_POST['IdCotizacion'];
            $cotizaciones = new cotizacionesModel();
            $cotizaciones->IdCotizacion = $IdCotizacion;
            $detalle = $cotizaciones->one();
            $productos = $cotizaciones->detalle();

            $data = [
                "IdCotizacion" => $IdCotizacion,
                "FolioCotizacion" => $detalle['FolioCotizacion'],
                "Detalle" => $detalle,
                "Productos" => $productos,
            ];

            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_cotizacionevento()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {

           $IdCotizacion = $_POST['IdCotizacion'];
            $cotizaciones = new cotizacionesModel();
            $cotizaciones->IdCotizacion = $IdCotizacion;
            $detalle = $cotizaciones->one();
            json_output(json_build(200, $detalle));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_cotizaciones()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $orden  = new cotizacionesModel;
            $cotizaciones = $orden->all();
            $data = get_module('tablacotizaciones', $cotizaciones);
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_cotizaciones2()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $orden  = new cotizacionesModel;
            $cotizaciones = $orden->all2();
            json_output(json_build(200, $cotizaciones));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_delete_cotizacion()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);

        try {
            $usuario  = new cotizacionesModel;
            $usuario->IdCotizacion = $_POST['idCotizacion'];
            $usuario->Estatus = 6; //$_POST['activo'];

            if (!$usuario->delete()) {
                json_output(json_build(400, null, 'Hubo error al guardar los cambios'));
            }

            // se guardó con éxito
            json_output(json_build(200, null, 'Cotización eliminada con éxito'));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_detallecotizacion()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $cotizacion  = new cotizacionesModel;
            $cotizacion->IdCotizacion = $_POST['IdCotizacion'];
            $cotizaciones = $cotizacion->detalle();
            $data = get_module('tablacotizaciondetalle', $cotizaciones);
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_add_detallecotizacion()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        try {
            $cotizaciones = new cotizacionesModel();
            $cotizaciones->IdCotizacion = $_POST['IdCotizacion'];
            $cotizaciones->FolioCotizacion = $_POST['FolioCotizacion'];
            $cotizaciones->Partida = $_POST['Partida'];
            $cotizaciones->IdProducto = $_POST['IdProducto'];
            $cotizaciones->Cantidad = $_POST['Cantidad'];
            $cotizaciones->PrecioVenta = $_POST['PrecioVenta'];
			$cotizaciones->DescuentoDetalle = 0;
			$cotizaciones->DescPesos = 0;
			$cotizaciones->Neto = $_POST['PrecioVenta'];

            
            if ($_POST['IdProducto'] == "") {
                throw json_output(json_build(400, null, "Por favor seleccione un producto."));
            }

            if (!$detalle = $cotizaciones->add_detalle()) {
                json_output(json_build(400, null, 'Hubo un error al guardar el detalle de la Cotización'));
            }
            json_output(json_build(201, $detalle, 'Cotización agregada con exito'));
        } catch (Exception $e) {
            throw json_output(json_build(400, null, $e->getMessage()));
        }
    }


    function codi_add_vales()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);
        $SolicitanteId = $_POST['SolicitanteId'];
        $IdReceptorVale = $_POST['IdReceptorVale'];
        $Tipovale = $_POST['Tipovale'];
        $IdOrden = $_POST['IdOrden'];
        $DescripcionOrden = $_POST['DescripcionOrden'];
        $Descripcionvale = $_POST['Descripcionvale'];
        $dinerosolicitud = $_POST['dinerosolicitud'];
        $idProducto = "";
        $TipoInsumoId = "";
        $TipoSalidaId = "";
        if($Tipovale == 1){
            $TipoInsumoId = $dinerosolicitud;
            $dinerosolicitud = "";
        }else if($Tipovale == 2){
            $TipoSalidaId = $dinerosolicitud;
            $dinerosolicitud = "";
        }else if($Tipovale == 3){
            $dinerosolicitud = $dinerosolicitud;
        }else if($Tipovale == 4){
            $idProducto = $dinerosolicitud;
            $dinerosolicitud = "";
        }
        try {
            $vales = new almacenesModel();
            $vales->solicitanteId = $SolicitanteId;
            $vales->idReceptorVale = $IdReceptorVale;
            $vales->tipovale= $Tipovale;
            $vales->detalleInsumosDinero= $dinerosolicitud;
            $vales->idProducto= $idProducto;
            $vales->tipoInsumoId= $TipoInsumoId;
            $vales->tipoSalidaId= $TipoSalidaId;
            $vales->descripcionSolicitud= $Descripcionvale;
            $vales->fechaSolicitud= date("Y-m-d H:i:s");
            $vales->estatus= 1;
            $vales->idOrdenVale = $IdOrden;           
            if (!$detalle = $vales->add_vales()) {
                json_output(json_build(400, null, 'Hubo un error al guardar el vale'));
            }
            json_output(json_build(201, $detalle, 'Vale agregada con exito'));
        } catch (Exception $e) {
            throw json_output(json_build(400, null, $e->getMessage()));
        }
    }

    function codi_update_cotizacion()
    {
        /*ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);*/
        try {
            $cotizacion  = new cotizacionesModel;
            $cotizacion->Estatus = $_POST['estatus'];
            $cotizacion->IdCotizacion = $_POST['idcotizacion'];
            $cotizacion->TipoOrden = $_POST['tipo_orden'];
            if ($_POST['tipo_servicio'] == "") {
                $cotizacion->TipoServicio = 0;
            } else {
                $cotizacion->TipoServicio = $_POST['tipo_servicio'];
            }

            $filas = json_decode($_POST['productos'], true);

            if (count($filas) < 1) {
                throw json_output(json_build(400, null, "Por favor seleccione un producto."));
            }

            $IdCotizacion = $cotizacion->update();
            if (!$IdCotizacion) {
                json_output(json_build(400, null, 'Hubo error al guardar los cambios'));
            } else {

                $cotizacion->IdCotizacion = $_POST['idcotizacion'];
                $one = $cotizacion->one();
                $cotizacion->FolioCotizacion = $one['FolioCotizacion'];
                if (!$id = $cotizacion->update_detalle()) {
                    json_output(json_build(400, null, 'Hubo un error al actualizar el detalle de la cotizacion'));
                }

                foreach ($filas as $fila) {
                    //$cotizacion->IdDetalle = $fila['iddetalle'];
                    $cotizacion->Partida = $fila['partida'];
                    $cotizacion->IdProducto = $fila['id'];
                    $cotizacion->Cantidad = $fila['cantidad'];
                    $cotizacion->PrecioVenta = $fila['precio'];
					$cotizacion->DescuentoDetalle = $fila['descuento'];
                    $cotizacion->DescPesos = $fila['descuentopesos'];
                    $cotizacion->Neto = $fila['neto'];
                    $cotizacion->datetentativo = $fila['datetentativo'];
                    $cotizacion->comagenteind = $fila['comagenteind'];
                    
					
                    if (!$id = $cotizacion->add_detalle()) {
                        json_output(json_build(400, null, 'Hubo un error al guardar el detalle de la cotizacion'));
                    }
                }
                $autorizacionOrden = $_POST['autorizacionOrden'] ? $_POST['autorizacionOrden'] : 0;
                $FisEmail = $_POST['FisEmail'] ? $_POST['FisEmail'] : 0;
                $llaveOrden = $_POST['llaveOrden'] ? $_POST['llaveOrden'] : 0;
                $llaveOrdenAutorizacion = $_POST['llaveOrdenAutorizacion'] ? $_POST['llaveOrdenAutorizacion'] : 0;
                        if($FisEmail != 0){
                             $email = new emailModel();
                        $email->llavelarga = "";
                        $email->llaveuno = 0;
                        $email->folio = $_POST['idcotizacion'];
                        $email->correoe = $FisEmail;
                        $email->tipo = "cotizacion";
                        $email->llaveorden = $llaveOrden;
                        $email->enviarcorreo(); 
                        }
                       
                    
                // se guardó con éxito
                json_output(json_build(200, $cotizacion->one(), 'Cotizacion actualizada con éxito'));
            }
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_update_fecha_cotizacion(){
        try {
            $cotizacion  = new cotizacionesModel;
            $cotizacion->IdCotizacion = $_POST['IdCotizacion'];
            $fechaactualizada = $cotizacion->update_fecha_cotizacion();
            json_output(json_build(200, $fechaactualizada, 'actualizacion agregada con exito'));
        } catch (Exception $e) {
            json_output(json_build(400, $e, 'Error al realizar el cambio de fecha'));
        }
        
    }

    function codi_update_aceptar_taller_cotizacion(){
         ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $cotizacion  = new cotizacionesModel;
            $cotizacion->IdCotizacion = $_POST['IdCotizacion'];
            $fechaactualizada = $cotizacion->update_fecha_cotizacion_taller_inicio();

            $cotizacion2  = new cotizacionesModel;
            $cotizacion2->IdCotizacion = $_POST['IdCotizacion'];
            $fechaactualizada = $cotizacion2->aceptar_taller_cotizacion();

            json_output(json_build(200, $fechaactualizada, 'actualizacion agregada con exito'));
        } catch (Exception $e) {
            json_output(json_build(400, $e, 'Error al realizar el cambio de fecha'));
        }
        
    }

    function codi_update_terminar_taller_cotizacion(){
         ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $cotizacion  = new cotizacionesModel;
            $cotizacion->IdCotizacion = $_POST['IdCotizacion'];
            $fechaactualizada = $cotizacion->update_fecha_cotizacion_taller_final();

            $cotizacion2  = new cotizacionesModel;
            $cotizacion2->IdCotizacion = $_POST['IdCotizacion'];
            $fechaactualizada = $cotizacion2->terminar_taller_cotizacion();

            json_output(json_build(200, $fechaactualizada, 'actualizacion agregada con exito'));
        } catch (Exception $e) {
            json_output(json_build(400, $e, 'Error al realizar el cambio de fecha'));
        }
        
    }

     function updateEstatusOrdenCompra(){
        $orden  = new ordenesModel;
        $orden->IdOrden = $_POST['iordene'];
        $compraorden = $orden->updatecompraorden();
        json_output(json_build(201, $compraorden, 'actualizacion agregada con exito'));
    }


    function codi_update_moroso(){
        $clientes  = new clientesModel;
        $clientes->IdCliente = $_POST['cliente'];
        $clientes->moroso = $_POST['moroso'];
        $moroso = $clientes->updatemoroso();
        json_output(json_build(201, $moroso, 'Cliente actualizado con exito'));
    }

    function codi_update_leido(){
        $notifi  = new notificacionesModel;
        $notifi->Folio = $_POST['IdOrden'];
        $notifi->Departamento = $_POST['departamento'];
        $notifi->leido = $_POST['leido'];
        $leido = $notifi->update();
        json_output(json_build(201, $leido, 'Confirmación de lectura actualizado con exito'));
    }

    function codi_update_leido_todos(){
        $notifi  = new notificacionesModel;
        $notifi->Departamento = $_POST['departamento'];
        $leido = $notifi->updatetodos();
        json_output(json_build(201, $leido, 'Confirmación de lectura actualizado con exito'));
    }


    //------------------------------COMPRAS------------------------------
    function codi_add_compras()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        try {
            $compras = new comprasModel();
            $compradetalle = new compradetalleModel();
            $notifi = new notificacionesModel();

            $compras->idOrden = $_POST['idOrden'];
            $compras->idProveedor = $_POST['idProveedorgeneral'];
            $compras->descripcion = $_POST['descripcion'];
            $compras->cantidad = $_POST['cantidad'];
            $compras->precio = $_POST['precio'];
            $compras->estado = $_POST['estado'];
            $compras->fecha = $_POST['fecha'];
            $compras->montoj = $_POST['montoj'];
            $compras->variosprov = $_POST['variosprov'];
            $compras->tipoPago = $_POST['tipoPago'];
            $compras->coutas = $_POST['tipoPago'] === 'credito' ? $_POST['coutas'] : 0;
            $compras->inicioPago =  $_POST['tipoPago'] === 'credito' ? $_POST['inicioPago'] : '0000-00-00';
            $compras->finPago = $_POST['tipoPago'] === 'credito' ? $_POST['finPago'] : '0000-00-00';
            $compras->departamento = $_POST['departamento'];
            $compras->aprobada = $_POST['aprobada'] == 1 ? $_POST['aprobada'] : 0;


            $filas = json_decode($_POST['productos'], true);

            if (count($filas) < 1) {
                throw json_output(json_build(400, null, "Por favor seleccione un producto."));
            }

            $idCompra = $compras->add();

            if (!$idCompra) {
                json_output(json_build(400, null, 'Hubo un error al guardar el registro'));
            } else {
                $notifi->Tipo = 5;
                $notifi->Descripcion = "Se creó una compra pendiente de revisión. Compra: " . $idCompra . ".";
                $notifi->Departamento = 11;
                $notifi->Folio = $idCompra;
                $notifi->Usuario = 
                $notifi->add();

                foreach ($filas as $fila) {
                    $compradetalle->idOrdendetalle = $_POST['idOrden'];
                    $compradetalle->partida = $fila['partida'];
                    $compradetalle->precio = $fila['precio'];
                    $compradetalle->cantidad = $fila['cantidad'];
                    $compradetalle->descripcion = $fila['descripcion'];
                    $compradetalle->partida = $fila['partida'];
                    $compradetalle->idCompra = $idCompra;
                    $compradetalle->monto = $fila['monto'];
                    $compradetalle->idProducto = $fila['id'];
                    $compradetalle->idProveedor = $fila['idProveedor'];

                    if (!$id = $compradetalle->add_detalle()) {
                        json_output(json_build(400, null, 'Hubo un error al guardar el detalle de la compra'));
                    }
                }

                json_output(json_build(201, $idCompra, 'compra agregada con exito'));
            }
        } catch (Exception $e) {
            throw json_output(json_build(400, null, $e->getMessage()));
        }
    }


    function codi_aprobar_compra_almacen(){

        try {
            $compras = new comprasModel();
            $compras->id = $_POST['idCompra'];
            $compras->filas = $_POST['filas'];


            if (!$compras = $compras->aprobar_compra()) {
                json_output(json_build(400, null, 'Hubo un error al aprobar la compra'));
            }

            json_output(json_build(200, null, 'Compra actualizada con exito'));
        } catch (Exception $e) {
            throw json_output(json_build(400, null, $e->getMessage()));
        }
    }


    function codi_cambiar_multiple_prov(){

        try {
            $compras = new comprasModel();
            $compras->variosprov = $_POST['activar'];
            $compras->id = $_POST['idc'];


            if (!$compras = $compras->multiple_prov()) {
                json_output(json_build(400, null, 'Hubo un error al cambiar a proveedores multiple en la compra'));
            }

            json_output(json_build(200, null, 'Proveedores multiple activado'));
        } catch (Exception $e) {
            throw json_output(json_build(400, null, $e->getMessage()));
        }
    }

    function codi_recibir_compra_final_sistema(){

        try {
            $compras = new comprasModel();
            $compras->id = $_POST['idCompra'];
            $compras->filas = json_decode($_POST['filas'], true);
            $compras->idOrden = $_POST['idordenoriginal'];
            $n = $_POST['n'];
            $compraid = $_POST['idCompra'];
            for ($i=1; $i <=$n ; $i++) { 
                $pdf = $_FILES['pdf_'.$i.'_'.$compraid]['name'];
                if($pdf){
                $arpdf = new facturaspdfModel();
                $arpdf->filename = $_FILES['pdf_'.$i.'_'.$compraid]['name'];
                $arpdf->temppath= $_FILES['pdf_'.$i.'_'.$compraid]['tmp_name'];
                $arpdf->Id = $compraid;
                $arpdf->partida = $i;
                $fileNameid = $arpdf->addpdfacdetalle();
                if(!$fileNameid){
                    json_output(json_build(400, null, 'Hubo un error al guardar la ficha tecnica'));
                }
              }
              $xml = $_FILES['xml_'.$i.'_'.$compraid]['name'];
                if($xml){
                $arxml = new facturaspdfModel();
                $arxml->filename = $_FILES['xml_'.$i.'_'.$compraid]['name'];
                $arxml->temppath= $_FILES['xml_'.$i.'_'.$compraid]['tmp_name'];
                $arxml->Id = $compraid;
                $arxml->partida = $i;
                $fileNameid = $arxml->addpdfacdetalle();
                if(!$fileNameid){
                    json_output(json_build(400, null, 'Hubo un error al guardar la ficha tecnica'));
                }
              }
            }

            if (!$compras = $compras->aprobar_compra_final_sistema()) {
                json_output(json_build(400, null, 'Hubo un error al aprobar la compra'));
            }

            json_output(json_build(200, null, 'Compra actualizada con exito'));
        } catch (Exception $e) {
            throw json_output(json_build(400, null, $e->getMessage()));
        }
    }

    function codi_hacer_devolucion(){
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);
        error_reporting(E_ALL);
            $compras = new comprasModel();
            $compras->id = $_POST['idCompra'];
            $compras->filas = json_decode($_POST['filas'], true);
            $compras->tipo = $_POST['tipocompra'];
            try{

             if (!$compras = $compras->codi_hacer_devolucion()) {
                json_output(json_build(400, null, 'Hubo un error al aprobar la compra'));
            }

            json_output(json_build(200, null, 'Compra actualizada con exito'));
        } catch (Exception $e) {
            throw json_output(json_build(400, null, $e->getMessage()));
        }
    }

    function codi_pdf_compra(){
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);
        try { 
            $compras = new comprasModel();
            $compras->filename = $_FILES['customFile']['name'];
            $compras->temppath=$_FILES["customFile"]["tmp_name"];
            $compras->id = $_POST['idCompraparapdf'];
            $compras->tipo = $_POST['tipo'];

            if (!$compras = $compras->codi_addpd_fsbf()) {
                json_output(json_build(400, null, 'Hubo un error al aprobar la compra'));
            }

            json_output(json_build(200, null, 'Compra actualizada con exito'));
        } catch (Exception $e) {
            throw json_output(json_build(400, null, "No pude ingresar al try"));
        }
    }

    //----------------------CATALOGOS SAT------------------------------------------------//

    function codi_get_tipospago()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);
        error_reporting(E_ALL);

        try {
            $cat  = new catalogosatModel;
            $catalogos = $cat->tipospago();
            $data = get_module('selecttipospago', $catalogos);
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_usocfdi()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);
        error_reporting(E_ALL);

        try {
            $cat  = new catalogosatModel;
            $cat->persona = $_POST['persona'];
            $catalogos = $cat->usocfdi();
            $data = get_module('selectusocfdi', $catalogos);
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_regimenfiscal()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);
        error_reporting(E_ALL);

        try {
            $cat  = new catalogosatModel;
            $cat->persona = $_POST['persona'];
            $catalogos = $cat->regimenfiscal();
            $data = get_module('selectregimenfiscal', $catalogos);
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }
    
    //----------------------EVENTOS------------------------------------------------------//
    function codi_get_eventos()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);
        $filtrotipo = $_POST['filtrocapacitaciones'] >= 0 ? $_POST['filtrocapacitaciones'] : 0;
        error_reporting(E_ALL);
        try {

            $calendario  = new calendarioModel;
            $eventos = $calendario->all();
            //json_output(json_build(200, $eventos));
            echo json_encode($eventos);
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_eventos2()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {

            $calendario = new calendarioModel();
            $calendario->fechainic = $_POST['Fechaini'];
            $calendario->fechafin = $_POST['Fechafin'];
            $calendario->IdCliente = $_POST['IdCliente'];
            $orden = $calendario->todos_eventos_clientes();
            json_output(json_build(200, $orden,"Consulta con exito"));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_add_evento()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        try {
            $eventos = new calendarioModel();
            $eventos->evntTipoServicio = $_POST['IevntTipoServicio'];
            $eventos->IdDomicilioClte = $_POST['IIdDomicilio'];
            $eventos->IdCliente = $_POST['IIdCliente'];
            $eventos->DC3Cliente = $_POST['dc3'];
            $eventos->IdVendedor = $_POST['IVendedor'];
            $eventos->IdOrden = $_POST['IIdOrden'];
            $eventos->evtNParticipantes = $_POST['IParticipantes'];
            $eventos->evtObservaciones = $_POST['IObservaciones'];
            $eventos->evntFechaInicio = $_POST['IevntFechaInicio'];
            $eventos->evntHoraInicio = $_POST['IevntHoraInicio'];
            $eventos->evntFechaFin = $_POST['IevntFechaFin'];
            $eventos->evntHoraFin = $_POST['IevntHoraFin'];
            $eventos->evntEstatus = $_POST['IevntEstatus'];
            $eventos->eventPartida = $_POST['partidaC'];
            $partidas = $_POST['IPartidas'];
            $eventos->Partidas  = json_encode($_POST['IPartidas']);
            $eventos->alimentos  = $_POST['alimentos'];
            $eventos->transporte  = $_POST['transporte'];
            $eventos->envtInstructores  = json_encode($_POST['IInstructores']);

            if (!$evento = $eventos->add()) {
                json_output(json_build(400, null, 'Hubo un error al guardar el evento'));
            }
            $Orden = $_POST['IIdOrden'];
            $partida = $_POST['partidaC'];
            $ordenes  = new ordenesModel;
            foreach ($partidas as $key => $value) {
                $ordenes->IdOrden = $Orden;
                $ordenes->Partida = $value;
                $ordenes->agendaCap = 1;
                $ordenes->Fecha = $_POST['IevntFechaInicio'];
                if (!$ordenes->update_calendario()) {
                    json_output(json_build(400, null, 'Hubo error al guardar los cambios'));
                }
            }
            json_output(json_build(201, $evento, 'Evento agregado con exito'));
        } catch (Exception $e) {
            throw json_output(json_build(400, null, $e->getMessage()));
        }
    }


    function codi_add_evento_cotizacion()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        try {
            $eventos = new calendarioModel();
            $eventos->evntTipoServicio = $_POST['IevntTipoServicio'];
            $eventos->IdDomicilioClte = $_POST['IIdDomicilio'];
            $eventos->IdCliente = $_POST['IIdCliente'];
            $eventos->DC3Cliente = $_POST['dc3'];
            $eventos->IdVendedor = $_POST['IVendedor'];
            $eventos->IdOrden = $_POST['IIdOrden'];
            $eventos->evtNParticipantes = $_POST['IParticipantes'];
            $eventos->evtObservaciones = $_POST['IObservaciones'];
            $eventos->evntFechaInicio = $_POST['IevntFechaInicio'];
            $eventos->evntHoraInicio = $_POST['IevntHoraInicio'];
            $eventos->evntFechaFin = $_POST['IevntFechaFin'];
            $eventos->evntHoraFin = $_POST['IevntHoraFin'];
            $eventos->evntEstatus = $_POST['IevntEstatus'];
            $eventos->eventPartida = $_POST['partidaC'];
            $partidas = $_POST['IPartidas'];
            $eventos->Partidas  = json_encode($_POST['IPartidas']);
            $eventos->alimentos  = $_POST['alimentos'];
            $eventos->transporte  = $_POST['transporte'];
            $eventos->envtInstructores  = json_encode($_POST['IInstructores']);

            if (!$evento = $eventos->add_cot()) {
                json_output(json_build(400, null, 'Hubo un error al guardar el evento'));
            }
            $IdCotizacion = $_POST['IIdOrden'];
            $partida = $_POST['partidaC'];
            $ordenes  = new cotizacionesModel;
            foreach ($partidas as $key => $value) {
                $ordenes->IdCotizacion = $IdCotizacion;
                $ordenes->Partida = $value;
                $ordenes->agendaCap = 1;
                $ordenes->Fecha = $_POST['IevntFechaInicio'];
                if (!$ordenes->update_calendario()) {
                    json_output(json_build(400, null, 'Hubo error al guardar los cambios'));
                }
            }
            
            json_output(json_build(201, $evento, 'Evento agregado con exito'));
        } catch (Exception $e) {
            throw json_output(json_build(400, null, $e->getMessage()));
        }
    }

   
    function codi_update_evento()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        try {
            $eventos = new calendarioModel();
            $eventos->evntId = $_POST['UevntId'];
            $eventos->evntTipoServicio = $_POST['UevntTipoServicio'];
            $eventos->IdDomicilioClte = $_POST['UIdDomicilio'];
            $eventos->IdCliente = $_POST['UIdCliente'];
            $eventos->DC3Cliente = $_POST['UDC3Cliente'];
            $eventos->IdVendedor = $_POST['UVendedor'];
            $eventos->IdOrden = $_POST['UIdOrden'];
            $eventos->evtNParticipantes = $_POST['UParticipantes'];
            $eventos->evtObservaciones = $_POST['UObservaciones'];
            $eventos->evntFechaInicio = $_POST['UevntFechaInicio'];
            $eventos->evntHoraInicio = $_POST['UevntHoraInicio'];
            $eventos->evntFechaFin = $_POST['UevntFechaFin'];
            $eventos->evntHoraFin = $_POST['UevntHoraFin'];
            $eventos->evntEstatus = $_POST['UevntEstatus'];
            $eventos->eventPartida = $_POST['partidaCalendario'];
            $partidas = $_POST['IPartidas'];
            $eventos->Partidas  = json_encode($_POST['IPartidas']);
            $eventos->alimentos  = $_POST['alimentos'];
            $eventos->transporte  = $_POST['transporte'];
            $eventos->envtInstructores  = json_encode($_POST['UInstructores']);

            if (!$evento = $eventos->update()) {
                json_output(json_build(400, null, 'Hubo un error al editar el evento'));
            }

            $ordenes  = new ordenesModel;
            $ordenes->IdOrden = $_POST['UIdOrden'];
            $ordenes->alimentosli = $_POST['alimentos'];
            $ordenes->transporteli = $_POST['transporte'];
            $ordenes->dc3li = $_POST['UDC3Cliente'];
            $ordenes->textocursos = $_POST['UObservaciones'];

            if (!$ordenes = $ordenes->update_cursos()) {
                json_output(json_build(400, null, 'Hubo un error al editar el evento'));
            }
            $ordenes  = new ordenesModel;
            foreach ($partidas as $key => $value) {
                $ordenes->Partida = $value;
                $ordenes->agendaCap = 1;
                $ordenes->Fecha = $_POST['UevntFechaInicio'];
                if (!$ordenes->update_calendario()) {
                    json_output(json_build(400, null, 'Hubo error al guardar los cambios'));
                }
            }

            json_output(json_build(201, $eventos->one(), 'Evento actualizado con exito'));
        } catch (Exception $e) {
            throw json_output(json_build(400, null, $e->getMessage()));
        }
    }


    function codi_update_tema()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        try {
            $usuarios = new usuariosModel();
            $usuarios->darkmode = $_POST['darkmode'];
            $usuarios->IdUsuario = $_POST['IdUsuario'];

            if (!$usuarios = $usuarios->update_tema()) {
                json_output(json_build(400, null, 'Hubo un error al actualizar tema'));
            }
            $_SESSION['usuario']['tema'] = $_POST['darkmode'];
            json_output(json_build(200, 'Evento actualizado con exito'));
        } catch (Exception $e) {
            throw json_output(json_build(400, null, $e->getMessage()));
        }
    }

    function codi_delete_evento()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        try {
            $eventos = new calendarioModel();
            $eventos->evntId = $_POST['DevntId'];
            $eventos->IdOrden = $_POST['OrdenId'];
            $eventos->tamano = $_POST['tamano'];
            $partidas = $_POST['IPartidasdelete'];
            $eventos->tamanodos = count($partidas);
            foreach ($partidas as $key => $value) {
                $eventos->eventPartida = $value;
                    if (!$evento = $eventos->delete()) {
                    json_output(json_build(400, null, 'Hubo un error al eliminar el evento'));
                }
            }

            json_output(json_build(201, $eventos->one(), 'Evento eliminado con exito'));
        } catch (Exception $e) {
            throw json_output(json_build(400, null, $e->getMessage()));
        }
    }


    

    //--------------------------------------------ALMACENES-------------------------------------------------
    function codi_get_almacenes()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {

            $usuario  = new almacenesModel;
            $usuarios = $usuario->all();
            $data = get_module('tablaalmacen', $usuarios);
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_almacenes_json()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {

            $usuario  = new almacenesModel;
            $usuarios = $usuario->all();
            json_output(json_build(200, $usuarios));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_almacenes_select()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {

            $almacen  = new almacenesModel;
            $almacen = $almacen->all();
            $data = get_module('selectalmacen', $almacen);

            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_almacenes_select_ind()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {

            $almacen  = new almacenesModel;
            $almacen->almId = $_POST['mostrar'];
            $almacen = $almacen->ind();
            $data = get_module('selectalmacen', $almacen);
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

     function codi_get_almacenes_select_ind2()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {

            $almacen  = new almacenesModel;
            $almacen->almId = $_POST['mostrar'];
            $almacen = $almacen->ind2();

            $data = get_module('selectalmacen', $almacen);
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_ordenanclar()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {

            $ordenanclar  = new ordenesModel;
            $ordenanclar->IdCliente = $_POST['idCliente'];
            $ordenanclar = $ordenanclar->slect_ordenes_anclabes();

            $data = get_module('selectordenanclar', $ordenanclar);
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_ordenanclar_invoce()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {

            $ordenanclar  = new ordenesModel;
            $ordenanclar->IdCliente = $_POST['idCliente'];
            $ordenanclar = $ordenanclar->slect_ordenes_anclabes_invoice();

            $data = get_module('selectordenanclar', $ordenanclar);
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_ordenanclar_invoce_complemento()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {

            $ordenanclar  = new ordenesModel;
            $ordenanclar->IdCliente = $_POST['idCliente'];
            $ordenanclar = $ordenanclar->slect_ordenes_anclabes_invoice_complemento();
            
            $data = get_module('selectordenanclar', $ordenanclar);
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_add_almacen()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $usuario = new almacenesModel();
            $usuario->almNombre = $_POST['almNombre'];
            $usuario->almEstatus = $_POST['almEstatus'];

            if (!$id = $usuario->add()) {
                json_output(json_build(400, null, 'Hubo un error al guardar el registro'));
            }
            // $usuario->IdUsuario = $id;
            json_output(json_build(201, null, 'Almacén agregado con exito'));
        } catch (Exception $e) {
            throw json_output(json_build(400, null, $e->getMessage()));
        }
    }

    function codi_update_almacen()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $usuario  = new almacenesModel;
            $usuario->almId = $_POST['id'];
            $usuario->almNombre = $_POST['nombre'];
            //$usuario->almEstatus = $_POST['estatus'];
            if (!$usuario->update()) {
                json_output(json_build(400, null, 'Hubo error al guardar los cambios'));
            }

            // se guardó con éxito
            json_output(json_build(200, null, 'Almacén actualizado con éxito'));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_delete_almacen()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);

        try {
            $almacen  = new almacenesModel();
            $producto  = new productosModel();
            $almacen->almId = $_POST['almid'];
            $almacen->almNombre = $_POST['EalmNombre'];
            $almacen->almNombre = $_POST['totalPro'];

            if ($_POST['proAlmacen'] != 0) {
                $producto->proAlmIdNuevo = $_POST['proAlmacen']; //Nuevo almacen
                $producto->proAlmId = $_POST['almid']; //Almacen actual

                if (!$producto->update_almacen()) {
                    json_output(json_build(400, null, 'Hubo error al traspasar los productos de almacen'));
                    exit();
                }
                if (!$almacen->delete()) {
                    json_output(json_build(400, null, 'Hubo error al eliminar el almacén.'));
                }
            } else {
                if (!$almacen->delete()) {
                    json_output(json_build(400, null, 'Hubo error al eliminar el almacén.'));
                }
            }

            // se guardó con éxito
            json_output(json_build(201, null, 'Almacen eliminado con éxito'));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    //--------------------------------------------PROVEEDORES-------------------------------------------------
    function codi_add_proveedor()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $usuario = new proveedoresModel();
            $usuario->nombre = $_POST['nombre'];
            $usuario->descripcion = $_POST['descripcion'];
            $usuario->email = $_POST['email'];
            $usuario->telefono = $_POST['telefono'];
            $usuario->calle = $_POST['calle'];
            $usuario->ninterior = $_POST['ninterior'];
            $usuario->nexterior = $_POST['nexterior'];
            $usuario->cp = $_POST['cp'];
            $usuario->municipio = $_POST['municipio'];
            $usuario->estado = $_POST['estado'];

            if (!$id = $usuario->add()) {
                json_output(json_build(400, null, 'Hubo un error al guardar el registro'));
            }
            // $usuario->IdUsuario = $id;
            json_output(json_build(201, null, 'Proveedor agregado con exito'));
        } catch (Exception $e) {
            throw json_output(json_build(400, null, $e->getMessage()));
        }
    }

    function codi_update_proveedores()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $usuario  = new proveedoresModel;
            $usuario->id = $_POST['id'];
            $usuario->nombre = $_POST['nombre'];
            $usuario->descripcion = $_POST['descripcion'];
            $usuario->email = $_POST['email'];
            $usuario->telefono = $_POST['telefono'];
            $usuario->calle = $_POST['calle'];
            $usuario->ninterior = $_POST['ninterior'];
            $usuario->nexterior = $_POST['nexterior'];
            $usuario->cp = $_POST['cp'];
            $usuario->municipio = $_POST['municipio'];
            $usuario->estado = $_POST['estado'];
            if (!$usuario->update()) {
                json_output(json_build(400, null, 'Hubo error al guardar los cambios'));
            }

            // se guardó con éxito
            json_output(json_build(200, null, 'Proveedor actualizado con éxito'));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }


    function codi_delete_proveedor()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);

        try {
            $proveedor  = new proveedoresModel;
            $proveedor->id = $_POST['edid'];

            if (!$proveedor->delete()) {
                json_output(json_build(400, null, 'Hubo error al guardar los cambios'));
            }

            // se guardó con éxito
            json_output(json_build(201, null, 'Proveedor eliminado con éxito'));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    //---------------------------------------------------------------------------------------------

    function codi_get_compras()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $compras  = new comprasModel;
            $compras = $compras->all();
            $data = get_module('tablacompras', $compras);
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_compra()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);

        try {

            $compras  = new comprasModel;
            $compras->id = $_POST['proId'];
            $compra = $compras->one();
            json_output(json_build(200, $compra));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_eliminar_fcompra()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);

        try {

            $eliminar = new comprasModel();
            $eliminar->id = $_POST['idCompra'];
            $filas = json_decode($_POST['filas'], true);
            
            foreach ($filas as $fila) {
                $eliminar->partida = $fila['partida'];
                    $eliminar->cantidad = $fila['cantidad'];
                    $eliminar->precio = $fila['precioventa'];
                    $eliminar->monto = $fila['monto'];
                    $eliminar->eliminado = $fila['eliminar'];
                    $elfila = $fila['eliminar'];
                     if($elfila == 1){
                        if (!$id = $eliminar->eliminar_fila()) {
                        json_output(json_build(400, null, 'Hubo un error al guardar el detalle de la orden'));
                        }
                    }
            }

            json_output(json_build(200, null, 'Producto eliminado de la compra'));

        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    

    function codi_agregar_fecha_entrega(){
    
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);

        try {

            $compras  = new comprasModel;
            $compras->id = $_POST['idCompra'];
            $compras->fecha = $_POST['fecha'];
            if (!$compras->codi_agregar_fecha_entrega_prove()) {
                json_output(json_build(400, null, 'Hubo error al guardar los cambios'));
            }

            // se guardó con éxito
            json_output(json_build(200, null, 'Proveedor actualizado con éxito'));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }


    //-------------------------------AGENTES---------------------------------------------------------
    function codi_get_agentes()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);
        error_reporting(E_ALL);

        try {
            $ag  = new agentesModel();
            $agentes = $ag->all();
            $data = get_module('selectagentes', $agentes);
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }
    //------------------------------CATEGORIAS---------------------------------------------------------
    function codi_get_categorias()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {

            $categoria = new categoriasModel;
            $categorias = $categoria->all();
            $data = get_module('tablacategorias', $categorias);
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_categorias_json()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {

            $categoria = new categoriasModel;
            $categorias = $categoria->all();
            json_output(json_build(200, $categorias));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_get_subcategorias()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {

            $subcategoria = new categoriasModel;
            $subcategorias = $subcategoria->allsub();
            $data = get_module('tablasubcategorias', $subcategorias);
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_add_categoria()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $categoria = new categoriasModel();
            $categoria->catNombre = $_POST['catNombre'];
            $categoria->catEstatus = $_POST['catEstatus'];

            if (!$id = $categoria->add()) {
                json_output(json_build(400, null, 'Hubo un error al guardar el registro'));
            }

            $categoria->catId = $id;
            json_output(json_build(201, null, 'Categoría agregada con exito'));
        } catch (Exception $e) {
            throw json_output(json_build(400, null, $e->getMessage()));
        }
    }

    function codi_add_subcategoria()
    {ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);

        try {
            $categoria = new categoriasModel();
            $categoria->subCategoriaNombre = $_POST['subcatNombre'];
            $categoria->catId = $_POST['Idcat'];
            $catNombre = $categoria->oneCat($_POST['Idcat']);
            $categoria->catNombre = $catNombre[0]['catNombre'];

            if (!$id = $categoria->addSub()) {
                json_output(json_build(400, null, 'Hubo un error al guardar el registro'));
            }

            $categoria->catId = $id;
            json_output(json_build(201, null, 'Categoría agregada con exito'));
        } catch (Exception $e) {
            throw json_output(json_build(400, null, $e->getMessage()));
        }
    }

    function codi_update_categoria()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $categoria  = new categoriasModel;
            $categoria->catId = $_POST['id'];
            $categoria->catNombre = $_POST['nombre'];
            //$usuario->almEstatus = $_POST['estatus'];
            if (!$categoria->update()) {
                json_output(json_build(400, null, 'Hubo error al guardar los cambios'));
            }

            json_output(json_build(200, null, 'Almacén actualizado con éxito'));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_update_subcategoria()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {

            $categoria  = new categoriasModel;
            $categoria->subcatId = $_POST['idsubcat'];
            $categoria->subCategoriaNombre = $_POST['nombresubcat'];
            $categoria->catId = $_POST['categoriaid'];
            $catNombre = $categoria->oneCat($_POST['categoriaid']);
            $categoria->catNombre = $catNombre[0]['catNombre'];
            if (!$categoria->updatesubcat()) {
                json_output(json_build(400, null, 'Hubo error al guardar los cambios'));
            }

            json_output(json_build(200, null, 'Almacén actualizado con éxito'));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }



    function codi_delete_categoria()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);

        try {
            $categoria  = new categoriasModel;
            $categoria->catId = $_POST['catId'];

            if (!$categoria->delete()) {
                json_output(json_build(400, null, 'Hubo error al guardar los cambios'));
            }

            // se guardó con éxito
            json_output(json_build(200, null, 'Categoria eliminada con éxito'));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }


    function codi_delete_subcategoria()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);

        try {
            $categoria  = new categoriasModel;
            $categoria->subcatId = $_POST['catId'];

            if (!$categoria->deletesub()) {
                json_output(json_build(400, null, 'Hubo error al guardar los cambios'));
            }

            // se guardó con éxito
            json_output(json_build(200, null, 'Categoria eliminada con éxito'));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }
    //-------------------------------EXTINTORES---------------------------------------------------------
    function codi_get_extintores()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $ex  = new extintoresModel;
            $extintores = $ex->all();
            $data = get_module('tablaextintores', $extintores);
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_add_extintor()
    {
        //ini_set('display_errors', 1);
        //ini_set('display_startup_errors', 1);
        error_reporting(E_ERROR);
        try {
            $extintores = new extintoresModel();
            $extintores->ClaveExtintor = random_strings(10);
            $extintores->IdProducto = $_POST['producto'];
            $extintores->FolioOrden = $_POST['orden'];
            $extintores->Ubicacion = $_POST['ubicacion'];
            $extintores->IdCliente = $_POST['cliente'];
            $extintores->FechaEntrega = $_POST['fechaentrega'];
            if ($_POST['orden']) {
                $extintores->Estatus = 1;
            } else {
                $extintores->Estatus = 2;
            }

            if (!$id = $extintores->add()) {
                json_output(json_build(400, null, 'Hubo un error al guardar el registro'));
            }

            $extintores->IdExtintor = $id;
            json_output(json_build(201, $extintores->one(), 'Extintor agregado con exito'));
        } catch (Exception $e) {
            throw json_output(json_build(400, null, $e->getMessage()));
        }
    }


    function codi_update_extintor()
    {
        //ini_set('display_errors', 1);
        //ini_set('display_startup_errors', 1);
        error_reporting(E_ERROR);
        try {
            $extintores = new extintoresModel();
            $extintores->IdExtintor = $_POST['Uidextintor'];
            $extintores->ClaveExtintor = $_POST['Uclaveextintor'];
            $extintores->IdProducto = $_POST['Uproducto'];
            $extintores->FolioOrden = $_POST['Uorden'];
            $extintores->Ubicacion = $_POST['Uubicacion'];
            $extintores->IdCliente = $_POST['Ucliente'];
            $extintores->FechaEntrega = $_POST['Ufechaentrega'];
            $extintores->Estatus = $_POST['Uestatus'];

            if (!$id = $extintores->update()) {
                json_output(json_build(400, null, 'Hubo un error al actualizar el registro'));
            }

            $extintores->IdExtintor = $id;
            json_output(json_build(201, $extintores->one(), 'Extintor actualizado con éxito'));
        } catch (Exception $e) {
            throw json_output(json_build(400, null, $e->getMessage()));
        }
    }

    function codi_update_extintor_baja()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);
        error_reporting(E_ERROR);
        try {
            $bajas = new bajasModel();
            $motivos = new motivosBajaModel();
            $extintores = new extintoresModel();
            $ordenesbaja = new ordenesModel();

            $bajas->FolioOrden = $_POST['BFolioOrden'];
            $bajas->ClaveExtintor = $_POST['BClaveExtintor'];
            $bajas->IdMotivo = $_POST['bmotivo'];
            $bajas->FechaBaja = date('Y-m-d');
            $bajas->Observacion = $_POST['BObservacion'];
            $usuario = $_SESSION['usuario']['idusu'];
            $bajas->Usuario = $usuario;
            $ordenesbaja->FolioOrden = $_POST['BFolioOrden'];
            $ordenesbaja->Partida = $_POST['BPartida'];

            if ($_POST['bmotivo'] == 6) {
                $motivos->Descripcion = $_POST['bOtroMotivo'];
                $bajas->IdMotivo = $motivos->add();
            }

            $extintores->IdExtintor = $_POST['BIdExtintor'];
            $extintores->Estatus = 5;

            if (!$id = $extintores->baja()) {
                json_output(json_build(400, null, 'Hubo un error al dar de baja el extintor. Error: Actualizar Estatus.'));
            }

            if (!$bajas->add()) {
                json_output(json_build(400, null, 'Hubo un error al dar de baja el extintor. Error: Agregar registro de la baja.'));
            }
            if (!$ordenesbaja->baja_danado_producto()) {
                json_output(json_build(400, null, 'Hubo un error al dar de baja el extintor. Error: Agregar registro de la baja.'));
            }
            $extintores->IdExtintor = $id;
            json_output(json_build(201, $extintores->one(), 'Extintor dado de baja con éxito'));
        } catch (Exception $e) {
            throw json_output(json_build(400, null, $e->getMessage()));
        }
    }
    //-------------------------------CONFIGURACION DE DESCUENTOS---------------------------------------------------------
    function codi_get_descuentos()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $noti  = new descuentosModel;
            $notis = $noti->all();
            $data = get_module('tabladescuentos', $notis);
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_add_descuento()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        //error_reporting(E_ALL);
        try {
            $descuento = new descuentosModel();
            $descuento->Departamento = $_POST['crearDepartamento'];
            $descuento->Descuento = $_POST['crearDescuento'];
            $IdDescuento = $descuento->add();

            if (!$IdDescuento) {
                json_output(json_build(400, null, 'Hubo un error al guardar el descuento.'));
            }
            json_output(json_build(201, $descuento, 'Descuento agregado con exito'));
        } catch (Exception $e) {
            throw json_output(json_build(400, null, $e->getMessage()));
        }
    }

    function codi_update_descuento()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $descuento  = new descuentosModel;
            $descuento->Descuento = $_POST['EdDescuento'];
            $descuento->IdDescuento = $_POST['iddescuento'];
            $IdDescuento = $descuento->update();

            if (!$IdDescuento) {
                json_output(json_build(400, null, 'Hubo error al guardar los cambios'));
            } else {
                // se guardó con éxito
                json_output(json_build(200, $descuento->one(), 'Descuento actualizado con éxito'));
            }
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_delete_descuento()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $descuento  = new descuentosModel;
            $descuento->IdDescuento = $_POST['iddescuento'];
            $IdDescuento = $descuento->delete();

            if (!$IdDescuento) {
                json_output(json_build(400, null, 'Hubo error al eliminar el descuento'));
            } else {
                // se guardó con éxito
                json_output(json_build(200, $descuento->one(), 'Descuento eliminado con éxito'));
            }
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }
    //-------------------------------NOTIFICAIONES---------------------------------------------------------
    function codi_get_notificaciones()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $noti  = new notificacionesModel;
            $noti->Departamento = $_POST['departamento'];
            $notis = $noti->all();
            $data = get_module('tablanotificaciones', $notis);
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }


    function codi_get_notificaciones_usu()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $noti  = new notificacionesModel;
            $noti->Departamento = $_POST['departamento'];
            $notis = $noti->allone();

            json_output(json_build(200, $notis));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_delete_compra()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);

        try {
            $usuario  = new comprasModel;
            $usuario->id = $_POST['id'];
            $usuario->estado = $_POST['estado'];
            $ordenes = new ordenesModel;
            if (!$usuario->delete()) {
                json_output(json_build(400, null, 'Hubo error al guardar los cambios'));
            }
               $ordenes->IdOrden = $_POST['idOrden'];
            if (!$ordenes->updateorden_desde_compra_cancelada()) {
                json_output(json_build(400, null, 'Hubo error al cambiar de estatus los cambios'));
            }

            // se guardó con éxito
            json_output(json_build(200, null, 'Compra cancelada con éxito'));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }


    function codi_get_proveedores()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $producto  = new proveedoresModel;
            $productos = $producto->all();
            $data = get_module('tablaproveedores', $productos);
            json_output(json_build(200, $data));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }


    function codi_update_producto_compra()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $producto  = new productosModel;
            $producto->proId = $_POST['proId'];
            $producto->cantidad = $_POST['cantidad'];

            if (!$producto->update_producto_compra()) {
                json_output(json_build(400, null, 'Hubo error al guardar los cambios'));
            }

            // se guardó con éxito
            json_output(json_build(200, null, 'Compra agregada al almacén con éxito'));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_update_producto_compra_detalle()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $producto  = new comprasModel;
            $producto->id = $_POST['id'];
            $producto->recibido = $_POST['cantidad'];

            if (!$producto->update_estado_compra_detalle()) {
                json_output(json_build(400, null, 'Hubo error al actualizar cantidad recibida'));
            }

            // se guardó con éxito
            json_output(json_build(200, null, 'Cantidad recibida actualizado'));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function cambiarproveedorgeneral(){
         ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $producto  = new comprasModel;

            $producto->iddetalle = $_POST['idordendetalle'];
            $producto->idProveedor = $_POST['idProveedor'];
            $producto->numeroprov = $_POST['numeroprov'];
        
            if (!$producto->cambiar_proveedor_general()) {
                json_output(json_build(400, null, 'Hubo error al actualizar el proveedor recibida'));
            }

            // se guardó con éxito
            json_output(json_build(200, null, 'Proveedor actualizado'));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function cambiarproveedorunitario(){
         ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $producto  = new comprasModel;

            $producto->iddetalle = $_POST['idordendetalle'];
            $producto->idProveedor = $_POST['idProveedor'];
            $producto->partida = $_POST['partida'];
            $producto->numeroprov = $_POST['numeroprov'];

            if (!$producto->cambiarproveedor_unitario()) {
                json_output(json_build(400, null, 'Hubo error al actualizar el proveedor recibida'));
            }

            // se guardó con éxito
            json_output(json_build(200, null, 'Proveedor actualizado'));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_update_estado_compra()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $producto  = new comprasModel;
            $producto->id = $_POST['id'];

            if (!$producto->update_estado_compra()) {
                json_output(json_build(400, null, 'Hubo error al guardar los cambios'));
            }

            // se guardó con éxito
            json_output(json_build(200, null, 'Compra agregada al almacén con éxito'));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

     function codi_update_llave()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {

            $tipo = $_POST['tipoordenval'];
            $idorden = $_POST['idordenval'];
            $texto = "";
            if($tipo == 0){
                $llave = new cotizacionesModel();
                $llave->autorizacionOrden = 1;
                $llave->llaveOrdenAutorizacion = $this->generarCodigo(20);
                $llave->IdCotizacion = $idorden;
                $texto = "Cotización aceptada correctamente";
            }else{
                $llave = new ordenesModel();
                $llave->autorizacionOrden = 1;
                $llave->llaveOrdenAutorizacion = $this->generarCodigo(20);
                $llave->IdOrden = $idorden;
                $texto = "Orden aceptada correctamente";
            }

            if (!$llave->updatellave()) {
                json_output(json_build(400, null, 'No se puedo actualizar llave favor de marcar con el vendedor'));
            }

            // se guardó con éxito
            json_output(json_build(200, null, $texto));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }
    function codi_update_taller()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $idorden = $_POST['idordenval'];
             $taller = new ordenesModel();
             $taller->IdOrden = $idorden;
            if (!$taller->updateordentaller()) {
                json_output(json_build(400, null, 'No se puedo autorizar la orden favor de revisar con sistemas'));
            }

            // se guardó con éxito
            json_output(json_build(200, null, "Orden autorizada de taller correctamente"));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_update_prefcursos_cot()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $IdCotizacion = $_POST['IdCotizacion'];
            $alimentosli = $_POST['alimentosli'];
            $transporteli = $_POST['transporteli'];
            $dc3li = $_POST['dc3li'];
            $textocursos = $_POST['textocursos'];

             $cursos = new cotizacionesModel();
             $cursos->IdCotizacion = $IdCotizacion;
             $cursos->alimentosli = $alimentosli;
             $cursos->transporteli = $transporteli;
             $cursos->dc3li = $dc3li;
             $cursos->textocursos = $textocursos;
            if (!$cursos->update_cursos()) {
                json_output(json_build(400, null, 'No se puedo actualizar el curso'));
            }

            // se guardó con éxito
            json_output(json_build(200, null, "Curso actualizado correctamente"));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_update_prefcursos_ord()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $IdOrden = $_POST['IdOrden'];
            $alimentosli = $_POST['alimentosli'];
            $transporteli = $_POST['transporteli'];
            $dc3li = $_POST['dc3li'];
            $textocursos = $_POST['textocursos'];

             $cursos = new ordenesModel();
             $cursos->IdOrden = $IdOrden;
             $cursos->alimentosli = $alimentosli;
             $cursos->transporteli = $transporteli;
             $cursos->dc3li = $dc3li;
             $cursos->textocursos = $textocursos;
            if (!$cursos->update_cursos()) {
                json_output(json_build(400, null, 'No se puedo actualizar el curso'));
            }

            // se guardó con éxito
            json_output(json_build(200, null, "Curso actualizado correctamente"));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function codi_vendedores_datos(){
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        try {
            $fechaInicio = $_POST['fechaInicio'];
            $fechaFinal = $_POST['fechaFinal'];
             $ordenes = new ordenesModel();
             $ordenes->FechaInicio = $fechaInicio;
             $ordenes->FechaTermino = $fechaFinal;
             $ordenes = $ordenes->vendedoresdatos();
            json_output(json_build(200, $ordenes));
            
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    //KPI productos

    function kpi_productos_3m(){
        try {
             $producto = new productosModel();
             $productos = $producto->kpiglobalsql();
            json_output(json_build(200, $productos));
            
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function tendencia_mensual_3m(){
        try {
             $producto = new productosModel();
             $productos = $producto->tendenciamensualsql();
            json_output(json_build(200, $productos));
            
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function ventas_almacen_3m_summary(){
        try {
             $producto = new productosModel();
             $productos = $producto->ventasporalmacensql();
            json_output(json_build(200, $productos));
            
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }
    function tendencia_almacen_3m(){
        try {
             $producto = new productosModel();
             $productos = $producto->tendenciaalmacensql();
            json_output(json_build(200, $productos));
            
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }
    function top10_sku_3m(){
        try {
             $producto = new productosModel();
             $productos = $producto->masvendidossql();
            json_output(json_build(200, $productos));
            
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }
    function sin_ventas_3m(){
        try {
             $producto = new productosModel();
             $productos = $producto->sinventasql();
            json_output(json_build(200, $productos));
            
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }
    function ventas_sku_almacen_3m(){
        try {
             $producto = new productosModel();
             $productos = $producto->ventasxskualmacensql();
            json_output(json_build(200, $productos));
            
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }
    function promos_activas_hoy(){
        try {
             $producto = new productosModel();
             $productos = $producto->promoactivashoysql();
            json_output(json_build(200, $productos));
            
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }
    function salud_inventario_sku(){
        try {
             $producto = new productosModel();
             $productos = $producto->saludinventarioskuql();
            json_output(json_build(200, $productos));
            
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }
    function salud_inventario_almacen(){
        try {
             $producto = new productosModel();
             $productos = $producto->salud_inventario_almacensql();
            json_output(json_build(200, $productos));
            
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function top_vendidos_stock_3m(){
        try {
             $producto = new productosModel();
             $productos = $producto->vendidos_stock_top_3m();
            json_output(json_build(200, $productos));
            
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }
    function sin_ventas_stock_3m(){
        try {
             $producto = new productosModel();
             $productos = $producto->sin_ventas_stock();
            json_output(json_build(200, $productos));
            
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function kpi_ordenes_3m(){
        try {
             $orden = new ordenesModel();
             $ordenes = $orden->kpi_ordenes_3m_reporte();
            json_output(json_build(200, $ordenes));
            
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }   
    function tendencia_ordenes_mensual_3m(){
        try {
             $orden = new ordenesModel();
             $ordenes = $orden->tendencia_ordenes_mensual_3m_reporte();
            json_output(json_build(200, $ordenes));
            
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }
    function top10_clientes_3m(){
        try {
             $orden = new ordenesModel();
             $ordenes = $orden->top10_clientes_3m_reporte();
            json_output(json_build(200, $ordenes));
            
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }
    function productos_top_clientes_3m(){
        try {
             $orden = new ordenesModel();
             $ordenes = $orden->productos_top_clientes_3m_reporte();
            json_output(json_build(200, $ordenes));
            
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }
    function totales_transito_3m(){
        try {
             $orden = new ordenesModel();
             $ordenes = $orden->totales_transito_3m_reporte();
            json_output(json_build(200, $ordenes));
            
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }
    function detalle_transito_3m(){
        $deptoId   = (int)($_POST['depto_id'] ?? 0);
        $estatusId = (int)($_POST['estatus_id'] ?? 0);
        try {
             $orden = new ordenesModel();
             $orden->deptoId = $deptoId;
             $orden->estatusId = $estatusId;
             $ordenes = $orden->detalle_transito_3m_reporte();
            json_output(json_build(200, $ordenes));
            
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }
    function totales_estatus_orden_3m(){
        try {
             $orden = new ordenesModel();
             $ordenes = $orden->totales_estatus_orden_3m_reporte();
            json_output(json_build(200, $ordenes));
            
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }
    function detalle_estatus_orden_3m(){
       $deptoId   = (int)($_POST['depto_id'] ?? 0);
        $estatusId = (int)($_POST['estatus_id'] ?? 0);
        try {
             $orden = new ordenesModel();
             $orden->deptoId = $deptoId;
             $orden->estatusId = $estatusId;
             $ordenes = $orden->detalle_estatus_orden_3m_reporte();
            json_output(json_build(200, $ordenes));
            
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }
    function ordenes_por_vendedor_3m(){
        try {
             $orden = new ordenesModel();
             $ordenes = $orden->ordenes_por_vendedor_3m_reporte();
            json_output(json_build(200, $ordenes));
            
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }
    function ordenes_vendedor_categoria_3m(){
        try {
             $orden = new ordenesModel();
             $ordenes = $orden->ordenes_vendedor_categoria_3m_reporte();
            json_output(json_build(200, $ordenes));
            
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }
    function ordenes_por_tipo_orden_3m(){
        try {
             $orden = new ordenesModel();
             $ordenes = $orden->ordenes_por_tipo_orden_3m_reporte();
            json_output(json_build(200, $ordenes));
            
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function ordenes_recarga_mantenimiento_recall(){
        try {
             $orden = new ordenesModel();
             $ordenes = $orden->ordenes_recarga_mantenimiento_recall_reporte();
            json_output(json_build(200, $ordenes));
            
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function detalle_orden_by_id(){
        $deptoId   = (int)($_POST['id_orden'] ? $_POST['id_orden'] : $_POST['IdOrden']);
        try {
             $orden = new ordenesModel();
             $orden->IdOrden = $deptoId;
             $ordenes = $orden->detalle_orden_by_id_reporte();
            json_output(json_build(200, $ordenes));
            
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function unsold_sku_6m(){
        try {
             $orden = new productosModel();
             $ordenes = $orden->unsold_sku_6m_reporte();
            json_output(json_build(200, $ordenes));
            
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function unsold_sku_almacen_6m(){
        try {
             $orden = new productosModel();
             $ordenes = $orden->unsold_sku_almacen_6m_reporte();
            json_output(json_build(200, $ordenes));
            
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function top_sellers_by_category_3m(){
        try {
             $orden = new productosModel();
             $ordenes = $orden->top_sellers_by_category_3m_reporte();
            json_output(json_build(200, $ordenes));
            
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function last_sale_date_sku(){
        try {
             $orden = new productosModel();
             $ordenes = $orden->last_sale_date_sku_reporte();
            json_output(json_build(200, $ordenes));
            
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }
    
    
    //Funciones caja

    function caja_check_prevday(){
         try {
             $orden = new cajaModel();
             $orden->IdUsuario = $_POST['IdUsuario'];
             $orden->Departamento = $_POST['Departamento'];
             $ordenes = $orden->caja_check_prevday_model();
            json_output(json_build(200, $ordenes));
            
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }


    function caja_open(){
        try {
            $orden = new cajaModel();
            $orden->IdUsuario    = $_POST['IdUsuario'];
            $orden->Departamento = $_POST['Departamento'];
            // fecha_dia la envías desde el front, o por defecto hoy (YYYY-mm-dd)
            $orden->dia          = $_POST['fecha_dia'] ?? date('Y-m-d');
            $orden->Saldoinicial = $_POST['saldo_inicial'];
            $ordenes = $orden->caja_open_model();
            json_output(json_build(200, $ordenes));
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }


    function caja_session_today(){
         try {
             $orden = new cajaModel();
              $orden->IdUsuario = $_POST['IdUsuario'];
             $orden->Departamento = $_POST['Departamento'];
             $ordenes = $orden->caja_session_today_model();
            json_output(json_build(200, $ordenes));
            
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function caja_ordenes_hoy(){
         try {
             $orden = new cajaModel();
             $orden->IdUsuario = $_POST['IdUsuario'];
             $orden->Departamento = $_POST['Departamento'];
             $orden->idSesion =  isset($_POST['idSesion']) ? (int)$_POST['idSesion'] : 0;
             $orden->ini = $_POST['ini'];
             $orden->fin = $_POST['fin'];
             $ordenes = $orden->caja_ordenes_hoy_model();
            json_output(json_build(200, $ordenes));
            
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function caja_eliminadas_hoy(){
         try {
             $orden = new cajaModel();
             $orden->IdUsuario = $_POST['IdUsuario'];
             $orden->ini = $_POST['ini'];
             $orden->fin = $_POST['fin'];
             $ordenes = $orden->caja_eliminadas_hoy_model();
            json_output(json_build(200, $ordenes));
            
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function caja_resumen_pagos_hoy(){
         try {
             $orden = new cajaModel();
             $orden->IdUsuario = $_POST['IdUsuario'];
             $orden->ini = $_POST['ini'];
             $orden->fin = $_POST['fin'];
             $ordenes = $orden->caja_resumen_pagos_hoy_model();
            json_output(json_build(200, $ordenes));
            
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function caja_sin_tipo_hoy(){
         try {
             $orden = new cajaModel();
             $orden->IdUsuario = $_POST['IdUsuario'];
             $orden->ini = $_POST['ini'];
             $orden->fin = $_POST['fin'];
             $ordenes = $orden->caja_sin_tipo_hoy_model();
            json_output(json_build(200, $ordenes));
            
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function caja_movs_hoy(){
         try {
             $orden = new cajaModel();
             $orden->idSesion = $_POST['idSesion'];
             $ordenes = $orden->caja_movs_hoy_model();
            json_output(json_build(200, $ordenes));
            
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function caja_add_mov(){
         try {
             $orden = new cajaModel();
             $orden->idSesion = $_POST['idSesion'];
             $orden->tipo = $_POST['tipo'];
             $orden->IdOrden = $_POST['IdOrden'];
             $orden->IdDetalle = $_POST['IdDetalle'];
             $orden->concepto = $_POST['concepto'];
             $orden->TipoPago = $_POST['TipoPago'];
             $orden->origen = $_POST['origen'] ?? 'manual';
             $orden->monto = $_POST['monto'];
             $orden->creado_por = $_POST['creado_por'];
             $ordenes = $orden->caja_add_mov_model();
            json_output(json_build(200, $ordenes));
            
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function caja_solicitar_cierre(){
         try {
             $orden = new cajaModel();
             $orden->idSesion = $_POST['idSesion'];
             $orden->IdUsuario = $_POST['IdUsuario'];
             $orden->resumen_json = $_POST['resumen_json'];
             $ordenes = $orden->caja_solicitar_cierre_model();
            json_output(json_build(200, $ordenes));
            
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function caja_listar_solicitudes(){
         try {
             $orden = new cajaModel();
             $ordenes = $orden->caja_listar_solicitudes_model();
            json_output(json_build(200, $ordenes));
            
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function caja_aprobar_cierre(){
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
         try {
             $orden = new cajaModel();
              $orden->idSolicitud  = (int)($_POST['idSolicitud'] ?? 0);
              $orden->idSesion  = (int)($_POST['idSesion'] ?? 0);     // por seguridad desde el front
              $orden->resuelto_por = (int)($_POST['resuelto_por'] ?? 0);
              $orden->diffs_json   = $_POST['diffs_json'] ?? '[]';       // opcional (si el front lo manda)
             $ordenes = $orden->caja_aprobar_cierre_model();
            json_output(json_build(200, $ordenes));
            
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function caja_rechazar_cierre(){
         try {
             $orden = new cajaModel();
              $orden->idSolicitud = $_POST['idSolicitud'];
             $orden->resuelto_por = $_POST['resuelto_por'];
             $orden->obs_supervisor = $_POST['obs'];
             $ordenes = $orden->caja_rechazar_cierre_model();
            json_output(json_build(200, $ordenes));
            
        } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function caja_sesiones_abiertas(){
    try {
        $orden = new cajaModel();
        $orden->IdUsuario    = $_POST['IdUsuario'];
        $orden->Departamento = $_POST['Departamento'];
        $ordenes = $orden->caja_sesiones_abiertas_model();
        json_output(json_build(200, $ordenes));
    } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function orden_actualizar_pago_manual(){
    try {
        $m = new cajaModel(); // o tu ordenesModel; usa el que prefieras
        $m->IdOrden        = (int)$_POST['IdOrden'];
        $m->PagadoCompleto = (int)$_POST['PagadoCompleto']; // 11,12 o 3
        $m->TipoPago       = $_POST['TipoPago'] ?? '';
        $ok = $m->orden_actualizar_pago_manual_model();
        json_output(json_build(200, $ok));
    } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function caja_listar_solicitudes_rechazadas(){
    try {
        $m = new cajaModel(); // o tu ordenesModel; usa el que prefieras
        $ok = $m->caja_listar_solicitudes_rechazadas_model();
        json_output(json_build(200, $ok));
    } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function caja_last_discrepancia(){
    try {
        $m = new cajaModel(); // o tu ordenesModel; usa el que prefieras
        $m->IdUsuario = $_POST['IdUsuario'];
        $ok = $m->caja_last_discrepancia_model();
        json_output(json_build(200, $ok));
    } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function caja_discrepancias_list(){
    try {
        $m = new cajaModel(); // o tu ordenesModel; usa el que prefieras
        $m->IdUsuario = $_POST['IdUsuario'];
        $m->ini = $_POST['fini'];
        $m->fin = $_POST['ffin'];
        $ok = $m->caja_discrepancias_list_model();
        json_output(json_build(200, $ok));
    } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function caja_listar_solicitudes_hist(){
    try {
        $m = new cajaModel(); // o tu ordenesModel; usa el que prefieras
        $ok = $m->caja_listar_solicitudes_hist_model();
        json_output(json_build(200, $ok));
    } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

    function caja_last_cierre(){
        $IdUsuario = (int)($_POST['IdUsuario'] ?? 0);
    try {
        $m = new cajaModel(); // o tu ordenesModel; usa el que prefieras
        $m->IdUsuario = $IdUsuario;
        $ok = $m->caja_last_cierre_model();
        json_output(json_build(200, $ok));
    } catch (Exception $e) {
            json_output(json_build(400, $e->getMessage()));
        }
    }

function reparto_ordenes_pendientes(){
    ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);
    error_reporting(E_ALL);
    try {
        $orden = new repartoModel();
        $orden->FechaInicio = $_POST['ini'] ?? null;   // opcional
        $orden->FechaTermino = $_POST['fin'] ?? null;  // opcional
        $rows = $orden->reparto_ordenes_pendientes_model();
        json_output(json_build(200, $rows));
    } catch (Exception $e) {
        json_output(json_build(400, $e->getMessage()));
    }
}

function reparto_ordenes_asignadas(){
    ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);
    error_reporting(E_ALL);
    try {
        $orden = new repartoModel();
        $orden->Departamento = isset($_POST['Departamento']) ? (int)$_POST['Departamento'] : 0; // 14/22 (opcional)
        $orden->IdUsuario    = isset($_POST['IdUsuario']) ? (int)$_POST['IdUsuario'] : 0;       // filtrar por repartidor (opcional)
        $rows = $orden->reparto_ordenes_asignadas_model();
        json_output(json_build(200, $rows));
    } catch (Exception $e) {
        json_output(json_build(400, $e->getMessage()));
    }
}

function reparto_repartidores_list(){
    ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);
    error_reporting(E_ALL);
    try {
        $orden = new repartoModel();
        $orden->Departamento = isset($_POST['Departamento']) ? (int)$_POST['Departamento'] : 0; // 14 o 22 (opcional)
        $rows = $orden->reparto_repartidores_model();
        json_output(json_build(200, $rows));
    } catch (Exception $e) {
        json_output(json_build(400, $e->getMessage()));
    }
}

function reparto_asignar_orden(){
    ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);
    error_reporting(E_ALL);
    try {
        $orden = new repartoModel();
        $orden->IdOrden         = (int)($_POST['IdOrden'] ?? 0);
        $orden->Departamento    = (int)($_POST['Departamento'] ?? 0); // 14 o 22
        $orden->IdUsuario       = (int)($_POST['IdUsuario'] ?? 0);    // repartidor
        $orden->IdUsuarioAccion = (int)($_POST['user'] ?? 0);         // quién asigna
        $ok = $orden->reparto_asignar_orden_model();
        json_output(json_build(200, $ok));
    } catch (Exception $e) {
        json_output(json_build(400, $e->getMessage()));
    }
}

function reparto_en_ruta(){
    ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);
    error_reporting(E_ALL);
    try {
        $orden = new repartoModel();
        $orden->IdOrden         = (int)($_POST['IdOrden'] ?? 0);
        $orden->IdUsuarioAccion = (int)($_POST['user'] ?? 0);
        $ok = $orden->reparto_en_ruta_model();
        json_output(json_build(200, $ok));
    } catch (Exception $e) {
        json_output(json_build(400, $e->getMessage()));
    }
}

function reparto_reasignar(){
    ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);
    error_reporting(E_ALL);
    try {
        $orden = new repartoModel();
        $orden->IdOrden         = (int)($_POST['IdOrden'] ?? 0);
        $orden->Departamento    = (int)($_POST['Departamento'] ?? 0); // 14/22
        $orden->IdUsuario       = (int)($_POST['IdUsuario'] ?? 0);    // nuevo repartidor
        $orden->IdUsuarioAccion = (int)($_POST['user'] ?? 0);
        $ok = $orden->reparto_reasignar_model();
        json_output(json_build(200, $ok));
    } catch (Exception $e) {
        json_output(json_build(400, $e->getMessage()));
    }
}

function reparto_devolver_almacen(){
    ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);
    error_reporting(E_ALL);
    try {
        $orden = new repartoModel();
        $orden->IdOrden         = (int)($_POST['IdOrden'] ?? 0);
        $orden->Motivo          = $_POST['motivo'] ?? 'Devuelto a almacén';
        $orden->IdUsuarioAccion = (int)($_POST['user'] ?? 0);
        $ok = $orden->reparto_devolver_almacen_model();
        json_output(json_build(200, $ok));
    } catch (Exception $e) {
        json_output(json_build(400, $e->getMessage()));
    }
}

/* ===================== Controlador AJAX (endpoints nuevos) ===================== */

// Taller AJAX controller (hook=codi_hook, action=load)

function taller_ordenes_en_taller(){
    ini_set('display_errors', 1); ini_set('display_startup_errors', 1); error_reporting(E_ALL);
    try {
        $m = new tallerModel();
        $m->TipoOrden = (int)($_POST['TipoOrden'] ?? 2); // 2 o 8
        $rows = $m->taller_ordenes_en_taller_model();
        json_output(json_build(200, $rows));
    } catch (Exception $e) { json_output(json_build(400, $e->getMessage())); }
}

function taller_resguardo_list(){
    ini_set('display_errors', 1); ini_set('display_startup_errors', 1); error_reporting(E_ALL);
    try {
        $m = new tallerModel();
        $rows = $m->taller_resguardo_list_model();
        json_output(json_build(200, $rows));
    } catch (Exception $e) { json_output(json_build(400, $e->getMessage())); }
}

function taller_iniciar_trabajo(){
    ini_set('display_errors', 1); ini_set('display_startup_errors', 1); error_reporting(E_ALL);
    try {
        $m = new tallerModel();
        $m->IdOrden         = (int)($_POST['IdOrden'] ?? 0);
        $m->IdUsuarioAccion = (int)($_POST['user'] ?? 0);
        $ok = $m->taller_iniciar_trabajo_model();
        json_output(json_build(200, $ok));
    } catch (Exception $e) { json_output(json_build(400, $e->getMessage())); }
}

function taller_terminar_orden(){
    ini_set('display_errors', 1); ini_set('display_startup_errors', 1); error_reporting(E_ALL);
    try {
        $m = new tallerModel();
        $m->IdOrden         = (int)($_POST['IdOrden'] ?? 0);
        $m->IdUsuarioAccion = (int)($_POST['user'] ?? 0);
        $ok = $m->taller_terminar_orden_model();
        json_output(json_build(200, $ok));
    } catch (Exception $e) { json_output(json_build(400, $e->getMessage())); }
}

function taller_enviar_resguardo(){
    ini_set('display_errors', 1); ini_set('display_startup_errors', 1); error_reporting(E_ALL);
    try {
        $m = new tallerModel();
        $m->IdOrden         = (int)($_POST['IdOrden'] ?? 0);
        $m->Motivo          = $_POST['motivo'] ?? '';
        $m->Comentario      = $_POST['comentario'] ?? '';
        $m->IdUsuarioAccion = (int)($_POST['user'] ?? 0);
        $ok = $m->taller_enviar_resguardo_model();
        json_output(json_build(200, $ok));
    } catch (Exception $e) { json_output(json_build(400, $e->getMessage())); }
}

function taller_resumen_metrics(){
    ini_set('display_errors', 1); ini_set('display_startup_errors', 1); error_reporting(E_ALL);
    try {
        $m = new tallerModel();
        $m->FechaInicio = $_POST['ini'] ?? '';
        $m->FechaTermino= $_POST['fin'] ?? '';
        $rows = $m->taller_resumen_metrics_model();
        json_output(json_build(200, $rows));
    } catch (Exception $e) { json_output(json_build(400, $e->getMessage())); }
}


function dashboard_ventas_read()
{
    try {
        $m = new dashboardModel();

        // Rango de fechas desde el POST; si vienen vacías usa inicio de mes -> hoy
        $m->FechaInicio = (isset($_POST['fechaInicio']) && $_POST['fechaInicio'] !== '')
            ? $_POST['fechaInicio']
            : date('Y-m-01');

        $m->FechaFin = (isset($_POST['fechaFin']) && $_POST['fechaFin'] !== '')
            ? $_POST['fechaFin']
            : date('Y-m-d');

        $rows = $m->dashboard_ventas_read_model();

        json_output(json_build(200, $rows));
    } catch (Exception $e) {
        json_output(json_build(400, $e->getMessage()));
    }
}

function dashboard_tendencia_read() {
    try {

        $m = new dashboardModel();

        // ================================
        // CARGA DE FILTROS
        // ================================
        $m->Vendedor    = $_POST["vendedor"];
        $m->TipoOrden   = $_POST["tipo"];
        $m->FechaInicio = $_POST["fechaInicio"];
        $m->FechaFin    = $_POST["fechaFin"];

        $rows = $m->dashboard_tendencia_model();
        json_output(json_build(200, $rows));

    } catch (Exception $e){
        json_output(json_build(400, $e->getMessage()));
    }
}


function dashboard_donut_read() {
    try {

        $m = new dashboardModel();

        $m->Vendedor    = $_POST["vendedor"];
        $m->TipoOrden   = $_POST["tipo"];
        $m->FechaInicio = $_POST["fechaInicio"];
        $m->FechaFin    = $_POST["fechaFin"];

        $rows = $m->dashboard_donut_model();
        json_output(json_build(200, $rows));

    } catch (Exception $e){
        json_output(json_build(400, $e->getMessage()));
    }
}


function dashboard_stacked_read() {
    try {

        $m = new dashboardModel();

        $m->Vendedor    = $_POST["vendedor"];
        $m->TipoOrden   = $_POST["tipo"];
        $m->FechaInicio = $_POST["fechaInicio"];
        $m->FechaFin    = $_POST["fechaFin"];

        $rows = $m->dashboard_stacked_model();
        json_output(json_build(200, $rows));

    } catch (Exception $e){
        json_output(json_build(400, $e->getMessage()));
    }
}


function dashboard_ranking_read() {
    try {

        $m = new dashboardModel();

        $m->Vendedor    = $_POST["vendedor"];
        $m->TipoOrden   = $_POST["tipo"];
        $m->FechaInicio = $_POST["fechaInicio"];
        $m->FechaFin    = $_POST["fechaFin"];

        $rows = $m->dashboard_ranking_model();
        json_output(json_build(200, $rows));

    } catch (Exception $e){
        json_output(json_build(400, $e->getMessage()));
    }
}


function dashboard_get_vendedores_read() {
    try {
        $m = new dashboardModel();
        $rows = $m->dashboard_get_vendedores_model();
        json_output(json_build(200, $rows));    

    } catch (Exception $e){
        json_output(json_build(400, $e->getMessage()));
    }
}

/* ============================================================
   AJAX: BUSCAR PRODUCTOS
   ============================================================ */
function puntodeventa_productos(){
    try {

        $m = new puntodeventaModel();

        $m->buscar    = $_POST["buscar"] ?? "";
        $m->porNombre = $_POST["porNombre"] ?? 0;
        $m->tipoOrden = $_POST["tipoOrden"] ?? 1;

        $data = $m->buscarProductosPOS();
        json_output(json_build(200, $data));

    } catch (Exception $e) {
        json_output(json_build(400, $e->getMessage()));
    }
}


/* ============================================================
   AJAX: OBTENER PRODUCTO POR ID
   ============================================================ */
function puntodeventa_getProducto() {
    try {

        $id = $_POST["idProducto"] ?? 0;
        if (!$id) throw new Exception("Producto inválido.");

        $m = new puntodeventaModel();
        $m->idProd = $id;

        $p = $m->obtenerProductoPorID();
        if (!$p) throw new Exception("Producto no encontrado.");

        json_output(json_build(200, $p));

    } catch (Exception $e) {
        json_output(json_build(400, $e->getMessage()));
    }
}


/* ============================================================
   AJAX: BUSCAR CLIENTES
   ============================================================ */
function puntodeventa_clientes() {
    try {

        $buscar = $_POST["buscar"] ?? "";
        $porNombre = isset($_POST["porNombre"]) ? intval($_POST["porNombre"]) : 0;

        if (strlen($buscar) < 2) {
            throw new Exception("Ingrese al menos 2 caracteres.");
        }

        $m = new puntodeventaModel();
        $m->buscar = $buscar;
        $m->porNombre = $porNombre;

        $data = $m->buscarClientesPOS();

        json_output(json_build(200, $data));

    } catch (Exception $e) {
        json_output(json_build(400, $e->getMessage()));
    }
}


/* ============================================================
   AJAX: OBTENER DOMICILIOS
   ============================================================ */
function puntodeventa_domicilios() {
    try {

        if (!isset($_POST["idCliente"])) {
            throw new Exception("Cliente no recibido.");
        }

        $m = new puntodeventaModel();
        $m->idCliente = intval($_POST["idCliente"]);

        $data = $m->obtenerDomiciliosClientePOS();

        json_output(json_build(200, $data));

    } catch (Exception $e) {
        json_output(json_build(400, $e->getMessage()));
    }
}


/* ============================================================
   AJAX: CREAR ORDEN
   ============================================================ */
function puntodeventa_crearorden(){
    try {

        if (!isset($_POST["venta"])) {
            throw new Exception("Venta no recibida.");
        }

        $venta = json_decode($_POST["venta"], true);
        if (!$venta) {
            throw new Exception("Formato inválido en venta.");
        }

        /* MAPEAMOS IdDomicilio (tu JS envía EntId) */
        if (isset($venta["domicilio"]["EntId"])) {
            $venta["domicilio"]["IdDomicilio"] = $venta["domicilio"]["EntId"];
        }

        $m = new puntodeventaModel();
        $m->venta = $venta;

        $result = $m->crearOrden();

        json_output(json_build(200, $result));

    } catch (Exception $e) {
        json_output(json_build(400, $e->getMessage()));
    }
}

function puntodeventa_ordenesactivas() {
    ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
    try {

        $m = new puntodeventaModel();
        $m->idUsuario = $_SESSION['usuario']['idusu'] ?? 0;

        $data = $m->obtenerOrdenesActivasPOS();

        json_output(json_build(200, $data));

    } catch (Exception $e) {
        json_output(json_build(400, $e->getMessage()));
    }
}

function puntodeventa_getOrden() {
    try {

        if (!isset($_POST["idOrden"])) {
            throw new Exception("Orden no recibida.");
        }

        $id = intval($_POST["idOrden"]);

        $m = new puntodeventaModel();
        $m->idOrden = $id;

        $data = $m->obtenerOrdenCompletaPOS();

        json_output(json_build(200, $data));

    } catch (Exception $e) {
        json_output(json_build(400, $e->getMessage()));
    }
}

function puntodeventa_tmpGuardarUser()
{
    try {

        if (!isset($_POST["action"]) || $_POST["action"] !== "update") {
            throw new Exception("Acción inválida.");
        }

        if (!isset($_POST["venta"])) {
            throw new Exception("No se recibió información.");
        }

        $json = json_decode($_POST["venta"], true);
        if (!$json) {
            throw new Exception("Formato JSON inválido.");
        }

        $idUsuario = $_SESSION['usuario']['idusu'] ?? 0;
        if (!$idUsuario) {
            throw new Exception("Usuario no identificado.");
        }

        // MODELO
        $m = new puntodeventaModel();
        $m->idUsuario  = $idUsuario;

        // ARMADO DE JSON FINAL A GUARDAR
        $m->jsonData = json_encode([
            "cliente"    => $json["cliente"]     ?? null,
            "domicilio"  => $json["domicilio"]   ?? null,
            "carrito"    => $json["carrito"]     ?? [],
            "tipoOrden"  => intval($json["tipoOrden"] ?? 1),
            "metodoPago" => $json["metodoPago"]  ?? "01",
            "sinIVA"     => intval($json["sinIVA"] ?? 0)
        ], JSON_UNESCAPED_UNICODE);

        // GUARDAR
        $m->guardarTmp();

        json_output(json_build(200, "TMP guardado"));

    } catch (Exception $e) {
        json_output(json_build(400, $e->getMessage()));
    }
}



function puntodeventa_tmpgetuser() {
    try {


        $idUsuario = $_SESSION['usuario']['idusu'] ?? 0;
        if (!$idUsuario) {
            throw new Exception("Usuario no identificado.");
        }

        $m = new puntodeventaModel();
        $m->idUsuario = $idUsuario;

        $row = $m->obtenerOrdenTmpPorUsuario();

        // Si no hay borrador → regresar data null
        if (!$row || !isset($row["jsonData"])) {
            json_output(json_build(200, null));
            return;
        }

        json_output(json_build(200, [
            "jsonData" => $row["jsonData"],
            "FechaUpdate" => $row["FechaUpdate"] ?? null
        ]));

    } catch (Exception $e) {
        json_output(json_build(400, $e->getMessage()));
    }
}


function puntodeventa_tmpDeleteUser() {
    try {

        $idUsuario = $_SESSION['usuario']['idusu'] ?? 0;
        if (!$idUsuario) {
            throw new Exception("Usuario no identificado.");
        }

        $m = new puntodeventaModel();
        $m->idUsuario = $idUsuario;

        $m->eliminarOrdenTmpPorUsuario();

        json_output(json_build(200, "TMP eliminado"));

    } catch (Exception $e) {
        json_output(json_build(400, $e->getMessage()));
    }
}





}
