<?php
class MYPDF extends TCPDF
{
    //Page header
    public function Header()
    {
        // get the current page break margin
        $bMargin = $this->getBreakMargin();
        // get current auto-page-break mode
        $auto_page_break = $this->AutoPageBreak;
        // disable auto-page-break
        $this->SetAutoPageBreak(false, 0);
        // set bacground image
        $img_file =  'assets/img/images/formatos/hoja.png';
        $this->Image($img_file, 0, 0, 210, 297, '', '', '', false, 300, '', false, false, 0);
        // restore auto-page-break status
        $this->SetAutoPageBreak($auto_page_break, $bMargin);
        // set the starting point for the page content
        $this->setPageMark();
    }
}

class pdfController
{   var $Void = "";
    var $SP = " ";
    var $Dot = ".";
    var $Zero = "0";
    var $Neg = "Menos";

    function __construct()
    {
    }

    function index()
    {
       if(Csrf::validate($_SESSION['token'],true)){
            $valtoken = Csrf::validate($_SESSION['token'],true);
            //var_dump($valtoken);
        }else{
            $valtoken = Csrf::validate($_SESSION['token'],true);
            //var_dump($valtoken);
            Redirect::to('auths/logout');
        }
        $data = array();
        View::render('seleccion', $data);
    }
    //---------------------------------------------------------------------Módulo de imprimir QR--------------------------------------------------------------------
    //--Select de opción de imprimir con o sin precio
    //--Se debe poder elegir entre imprimir qr por producto o categoría
    //----Si es por categoría, crear un pdf con un montón de qr de cada producto que esté en esa categoría
    //-------Cuando la categoría sea extintores, poner un select para imprimir el qr de extintor o de producto
    //----Si es por producto, generar un solo qr en una hoja

    //conprecio: opción de imprimir con o sin precio
    //tipo: Si es por categoría o por producto
    //categoria: Categoría seleccionada de los productos
    //extintor: Cuando la categoría sea extintores, distinguir si se va a imprimir el qr de extintor o de producto
    //claveprod: cuando solo se imprima un qr, debe recibirse el valor del id del producto
    function pdfqr($tipo, $conprecio, $categoria, $extintor, $claveprod)
    {
        //ini_set('error_reporting', E_ALL);
        //ini_set('display_errors', true);

        //Variables y arreglos
        if ($tipo == 'producto') {
            //Producto 
            //Mostrar un solo qr, buscar por claveprod
            $prod = new productosModel();
            $prod->proId = $claveprod;
            $result = $prod->one();
            $p = to_object($result);
            $cards = "<h6>Etiqueta del Producto " . $p->proTitulo . "</h6>";
            $cards .=  pdfController::create_table(array($p), $conprecio, "producto");
        } else  if ($tipo == 'categoria') {
            //Categoría
            if ($categoria == 1 && $extintor == "extintor") {
                //Si es de la categoría extintores y quieren el qr del extintor
                //Mostrar una tabla de qrs
                $prod = new extintoresModel();
                $result = $prod->all();
                $p = to_object($result);
                $cards = "<h6>Etiquetas de Extintores</h6>";
                $cards .= pdfController::create_table_catextintores($p, $conprecio, "extintor");
            } else {
                //Mostrar una tabla de qrs por categoría
                $prod = new productosModel();
                $prod->proCatId = $categoria;
                $result = $prod->all_categoria();
                $p = to_object($result);
                $cards = "<h6>Etiquetas de Productos por Categoría</h6>";
                $cards .= pdfController::create_table($p, $conprecio, "producto");
            }
        }
        //echo $cards;

        // ---------------------------------------------------------
        // create new PDF document
        $pageLayout = array('215.9', '279.4'); //  or array($height, $width) 
        $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, $pageLayout, true, 'UTF-8', false);

        // set document information
        $pdf->SetKeywords('QR, PDF');

        // remove default header/footer
        $pdf->setPrintHeader(false);
        $pdf->setPrintFooter(false);

        // set margins
        $pdf->SetMargins("20", "20", "20");

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, "20");

        // set image scale factor
        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

        // set some language-dependent strings (optional)
        if (@file_exists(dirname(__FILE__) . '/lang/eng.php')) {
            require_once(dirname(__FILE__) . '/lang/eng.php');
            $pdf->setLanguageArray($l);
        }
        // ---------------------------------------------------------

        // set font
        $pdf->SetFont('helvetica', '', 12);
        // add a page
        $pdf->AddPage();
        // create some HTML content
        $html = $cards;
        // output the HTML content
        $pdf->writeHTML($html, true, false, true, false, '');

        //Close and output PDF document
        $pdf->Output('etiquetas.pdf', 'I');
    }

    function create_table($p, $conprecio, $extintor)
    {
        $cards = "";
        if ($p != null) {
            $total = count($p);
            $thisrow = 1;
            $limt = 5;
            $cols = 1;
            $row = "";
            $tabla = "";

            foreach ($p as $ps) {
                $sku = $ps->proSku;
                $nombre = $ps->proTitulo;

                if ($extintor == "extintor") {
                    $urlqr = crear_qr_extintor($sku, $ps, $conprecio);
                    $urlqr = str_replace(URL, "", $urlqr);
                } else {
                    $urlqr = crear_qr_card($sku, $ps, $conprecio);
                    $urlqr = str_replace(URL, "", $urlqr);
                }
                $imgs = '<th style="border:1px solid black;"><img src="' . $urlqr . '" /><b>' . $sku . "</b> - " . $nombre . '</th>';

                if ($total == $thisrow) {
                    $row .= $imgs;
                    $limt2 = $limt - $cols;
                    for ($i = 1; $i <= $limt2; $i++) {
                        $row .= '<th></th>';
                    }
                    $tabla .= '<tr>' . $row . '</tr>';
                } else if ($cols < $limt) {
                    $row .= $imgs;
                    $cols++;
                } else if ($cols >= $limt) {
                    $row .= $imgs;
                    $tabla .= '<tr>' . $row . '</tr>';
                    $cols = 1;
                    $row = "";
                }
                $thisrow++;
            }

            $cards =
                '<style>
                table, th, td {
                    font-size: 10px;
                    padding-top: 5px;
                }
                </style>
                <table style="width:100%; ">' . $tabla . ' </table>';
        }
        return $cards;
    }

    function create_table_catextintores($p, $conprecio, $extintor)
    {
        $cards = "";
        if ($p != null) {
            $total = count($p);
            $thisrow = 1;
            $limt = 2;
            $cols = 1;
            $row = "";
            $tabla = "";

            foreach ($p as $ps) {
                $sku = $ps->proSku;
                $nombre = $ps->proTitulo;
                $FolioOrden = $ps->FolioOrden;

                if ($extintor == "extintor") {
                    $urlqr = crear_qr_extintor($sku, $ps, $conprecio);
                    $urlqr = str_replace(URL, "", $urlqr);
                } else {
                    $urlqr = crear_qr_card($sku, $ps, $conprecio);
                    $urlqr = str_replace(URL, "", $urlqr);
                }
                $imgs = '<th style="border:1px solid black;">' .
                    '<table>' .
                    '<tr>' .
                    '<td>' .
                    '<img class="etiqueta" src="' . $urlqr . '"/>' .
                    '</td>' .
                    '<td>' .
                    '<table>' .
                    '<tr>' .
                    '<td>' .
                    " " .
                    '</td>' .
                    '</tr>' .
                    '<tr>' .
                    '<td>' .
                    $FolioOrden . " " .
                    '</td>' .
                    '</tr>' .
                    '<tr>' .
                    '<td>' .
                    " " .
                    '</td>' .
                    '</tr>' .
                    '</table>' .
                    '</td>' .
                    '<td>' .
                    '<table>' .
                    '<tr>' .
                    '<td>' .
                    '<img class="etiqueta" src="'  . 'assets/img/xtinf.png' . '"/>' .
                    '</td>' .
                    '</tr>' .
                    '<tr>' .
                    '<td>' .
                    $sku . " " .
                    $nombre . /*json_encode($ps).*/
                    '</td>' .
                    '</tr>' .
                    '</table>' .
                    '</td>' .
                    '<td>' .
                    '<img class="etiqueta" src="' . $urlqr . '" />' .
                    '</td>' .
                    '</tr>' .
                    '</table>' .
                    '</th>';

                if ($total == $thisrow) {
                    $row .= $imgs;
                    $limt2 = $limt - $cols;
                    for ($i = 1; $i <= $limt2; $i++) {
                        $row .= '<th></th>';
                    }
                    $tabla .= '<tr>' . $row . '</tr>';
                } else if ($cols < $limt) {
                    $row .= $imgs;
                    $cols++;
                } else if ($cols >= $limt) {
                    $row .= $imgs;
                    $tabla .= '<tr>' . $row . '</tr>';
                    $cols = 1;
                    $row = "";
                }
                $thisrow++;
            }

            $cards =
                '<style>
                .etiqueta{
                    width:50px;
                }
                .folio{
                    width: 50px;
                    font-size: 10px;
                    word-wrap: break-word;
                }
                table, th, td {
                    font-size: 10px;
                    padding-top: 5px;
                }
                </style>
                <table style="width:100%; ">' . $tabla . ' </table>';
        }
        return $cards;
    }

    //--------------------------------------------------------------------Extintores por orden--------------------------------------------------------------------
    function pdfextintores($FolioOrden, $conprecio)
    {
        ini_set('error_reporting', E_ALL);
        ini_set('display_errors', true);

        //Producto 
        //Mostrar un solo qr, buscar por claveprod
        $prod = new extintoresModel();
        $prod->FolioOrden = $FolioOrden;
        $result = $prod->all_orden();
        $p = to_object($result);
        $cards = "";
        $cards .= pdfController::create_table_extintores($p, $conprecio, "extintor");

        // ---------------------------------------------------------
        // create new PDF document
        $pageLayout = array('3276', '80'); //  or array($height, $width) 
        $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, $pageLayout, true, 'UTF-8', false);

        // set document information
        $pdf->SetKeywords('QR, PDF');

        // remove default header/footer
        $pdf->setPrintHeader(false);
        $pdf->setPrintFooter(false);

        // set margins
        $pdf->SetMargins("0.2", "0.2", "0.2");

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, "30");

        // set image scale factor
        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

        // set some language-dependent strings (optional)
        if (@file_exists(dirname(__FILE__) . '/lang/eng.php')) {
            require_once(dirname(__FILE__) . '/lang/eng.php');
            $pdf->setLanguageArray($l);
        }
        // ---------------------------------------------------------

        // set font
        $pdf->SetFont('helvetica', '', 12);
        // add a page
        $pdf->AddPage();
        // create some HTML content
        $html = $cards;
        // output the HTML content
        $pdf->writeHTML($html, true, false, true, false, '');

        //Close and output PDF document
        $pdf->Output('etiquetas.pdf', 'I');
    }
    function create_table_extintores($p, $conprecio, $extintor)
    {
        $cards = "";
        if ($p != null) {
            $total = count($p);
            $thisrow = 1;
            $limt = 1;
            $cols = 1;
            $row = "";
            $tabla = "";

            foreach ($p as $ps) {
                $sku = $ps->proSku;
                $nombre = $ps->proTitulo;
                $FolioOrden = $ps->FolioOrden;
                $urlqr = crear_qr_extintor($sku, $ps, $conprecio);
                $urlqr = str_replace(URL, "", $urlqr);
                $urlqrprod = crear_qr_card($sku, $ps, $conprecio);
                $urlqrprod = str_replace(URL, "", $urlqrprod);

                $imgs = '<th style="border:1px solid black;">' .
                    '<table>' .
                    '<tr>' .
                    '<td>' .
                    '<img class="etiqueta" src="' . $urlqr . '"/>' .
                    '</td>' .
                    '<td>' .
                    '<table>' .
                    '<tr>' .
                    '<td>' .
                    " " .
                    '</td>' .
                    '</tr>' .
                    '<tr>' .
                    '<td>' .
                    $FolioOrden . " " .
                    '</td>' .
                    '</tr>' .
                    '<tr>' .
                    '<td>' .
                    " " .
                    '</td>' .
                    '</tr>' .
                    '</table>' .
                    '</td>' .
                    '<td>' .
                    '<table>' .
                    '<tr>' .
                    '<td>' .
                    '<img class="etiqueta" src="assets/img/xtinf.png"/>' .
                    '</td>' .
                    '</tr>' .
                    '<tr>' .
                    '<td style="width:120px">' .
                    $sku . " " .
                    $nombre . /*json_encode($ps).*/
                    '</td>' .
                    '</tr>' .
                    '</table>' .
                    '</td>' .
                    '<td>' .
                    '<img class="etiqueta" src="' . $urlqrprod . '" />' .
                    '</td>' .
                    '</tr>' .
                    '</table>' .
                    '</th>';

                if ($total == $thisrow) {
                    $row .= $imgs;
                    $limt2 = $limt - $cols;
                    for ($i = 1; $i <= $limt2; $i++) {
                        $row .= '<th></th>';
                    }
                    $tabla .= '<tr>' . $row . '</tr>';
                } else if ($cols < $limt) {
                    $row .= $imgs;
                    $cols++;
                } else if ($cols >= $limt) {
                    $row .= $imgs;
                    $tabla .= '<tr>' . $row . '</tr>';
                    $cols = 1;
                    $row = "";
                }
                $thisrow++;
            }

            $cards =
                '<style>
                .etiqueta{
                    width:80px;
                }
                .folio{
                    width: 50px;
                    font-size: 10px;
                    word-wrap: break-word;
                }
                table, th, td {
                    font-size: 10px;
                    padding-top: 5px;
                }
                </style>
                <table style="width:100%; ">' . $tabla . ' </table>';
        }
        return $cards;
    }

    function pdfextintor($ClaveExtintor, $conprecio)
    {
        ini_set('error_reporting', E_ALL);
        ini_set('display_errors', true);

        //Producto 
        //Mostrar un solo qr, buscar por claveprod
        $prod = new extintoresModel();
        $prod->ClaveExtintor = $ClaveExtintor;
        $result = $prod->one_clave();
        $p = array(to_object($result));
        //echo json_encode($p);
        $cards = "";
        $cards .= pdfController::create_table_extintores($p, $conprecio, "extintor");

        // ---------------------------------------------------------
        // create new PDF document
        $pageLayout = array('3276', '80'); //  or array($height, $width) 
        $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, $pageLayout, true, 'UTF-8', false);

        // set document information
        $pdf->SetKeywords('QR, PDF');

        // remove default header/footer
        $pdf->setPrintHeader(false);
        $pdf->setPrintFooter(false);

        // set margins
        $pdf->SetMargins("0.2", "0.2", "0.2");

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, "30");

        // set image scale factor
        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

        // set some language-dependent strings (optional)
        if (@file_exists(dirname(__FILE__) . '/lang/eng.php')) {
            require_once(dirname(__FILE__) . '/lang/eng.php');
            $pdf->setLanguageArray($l);
        }
        // ---------------------------------------------------------

        // set font
        $pdf->SetFont('helvetica', '', 12);
        // add a page
        $pdf->AddPage();
        // create some HTML content
        $html = $cards;
        // output the HTML content
        $pdf->writeHTML($html, true, false, true, false, '');

        //Close and output PDF document
        $pdf->Output('etiquetas.pdf', 'I');
    }

    //--------------------------------------------------------------------PDF Orden--------------------------------------------------------------------

    function plantilla()
    {

        $div = "<div></div>";
        // ---------------------------------------------------------

        // create new PDF document
        $pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

        // set document information
        $pdf->SetTitle('ORDEN DE SERVICIO');
        $pdf->SetKeywords('QR, PDF');

        // set header and footer fonts
        $pdf->setHeaderFont(array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));

        // set default monospaced font
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

        // set margins
        //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        // set margins
        $pdf->SetMargins("20", "30", "20");
        $pdf->SetHeaderMargin(0);
        $pdf->SetFooterMargin(0);

        // remove default footer
        $pdf->setPrintFooter(false);

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

        // set image scale factor
        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

        // set some language-dependent strings (optional)
        if (@file_exists(dirname(__FILE__) . '/lang/eng.php')) {
            require_once(dirname(__FILE__) . '/lang/eng.php');
            $pdf->setLanguageArray($l);
        }

        // ---------------------------------------------------------
        // set font
        $pdf->SetFont('helvetica', '', 12);

        // add a page
        $pdf->AddPage();

        $html = $div;
        $pdf->writeHTML($html, true, false, true, false, '');

        //Close and output PDF document
        $pdf->Output('orden_de_servicio.pdf', 'I');

        //============================================================+
        // END OF FILE
        //============================================================+
    }

    function pdfticket($IdOrden)
    {

        //Producto 
        //Mostrar un solo qr, buscar por claveprod
        $ordenes = new ordenesModel();
        $ordenes->IdOrden = $IdOrden;
        $detalle = $ordenes->one();
        $ordenes->pdfval = 1;
        $rows = $ordenes->detalle();
        $IdOrden = $detalle['IdOrden'];
        $Nombre = $detalle['Nombre'];
        $FisTelefono = $detalle['FisTelefono'];
        $FisEmail = $detalle['FisEmail'];
        $EntCalle = $detalle['EntCalle'];
        $EntNExt = $detalle['EntNExt'];
        $EntColonia = $detalle['EntColonia'];
        $EntCP = $detalle['EntCP'];
        $EntMunicipio = $detalle['EntMunicipio'];
        $EntEstado = $detalle['EntEstado'];
        $TipoPago = $detalle['TipoPago'];
        if($TipoPago == 01){
            $TipoPago = "EFECTIVO";
        }else if($TipoPago == 03){
            $TipoPago = "TRANSFERENCIA ELECTRÓNICA DE FONDOS";
        }else if($TipoPago == 04){
            $TipoPago = "TARJETA CRÉDITO/DEBITO";
        }else if($TipoPago == 52){
            $TipoPago = "CHEQUE";
        }else if($TipoPago == 99){
            $TipoPago = "CRÉDITO/POR DEFINIR";
        }
        $imagen = crear_qr($detalle['FolioOrden']);
        $imagen = str_replace(URL, "", $imagen);
        $domicilio_completo = $EntCalle . " " . $EntNExt . " Colonia " . $EntColonia . " C.P. " . $EntCP . " " . $EntMunicipio . ", " . $EntEstado;
        $NombreUsuario =  $detalle['NombreUsuario'];
        $telefonovendedor = $detalle['telvendedor'];
        $FE = $detalle['Fecha'];
        $arrMeses = array("enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre");
        $fecha = 'Guadalajara, Jal, a ' . date("d", strtotime($FE)) . " de " . $arrMeses[date("m", strtotime($FE)) - 1] . " del " . date("Y", strtotime($FE) . ".");

        $div = '
            <style>
            .etiqueta{
                height: 150px;
            }
            
            .etiqueta2{
                height: 80px;
            }

            .numeros{
                text-align: right;
            }
            
            .customers {
                font-family: Arial, Helvetica, sans-serif;
                border-collapse: collapse;
                width: 100%;
            }
              
            .customers td, #customers th {
                
                padding: 8px;
                font-size: 10px;
            }
              
            .customers th {
                padding-top: 12px;
                padding-bottom: 12px;
                text-align: center;
                border-bottom: 1px solid #201E1F;
                color: black;
                font-size: 11px;
                white-space:nowrap;
            }
            
            td, th {
                font-size: 10px;
            }
              
            th {
                font-size: 11px;
            }
            
            p{
                font-size: 10px;
            }
            .img-container {
                text-align: center;
                display: block;
              }
            </style>
    
            <table style="width:100%" class=""><tbody>
            <tr>
                <td colspan="4"><img class="etiqueta2" src="assets/img/xtinf.png"/></td>
            </tr>
            <tr>
                <td colspan="4" style="text-align: center;"><b>FECHA VENTA: </b>' . $FE . '</td>
            </tr>
            <tr>
                <td colspan="4"></td>
            </tr>

            <tr>
                <td colspan="4" style="text-align: center;"><b></b>GRUPO XTINFIRE</td>
            </tr>
            <tr>
                <td colspan="4" style="text-align: center;"><b></b>Av. de la Paz 2529, Arcos Vallarta, CP: 44130</td>
            </tr>
            <tr>
                <td colspan="4" style="text-align: center;"><b></b>Guadalajara, Jal, México.</td>
            </tr>
            <tr>
                <td colspan="4" style="text-align: center;"><b>TELÉFONO: </b>33 3630 1313</td>
            </tr>
            <tr>
                <td colspan="4" style="text-align: center;"><b>RFC: </b>GXF211012H71</td>
            </tr>
 
            <tr>
                <td colspan="5"></td>
            </tr>
            </tbody></table>';

        $div .= '<br><br><table class="customers">' .
            '<tbody><tr>' .
            '<th style="font-size:9px; line-height: 22px;"><b>CANTIDAD</b></th>' .
            '<th style="font-size:9px; line-height: 22px;" colspan="2"><b>DESCRIPCIÓN</b></th>' .
            '<th style="font-size:9px"><b>P. UNITARIO</b></th>' .
            '<th style="font-size:9px"><b>SUB-TOTAL</b></th>' .
            '</tr>';

        $subtotal = 0;
        $desc = 0;
        $ivaindividual = 0 ;
        $ivatotal = 0;
        foreach (to_object($rows) as $row) {
            $Cantidad = $row->Cantidad;
            $PrecioVenta = $row->PrecioVenta;
            $proTitulo = $row->proTitulo;
            $DescPesos = $row->DescPesos;
            $Neto = $row->Neto;
            $ivaindividual = $Neto * 0.16;
            $ivaindividual = str_replace(",","",$ivaindividual);
            $ivatotal += number_format($ivaindividual, 2, '.', '');
            $proImagen = $row->proImagen;
            $proImagen = str_replace(URL, "", $proImagen);
            $subtotal += $Neto;
            $desc += $DescPesos;
            $clave = $row->proSku;
            $almId = $row->proAlmId;
            $descripciontitulo = $row->DescripcionNueva;
            if($descripciontitulo != ""){
               $proTitulo = $descripciontitulo;
            }
            if($almId != 2){
                    $div .= '<tr>' .
                '<td style="text-align: center;">' . $Cantidad . '</td>' .
                '<td colspan="2">' . $proTitulo . '</td>' .
                '<td class="numeros">' . number_format($PrecioVenta, 2) . '</td>' .
                '<td class="numeros">' . number_format($Neto, 2) . '</td>' .
                '</tr>';
            }elseif ($almId == 2 AND $Neto>=100) {
                $div .= '<tr>' .
                '<td style="text-align: center;">' . $Cantidad . '</td>' .
                '<td colspan="2">' . $proTitulo . '</td>' .
                '<td class="numeros">' . number_format($PrecioVenta, 2) . '</td>' .
                '<td class="numeros">' . number_format($Neto, 2) . '</td>' .
                '</tr>';
            }
            
        }
        $iva = $subtotal  * (16 / 100);
        $total = $ivatotal + $subtotal;

        $div .= '<tr>
                    <td class="numeros" colspan="4"><b>SUB-TOTAL</b></td>
                    <td class="numeros"> ' . number_format($subtotal, 2) . '</td>
                </tr>
                <tr>
                    <td class="numeros" colspan="4"><b>DESCUENTO</b></td>
                    <td class="numeros"> ' . number_format($desc, 2) . '</td>
                </tr>
                <tr>
                    <td class="numeros quitar" colspan="4"><b>I.V.A.</b></td>
                    <td class="numeros"> ' . number_format($ivatotal, 2) . '</td>
                </tr>
                <tr>
                    <td class="numeros quitar" colspan="4"><b>TOTAL</b></td>
                    <td class="numeros"> ' . number_format($total, 2) . '</td>
                </tr>
            </tbody>
            </table>';
        $letras = number_format($total,2,".","");
        $letras = $this->numtoletras($letras);
        $explodeletras = explode(" ",$letras);
        $textoval = $explodeletras[0].$explodeletras[1];
        if ($textoval == "UNMIL") {
            $letras = substr($letras,3);
        }
        $div .= '<br><p style="text-align: center;">'.$letras.'</p>
        <p style="text-align: center;">-------------------------FORMA DE PAGO-------------------------</p>
            <p style="text-align: center;">'.$TipoPago.'</p>
                    <p style="text-align: center;">
                        Estimado Cliente la información para generar su factura la puede enviar a <strong>facturacion1@grupoxtinfire.com</strong> solicitando su factura.
                        Dudas y sugerencias contactar a su vendedor:
                    </p>
                    <p style="text-align: center;">
                        <br>' . $NombreUsuario . ' | Asesor de ventas
                        <br>Télefono: '.$telefonovendedor.'
                        <br>Gracias por su compra.
                    </p>';

        // ---------------------------------------------------------

        // create new PDF document
         $pageLayout = array('3276', '80'); //  or array($height, $width) 
        $pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, $pageLayout, true, 'UTF-8', false);

        // set document information
        $pdf->SetTitle('ORDEN DE SERVICIO');
        $pdf->SetKeywords('QR, PDF');

        // set header and footer fonts
        $pdf->setHeaderFont(array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
            $pdf->setPrintHeader(false);
        $pdf->setPrintFooter(false);
        // set default monospaced font
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

        // set margins
        //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        // set margins
        $pdf->SetMargins("0.2", "0.2", "0.2");
        $pdf->SetHeaderMargin(0);
        $pdf->SetFooterMargin(0);

        // remove default footer
        $pdf->setPrintFooter(false);

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

        // set image scale factor
        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

        // set some language-dependent strings (optional)
        if (@file_exists(dirname(__FILE__) . '/lang/eng.php')) {
            require_once(dirname(__FILE__) . '/lang/eng.php');
            $pdf->setLanguageArray($l);
        }

        // ---------------------------------------------------------
        // set font
        $pdf->SetFont('helvetica', '', 12);

        // add a page
        $pdf->AddPage();

        $html = $div;
        $pdf->writeHTML($html, true, false, true, false, '');

        //Close and output PDF document
        $pdf->Output('orden_de_servicio_' . $IdOrden . '.pdf', 'I');

        //============================================================+
        // END OF FILE
        //============================================================+
    }


    function numtoletras($xcifra)
{
    $xarray = array(0 => "Cero",
        1 => "UN", "DOS", "TRES", "CUATRO", "CINCO", "SEIS", "SIETE", "OCHO", "NUEVE",
        "DIEZ", "ONCE", "DOCE", "TRECE", "CATORCE", "QUINCE", "DIECISEIS", "DIECISIETE", "DIECIOCHO", "DIECINUEVE",
        "VEINTI", 30 => "TREINTA", 40 => "CUARENTA", 50 => "CINCUENTA", 60 => "SESENTA", 70 => "SETENTA", 80 => "OCHENTA", 90 => "NOVENTA",
        100 => "CIENTO", 200 => "DOSCIENTOS", 300 => "TRESCIENTOS", 400 => "CUATROCIENTOS", 500 => "QUINIENTOS", 600 => "SEISCIENTOS", 700 => "SETECIENTOS", 800 => "OCHOCIENTOS", 900 => "NOVECIENTOS"
    );
//
    $xcifra = trim($xcifra);
    $xlength = strlen($xcifra);
    $xpos_punto = strpos($xcifra, ".");
    $xaux_int = $xcifra;
    $xdecimales = "00";
    if (!($xpos_punto === false)) {
        if ($xpos_punto == 0) {
            $xcifra = "0" . $xcifra;
            $xpos_punto = strpos($xcifra, ".");
        }
        $xaux_int = substr($xcifra, 0, $xpos_punto); // obtengo el entero de la cifra a covertir
        $xdecimales = substr($xcifra . "00", $xpos_punto + 1, 2); // obtengo los valores decimales
    }

    $XAUX = str_pad($xaux_int, 18, " ", STR_PAD_LEFT); // ajusto la longitud de la cifra, para que sea divisible por centenas de miles (grupos de 6)
    $xcadena = "";
    for ($xz = 0; $xz < 3; $xz++) {
        $xaux = substr($XAUX, $xz * 6, 6);
        $xi = 0;
        $xlimite = 6; // inicializo el contador de centenas xi y establezco el límite a 6 dígitos en la parte entera
        $xexit = true; // bandera para controlar el ciclo del While
        while ($xexit) {
            if ($xi == $xlimite) { // si ya llegó al límite máximo de enteros
                break; // termina el ciclo
            }

            $x3digitos = ($xlimite - $xi) * -1; // comienzo con los tres primeros digitos de la cifra, comenzando por la izquierda
            $xaux = substr($xaux, $x3digitos, abs($x3digitos)); // obtengo la centena (los tres dígitos)
            for ($xy = 1; $xy < 4; $xy++) { // ciclo para revisar centenas, decenas y unidades, en ese orden
                switch ($xy) {
                    case 1: // checa las centenas
                        if (substr($xaux, 0, 3) < 100) { // si el grupo de tres dígitos es menor a una centena ( < 99) no hace nada y pasa a revisar las decenas
                            
                        } else {
                            $key = (int) substr($xaux, 0, 3);
                            if (TRUE === array_key_exists($key, $xarray)){  // busco si la centena es número redondo (100, 200, 300, 400, etc..)
                                $xseek = $xarray[$key];
                                $xsub = $this->subfijo($xaux); // devuelve el subfijo correspondiente (Millón, Millones, Mil o nada)
                                if (substr($xaux, 0, 3) == 100)
                                    $xcadena = " " . $xcadena . " CIEN " . $xsub;
                                else
                                    $xcadena = " " . $xcadena . " " . $xseek . " " . $xsub;
                                $xy = 3; // la centena fue redonda, entonces termino el ciclo del for y ya no reviso decenas ni unidades
                            }
                            else { // entra aquí si la centena no fue numero redondo (101, 253, 120, 980, etc.)
                                $key = (int) substr($xaux, 0, 1) * 100;
                                $xseek = $xarray[$key]; // toma el primer caracter de la centena y lo multiplica por cien y lo busca en el arreglo (para que busque 100,200,300, etc)
                                $xcadena = " " . $xcadena . " " . $xseek;
                            } // ENDIF ($xseek)
                        } // ENDIF (substr($xaux, 0, 3) < 100)
                        break;
                    case 2: // checa las decenas (con la misma lógica que las centenas)
                        if (substr($xaux, 1, 2) < 10) {
                            
                        } else {
                            $key = (int) substr($xaux, 1, 2);
                            if (TRUE === array_key_exists($key, $xarray)) {
                                $xseek = $xarray[$key];
                                $xsub = $this->subfijo($xaux);
                                if (substr($xaux, 1, 2) == 20)
                                    $xcadena = " " . $xcadena . " VEINTE " . $xsub;
                                else
                                    $xcadena = " " . $xcadena . " " . $xseek . " " . $xsub;
                                $xy = 3;
                            }
                            else {
                                $key = (int) substr($xaux, 1, 1) * 10;
                                $xseek = $xarray[$key];
                                if (20 == substr($xaux, 1, 1) * 10)
                                    $xcadena = " " . $xcadena . " " . $xseek;
                                else
                                    $xcadena = " " . $xcadena . " " . $xseek . " Y ";
                            } // ENDIF ($xseek)
                        } // ENDIF (substr($xaux, 1, 2) < 10)
                        break;
                    case 3: // checa las unidades
                        if (substr($xaux, 2, 1) < 1) { // si la unidad es cero, ya no hace nada
                            
                        } else {
                            $key = (int) substr($xaux, 2, 1);
                            $xseek = $xarray[$key]; // obtengo directamente el valor de la unidad (del uno al nueve)
                            $xsub = $this->subfijo($xaux);
                            $xcadena = " " . $xcadena . " " . $xseek . " " . $xsub;
                        } // ENDIF (substr($xaux, 2, 1) < 1)
                        break;
                } // END SWITCH
            } // END FOR
            $xi = $xi + 3;
        } // ENDDO

        if (substr(trim($xcadena), -5, 5) == "ILLON") // si la cadena obtenida termina en MILLON o BILLON, entonces le agrega al final la conjuncion DE
            $xcadena.= " DE";

        if (substr(trim($xcadena), -7, 7) == "ILLONES") // si la cadena obtenida en MILLONES o BILLONES, entoncea le agrega al final la conjuncion DE
            $xcadena.= " DE";

        // ----------- esta línea la puedes cambiar de acuerdo a tus necesidades o a tu país -------
        if (trim($xaux) != "") {
            switch ($xz) {
                case 0:
                    if (trim(substr($XAUX, $xz * 6, 6)) == "1")
                        $xcadena.= "UN BILLON ";
                    else
                        $xcadena.= " BILLONES ";
                    break;
                case 1:
                    if (trim(substr($XAUX, $xz * 6, 6)) == "1")
                        $xcadena.= "UN MILLON ";
                    else
                        $xcadena.= " MILLONES ";
                    break;
                case 2:
                    if ($xcifra < 1) {
                        $xcadena = "CERO PESOS $xdecimales/100 M.N.";
                    }
                    if ($xcifra >= 1 && $xcifra < 2) {
                        $xcadena = "UN PESO $xdecimales/100 M.N. ";
                    }
                    if ($xcifra >= 2) {
                        $xcadena.= " PESOS $xdecimales/100 M.N. "; //
                    }
                    break;
            } // endswitch ($xz)
        } // ENDIF (trim($xaux) != "")
        // ------------------      en este caso, para México se usa esta leyenda     ----------------
        $xcadena = str_replace("VEINTI ", "VEINTI", $xcadena); // quito el espacio para el VEINTI, para que quede: VEINTICUATRO, VEINTIUN, VEINTIDOS, etc
        $xcadena = str_replace("  ", " ", $xcadena); // quito espacios dobles
        $xcadena = str_replace("UN UN", "UN", $xcadena); // quito la duplicidad
        $xcadena = str_replace("  ", " ", $xcadena); // quito espacios dobles
        $xcadena = str_replace("BILLON DE MILLONES", "BILLON DE", $xcadena); // corrigo la leyenda
        $xcadena = str_replace("BILLONES DE MILLONES", "BILLONES DE", $xcadena); // corrigo la leyenda
        $xcadena = str_replace("DE UN", "UN", $xcadena); // corrigo la leyenda
    } // ENDFOR ($xz)
    return trim($xcadena);
}

// END FUNCTION

function subfijo($xx)
{ // esta función regresa un subfijo para la cifra
    $xx = trim($xx);
    $xstrlen = strlen($xx);
    if ($xstrlen == 1 || $xstrlen == 2 || $xstrlen == 3)
        $xsub = "";
    //
    if ($xstrlen == 4 || $xstrlen == 5 || $xstrlen == 6)
        $xsub = "MIL";
    //
    return $xsub;
}
    
    function pdforden($IdOrden)
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);

        error_reporting(E_ALL);
        //Producto 
        //Mostrar un solo qr, buscar por claveprod
        $ordenes = new ordenesModel();
        $ordenes->IdOrden = $IdOrden;
        $detalle = $ordenes->one();
        $ordenes->pdfval = 1;
        $ordenes->separar = $detalle['Separaproductos'];
        $rows = $ordenes->detalle();
        $ordenescero = new ordenesModel();
        $ordenescero->IdOrden = $IdOrden;
        $rows2 = $ordenescero->detalle_cantidad_cero_pdf();
        $IdOrden = $detalle['IdOrden'];
        $Nombre = $detalle['Nombre'];
        $Descuentocolumana = $detalle['Descuento'];
        $FisTelefono = $detalle['FisTelefono'];
        $FisEmail = $detalle['FisEmail'];
        $EntCalle = $detalle['EntCalle'];
        $EntNExt = $detalle['EntNExt'];
        $EntColonia = $detalle['EntColonia'];
        $EntCP = $detalle['EntCP'];
        $EntMunicipio = $detalle['EntMunicipio'];
        $EntEstado = $detalle['EntEstado'];
        $imagenurlfirma = $detalle['urlfirma'];
        $Nombrerecibe = $detalle['Nombrerecibe'];
        $imagen = crear_qr($detalle['FolioOrden']);
        $imagen = str_replace(URL, "", $imagen);
        $domicilio_completo = $EntCalle . " " . $EntNExt . " Colonia " . $EntColonia . " C.P. " . $EntCP . " " . $EntMunicipio . ", " . $EntEstado;
        $NombreUsuario =  $detalle['NombreUsuario'];
        $telefonovendedor = $detalle['telvendedor'];
        $idVendedor =  $detalle['IdUsuario'];
        $TipoPago = $detalle['TipoPago'];
        $NombreEstatus = $detalle['NombreEstatus'];
        $PagadoCompleto = $detalle['PagadoCompleto'];
        if($PagadoCompleto == 2){
            $PagadoCompleto = "Pendiente de Pago";
        }else if($PagadoCompleto == 3){
            $PagadoCompleto = "Pago Parcial";
        }else if($PagadoCompleto == 11){
            $PagadoCompleto = "Pagado con Factura";
        }else if($PagadoCompleto == 12){
            $PagadoCompleto = "Pagado sin Factura";
        }else if($PagadoCompleto == 25){
           $PagadoCompleto = "Pago Contra Entrega";
        }else{
            $PagadoCompleto = "Aún no lo revisa facturación";
        }
        if($TipoPago == 01){
            $TipoPago = "EFECTIVO";
        }else if($TipoPago == 03){
            $TipoPago = "TRANSFERENCIA ELECTRÓNICA DE FONDOS";
        }else if($TipoPago == 04){
            $TipoPago = "TARJETA CRÉDITO/DEBITO";
        }else if($TipoPago == 52){
            $TipoPago = "CHEQUE";
        }else if($TipoPago == 99){
            $TipoPago = "CRÉDITO/POR DEFINIR";
        }
        $FE = $detalle['Fecha'];
        $arrMeses = array("enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre");
        $fecha = 'Guadalajara, Jal, a ' . date("d", strtotime($FE)) . " de " . $arrMeses[date("m", strtotime($FE)) - 1] . " del " . date("Y", strtotime($FE) . ".");
        
        $div = '
            <style>
            .etiqueta{
                height: 150px;
            }
			
			.etiqueta2{
                height: 80px;
            }

            .numeros{
                text-align: right;
            }

            .numeros2{
                text-align: center;
            }
            
            .customers {
                font-family: Arial, Helvetica, sans-serif;
                border-collapse: collapse;
                width: 100%;
            }
              
            .customers td, #customers th {
                border: 1px solid #ddd;
                padding: 8px;
				font-size: 10px;
            }
              
            .customers th {
                padding-top: 12px;
                padding-bottom: 12px;
                text-align: center;
                background-color: #201E1F;
                color: white;
				font-size: 11px;
				white-space:nowrap;
            }
			
			td, th {
				font-size: 10px;
            }
              
            th {
				font-size: 11px;
            }
			
			p{
				font-size: 10px;
			}
            .img-container {
                text-align: center;
                display: block;
              }
            </style>
	
            <table style="width:100%" class=""><tbody>
            <tr>
                <td colspan="4"></td>
            </tr>
            <tr>
                <td colspan="4" style="text-align: right;">' . $fecha . '</td>
            </tr>
            <tr>
                <td colspan="4"><b>Id Orden: </b>'.$IdOrden.'</td>
            </tr>
            <!--<tr>
                <td colspan="3"></td>
                <th rowspan="6"><img class="etiqueta" src="' . $imagen . '"/></th>
            </tr>-->
            <tr>
                <td colspan="3"><b>A/A: </b>' . $Nombre . '</td>
            </tr>
			<tr>
                <td colspan="3"><b>EMAIL: </b>' . $FisEmail . '</td>
            </tr>
            <tr>
                <td colspan="3"><b>TELÉFONO: </b>' . $FisTelefono . '</td>
            </tr>
            <tr>
                <td colspan="3"><b>DOMICILIO: </b>' . $domicilio_completo . '</td>
            </tr>
			<tr>
                <td colspan="5"></td>
            </tr>
            <tr>
                <td colspan="5" style="text-align: center;">
					Apreciable cliente, presentamos a usted la siguiente orden solicitada para su consideración, esperando 
					que el contenido en la presente sea de su utilidad, agradeciéndole de antemano la oportunidad de ofrecerle nuestros 
					productos y servicios.
				</td>
            </tr>
            </tbody></table>';
            $crearcolumna = "";
        if($Descuentocolumana != 0){
            $crearcolumna = '<th><b>Precio Neto</b></th>';
            $crearcolumna = ""; // Activar cuando se necesite es una columna extra cuando se activa un descuento
        }
        $div .= '<br><br><table class="customers">' .
            '<tbody><tr>' .
            '<th><b>CLAVE</b></th>' .
            '<th><b>CANTIDAD</b></th>' .
            '<th colspan="2"><b>DESCRIPCIÓN</b></th>' .
            '<th colspan="2"><b>IMAGEN</b></th>' .
            '<th><b>P. UNITARIO</b></th>' .
             $crearcolumna.
            '<th><b>SUB-TOTAL</b></th>' .
            '</tr>';

        $subtotal = 0;
        $desc = 0;
        $breakpage = 1;
        $ivaindividual = 0 ;
        $ivatotal = 0;
        $contarbaja = 0;
        foreach (to_object($rows2) as $row2) {
            $Cantidad2 = $row2->Cantidad;
            
            if($Cantidad2 == 0){
                $contarbaja++;
            }
        }


        foreach (to_object($rows) as $row) {
            $Cantidad = $row->Cantidad;
            $PrecioVenta = $row->PrecioVenta;
            $proTitulo = $row->proTitulo;
            $DescPesos = $row->DescPesos;
            $Neto = $row->Neto;
            $ivaindividual = $Neto * 0.16;
            $ivaindividual = str_replace(",","",$ivaindividual);
            $ivatotal += number_format($ivaindividual, 2, '.', '');
            $proImagen = $row->proImagen;
            $almId = $row->proAlmId;
            $proImagen = str_replace(URL, "", $proImagen);
            $subtotal += $Neto;
            $desc += $DescPesos;
            $clave = $row->proSku;
            $contadorcaracteres = strlen($proTitulo);
            $netofinal = $Neto + $DescPesos;
            if($breakpage%8 == 0){
                $salto= '<br><br><br><br>';
            }else{
                $salto= '';
            }
            if($contadorcaracteres <= 100){
                $linebreak = "<br><br><br>";
            }else{
               $linebreak = "<br>"; 
            }
            $descripciontitulo = $row->DescripcionNueva;
            if($descripciontitulo != ""){
               $proTitulo = $descripciontitulo;
            }
            $dibujardescolumna = "";
            if($desc != 0){
                $dibujardescolumna = '<td style="text-align: center;line-height:70em" >' . number_format($netofinal,2) . '</td>';
                $dibujardescolumna = "";
                $netofinal = $Neto;
            }
            $div .= $salto.'<tr nobr="true">' .
                '<td style="text-align: center;line-height:70em" >' . $clave . '</td>' .
                '<td style="text-align: center;line-height:70em" >' . $Cantidad . '</td>' .
                '<td colspan="2">' . $linebreak . $proTitulo . '</td>' .
                '<td colspan="2"><span class="img-container"><img class="etiqueta2" src="' . $proImagen . '"/></span></td>' .
                '<td class="numeros2" style="line-height:70em">' . number_format($PrecioVenta, 2) . '</td>' .
                $dibujardescolumna.
                '<td class="numeros2" style="line-height:70em">' . number_format($netofinal, 2) . '</td>' .
                '</tr>';
            /*if($almId != 2){
                
            }*/
            /*elseif ($almId == 2 A3ND $Neto>=100) {
                $div .= $salto.'<tr>' .
                '<td style="text-align: center;line-height:70em">' . $Cantidad . '</td>' .
                '<td colspan="2">' . $linebreak . $proTitulo . '</td>' .
                '<td colspan="2"><span class="img-container"><img class="etiqueta2" src="' . $proImagen . '"/></span></td>' .
                '<td class="numeros2" style="line-height:70em">' . number_format($PrecioVenta, 2) . '</td>' .
                '<td class="numeros2" style="line-height:70em">' . number_format($Neto, 2) . '</td>' .
                '</tr>'; 
            }*/
        
            $breakpage++;
        }
        $iva = $subtotal  * (16 / 100);
        $total = $ivatotal + $subtotal;
        $ttprincipal = $subtotal + $desc;
        $negritasinicial = "";
            $negritasfinal = "";
        if($idVendedor == 41 ){
            $negritasinicial = "<strong>";
            $negritasfinal = "</strong>";
        }
        $dibujardesc = '';
        $colspan = 7;
        if($desc != 0){
            $colspan = 7;
            $dibujardesc = '<tr>
                    <td class="numeros" colspan="'.$colspan.'"><b>DESCUENTO</b></td>
                    <td class="numeros"> ' . $negritasinicial. number_format($desc, 2) . $negritasfinal. '</td>
                </tr>';

                
        }

        $div .= '<!--<tr>
                    <td class="numeros" colspan="'.$colspan.'"><b>TOTAL</b></td>
                    <td class="numeros"> ' . $negritasinicial. number_format($ttprincipal, 2) . '</td>
                </tr>-->
                '.$dibujardesc.'
                <tr>
					<td class="numeros" colspan="'.$colspan.'"><b>SUB-TOTAL</b></td>
					<td class="numeros"> ' . $negritasinicial. number_format($subtotal, 2) . $negritasfinal.'</td>
				</tr>
                
				<tr>
					<td class="numeros" colspan="'.$colspan.'"><b>I.V.A.</b></td>
					<td class="numeros"> ' . $negritasinicial. number_format($ivatotal, 2) . $negritasfinal.'</td>
				</tr>
				<tr>
					<td class="numeros" colspan="'.$colspan.'"><b>TOTAL A PAGAR</b></td>
					<td class="numeros"> ' . $negritasinicial. number_format($total, 2) . $negritasfinal.'</td>
				</tr>
			</tbody>
            </table>';
        if($contarbaja > 0){
           $div.= 'Extintores que estan dados de baja en esta orden: '.$contarbaja; 
        } 
        $div .= '<br><p>Metodo de Pago: '.$TipoPago.'. Estatus de orden: '.$NombreEstatus.'. Pago: '.$PagadoCompleto.'</p>
                        <p>
						<b>Términos y Condiciones. </b>
						<br>&nbsp;&nbsp;&nbsp;•&nbsp;&nbsp;&nbsp; Los precios son expresados en Moneda Nacional. 
						<br>&nbsp;&nbsp;&nbsp;• &nbsp;&nbsp;&nbsp;En piezas eléctricas la garantía es de 5 días a partir de su compra, posterior aplica directo con el fabricante. 
						<br>&nbsp;&nbsp;&nbsp;•&nbsp;&nbsp;&nbsp; Los equipos extintores nuevos cuentan con 5 años de garantía por defecto de fabricación y 1 año en su carga. 
						<br><b>Tiempo de entrega: </b>
                        <br>&nbsp;&nbsp;&nbsp;•&nbsp;&nbsp;&nbsp; <strong>Comentarios del Vendedor</strong>: '.$detalle['Descripcion'].'
						<br>&nbsp;&nbsp;&nbsp;•&nbsp;&nbsp;&nbsp; Entrega a domicilio de 3 a 8 días hábiles.
						<br>&nbsp;&nbsp;&nbsp;•&nbsp;&nbsp;&nbsp; Todo equipo nuevo incluye instalacion se aplican restricciones*.
						
						<br>La presente cotización tiene validez de 7 días naturales a partir de la fecha de expedición.
						<br><b>Para efectos de facturación</b> se requiere especificar forma de pago, uso de cfdi y método de pago.
					</p>	
                    <p>*Si la instalación es mayor a 3 metros de altura del piso al tope de la barda o se requiere una escalera mayor a 3 metros se aplican costos extras.</p>
                    <p style="text-align: center;">Firma y nombre de recibido</p>
                    <p style="text-align: center;">'.$Nombrerecibe.'</p>
                    <img style="width:150px;text-align: center; margin: auto;" src="'.$imagenurlfirma.'" />
					<p style="text-align: center;">
						<p><b>Atentamente,</b>
						<br>' . $NombreUsuario . ' | Asesor de ventas
                        <br>Télefono: '.$telefonovendedor.'
						<br>XTIN FIRE S.A. DE C.V.
						<br>¡18 años trabajando por tu seguridad
					</p>';

        // ---------------------------------------------------------

        // create new PDF document

        $pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
        // set document information
        $pdf->SetTitle('ORDEN DE SERVICIO');
        $pdf->SetKeywords('QR, PDF');

        // set header and footer fonts
        $pdf->setHeaderFont(array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));

        // set default monospaced font
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

        // set margins
        //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        // set margins
        $pdf->SetMargins("20", "30", "20");
        $pdf->SetHeaderMargin(0);
        $pdf->SetFooterMargin(0);

        // remove default footer
        $pdf->setPrintFooter(false);

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

        // set image scale factor
        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

        // set some language-dependent strings (optional)
        if (@file_exists(dirname(__FILE__) . '/lang/eng.php')) {
            require_once(dirname(__FILE__) . '/lang/eng.php');
            $pdf->setLanguageArray($l);
        }

        // ---------------------------------------------------------
        // set font
        $pdf->SetFont('helvetica', '', 12);

        // add a page
        $pdf->AddPage();

        $html = $div;
        $pdf->writeHTML($html, true, false, true, false, '');

        //Close and output PDF document
        $pdf->Output('orden_de_servicio_' . $IdOrden . '.pdf', 'I');

        //============================================================+
        // END OF FILE
        //============================================================+
    }

    function pdfcotizacion($IdOrden)
    {

        /*ini_set('error_reporting', E_ALL);
        ini_set('display_errors', true);*/

        //Producto 
        //Mostrar un solo qr, buscar por claveprod
        $ordenes = new ordenesModel();
        $cotizaciones = new cotizacionesModel();
        $cotizaciones->IdCotizacion = $IdOrden;
        $detalle = $cotizaciones->one();
        $cotizaciones->IdCotizacion = $detalle['IdCotizacion'];
        $cotizaciones->pdfval = 1;
        $rows = $cotizaciones->detalle();
        $Nombre = $detalle['Nombre'];
        $Descuentocolumana = $detalle['Descuento'];
        $FisTelefono = $detalle['FisTelefono'];
        $FisEmail = $detalle['FisEmail'];
        $EntCalle = $detalle['EntCalle'];
        $EntNExt = $detalle['EntNExt'];
        $EntColonia = $detalle['EntColonia'];
        $EntCP = $detalle['EntCP'];
        $EntMunicipio = $detalle['EntMunicipio'];
        $EntEstado = $detalle['EntEstado'];
        $imagen = crear_qr($detalle['FolioCotizacion']);
        $imagen = str_replace(URL, "", $imagen);
        $domicilio_completo = $EntCalle . " " . $EntNExt . " Colonia " . $EntColonia . " C.P. " . $EntCP . " " . $EntMunicipio . ", " . $EntEstado;
        $NombreUsuario =  $detalle['NombreUsuario'];
        $telefonovendedor =  $detalle['telvendedor'];
        $idVendedor =  $detalle['IdUsuario'];
        $FE = $detalle['Fecha'];
        $arrMeses = array("enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre");
        $fecha = 'Guadalajara, Jal, a ' . date("d", strtotime($FE)) . " de " . $arrMeses[date("m", strtotime($FE)) - 1] . " del " . date("Y", strtotime($FE) . ".");


        $div = '
            <style>
            .etiqueta{
                height: 150px;
            }
			
			.etiqueta2{
                height: 80px;
            }

            .numeros{
                text-align: right;
            }

            .numeros2{
                text-align: center;
            }
            
            .customers {
                font-family: Arial, Helvetica, sans-serif;
                border-collapse: collapse;
                width: 100%;
            }
              
            .customers td, #customers th {
                border: 1px solid #ddd;
                padding: 8px;
				font-size: 10px;
            }
              
            .customers th {
                padding-top: 12px;
                padding-bottom: 12px;
                text-align: center;
                background-color: #201E1F;
                color: white;
				font-size: 11px;
				white-space:nowrap;
            }
			
			td, th {
				font-size: 10px;
            }
              
            th {
				font-size: 11px;
            }
			
			p{
				font-size: 10px;
			}
            .img-container {
                text-align: center;
                display: block;
              }

            </style>
	
            <table style="width:100%" class=""><tbody>
            <tr>
                <td colspan="4"></td>
            </tr>
            <tr>
                <td colspan="4" style="text-align: right;">' . $fecha . '</td>
            </tr>
            <tr>
                <td colspan="4"><b>Id Cotización: </b>'.$IdOrden.'</td>
            </tr>
            <!--<tr>
                <td colspan="3"></td>
                <th rowspan="6"><img class="etiqueta" src="' . $imagen . '"/></th>
            </tr>-->
            <tr>
                <td colspan="3"><b>A/A: </b>' . $Nombre . '</td>
            </tr>
			<tr>
                <td colspan="3"><b>EMAIL: </b>' . $FisEmail . '</td>
            </tr>
            <tr>
                <td colspan="3"><b>TELÉFONO: </b>' . $FisTelefono . '</td>
            </tr>
            <tr>
                <td colspan="3"><b>DOMICILIO: </b>' . $domicilio_completo . '</td>
            </tr>
			<tr>
                <td colspan="5"></td>
            </tr>
            <tr>
                <td colspan="5" style="text-align: center;">
					Apreciable cliente, presentamos a usted la siguiente cotización solicitada para su consideración, esperando 
					que el contenido en la presente sea de su utilidad, agradeciéndole de antemano la oportunidad de ofrecerle nuestros 
					productos y servicios.
				</td>
            </tr>
            </tbody></table>';
        $crearcolumna = "";
        if($Descuentocolumana != 0){
            $crearcolumna = '<th><b>Precio Neto</b></th>';
            $crearcolumna = ""; //Cuando se quiera activar una nueva columna hay que quitar esta opcion
        }
        $div .= '<br><br><table class="customers">' .
            '<tbody><tr>' .
            '<th><b>CANTIDAD</b></th>' .
            '<th colspan="2"><b>DESCRIPCION</b></th>' .
            '<th colspan="2"><b>IMAGEN</b></th>' .
            '<th><b>P. UNITARIO</b></th>' .
            $crearcolumna.
            '<th><b>SUB-TOTAL</b></th>' .
            '</tr>';

        $subtotal = 0;
        $desc = 0;
        $breakpage = 1;
        $ivaindividual = 0 ;
        $ivatotal = 0;
        foreach (to_object($rows) as $row) {
            $Cantidad = $row->Cantidad;
            $PrecioVenta = $row->PrecioVenta;
            $proTitulo = $row->proTitulo;
            $DescPesos = $row->DescPesos;
            $descripciontitulo = $row->DescripcionNueva;
            $Neto = $row->Neto;
            $ivaindividual = $Neto * 0.16;
            $ivaindividual = str_replace(",","",$ivaindividual);
            $ivatotal += number_format($ivaindividual, 2, '.', '');
            $proImagen = $row->proImagen;
            $proImagen = str_replace(URL, "", $proImagen);
            $subtotal += $Neto;
            $netofinal = $Neto + $DescPesos;
            $desc += $DescPesos;
            $contadorcaracteres = strlen($proTitulo);
            if($breakpage%8 == 0){
                $salto= '<br><br><br><br>';
            }else{
                $salto= '';
            }
            if($contadorcaracteres <= 100){
                $linebreak = "<br><br><br>";
            }else{
               $linebreak = "<br>"; 
            }
            if($descripciontitulo != ""){
               $proTitulo = $descripciontitulo;
            }
            $dibujardescolumna = "";
            if($desc != 0){
                $dibujardescolumna = '<td style="text-align: center;line-height:70em" >' . number_format($netofinal,2) . '</td>';

                $netofinal = $Neto;
            }
            $div .= $salto.'<tr>' .
                '<td style="text-align: center; line-height:70em;" >' . $Cantidad . '</td>' .
                '<td colspan="2"><div>' . $linebreak . $proTitulo . '</div></td>' .
                '<td colspan="2"><span class="img-container"><img class="etiqueta2" src="' . $proImagen . '"/></span></td>' .
                '<td class="numeros2" style="line-height:70em">' . number_format($PrecioVenta, 2) .'</td>' .
                '<td class="numeros2" style="line-height:70em">' . number_format($netofinal, 2) . '</td>' .
                '</tr>';

                $breakpage++;

        }
      $iva = $subtotal  * (16 / 100);
        $total = $ivatotal + $subtotal;
        $ttprincipal = $subtotal + $desc;
        $negritasinicial = "";
            $negritasfinal = "";
        if($idVendedor == 41 ){
            $negritasinicial = "<strong>";
            $negritasfinal = "</strong>";
        }
        $dibujardesc = '';
        $colspan = 6;
        if($desc != 0){
            $colspan = 6;
            $dibujardesc = '<tr>
                    <td class="numeros" colspan="'.$colspan.'"><b>DESCUENTO</b></td>
                    <td class="numeros"> ' . $negritasinicial . number_format($desc, 2) . $negritasfinal. '</td>
                </tr>';
        }
        $div .= '<!--<tr>
                    <td class="numeros" colspan="'.$colspan.'"><b>TOTAL</b></td>
                    <td class="numeros"> ' . $negritasinicial . number_format($ttprincipal, 2) .$negritasfinal. '</td>
                </tr>-->
                '.$dibujardesc.'
                <tr>
					<td class="numeros" colspan="'.$colspan.'"><b>SUB-TOTAL</b></td>
					<td class="numeros"> ' . $negritasinicial . number_format($subtotal, 2) .$negritasfinal. '</td>
				</tr>
				<tr>
					<td class="numeros" colspan="'.$colspan.'"><b>I.V.A.</b></td>
					<td class="numeros"> ' . $negritasinicial . number_format($ivatotal, 2) . $negritasfinal.'</td>
				</tr>
				<tr>
					<td class="numeros" colspan="'.$colspan.'"><b>TOTAL PAGAR</b></td>
					<td class="numeros"> ' . $negritasinicial .number_format($total, 2) . $negritasfinal. '</td>
				</tr>
			</tbody>
            </table>';

        $div .= '<p>
                        <b>Términos y Condiciones. </b>
                        <br>&nbsp;&nbsp;&nbsp;•&nbsp;&nbsp;&nbsp; Los precios son expresados en Moneda Nacional. 
                        <br>&nbsp;&nbsp;&nbsp;• &nbsp;&nbsp;&nbsp;En piezas eléctricas la garantía es de 5 días a partir de su compra, posterior aplica directo con el fabricante. 
                        <br>&nbsp;&nbsp;&nbsp;•&nbsp;&nbsp;&nbsp; Los equipos extintores nuevos cuentan con 5 años de garantía por defecto de fabricación y 1 año en su carga. 
                        <br><b>Tiempo de entrega: </b>
                        <br>&nbsp;&nbsp;&nbsp;•&nbsp;&nbsp;&nbsp; <strong>Comentarios del Vendedor</strong>: '.$detalle['Descripcion'].'
                        <br>&nbsp;&nbsp;&nbsp;•&nbsp;&nbsp;&nbsp; Entrega a domicilio de 3 a 8 días hábiles.
                        <br>&nbsp;&nbsp;&nbsp;•&nbsp;&nbsp;&nbsp; Todo equipo nuevo incluye instalacion se aplican restricciones*.
                        
                        <br>La presente cotización tiene validez de 7 días naturales a partir de la fecha de expedición.
                        <br><b>Para efectos de facturación</b> se requiere especificar forma de pago, uso de cfdi y método de pago.
                    </p>    
                    <p style="text-align: center;">
                        En espera de que nuestra cotización cumpla con sus requerimientos y de poder vernos favorecidos con su 
                        apreciable compra, nos despedimos quedando a sus órdenes para cualquier duda o aclaración al respecto.
                    </p>
                    <p>*Si la instalación es mayor a 3 metros de altura del piso al tope de la barda o se requiere una escalera mayor a 3 metros se aplican costos extras.</p>
                    <p style="text-align: center;">
                        <p><b>Atentamente,</b>
                        <br>' . $NombreUsuario . ' | Asesor de ventas
                        <br>Télefono: '.$telefonovendedor.'
                        <br>XTIN FIRE S.A. DE C.V.
                        <br>¡19 años trabajando por tu seguridad
                    </p>';

        // ---------------------------------------------------------

        // create new PDF document
        $pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

        // set document information
        $pdf->SetTitle('COTIZACIÓN');
        $pdf->SetKeywords('QR, PDF');

        // set header and footer fonts
        $pdf->setHeaderFont(array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));

        // set default monospaced font
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

        // set margins
        //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        // set margins
        $pdf->SetMargins("20", "30", "20");
        $pdf->SetHeaderMargin(0);
        $pdf->SetFooterMargin(0);

        // remove default footer
        $pdf->setPrintFooter(false);

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

        // set image scale factor
        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

        // set some language-dependent strings (optional)
        if (@file_exists(dirname(__FILE__) . '/lang/eng.php')) {
            require_once(dirname(__FILE__) . '/lang/eng.php');
            $pdf->setLanguageArray($l);
        }

        // ---------------------------------------------------------
        // set font
        $pdf->SetFont('helvetica', '', 12);

        // add a page
        $pdf->AddPage();

        $html = $div;
        $pdf->writeHTML($html, true, false, true, false, '');

        //Close and output PDF document
        $pdf->Output('cotizacion_' . $IdOrden . '.pdf', 'I');

        //============================================================+
        // END OF FILE
        //============================================================+
    }

    function pdfinvoice($IdInvoice)
    {

        ini_set('error_reporting', E_ALL);
        ini_set('display_errors', true);

        //Producto 
        //Mostrar un solo qr, buscar por claveprod
        $ordenes = new ordenesModel();
        $invoices = new invoicesModel();

        $invoices->IdInvoice = $IdInvoice;
        $detalle = $invoices->one();
        $ordenes->IdOrden = $detalle['IdOrden'];
        $rows = $ordenes->detalle();

        $IdInvoice = $detalle['IdInvoice'];
        $Nombre = $detalle['Nombre'];
        $FisTelefono = $detalle['FisTelefono'];
        $FisEmail = $detalle['FisEmail'];
        $EntCalle = $detalle['EntCalle'];
        $EntNExt = $detalle['EntNExt'];
        $EntColonia = $detalle['EntColonia'];
        $EntCP = $detalle['EntCP'];
        $EntMunicipio = $detalle['EntMunicipio'];
        $EntEstado = $detalle['EntEstado'];
        $imagen = crear_qr($detalle['FolioOrden']);
        $imagen = str_replace(URL, "", $imagen);
        $domicilio_completo = $EntCalle . " " . $EntNExt . " Colonia " . $EntColonia . " C.P. " . $EntCP . " " . $EntMunicipio . ", " . $EntEstado;
        $NombreUsuario =  $detalle['NombreUsuario'];
        $FE = $detalle['Fecha'];
        $arrMeses = array("enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre");
        $fecha = 'Guadalajara, Jal, a ' . date("d", strtotime($FE)) . " de " . $arrMeses[date("m", strtotime($FE)) - 1] . " del " . date("Y", strtotime($FE) . ".");

        $div = '
        <style>
        .etiqueta{
            height: 150px;
        }
        
        .etiqueta2{
            height: 80px;
        }

        .numeros{
            text-align: right;
        }
        
        .customers {
            font-family: Arial, Helvetica, sans-serif;
            border-collapse: collapse;
            width: 100%;
        }
          
        .customers td, #customers th {
            border: 1px solid #ddd;
            padding: 8px;
            font-size: 10px;
        }
          
        .customers th {
            padding-top: 12px;
            padding-bottom: 12px;
            text-align: center;
            background-color: #201E1F;
            color: white;
            font-size: 11px;
            white-space:nowrap;
        }
        
        td, th {
            font-size: 10px;
        }
          
        th {
            font-size: 11px;
        }
        
        p{
            font-size: 10px;
        }
        </style>

        <table style="width:100%" class=""><tbody>
        <tr>
            <td colspan="4"></td>
        </tr>
        <tr>
            <td colspan="4" style="text-align: right;">' . $fecha . '</td>
        </tr>
        <tr>
            <td colspan="4"></td>
        </tr>
        <tr>
            <td colspan="3"></td>
            <th rowspan="6"><img class="etiqueta" src="' . $imagen . '"/></th>
        </tr>
        <tr>
            <td colspan="3"><b>A/A: </b>' . $Nombre . '</td>
        </tr>
        <tr>
            <td colspan="3"><b>EMAIL: </b>' . $FisEmail . '</td>
        </tr>
        <tr>
            <td colspan="3"><b>TELÉFONO: </b>' . $FisTelefono . '</td>
        </tr>
        <tr>
            <td colspan="3"><b>DOMICILIO: </b>' . $domicilio_completo . '</td>
        </tr>
        <tr>
            <td colspan="5"></td>
        </tr>
        <tr>
            <td colspan="5" style="text-align: center;">
                Apreciable cliente, presentamos a usted la siguiente cotización solicitada para su consideración, esperando 
                que el contenido en la presente sea de su utilidad, agradeciéndole de antemano la oportunidad de ofrecerle nuestros 
                productos y servicios.
            </td>
        </tr>
        </tbody></table>';

        $div .= '<br><br><table class="customers">' .
            '<tbody><tr>' .
            '<th><b>CANTIDAD</b></th>' .
            '<th colspan="2"><b>DESCRIPCION</b></th>' .
            '<th colspan="2"><b>IMAGEN</b></th>' .
            '<th><b>P. UNITARIO</b></th>' .
            '<th><b>DESCUENTO</b></th>' .
            '<th><b>SUB-TOTAL</b></th>' .
            '</tr>';

        $subtotal = 0;
        foreach (to_object($rows) as $row) {
            $Cantidad = $row->Cantidad;
            $PrecioVenta = $row->PrecioVenta;
            $proTitulo = $row->proTitulo;
            $DescPesos = $row->DescPesos;
            $Neto = $row->Neto;
            $proImagen = $row->proImagen;
            $proImagen = str_replace(URL, "", $proImagen);
            $subtotal += $Neto;
            $almId = $row->proAlmId;
            if($almId != 2){
                    $div .= '<tr>' .
                '<td style="text-align: center;">' . $Cantidad . '</td>' .
                '<td colspan="2">' . $proTitulo . '</td>' .
                '<td colspan="2"><img class="etiqueta2" src="' . $proImagen . '"/></td>' .
                '<td class="numeros">' . number_format($PrecioVenta, 2) . '</td>' .
                '<td class="numeros">' . number_format($DescPesos, 2) . '</td>' .
                '<td class="numeros">' . number_format($Neto, 2) . '</td>' .
                '</tr>';
            }elseif ($almId == 2 AND $Neto>=100) {
                $div .= '<tr>' .
                '<td style="text-align: center;">' . $Cantidad . '</td>' .
                '<td colspan="2">' . $proTitulo . '</td>' .
                '<td colspan="2"><img class="etiqueta2" src="' . $proImagen . '"/></td>' .
                '<td class="numeros">' . number_format($PrecioVenta, 2) . '</td>' .
                '<td class="numeros">' . number_format($DescPesos, 2) . '</td>' .
                '<td class="numeros">' . number_format($Neto, 2) . '</td>' .
                '</tr>';
            }
            
        }
       $iva = $subtotal  * (16 / 100);
        $total = $iva + $subtotal;

        $div .= '<tr>
                <td class="numeros" colspan="7"><b>SUB-TOTAL</b></td>
                <td class="numeros"> ' . number_format($subtotal, 2) . '</td>
            </tr>
            <tr>
                <td class="numeros" colspan="7"><b>I.V.A.</b></td>
                <td class="numeros"> ' . number_format($iva, 2) . '</td>
            </tr>
            <tr>
                <td class="numeros" colspan="7"><b>TOTAL</b></td>
                <td class="numeros"> ' . number_format($total, 2) . '</td>
            </tr>
        </tbody>
        </table>';

        $div .= '<br><br><p>
                    <b>Términos y Condiciones. </b>
                    <br>&nbsp;&nbsp;&nbsp;•&nbsp;&nbsp;&nbsp; Los precios son expresados en Moneda Nacional. 
                    <br>&nbsp;&nbsp;&nbsp;• &nbsp;&nbsp;&nbsp;En piezas eléctricas la garantía es de 5 días a partir de su compra, posterior aplica directo con el fabricante. 
                    <br>&nbsp;&nbsp;&nbsp;•&nbsp;&nbsp;&nbsp; Los equipos extintores nuevos cuentan con 1 año de garantía por defecto de fabricación y 1 año en su carga. 
                    <br><b>Tiempo de entrega: </b>
                    <br>&nbsp;&nbsp;&nbsp;•&nbsp;&nbsp;&nbsp; Entrega a domicilio de 3 a 8 días hábiles.
                    <br>&nbsp;&nbsp;&nbsp;•&nbsp;&nbsp;&nbsp; Instalación sin costo no más de 3 metros de altura.
                    
                    <br>La presente cotización tiene validez de 7 días naturales a partir de la fecha de expedición.
                    <br><b>Para efectos de facturación</b> se requiere especificar FORMA DE PAGO, USO DE CFDI Y MÉTODO DE PAGO.
                </p>	
                <p style="text-align: center;">
                    En espera de que nuestra cotización cumpla con sus requerimientos y de poder vernos favorecidos con su 
                    apreciable compra, nos despedimos quedando a sus órdenes para cualquier duda o aclaración al respecto.
                </p>
                <p style="text-align: center;">
                    <p><b>Atentamente,</b>
                    <br>' . $NombreUsuario . ' | Asesor de ventas
                    <br>XTIN FIRE S.A. DE C.V.
                    <br>¡15 años trabajando por tu seguridad
                </p>';
        // ---------------------------------------------------------

        // create new PDF document
        $pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

        // set document information
        $pdf->SetTitle('ORDEN DE SERVICIO');
        $pdf->SetKeywords('QR, PDF');

        // set header and footer fonts
        $pdf->setHeaderFont(array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));

        // set default monospaced font
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

        // set margins
        //$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        // set margins
        $pdf->SetMargins("20", "30", "20");
        $pdf->SetHeaderMargin(0);
        $pdf->SetFooterMargin(0);

        // remove default footer
        $pdf->setPrintFooter(false);

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

        // set image scale factor
        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

        // set some language-dependent strings (optional)
        if (@file_exists(dirname(__FILE__) . '/lang/eng.php')) {
            require_once(dirname(__FILE__) . '/lang/eng.php');
            $pdf->setLanguageArray($l);
        }

        // ---------------------------------------------------------
        // set font
        $pdf->SetFont('helvetica', '', 12);

        // add a page
        $pdf->AddPage();

        $html = $div;
        $pdf->writeHTML($html, true, false, true, false, '');

        //Close and output PDF document
        $pdf->Output('invoice' . $IdInvoice . '.pdf', 'I');

        //============================================================+
        // END OF FILE
        //============================================================+
    }

    //--------------------------------------------------------------------PDF Garantía Orden--------------------------------------------------------------------
    function pdfgarantia($IdOrden)
    {
        ini_set('error_reporting', E_ALL);
        ini_set('display_errors', true);

        //Producto 
        //Mostrar un solo qr, buscar por claveprod
        $ordenes = new ordenesModel();
        $ordenes->IdOrden = $IdOrden;
        $detalle = $ordenes->one();
        $rows = $ordenes->detalle();

        //echo json_encode($detalle);
        $IdOrden = $detalle['IdOrden'];
        $FolioOrden = $detalle['FolioOrden'];

        $prod = new extintoresModel();
        $prod->FolioOrden = $FolioOrden;
        $rowext = $prod->all_orden();

        $Nombre = $detalle['Nombre'];
        $FisTelefono = $detalle['FisTelefono'];
        $EntCalle = $detalle['EntCalle'];
        $EntNExt = $detalle['EntNExt'];
        $EntColonia = $detalle['EntColonia'];
        $EntCP = $detalle['EntCP'];
        $EntMunicipio = $detalle['EntMunicipio'];
        $EntEstado = $detalle['EntEstado'];
        $NombreTipoOrden = $detalle['NombreTipoOrden'];
        $domicilio_completo = $EntCalle . " " . $EntNExt . " Colonia " . $EntColonia . " C.P. " . $EntCP . " " . $EntMunicipio . ", " . $EntEstado;

        $FE = $detalle['Fecha'];
        $arrMeses = array("enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre");
        $fecha = 'GUADALAJARA, JALISCO ' . date("d", strtotime($FE)) . " de " . $arrMeses[date("m", strtotime($FE)) - 1] . " del " . date("Y", strtotime($FE) . ".");

        $style = '<style>
        .etiqueta{
            height: 150px;
        }

        p{ 
            font-size: 12px; 
        }

        .numeros{
            text-align: right;
        }

        .titulo{
            text-align: center; color:red; background-color:#fff;
        }
        
        .customers {
            border: 1px solid #000;
            font-family: Arial, Helvetica, sans-serif;
            border-collapse: collapse;
            width: 100%;
            font-size: 10px;
        }
          
        .customers td, .customers th {
            border: 1px solid #000;
            padding: 8px;
        }
          
        .customers th {
            padding-top: 12px;
            padding-bottom: 12px;
            text-align: center;
            background-color: #fff;
            color: black;
        }
        </style>';

        $div = $style . '
            <h3 align="center"><b>POLIZA DE GARANTÍA.</b></h3>
			<h5><b>ESTA PÓLIZA DE GARANTÍA SERÁ VALIDA PARA LOS SIGUIENTES EQUIPOS</b></h5>
			
			   <table class="customers">
                <thead>
                    <tr>
                        <td style="text-align: center"><b>TIPO Y CARACTERÍSTICAS GENÉRICAS DEL EXTINTOR Y EXTINGUIDOR</b></td>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>RECIPIENTE DEL EXTINTOR PRESURIZADO PERMANENTEMENTE, CONTENIENDO COMO AGENTE EXTINGUIDOR AGUA; 
						AGUA CON ADITIVOS ESPUMA Y AGUA. EN SUS DIFERENTES CAPACIDADES.</td>
                    </tr>
					 <tr>
                        <td>RECIPIENTE DEL EXTINTOR PRESURIZADO PERMANENTEMENTE, CONTENIENDO COMO AGENTE EXTINGUIDOR POLVO 
						QUIMICO SECO AGENTES LIMPIOS QUIMICO HUMEDO. EN SUS DIFERENTES CAPACIDADES</td>
                    </tr>
					 <tr>
                        <td>RECIPIENTE DEL EXTINTOR PRESURIZADO PERMANENTEMENTE, CONTENIENDO COMO AGENTE EXTINGUIDOR POLVO 
						QUIMICO SECO AGENTES LIMPIOS QUIMICO HUMEDO. EN SUS DIFERENTES CAPACIDADES</td>
                    </tr>
					 <tr>
                        <td>EXTINTOR QUE CONTIENE COMO AGENTE EXTINGUIDOR POLVO QUIMICO SECO (COLOR ROSA) Y SE PRESURIZA AL 
						MOMENTO DE OPERARLO POR MEDIO DE GAS CONTENIDO EN CARTUCHOS O CAPSULAS, INTERNAS O EXTERNAS. EN 
						SUS DIFERENTES CAPACIDADES. <b> (NOM -154-SCFI-2005.)</b></td>
                    </tr>
					<tr>
                        <td>EXTINTOR QUE CONTIENE BIOXIDO DE CARBONO COMO AGENTE EXTINGUIDOR Y TODOS LOS CARTUCHOS O 
						CAPSULAS DE LOS EXTINTORES CATEGORIA 3 Y 4. EN SUS DIFERENTES CAPACIDADES.
						</td>
                    </tr>
                </tbody>
            </table>
			
            <p style="text-align: justify">
				<b>1. PARA HACER EFECTIVA ESTA GARANTÍA:</b><br>
				SE DEBE REPORTAR LA FALLA QUE PRESENTE EL EQUIPO A LAS OFICINAS POR VÍA TELEFÓNICA O POR ESCRITO A 
				<b>AMOR JOSE SILVA ESCALERA.</b><br>
				EL PERSONAL DE <b>AMOR JOSE SILVA ESCALERA</b> ACUDIRÁ A LAS INSTALACIONES DEL CLIENTE PARA REVISAR EL 
				EQUIPO Y DETERMINAR LA PROCEDENCIA O NO DE LA GARANTÍA.<br>
				DEBERÁ PRESENTAR LA PÓLIZA DE GARANTÍA VIGENTE, LA FACTURA Y EL EQUIPO.<br>
				LA EMPRESA <b>AMOR JOSE SILVA ESCALERA</b> SE COMPROMETE A REPARAR EL EQUIPO DEFECTUOSO 
				 QUE AMPARE LA FACTURA <b>N° ' . strtoupper($IdOrden) . '</b> CON NÚMERO DE ORDEN DE SERVICIO, <b>' . strtoupper($IdOrden) . '</b> PARA LA EMPRESA:
				<b>' . strtoupper($Nombre) . '</b> CON DOMICILIO: ' . strtoupper($domicilio_completo) . '.
            </p>


            <p style="text-align: justify">
            <br><b>CONDICIONES:</b>
            <br><b>1. </b>EL DOMICILIO PARA HACER VALIDA ESTA GARANTÍA, Y LOS TELÉFONOS DE AMOR JOSE SILVA ESCALERA VIENE ASENTADO AL FINAL DE ESTA PÓLIZA DE GARANTÍA.
            <br><b>2. </b>ESTA GARANTÍA SERÁ VALIDA DURANTE UN AÑO, CONTANDO A PARTIR DE LA FECHA MARCADA EN LA ETIQUETA DEL EQUIPO AL QUE SE LE PRESTO EL SERVICIO DE MANTENIMIENTO Y/O RECARGA.
            <br>
            <br><b>ESTA GARANTÍA NO SERÁ VALIDA EN LOS SIGUIENTES CASOS:</b>
            <br><b>1. </b>CUANDO NO CONSERVE EL SEGURO Y MARCHAMO DEL EQUIPO.
            <br><b>2. </b>CUANDO EL EQUIPO NO SEA OPERADO CORRECTAMENTE.
            <br><b>3. </b>CUANDO EL EQUIPO PRESENTE GOLPES O DAÑO QUE REPERCUTA EN EL BUEN FUNCIONAMIENTO DEL EQUIPO.
            <br><b>4. </b>CUANDO EL EQUIPO HAYA SIDO ALTERADO O REPARADO POR PERSONAS NO AUTORIZADAS POR AMOR JOSE SILVA ESCALERA.
			</p>  
			<p style="text-align: justify">
			<b>PRECAUCIONES:</b>
            <br>LOS EXTINTORES SON RECIPIENTES QUE SE ENCUENTRAN CON PRESION CONTENIDA DE 17 KGM/CM2, POR LO QUE 
			ES IMPORTANTE Y SE RECOMIENDA UN ALTO ADIESTRAMEINTO PARA SU MANEJO.
			<br>
            SIN MAS POR EL MOMENTO Y AGREDECIENDO SU PREFERENCIA, NOS REITERAMOS A SUS ORDENES.
            </p>
            <br>
            <p align="right">' . strtoupper($fecha) . '</p>';

        $div2 = $style . '<p style="text-align: justify">
        <br>AT`N: A QUIEN CORRESPONDA::
                <br>
                <br>
                <br>POR MEDIO DE LA PRESENTE INFORMAMOS A USTEDES QUE HEMOS REALIZADO EL SERVICIO DE
                REVISION Y MANTENIMIENTO Y/O RECARGA.                
                </p>';

        $div2 .= '<br><table class="customers" style="text-align:center;">' .
            '<tbody><tr>' .
            '<th><b>No.</b></th>' .
            '<th><b>Equipo</b></th>' .
            '<th><b>Capacidad</b></th>' .
            '<th><b>Ag. Ext.</b></th>' .
            '<th colspan="2"><b>Vence</b></th>' .
            '</tr>';

        foreach (to_object($rowext) as $row) {
            $IdExtintor = $row->IdExtintor;
            $catNombre = $row->catNombre;
            $Capacidad = $row->Capacidad;
            $Capacidad = $row->Capacidad;
            $Agentes = $row->Agentes;
            $Vencimiento = $row->Vencimiento;
            //echo str_replace('[]', '', $Agentes);

            $Agente = "";
            $div2 .= '<tr>' .
                '<td>' . $IdExtintor . '</td>' .
                '<td>' . $catNombre . '</td>' .
                '<td>' . $Capacidad . '</td>' .
                '<td>' . $Agente . '</td>' .
                '<td colspan="2">' . $Vencimiento . '</td>' .
                '</tr>';
        }

        $div2 .= '</tbody></table>
        <br><br><p style="text-align: justify">SEGÚN LO INDICA EL RECORD DE SERVICIO EN SU EQUIPO.
        <br>
        <br>LLAS RECARGAS DEL EQUIPO SE HA REALIZADO BAJO LAS ESPECIFICACIONES DE LA NORMA OFICIAL
        MEXICANA <b>NOM.-154-SCFI-2005</b>, POR LO ANTERIOR EXTENDEMOS NUESTRA GARANTIA EN LAS RECARGAS DE 
        LOS EQUIPOS.
        <br>
        <br>SIN MÁS POR EL MOMENTO EXTENDEMOS LA PRESENTE Y QUEDAMOS A USTEDES, MANTENIENDO EL FIRME 
        ESFUERZO Y COMPROMISO DE SERVIRLE.        
        </p>
        <br><br><br><br><br>
        <p align="right">' . strtoupper($fecha) . '</p>';


        // ---------------------------------------------------------
        // create new PDF document
        $pageLayout = array('215.9', '279.4'); //  or array($height, $width) 
        $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, $pageLayout, true, 'UTF-8', false);

        // set document information
        $pdf->SetKeywords('QR, PDF');

        // remove default header/footer
        $pdf->setPrintHeader(false);
        $pdf->setPrintFooter(false);

        // set margins
        $pdf->SetMargins("20", "40", "20");

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, "0");

        // set image scale factor
        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

        // set some language-dependent strings (optional)
        if (@file_exists(dirname(__FILE__) . '/lang/eng.php')) {
            require_once(dirname(__FILE__) . '/lang/eng.php');
            $pdf->setLanguageArray($l);
        }
        // ---------------------------------------------------------

        // set font
        $pdf->SetFont('helvetica', '', 12);
        //Pagina 1
        // add a page
        $pdf->AddPage();
        // create some HTML content


        // -- set new background ---
        // get the current page break margin
        $bMargin = $pdf->getBreakMargin();
        // get current auto-page-break mode
        $auto_page_break = $pdf->getAutoPageBreak();
        // disable auto-page-break
        $pdf->SetAutoPageBreak(false, 0);
        // set bacground image
        $pdf->Image('assets/img/images/formatos/encabezado.png', 0, 0, '215.9', 32, 'PNG', '', '', false, 300, '', false, false, 0, false, false, false);
        $pdf->Image('assets/img/images/formatos/pie.png', 0, 134.4, '215.9', 145, '', '', '', false, 300, '', false, false, 0);
        $pdf->Image('assets/img/images/formatos/firma.png', 60, 227, '64', 38, 'PNG', '', '', false, 300, '', false, false, 0, false, false, false);
        //$pdf->Image('assets/img/images/formatos/sello.png', 20, 227, '64', 38, 'PNG', '', '', false, 300, '', false, false, 0, false, false, false);

        // restore auto-page-break status
        $pdf->SetAutoPageBreak($auto_page_break, $bMargin);
        // set the starting point for the page content
        $pdf->setPageMark();
        // -- set new background ---


        // output the HTML content
        $pdf->writeHTML($div, true, false, true, false, '');

        //Pagina 2
        $pdf->AddPage();
        // create some HTML content

        // -- set new background ---
        // get the current page break margin
        $bMargin = $pdf->getBreakMargin();
        // get current auto-page-break mode
        $auto_page_break = $pdf->getAutoPageBreak();
        // disable auto-page-break
        $pdf->SetAutoPageBreak(false, 0);
        // set bacground image
        $pdf->Image('assets/img/images/formatos/encabezado.png', 0, 0, '215.9', 32, 'PNG', '', '', false, 300, '', false, false, 0, false, false, false);
        $pdf->Image('assets/img/images/formatos/pie.png', 0, 134.4, '215.9', 145, '', '', '', false, 300, '', false, false, 0);
        $pdf->Image('assets/img/images/formatos/firma.png', 80, 160, '64', 38, 'PNG', '', '', false, 300, '', false, false, 0, false, false, false);
        // restore auto-page-break status
        $pdf->SetAutoPageBreak($auto_page_break, $bMargin);
        // set the starting point for the page content
        $pdf->setPageMark();
        // -- set new background ---

        // output the HTML content
        $pdf->writeHTML($div2, true, false, true, false, '');

        //Close and output PDF document
        $pdf->Output('etiquetas.pdf', 'I');
    }

    //--------------------------------------------------------------------PDF Baja Extintor Orden--------------------------------------------------------------------
    function pdfbaja($IdOrden, $ClaveExtintor)
    {
        ini_set('error_reporting', E_ALL);
        ini_set('display_errors', true);

        //Producto 
        //Mostrar un solo qr, buscar por claveprod
        $ordenes = new ordenesModel();
        $ordenes->IdOrden = $IdOrden;
        $detalle = $ordenes->one();
        $rows = $ordenes->detalle();

        $IdOrden = $detalle['IdOrden'];
        $FolioOrden = $detalle['FolioOrden'];

        $prod = new extintoresModel();
        $prod->FolioOrden = $FolioOrden;
        $rowext = $prod->all_orden();

        $Nombre = $detalle['Nombre'];
        $FisTelefono = $detalle['FisTelefono'];
        $EntCalle = $detalle['EntCalle'];
        $EntNExt = $detalle['EntNExt'];
        $EntColonia = $detalle['EntColonia'];
        $EntCP = $detalle['EntCP'];
        $EntMunicipio = $detalle['EntMunicipio'];
        $EntEstado = $detalle['EntEstado'];
        $NombreTipoOrden = $detalle['NombreTipoOrden'];
        $domicilio_completo = $EntCalle . " " . $EntNExt . " Colonia " . $EntColonia . " C.P. " . $EntCP . " " . $EntMunicipio . ", " . $EntEstado;

        $ext = new extintoresModel();
        $ext->ClaveExtintor = $ClaveExtintor;
        $bextintor = $ext->one_clave();
        $extintor = to_object($bextintor);
        /*
        {
            "IdExtintor": "25",
            "FechaAlta": "0000-00-00",
            "ClaveExtintor": "176LX1HTBT",
            "FolioOrden": "00000091",
            "IdProducto": "3",
            "Marca": "0",
            "Capacidad": null,
            "TipoExtintor": "Cilindro",
            "Agentes": null,
            "Ubicacion": "Sala de estar",
            "IdCliente": "1",
            "FechaEntrega": "2023-03-23",
            "Vencimiento": null,
            "UltimaRevisionPH": null,
            "CausaBaja": null,
            "Estatus": "1",
            "proTitulo": "Extintor 4.5KG",
            "proSku": "EX9371",
            "proPrecioventa": "100.00",
            "proCatId": "1",
            "catNombre": "EXTINTORES",
            "Nombre": "Diana Quintero Castell\u00f3n"
        }
        */

        $style = '<style>
            .etiqueta{
                height: 150px;
            }
    
            p{ 
                font-size: 12px; 
            }
    
            .numeros{
                text-align: right;
            }
    
            .titulo{
                text-align: center; color:red; background-color:#fff;
            }
            
            .customers {
                border: 1px solid #000;
                font-family: Arial, Helvetica, sans-serif;
                border-collapse: collapse;
                width: 100%;
                font-size: 10px;
            }
              
            .customers td, .customers th {
                border: 1px solid #000;
                padding: 8px;
            }
              
            .customers th {
                padding-top: 12px;
                padding-bottom: 12px;
                text-align: center;
                background-color: #fff;
                color: black;
            }
            </style>';

        $div = $style . '
                <p align="center">DEVOLUCIÓN DE EXTINTOR.</p>
                <p style="text-align: justify">
                <br><b>CLIENTE: </b> ' . $Nombre . '
                <br><b>DOMICILIO: </b> ' . $domicilio_completo . ' <b>COL: </b>' . $EntColonia . '
                <br><b>MUNICIPIO: </b> ' . $EntMunicipio . ' <b>TEL: </b>' . $FisTelefono . '
                </p>
                <p style="text-align: justify">
                <br>DESCRIPCIÓN DEL EQUIPO<br>

                <br><b>TIPO: </b> 
                <label>' . $extintor->TipoExtintor . '</label>

                <br><b>FECHA ULTIMA PH: </b>
                <label>' . $extintor->UltimaRevisionPH . '</label>

                <br><b>EQUIPO: </b>
                <label>' . $extintor->Agentes . '</label>
                
                <br><b>CANT: </b>
                <label>' . '1' . '</label>

                <br><b>MARCA: </b>
                <label>' . $extintor->Marca . '</label>

                <br><b>CAP.: </b>
                <label>' . $extintor->Capacidad . '</label>

                <br><b>FECHA O # DE FABRICACIÓN.: </b>
                <label>' . $extintor->FechaAlta . '</label>
                <br>
                <br>CAUSAS
                <br>
                <label>' . $extintor->CausaBaja . '</label>
                <br>
                <br>* La vida útil del recipiente es de 20 años como plazo máximo y deberán aplicarse hasta 4 pruebas hidrostáticas de baja presión con
                intervalos de 5 años después de su fecha de elaboración, o en caso de no contar con ella, conforme a norma <b>REF. NOM-002-STPS</b>
                o <b>NOM-154-SCFI-2005.</b>
                <br>
                <br>* Extintores que no se deben someter a servicio indicados en el punto 5.6.1 y 5.6.3 de la <b>NOM-154-SCFI-2005.</b>
                <br>
                <br>Por lo antes mencionado se le hace la devolución su equipo, recomendándole el reemplazo por un equipo por un equipo nuevo de acuerdo al punto 5.6.2 indicado en la <b>NOM-154-SCFI-2005</b>
                <br>
                <br>Xtinfire a través de su representante (Amor José Silva Escalera) no se hace responsable por el mal uso que se le de al equipo aquí
                reportado.
                <br>
                <br>Quedando de antemano a sus órdenes, nos despedimos de ustedes esperando cualquier duda y/o aclaración al respecto, para
                una mejor atención y servicio de nuestra empresa.
                </p>';

        // ---------------------------------------------------------
        // create new PDF document
        $pageLayout = array('215.9', '279.4'); //  or array($height, $width) 
        $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, $pageLayout, true, 'UTF-8', false);

        // set document information
        $pdf->SetKeywords('QR, PDF');

        // remove default header/footer
        $pdf->setPrintHeader(false);
        $pdf->setPrintFooter(false);

        // set margins
        $pdf->SetMargins("20", "40", "20");

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, "0");

        // set image scale factor
        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

        // set some language-dependent strings (optional)
        if (@file_exists(dirname(__FILE__) . '/lang/eng.php')) {
            require_once(dirname(__FILE__) . '/lang/eng.php');
            $pdf->setLanguageArray($l);
        }
        // ---------------------------------------------------------

        // set font
        $pdf->SetFont('helvetica', '', 12);
        //Pagina 1
        // add a page
        $pdf->AddPage();
        // create some HTML content

        // -- set new background ---
        // get the current page break margin
        $bMargin = $pdf->getBreakMargin();
        // get current auto-page-break mode
        $auto_page_break = $pdf->getAutoPageBreak();
        // disable auto-page-break
        $pdf->SetAutoPageBreak(false, 0);
        // set bacground image
        $pdf->Image('assets/img/images/formatos/encabezado.png', 0, 0, '215.9', 32, 'PNG', '', '', false, 300, '', false, false, 0, false, false, false);
        $pdf->Image('assets/img/images/formatos/pie.png', 0, 134.4, '215.9', 145, '', '', '', false, 300, '', false, false, 0);
        // restore auto-page-break status
        $pdf->SetAutoPageBreak($auto_page_break, $bMargin);
        // set the starting point for the page content
        $pdf->setPageMark();
        // -- set new background ---

        // output the HTML content
        $pdf->writeHTML($div, true, false, true, false, '');

        //Close and output PDF document
        $pdf->Output('etiquetas.pdf', 'I');
    }
}
