<?php
class MYPDF extends TCPDF
{
    //Page header
    public function Header()
    {
        // get the current page break margin
        $bMargin = $this->getBreakMargin();
        // get current auto-page-break mode
        $auto_page_break = $this->AutoPageBreak;
        // disable auto-page-break
        $this->SetAutoPageBreak(false, 0);
        // set bacground image
        $img_file =  'assets/img/images/formatos/portada.png';
        $this->Image($img_file, 0, 0, 210, 297, '', '', '', false, 300, '', false, false, 0);
        // restore auto-page-break status
        $this->SetAutoPageBreak($auto_page_break, $bMargin);
        // set the starting point for the page content
        $this->setPageMark();
        
    }
    public function Footer() {
		// Position at 15 mm from bottom
		$this->SetY(-20);
		// Set font
		$this->SetFont('helvetica', 'I', 8);
		// Page number
         $this->html = '<hr><span>*Listado de productos uso interno exclusivo GRUPO XTINFIRE.</span>';
        $this->writeHTML($this->html, true, false, true, false, '');
		$this->Cell(0, 5, 'Página '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
	}
}

class pdfreportesController
{   var $Void = "";
    var $SP = " ";
    var $Dot = ".";
    var $Zero = "0";
    var $Neg = "Menos";

    function __construct()
    {
    }

    function index()
    {
        Redirect::to('./reportes');
    }

function pdfcatalogo(){
    if ($_SERVER["REQUEST_METHOD"] !== "POST") { Redirect::to('./reportes'); return; }

    // ===== ENTRADAS FRONT =====
    $departamento   = isset($_POST["departamento"])  ? trim($_POST["departamento"])  : "";
    $reporte        = isset($_POST["reporte"])       ? trim($_POST["reporte"])       : "";
    $fecha_inicial  = isset($_POST["fecha_inicial"]) ? trim($_POST["fecha_inicial"]) : "";
    $fecha_final    = isset($_POST["fecha_final"])   ? trim($_POST["fecha_final"])   : "";
    $vista          = isset($_POST["vista"])         ? trim($_POST["vista"])         : "lista"; // lista|cuadros
    $categoriasPost = (isset($_POST["categorias"]) && is_array($_POST["categorias"])) ? $_POST["categorias"] : [];

    // ===== OPCIONES AVANZADAS (checks) =====
    $opt_existencias         = !empty($_POST["existencias"]);          // proExistencia
    $opt_costo_compra        = !empty($_POST["costo_compra"]);         // proPreciocosto
    $opt_max_min             = !empty($_POST["max_min"]);              // proMax, proMin
    $opt_mostrar_descripcion = !empty($_POST["mostrar_descripcion"]);  // proTitulo
    $opt_mostrar_sku         = !empty($_POST["mostrar_sku"]);          // proSku
    $opt_mostrar_imagen      = !empty($_POST["mostrar_imagen"]);       // proImagen
    $opt_mostrar_precio      = !empty($_POST["mostrar_precio"]);       // proPrecioventa

    // ===== DEFAULTS (si no se marcó nada): SKU + PRECIO =====
    $ningunaMarcada = !$opt_existencias && !$opt_costo_compra && !$opt_max_min && !$opt_mostrar_descripcion && !$opt_mostrar_sku && !$opt_mostrar_imagen && !$opt_mostrar_precio;
    if ($ningunaMarcada) {
        $opt_mostrar_sku    = true;
        $opt_mostrar_precio = true;
    }

    // ===== SELECT dinámico (sólo lo pedido) =====
    $cols = [];
    if ($opt_existencias)         { $cols[] = "proExistencia"; }
    if ($opt_costo_compra)        { $cols[] = "proPreciocosto"; }
    if ($opt_max_min)             { $cols[] = "proMax"; $cols[] = "proMin"; }
    if ($opt_mostrar_descripcion) { $cols[] = "proTitulo"; }
    if ($opt_mostrar_sku)         { $cols[] = "proSku"; }
    if ($opt_mostrar_imagen)      { $cols[] = "proImagen"; }
    if ($opt_mostrar_precio)      { $cols[] = "proPrecioventa"; }

    // Para asegurar la portada en "cuadros", traemos SIEMPRE proTitulo y proImagen
    if (!in_array("proTitulo", $cols))  { $cols[] = "proTitulo"; }
    if (!in_array("proImagen", $cols))  { $cols[] = "proImagen"; }
    // Y necesitamos proCatId para separar por categoría
    if (!in_array("proCatId", $cols))   { $cols[] = "proCatId"; }

    $cols = array_values(array_unique($cols));
    $colsSql = implode(",", $cols);

    // WHERE (categorías si llegaron)
    $cond = ["Activo = 1", "proAlmId NOT IN (5,4)"];
    $catIds = [];
    foreach ($categoriasPost as $cv) { $id=(int)$cv; if($id>0) $catIds[]=$id; }
    if (!empty($catIds)) { $cond[] = "proCatId IN (" . implode(",", $catIds) . ")"; }

    $sentenciasql = "SELECT {$colsSql} FROM productos WHERE ".implode(" AND ", $cond)." ORDER BY proCatId ASC";

    // ===== Consulta
    $prod = new productosModel();
    $prod->sentencia = $sentenciasql;
    $result = $prod->catalogoproductos();

    // ===== PDF base
    $pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
    $pdf->SetTitle('CATÁLOGO DE PRODUCTOS');
    $pdf->setPrintHeader(false);
    $pdf->SetMargins(13, 15, 5, true);
    $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
    $pdf->SetFont('helvetica','',12);

    $pdf->AddPage();
    // Encabezado visual
    $bMargin = $pdf->getBreakMargin();
    $auto_page_break = $pdf->getAutoPageBreak();
    $pdf->SetAutoPageBreak(false, 0);
    $img_head = 'assets/img/images/formatos/encabezado.png';
    if (file_exists($img_head)) { $pdf->Image($img_head, 0, 0, 210, 23, '', '', '', false, 300, '', false, false, 0); }
    $pdf->SetAutoPageBreak($auto_page_break, $bMargin);
    $pdf->setPageMark();

    $isCuadros = (strtolower($vista) === 'cuadros');

    if (!$isCuadros) {
        // ====== VISTA LISTA: TABLA DINÁMICA ======
        $columns = [];
        if ($opt_mostrar_sku)         $columns[] = ['key'=>'sku',    'label'=>'SKU',         'width'=>80];
        if ($opt_mostrar_descripcion) $columns[] = ['key'=>'titulo', 'label'=>'Descripción', 'width'=>220];
        if ($opt_existencias)         $columns[] = ['key'=>'exist',  'label'=>'Existencia',  'width'=>80];
        if ($opt_max_min) {
            $columns[] = ['key'=>'max', 'label'=>'Max', 'width'=>60];
            $columns[] = ['key'=>'min', 'label'=>'Min', 'width'=>60];
        }
        if ($opt_mostrar_precio)      $columns[] = ['key'=>'precio', 'label'=>'Precio',      'width'=>80];
        if ($opt_costo_compra)        $columns[] = ['key'=>'costo',  'label'=>'Costo',       'width'=>80];
        if ($opt_mostrar_imagen)      $columns[] = ['key'=>'imagen', 'label'=>'Imagen',      'width'=>100];

        if (empty($columns)) {
            // Defensa extra (no debería suceder por los defaults)
            $columns = [
                ['key'=>'sku','label'=>'SKU','width'=>100],
                ['key'=>'precio','label'=>'Precio','width'=>100],
            ];
        }

        $thead = '<tr style="color:#0000FF;">';
        foreach ($columns as $c) {
            $thead .= '<td width="'.$c['width'].'" align="center" style="font-size:12px;">'.htmlspecialchars($c['label']).'</td>';
        }
        $thead .= '</tr>';

        $html = '<div style="text-align:center;"><h2>CATÁLOGO DE PRODUCTOS</h2></div>';
        $html .= '<table border="1" cellpadding="1" cellspacing="1"><thead>'.$thead.'</thead>';

        $get = function($row,$p,$d=null){ return isset($row->$p)?$row->$p:$d; };

        foreach (to_object($result) as $row) {
            $titulo = $get($row,'proTitulo','');
            $sku    = $get($row,'proSku',null);
            $exist  = $get($row,'proExistencia',null);
            $max    = $get($row,'proMax',null);
            $min    = $get($row,'proMin',null);
            $precio = $get($row,'proPrecioventa',null);
            $costo  = $get($row,'proPreciocosto',null);
            $img    = $get($row,'proImagen',null);

            $html .= '<tr>';
            foreach ($columns as $c) {
                $w=$c['width']; $key=$c['key']; $val='—';
                if ($key==='sku')     $val = $sku ?: '—';
                if ($key==='titulo')  $val = $titulo ?: '—';
                if ($key==='exist')   $val = ($exist!==null ? $exist : '—');
                if ($key==='max')     $val = ($max!==null ? $max : '—');
                if ($key==='min')     $val = ($min!==null ? $min : '—');
                if ($key==='precio')  $val = ($precio!==null && $precio!=='') ? ('$'.number_format((float)$precio,2,'.',',')) : '—';
                if ($key==='costo')   $val = ($costo!==null && $costo!=='') ? ('$'.number_format((float)$costo,2,'.',',')) : '—';

                if ($key==='imagen') {
                    $cell = $img ? '<img style="width:70px;height:50px;object-fit:contain;" src="'.htmlspecialchars($img).'"/>' : '—';
                    $html .= '<td width="'.$w.'" align="center"><p style="font-size:10px;">'.$cell.'</p></td>';
                } else {
                    $html .= '<td width="'.$w.'" align="center"><p style="font-size:10px;">'.htmlspecialchars((string)$val).'</p></td>';
                }
            }
            $html .= '</tr>';
        }
        $html .= '</table>';
        $pdf->writeHTML($html,true,false,true,false,'');

    } else {
        // ====== VISTA CUADROS: PORTADA POR CATEGORÍA + TARJETAS ======
        $pdf->setEqualColumns(3);

        $get = function($row,$p,$d=null){ return isset($row->$p)?$row->$p:$d; };

        $catPrev = null;
        $col     = 0;   // columna actual (0..2)
        $cards   = 0;   // tarjetas en la página

        foreach (to_object($result) as $row) {
            $catId  = $get($row,'proCatId', null);
            $titulo = $get($row,'proTitulo','');
            $img    = $get($row,'proImagen',null);
            $sku    = $get($row,'proSku',null);
            $precio = $get($row,'proPrecioventa',null);
            $exist  = $get($row,'proExistencia',null);
            $max    = $get($row,'proMax',null);
            $min    = $get($row,'proMin',null);
            $costo  = $get($row,'proPreciocosto',null);

            // ---- Cambio de categoría => PORTADA (título SIEMPRE) ----
            if ($catPrev !== $catId) {
                $pdf->setPrintHeader(false);
                $pdf->AddPage();

                // fondo portada
                $bMargin = $pdf->getBreakMargin();
                $auto_page_break = $pdf->getAutoPageBreak();
                $pdf->SetAutoPageBreak(false, 0);
                $img_bg = 'assets/img/images/formatos/portadaprimera.png';
                if (file_exists($img_bg)) {
                    $pdf->Image($img_bg, 0, 0, 210, 297, '', '', '', false, 300, '', false, false, 0);
                }
                $pdf->SetAutoPageBreak($auto_page_break, $bMargin);
                $pdf->setPageMark();

                // ✅ Título en portada SIEMPRE
                $tituloPort = (isset($titulo) && trim($titulo) !== '') ? $titulo : 'Catálogo';
                $pdf->writeHTMLCell(
                    200, 0, 10, 10,
                    '<div style="text-align:center;"><h2 style="color:#fff;">'.htmlspecialchars($tituloPort).'</h2></div>',
                    0, 1, false, true, 'L', true
                );

                // En portada (opcional) imagen / precio / sku según checks
                $imgPortada = ($opt_mostrar_imagen && $img)
                    ? '<img style="width:200px;max-width:100%;height:180px;" src="'.htmlspecialchars($img).'"/>'
                    : '';
                $skuTxt    = ($opt_mostrar_sku && $sku) ? ('SKU: '.htmlspecialchars($sku)) : '';
                $precioTxt = ($opt_mostrar_precio && $precio!=='')
                                ? ('Precio: $'.number_format((float)$precio,2,'.',',')) : '';
                $txtPort   = trim($precioTxt . ($skuTxt ? ('  '.$skuTxt) : ''));

                $pdf->writeHTMLCell(
                    200, 0, 10, 100,
                    '<div style="text-align:center;">
                        <p>'.$imgPortada.'</p>
                        <p style="font-size:30px;text-align:center;color:#fff;">'.htmlspecialchars($txtPort).'</p>
                     </div>',
                    0, 1, false, true, 'L', true
                );

                // Reinicio y página de tarjetas
                $catPrev = $catId;
                $col = 0;
                $cards = 0;

                $pdf->AddPage();
                $pdf->setEqualColumns(3);
            }

            // ---- Tarjeta del producto (muestra solo lo marcado) ----
            $pdf->selectColumn($col);

            $card = '<table border="0" cellpadding="0" style="width:210px;min-height:220px;"><tr><td style="text-align:center;">';
            if ($opt_mostrar_descripcion && $titulo) $card .= '<p style="font-size:10px;font-weight:bold;">'.htmlspecialchars($titulo).'</p>';
            if ($opt_mostrar_imagen && $img)         $card .= '<p><img style="width:100px;height:80px;object-fit:contain;" src="'.htmlspecialchars($img).'"/></p>';
            if ($opt_mostrar_sku && $sku)            $card .= '<p style="font-size:10px;">SKU: '.htmlspecialchars($sku).'</p>';
            if ($opt_existencias && $exist!==null)   $card .= '<p style="font-size:9px;">Existencia: '.htmlspecialchars((string)$exist).'</p>';
            if ($opt_max_min && ($max!==null || $min!==null)) $card .= '<p style="font-size:9px;">Máx: '.htmlspecialchars((string)($max??'—')).'  Mín: '.htmlspecialchars((string)($min??'—')).'</p>';
            if ($opt_mostrar_precio && $precio!=='') $card .= '<p style="font-size:10px;">Precio: $'.number_format((float)$precio,2,'.',',').'</p>';
            if ($opt_costo_compra && $costo!=='')    $card .= '<p style="font-size:9px;color:#444;">Costo: $'.number_format((float)$costo,2,'.',',').'</p>';
            $card .= '</td></tr></table>';

            $pdf->writeHTML($card,true,false,true,false,'');

            // columnas/paginación
            $col++; $cards++;
            if ($col===3) { $col=0; $pdf->resetColumns(); $pdf->setEqualColumns(3); }
            if ($cards===12){ $pdf->AddPage(); $pdf->setEqualColumns(3); $cards=0; }
        }
    }

    $pdf->Output('catalogo_productos.pdf', 'I');
}
// Terminan reporte Catalogo de productos
//Inicia pdf inventarios
function pdfinvetarios(){
    if ($_SERVER["REQUEST_METHOD"] !== "POST") { Redirect::to('./reportes'); return; }

    // === ENTRADAS FRONT ===
    $fecha_inicial  = isset($_POST["fecha_inicial"]) ? trim($_POST["fecha_inicial"]) : "";
    $fecha_final    = isset($_POST["fecha_final"])   ? trim($_POST["fecha_final"])   : "";
    $vista          = isset($_POST["vista"])         ? trim($_POST["vista"])         : "lista";
    $inv_almacen_id = isset($_POST["inv_almacen_id"]) && $_POST["inv_almacen_id"] !== "" ? (int)$_POST["inv_almacen_id"] : null;
    $categoriasPost = (isset($_POST["categorias"]) && is_array($_POST["categorias"])) ? $_POST["categorias"] : [];

    // Checks avanzados
    $opt_existencias         = !empty($_POST["existencias"]);          // proExistencia
    $opt_costo_compra        = !empty($_POST["costo_compra"]);         // proPreciocosto
    $opt_max_min             = !empty($_POST["max_min"]);              // proMax, proMin
    $opt_mostrar_descripcion = !empty($_POST["mostrar_descripcion"]);  // proTitulo
    $opt_mostrar_sku         = !empty($_POST["mostrar_sku"]);          // proSku
    $opt_mostrar_imagen      = !empty($_POST["mostrar_imagen"]);       // proImagen
    $opt_mostrar_precio      = !empty($_POST["mostrar_precio"]);       // proPrecioventa

    // ==== SELECT dinámico (sólo columnas pedidas) ====
    $cols = [];
    if ($opt_existencias)         { $cols[] = "proExistencia"; }
    if ($opt_costo_compra)        { $cols[] = "proPreciocosto"; }
    if ($opt_max_min)             { $cols[] = "proMax"; $cols[] = "proMin"; }
    if ($opt_mostrar_descripcion) { $cols[] = "proTitulo"; }
    if ($opt_mostrar_sku)         { $cols[] = "proSku"; }
    if ($opt_mostrar_imagen)      { $cols[] = "proImagen"; }
    if ($opt_mostrar_precio)      { $cols[] = "proPrecioventa"; }

    // Fallback mínimo si no se marcó nada: al menos título
    if (empty($cols)) { $cols[] = "proTitulo"; $opt_mostrar_descripcion = true; }

    // SIEMPRE traemos FechaActualizacion (Última compra) para mostrarla como columna fija
    $cols = array_values(array_unique($cols));
    $colsSql = implode(",", $cols) . ", FechaActualizacion, proCatId";

    $selectBase = "SELECT {$colsSql} FROM productos WHERE ";
    $cond = [];
    $cond[] = ($inv_almacen_id !== null) ? "proAlmId = {$inv_almacen_id}" : "proAlmId NOT IN (5,4)";
    $cond[] = "Activo = 1";

    // Categorías
    $catIds = [];
    foreach ($categoriasPost as $cv) { $id = (int)$cv; if ($id > 0) $catIds[] = $id; }
    if (!empty($catIds)) { $cond[] = "proCatId IN (" . implode(",", $catIds) . ")"; }

    $sentenciasql = $selectBase . implode(" AND ", $cond) . " ORDER BY proCatId ASC";

    // === Consulta
    $prod = new productosModel();
    $prod->sentencia = $sentenciasql;
    $result = $prod->catalogoproductos();

    // ==== PDF ====
    $pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
    $pdf->SetTitle('INVENTARIO DE PRODUCTOS');
    $pdf->setPrintHeader(false);
    $pdf->setHeaderFont(array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
    $pdf->SetMargins("20", "30", "20");
    $pdf->SetHeaderMargin(0);
    $pdf->SetFooterMargin(0);
    $pdf->setPrintFooter(false);
    $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
    if (@file_exists(dirname(__FILE__) . '/lang/eng.php')) { require_once(dirname(__FILE__) . '/lang/eng.php'); $pdf->setLanguageArray($l); }
    $pdf->SetFont('helvetica', '', 12);
    $pdf->SetMargins(13, 15, 5, true);

    // === Armar columnas de la tabla según checks ===
    $columns = []; // cada item: ['key'=>'sku','label'=>'SKU','width'=>80]
    if ($opt_mostrar_sku)         $columns[] = ['key'=>'sku',    'label'=>'SKU',         'width'=>80];
    if ($opt_mostrar_descripcion) $columns[] = ['key'=>'titulo', 'label'=>'Descripción', 'width'=>220];
    if ($opt_existencias)         $columns[] = ['key'=>'exist',  'label'=>'Existencia',  'width'=>80];
    if ($opt_max_min) {
        $columns[] = ['key'=>'max', 'label'=>'Max', 'width'=>80];
        $columns[] = ['key'=>'min', 'label'=>'Min', 'width'=>80];
    }
    if ($opt_mostrar_precio)      $columns[] = ['key'=>'precio', 'label'=>'Precio',      'width'=>80];
    if ($opt_costo_compra)        $columns[] = ['key'=>'costo',  'label'=>'Costo compra','width'=>80];
    if ($opt_mostrar_imagen)      $columns[] = ['key'=>'imagen', 'label'=>'Imagen',      'width'=>100];

    // Columna fija "Última compra"
    $columns[] = ['key'=>'ultima', 'label'=>'Última compra', 'width'=>100];

    // Header dinámico
    $thead = '<tr style="color:#0000FF;">';
    foreach ($columns as $c) {
        $thead .= '<td width="'.$c['width'].'" align="center">'.htmlspecialchars($c['label']).'</td>';
    }
    $thead .= '</tr>';

    $divtitle = '<div style="text-align: center;"><h2 style="color:#000;">INVENTARIO DE PRODUCTOS</h2></div>';
    $divtablaini = '<table border="1" cellpadding="1" cellspacing="1"><thead>'.$thead.'</thead>';
    $div = "";

    $get = function($row, $prop, $default=null){ return isset($row->$prop) ? $row->$prop : $default; };

    foreach (to_object($result) as $row) {
        $titulo  = $get($row, 'proTitulo', '');
        $sku     = $get($row, 'proSku', null);
        $exist   = $get($row, 'proExistencia', null);
        $maximo  = $get($row, 'proMax', null);
        $minimo  = $get($row, 'proMin', null);
        $precio  = $get($row, 'proPrecioventa', null);
        $costo   = $get($row, 'proPreciocosto', null);
        $img     = $get($row, 'proImagen', null);
        $ultima  = $get($row, 'FechaActualizacion', null);

        $div .= '<tr>';
        foreach ($columns as $c) {
            $w = $c['width']; $key = $c['key']; $val = '—';
            if ($key === 'sku')     { $val = $sku ?: '—'; }
            if ($key === 'titulo')  { $val = $titulo ?: '—'; }
            if ($key === 'exist')   { $val = ($exist !== null ? $exist : '—'); }
            if ($key === 'max')     { $val = ($maximo !== null ? $maximo : '—'); }
            if ($key === 'min')     { $val = ($minimo !== null ? $minimo : '—'); }
            if ($key === 'precio')  { $val = ($precio !== null && $precio !== '') ? ('$'.number_format((float)$precio, 2, '.', ',')) : '—'; }
            if ($key === 'costo')   { $val = ($costo !== null && $costo !== '') ? ('$'.number_format((float)$costo, 2, '.', ',')) : '—'; }
            if ($key === 'ultima')  { $val = $ultima ? date('Y/m/d', strtotime($ultima)) : '—'; }

            if ($key === 'imagen') {
                $cell = $img ? '<img style="width:70px;height:50px;object-fit:contain;" src="'.htmlspecialchars($img).'"/>' : '—';
                $div .= '<td width="'.$w.'" align="center"><p style="font-size:10px;">'.$cell.'</p></td>';
            } else {
                $div .= '<td width="'.$w.'" align="center"><p style="font-size:10px;">'.htmlspecialchars((string)$val).'</p></td>';
            }
        }
        $div .= '</tr>';
    }

    $html = $divtitle.$divtablaini.$div."</table>";

    // Encabezado y salida
    $pdf->AddPage();
    $bMargin = $pdf->getBreakMargin();
    $auto_page_break = $pdf->getAutoPageBreak();
    $pdf->SetAutoPageBreak(false, 0);
    $img_file = 'assets/img/images/formatos/encabezado.png';
    if (file_exists($img_file)) { $pdf->Image($img_file, 0, 0, 210, 23, '', '', '', false, 300, '', false, false, 0); }
    $pdf->SetAutoPageBreak($auto_page_break, $bMargin);
    $pdf->setPageMark(); 
    $pdf->setPrintFooter(true);

    $pdf->writeHTML($html,true, false, true, false, '');
    $pdf->Output('reporte_de_inventarios.pdf', 'I');
}
// Termina pdf inventarios
// Inicia pdf inventarios tienda
function pdfinvetariostienda(){
    if ($_SERVER["REQUEST_METHOD"] !== "POST") { Redirect::to('./reportes'); return; }

    // ENTRADAS
    $fecha_inicial  = isset($_POST["fecha_inicial"]) ? trim($_POST["fecha_inicial"]) : "";
    $fecha_final    = isset($_POST["fecha_final"])   ? trim($_POST["fecha_final"])   : "";
    $vista          = isset($_POST["vista"])         ? trim($_POST["vista"])         : "lista";
    $categoriasPost = (isset($_POST["categorias"]) && is_array($_POST["categorias"])) ? $_POST["categorias"] : [];

    // Checks
    $opt_existencias         = !empty($_POST["existencias"]);
    $opt_costo_compra        = !empty($_POST["costo_compra"]);
    $opt_max_min             = !empty($_POST["max_min"]);
    $opt_mostrar_descripcion = !empty($_POST["mostrar_descripcion"]);
    $opt_mostrar_sku         = !empty($_POST["mostrar_sku"]);
    $opt_mostrar_imagen      = !empty($_POST["mostrar_imagen"]);
    $opt_mostrar_precio      = !empty($_POST["mostrar_precio"]);

    // SELECT dinámico
    $cols = [];
    if ($opt_existencias)         { $cols[] = "proExistencia"; }
    if ($opt_costo_compra)        { $cols[] = "proPreciocosto"; }
    if ($opt_max_min)             { $cols[] = "proMax"; $cols[] = "proMin"; }
    if ($opt_mostrar_descripcion) { $cols[] = "proTitulo"; }
    if ($opt_mostrar_sku)         { $cols[] = "proSku"; }
    if ($opt_mostrar_imagen)      { $cols[] = "proImagen"; }
    if ($opt_mostrar_precio)      { $cols[] = "proPrecioventa"; }

    if (empty($cols)) { $cols[] = "proTitulo"; $opt_mostrar_descripcion = true; }

    $cols = array_values(array_unique($cols));
    $colsSql = implode(",", $cols) . ", FechaActualizacion, proCatId";

    $selectBase = "SELECT {$colsSql} FROM productos WHERE ";
    $cond = [];
    $cond[] = "proAlmId IN (5)";
    $cond[] = "Activo = 1";

    $catIds = [];
    foreach ($categoriasPost as $cv) { $id = (int)$cv; if ($id > 0) $catIds[] = $id; }
    if (!empty($catIds)) { $cond[] = "proCatId IN (" . implode(",", $catIds) . ")"; }

    $sentenciasql = $selectBase . implode(" AND ", $cond) . " ORDER BY proCatId ASC";

    // Consulta
    $prod = new productosModel();
    $prod->sentencia = $sentenciasql;
    $result = $prod->catalogoproductos();

    // ==== PDF ====
    $pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
    $pdf->SetTitle('INVENTARIO DE PRODUCTOS (TIENDA)');
    $pdf->setPrintHeader(false);
    $pdf->setHeaderFont(array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
    $pdf->SetMargins("20", "30", "20");
    $pdf->SetHeaderMargin(0);
    $pdf->SetFooterMargin(0);
    $pdf->setPrintFooter(false);
    $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
    if (@file_exists(dirname(__FILE__) . '/lang/eng.php')) { require_once(dirname(__FILE__) . '/lang/eng.php'); $pdf->setLanguageArray($l); }
    $pdf->SetFont('helvetica', '', 12);
    $pdf->SetMargins(13, 15, 5, true);

    // Columnas dinámicas
    $columns = [];
    if ($opt_mostrar_sku)         $columns[] = ['key'=>'sku',    'label'=>'SKU',         'width'=>80];
    if ($opt_mostrar_descripcion) $columns[] = ['key'=>'titulo', 'label'=>'Descripción', 'width'=>220];
    if ($opt_existencias)         $columns[] = ['key'=>'exist',  'label'=>'Existencia',  'width'=>80];
    if ($opt_max_min) {
        $columns[] = ['key'=>'max', 'label'=>'Max', 'width'=>80];
        $columns[] = ['key'=>'min', 'label'=>'Min', 'width'=>80];
    }
    if ($opt_mostrar_precio)      $columns[] = ['key'=>'precio', 'label'=>'Precio',      'width'=>80];
    if ($opt_costo_compra)        $columns[] = ['key'=>'costo',  'label'=>'Costo compra','width'=>80];
    if ($opt_mostrar_imagen)      $columns[] = ['key'=>'imagen', 'label'=>'Imagen',      'width'=>100];
    // Fija
    $columns[] = ['key'=>'ultima', 'label'=>'Última compra', 'width'=>100];

    $thead = '<tr style="color:#0000FF;">';
    foreach ($columns as $c) {
        $thead .= '<td width="'.$c['width'].'" align="center">'.htmlspecialchars($c['label']).'</td>';
    }
    $thead .= '</tr>';

    $divtitle = '<div style="text-align: center;"><h2 style="color:#000;">INVENTARIO DE PRODUCTOS (TIENDA)</h2></div>';
    $divtablaini = '<table border="1" cellpadding="1" cellspacing="1"><thead>'.$thead.'</thead>';
    $div = "";

    $get = function($row, $prop, $default=null){ return isset($row->$prop) ? $row->$prop : $default; };

    foreach (to_object($result) as $row) {
        $titulo  = $get($row, 'proTitulo', '');
        $sku     = $get($row, 'proSku', null);
        $exist   = $get($row, 'proExistencia', null);
        $maximo  = $get($row, 'proMax', null);
        $minimo  = $get($row, 'proMin', null);
        $precio  = $get($row, 'proPrecioventa', null);
        $costo   = $get($row, 'proPreciocosto', null);
        $img     = $get($row, 'proImagen', null);
        $ultima  = $get($row, 'FechaActualizacion', null);

        $div .= '<tr>';
        foreach ($columns as $c) {
            $w = $c['width']; $key = $c['key']; $val = '—';
            if ($key === 'sku')     { $val = $sku ?: '—'; }
            if ($key === 'titulo')  { $val = $titulo ?: '—'; }
            if ($key === 'exist')   { $val = ($exist !== null ? $exist : '—'); }
            if ($key === 'max')     { $val = ($maximo !== null ? $maximo : '—'); }
            if ($key === 'min')     { $val = ($minimo !== null ? $minimo : '—'); }
            if ($key === 'precio')  { $val = ($precio !== null && $precio !== '') ? ('$'.number_format((float)$precio, 2, '.', ',')) : '—'; }
            if ($key === 'costo')   { $val = ($costo !== null && $costo !== '') ? ('$'.number_format((float)$costo, 2, '.', ',')) : '—'; }
            if ($key === 'ultima')  { $val = $ultima ? date('Y/m/d', strtotime($ultima)) : '—'; }

            if ($key === 'imagen') {
                $cell = $img ? '<img style="width:70px;height:50px;object-fit:contain;" src="'.htmlspecialchars($img).'"/>' : '—';
                $div .= '<td width="'.$w.'" align="center"><p style="font-size:10px;">'.$cell.'</p></td>';
            } else {
                $div .= '<td width="'.$w.'" align="center"><p style="font-size:10px;">'.htmlspecialchars((string)$val).'</p></td>';
            }
        }
        $div .= '</tr>';
    }

    $html = $divtitle.$divtablaini.$div."</table>";

    $pdf->AddPage();
    $bMargin = $pdf->getBreakMargin();
    $auto_page_break = $pdf->getAutoPageBreak();
    $pdf->SetAutoPageBreak(false, 0);
    $img_file = 'assets/img/images/formatos/encabezado.png';
    if (file_exists($img_file)) { $pdf->Image($img_file, 0, 0, 210, 23, '', '', '', false, 300, '', false, false, 0); }
    $pdf->SetAutoPageBreak($auto_page_break, $bMargin);
    $pdf->setPageMark(); 
    $pdf->setPrintFooter(true);

    $pdf->writeHTML($html,true, false, true, false, '');
    $pdf->Output('reporte_de_inventarios_tienda.pdf', 'I');
} 
// Termina inventarios tienda
// Inicia compras
function pdfcompras(){
    if ($_SERVER["REQUEST_METHOD"] != "POST") { Redirect::to('./reportes'); return; }

    // ====== Entrada desde el FRONT ======
    // Rango de fechas (el front usa fecha_inicial / fecha_final)
    $fechaini = isset($_POST["fecha_inicial"]) ? trim((string)$_POST["fecha_inicial"]) : '';
    $fechafin = isset($_POST["fecha_final"])   ? trim((string)$_POST["fecha_final"])   : '';

    // Compatibilidad con nombres previos (por si el form legacy los manda)
    if ($fechaini === '' && isset($_POST["fechaini"])) $fechaini = trim((string)$_POST["fechaini"]);
    if ($fechafin === '' && isset($_POST["fechafin"])) $fechafin = trim((string)$_POST["fechafin"]);

    if ($fechaini === '') $fechaini = date('Y-m-01');
    if ($fechafin === '') $fechafin = date('Y-m-d');

    // Avanzados de COMPRAS (según tu HTML)
    $comp_sku   = isset($_POST['comp_sku']) ? trim((string)$_POST['comp_sku']) : '';
    $comp_estado= isset($_POST['comp_estado']) ? trim((string)$_POST['comp_estado']) : ''; // '', 'activa', 'pendiente_cotizar', 'completada'
    $comp_ultimo= (isset($_POST['comp_ultimo']) && $_POST['comp_ultimo'] === '1') ? 1 : 0;
    $detallado  = (isset($_POST['comp_detallado']) && $_POST['comp_detallado'] === '1') ? 1 : 0;

    // Detalles opcionales
    $comp_prov  = isset($_POST['comp_proveedor']) ? trim((string)$_POST['comp_proveedor']) : '';
    $comp_orden = isset($_POST['comp_orden']) ? trim((string)$_POST['comp_orden']) : '';
    $comp_pago  = isset($_POST['comp_pago']) ? strtolower(trim((string)$_POST['comp_pago'])) : ''; // 'contado'|'credito'|'mixta'
    $comp_moneda= isset($_POST['comp_moneda']) ? strtoupper(trim((string)$_POST['comp_moneda'])) : ''; // 'MXN'|'USD'|'PEN'
    $monto_min  = isset($_POST['comp_monto_min']) && $_POST['comp_monto_min'] !== '' ? (float)$_POST['comp_monto_min'] : null;
    $monto_max  = isset($_POST['comp_monto_max']) && $_POST['comp_monto_max'] !== '' ? (float)$_POST['comp_monto_max'] : null;

    $incl_cancel= (isset($_POST['comp_incluir_canceladas'])   && $_POST['comp_incluir_canceladas']   === '1') ? 1 : 0;
    $incl_devol = (isset($_POST['comp_incluir_devoluciones']) && $_POST['comp_incluir_devoluciones'] === '1') ? 1 : 0;

    // ====== Construcción dinámica de la consulta ======
    // Condiciones base
    $where = [];
    $where[] = "c.fecha BETWEEN '".addslashes($fechaini)."' AND '".addslashes($fechafin)."'";

    // Estatus (mapeo a tus códigos)
    // 0=Pendiente de cotizar, 1=Completada, 2=OC Incompleta, 3=Cancelada, 4=Cotizada, 5=Devolución completa, 6=Devolución parcial
    if ($comp_estado !== '') {
        $codes = [];
        if ($comp_estado === 'pendiente_cotizar') {
            $codes = [0];
        } elseif ($comp_estado === 'completada') {
            $codes = [1];
        } elseif ($comp_estado === 'activa') {
            // "Activa" = todo lo que no sea cancelada ni devoluciones
            $codes = [0,1,2,4];
            if ($incl_cancel) { $codes[] = 3; }
            if ($incl_devol)  { $codes[] = 5; $codes[] = 6; }
        }
        if (!empty($codes)) {
            $codes = array_map('intval', array_unique($codes));
            $where[] = "c.estatus IN (".implode(',', $codes).")";
        }
        // Si comp_estado == '' (todas), no filtramos por estatus; los "incluir" no aplican porque ya se incluyen de todos modos
    }

    // Forma de pago (case-insensitive; compras.tipoPago es texto libre)
    if ($comp_pago !== '') {
        $p = addslashes($comp_pago);
        $where[] = "LOWER(c.tipoPago) LIKE '%{$p}%'";
    }

    // # Orden / Folio (c.idOrden)
    if ($comp_orden !== '') {
        $ord = addslashes($comp_orden);
        $where[] = "CAST(c.idOrden AS CHAR) LIKE '%{$ord}%'";
    }

    // Rango de montos (a nivel compra)
    if ($monto_min !== null) {
        $where[] = "c.monto >= ".((float)$monto_min);
    }
    if ($monto_max !== null) {
        $where[] = "c.monto <= ".((float)$monto_max);
    }

    // ¿Necesitamos unir detalle y productos?
    // - Siempre que se pida "detallado"
    // - o si filtramos por SKU
    // - o si filtramos por MONEDA (viene de productos)
    $needProdJoin = $detallado || ($comp_sku !== '') || ($comp_moneda !== '');

    // SELECT y JOINs
    if ($detallado) {
        // ====== DETALLADO: traemos partidas + SKU ======
        $select = "
            SELECT
                c.id,
                c.idOrden,
                c.descripcion,
                c.fecha,
                c.tipoPago,
                c.estatus,
                c.variosProv,
                c.monto,
                p1.nombre AS Prov1, p2.nombre AS Prov2, p3.nombre AS Prov3, p4.nombre AS Prov4, p5.nombre AS Prov5,
                cd.cantidad   AS CantidadDet,
                cd.precio     AS PrecioDet,
                cd.monto      AS MontoDet,
                pr.proSku     AS SKU,
                pr.proMoneda  AS Moneda
            FROM compras c
            INNER JOIN comprasDetalle cd ON cd.idCompra = c.id
            INNER JOIN productos pr      ON pr.proId   = cd.idProducto
            LEFT  JOIN proveedores p1 ON p1.id = c.idProveedor
            LEFT  JOIN proveedores p2 ON p2.id = c.idProveedor2
            LEFT  JOIN proveedores p3 ON p3.id = c.idProveedor3
            LEFT  JOIN proveedores p4 ON p4.id = c.idProveedor4
            LEFT  JOIN proveedores p5 ON p5.id = c.idProveedor5
        ";

        // Filtro por SKU (exacto) si llega
        if ($comp_sku !== '') {
            $where[] = "pr.proSku = '".addslashes($comp_sku)."'";
        }
        // Filtro por moneda si llega
        if ($comp_moneda !== '') {
            $where[] = "pr.proMoneda = '".addslashes($comp_moneda)."'";
        }

        // Filtro por proveedor (nombre o id) sobre p1..p5 / ids
        if ($comp_prov !== '') {
            $provConds = [];
            $term = addslashes($comp_prov);
            // por nombre
            foreach (['p1','p2','p3','p4','p5'] as $px) {
                $provConds[] = "{$px}.nombre LIKE '%{$term}%'";
            }
            // si vino un número, buscar por IDs también
            if (ctype_digit($comp_prov)) {
                $pid = (int)$comp_prov;
                $provConds[] = "c.idProveedor  = {$pid}";
                $provConds[] = "c.idProveedor2 = {$pid}";
                $provConds[] = "c.idProveedor3 = {$pid}";
                $provConds[] = "c.idProveedor4 = {$pid}";
                $provConds[] = "c.idProveedor5 = {$pid}";
            }
            $where[] = '('.implode(' OR ', $provConds).')';
        }

        $sql = $select.' WHERE '.implode(' AND ', $where).' ORDER BY c.fecha ASC, c.id ASC, cd.id ASC';
        if ($comp_ultimo === 1) {
            $sql = $select.' WHERE '.implode(' AND ', $where).' ORDER BY c.fecha DESC, c.id DESC, cd.id DESC LIMIT 1';
        }

    } else {
        // ====== RESUMEN: una fila por compra ======
        // Si necesitamos filtrar por SKU o MONEDA pero mostrar resumen,
        // unimos pr/cd solo para filtrar y usamos DISTINCT para no duplicar compras.
        if ($needProdJoin) {
            $select = "
                SELECT DISTINCT
                    c.id,
                    c.idOrden,
                    c.descripcion,
                    c.fecha,
                    c.tipoPago,
                    c.estatus,
                    c.variosProv,
                    c.monto,
                    p1.nombre AS Prov1, p2.nombre AS Prov2, p3.nombre AS Prov3, p4.nombre AS Prov4, p5.nombre AS Prov5
                FROM compras c
                INNER JOIN comprasDetalle cd ON cd.idCompra = c.id
                INNER JOIN productos pr      ON pr.proId   = cd.idProducto
                LEFT  JOIN proveedores p1 ON p1.id = c.idProveedor
                LEFT  JOIN proveedores p2 ON p2.id = c.idProveedor2
                LEFT  JOIN proveedores p3 ON p3.id = c.idProveedor3
                LEFT  JOIN proveedores p4 ON p4.id = c.idProveedor4
                LEFT  JOIN proveedores p5 ON p5.id = c.idProveedor5
            ";

            if ($comp_sku !== '') {
                $where[] = "pr.proSku = '".addslashes($comp_sku)."'";
            }
            if ($comp_moneda !== '') {
                $where[] = "pr.proMoneda = '".addslashes($comp_moneda)."'";
            }
            if ($comp_prov !== '') {
                $provConds = [];
                $term = addslashes($comp_prov);
                foreach (['p1','p2','p3','p4','p5'] as $px) {
                    $provConds[] = "{$px}.nombre LIKE '%{$term}%'";
                }
                if (ctype_digit($comp_prov)) {
                    $pid = (int)$comp_prov;
                    $provConds[] = "c.idProveedor  = {$pid}";
                    $provConds[] = "c.idProveedor2 = {$pid}";
                    $provConds[] = "c.idProveedor3 = {$pid}";
                    $provConds[] = "c.idProveedor4 = {$pid}";
                    $provConds[] = "c.idProveedor5 = {$pid}";
                }
                $where[] = '('.implode(' OR ', $provConds).')';
            }

            $sql = $select.' WHERE '.implode(' AND ', $where).' ORDER BY c.fecha ASC, c.id ASC';
            if ($comp_ultimo === 1) {
                $sql = $select.' WHERE '.implode(' AND ', $where).' ORDER BY c.fecha DESC, c.id DESC LIMIT 1';
            }

        } else {
            // Resumen puro, sin joins de productos
            $select = "
                SELECT
                    c.id,
                    c.idOrden,
                    c.descripcion,
                    c.fecha,
                    c.tipoPago,
                    c.estatus,
                    c.variosProv,
                    c.monto,
                    p1.nombre AS Prov1, p2.nombre AS Prov2, p3.nombre AS Prov3, p4.nombre AS Prov4, p5.nombre AS Prov5
                FROM compras c
                LEFT  JOIN proveedores p1 ON p1.id = c.idProveedor
                LEFT  JOIN proveedores p2 ON p2.id = c.idProveedor2
                LEFT  JOIN proveedores p3 ON p3.id = c.idProveedor3
                LEFT  JOIN proveedores p4 ON p4.id = c.idProveedor4
                LEFT  JOIN proveedores p5 ON p5.id = c.idProveedor5
            ";

            if ($comp_prov !== '') {
                $provConds = [];
                $term = addslashes($comp_prov);
                foreach (['p1','p2','p3','p4','p5'] as $px) {
                    $provConds[] = "{$px}.nombre LIKE '%{$term}%'";
                }
                if (ctype_digit($comp_prov)) {
                    $pid = (int)$comp_prov;
                    $provConds[] = "c.idProveedor  = {$pid}";
                    $provConds[] = "c.idProveedor2 = {$pid}";
                    $provConds[] = "c.idProveedor3 = {$pid}";
                    $provConds[] = "c.idProveedor4 = {$pid}";
                    $provConds[] = "c.idProveedor5 = {$pid}";
                }
                $where[] = '('.implode(' OR ', $provConds).')';
            }

            $sql = $select.' WHERE '.implode(' AND ', $where).' ORDER BY c.fecha ASC, c.id ASC';
            if ($comp_ultimo === 1) {
                $sql = $select.' WHERE '.implode(' AND ', $where).' ORDER BY c.fecha DESC, c.id DESC LIMIT 1';
            }
        }
    }

    // ====== Ejecutar ======
    $comp = new comprasModel();
    $comp->sentencia = $sql;
    $result = $comp->comprasreporte();

    // ====== Helper estatus textual ======
    $mapEstatus = function($code){
        switch ((int)$code) {
            case 0: return "En espera de cotización con proveedor";
            case 1: return "Compra Completada";
            case 2: return "Orden de Compra Incompleta";
            case 3: return "Orden de Compra Cancelada";
            case 4: return "Orden de Compra Cotizada";
            case 5: return "Devolución Completa";
            case 6: return "Devolución Parcial";
            default: return "Desconocido";
        }
    };

    // ====== PDF (TCPDF) ======
    $pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
    $pdf->SetTitle('Compras');
    $pdf->setPrintHeader(false);
    $pdf->setPrintFooter(true);
    $pdf->SetMargins(13, 17, 5, true);
    $pdf->AddPage();
    $pdf->SetFont('helvetica', '', 11);

    $titulo = '<div style="text-align:center;"><h2>COMPRAS</h2></div>';
    $sub    = '<div style="text-align:center;margin-bottom:8px;"><strong>Rango: '
            .htmlspecialchars((string)$fechaini).' al '.htmlspecialchars((string)$fechafin).'</strong></div>';

    // Encabezados según modo (resumen vs detalles)
    if ($detallado) {
        $thead = '<table border="1" cellpadding="3" cellspacing="0">
            <thead>
                <tr style="background-color:#f2f2f2;">
                    <th align="center">#Compra</th>
                    <th align="center">Folio</th>
                    <th align="center">Fecha</th>
                    <th align="center">Forma Pago</th>
                    <th align="left">Proveedor</th>
                    <th align="center">Estatus</th>
                    <th align="center">SKU</th>
                    <th align="center">Cant</th>
                    <th align="right">Precio</th>
                    <th align="right">Monto</th>
                </tr>
            </thead>';
    } else {
        $thead = '<table border="1" cellpadding="3" cellspacing="0">
            <thead>
                <tr style="background-color:#f2f2f2;">
                    <th align="center">#Compra</th>
                    <th align="center">Folio</th>
                    <th align="center">Fecha</th>
                    <th align="left">Descripción</th>
                    <th align="center">Forma Pago</th>
                    <th align="left">Proveedor</th>
                    <th align="center">Estatus</th>
                    <th align="right">Monto</th>
                </tr>
            </thead>';
    }

    $tbody = '';
    $totalGeneral = 0.0;
    $pdf->SetFont('helvetica', '', 8);

    foreach (to_object($result) as $row) {
        $idCompra   = (string)$row->id;
        $folio      = (string)($row->idOrden ?? 'NA');
        $fecha      = (string)($row->fecha ?? '');
        $fechaD     = substr($fecha, 0, 10);
        $tipoPago   = (string)($row->tipoPago ?? 'NA');
        $estatusTx  = $mapEstatus($row->estatus ?? -1);
        $desc       = (string)($row->descripcion ?? 'SD');
        $variosProv = (int)($row->variosProv ?? 0);
        $monto      = (float)($row->monto ?? 0);

        // Proveedor(es)
        $provList = [];
        foreach (['Prov1','Prov2','Prov3','Prov4','Prov5'] as $pname) {
            if (isset($row->$pname) && trim((string)$row->$pname) !== '') $provList[] = trim((string)$row->$pname);
        }
        $proveedores = $variosProv === 1 ? (implode(' / ', $provList) ?: 'Varios Proveedores')
                                         : ((isset($row->Prov1) && $row->Prov1) ? (string)$row->Prov1 : 'Sin proveedor');

        if ($detallado) {
            $sku     = isset($row->SKU) ? (string)$row->SKU : 'NA';
            $cant    = isset($row->CantidadDet) ? (float)$row->CantidadDet : 0;
            $precio  = isset($row->PrecioDet)   ? (float)$row->PrecioDet   : 0;
            $montoDt = isset($row->MontoDet)    ? (float)$row->MontoDet    : 0;

            $totalGeneral += $montoDt;

            $tbody .= '<tr>
                <td align="center">'.htmlspecialchars($idCompra).'</td>
                <td align="center">'.htmlspecialchars($folio).'</td>
                <td align="center">'.htmlspecialchars($fechaD).'</td>
                <td align="center">'.htmlspecialchars($tipoPago).'</td>
                <td align="left">'.htmlspecialchars($proveedores).'</td>
                <td align="center">'.htmlspecialchars($estatusTx).'</td>
                <td align="center">'.htmlspecialchars($sku).'</td>
                <td align="center">'.number_format($cant, 2, '.','').'</td>
                <td align="right">$'.number_format($precio, 2, '.',',').'</td>
                <td align="right">$'.number_format($montoDt, 2, '.',',').'</td>
            </tr>';
        } else {
            $totalGeneral += $monto;

            $tbody .= '<tr>
                <td align="center">'.htmlspecialchars($idCompra).'</td>
                <td align="center">'.htmlspecialchars($folio).'</td>
                <td align="center">'.htmlspecialchars($fechaD).'</td>
                <td align="left">'.htmlspecialchars($desc).'</td>
                <td align="center">'.htmlspecialchars($tipoPago).'</td>
                <td align="left">'.htmlspecialchars($proveedores).'</td>
                <td align="center">'.htmlspecialchars($estatusTx).'</td>
                <td align="right">$'.number_format($monto, 2, '.',',').'</td>
            </tr>';
        }
    }

    $tfoot = '<tr>
        <td '.($detallado ? 'colspan="9"' : 'colspan="7"').' align="right"><strong>Total</strong></td>
        <td align="right"><strong>$'.number_format($totalGeneral, 2, '.',',').'</strong></td>
    </tr>';

    // Encabezado gráfico (imagen superior)
    $bMargin = $pdf->getBreakMargin();
    $auto_page_break = $pdf->getAutoPageBreak();
    $pdf->SetAutoPageBreak(false, 0);
    $img_file = 'assets/img/images/formatos/encabezado.png';
    if (file_exists($img_file)) { $pdf->Image($img_file, 0, 0, 210, 23, '', '', '', false, 300, '', false, false, 0); }
    $pdf->SetAutoPageBreak($auto_page_break, $bMargin);
    $pdf->setPageMark();

    $html = $titulo.$sub.$thead.$tbody.$tfoot.'</table>';
    $pdf->writeHTML($html, true, false, true, false, '');

    $pdf->Output('reporte_compras.pdf', 'I');
}
//Terminan compras
//Inica Reporte Almacenes
function pdfAlmacenes() {
    if ($_SERVER["REQUEST_METHOD"] !== "POST") {
        Redirect::to('./reportes');
        return;
    }

    // === SQL EXACTO solicitado ===
    $sql = "
        SELECT
            a.almId,
            a.almNombre,
            COUNT(p.proId) AS TotalProductos,
            SUM(CASE WHEN IFNULL(p.Activo,0) = 1 THEN 1 ELSE 0 END) AS Activos,
            SUM(CASE WHEN IFNULL(p.Activo,0) <> 1 THEN 1 ELSE 0 END) AS Inactivos
        FROM almacenes a
        INNER JOIN productos p ON p.proAlmId = a.almId
        GROUP BY a.almId
    ";

    // Ejecuta con tu modelo (ajusta nombres si usas otro)
    $alm = new almacenesModel();
    $alm->sentencia = $sql;
    $rows = $alm->allmacenreportes();
    $data = to_object($rows);
    
    // === PDF (TCPDF) ===
    $pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
    $pdf->SetTitle('Almacenes - Conteo de productos');
    $pdf->setPrintHeader(false);
    $pdf->setPrintFooter(true);
    $pdf->SetMargins(13, 17, 5, true);
    $pdf->AddPage();

    // Encabezado gráfico superior (opcional, como en otros reportes)
    $bMargin = $pdf->getBreakMargin();
    $auto_page_break = $pdf->getAutoPageBreak();
    $pdf->SetAutoPageBreak(false, 0);
    $img_file = 'assets/img/images/formatos/encabezado.png';
    if (file_exists($img_file)) {
        $pdf->Image($img_file, 0, 0, 210, 23, '', '', '', false, 300, '', false, false, 0);
    }
    $pdf->SetAutoPageBreak($auto_page_break, $bMargin);
    $pdf->setPageMark();

    $pdf->SetFont('helvetica', '', 11);
    $titulo = '<div style="text-align:center;"><h2>ALMACENES</h2></div>';
    $sub    = '<div style="text-align:center;margin-bottom:8px;"><strong>Conteo de productos por almacén</strong></div>';

    // Anchos que caben en el área útil (~192mm con tus márgenes)
    // 20 + 100 + 24 + 24 + 24 = 192
    $thead = '
        <table border="1" cellpadding="4" cellspacing="0">
            <thead>
                <tr style="background-color:#f2f2f2;">
                    <th width="30"  align="center">ID</th>
                    <th width="100" align="left">Almacén</th>
                    <th width="100"  align="right">Total</th>
                    <th width="100"  align="right">Activos</th>
                    <th width="100"  align="right">Inactivos</th>
                </tr>
            </thead>
    ';

    $tbody = '';
    $sumTotal = 0; $sumAct = 0; $sumInact = 0;
    $pdf->SetFont('helvetica', '', 9);

    if ($data && count($data) > 0) {
        
        foreach ($data as $r) {
            $almId   = (int)$r->almId;
            $nombre  = (string)$r->almNombre;
            $total   = (int)$r->TotalProductos;
            $act     = (int)$r->Activos;
            $inact   = (int)$r->Inactivos;

            $sumTotal += $total;
            $sumAct   += $act;
            $sumInact += $inact;

            $tbody .= '
                <tr>
                    <td width="30"  align="center">'.number_format($almId).'</td>
                    <td width="100" align="left">'.htmlspecialchars($nombre).'</td>
                    <td width="100"  align="right">'.number_format($total).'</td>
                    <td width="100"  align="right">'.number_format($act).'</td>
                    <td width="100"  align="right">'.number_format($inact).'</td>
                </tr>
            ';
        }
    } else {
        $tbody .= '
            <tr>
                <td colspan="5" align="center">Sin resultados.</td>
            </tr>
        ';
    }

    $tfoot = '
        <tr>
            <td colspan="2" align="right"><strong>Totales</strong></td>
            <td align="right"><strong>'.number_format($sumTotal).'</strong></td>
            <td align="right"><strong>'.number_format($sumAct).'</strong></td>
            <td align="right"><strong>'.number_format($sumInact).'</strong></td>
        </tr>
    ';

    $html = $titulo.$sub.$thead.$tbody.$tfoot.'</table>';
    $pdf->writeHTML($html, true, false, true, false, '');

    $pdf->Output('reporte_almacenes.pdf', 'I');
}


//Terminan reporte de almacenes
//Inicia reportes categorias
function pdfCategorias() {
    if ($_SERVER["REQUEST_METHOD"] !== "POST") {
        Redirect::to('./reportes');
        return;
    }

    // ====== ENTRADA DESDE EL FRONT ======
    $fechaini = isset($_POST["fecha_inicial"]) && $_POST["fecha_inicial"] !== "" ? $_POST["fecha_inicial"] : "";
    $fechafin = isset($_POST["fecha_final"])   && $_POST["fecha_final"]   !== "" ? $_POST["fecha_final"]   : "";
    if ($fechaini === "") $fechaini = date('Y-m-01');
    if ($fechafin === "") $fechafin = date('Y-m-d');

    // categorias[] puede venir vacío o no venir
    $catsSel = [];
    if (isset($_POST["categorias"]) && is_array($_POST["categorias"])) {
        foreach ($_POST["categorias"] as $cid) {
            if (is_numeric($cid)) { $catsSel[] = (int)$cid; }
        }
    }

    // ====== FILTROS SQL ======
    $filtroCats = "";
    if (count($catsSel) > 0) {
        $in = implode(",", array_map('intval', $catsSel));
        $filtroCats = " WHERE c.catId IN ($in) ";
    }

    // ====== SQL 1: RESUMEN POR CATEGORÍA (productos totales / activos / inactivos) ======
    $sqlResumen = "
        SELECT
            c.catId,
            c.catNombre,
            COUNT(p.proId) AS TotalProductos,
            SUM(CASE WHEN IFNULL(p.Activo,0)=1 THEN 1 ELSE 0 END) AS Activos,
            SUM(CASE WHEN IFNULL(p.Activo,0)<>1 THEN 1 ELSE 0 END) AS Inactivos
        FROM categorias c
        LEFT JOIN productos p ON p.proCatId = c.catId
        $filtroCats
        GROUP BY c.catId, c.catNombre
        ORDER BY c.catNombre ASC
    ";

    // ====== SQL 2: DESGLOSE POR SUBCATEGORÍA (totales de productos por subcat) ======
    $sqlSub = "
        SELECT
            c.catId,
            c.catNombre,
            s.IdsubCategoria,
            s.NsubCategoria,
            COUNT(p.proId) AS Productos
        FROM subCategorias s
        INNER JOIN categorias c ON c.catId = s.IdCatego
        LEFT JOIN productos p ON p.proSubCategoria = s.IdsubCategoria
        ".($filtroCats !== "" ? str_replace("c.", "c.", $filtroCats) : "")."
        GROUP BY s.IdsubCategoria, c.catId, c.catNombre, s.NsubCategoria
        ORDER BY c.catNombre ASC, s.NsubCategoria ASC
    ";

    // ====== EJECUCIÓN ======
    $cat = new categoriasModel();
    $cat->sentencia = $sqlResumen;
    $resResumen = to_object($cat->categoriasreporte());

    $cat2 = new categoriasModel();
    $cat2->sentencia = $sqlSub;
    $resSub = to_object($cat2->categoriasreporte());

    // Mapear conteo de subcategorías por catId (solo para mostrar número de subcats en la tabla principal)
    $subCountPerCat = [];
    if ($resSub) {
        foreach ($resSub as $row) {
            $cid = (int)$row->catId;
            if (!isset($subCountPerCat[$cid])) $subCountPerCat[$cid] = 0;
            $subCountPerCat[$cid] += 1; // cada fila = una subcategoría con su total
        }
    }

    // ====== PDF (TCPDF) ======
    $pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
    $pdf->SetTitle('Categorías y Subcategorías');
    $pdf->setPrintHeader(false);
    $pdf->setPrintFooter(true);
    $pdf->SetMargins(13, 17, 5, true);
    $pdf->AddPage();

    // Encabezado gráfico superior (como en otros reportes)
    $bMargin = $pdf->getBreakMargin();
    $auto_page_break = $pdf->getAutoPageBreak();
    $pdf->SetAutoPageBreak(false, 0);
    $img_file = 'assets/img/images/formatos/encabezado.png';
    if (file_exists($img_file)) {
        $pdf->Image($img_file, 0, 0, 210, 23, '', '', '', false, 300, '', false, false, 0);
    }
    $pdf->SetAutoPageBreak($auto_page_break, $bMargin);
    $pdf->setPageMark();

    // Títulos
    $pdf->SetFont('helvetica', '', 11);
    $titulo = '<div style="text-align:center;"><h2>CATEGORÍAS</h2></div>';
    $subtit = '<div style="text-align:center;margin-bottom:8px;"><strong>Rango: '
        .htmlspecialchars((string)$fechaini).' al '.htmlspecialchars((string)$fechafin).'</strong></div>';

    // ====== TABLA 1: RESUMEN POR CATEGORÍA ======
    // Anchos suman 192mm (área útil con tus márgenes)
    // 15 + 90 + 20 + 22 + 22 + 23 = 192
    $thead1 = '
        <table border="1" cellpadding="4" cellspacing="0">
            <thead>
                <tr style="background-color:#f2f2f2;">
                    <th width="40"  align="center">ID</th>
                    <th width="200"  align="left">Categoría</th>
                    <th width="70"  align="right">#Sub</th>
                    <th width="70"  align="right">Total</th>
                    <th width="70"  align="right">Activos</th>
                    <th width="70"  align="right">Inactivos</th>
                </tr>
            </thead>
    ';

    $tbody1 = '';
    $sumTotal = 0; $sumAct = 0; $sumInact = 0; $sumSub = 0;
    $maxCatTotal = 0; // para la gráfica

    $pdf->SetFont('helvetica', '', 9);

    if ($resResumen && count($resResumen) > 0) {
        foreach ($resResumen as $r) {
            $cid   = (int)$r->catId;
            $name  = (string)$r->catNombre;
            $tot   = (int)$r->TotalProductos;
            $act   = (int)$r->Activos;
            $inact = (int)$r->Inactivos;
            $nsub  = isset($subCountPerCat[$cid]) ? (int)$subCountPerCat[$cid] : 0;

            $sumTotal += $tot; $sumAct += $act; $sumInact += $inact; $sumSub += $nsub;
            if ($tot > $maxCatTotal) $maxCatTotal = $tot;

            $tbody1 .= '
                <tr>
                    <td width="40"  align="center">'.number_format($cid).'</td>
                    <td width="200"  align="left">'.htmlspecialchars($name).'</td>
                    <td width="70"  align="right">'.number_format($nsub).'</td>
                    <td width="70"  align="right">'.number_format($tot).'</td>
                    <td width="70"  align="right">'.number_format($act).'</td>
                    <td width="70"  align="right">'.number_format($inact).'</td>
                </tr>
            ';
        }
    } else {
        $tbody1 .= '
            <tr><td colspan="6" align="center">Sin resultados.</td></tr>
        ';
    }

    $tfoot1 = '
        <tr>
            <td colspan="2" align="right"><strong>Totales</strong></td>
            <td align="right"><strong>'.number_format($sumSub).'</strong></td>
            <td align="right"><strong>'.number_format($sumTotal).'</strong></td>
            <td align="right"><strong>'.number_format($sumAct).'</strong></td>
            <td align="right"><strong>'.number_format($sumInact).'</strong></td>
        </tr>
    ';

    $html1 = $titulo.$subtit.$thead1.$tbody1.$tfoot1.'</table>';
    $pdf->writeHTML($html1, true, false, true, false, '');

    // ====== TABLA 2: DESGLOSE POR SUBCATEGORÍA (SOLO TOTALES) ======
    // 70 + 80 + 42 = 192
    $pdf->Ln(2);
    $pdf->SetFont('helvetica', '', 11);
    $pdf->writeHTML('<h3 style="text-align:center;margin:8px 0;">SUBCATEGORÍAS (Totales por subcategoría)</h3>', true, false, true, false, '');
    $pdf->SetFont('helvetica', '', 9);

    $thead2 = '
        <table border="1" cellpadding="4" cellspacing="0">
            <thead>
                <tr style="background-color:#f2f2f2;">
                    <th width="225" align="left">Categoría</th>
                    <th width="225" align="left">Subcategoría</th>
                    <th width="70" align="right">Productos</th>
                </tr>
            </thead>
    ';
    $tbody2 = '';
    $sumSubProd = 0;

    if ($resSub && count($resSub) > 0) {
        foreach ($resSub as $r) {
            $cname = (string)$r->catNombre;
            $sname = (string)$r->NsubCategoria;
            $prod  = (int)$r->Productos;
            $sumSubProd += $prod;

            $tbody2 .= '
                <tr>
                    <td width="225" align="left">'.htmlspecialchars($cname).'</td>
                    <td width="225" align="left">'.htmlspecialchars($sname).'</td>
                    <td width="70" align="right">'.number_format($prod).'</td>
                </tr>
            ';
        }
    } else {
        $tbody2 .= '<tr><td colspan="3" align="center">Sin subcategorías / sin productos.</td></tr>';
    }

    $tfoot2 = '
        <tr>
            <td colspan="2" align="right"><strong>Total productos (por subcategoría)</strong></td>
            <td align="right"><strong>'.number_format($sumSubProd).'</strong></td>
        </tr>
    ';

    $html2 = $thead2.$tbody2.$tfoot2.'</table>';
    $pdf->writeHTML($html2, true, false, true, false, '');

    // ====== GRÁFICA: Productos por categoría (barras horizontales) ======
    if ($resResumen && count($resResumen) > 0 && $maxCatTotal > 0) {
        $pdf->AddPage();

        // Encabezado gráfico superior (opcional) otra vez
        $bMargin = $pdf->getBreakMargin();
        $auto_page_break = $pdf->getAutoPageBreak();
        $pdf->SetAutoPageBreak(false, 0);
        if (file_exists($img_file)) {
            $pdf->Image($img_file, 0, 0, 210, 23, '', '', '', false, 300, '', false, false, 0);
        }
        $pdf->SetAutoPageBreak($auto_page_break, $bMargin);
        $pdf->setPageMark();

        $pdf->SetFont('helvetica', '', 11);
        $pdf->writeHTML('<h3 style="text-align:center;margin:8px 0;">Productos por categoría</h3>', true, false, true, false, '');
        $pdf->SetFont('helvetica', '', 8);

        // Área de la gráfica
        $chartX = 20;          // mm desde la izquierda
        $chartY = $pdf->GetY() + 4; // posición vertical actual + margen
        $chartW = 170;         // ancho de la zona de barras
        $barH   = 5.5;         // alto por barra
        $gap    = 2.5;         // separación entre barras
        $labelW = 45;          // ancho reservado para etiqueta a la izquierda
        $barW   = $chartW - $labelW - 10; // 10mm margen numérico al final

        // Marco (opcional)
        $pdf->SetDrawColor(200,200,200);
        $pdf->Rect($chartX, $chartY, $chartW, (count($resResumen) * ($barH + $gap)) + 10);

        $y = $chartY + 5;

        foreach ($resResumen as $r) {
            $name = (string)$r->catNombre;
            $tot  = (int)$r->TotalProductos;
            $w    = ($tot / $maxCatTotal) * $barW;

            // Etiqueta (truncate si es muy larga)
            $etq = mb_strimwidth($name, 0, 32, '…', 'UTF-8');
            $pdf->Text($chartX + 2, $y + 1.2, $etq);

            // Barra
            $pdf->SetFillColor(80, 160, 220);
            $pdf->Rect($chartX + $labelW, $y, max(0.5, $w), $barH, 'F');

            // Valor numérico al final
            $pdf->Text($chartX + $labelW + $w + 2, $y + 1.2, (string)$tot);

            $y += ($barH + $gap);
        }

        // Leyenda de rango
        $pdf->Text($chartX + $labelW, $y + 2, '0');
        $pdf->Text($chartX + $labelW + $barW - 8, $y + 2, (string)$maxCatTotal);
    }

    $pdf->Output('reporte_categorias.pdf', 'I');
}
//Termina reportes categorias
//Inicia Traspasos
function pdftraspasos() {
    //ini_set('error_reporting', E_ALL);
    //ini_set('display_errors', true);
    if ($_SERVER["REQUEST_METHOD"] !== "POST") {
        Redirect::to('./reportes');
        return;
    }

    // ===== ENTRADA DESDE EL FRONT =====
    $fechaini = isset($_POST["fechaini"]) && $_POST["fechaini"] !== "" ? $_POST["fechaini"] :
                (isset($_POST["fecha_inicial"]) ? $_POST["fecha_inicial"] : "");
    $fechafin = isset($_POST["fechafin"]) && $_POST["fechafin"] !== "" ? $_POST["fechafin"] :
                (isset($_POST["fecha_final"]) ? $_POST["fecha_final"] : "");

    if ($fechaini === "") $fechaini = date('Y-m-01');
    if ($fechafin === "") $fechafin = date('Y-m-d');

    // Almacén (Traspasos) opcional
    $almacenId = null;
    if (isset($_POST["trasp_almacen_id"]) && $_POST["trasp_almacen_id"] !== "") {
        $almacenId = (int)$_POST["trasp_almacen_id"];
    } elseif (isset($_POST["traspAlmacen"]) && $_POST["traspAlmacen"] !== "") {
        $almacenId = (int)$_POST["traspAlmacen"];
    }

    // NUEVO: Filtro SKU o nombre de producto (proTitulo %LIKE%)
    $filtroProd = "";
    if (isset($_POST["trasp_filtro"]) && trim($_POST["trasp_filtro"]) !== "") {
        $filtroProd = trim((string)$_POST["trasp_filtro"]);
    } elseif (isset($_POST["traspFiltro"]) && trim($_POST["traspFiltro"]) !== "") {
        $filtroProd = trim((string)$_POST["traspFiltro"]);
    }

    // ===== SQL =====
    $where = [];
    $where[] = "ht.fechaTraspaso BETWEEN '".$fechaini." 00:00:00' AND '".$fechafin." 23:59:59'";
    if ($almacenId !== null) {
        $where[] = "ht.AlmacenDestino = ".intval($almacenId);
    }
    if ($filtroProd !== "") {
        $like = "%".addslashes($filtroProd)."%";
        $eq   = addslashes($filtroProd);
        // Coincidir por nombre (contiene) o por SKU (LIKE o exacto)
        $where[] = "( (p.proTitulo IS NOT NULL AND p.proTitulo LIKE '".$like."')
                      OR ht.historialproSku LIKE '".$like."'
                      OR ht.historialproSku = '".$eq."' )";
    }

    $sql = "
        SELECT
            ht.IdTraspaso,
            ht.IdProductoTraspaso,
            ht.correoTraspaso,
            ht.fechaTraspaso,
            ht.cantidadTraspaso,
            ht.motivoTraspaso,
            ht.historialproSku,
            ht.AlmacenDestino,
            u.Usuario         AS UsuarioNombre,
            a.almNombre       AS AlmacenDestinoNombre,
            p.proTitulo       AS ProductoNombre
        FROM historial_traspaso ht
        INNER JOIN usuarios  u ON u.Correo = ht.correoTraspaso
        INNER JOIN almacenes a ON a.almId  = ht.AlmacenDestino
        LEFT  JOIN productos p ON p.proSku = ht.historialproSku
        WHERE ".implode(" AND ", $where)." GROUP BY ht.IdTraspaso
        ORDER BY ht.fechaTraspaso ASC, ht.IdTraspaso ASC
    ";
    // Ejecutar query (ajusta al modelo que uses)
    $trasp = new almacenesModel();
    $trasp->sentencia = $sql;
    $result = $trasp->traspasosreporte();

    // ===== PDF (TCPDF) =====
    $pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
    $pdf->SetTitle('Reporte de Traspasos');
    $pdf->setPrintHeader(false);
    $pdf->setPrintFooter(true);
    $pdf->SetMargins(13, 17, 5, true);
    $pdf->AddPage();
    $pdf->SetFont('helvetica', '', 10);

    // Encabezado visual
    $bMargin = $pdf->getBreakMargin();
    $auto_page_break = $pdf->getAutoPageBreak();
    $pdf->SetAutoPageBreak(false, 0);
    $img_file = 'assets/img/images/formatos/encabezado.png';
    if (file_exists($img_file)) {
        $pdf->Image($img_file, 0, 0, 210, 23, '', '', '', false, 300, '', false, false, 0);
    }
    $pdf->SetAutoPageBreak($auto_page_break, $bMargin);
    $pdf->setPageMark();

    // Título
    $titulo = '<div style="text-align:center;"><h2>REPORTE DE TRASPASOS</h2></div>';
    $sub    = '<div style="text-align:center;margin-bottom:8px;"><strong>Rango: '
            .htmlspecialchars((string)$fechaini).' al '.htmlspecialchars((string)$fechafin).'</strong>'
            .($almacenId ? ' &nbsp;|&nbsp; Almacén: '.htmlspecialchars((string)$almacenId) : '')
            .($filtroProd !== "" ? ' &nbsp;|&nbsp; Filtro: '.htmlspecialchars($filtroProd) : '')
            .'</div>';

    // ===== TABLA DETALLADA =====
    $thead = '
        <table border="1" cellpadding="4" cellspacing="0">
            <thead>
                <tr style="background-color:#f2f2f2;">
                    <th width="40" align="center">ID</th>
                    <th width="60" align="center">Fecha</th>
                    <th width="60" align="center">SKU</th>
                    <th width="70" align="left">Producto</th>
                    <th width="120" align="center">Usuario</th>
                    <th width="70" align="left">Motivo</th>
                    <th width="60" align="center">Almacén Destino</th>
                    <th width="50" align="right">Cantidad</th>
                </tr>
            </thead>
    ';

    $tbody = '';
    $totalGeneral = 0;
    $productosCount = []; // para la gráfica (suma cantidades por producto)

    $pdf->SetFont('helvetica', '', 8);
    
    foreach (to_object($result) as $row) {
        $idTr      = (int)$row->IdTraspaso;
        $fecha     = substr((string)$row->fechaTraspaso, 0, 10);
        $usuario   = (string)$row->UsuarioNombre;
        $almNom    = (string)$row->AlmacenDestinoNombre;
        $sku       = (string)$row->historialproSku;
        $prodNom   = $row->ProductoNombre ? (string)$row->ProductoNombre : 'NA';
        $cant      = (int)$row->cantidadTraspaso;
        $motivo    = (string)$row->motivoTraspaso;
        $idProd    = (int)$row->IdProductoTraspaso;

        $labelGraf = $prodNom !== 'NA' ? $prodNom : ('SKU '.$sku);
        if (!isset($productosCount[$labelGraf])) $productosCount[$labelGraf] = 0;
        $productosCount[$labelGraf] += $cant;

        $totalGeneral += $cant;

        $tbody .= '
            <tr>
                <td width="40" align="center">'.htmlspecialchars((string)$idTr).'</td>
                <td width="60" align="center">'.htmlspecialchars($fecha).'</td>
                <td width="60" align="center">'.htmlspecialchars($sku).'</td>
                <td width="70" align="left">'.htmlspecialchars($prodNom).'</td>
                <td width="120" align="center">'.htmlspecialchars($usuario).'</td>
                <td width="70" align="left">'.htmlspecialchars($motivo).'</td>
                <td width="60" align="center">'.htmlspecialchars($almNom).'</td>
                <td width="50" align="right">'.number_format($cant).'</td>
            </tr>
        ';
    }

    if ($tbody === '') {
        $tbody = '<tr><td colspan="9" align="center">Sin registros de traspasos en este rango.</td></tr>';
    }

    $tfoot = '
        <tr>
            <td colspan="7" align="right"><strong>Total general</strong></td>
            <td align="center"><strong>'.number_format($totalGeneral).'</strong></td>
        </tr>
    ';

    $html = $titulo.$sub.$thead.$tbody.$tfoot.'</table>';
    $pdf->writeHTML($html, true, false, true, false, '');

    // ===== GRÁFICA DE PRODUCTOS TRASPASADOS =====
    if (count($productosCount) > 0) {
        $pdf->AddPage();

        $bMargin = $pdf->getBreakMargin();
        $auto_page_break = $pdf->getAutoPageBreak();
        $pdf->SetAutoPageBreak(false, 0);
        if (file_exists($img_file)) {
            $pdf->Image($img_file, 0, 0, 210, 23, '', '', '', false, 300, '', false, false, 0);
        }
        $pdf->SetAutoPageBreak($auto_page_break, $bMargin);
        $pdf->setPageMark();

        $pdf->SetFont('helvetica', '', 11);
        $pdf->writeHTML('<h3 style="text-align:center;">Productos traspasados ('.$fechaini.' a '.$fechafin.')</h3>', true, false, true, false, '');
        $pdf->SetFont('helvetica', '', 8);

        arsort($productosCount);
        $max = max($productosCount);

        $chartX = 20;
        $chartY = $pdf->GetY() + 5;
        $chartW = 170;
        $barH   = 5.5;
        $gap    = 2.5;
        $labelW = 90;
        $barW   = $chartW - $labelW - 10;

        $y = $chartY;
        foreach ($productosCount as $prod => $cant) {
            $w = ($cant / $max) * $barW;
            $etq = mb_strimwidth($prod, 0, 60, '…', 'UTF-8');

            $pdf->Text($chartX, $y + 1.5, $etq);
            $pdf->SetFillColor(60, 160, 220);
            $pdf->Rect($chartX + $labelW, $y, max(0.5, $w), $barH, 'F');
            $pdf->Text($chartX + $labelW + $w + 2, $y + 1.5, (string)$cant);

            $y += ($barH + $gap);
            if ($y > 270) {
                $pdf->AddPage();
                $pdf->SetFont('helvetica', '', 8);
                $y = 25;
            }
        }
    }

    $pdf->Output('reporte_traspasos.pdf', 'I');
}



//Fin Traspasos
//Inician  los reportes de Ventas
function pdfVentasGenerales() {
    if ($_SERVER["REQUEST_METHOD"] != "POST") { Redirect::to('./reportes'); return; }

    // Fechas desde el front (compat)
    $fechaini = isset($_POST["fechaini"]) && $_POST["fechaini"] !== "" ? $_POST["fechaini"] : (isset($_POST["fecha_inicial"]) ? $_POST["fecha_inicial"] : "");
    $fechafin = isset($_POST["fechafin"]) && $_POST["fechafin"] !== "" ? $_POST["fechafin"] : (isset($_POST["fecha_final"]) ? $_POST["fecha_final"] : "");
    if ($fechaini === "") $fechaini = date('Y-m-d');
    if ($fechafin === "") $fechafin = date('Y-m-d');

    // Filtros opcionales del front
    $f_estatus  = isset($_POST['ven_estatus'])  && $_POST['ven_estatus']  !== '' ? (int)$_POST['ven_estatus']  : null; // o.Estatus
    $f_transito = isset($_POST['ven_transito']) && $_POST['ven_transito'] !== '' ? (int)$_POST['ven_transito'] : null; // o.EstadoTransito

    // WHERE
    $where = [];
    $where[] = "o.Fecha BETWEEN '".$fechaini."' AND '".$fechafin."'";
    if ($f_estatus !== null)  $where[] = "o.Estatus = ".intval($f_estatus);
    if ($f_transito !== null) $where[] = "o.EstadoTransito = ".intval($f_transito);

    // Consulta EXACTA (con joins a estatus y departamentos)
    $orden = new ordenesModel();
    $orden->sentencia = "
        SELECT 
            o.IdOrden, o.FolioOrden, o.Fecha, o.IdUsuario, 
            odet.Neto AS Total, u.Usuario, dep.DeptoDescripcion, est.Descripcion,
            o.Estatus, o.EstadoTransito
        FROM ordenes o
        INNER JOIN ordenesdetalle odet ON odet.IdOrden = o.IdOrden
        INNER JOIN estatus est         ON est.IdEstatus = o.Estatus
        INNER JOIN departamentos dep   ON dep.IdDepto   = o.EstadoTransito
        INNER JOIN usuarios u          ON u.IdUsuario   = o.IdUsuario
        WHERE ".implode(" AND ", $where)."
        GROUP BY o.IdOrden
        ORDER BY o.Fecha ASC
    ";
    $result = $orden->ventasGenerales();

    // ================== PDF ==================
    $pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
    $pdf->SetTitle('Ventas Generales');
    $pdf->setPrintHeader(false);
    $pdf->setPrintFooter(true);
    $pdf->SetMargins(13, 17, 5, true);
    $pdf->AddPage();
    $pdf->SetFont('helvetica', '', 9);

    // Encabezado visual
    $bMargin = $pdf->getBreakMargin();
    $auto_page_break = $pdf->getAutoPageBreak();
    $pdf->SetAutoPageBreak(false, 0);
    $img_file = 'assets/img/images/formatos/encabezado.png';
    if (file_exists($img_file)) {
        $pdf->Image($img_file, 0, 0, 210, 23, '', '', '', false, 300, '', false, false, 0);
    }
    $pdf->SetAutoPageBreak($auto_page_break, $bMargin);
    $pdf->setPageMark();

    $titulo = '<div style="text-align:center;"><h2>VENTAS GENERALES</h2></div>';
    $sub    = '<div style="text-align:center;margin-bottom:8px;"><strong>Rango: '
            .htmlspecialchars((string)$fechaini).' al '.htmlspecialchars((string)$fechafin).'</strong></div>';

    // Tabla
    $thead = '<table border="1" cellpadding="4" cellspacing="0">
        <thead>
            <tr style="background-color:#f2f2f2;">
                <th width="60"  align="center">#</th>
                <th width="70"  align="center">ID</th>
                <th width="80"  align="center">Fecha</th>
                <th width="210"  align="left">Vendedor</th>
                <th width="100"  align="right">Total</th>
            </tr>
        </thead>';
    $tbody = '';

    $i=0; $totalGeneral=0.0;
    $porEstatusTxt  = []; // 'Descripcion' => ['count'=>n, 'total'=>suma]
    $porTransitoTxt = []; // 'DeptoDescripcion' => count

    foreach (to_object($result) as $row) {
        $i++;
        $id     = (string)$row->IdOrden;
        $folio  = (string)($row->FolioOrden ?? 'NA');
        $fecha  = (string)($row->Fecha ?? '');
        $fechaD = substr($fecha, 0, 10);
        $vend   = (string)($row->Usuario ?? 'S/D');
        $total  = (float)($row->Total ?? 0);

        $totalGeneral += $total;

        // Acumulados para gráficas con NOMBRES
        $estNombre = trim((string)($row->Descripcion ?? 'Sin estatus'));
        if ($estNombre === '') $estNombre = 'Sin estatus';
        if (!isset($porEstatusTxt[$estNombre])) $porEstatusTxt[$estNombre] = ['count'=>0,'total'=>0.0];
        $porEstatusTxt[$estNombre]['count']++;
        $porEstatusTxt[$estNombre]['total'] += $total;

        $depNombre = trim((string)($row->DeptoDescripcion ?? 'Sin depto'));
        if ($depNombre === '') $depNombre = 'Sin depto';
        if (!isset($porTransitoTxt[$depNombre])) $porTransitoTxt[$depNombre] = 0;
        $porTransitoTxt[$depNombre]++;

        // fila
        $tbody .= '<tr>
            <td width="60"  align="center">'.$i.'</td>
            <td width="70"  align="center">'.htmlspecialchars($id).'</td>
            <td width="80"  align="center">'.htmlspecialchars($fechaD).'</td>
            <td width="210"  align="left">'.htmlspecialchars($vend).'</td>
            <td width="100"  align="right">$'.number_format($total, 2, '.').'</td>
        </tr>';
    }

    $tfoot = '
        <tr>
            <td colspan="4" align="right"><strong>Total</strong></td>
            <td align="right"><strong>$'.number_format($totalGeneral, 2, '.').'</strong></td>
        </tr>';

    $html = $titulo.$sub.$thead.$tbody.$tfoot.'</table>';
    $pdf->writeHTML($html, true, false, true, false, '');

    // ================== GRÁFICAS con nombres ==================
    $pdf->AddPage();
    $pdf->SetFont('helvetica', '', 11);

    // Re-encabezado visual por compatibilidad
    $bMargin = $pdf->getBreakMargin();
    $auto_page_break = $pdf->getAutoPageBreak();
    $pdf->SetAutoPageBreak(false, 0);
    if (file_exists($img_file)) {
        $pdf->Image($img_file, 0, 0, 210, 23, '', '', '', false, 300, '', false, false, 0);
    }
    $pdf->SetAutoPageBreak($auto_page_break, $bMargin);
    $pdf->setPageMark();

    // Helper para recortar texto en la etiqueta
    $short = function($s, $len=18) {
        $s = (string)$s;
        return (mb_strlen($s,'UTF-8') > $len) ? (mb_substr($s,0,$len,'UTF-8').'…') : $s;
    };

    // --- A) Total por Estatus (barras, usando Descripcion)
    $pdf->Cell(0, 8, 'Total de órdenes por Estatus (importe).', 0, 1, 'C');
    if (empty($porEstatusTxt)) {
        $pdf->Cell(0, 8, 'Sin datos.', 0, 1, 'C');
    } else {
        ksort($porEstatusTxt, SORT_NATURAL | SORT_FLAG_CASE);
        $labels = array_keys($porEstatusTxt);
        $values = array_map(function($v){ return (float)$v['total']; }, array_values($porEstatusTxt));

        // Área de dibujo
        $margenIzq=16; $margenDer=10; $margenTop=35;
        $ancho=210-$margenIzq-$margenDer; $alto=70;
        $x0=$margenIzq; $y0=$margenTop+$alto; $yTop=$margenTop;

        // Ejes
        $pdf->SetDrawColor(0,0,0);
        $pdf->Line($x0, $y0, $x0+$ancho, $y0);
        $pdf->Line($x0, $y0, $x0, $yTop);

        $maxVal = max($values); if ($maxVal <= 0) $maxVal = 1;
        $n = count($values);
        $gap = 2.0;
        $barWidth = max(6.0, min(22.0, ($ancho-($n+1)*$gap)/$n));

        $x = $x0 + $gap;
        $pdf->SetFont('helvetica','',7);
        for ($k=0; $k<$n; $k++) {
            $val = (float)$values[$k];
            $h = ($val/$maxVal) * ($alto - 14);
            $pdf->SetFillColor(60,130,220);
            $pdf->Rect($x, $y0-$h, $barWidth, $h, 'DF');

            // valor
            $valTxt = '$'.number_format($val,0,'.',',');
            if ($h > 8) { $pdf->SetTextColor(255,255,255); $pdf->Text($x+0.5, $y0-$h+1.0, $valTxt); $pdf->SetTextColor(0,0,0); }
            else { $pdf->Text($x, $y0-$h-4, $valTxt); }

            // etiqueta (nombre del estatus)
            $lbl = $short($labels[$k], 20);
            if ($barWidth < 12) { $pdf->StartTransform(); $pdf->Rotate(60, $x+($barWidth/2), $y0+1); $pdf->Text($x-2, $y0+1, $lbl); $pdf->StopTransform(); }
            else { $pdf->Text($x-1, $y0+3, $lbl); }

            $x += ($barWidth + $gap);
        }
    }

    $pdf->Ln(6);

    // --- B) Órdenes por Departamento en Tránsito (conteo, usando DeptoDescripcion)
    $pdf->Cell(0, 8, 'Órdenes por Departamento en Tránsito (conteo).', 0, 1, 'C');
    if (empty($porTransitoTxt)) {
        $pdf->Cell(0, 8, 'Sin datos.', 0, 1, 'C');
    } else {
        ksort($porTransitoTxt, SORT_NATURAL | SORT_FLAG_CASE);
        $labels = array_keys($porTransitoTxt);
        $values = array_values($porTransitoTxt);

        // Área de dibujo
        $margenIzq=16; $margenDer=10; $margenTop=35+90;
        $ancho=210-$margenIzq-$margenDer; $alto=70;
        $x0=$margenIzq; $y0=$margenTop+$alto; $yTop=$margenTop;

        // Ejes
        $pdf->SetDrawColor(0,0,0);
        $pdf->Line($x0, $y0, $x0+$ancho, $y0);
        $pdf->Line($x0, $y0, $x0, $yTop);

        $maxVal = max($values); if ($maxVal <= 0) $maxVal = 1;
        $n = count($values);
        $gap = 2.0;
        $barWidth = max(6.0, min(22.0, ($ancho-($n+1)*$gap)/$n));

        $x = $x0 + $gap;
        $pdf->SetFont('helvetica','',7);
        for ($k=0; $k<$n; $k++) {
            $val = (float)$values[$k];
            $h = ($val/$maxVal) * ($alto - 14);
            $pdf->SetFillColor(120,180,80);
            $pdf->Rect($x, $y0-$h, $barWidth, $h, 'DF');

            // valor
            $valTxt = (string)number_format($val,0,'.',',');
            if ($h > 8) { $pdf->SetTextColor(255,255,255); $pdf->Text($x+0.5, $y0-$h+1.0, $valTxt); $pdf->SetTextColor(0,0,0); }
            else { $pdf->Text($x, $y0-$h-4, $valTxt); }

            // etiqueta (nombre del depto)
            $lbl = $short($labels[$k], 22);
            if ($barWidth < 12) { $pdf->StartTransform(); $pdf->Rotate(60, $x+($barWidth/2), $y0+1); $pdf->Text($x-2, $y0+1, $lbl); $pdf->StopTransform(); }
            else { $pdf->Text($x-1, $y0+3, $lbl); }

            $x += ($barWidth + $gap);
        }
    }
    // ... después de terminar el segundo gráfico (Depto en tránsito)
$pdf->Ln(10);

// ========= NUEVA PÁGINA PARA EL TERCER GRÁFICO =========
$pdf->AddPage();
$pdf->SetFont('helvetica', '', 9);

// (opcional) si quieres repetir el encabezado gráfico en cada página:
// $bMargin = $pdf->getBreakMargin();
// $auto_page_break = $pdf->getAutoPageBreak();
// $pdf->SetAutoPageBreak(false, 0);
// $img_file = 'assets/img/images/formatos/encabezado.png';
// if (file_exists($img_file)) {
//     $pdf->Image($img_file, 0, 0, 210, 23, '', '', '', false, 300, '', false, false, 0);
// }
// $pdf->SetAutoPageBreak($auto_page_break, $bMargin);
// $pdf->setPageMark();

// --- C) Órdenes por Estatus (conteo)
$pdf->Cell(0, 8, 'Órdenes por Estatus (conteo).', 0, 1, 'C');

if (empty($porEstatusTxt)) {
    $pdf->Cell(0, 8, 'Sin datos.', 0, 1, 'C');
} else {
    ksort($porEstatusTxt, SORT_NATURAL | SORT_FLAG_CASE);
    $labels = array_keys($porEstatusTxt);
    $values = array_map(function($v){ return (int)$v['count']; }, array_values($porEstatusTxt));

    // Área de dibujo
    $margenIzq=16; $margenDer=10; $margenTop=$pdf->GetY()+10;
    $ancho=210-$margenIzq-$margenDer; $alto=70;
    $x0=$margenIzq; $y0=$margenTop+$alto; $yTop=$margenTop;

    // Ejes
    $pdf->SetDrawColor(0,0,0);
    $pdf->Line($x0, $y0, $x0+$ancho, $y0);
    $pdf->Line($x0, $y0, $x0, $yTop);

    $maxVal = max($values); if ($maxVal <= 0) $maxVal = 1;
    $n = count($values);
    $gap = 2.0;
    $barWidth = max(6.0, min(22.0, ($ancho-($n+1)*$gap)/$n));

    $x = $x0 + $gap;
    $pdf->SetFont('helvetica','',7);
    $short = function($s, $len=22){ $s=(string)$s; return (mb_strlen($s,'UTF-8')>$len)?(mb_substr($s,0,$len,'UTF-8').'…'):$s; };

    for ($k=0; $k<$n; $k++) {
        $val = (int)$values[$k];
        $h = ($val/$maxVal) * ($alto - 14);
        $pdf->SetFillColor(200,100,60);
        $pdf->Rect($x, $y0-$h, $barWidth, $h, 'DF');

        // valor
        $valTxt = (string)$val;
        if ($h > 8) { $pdf->SetTextColor(255,255,255); $pdf->Text($x+0.5, $y0-$h+1.0, $valTxt); $pdf->SetTextColor(0,0,0); }
        else { $pdf->Text($x, $y0-$h-4, $valTxt); }

        // etiqueta
        $lbl = $short($labels[$k], 22);
        if ($barWidth < 12) {
            $pdf->StartTransform();
            $pdf->Rotate(60, $x+($barWidth/2), $y0+1);
            $pdf->Text($x-2, $y0+1, $lbl);
            $pdf->StopTransform();
        } else {
            $pdf->Text($x-1, $y0+3, $lbl);
        }

        $x += ($barWidth + $gap);
    }
}


    $pdf->Output('ventas_generales.pdf', 'I');
}


// Terminan ventas generales
// Inician ventas por producto

function pdfVentasPorProducto() { 
    if ($_SERVER["REQUEST_METHOD"] != "POST") { Redirect::to('./reportes'); return; }

    // ===== Entradas del FRONT =====
    $fechaini = isset($_POST["fechaini"]) && $_POST["fechaini"] !== "" ? $_POST["fechaini"] :
                (isset($_POST["fecha_inicial"]) ? $_POST["fecha_inicial"] : "");
    $fechafin = isset($_POST["fechafin"]) && $_POST["fechafin"] !== "" ? $_POST["fechafin"] :
                (isset($_POST["fecha_final"]) ? $_POST["fecha_final"] : "");

    if ($fechaini === "") $fechaini = date('Y-m-d');
    if ($fechafin === "") $fechafin = date('Y-m-d');

    // Filtros avanzados del bloque "Ventas → Ventas por Producto"
    $skuFiltro      = isset($_POST["vpp_sku"]) ? trim((string)$_POST["vpp_sku"]) : "";
    $almacenFiltro  = isset($_POST["vpp_almacen_id"]) && $_POST["vpp_almacen_id"] !== "" ? (int)$_POST["vpp_almacen_id"] : null;

    // NUEVO: "Mostrar la última venta"
    $ultimaVenta    = (isset($_POST["vpp_ultima"]) && ($_POST["vpp_ultima"] === "1" || $_POST["vpp_ultima"] === "on")) ? 1 : 0;

    // ===== NUEVO: Categorías (desde checkboxes categorias[]) =====
    // Acepta tambien 'categoria' singular si existiera.
    $categoriasRaw = [];
    if (isset($_POST['categorias']) && is_array($_POST['categorias'])) {
        $categoriasRaw = $_POST['categorias'];
    } elseif (isset($_POST['categoria']) && $_POST['categoria'] !== '') {
        $categoriasRaw = [ $_POST['categoria'] ];
    }

    // Sanitiza: solo ids numéricos (proCatId es numérico)
    $categorias = [];
    foreach ($categoriasRaw as $c) {
        if (is_numeric($c)) { $categorias[] = (int)$c; }
    }
    $categorias = array_values(array_unique($categorias)); // sin duplicados

    // ===== SQL =====
    // - Relación por IdProducto (NO por SKU); SKU solo filtra desde productos.
    $where = [];

    // Omitir rango de fechas si piden "última venta"
    if (!$ultimaVenta) {
        $where[] = "o.Fecha BETWEEN '".addslashes($fechaini)."' AND '".addslashes($fechafin)."'";
    }
    if ($skuFiltro !== "") {
        $where[] = "p.proSku = '".addslashes($skuFiltro)."'";
    }
    if ($almacenFiltro !== null) {
        $where[] = "p.proAlmId = ".intval($almacenFiltro);
    }

    // ===== NUEVO: filtro por categoría (productos.proCatId)
    if (!empty($categorias)) {
        $where[] = "p.proCatId IN (".implode(',', array_map('intval', $categorias)).")";
    }

    $select = "
        SELECT
            o.IdOrden, o.FolioOrden, o.Fecha, o.IdUsuario,
            od.IdProducto, od.Cantidad, od.PrecioVenta, od.Neto,
            p.proId, p.proSku, p.proTitulo, p.proMarca, p.proAlmId, p.proCatId,
            a.almNombre,
            u.Usuario
        FROM ordenes o
        INNER JOIN ordenesdetalle od ON od.IdOrden = o.IdOrden
        INNER JOIN productos p       ON p.proId   = od.IdProducto
        LEFT  JOIN almacenes a       ON a.almId   = p.proAlmId
        LEFT  JOIN usuarios u        ON u.IdUsuario = o.IdUsuario
    ";

    $sql = $select . (count($where) ? " WHERE ".implode(" AND ", $where) : "");

    if ($ultimaVenta) {
        // Traer solo la línea más reciente que cumpla con los filtros (SKU/Almacén/Categoría)
        $sql .= " ORDER BY o.Fecha DESC, o.IdOrden DESC LIMIT 1";
    } else {
        $sql .= " ORDER BY o.Fecha ASC, o.IdOrden ASC";
    }

    $orden = new ordenesModel();
    $orden->sentencia = $sql;
    $result = $orden->ventasPorProducto();

    // ===== Preparar datos =====
    $rows = to_object($result);
    $kpis = [
        'total_importe' => 0.0,
        'total_unidades'=> 0,
        'ordenes'       => [],
        'sku'           => null,
        'producto'      => null,
        'almacen'       => null
    ];
    $porDiaCant  = []; // YYYY-MM-DD => cantidad
    $porDiaImp   = []; // YYYY-MM-DD => importe (Neto)

    foreach ($rows as $r) {
        $fechaD = substr((string)$r->Fecha, 0, 10);
        $cant   = (float)($r->Cantidad ?? 0);
        $neto   = (float)($r->Neto ?? 0);

        $kpis['total_importe'] += $neto;
        $kpis['total_unidades'] += $cant;
        $kpis['ordenes'][(string)$r->IdOrden] = true;

        if (!isset($porDiaCant[$fechaD])) $porDiaCant[$fechaD] = 0;
        if (!isset($porDiaImp[$fechaD]))  $porDiaImp[$fechaD]  = 0.0;
        $porDiaCant[$fechaD] += $cant;
        $porDiaImp[$fechaD]  += $neto;

        if ($kpis['sku'] === null)       $kpis['sku'] = (string)($r->proSku ?? '');
        elseif ($kpis['sku'] !== (string)($r->proSku ?? '')) $kpis['sku'] = 'Varios';

        if ($kpis['producto'] === null)  $kpis['producto'] = (string)($r->proTitulo ?? '');
        elseif ($kpis['producto'] !== (string)($r->proTitulo ?? '')) $kpis['producto'] = 'Varios productos';

        if ($kpis['almacen'] === null)   $kpis['almacen'] = (string)($r->almNombre ?? '');
        elseif ($kpis['almacen'] !== (string)($r->almNombre ?? '')) $kpis['almacen'] = 'Varios almacenes';
    }
    $kpis['ordenes_count'] = count($kpis['ordenes']);
    $precioProm = $kpis['total_unidades'] > 0 ? ($kpis['total_importe'] / $kpis['total_unidades']) : 0;

    // ===== PDF =====
    $pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
    $pdf->SetTitle('Ventas por Producto');
    $pdf->setPrintHeader(false);
    $pdf->setPrintFooter(true);
    $pdf->SetMargins(13, 17, 5, true);
    $pdf->AddPage();
    $pdf->SetFont('helvetica', '', 11);

    // Encabezado visual
    $bMargin = $pdf->getBreakMargin();
    $auto_page_break = $pdf->getAutoPageBreak();
    $pdf->SetAutoPageBreak(false, 0);
    $img_file = 'assets/img/images/formatos/encabezado.png';
    if (file_exists($img_file)) {
        $pdf->Image($img_file, 0, 0, 210, 23, '', '', '', false, 300, '', false, false, 0);
    }
    $pdf->SetAutoPageBreak($auto_page_break, $bMargin);
    $pdf->setPageMark();

    // Título + subtítulo (con filtros)
    $titulo = '<div style="text-align:center;"><h2>VENTAS POR PRODUCTO</h2></div>';
    $subs = [];
    if ($ultimaVenta) {
        $subs[] = 'Modo: Última venta (ignora rango de fechas)';
    } else {
        $subs[] = 'Rango: '.htmlspecialchars($fechaini).' al '.htmlspecialchars($fechafin);
    }
    if ($skuFiltro !== '')       $subs[] = 'SKU: '.htmlspecialchars($skuFiltro);
    if ($almacenFiltro !== null) $subs[] = 'Almacén ID: '.htmlspecialchars((string)$almacenFiltro);
    // NUEVO: mostrar si llegó filtro de categoría
    if (!empty($categorias))     $subs[] = 'Categoría(s): '.htmlspecialchars(implode(',', $categorias));

    $sub = '<div style="text-align:center;margin-bottom:8px;"><strong>'.implode(' | ', $subs).'</strong></div>';

    // KPIs
    $pdf->writeHTML($titulo.$sub, true, false, true, false, '');
    $pdf->SetFont('helvetica', '', 9);
    $kpiHtml = '
        <table cellpadding="4" cellspacing="0" border="0" style="margin-bottom:6px;">
            <tr>
                <td width="45%"><strong>Producto:</strong> '.htmlspecialchars($kpis['producto'] ?? '—').'</td>
                <td width="25%"><strong>SKU:</strong> '.htmlspecialchars($kpis['sku'] ?? '—').'</td>
                <td width="30%"><strong>Almacén:</strong> '.htmlspecialchars($kpis['almacen'] ?? '—').'</td>
            </tr>
            <tr>
                <td><strong>Total vendido (Neto):</strong> $'.number_format($kpis['total_importe'], 2, '.', ',').'</td>
                <td><strong>Unidades:</strong> '.number_format($kpis['total_unidades']).'</td>
                <td><strong>Precio promedio:</strong> $'.number_format($precioProm, 2, '.', ',').'</td>
            </tr>
            <tr>
                <td><strong>Órdenes:</strong> '.$kpis['ordenes_count'].'</td>
                <td></td>
                <td></td>
            </tr>
        </table>';
    $pdf->writeHTML($kpiHtml, true, false, true, false, '');

    // ===== Tabla de líneas =====
    $thead = '<table border="1" cellpadding="3" cellspacing="0">
        <thead>
            <tr style="background-color:#f2f2f2;">
                <th width="50" align="center">ID</th>
                <th width="50" align="center">Fecha</th>
                <th width="50" align="center">SKU</th>
                <th width="140" align="left">Producto</th>
                <th width="60" align="left">Almacén</th>
                <th width="40" align="right">Cant</th>
                <th width="65" align="right">P. Unit</th>
                <th width="70" align="right">Neto</th>
            </tr>
        </thead>';
    $tbody = '';
    $pdf->SetFont('helvetica','',8);

    $i=0;
    foreach ($rows as $r) {
        $i++;
        $fechaD = substr((string)$r->Fecha, 0, 10);
        $cant   = (float)($r->Cantidad ?? 0);
        $neto   = (float)($r->Neto ?? 0);
        $punit  = ($cant > 0 ? $neto/$cant : (float)($r->PrecioVenta ?? 0));

        $tbody .= '<tr>
            <td width="50" align="center">'.htmlspecialchars((string)$r->IdOrden).'</td>
            <td width="50" align="center">'.htmlspecialchars($fechaD).'</td>
            <td width="50" align="center">'.htmlspecialchars((string)($r->proSku ?? '')).'</td>
            <td width="140" align="left">'.htmlspecialchars((string)($r->proTitulo ?? '')).'</td>
            <td width="60" align="left">'.htmlspecialchars((string)($r->almNombre ?? '')).'</td>
            <td width="40" align="right">'.number_format($cant,0,'.',',').'</td>
            <td width="65" align="right">$'.number_format($punit,2,'.',',').'</td>
            <td width="70" align="right">$'.number_format($neto,2,'.',',').'</td>
        </tr>';
    }
    if ($tbody === '') {
        $tbody = '<tr><td colspan="11" align="center">Sin registros para los filtros seleccionados.</td></tr>';
    }
    $tfoot = '
        <tr>
            <td colspan="7" align="right"><strong>Total:</strong></td>
            <td align="right"><strong>$'.number_format($kpis['total_importe'], 2, '.', ',').'</strong></td>
        </tr>';
    $pdf->writeHTML($thead.$tbody.$tfoot.'</table>', true, false, true, false, '');

    // ===== Gráficas (solo cuando NO es "última venta") =====
    if (!$ultimaVenta && !empty($porDiaCant)) {
        $pdf->AddPage();

        $bMargin = $pdf->getBreakMargin();
        $auto_page_break = $pdf->getAutoPageBreak();
        $pdf->SetAutoPageBreak(false, 0);
        if (file_exists($img_file)) {
            $pdf->Image($img_file, 0, 0, 210, 23, '', '', '', false, 300, '', false, false, 0);
        }
        $pdf->SetAutoPageBreak($auto_page_break, $bMargin);
        $pdf->setPageMark();

        ksort($porDiaCant);
        ksort($porDiaImp);
        $labels = array_keys($porDiaCant);
        $valsQ  = array_values($porDiaCant);
        $valsX  = array_values($porDiaImp);

        // Cantidad por día
        $pdf->SetFont('helvetica','',10);
        $pdf->Cell(0, 8, 'Cantidad vendida por día', 0, 1, 'C');
        $mIzq=16; $mDer=10; $mTop=40;
        $W=210-$mIzq-$mDer; $H=70;
        $x0=$mIzq; $y0=$mTop+$H; $yTop=$mTop;

        $pdf->SetDrawColor(0,0,0);
        $pdf->Line($x0, $y0, $x0+$W, $y0);
        $pdf->Line($x0, $y0, $x0, $yTop);

        $maxQ = max($valsQ); if ($maxQ <= 0) $maxQ = 1;
        $n = count($valsQ);
        $gap = 2.0;
        $bw  = max(2.0, min(16.0, ($W-($n+1)*$gap)/$n));
        $x = $x0 + $gap;

        $pdf->SetFont('helvetica','',7);
        for ($i=0; $i<$n; $i++) {
            $v = (float)$valsQ[$i];
            $h = ($v/$maxQ) * ($H - 14);
            $pdf->SetFillColor(60,130,220);
            $pdf->Rect($x, $y0-$h, $bw, $h, 'DF');

            $txt = number_format($v,0,'.',',');
            if ($h > 8) { $pdf->SetTextColor(255,255,255); $pdf->Text($x+0.5, $y0-$h+1.0, $txt); $pdf->SetTextColor(0,0,0); }
            else { $pdf->Text($x, $y0-$h-4, $txt); }

            $lbl = (string)$labels[$i];
            if ($bw < 8) {
                $pdf->StartTransform();
                $pdf->Rotate(60, $x+($bw/2), $y0+1);
                $pdf->Text($x-1, $y0+1, $lbl);
                $pdf->StopTransform();
            } else {
                $pdf->Text($x-1, $y0+3, $lbl);
            }
            $x += ($bw + $gap);
        }

        $pdf->Ln(6);

        // Importe por día
        $pdf->SetFont('helvetica','',10);
        $pdf->Cell(0, 8, 'Ventas (Neto) por día', 0, 1, 'C');
        $mTop2 = $pdf->GetY()+4;
        $H2=70; $y02=$mTop2+$H2; $yTop2=$mTop2;

        $pdf->SetDrawColor(0,0,0);
        $pdf->Line($x0, $y02, $x0+$W, $y02);
        $pdf->Line($x0, $y02, $x0, $yTop2);

        $maxS = max($valsX); if ($maxS <= 0) $maxS = 1;
        $x = $x0 + $gap;
        $pdf->SetFont('helvetica','',7);
        for ($i=0; $i<$n; $i++) {
            $v = (float)$valsX[$i];
            $h = ($v/$maxS) * ($H2 - 14);
            $pdf->SetFillColor(90,170,90);
            $pdf->Rect($x, $y02-$h, $bw, $h, 'DF');

            $txt = '$'.number_format($v,0,'.',',');
            if ($h > 8) { $pdf->SetTextColor(255,255,255); $pdf->Text($x+0.5, $y02-$h+1.0, $txt); $pdf->SetTextColor(0,0,0); }
            else { $pdf->Text($x, $y02-$h-4, $txt); }

            $lbl = (string)$labels[$i];
            if ($bw < 8) {
                $pdf->StartTransform();
                $pdf->Rotate(60, $x+($bw/2), $y02+1);
                $pdf->Text($x-1, $y02+1, $lbl);
                $pdf->StopTransform();
            } else {
                $pdf->Text($x-1, $y02+3, $lbl);
            }
            $x += ($bw + $gap);
        }
    }

    $pdf->Output('ventas_por_producto.pdf', 'I');
}

// Terminan ventas por producto
// Inica ventas por categoria
function pdfVentasPorCategoria() {
    ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);

    if ($_SERVER["REQUEST_METHOD"] != "POST") { Redirect::to('./reportes'); return; }

    // ===== Fechas (compatibilidad con nombres previos) =====
    $fechaini = isset($_POST["fechaini"]) && $_POST["fechaini"] !== "" ? $_POST["fechaini"] :
                (isset($_POST["fecha_inicial"]) ? $_POST["fecha_inicial"] : "");
    $fechafin = isset($_POST["fechafin"]) && $_POST["fechafin"] !== "" ? $_POST["fechafin"] :
                (isset($_POST["fecha_final"]) ? $_POST["fecha_final"] : "");

    if ($fechaini === "") $fechaini = date('Y-m-d');
    if ($fechafin === "") $fechafin = date('Y-m-d');

    // ===== Filtros =====
    $cats = [];
    if (isset($_POST["categorias"]) && is_array($_POST["categorias"])) {
        foreach ($_POST["categorias"] as $cid) {
            $cid = (int)$cid;
            if ($cid > 0) $cats[] = $cid;
        }
    }
    $almacenId = isset($_POST["vpp_almacen_id"]) && $_POST["vpp_almacen_id"] !== "" ? (int)$_POST["vpp_almacen_id"] : null;

    // ===== WHERE dinámico =====
    $where = [];
    $where[] = "o.Fecha BETWEEN '".$fechaini."' AND '".$fechafin."'";
    if (!empty($cats)) {
        $where[] = "p.proCatId IN (".implode(',', array_map('intval', $cats)).")";
    }
    if ($almacenId !== null) {
        $where[] = "p.proAlmId = ".intval($almacenId);
    }

    // ===== Consulta agregada por categoría =====
    $detalle = new ordenesModel();
    $detalle->sentencia = "
        SELECT 
            c.catId,
            c.catNombre,
            SUM(od.Cantidad) AS CantidadVendida,
            SUM(od.Neto)     AS TotalVendido
        FROM ordenesdetalle od
        INNER JOIN ordenes   o ON o.IdOrden = od.IdOrden
        INNER JOIN productos p ON p.proId   = od.IdProducto
        INNER JOIN categorias c ON c.catId  = p.proCatId
        WHERE ".implode(" AND ", $where)."
        GROUP BY c.catId, c.catNombre
        ORDER BY TotalVendido DESC
    ";
    $result = $detalle->ventasPorCategoria();

    // Normalizar a ARREGLO DE FILAS para evitar count(false)
    $rows = to_object($result);
    if ($rows === false || $rows === null) {
        $rows = [];
    } elseif ($rows instanceof stdClass) {
        $rows = [$rows];
    } elseif (!is_array($rows)) {
        // Cualquier otro tipo inesperado -> vacío
        $rows = [];
    }

    // ===== Agregados para KPIs + gráficas =====
    $labels = []; 
    $valsImporte = []; 
    $valsCantidad = [];
    $totalImporte = 0.0; 
    $totalUnidades = 0;

    foreach ($rows as $r) {
        $labels[]       = (string)$r->catNombre;
        $valsImporte[]  = (float)$r->TotalVendido;
        $valsCantidad[] = (float)$r->CantidadVendida;
        $totalImporte  += (float)$r->TotalVendido;
        $totalUnidades += (float)$r->CantidadVendida;
    }
    // Usar lo ya acumulado (más seguro que count($rows))
    $catsConsideradas = count($labels);

    // ===== PDF =====
    $pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
    $pdf->SetTitle('Ventas por Categoría');
    $pdf->setPrintHeader(false);
    $pdf->setPrintFooter(true);
    $pdf->SetMargins(13, 17, 5, true);
    $pdf->AddPage();
    $pdf->SetFont('helvetica', '', 11);

    // Encabezado visual
    $bMargin = $pdf->getBreakMargin();
    $auto_page_break = $pdf->getAutoPageBreak();
    $pdf->SetAutoPageBreak(false, 0);
    $img_file = 'assets/img/images/formatos/encabezado.png';
    if (file_exists($img_file)) {
        $pdf->Image($img_file, 0, 0, 210, 23, '', '', '', false, 300, '', false, false, 0);
    }
    $pdf->SetAutoPageBreak($auto_page_break, $bMargin);
    $pdf->setPageMark();

    $titulo = '<div style="text-align:center;"><h2>REPORTE DE VENTAS POR CATEGORÍA</h2></div>';
    $subs = [];
    $subs[] = 'Rango: '.htmlspecialchars($fechaini).' al '.htmlspecialchars($fechafin);
    if (!empty($cats))       $subs[] = 'Categorías: '.count($cats).' seleccionadas';
    if ($almacenId !== null) $subs[] = 'Almacén ID: '.htmlspecialchars((string)$almacenId);
    $sub = '<div style="text-align:center;margin-bottom:8px;"><strong>'.implode(' | ', $subs).'</strong></div>';

    // KPIs
    $kpiHtml = '
        <table cellpadding="4" cellspacing="0" border="0" style="margin-bottom:6px;">
            <tr>
                <td width="40%"><strong>Categorías:</strong> '.$catsConsideradas.'</td>
                <td width="30%"><strong>Unidades:</strong> '.number_format($totalUnidades).'</td>
                <td width="30%"><strong>Total (Neto):</strong> $'.number_format($totalImporte, 2, '.', ',').'</td>
            </tr>
        </table>';

    $pdf->writeHTML($titulo.$sub.$kpiHtml, true, false, true, false, '');

    // Tabla
    $thead = '<table border="1" cellpadding="4" cellspacing="0">
        <thead>
            <tr style="background-color:#f2f2f2;">
                <th width="210" align="left">Categoría</th>
                <th width="100"  align="right">Cantidad</th>
                <th width="210"  align="right">Total Vendido</th>
            </tr>
        </thead>';
    $tbody = '';
    $pdf->SetFont('helvetica','',9);

    if (empty($rows)) {
        $tbody = '<tr><td colspan="3" align="center">Sin datos para los filtros seleccionados.</td></tr>';
    } else {
        foreach ($rows as $r) {
            $tbody .= '<tr>
                <td width="210">'.htmlspecialchars((string)$r->catNombre).'</td>
                <td width="100" align="right">'.number_format((float)$r->CantidadVendida,0,'.',',').'</td>
                <td width="210" align="right">$'.number_format((float)$r->TotalVendido,2,'.',',').'</td>
            </tr>';
        }
    }
    $tfoot = '
        <tr>
            <td align="right"><strong>Totales</strong></td>
            <td align="right"><strong>'.number_format($totalUnidades,0,'.',',').'</strong></td>
            <td align="right"><strong>$'.number_format($totalImporte,2,'.',',').'</strong></td>
        </tr>';

    $pdf->writeHTML($thead.$tbody.$tfoot.'</table>', true, false, true, false, '');

    // ===== Gráficas (Importe y Cantidad) =====
    if (!empty($rows)) {
        $pdf->AddPage();

        // Reordena por importe desc
        $data = [];
        for ($i=0; $i<count($labels); $i++) {
            $data[] = ['label'=>$labels[$i], 'imp'=>$valsImporte[$i], 'cant'=>$valsCantidad[$i]];
        }
        usort($data, function($a,$b){ return $b['imp'] <=> $a['imp']; });

        $mL=16; $mR=10; $mT=40; $W=210-$mL-$mR;

        // Gráfica Importe
        $pdf->SetFont('helvetica','',11);
        $pdf->Cell(0, 8, 'Ventas por Categoría (Neto)', 0, 1, 'C');
        $H=70; $x0=$mL; $y0=$mT+$H; $yTop=$mT;
        $pdf->SetDrawColor(0,0,0);
        $pdf->Line($x0, $y0, $x0+$W, $y0);
        $pdf->Line($x0, $y0, $x0, $yTop);

        $vals = array_column($data,'imp');
        $labs = array_column($data,'label');
        $maxV = max($vals); if ($maxV <= 0) $maxV = 1;
        $n = count($vals); $gap=2.0; $bw=max(2.0,min(16.0,($W-($n+1)*$gap)/$n));
        $x=$x0+$gap; $pdf->SetFont('helvetica','',7);
        for ($i=0; $i<$n; $i++) {
            $v=(float)$vals[$i]; $h=($v/$maxV)*($H-14);
            $pdf->SetFillColor(60,130,220); $pdf->Rect($x,$y0-$h,$bw,$h,'DF');
            $txt='$'.number_format($v,0,'.',',');
            if ($h>8){ $pdf->SetTextColor(255,255,255); $pdf->Text($x+0.5,$y0-$h+1.0,$txt); $pdf->SetTextColor(0,0,0); }
            else { $pdf->Text($x,$y0-$h-4,$txt); }
            $lbl=(string)$labs[$i];
            if ($bw<10){ $pdf->StartTransform(); $pdf->Rotate(60,$x+$bw/2,$y0+1); $pdf->Text($x-1,$y0+1,mb_substr($lbl,0,14)); $pdf->StopTransform(); }
            else { $pdf->Text($x-2,$y0+3,mb_substr($lbl,0,14)); }
            $x+=($bw+$gap);
        }

        // Gráfica Cantidad
        $pdf->Ln(8);
        $pdf->SetFont('helvetica','',11);
        $pdf->Cell(0, 8, 'Cantidad vendida por Categoría', 0, 1, 'C');
        $mT2=$pdf->GetY()+2; $H2=70; $x0=$mL; $y0=$mT2+$H2; $yTop=$mT2;
        $pdf->SetDrawColor(0,0,0);
        $pdf->Line($x0, $y0, $x0+$W, $y0);
        $pdf->Line($x0, $y0, $x0, $yTop);

        $valsQ = array_column($data,'cant');
        $maxQ = max($valsQ); if ($maxQ <= 0) $maxQ = 1;
        $n = count($valsQ); $gap=2.0; $bw=max(2.0,min(16.0,($W-($n+1)*$gap)/$n));
        $x=$x0+$gap; $pdf->SetFont('helvetica','',7);
        for ($i=0; $i<$n; $i++) {
            $v=(float)$valsQ[$i]; $h=($v/$maxQ)*($H2-14);
            $pdf->SetFillColor(90,170,90); $pdf->Rect($x,$y0-$h,$bw,$h,'DF');
            $txt=number_format($v,0,'.',',');
            if ($h>8){ $pdf->SetTextColor(255,255,255); $pdf->Text($x+0.5,$y0-$h+1.0,$txt); $pdf->SetTextColor(0,0,0); }
            else { $pdf->Text($x,$y0-$h-4,$txt); }
            $lbl=(string)$labs[$i];
            if ($bw<10){ $pdf->StartTransform(); $pdf->Rotate(60,$x+$bw/2,$y0+1); $pdf->Text($x-1,$y0+1,mb_substr($lbl,0,14)); $pdf->StopTransform(); }
            else { $pdf->Text($x-2,$y0+3,mb_substr($lbl,0,14)); }
            $x+=($bw+$gap);
        }
    }

    $pdf->Output('ventas_por_categoria.pdf','I');
}


// Fin pdf por categorias
// Inicio pdf por vendedores

function pdfVentasPorVendedor() {
    if ($_SERVER["REQUEST_METHOD"] != "POST") { Redirect::to('./reportes'); return; }

    // ====== Entrada ======
    $fechaini = $_POST["fechaini"] ?? ($_POST["fecha_inicial"] ?? "");
    $fechafin = $_POST["fechafin"] ?? ($_POST["fecha_final"] ?? "");
    if ($fechaini === "") $fechaini = date('Y-m-01');
    if ($fechafin === "") $fechafin = date('Y-m-d');

    $vendId   = isset($_POST["vv_vendedor_id"]) && $_POST["vv_vendedor_id"] !== "" ? (int)$_POST["vv_vendedor_id"] : null;
    $estSel   = isset($_POST["ven_estatus_id"]) && $_POST["ven_estatus_id"] !== "" ? (int)$_POST["ven_estatus_id"] : null;
    $tranSel  = isset($_POST["ven_transito_id"]) && $_POST["ven_transito_id"] !== "" ? (int)$_POST["ven_transito_id"] : null;

    // ====== WHERE ======
    $where = [];
    $where[] = "o.Fecha BETWEEN '".$fechaini."' AND '".$fechafin."'";
    if ($vendId !== null) $where[] = "o.IdUsuario = ".intval($vendId);
    if ($estSel !== null) $where[] = "o.Estatus = ".intval($estSel);
    if ($tranSel !== null) $where[] = "o.EstadoTransito = ".intval($tranSel);
    $whereSQL = " WHERE ".implode(" AND ", $where)." ";

    // ====== WHERE ======
    $where2 = [];
    $where2[] = "o.Fecha BETWEEN '".$fechaini."' AND '".$fechafin."' AND o.Estatus NOT IN (5,6,7,9) ";
    if ($vendId !== null) $where2[] = "o.IdUsuario = ".intval($vendId);
    if ($estSel !== null) $where2[] = "o.Estatus = ".intval($estSel);
    if ($tranSel !== null) $where2[] = "o.EstadoTransito = ".intval($tranSel);
    $whereSQL2 = " WHERE ".implode(" AND ", $where2)." ";

    // ====== Consultas ======
    $orden = new ordenesModel();

    // 1) Tabla: órdenes del vendedor (AGRUPADO por orden)
    $orden->sentencia = "
        SELECT 
            o.IdOrden, o.FolioOrden, o.Fecha,
            u.Usuario AS Vendedor,
            s1.Descripcion AS EstatusDesc,
            s2.Descripcion AS TransitoDesc,
            SUM(od.Neto) AS Total
        FROM ordenes o
        INNER JOIN ordenesdetalle od ON od.IdOrden = o.IdOrden
        INNER JOIN usuarios u ON u.IdUsuario = o.IdUsuario
        LEFT  JOIN estatus s1 ON s1.IdEstatus = o.Estatus
        LEFT  JOIN estatus s2 ON s2.IdEstatus = o.EstadoTransito
        $whereSQL2
        GROUP BY o.IdOrden
        ORDER BY o.Fecha ASC, o.IdOrden ASC
    ";
    $resOrdenes = $orden->ventasPorVendedor(); // método análogo a ventasGenerales()

    // 2) Top productos del vendedor (por Cantidad y por Total)
    $orden->sentencia = "
        SELECT 
            o.IdOrden,p.proId, p.proSku, p.proTitulo,
            SUM(od.Cantidad) AS CantidadVendida,
            SUM(od.Neto) AS TotalVendido
        FROM ordenes o
        INNER JOIN ordenesdetalle od ON od.IdOrden = o.IdOrden
        INNER JOIN productos p ON p.proId = od.IdProducto
        $whereSQL
        GROUP BY p.proId
        ORDER BY TotalVendido DESC
    ";
    $resTopProd = $orden->ventasPorVendedorTopProductos();

    // 3) Resumen por estatus y por tránsito
    $orden->sentencia = "
        SELECT COALESCE(s1.Descripcion,'(s/d)') AS Etiqueta, COUNT(DISTINCT o.IdOrden) AS Ordenes, SUM(od.Neto) AS Total
        FROM ordenes o
        INNER JOIN ordenesdetalle od ON od.IdOrden = o.IdOrden
        LEFT  JOIN estatus s1 ON s1.IdEstatus = o.Estatus
        $whereSQL
        GROUP BY o.Estatus
        ORDER BY Total DESC
    ";
    $resPorEstatus = $orden->ventasPorVendedorPorEstatus();

    $orden->sentencia = "
        SELECT COALESCE(s2.Descripcion,'(s/d)') AS Etiqueta, COUNT(DISTINCT o.IdOrden) AS Ordenes, SUM(od.Neto) AS Total
        FROM ordenes o
        INNER JOIN ordenesdetalle od ON od.IdOrden = o.IdOrden
        LEFT  JOIN estatus s2 ON s2.IdEstatus = o.EstadoTransito
        $whereSQL
        GROUP BY o.EstadoTransito
        ORDER BY Total DESC
    ";
    $resPorTransito = $orden->ventasPorVendedorPorTransito();

    // ====== Procesamiento para totales/series ======
    $rowsOrdenes = to_object($resOrdenes);
    $rowsTop     = to_object($resTopProd);
    $rowsEst     = to_object($resPorEstatus);
    $rowsTran    = to_object($resPorTransito);

    $totalGeneral = 0.0;
    $porDia = []; // 'YYYY-MM-DD' => total

    foreach ($rowsOrdenes as $r) {
        $total = (float)($r->Total ?? 0);
        $totalGeneral += $total;
        $fechaD = substr((string)$r->Fecha, 0, 10);
        if (!isset($porDia[$fechaD])) $porDia[$fechaD] = 0.0;
        $porDia[$fechaD] += $total;
    }

    // ====== PDF ======
    $pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
    $pdf->SetTitle('Ventas por Vendedor');
    $pdf->setPrintHeader(false);
    $pdf->setPrintFooter(true);
    $pdf->SetMargins(13, 17, 5, true);
    $pdf->AddPage();
    $pdf->SetFont('helvetica', '', 9);

    // Encabezado visual
    $bMargin = $pdf->getBreakMargin();
    $auto_page_break = $pdf->getAutoPageBreak();
    $pdf->SetAutoPageBreak(false, 0);
    $img_file = 'assets/img/images/formatos/encabezado.png';
    if (file_exists($img_file)) { $pdf->Image($img_file, 0, 0, 210, 23, '', '', '', false, 300, '', false, false, 0); }
    $pdf->SetAutoPageBreak($auto_page_break, $bMargin);
    $pdf->setPageMark();

    // Título + filtros
    $filtrosTxt = [];
    if ($vendId !== null && isset($rowsOrdenes[0]->Vendedor)) $filtrosTxt[] = "Vendedor: ".htmlspecialchars((string)$rowsOrdenes[0]->Vendedor);
    if ($estSel !== null) $filtrosTxt[] = "Estatus: ".$_POST['ven_estatus_id'];
    if ($tranSel !== null) $filtrosTxt[] = "Tránsito: ".$_POST['ven_transito_id'];

    $titulo = '<div style="text-align:center;"><h2>VENTAS POR VENDEDOR</h2></div>';
    $sub    = '<div style="text-align:center;margin-bottom:6px;"><strong>Rango: '
            .htmlspecialchars((string)$fechaini).' al '.htmlspecialchars((string)$fechafin).'</strong>'
            .(count($filtrosTxt)?'<br><span>'.implode(' • ', $filtrosTxt).'</span>':'')
            .'</div>';

    // ===== Vista 1: Detalle por orden =====
    $thead = '<table border="1" cellpadding="4" cellspacing="0">
      <thead>
        <tr style="background-color:#f2f2f2;">
          <th width="40" align="center">ID</th>
          <th width="60" align="center">Fecha</th>
          <th width="170" align="left">Vendedor</th>
          <th width="80" align="left">Estatus</th>
          <th width="80" align="left">Tránsito</th>
          <th width="80" align="right">Total</th>
        </tr>
      </thead>';
    $tbody = '';
    $i = 0;
    foreach ($rowsOrdenes as $r) {
        $i++;
        $tbody .= '<tr>
          <td align="center" width="40">'.htmlspecialchars((string)$r->IdOrden).'</td>
          <td align="center" width="60">'.htmlspecialchars(substr((string)$r->Fecha,0,10)).'</td>
          <td align="left" width="170">'.htmlspecialchars((string)($r->Vendedor ?? 'S/D')).'</td>
          <td align="left" width="80">'.htmlspecialchars((string)($r->EstatusDesc ?? 'S/D')).'</td>
          <td align="left" width="80">'.htmlspecialchars((string)($r->TransitoDesc ?? 'S/D')).'</td>
          <td align="right" width="80">$'.number_format((float)($r->Total ?? 0), 2, '.', ',').'</td>
        </tr>';
    }
    $tfoot = '<tr>
      <td colspan="5" align="right"><strong>Total</strong></td>
      <td align="right"><strong>$'.number_format($totalGeneral, 2, '.', ',').'</strong></td>
    </tr>';

    $pdf->writeHTML($titulo.$sub.$thead.$tbody.$tfoot.'</table>', true, false, true, false, '');

    // ===== Vista 2: Gráfica por día =====
    $pdf->AddPage();
    $pdf->SetFont('helvetica', '', 11);

    if (!empty($porDia)) {
        ksort($porDia);
        $labels = array_keys($porDia);
        $values = array_values($porDia);

        $pdf->Cell(0, 8, 'Ventas por día | Total $'.number_format($totalGeneral,2,'.',',').' | Órdenes '.count($rowsOrdenes), 0, 1, 'C');
        $pdf->Ln(2);

        $margenIzq=16; $margenDer=10; $margenTop=40;
        $ancho=210-$margenIzq-$margenDer; $alto=90;
        $x0=$margenIzq; $y0=$margenTop+$alto; $yTop=$margenTop;

        // Ejes
        $pdf->SetDrawColor(0,0,0);
        $pdf->Line($x0, $y0, $x0+$ancho, $y0); // X
        $pdf->Line($x0, $y0, $x0, $yTop);      // Y

        $maxVal = max($values); if ($maxVal <= 0) $maxVal = 1;
        $n = count($values); $gap = 2.0; 
        $barWidth = max(2.0, min(16.0, ($ancho-($n+1)*$gap)/$n));

        $x = $x0 + $gap;
        $pdf->SetFont('helvetica','',7);
        for ($k=0; $k<$n; $k++) {
            $val = (float)$values[$k];
            $h = ($val/$maxVal) * ($alto - 14);
            $pdf->SetFillColor(60,130,220);
            $pdf->Rect($x, $y0-$h, $barWidth, $h, 'DF');

            $valTxt = '$'.number_format($val,0,'.',',');
            if ($h > 8) {
                $pdf->SetTextColor(255,255,255);
                $pdf->Text($x+0.5, $y0-$h+1.0, $valTxt);
                $pdf->SetTextColor(0,0,0);
            } else {
                $pdf->Text($x, $y0-$h-4, $valTxt);
            }

            $fechaLbl = (string)$labels[$k];
            if ($barWidth < 8) {
                $pdf->StartTransform();
                $pdf->Rotate(60, $x+($barWidth/2), $y0+1);
                $pdf->Text($x-1, $y0+1, $fechaLbl);
                $pdf->StopTransform();
            } else {
                $pdf->Text($x-1, $y0+3, $fechaLbl);
            }
            $x += ($barWidth + $gap);
        }
    } else {
        $pdf->Cell(0,10,'Sin datos para la gráfica en el rango seleccionado.',0,1,'C');
    }

    // ===== Vista 3: Top productos del vendedor =====
    $pdf->AddPage();
    
     // Encabezado visual
    $bMargin = $pdf->getBreakMargin();
    $auto_page_break = $pdf->getAutoPageBreak();
    $pdf->SetAutoPageBreak(false, 0);
    $img_file = 'assets/img/images/formatos/encabezado.png';
    if (file_exists($img_file)) { $pdf->Image($img_file, 0, 0, 210, 23, '', '', '', false, 300, '', false, false, 0); }
    $pdf->SetAutoPageBreak($auto_page_break, $bMargin);
    $pdf->setPageMark();
    $pdf->SetFont('helvetica', '', 11);
    $pdf->Cell(0, 20, 'Top productos vendidos', 0, 1, 'C');
    $pdf->SetFont('helvetica', '', 9);
    $thead2 = '<table border="1" cellpadding="4" cellspacing="0">
      <thead>
        <tr style="background-color:#f2f2f2;">
          <th width="60" align="center">ID</th>
          <th width="60" align="center">SKU</th>
          <th width="230" align="left">Producto</th>
          <th width="80" align="center">Cantidad</th>
          <th width="80" align="right">Total</th>
        </tr>
      </thead>';
    $tbody2 = '';
    $i=0; $maxBar = 0.0; $vals = [];
    foreach ($rowsTop as $r) {
        $i++;
        $cant = (float)($r->CantidadVendida ?? 0);
        $tot  = (float)($r->TotalVendido ?? 0);
        $vals[] = $tot; if ($tot > $maxBar) $maxBar = $tot;

        $tbody2 .= '<tr>
          <td align="center" width="60">'.htmlspecialchars((string)$r->IdOrden).'</td>
          <td align="center" width="60">'.htmlspecialchars((string)($r->proSku ?? 'NA')).'</td>
          <td align="left" width="230">'.htmlspecialchars((string)($r->proTitulo ?? 'S/T')).'</td>
          <td align="center" width="80">'.number_format($cant, 0, '.', ',').'</td>
          <td align="right" width="80">$'.number_format($tot, 2, '.', ',').'</td>
        </tr>';
    }
    if ($i === 0) {
        $tbody2 .= '<tr><td colspan="5" align="center">Sin ventas registradas.</td></tr>';
    }
    $pdf->writeHTML($thead2.$tbody2.'</table>', true, false, true, false, '');
    // === Mini-gráfica horizontal: Top productos (por TotalVendido) ===
$pdf->Ln(2);
$pdf->SetFont('helvetica', '', 10);
$pdf->Cell(0, 7, 'Mini-gráfica horizontal — Top productos (por total vendido)', 0, 1, 'C');
$pdf->Ln(1);

$items = [];
$maxBar = 0.0;
foreach ($rowsTop as $r) {
    $label = (string)($r->proTitulo ?? 'S/T');
    $tot   = (float)($r->TotalVendido ?? 0);
    $sku   = (string)($r->proSku ?? '');
    $items[] = ['label'=>$label, 'sku'=>$sku, 'total'=>$tot];
    if ($tot > $maxBar) $maxBar = $tot;
}
// Limitar a top 15 para que quepa cómodo
$items = array_slice($items, 0, 15);

if (!empty($items) && $maxBar > 0) {
    // Layout
    $left   = 16;   // margen izquierdo
    $right  = 12;   // margen derecho
    $xLabel = $left; 
    $wLabel = 88;   // ancho para el nombre
    $xBar   = $xLabel + $wLabel + 2;
    $wBar   = 210 - $xBar - $right; // ancho de la barra
    $hBar   = 6;    // alto por renglón
    $gap    = 3;    // separación entre renglones

    // Encabezados pequeños
    $pdf->SetFont('helvetica','B',8);
    $pdf->Text($xLabel, $pdf->GetY(), 'Producto');
    $pdf->Text($xBar,   $pdf->GetY(), 'Venta');
    $pdf->Text($xBar + $wBar - 24, $pdf->GetY(), 'Total');
    $pdf->Ln($hBar);

    $pdf->SetFont('helvetica','',8);
    foreach ($items as $i => $it) {
        // Salto de página si no cabe el renglón
        if (($pdf->GetY() + $hBar + $gap) > 270) {
            $pdf->AddPage();
            $pdf->SetFont('helvetica','B',8);
            $pdf->Text($xLabel, 30, 'Producto');
            $pdf->Text($xBar,   30, 'Venta');
            $pdf->Text($xBar + $wBar - 24, 30, 'Total');
            $pdf->SetY(30 + $hBar);
            $pdf->SetFont('helvetica','',8);
        }

        $y = $pdf->GetY();

        // Etiqueta: "TÍTULO (SKU)"
        $lbl = trim($it['label']);
        if ($it['sku'] !== '') $lbl .= ' ('.$it['sku'].')';
        // Truncado simple si es muy largo
        if (mb_strlen($lbl) > 60) $lbl = mb_substr($lbl, 0, 57).'...';

        // Valor → ancho de barra
        $rel = $it['total'] / $maxBar;
        if ($rel < 0) $rel = 0; if ($rel > 1) $rel = 1;
        $wb = max(1.5, $wBar * $rel);

        // Dibujar etiqueta
        $pdf->Text($xLabel, $y + 1.2, $lbl);

        // Barra
        $pdf->SetFillColor(60,130,220);
        $pdf->Rect($xBar, $y, $wb, $hBar, 'DF');

        // Texto de total (derecha)
        $txtTot = '$'.number_format($it['total'], 2, '.', ',');
        // Si la barra es ancha, mostrar total en blanco dentro; si es corta, fuera a la derecha
        if ($wb > 28) {
            $pdf->SetTextColor(255,255,255);
            $pdf->Text($xBar + 2, $y + 1.2, $txtTot);
            $pdf->SetTextColor(0,0,0);
        } else {
            $pdf->Text($xBar + $wBar - 24, $y + 1.2, $txtTot);
        }

        $pdf->Ln($hBar + $gap);
    }

    // Nota inferior
    $pdf->SetFont('helvetica','I',7);
    $pdf->Ln(1);
    $pdf->Cell(0, 5, 'Escala relativa al producto con mayor venta del listado.', 0, 1, 'R');
    } else {
        $pdf->Cell(0, 8, 'No hay datos suficientes para la mini-gráfica.', 0, 1, 'C');
    }

    $pdf->Output('ventas_por_vendedor.pdf', 'I');
}


// Termino ventas por vendedor
// Inicio pipcReportes

public function pipcReportes() {

    if ($_SERVER["REQUEST_METHOD"] !== "POST") { Redirect::to('./reportes'); return; }

    // ===== Helpers =====
    $is_checked = function($name) {
        if (!isset($_POST[$name])) return false;
        $v = strtolower(trim((string)$_POST[$name]));
        return in_array($v, ['1','on','true','si','sí'], true);
    };
    $valid_date = function($d) {
        if (!$d) return false;
        if ($d === '0000-00-00') return false;
        return (bool)strtotime($d);
    };
    $days_between = function($d1, $d2) {
        if (!$d1 || !$d2) return null;
        $t1 = strtotime($d1);
        $t2 = strtotime($d2);
        if ($t1 === false || $t2 === false) return null;
        return (int)floor(($t2 - $t1) / 86400);
    };

    // ===== Entradas =====
    $fechaini = isset($_POST["fechaini"]) && $_POST["fechaini"] !== "" ? $_POST["fechaini"] :
                (isset($_POST["fecha_inicial"]) ? $_POST["fecha_inicial"] : "");
    $fechafin = isset($_POST["fechafin"]) && $_POST["fechafin"] !== "" ? $_POST["fechafin"] :
                (isset($_POST["fecha_final"]) ? $_POST["fecha_final"] : "");

    if ($fechaini === "") $fechaini = date('Y-m-d');
    if ($fechafin === "") $fechafin = date('Y-m-d');

    // Flags
    $flagOrigen              = $is_checked('pipc_origen') || $is_checked('origen_tiempos') || $is_checked('desde_origen');
    $flagCaducar             = $is_checked('pipc_caducar');
    $flagActivas             = $is_checked('pipc_activas');
    $flagNoPagadas           = $is_checked('pipc_no_pagadas');
    $flagPagadasSinRevisar   = $is_checked('pipc_pagadas_sin_revisar');
    $flagTodas               = $is_checked('pipc_todas');

    // ===== WHERE =====
    $where = [];
    $where[] = "o.TipoOrden = 6"; // PIPC

    if (!$flagOrigen) {
        $where[] = "DATE(o.Fecha) BETWEEN '".addslashes($fechaini)."' AND '".addslashes($fechafin)."'";
    }
    if (!$flagTodas) {
        if ($flagCaducar && !$flagActivas) {
            $where[] = "DATEDIFF(o.FechaTerminoPipc, CURDATE()) < 7";
        } else if ($flagActivas && !$flagCaducar) {
            $where[] = "DATEDIFF(o.FechaTerminoPipc, CURDATE()) >= 7";
        }
        if ($flagNoPagadas) {
            $where[] = "(o.PagadoCompleto NOT IN (11,12))";
        }
        if ($flagPagadasSinRevisar) {
            $where[] = "(o.PagadoCompleto IN (11,12) AND (o.FechaTerminoPipc IS NULL OR o.FechaTerminoPipc='' OR o.FechaTerminoPipc='0000-00-00'))";
        }
    }

    // ===== SQL =====
    $sql = "
        SELECT
            o.IdOrden, o.FolioOrden, o.Fecha, o.IdUsuario,
            o.PagadoCompleto,
            o.FechaInicioPipc, o.FechaTerminoPipc,
            c.IdCliente, c.Nombre AS Cliente, c.FisTelefono, c.FisEmail,
            SUM(od.Neto) AS TotalNeto
        FROM ordenes o
        INNER JOIN ordenesdetalle od ON od.IdOrden = o.IdOrden
        LEFT  JOIN clientes c        ON c.IdCliente = o.IdCliente
        WHERE ".implode(" AND ", $where)."
        GROUP BY o.IdOrden
        ORDER BY o.Fecha ASC
    ";

    $orden = new ordenesModel();
    $orden->sentencia = $sql;
    $result = $orden->pipcReportes();

    // ===== Procesar =====
    $rows = to_object($result);

    $caducarCount = 0;
    $activasCount = 0;
    $pagadasCount = 0;
    $noPagadasCount = 0;

    $sumWaitToStart = 0; $cntWaitToStart = 0;   // Fecha -> Inicio
    $sumExec        = 0; $cntExec        = 0;   // Inicio -> Término
    $sumTotal       = 0; $cntTotal       = 0;   // Fecha -> Término

    $thead = '<table border="1" cellpadding="3" cellspacing="0">
        <thead>
            <tr style="background-color:#f2f2f2;">
                <th width="30"  align="center">#</th>
                <th width="40"  align="center">ID</th>
                <th width="47"  align="center">Fecha</th>
                <th width="100"  align="left">Cliente</th>
                <th width="55"  align="left">Teléfono</th>
                <th width="70"  align="left">Email</th>
                <th width="47"  align="center">Inicio</th>
                <th width="47"  align="center">Término</th>
                <th width="20"  align="right">-D</th>
                <th width="70"  align="center">Pago</th>
            </tr>
        </thead>';
    $tbody = '';
    $i=0;

    foreach ($rows as $r) {
        $i++;
        $fechaD   = substr((string)$r->Fecha, 0, 10);
        $iniPipc  = ($r->FechaInicioPipc ?? null);
        $finPipc  = ($r->FechaTerminoPipc ?? null);

        // Caducar vs Activas (como en WHERE)
        if ($valid_date($finPipc)) {
            // DATEDIFF(fin, CURDATE())
            $dd = $days_between(date('Y-m-d'), $finPipc); // hoy->fin
            if ($dd < 7) $caducarCount++; else $activasCount++;
        } else {
            $activasCount++;
        }

        // Pagadas
        $pagada = in_array((int)($r->PagadoCompleto ?? 0), [11,12], true);
        if ($pagada) $pagadasCount++; else $noPagadasCount++;

        // Rendimiento
        if ($valid_date($iniPipc)) {
            $w = $days_between($fechaD, $iniPipc);
            if ($w !== null) { $sumWaitToStart += $w; $cntWaitToStart++; }
        }
        if ($valid_date($iniPipc) && $valid_date($finPipc)) {
            $e = $days_between($iniPipc, $finPipc);
            if ($e !== null) { $sumExec += $e; $cntExec++; }
        }
        if ($valid_date($finPipc)) {
            $t = $days_between($fechaD, $finPipc);
            if ($t !== null) { $sumTotal += $t; $cntTotal++; }
        }

        $tbody .= '<tr>
            <td width="30" align="center">'.$i.'</td>
            <td width="40" align="center">'.htmlspecialchars((string)$r->IdOrden).'</td>
            <td width="47" align="center">'.htmlspecialchars($fechaD).'</td>
            <td width="100" align="left">'.htmlspecialchars((string)($r->Cliente ?? 'S/D')).'</td>
            <td width="55" align="left">'.htmlspecialchars((string)($r->FisTelefono ?? '')).'</td>
            <td width="70" align="left">'.htmlspecialchars((string)($r->FisEmail ?? '')).'</td>
            <td width="47" align="center">'.htmlspecialchars($valid_date($iniPipc) ? $iniPipc : '—').'</td>
            <td width="47" align="center">'.htmlspecialchars($valid_date($finPipc) ? $finPipc : '—').'</td>
            <td width="20" align="right">'.($valid_date($finPipc) ? ((int)$days_between(date('Y-m-d'), $finPipc)) : '—').'</td>
            <td width="70" align="center">'.($pagada ? 'Pagada' : 'No pagada').'</td>
        </tr>';
    }
    if ($tbody === '') {
        $tbody = '<tr><td colspan="11" align="center">Sin registros para los filtros seleccionados.</td></tr>';
    }

    // ===== PDF =====
    $pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
    $pdf->SetTitle('PIPC - Reporte');
    $pdf->setPrintHeader(false);
    $pdf->SetMargins(13, 17, 5, true);
    $pdf->setPrintFooter(true);
    $pdf->AddPage();
    $pdf->SetFont('helvetica', '', 11);

    // Encabezado visual
    $bMargin = $pdf->getBreakMargin();
    $auto_page_break = $pdf->getAutoPageBreak();
    $pdf->SetAutoPageBreak(false, 0);
    $img_file = 'assets/img/images/formatos/encabezado.png';
    if (file_exists($img_file)) {
        $pdf->Image($img_file, 0, 0, 210, 23, '', '', '', false, 300, '', false, false, 0);
    }
    $pdf->SetAutoPageBreak($auto_page_break, $bMargin);
    $pdf->setPageMark();

    $titulo = '<div style="text-align:center;"><h2>REPORTE PIPC</h2></div>';
    $sub = '<div style="text-align:center;margin-bottom:8px;"><strong>'
        . ($flagOrigen ? 'Desde el origen de los tiempos' : ('Rango: '.htmlspecialchars($fechaini).' al '.htmlspecialchars($fechafin)))
        .'</strong></div>';
    $pdf->writeHTML($titulo.$sub, true, false, true, false, '');

    // Resumen
    $pdf->SetFont('helvetica','',9);
    $resumen = '
        <table cellpadding="4" cellspacing="0" border="0" style="margin-bottom:6px;">
            <tr>
                <td width="33%"><strong>Órdenes activas:</strong> '.$activasCount.'</td>
                <td width="33%"><strong>Por caducar/caducadas (&lt;7d):</strong> '.$caducarCount.'</td>
                <td width="34%"><strong>Pagadas / No pagadas:</strong> '.$pagadasCount.' / '.$noPagadasCount.'</td>
            </tr>
        </table>';
    $pdf->writeHTML($resumen, true, false, true, false, '');

    // Tabla
    $pdf->SetFont('helvetica','',8);
    $pdf->writeHTML($thead.$tbody.'</table>', true, false, true, false, '');

    // ===== Gráfica de rendimiento (nueva página) =====
    $avgWait  = $cntWaitToStart > 0 ? $sumWaitToStart / $cntWaitToStart : 0;
    $avgExec  = $cntExec        > 0 ? $sumExec        / $cntExec        : 0;
    $avgTotal = $cntTotal       > 0 ? $sumTotal       / $cntTotal       : 0;

    $pdf->AddPage();
    $pdf->SetAutoPageBreak(false, 0);
    if (file_exists($img_file)) { $pdf->Image($img_file, 0, 0, 210, 23, '', '', '', false, 300, '', false, false, 0); }
    $pdf->SetAutoPageBreak($auto_page_break, $bMargin);
    $pdf->setPageMark();

    $pdf->SetFont('helvetica','',11);
    $pdf->Cell(0, 20, 'Rendimiento promedio (días): Espera para iniciar / Ejecución / Total a cierre', 0, 1, 'C');

    $metrics = [
        ['label' => 'Espera',    'value' => $avgWait,  'color' => [60,130,220]],
        ['label' => 'Ejecución', 'value' => $avgExec,  'color' => [90,170,90]],
        ['label' => 'Total',     'value' => $avgTotal, 'color' => [220,140,60]],
    ];
    $mLeft=25; $mRight=15; $mTop=40;
    $W=210-$mLeft-$mRight; $H=80;
    $x0=$mLeft; $y0=$mTop+$H; $yTop=$mTop;

    $pdf->SetDrawColor(0,0,0);
    $pdf->Line($x0, $y0, $x0+$W, $y0);
    $pdf->Line($x0, $y0, $x0, $yTop);

    $vals = array_map(function($m){ return max(0,(float)$m['value']); }, $metrics);
    $maxV = max($vals); if ($maxV <= 0) $maxV = 1;
    $n = count($metrics);
    $gap = 12.0;
    $bw = min(40.0, max(16.0, ($W - ($n+1)*$gap)/$n));
    $x  = $x0 + $gap;

    $pdf->SetFont('helvetica','',9);
    foreach ($metrics as $m) {
        [$r,$g,$b] = $m['color'];
        $v = max(0,(float)$m['value']);
        $h = ($v/$maxV) * ($H - 14);
        $pdf->SetFillColor($r,$g,$b);
        $pdf->Rect($x, $y0-$h, $bw, $h, 'DF');
        $txt = number_format($v,2,'.',',').' d';
        if ($h > 10) { $pdf->SetTextColor(255,255,255); $pdf->Text($x+2, $y0-$h+2, $txt); $pdf->SetTextColor(0,0,0); }
        else { $pdf->Text($x, $y0-$h-5, $txt); }
        $pdf->Text($x+($bw/2)-8, $y0+4, $m['label']);
        $x += ($bw + $gap);
    }

    // ===== Gráfico de pastel (nueva página) =====
    $pdf->AddPage();
    $pdf->SetAutoPageBreak(false, 0);
    if (file_exists($img_file)) { $pdf->Image($img_file, 0, 0, 210, 23, '', '', '', false, 300, '', false, false, 0); }
    $pdf->SetAutoPageBreak($auto_page_break, $bMargin);
    $pdf->setPageMark();

    $pdf->SetFont('helvetica','',11);
    $pdf->Cell(0, 20, 'Distribución de órdenes: Activas vs Por caducar/caducadas', 0, 1, 'C');

    $totA = (int)$activasCount;
    $totC = (int)$caducarCount;
    $tot  = max(1, $totA + $totC);
    $pctA = ($totA / $tot) * 100.0;
    $pctC = 100.0 - $pctA;

    $cx = 105; $cy = 95; $r = 42;
    $degA = ($totA / $tot) * 360.0;
    $degC = 360.0 - $degA;

    // Intenta con PieSector / Sector; si no existen, usa fallback de barras
    if (method_exists($pdf, 'PieSector') || method_exists($pdf, 'Sector')) {
        $start = 0.0;
        // Activas (verde)
        $pdf->SetFillColor(90,170,90);
        if (method_exists($pdf, 'PieSector')) {
            $pdf->PieSector($cx, $cy, $r, $start, $start + $degA, 'FD', false, 0);
        } else {
            $pdf->Sector($cx, $cy, $r, $start, $start + $degA, 'FD', false, 0);
        }
        $start += $degA;
        // Caducar (naranja)
        $pdf->SetFillColor(220,140,60);
        if (method_exists($pdf, 'PieSector')) {
            $pdf->PieSector($cx, $cy, $r, $start, $start + $degC, 'FD', false, 0);
        } else {
            $pdf->Sector($cx, $cy, $r, $start, $start + $degC, 'FD', false, 0);
        }

        // Leyenda
        $lx = 30; $ly = 150;
        $pdf->SetFont('helvetica','',9);
        $pdf->SetFillColor(90,170,90);  $pdf->Rect($lx,   $ly, 6, 6, 'F');
        $pdf->SetFillColor(220,140,60); $pdf->Rect($lx, $ly+8, 6, 6, 'F');
        $pdf->Text($lx+9,  $ly+1, 'Activas: '.$totA.' ('.number_format($pctA,1).'%)');
        $pdf->Text($lx+9,  $ly+9, 'Por caducar/caducadas: '.$totC.' ('.number_format($pctC,1).'%)');

    } else {
        // Fallback: barras proporcionales
        $pdf->SetFont('helvetica','',10);
        $pdf->Cell(0, 6, 'Vista alternativa (barras) por compatibilidad TCPDF', 0, 1, 'C');
        $mL=25; $mR=15; $y=95; $W=210-$mL-$mR; $H=10;

        $wA = ($totA / $tot) * $W;
        $wC = $W - $wA;

        $pdf->SetFillColor(90,170,90);  $pdf->Rect($mL,     $y, $wA, $H, 'F');
        $pdf->SetFillColor(220,140,60); $pdf->Rect($mL+$wA, $y, $wC, $H, 'F');

        $pdf->SetFont('helvetica','',9);
        $pdf->Text($mL, $y+H+6, 'Activas: '.$totA.' ('.number_format($pctA,1).'%)');
        $pdf->Text($mL, $y+H+12, 'Por caducar/caducadas: '.$totC.' ('.number_format($pctC,1).'%)');
    }

    $pdf->Output('pipc_reporte.pdf','I');
}
// Termino pipc reporte
// Inicio Reporte Capacitaciones
function pdfDesgloceCapacitaciones() { 
    ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);

    if ($_SERVER["REQUEST_METHOD"] !== "POST") { Redirect::to('./reportes'); return; }

    // ===== Helpers =====
    $post = fn($k,$d=null)=>($_POST[$k]??$d);
    $nonEmpty = fn($v)=>isset($v)&&$v!==''&&$v!==null;

    $to_rows = function($result){
        $rows = to_object($result);
        if ($rows === false || $rows === null) return [];
        if ($rows instanceof stdClass) return [$rows];
        return is_array($rows) ? $rows : [];
    };
    $parse_json_or_csv_ints = function($raw){
        $out = [];
        if (!isset($raw) || $raw === '') return [];
        $s = trim((string)$raw);
        $j = json_decode($s, true);
        if (json_last_error() === JSON_ERROR_NONE && is_array($j)) {
            foreach ($j as $entry) {
                foreach (preg_split('/\s*,\s*/', (string)$entry, -1, PREG_SPLIT_NO_EMPTY) as $x) {
                    $n=(int)$x; if($n>0) $out[$n]=true;
                }
            }
            return array_keys($out);
        }
        $s = trim($s, " \t\n\r\0\x0B[]\""); // limpia brackets y comillas
        foreach (preg_split('/\s*,\s*/', $s, -1, PREG_SPLIT_NO_EMPTY) as $x) {
            $n=(int)$x; if($n>0) $out[$n]=true;
        }
        return array_keys($out);
    };
    $fmtDT = function($d,$t){
        $dd = $d ? date('Y-m-d', strtotime((string)$d)) : '';
        $tt = $t ? date('H:i',   strtotime((string)$t)) : '';
        return trim($dd.' '.$tt);
    };
    $isPagadoById = function($id){
        static $OK = [1,3,11,12,29];  // Crédito, Pago parcial, Pagada c/factura, s/factura, Contra Entrega
        return $id!==null && in_array((int)$id, $OK, true);
    };
    $mapEvntEstatus = function($st){
        $m = [0=>'Eliminado',1=>'Nuevo',2=>'Terminado',3=>'Pospuesto'];
        return $m[(int)$st] ?? '—';
    };

    // ===== Fechas =====
    $fechaini = $post("fechaini") ?: $post("fecha_inicial") ?: date('Y-m-d');
    $fechafin = $post("fechafin") ?: $post("fecha_final")   ?: date('Y-m-d');

    // ===== Filtros CAP del front =====
    $porCliente      = $post('cap_por_cliente') === '1';
    $clienteQ        = trim((string)$post('cap_cliente_query',''));
    $fRealizados     = $post('cap_realizados') === '1';
    $fPendientes     = $post('cap_pendientes') === '1';
    $fSinRevisar     = $post('cap_sin_revisar') === '1';
    $fPospuestos     = $post('cap_pospuestos') === '1';
    $fSoloPagados    = $post('cap_pagados') === '1';
    $instructorId    = $nonEmpty($post('cap_instructor_id')) ? (int)$post('cap_instructor_id') : null;
    $byAgenda        = $post('cap_fecha_agenda') === '1';  // checkbox del front

    // ===== WHERE base =====
    $where = [];
    $where[] = "o.TipoOrden = 3";

    // Fecha (normal vs agenda)
    if ($byAgenda) {
        // fechaCapacitacionOrd (ordenesdetalle) o evntFechaInicio (calendario)
        $where[] = "("
                 . " (od.fechaCapacitacionOrd IS NOT NULL AND od.fechaCapacitacionOrd <> '0000-00-00'"
                 . "    AND DATE(od.fechaCapacitacionOrd) BETWEEN '".$fechaini."' AND '".$fechafin."')"
                 . " OR "
                 . " (cal.evntFechaInicio IS NOT NULL"
                 . "    AND DATE(cal.evntFechaInicio) BETWEEN '".$fechaini."' AND '".$fechafin."')"
                 . ")";
    } else {
        $where[] = "DATE(o.Fecha) BETWEEN '".$fechaini."' AND '".$fechafin."'";
    }

    if ($porCliente && $clienteQ !== '') {
        if (ctype_digit($clienteQ)) {
            $where[] = "o.IdCliente = ".intval($clienteQ);
        } else {
            $clienteQ_esc = addslashes($clienteQ);
            $where[] = "c.Nombre LIKE '%".$clienteQ_esc."%'";
        }
    }
    if ($fSoloPagados) {
        $where[] = "o.PagadoCompleto IN (1,3,11,12,29)";
    }

    // ===== Consulta (JOINs correctos) =====
    // Nota: JOIN con calendario por Partida usando FIND_IN_SET sobre PartidaO2 sin [ ] ni espacios.
    $mdl = new ordenesModel();
    $mdl->sentencia = "
        SELECT
            -- Orden
            o.IdOrden, o.Fecha, o.IdCliente, o.IdUsuario,
            o.PagadoCompleto, o.Estatus AS EstatusOrdenId,
            c.Nombre AS ClienteNombre,
            u.Usuario AS VendedorNombre,
            ep.Descripcion AS PagoDescripcion,
            eo.Descripcion AS EstatusOrden,

            -- Detalle (INNER)
            od.Partida, od.IdProducto, od.Cantidad, od.DescripcionNueva,
            od.agendaCap, od.fechaCapacitacionOrd,

            -- Producto (INNER)
            p.proSku, p.proTitulo, p.proDescripcion, p.proCatId,

            -- Calendario (LEFT por Partida)
            cal.evntFechaInicio, cal.evntHoraInicio,
            cal.evntFechaFin,   cal.evntHoraFin,
            cal.evtNParticipantes, cal.evtObservaciones,
            cal.evntEstatus,
            cal.alimentoscal, cal.transportecal,
            cal.envtInstructores AS InstructoresRaw,
            cal.DC3Cliente

        FROM ordenes o
        INNER JOIN ordenesdetalle od ON od.IdOrden = o.IdOrden
        INNER JOIN productos      p  ON p.proId    = od.IdProducto
        INNER JOIN clientes       c  ON c.IdCliente= o.IdCliente
        LEFT  JOIN usuarios       u  ON u.IdUsuario= o.IdUsuario
        LEFT  JOIN estatus        ep ON ep.IdEstatus = o.PagadoCompleto
        LEFT  JOIN estatus        eo ON eo.IdEstatus = o.Estatus
        LEFT  JOIN calendario     cal
               ON cal.IdOrden = o.IdOrden
              AND FIND_IN_SET(
                    od.Partida,
                    REPLACE(REPLACE(REPLACE(REPLACE(cal.PartidaO2,'[',''),']',''), '\"',''), ' ', '')
                  ) > 0

        WHERE ".implode(" AND ", $where)."
        ORDER BY 
            ".($byAgenda
                ? "COALESCE(cal.evntFechaInicio, od.fechaCapacitacionOrd, o.Fecha) ASC,"
                : "o.IdOrden DESC,"
            )."
            CAST(od.Partida AS UNSIGNED) ASC,
            cal.evntFechaInicio ASC, cal.evntHoraInicio ASC
    ";
    $rows = $to_rows($mdl->desgloseCapacitaciones());

    if (empty($rows)) {
        $PDFClass = class_exists('MYPDF') ? 'MYPDF' : 'TCPDF';
        $pdf = new $PDFClass(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
        $pdf->SetTitle('Desglose de Capacitaciones');
        $pdf->setPrintHeader(false); $pdf->setPrintFooter(true);
        $pdf->SetMargins(13, 17, 5, true);
        $pdf->AddPage('P');
        $pdf->SetFont('helvetica','',12);
        $pdf->writeHTML('<h3>Desglose de Capacitaciones</h3><p>Sin datos para el rango seleccionado.</p>', true, false, true, false, '');
        $pdf->Output('desglose_capacitaciones.pdf','I');
        return;
    }

    // ===== Post-proceso → estructura por Orden → Partida =====
    $orders = [];                  // oid => info
    $byInstructorIds = [];         // recolectar instructores
    foreach ($rows as $r) {
        $oid = (int)$r->IdOrden;
        if (!isset($orders[$oid])) {
            $orders[$oid] = [
                'info' => [
                    'IdOrden'        => $oid,
                    'Fecha'          => $r->Fecha,
                    'ClienteNombre'  => $r->ClienteNombre ?? '',
                    'VendedorNombre' => $r->VendedorNombre ?? '',
                    'EstatusOrden'   => $r->EstatusOrden ?? '—',
                    'PagadoCompleto' => $r->PagadoCompleto,
                    'PagoDescripcion'=> $r->PagoDescripcion ?? ''
                ],
                'detalles' => [] // partida => detail + eventos[]
            ];
        }
        $part = (int)$r->Partida;
        if (!isset($orders[$oid]['detalles'][$part])) {
            $desc = trim((string)($r->DescripcionNueva ?? ''));
            if ($desc === '') $desc = (string)($r->proTitulo ?? '');
            if ($desc === '') $desc = 'Producto #'.(string)($r->IdProducto ?? '');

            $orders[$oid]['detalles'][$part] = [
                'Partida'   => $part,
                'Producto'  => [
                    'IdProducto' => $r->IdProducto,
                    'Sku'        => $r->proSku,
                    'Titulo'     => $r->proTitulo,
                    'Descripcion'=> $r->proDescripcion
                ],
                'Cantidad'  => $r->Cantidad ?? 1,
                'agendaCap' => (int)($r->agendaCap ?? 0),
                'fechaCap'  => $r->fechaCapacitacionOrd,
                'DescShow'  => $desc,
                'eventos'   => [] // lista
            ];
        }

        // Si hay fila de calendario (LEFT JOIN), agregamos evento
        if (!empty($r->evntFechaInicio) || !empty($r->evntFechaFin) || $r->evntEstatus !== null) {
            $horaIni = ($r->evntHoraInicio ?? null);
            if (empty($horaIni) && !empty($r->evntHoraFin)) $horaIni = $r->evntHoraFin;

            $orders[$oid]['detalles'][$part]['eventos'][] = [
                'ini'  => $fmtDT($r->evntFechaInicio ?? null, $horaIni),
                'fin'  => $fmtDT($r->evntFechaFin   ?? null, $r->evntHoraFin   ?? null),
                'est'  => $mapEvntEstatus((int)($r->evntEstatus ?? -1)),
                'pars' => [
                    'DC3'     => (string)($r->DC3Cliente ?? '') === '1' ? 'Sí':'No',
                    'N'       => (int)($r->evtNParticipantes ?? 0),
                    'Alim'    => ((int)($r->alimentoscal ?? 0)===1 ? 'Sí':'No'),
                    'Transp'  => ((int)($r->transportecal ?? 0)===1 ? 'Sí':'No'),
                    'Obs'     => (string)($r->evtObservaciones ?? '')
                ],
                'inst_raw' => (string)($r->InstructoresRaw ?? '[]')
            ];
            foreach ($parse_json_or_csv_ints($r->InstructoresRaw ?? '') as $iid) {
                $byInstructorIds[$iid] = true;
            }
        }
    }

    // ===== Filtro por instructor / estatus evento (en memoria) =====
    $filterByStatus = [];
    if ($fRealizados) $filterByStatus[2]='Terminado';
    if ($fPendientes) $filterByStatus[1]='Nuevo';
    if ($fPospuestos) $filterByStatus[3]='Pospuesto';
    if ($fSinRevisar) $filterByStatus[0]='Eliminado'; // interpretamos como 0 (o sin evento → más abajo)

    if ($instructorId || !empty($filterByStatus)) {
        foreach ($orders as $oid => &$O) {
            foreach ($O['detalles'] as $p => &$D) {
                $keep = false;
                if (!empty($D['eventos'])) {
                    foreach ($D['eventos'] as $ev) {
                        $okInst = !$instructorId;
                        $okStat = empty($filterByStatus);
                        if ($instructorId) {
                            $ids = $parse_json_or_csv_ints($ev['inst_raw']);
                            if (in_array($instructorId, $ids, true)) $okInst = true;
                        }
                        if (!empty($filterByStatus)) {
                            $okStat = in_array($ev['est'], array_values($filterByStatus), true);
                        }
                        if ($okInst && $okStat) { $keep = true; break; }
                    }
                } else {
                    if (isset($filterByStatus[0])) $keep = true; // sin eventos
                }
                if (!$keep) unset($O['detalles'][$p]);
            }
            if (empty($O['detalles'])) unset($orders[$oid]);
        }
        unset($O,$D);
    }

    if (empty($orders)) {
        $PDFClass = class_exists('MYPDF') ? 'MYPDF' : 'TCPDF';
        $pdf = new $PDFClass(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
        $pdf->SetTitle('Desglose de Capacitaciones');
        $pdf->setPrintHeader(false); $pdf->setPrintFooter(true);
        $pdf->SetMargins(13, 17, 5, true);
        $pdf->AddPage('P');
        $pdf->SetFont('helvetica','',12);
        $pdf->writeHTML('<h3>Desglose de Capacitaciones</h3><p>No hay órdenes que cumplan los filtros.</p>', true, false, true, false, '');
        $pdf->Output('desglose_capacitaciones.pdf','I');
        return;
    }

    // ===== Resolver nombres de instructores =====
    $instNames = [];
    $iidList = array_keys($byInstructorIds);
    if (!empty($iidList)) {
        $mdl->sentencia = "SELECT IdUsuario, Usuario FROM usuarios WHERE IdUsuario IN (".implode(',', array_map('intval',$iidList)).")";
        $uu = $to_rows($mdl->desgloseCapacitaciones());
        foreach ($uu as $u) $instNames[(int)$u->IdUsuario] = $u->Usuario;
    }
    $instNameList = function($raw) use ($parse_json_or_csv_ints,$instNames){
        $ids = $parse_json_or_csv_ints($raw);
        if (!$ids) return '—';
        $n=[]; foreach ($ids as $id) $n[] = $instNames[$id] ?? ("#".$id);
        return implode(', ',$n);
    };

    // ===== KPIs =====
    $k_ordenes = count($orders);
    $k_partidas = 0; $k_eventos = 0;
    $byPago = ['Pagadas'=>0,'No pagadas'=>0];
    $byEstatusEv = []; $byInstructor = [];

    foreach ($orders as $O) {
        $isPaid = $isPagadoById($O['info']['PagadoCompleto'] ?? null);
        if ($isPaid){ $byPago['Pagadas']++; } else { $byPago['No pagadas']++; }

        foreach ($O['detalles'] as $D) {
            $k_partidas++;
            if (!empty($D['eventos'])) {
                foreach ($D['eventos'] as $ev) {
                    $k_eventos++;
                    $byEstatusEv[$ev['est']] = ($byEstatusEv[$ev['est']] ?? 0) + 1;
                    foreach ($parse_json_or_csv_ints($ev['inst_raw']) as $iid) {
                        $name = $instNames[$iid] ?? ("#".$iid);
                        $byInstructor[$name] = ($byInstructor[$name] ?? 0) + 1;
                    }
                }
            } else {
                $byEstatusEv['Sin evento'] = ($byEstatusEv['Sin evento'] ?? 0) + 1;
            }
        }
    }

    // ===== PDF =====
    $PDFClass = class_exists('MYPDF') ? 'MYPDF' : 'TCPDF';
    $pdf = new $PDFClass(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
    $pdf->SetTitle('Desglose de Capacitaciones');
    $pdf->setPrintHeader(false); $pdf->setPrintFooter(true);
    $pdf->SetMargins(13, 17, 5, true);

    // ---------- Encabezado robusto (se usa en TODAS las páginas) ----------
    // ---------- Encabezado robusto (usar en TODAS las páginas) ----------
$resolveHeaderPath = function() {
    $rel = 'assets/img/images/formatos/encabezado.png';
    $candidates = [
        $rel,
        __DIR__ . '/' . $rel,
        dirname(__FILE__) . '/' . $rel,
        dirname(__FILE__,2) . '/' . $rel,
        (isset($_SERVER['DOCUMENT_ROOT']) ? rtrim($_SERVER['DOCUMENT_ROOT'],'/').'/'.$rel : null),
        (defined('K_PATH_IMAGES') ? rtrim(K_PATH_IMAGES,'/').'/encabezado.png' : null),
    ];
    foreach ($candidates as $p) {
        if (!$p) continue;
        // realpath si existe, si no prueba tal cual
        $rp = @realpath($p);
        if ($rp && @is_file($rp)) return $rp;
        if (@is_file($p)) return $p;
    }
    return null;
};

$drawHeader = function($pdf) use ($resolveHeaderPath) {
    $img = $resolveHeaderPath();

    // Reserva espacio de header aunque no hubiera imagen
    $pageW = $pdf->getPageWidth();  // 297 en L, 210 en P
    $imgH  = 23;                    // alto de la franja reservada

    // Mientras dibujamos el header, desactivamos saltos
    $bMargin = $pdf->getBreakMargin();
    $apb     = $pdf->getAutoPageBreak();
    $pdf->SetAutoPageBreak(false, 0);

    if ($img) {
        // Carga en memoria para evitar problemas de permisos/rutas
        $data = @file_get_contents($img);
        if ($data !== false) {
            // Mantiene proporción automáticamente (alto=0) y ocupa todo el ancho
            $pdf->Image('@'.$data, 0, 0, $pageW, 0, '', '', '', false, 300, '', false, false, 0, false, false, false);
            // Intentar calcular el alto real para colocar el cursor justo debajo
            if ($info = @getimagesizefromstring($data)) {
                if (!empty($info[0])) {
                    $ratio = $info[1] / $info[0];
                    $imgH  = max($imgH, $pageW * $ratio);
                }
            }
        } else {
            // Fallback visual para verificar que el header se dibuja
            $pdf->SetFillColor(235,235,235);
            $pdf->Rect(0, 0, $pageW, $imgH, 'F');
        }
    } else {
        // Fallback si no se localiza el archivo
        $pdf->SetFillColor(235,235,235);
        $pdf->Rect(0, 0, $pageW, $imgH, 'F');
        // DEBUG opcional:
        // $pdf->SetTextColor(200,0,0);
        // $pdf->SetXY(2, 2);
        // $pdf->Write(0, 'No se encontró encabezado.png');
    }

    // Restaurar saltos y colocar cursor bajo el header
    $pdf->SetAutoPageBreak($apb, $bMargin);
    $pdf->SetY($imgH + 2);
    $pdf->setPageMark();
};
// --------------------------------------------------------------------

    // ----------------------------------------------------------------------

    // Portada/KPIs
    $pdf->AddPage('L');
    $drawHeader($pdf);

    $subs = [];
    $subs[] = 'Rango: '.htmlspecialchars($fechaini).' al '.htmlspecialchars($fechafin).($byAgenda ? ' (por agenda)':'');
    if ($porCliente && $clienteQ!=='') $subs[] = 'Cliente: '.htmlspecialchars($clienteQ);
    if ($instructorId) $subs[] = 'Instructor ID: '.(int)$instructorId;

    $pdf->SetFont('helvetica','',11);
    $pdf->writeHTML(
        '<div style="text-align:center;"><h2>DESGLOSE DE CAPACITACIONES</h2></div>'.
        '<div style="text-align:center;margin-bottom:8px;"><strong>'.implode(' | ', $subs).'</strong></div>'.
        '<table cellpadding="4" cellspacing="0" border="0" style="margin-bottom:6px;">
            <tr>
                <td width="33%"><strong>Órdenes:</strong> '.number_format($k_ordenes).'</td>
                <td width="33%"><strong>Partidas/Cursos:</strong> '.number_format($k_partidas).'</td>
                <td width="34%"><strong>Eventos agendados:</strong> '.number_format($k_eventos).'</td>
            </tr>
            <tr>
                <td width="33%"><strong>Pagadas:</strong> '.number_format($byPago['Pagadas']).'</td>
                <td width="33%"><strong>No pagadas:</strong> '.number_format($byPago['No pagadas']).'</td>
                <td width="34%"></td>
            </tr>
        </table>'
    , true, false, true, false, '');

    // ====== BLOQUE OPCIONAL DE GRÁFICOS (quitar si causa problemas) ======
    $drawBars = function($pdf,$x,$y,$w,$title,$pairs){
        $pdf->SetFont('helvetica','B',10);
        $pdf->SetXY($x,$y); $pdf->Cell($w,6,$title,0,1,'L',false,'');
        $max=1; foreach($pairs as $p){ $max=max($max,(float)$p['v']); }
        $h=5.5; $gap=1.5; $lw=$w*0.42; $bw=$w*0.58; $curY=$pdf->GetY();
        $pdf->SetFont('helvetica','',9);
        foreach($pairs as $p){
            $lbl=(string)$p['k']; $val=(float)$p['v'];
            $pdf->SetXY($x,$curY); $pdf->Cell($lw,$h,mb_strimwidth($lbl,0,40,'…','UTF-8'),0,0,'L');
            $len=($val/$max)*($bw-18); $px=$x+$lw+1; $py=$curY+1.2;
            $pdf->SetFillColor(60,141,188); $pdf->Rect($px,$py,max(0.1,$len),$h-2.4,'F');
            $pdf->SetXY($px+$len+2,$curY); $pdf->Cell(16,$h,(string)((int)$val),0,1,'L');
            $curY+=($h+$gap);
        }
        $pdf->SetY($curY+1);
    };

    $x0=15; $y0=$pdf->GetY()+2; $W=267;
    $pairsPago = [
        ['k'=>'Pagadas','v'=>$byPago['Pagadas']],
        ['k'=>'No pagadas','v'=>$byPago['No pagadas']]
    ];
    $pairsEst = []; foreach ($byEstatusEv as $k=>$v) $pairsEst[]=['k'=>$k,'v'=>$v];
    arsort($byInstructor); $pairsInst=[]; $i=0; foreach ($byInstructor as $k=>$v){ $pairsInst[]=['k'=>$k,'v'=>$v]; if(++$i>=10) break; }

    $drawBars($pdf,$x0,               $y0,$W/3-5,'Pagos',$pairsPago);
    $drawBars($pdf,$x0 + $W/3,        $y0,$W/3-5,'Estatus de evento',$pairsEst);
    $drawBars($pdf,$x0 + 2*($W/3),    $y0,$W/3-5,'Top instructores',$pairsInst);
    // ====== FIN BLOQUE OPCIONAL DE GRÁFICOS ======

    // ===== Detalle por Orden =====
    $pdf->AddPage('L');
    $drawHeader($pdf);

    $pdf->SetFont('helvetica','B',12);
    $pdf->Cell(0,8,'Detalle por Orden',0,1,'L');
    $pdf->SetFont('helvetica','',9);

    foreach ($orders as $O) {
        $info = $O['info'];
        $isPaid = $isPagadoById($info['PagadoCompleto'] ?? null);
        $pagoTxt = $info['PagoDescripcion'] ?: ($isPaid ? 'Pagado' : 'No pagado');

        $pdf->SetFillColor(230,230,230);
        $pdf->SetFont('helvetica','B',10);
        $pdf->Cell(0,7,
            "Orden #{$info['IdOrden']} — Fecha: ".date('Y-m-d',strtotime((string)$info['Fecha'])).
            " — Cliente: ".($info['ClienteNombre'] ?? '').
            " — Vendedor: ".($info['VendedorNombre'] ?? '').
            " — Estatus Orden: ".($info['EstatusOrden'] ?? '—').
            " — Pago: ".$pagoTxt,
        0,1,'L',true);

        $thead = '
        <table border="1" cellpadding="3" cellspacing="0" style="font-size:9px;">
          <thead>
            <tr style="font-weight:bold;background-color:#f2f2f2;">
              <th width="6%">Par</th>
              <th width="20%">SKU</th>
              <th width="28%">Curso / Producto</th>
              <th width="6%">Cant</th>
              <th width="12%">Agendado</th>
              <th width="12%">Inicio</th>
              <th width="12%">Fin</th>
              <th width="12%">Instructores</th>
            </tr>
          </thead><tbody>';
        $body = '';
        $rows = 0;

        foreach ($O['detalles'] as $D) {
            $sku = $D['Producto']['Sku'] ?? '';
            $desc= $D['DescShow'] ?: ($D['Producto']['Titulo'] ?? '');
            $cant= $D['Cantidad'] ?? 1;

            if (empty($D['eventos'])) {
                $ag = ((int)$D['agendaCap']===1)
                      ? ('Agendado'.($D['fechaCap']?' ('.$D['fechaCap'].')':''))
                      : 'No';
                $rows++;
                $body .= sprintf(
                    '<tr>
                        <td>%d</td>
                        <td>%s</td>
                        <td>%s</td>
                        <td align="right">%s</td>
                        <td>%s</td>
                        <td>%s</td>
                        <td>%s</td>
                        <td>%s</td>
                    </tr>',
                    (int)$D['Partida'],
                    htmlspecialchars((string)$sku),
                    htmlspecialchars((string)$desc),
                    htmlspecialchars((string)$cant),
                    $ag, '—','—','—'
                );
            } else {
                foreach ($D['eventos'] as $ev) {
                    $rows++;
                    $body .= sprintf(
                        '<tr>
                            <td>%d</td>
                            <td>%s</td>
                            <td>%s</td>
                            <td align="right">%s</td>
                            <td>%s</td>
                            <td>%s</td>
                            <td>%s</td>
                            <td>%s</td>
                        </tr>',
                        (int)$D['Partida'],
                        htmlspecialchars((string)$sku),
                        htmlspecialchars((string)$desc),
                        htmlspecialchars((string)$cant),
                        'Agendado',
                        htmlspecialchars($ev['ini'] ?: '—'),
                        htmlspecialchars($ev['fin'] ?: '—'),
                        htmlspecialchars($instNameList($ev['inst_raw']))
                    );

                    $chips = [];
                    if ($ev['pars']['DC3'] !== '')     $chips[] = 'DC3: '.$ev['pars']['DC3'];
                    if ($ev['pars']['N']>0)            $chips[] = 'Participantes: '.$ev['pars']['N'];
                    if ($ev['pars']['Alim'] !== '')     $chips[] = 'Alimentos: '.$ev['pars']['Alim'];
                    if ($ev['pars']['Transp'] !== '')   $chips[] = 'Transporte: '.$ev['pars']['Transp'];
                    if ($ev['pars']['Obs'] !== '')      $chips[] = 'Obs: '.htmlspecialchars($ev['pars']['Obs']);
                    if ($chips) {
                        $body .= '<tr><td colspan="8" style="color:#444;">'.implode(' | ', $chips).'</td></tr>';
                    }
                }
            }
        }
        if ($rows===0) { $body .= '<tr><td colspan="8" align="center">— Sin partidas para mostrar —</td></tr>'; }

        $pdf->writeHTML($thead.$body.'</tbody></table><br/>', true, false, true, false, '');
    }

    /* =========================================================================
       ===== INICIO: NUEVOS REPORTES CON GRÁFICOS (puedes borrar este bloque) ==
       ========================================================================= */
    // 1) Eventos por día (según fecha de agenda)
    $byDay = [];  // 'YYYY-mm-dd' => count
    foreach ($orders as $O) {
        foreach ($O['detalles'] as $D) {
            if (!empty($D['eventos'])) {
                foreach ($D['eventos'] as $ev) {
                    $d = trim(substr($ev['ini'],0,10));
                    if ($d !== '' && preg_match('/^\d{4}-\d{2}-\d{2}$/',$d)) {
                        $byDay[$d] = ($byDay[$d] ?? 0) + 1;
                    }
                }
            }
        }
    }
    ksort($byDay);
    $pdf->AddPage('L');
    $drawHeader($pdf);
    $pdf->SetFont('helvetica','B',12);
    $pdf->Cell(0,8,'Eventos por día',0,1,'L');
    $pairsByDay=[];
    foreach ($byDay as $d=>$v) { $pairsByDay[]=['k'=>$d,'v'=>$v]; }
    if (!$pairsByDay) $pairsByDay=[['k'=>'(sin eventos)','v'=>0]];
    $drawBars($pdf, 15, $pdf->GetY()+2, 267, 'Cantidad de eventos por fecha', $pairsByDay);

    // 2) Top 10 clientes por cursos/partidas
    $byCliente = [];
    foreach ($orders as $O) {
        $cli = $O['info']['ClienteNombre'] ?: '(Sin nombre)';
        $byCliente[$cli] = ($byCliente[$cli] ?? 0) + count($O['detalles']);
    }
    arsort($byCliente);
    $pairsCli=[]; $i=0;
    foreach ($byCliente as $k=>$v) { $pairsCli[]=['k'=>$k,'v'=>$v]; if(++$i>=10) break; }
    $pdf->AddPage('L');
    $drawHeader($pdf);
    $pdf->SetFont('helvetica','B',12);
    $pdf->Cell(0,8,'Top clientes por cursos',0,1,'L');
    if (!$pairsCli) $pairsCli=[['k'=>'(sin datos)','v'=>0]];
    $drawBars($pdf, 15, $pdf->GetY()+2, 267, 'Top 10 clientes (por partidas/cursos)', $pairsCli);
    /* =========================================================================
       ===== FIN: NUEVOS REPORTES CON GRÁFICOS ================================ */

    $pdf->Output('desglose_capacitaciones.pdf','I');
}

function pdfcierre_caja($idSesion) {
     //ini_set('display_errors', 1);
        //ini_set('display_startup_errors', 1);

        //error_reporting(E_ALL);
    // ====== SQLs (solo se construyen aquí) ======
    // 1) Sesión de caja
    $sqlSesion = "
        SELECT 
            s.idSesion, s.IdUsuario, s.Departamento, s.fecha_apertura, s.fecha_dia,
            s.saldo_inicial, s.estado, s.aprobado_por, s.aprobado_en,
            u.Usuario     AS usuario_apertura,
            sup.Usuario   AS usuario_supervisor
        FROM caja_sesiones s
        LEFT JOIN usuarios u   ON u.IdUsuario = s.IdUsuario
        LEFT JOIN usuarios sup ON sup.IdUsuario = s.aprobado_por
        WHERE s.idSesion = $idSesion
        LIMIT 1
    ";
    $pSesion = [':idSesion' => $idSesion];

    // 2) Solicitud aprobada (contiene el resumen_json con esperado/contado)
    $sqlSolicitud = "
        SELECT idSolicitud, estado, resumen_json, solicitado_en, resuelto_en
        FROM caja_solicitudes_cierre
        WHERE idSesion = $idSesion AND estado = 'APROBADA'
        ORDER BY idSolicitud DESC
        LIMIT 1
    ";
    $pSolicitud = [':idSesion' => $idSesion];

    // 3) Movimientos manuales de la sesión (para el detalle del ticket)
    $sqlMovs = "
        SELECT cm.creado_en, cm.tipo, cm.origen, cm.IdOrden, cm.TipoPago, cm.concepto, cm.monto, tp.Descripcion
        FROM caja_movimientos cm INNER JOIN tipos_pago tp ON cm.TipoPago = tp.FidPago
        WHERE idSesion = $idSesion
        ORDER BY creado_en ASC
    ";
    $pMovs = [':idSesion' => $idSesion];

    // ====== EJECUCIÓN (usa tu MODELO) ======
    // Reemplaza estas 3 líneas por tu capa de modelos (la que ya tienes).
    // Por ejemplo, si tienes Model::query($sql,$params):
    // $rowSesion   = Model::query($sqlSesion, $pSesion);
    // $rowSol      = Model::query($sqlSolicitud, $pSolicitud);
    // $rowsMovs    = Model::query($sqlMovs, $pMovs);

    // TODO: ejecuta con tu modelo y obtén resultados
    $caja  = new cajaModel;
    $caja->sentencia = $sqlSesion;
    $rowSesion = $caja->codi_get_sesion_pdf();
    $caja2  = new cajaModel;
    $caja2->sentencia = $sqlSolicitud;
    $rowSol = $caja2->codi_get_cierre_solicitudes_pdf();
    $caja3  = new cajaModel;
    $caja3->sentencia = $sqlMovs;
    $rowsMovs = $caja3->codi_get_caja_movi_pdf();

    $sesion = is_array($rowSesion) && !empty($rowSesion) ? $rowSesion[0] : null;
    $sol    = is_array($rowSol)    && !empty($rowSol)    ? $rowSol[0]    : null;
    $movs   = is_array($rowsMovs)  ? $rowsMovs           : [];

    if (!$sesion) {
        header('HTTP/1.1 404 Not Found');
        echo 'Sesión no encontrada';
        return;
    }
    if (!$sol || empty($sol['resumen_json'])) {
        header('HTTP/1.1 409 Conflict');
        echo 'No hay solicitud APROBADA para esta sesión';
        return;
    }

    // ====== Parsear resumen ======
    $resumen = json_decode($sol['resumen_json'], true);
    if (!is_array($resumen)) { $resumen = []; }

    $esperado = isset($resumen['esperado']) && is_array($resumen['esperado']) ? $resumen['esperado'] : [];
    $contado  = isset($resumen['contado'])  && is_array($resumen['contado'])  ? $resumen['contado']  : [];
    $observ   = isset($resumen['observ']) ? (string)$resumen['observ'] : '';

    // Normalizar llaves del "contado" a las mismas etiquetas del "esperado"
    $map = [
        'efectivo'          => 'Efectivo',
        'transferencia'     => 'Transferencia',
        'tarjeta_credito'   => 'Tarjeta Crédito',
        'tarjeta_debito'    => 'Tarjeta Débito',
        'cheque'            => 'Cheque',
        'sintipodepago'     => 'SinTipodePago',
        'desconocido'       => 'Pago desconocido',
    ];
    $contadoNorm = [
        'Efectivo'         => 0, 'Transferencia' => 0, 'Tarjeta Crédito' => 0,
        'Tarjeta Débito'   => 0, 'Cheque' => 0, 'SinTipodePago' => 0, 'Pago desconocido' => 0
    ];
    foreach ($contado as $k => $v) {
        $label = isset($map[$k]) ? $map[$k] : $k;
        if (!isset($contadoNorm[$label])) { $contadoNorm[$label] = 0; }
        $contadoNorm[$label] += (float)$v;
    }

    // Garantiza todas las llaves en esperado
    $formas = ['Efectivo','Transferencia','Tarjeta Crédito','Tarjeta Débito','Cheque','SinTipodePago','Pago desconocido'];
    foreach ($formas as $f) {
        if (!isset($esperado[$f])) $esperado[$f] = 0.0;
        if (!isset($contadoNorm[$f])) $contadoNorm[$f] = 0.0;
    }

    // Totales
    $fmt = function($n){ return '$' . number_format((float)$n, 2, '.', ','); };
    $sumEsp = 0; $sumCnt = 0; $sumDif = 0;

    // ====== Armar HTML ======
    $h = function($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); };

    $headerHtml = '
      <div style="text-align:center;">
        <h2 style="margin:4px 0;">CIERRE DE CAJA</h2>
        <span>Sesión #'.$h($sesion['idSesion']).' &nbsp;|&nbsp; Estado: '.$h($sesion['estado']).'</span><br/>
        <small>Apertura: '.$h($sesion['fecha_apertura']).' &nbsp;|&nbsp; Día: '.$h($sesion['fecha_dia']).'</small><br/>
        <small>Saldo inicial: <strong>'.$fmt($sesion['saldo_inicial']).'</strong></small><br/>
        <small>Usuario: '.$h($sesion['usuario_apertura'] ?: $sesion['IdUsuario']).'</small><br/>
        <small>Aprobado por: '.$h($sesion['usuario_supervisor'] ?: $sesion['aprobado_por']).' &nbsp;|&nbsp; '.$h($sesion['aprobado_en']).'</small>
      </div>
      <br/>';

    // Tabla resumen esperado vs contado
    $tabla = '
      <table border="1" cellpadding="4" cellspacing="0">
        <thead>
          <tr style="background-color:#f0f0f0;">
            <th width="25%" align="left">Forma de pago</th>
            <th width="25%" align="right">Esperado</th>
            <th width="25%" align="right">Contado</th>
            <th width="25%" align="right">Diferencia</th>
          </tr>
        </thead>
        <tbody>';
    foreach ($formas as $f) {
        $e = (float)$esperado[$f];
        $c = (float)$contadoNorm[$f];
        $d = $c - $e;
        $sumEsp += $e; $sumCnt += $c; $sumDif += $d;
        $tabla .= '
          <tr>
            <td>'.$h($f).'</td>
            <td align="right">'.$fmt($e).'</td>
            <td align="right">'.$fmt($c).'</td>
            <td align="right">'.$fmt($d).'</td>
          </tr>';
    }
    $tabla .= '
          <tr>
            <td align="right"><strong>TOTALES</strong></td>
            <td align="right"><strong>'.$fmt($sumEsp).'</strong></td>
            <td align="right"><strong>'.$fmt($sumCnt).'</strong></td>
            <td align="right"><strong>'.$fmt($sumDif).'</strong></td>
          </tr>
        </tbody>
      </table>
      <br/>';

    // Observaciones
    $obsHtml = '';
    if ($observ !== '') {
        $obsHtml = '
          <table border="0" cellpadding="4" cellspacing="0">
            <tr><td><strong>Observaciones:</strong><br/>'.$h($observ).'</td></tr>
          </table>
          <br/>';
    }

    // Movimientos manuales
    $movHtml = '
      <table border="1" cellpadding="3" cellspacing="0">
        <thead>
          <tr style="background-color:#f9f9f9;">
            <th width="20%" align="left">Fecha</th>
            <th width="12%" align="center">Tipo</th>
            <th width="11%" align="center">Origen</th>
            <th width="10%" align="center">Orden</th>
            <th width="13%" align="left">Tipo pago</th>
            <th width="19%" align="left">Concepto</th>
            <th width="15%" align="right">Monto</th>
          </tr>
        </thead>
        <tbody>';
    if (!empty($movs)) {
        foreach ($movs as $m) {
            $movHtml .= '
              <tr>
                <td width="20%">'.$h($m['creado_en']).'</td>
                <td width="12%" align="center">'.$h($m['tipo']).'</td>
                <td width="11%" align="center">'.$h($m['origen']).'</td>
                <td width="10%" align="center">'.($m['IdOrden'] ? '#'.$h($m['IdOrden']) : '—').'</td>
                <td width="13%">'.$h($m['Descripcion'] ?: '—').'</td>
                <td width="19%">'.$h($m['concepto'] ?: '').'</td>
                <td width="15%" align="right">'.$fmt($m['monto']).'</td>
              </tr>';
        }
    } else {
        $movHtml .= '<tr><td colspan="7" align="center">Sin movimientos manuales.</td></tr>';
    }
    $movHtml .= '</tbody></table>';

    // ====== Render con TCPDF ======
    $pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
    $pdf->SetTitle('Ticket de Cierre - Sesión #'.$sesion['idSesion']);
    $pdf->setPrintHeader(false);       // Usas tu header de clase si prefieres true
    $pdf->setPrintFooter(true);
    $pdf->SetMargins(13, 15, 13, true);
    $pdf->SetAutoPageBreak(TRUE, 15);
    $pdf->SetFont('helvetica', '', 10);

    $pdf->AddPage();

    // Encabezado gráfico si lo usas (opcional)
    $bMargin = $pdf->getBreakMargin();
    $auto_page_break = $pdf->getAutoPageBreak();
    $pdf->SetAutoPageBreak(false, 0);
    $img_header = 'assets/img/images/formatos/encabezado.png';
    if (file_exists($img_header)) { $pdf->Image($img_header, 0, 0, 210, 23, '', '', '', false, 300, '', false, false, 0); }
    $pdf->SetAutoPageBreak($auto_page_break, $bMargin);
    $pdf->setPageMark();

    // Cuerpo
    $pdf->writeHTML($headerHtml, true, false, true, false, '');
    $pdf->writeHTML($tabla, true, false, true, false, '');
    if ($obsHtml) $pdf->writeHTML($obsHtml, true, false, true, false, '');
    $pdf->writeHTML('<h4>Movimientos manuales</h4>', true, false, true, false, '');
    $pdf->writeHTML($movHtml, true, false, true, false, '');

    // Salida
    $pdf->Output('ticket_cierre_sesion_'.$sesion['idSesion'].'.pdf', 'I');
}



public function productos_eliminar_pdf()
{
    $chartCategorias = $_POST['chart_categorias'] ?? '';
    $tablaCandidatos = $_POST['tabla_candidatos'] ?? '';

    $cleanTable = function($html){
        if (!$html) return '';
        $html = preg_replace('#<script[^>]*>.*?</script>#is','',$html);
        $html = preg_replace('#<iframe[^>]*>.*?</iframe>#is','',$html);
        $html = preg_replace('/\sclass="[^"]*"/i','',$html);
        return $html;
    };

    $drawDataUrlImage = function (TCPDF $pdf, $dataUrl, $maxWidthMM = null) {
        if (empty($dataUrl)) return false;
        if (preg_match('#^data:image/[-+a-z0-9.]+;base64,#i', $dataUrl)) {
            $dataUrl = substr($dataUrl, strpos($dataUrl, ',') + 1);
        }
        $raw = base64_decode($dataUrl, true);
        if ($raw === false) return false;
        $m = $pdf->getMargins();
        $w = $maxWidthMM ?: ($pdf->getPageWidth() - $m['left'] - $m['right']);
        $pdf->Image('@'.$raw, '', '', $w, 0, '', '', 'T', false, 300, '', false, false, 0, false, false, false);
        return true;
    };

    $tableCss = <<<CSS
<style>
  table { border-collapse: collapse; width: 100%; }
  th, td { border: 1px solid #555; padding: 5px 6px; font-size: 9pt; }
  thead th { background-color: #efefef; font-weight: bold; }
  tr:nth-child(even) td { background-color: #fafafa; }
</style>
CSS;

    $pdf = new MYPDF('P','mm','A4',true,'UTF-8',false);
    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('Sistema');
    $pdf->SetTitle('Productos a eliminar (sin ventas 6M)');
    $pdf->SetSubject('Reporte de productos sin rotación');
    $pdf->setPrintHeader(false);
    $pdf->SetMargins(12,18,12);
    $pdf->SetHeaderMargin(0);
    $pdf->SetFooterMargin(12);
    $pdf->SetAutoPageBreak(true,18);
    $pdf->SetFont('helvetica','',10);

    // Portada
    $pdf->AddPage();
    $pdf->SetFont('helvetica','B',18);
    $pdf->Cell(0,12,'Productos a eliminar (sin ventas 6M)',0,1,'L');
    $pdf->SetFont('helvetica','',11);
    $pdf->Cell(0,8,'Generado: '.date('d/m/Y H:i'),0,1,'L');
    $pdf->Ln(2);
    $intro = '<p style="line-height:150%;">Este reporte muestra SKUs activos sin ventas en los últimos 6 meses (excluye almacenes 4 y 6), con existencias, valor y recomendaciones de acción.</p>';
    $pdf->writeHTML($intro, true, false, true, false, '');

    // Gráfico por categoría
    $pdf->AddPage();
    $pdf->SetFont('helvetica','B',13);
    $pdf->Cell(0,8,'Distribución de valor por categoría (candidatos)',0,1,'L');
    $pdf->Ln(2);
    if (!$drawDataUrlImage($pdf, $chartCategorias)) {
      $pdf->SetFont('helvetica','',10);
      $pdf->SetTextColor(200,0,0);
      $pdf->Cell(0,6,'No se recibió la imagen del gráfico.',0,1,'L');
      $pdf->SetTextColor(0,0,0);
    }

    // Tabla principal
    $pdf->AddPage();
    $pdf->SetFont('helvetica','B',13);
    $pdf->Cell(0,8,'Candidatos a eliminar',0,1,'L');
    $pdf->Ln(2);
    $pdf->SetFont('helvetica','',9);
    $tbl = $cleanTable($tablaCandidatos);
    if (!empty($tbl)) {
        $pdf->writeHTML($tableCss.$tbl, true, false, true, false, '');
    } else {
        $pdf->SetTextColor(200,0,0);
        $pdf->Cell(0,6,'No se recibió la tabla de candidatos.',0,1,'L');
        $pdf->SetTextColor(0,0,0);
    }

    $pdf->Output('productos_eliminar_'.date('Ymd_His').'.pdf','I');
}


public function kpi_ordenes_pdf()
{
    // Entradas del formulario (JS)
    $chartOrdenes       = $_POST['chart_ordenes']        ?? '';
    $tablaTopClientes   = $_POST['tabla_top_clientes']   ?? '';
    $tablaVendCat       = $_POST['tabla_vendedor_cat']   ?? '';
    $tablaRecargaRecall = $_POST['tabla_recarga_recall'] ?? '';
    $tablaVendedores    = $_POST['tabla_vendedores']     ?? '';

    // Helpers locales
    $drawDataUrlImage = function (TCPDF $pdf, $dataUrl, $maxWidthMM = null) {
        if (empty($dataUrl)) return false;
        if (preg_match('#^data:image/[-+a-z0-9.]+;base64,#i', $dataUrl)) {
            $dataUrl = substr($dataUrl, strpos($dataUrl, ',') + 1);
        }
        $raw = base64_decode($dataUrl, true);
        if ($raw === false) return false;
        $m = $pdf->getMargins();
        $w = $maxWidthMM ?: ($pdf->getPageWidth() - $m['left'] - $m['right']);
        $pdf->Image('@'.$raw, '', '', $w, 0, '', '', 'T', false, 300, '', false, false, 0, false, false, false);
        return true;
    };
    $cleanTableHtml = function($html){
        if (!$html) return '';
        $html = preg_replace('#<script[^>]*>.*?</script>#is','',$html);
        $html = preg_replace('#<iframe[^>]*>.*?</iframe>#is','',$html);
        $html = preg_replace('/\sclass="[^"]*"/i','',$html);
        return $html;
    };
    $tableCss = <<<CSS
<style>
  table { border-collapse: collapse; width: 100%; }
  th, td { border: 1px solid #555; padding: 5px 6px; font-size: 9pt; }
  thead th { background-color: #efefef; font-weight: bold; }
  tr:nth-child(even) td { background-color: #fafafa; }
</style>
CSS;

    // PDF
    $pdf = new MYPDF('P','mm','A4',true,'UTF-8',false);
    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('Sistema');
    $pdf->SetTitle('KPI Órdenes');
    $pdf->SetSubject('Reporte KPI de Órdenes');
    $pdf->setPrintHeader(false);
    $pdf->SetMargins(12,18,12);
    $pdf->SetHeaderMargin(0);
    $pdf->SetFooterMargin(12);
    $pdf->SetAutoPageBreak(true,18);
    $pdf->SetFont('helvetica','',10);

    // Portada / Intro
    $pdf->AddPage();
    $pdf->SetFont('helvetica','B',18);
    $pdf->Cell(0,12,'Reporte KPI de Órdenes (3M)',0,1,'L');
    $pdf->SetFont('helvetica','',11);
    $pdf->Cell(0,8,'Generado: '.date('d/m/Y H:i'),0,1,'L');
    $pdf->Ln(2);
    $intro = '<p style="line-height:150%;">Incluye tendencia de órdenes, Top 10 clientes, Vendedor x Categoría, Vendedores y Recall de Recarga/Mantenimiento (m-11 y m-10).</p>';
    $pdf->writeHTML($intro, true, false, true, false, '');

    // Gráfica
    $pdf->AddPage();
    $pdf->SetFont('helvetica','B',13);
    $pdf->Cell(0,8,'Gráfica: Tendencia de Órdenes (3M)',0,1,'L');
    $pdf->Ln(2);
    if (!$drawDataUrlImage($pdf, $chartOrdenes)) {
        $pdf->SetFont('helvetica','',10);
        $pdf->SetTextColor(200,0,0);
        $pdf->Cell(0,6,'No se recibió la imagen de la gráfica.',0,1,'L');
        $pdf->SetTextColor(0,0,0);
    }

    // Top clientes
    $pdf->AddPage();
    $pdf->SetFont('helvetica','B',13);
    $pdf->Cell(0,8,'Top 10 clientes por ingresos (3M)',0,1,'L');
    $pdf->Ln(2);
    $pdf->SetFont('helvetica','',9);
    $topHtml = $cleanTableHtml($tablaTopClientes);
    if (!empty($topHtml)) $pdf->writeHTML($tableCss.$topHtml, true, false, true, false, '');
    else { $pdf->SetTextColor(200,0,0); $pdf->Cell(0,6,'No se recibió la tabla de Top clientes.',0,1,'L'); $pdf->SetTextColor(0,0,0); }

    // Vendedor x Categoría
    $pdf->Ln(4);
    $pdf->SetFont('helvetica','B',13);
    $pdf->Cell(0,8,'Órdenes por vendedor y categoría (3M)',0,1,'L');
    $pdf->Ln(2);
    $pdf->SetFont('helvetica','',9);
    $vcHtml = $cleanTableHtml($tablaVendCat);
    if (!empty($vcHtml)) $pdf->writeHTML($tableCss.$vcHtml, true, false, true, false, '');
    else { $pdf->SetTextColor(200,0,0); $pdf->Cell(0,6,'No se recibió la tabla de Vendedor/Categoría.',0,1,'L'); $pdf->SetTextColor(0,0,0); }

    // Vendedores (resumen)
    $pdf->AddPage();
    $pdf->SetFont('helvetica','B',13);
    $pdf->Cell(0,8,'Órdenes por vendedor (3M)',0,1,'L');
    $pdf->Ln(2);
    $pdf->SetFont('helvetica','',9);
    $vHtml = $cleanTableHtml($tablaVendedores);
    if (!empty($vHtml)) $pdf->writeHTML($tableCss.$vHtml, true, false, true, false, '');
    else { $pdf->SetTextColor(200,0,0); $pdf->Cell(0,6,'No se recibió la tabla de Vendedores.',0,1,'L'); $pdf->SetTextColor(0,0,0); }

    // Recall Recarga/Mantenimiento (m-11 y m-10)
    $pdf->AddPage();
    $pdf->SetFont('helvetica','B',13);
    $pdf->Cell(0,8,'Recall Recarga/Mantenimiento (tipo_orden = 2) — Meses m-11 y m-10',0,1,'L');
    $pdf->Ln(2);
    $pdf->SetFont('helvetica','',9);
    $recHtml = $cleanTableHtml($tablaRecargaRecall);
    if (!empty($recHtml)) $pdf->writeHTML($tableCss.$recHtml, true, false, true, false, '');
    else { $pdf->SetTextColor(200,0,0); $pdf->Cell(0,6,'No se recibió la tabla de Recall.',0,1,'L'); $pdf->SetTextColor(0,0,0); }

    $pdf->Output('kpi_ordenes_'.date('Ymd_His').'.pdf','I');
}


function kpi_pdf()
{
    // ====== 1) Entradas desde el formulario (JS) ======
    $chartGeneral   = $_POST['chart_general']   ?? '';
    $chartAlmacenes = $_POST['chart_almacenes'] ?? '';
    $tablaTop       = $_POST['tabla_top']       ?? '';
    $tablaKits      = $_POST['tabla_kits']      ?? '';

    // ====== 2) Helpers locales ======
    // Dibuja una imagen desde dataURL/base64 al ancho disponible
    $drawDataUrlImage = function (TCPDF $pdf, $dataUrl, $maxWidthMM = null) {
        if (empty($dataUrl)) return false;

        // Si viene con prefijo data:image/...
        if (preg_match('#^data:image/[-+a-z0-9.]+;base64,#i', $dataUrl)) {
            $dataUrl = substr($dataUrl, strpos($dataUrl, ',') + 1);
        }

        $raw = base64_decode($dataUrl, true);
        if ($raw === false) return false;

        $margins = $pdf->getMargins();
        $usableWidth = $maxWidthMM ?: ($pdf->getPageWidth() - $margins['left'] - $margins['right']);
        // La sintaxis '@' acepta binario directo
        $pdf->Image('@' . $raw, '', '', $usableWidth, 0, '', '', 'T', false, 300, '', false, false, 0, false, false, false);
        return true;
    };

    // Sanea HTML de tablas (elimina <script>/<iframe> y clases)
    $cleanTableHtml = function ($html) {
        if (!$html) return '';
        $html = preg_replace('#<script[^>]*>.*?</script>#is', '', $html);
        $html = preg_replace('#<iframe[^>]*>.*?</iframe>#is', '', $html);
        $html = preg_replace('/\sclass="[^"]*"/i', '', $html);
        return $html;
    };

    // CSS simple para que TCPDF muestre bordes
    $tableCss = <<<CSS
<style>
  table { border-collapse: collapse; width: 100%; }
  th, td { border: 1px solid #555; padding: 5px 6px; font-size: 9pt; }
  thead th { background-color: #efefef; font-weight: bold; }
  tr:nth-child(even) td { background-color: #fafafa; }
</style>
CSS;
    // ====== 3 Instanciar PDF con tu clase MYPDF ======
    // Usa tu header/footer ya definidos (portada.png en Header)
    $pdf = new MYPDF('P', 'mm', 'A4', true, 'UTF-8', false);

    // Metadata (ajústalo si deseas)
    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('Sistema');
    $pdf->SetTitle('KPI Productos');
    $pdf->SetSubject('Reporte KPI de Productos');
    $pdf->SetKeywords('KPI, Productos, Ventas, Inventario');

    // Márgenes (tu Header pinta fondo completo y hace setPageMark)
    $pdf->setPrintHeader(false);
    $pdf->SetMargins(12, 18, 12);    // izq, sup, der
    $pdf->SetHeaderMargin(0);
    $pdf->SetFooterMargin(12);
    $pdf->SetAutoPageBreak(true, 18);
    $pdf->setImageScale(1.25);

    $pdf->SetFont('helvetica', '', 10);

    // ====== 4) Portada / Introducción ======
    $pdf->AddPage();
    $pdf->SetFont('helvetica', 'B', 18);
    $pdf->Cell(0, 12, 'Reporte KPI de Productos', 0, 1, 'L');

    $pdf->SetFont('helvetica', '', 11);
    $pdf->Cell(0, 8, 'Generado: ' . date('d/m/Y H:i'), 0, 1, 'L');
    $pdf->Ln(2);

    $intro = <<<HTML
<p style="line-height:150%;">
Este documento incluye un resumen de indicadores (KPI) de productos, ventas de los últimos 3 meses y salud de inventario.
Además, contiene las tablas de "Top vendidos" y "Productos sin ventas" con sugerencias de kits.
</p>
HTML;
    $pdf->writeHTML($intro, true, false, true, false, '');

    // ====== 5) Gráficas ======
    $pdf->AddPage();
    $pdf->SetFont('helvetica', 'B', 13);
    $pdf->Cell(0, 8, 'Gráfica: Tendencia mensual (General)', 0, 1, 'L');
    $pdf->Ln(2);

    if (!$drawDataUrlImage($pdf, $chartGeneral)) {
        $pdf->SetFont('helvetica', '', 10);
        $pdf->SetTextColor(200, 0, 0);
        $pdf->Cell(0, 6, 'No se recibió la imagen de esta gráfica.', 0, 1, 'L');
        $pdf->SetTextColor(0, 0, 0);
    }

    $pdf->Ln(6);
    $pdf->SetFont('helvetica', 'B', 13);
    $pdf->Cell(0, 8, 'Gráfica: Tendencia por almacén', 0, 1, 'L');
    $pdf->Ln(2);

    if (!$drawDataUrlImage($pdf, $chartAlmacenes)) {
        $pdf->SetFont('helvetica', '', 10);
        $pdf->SetTextColor(200, 0, 0);
        $pdf->Cell(0, 6, 'No se recibió la imagen de esta gráfica.', 0, 1, 'L');
        $pdf->SetTextColor(0, 0, 0);
    }

    // ====== 6) Tablas (Top vendidos / Sin ventas + kits) ======
    $pdf->AddPage();

    // Top vendidos
    $pdf->SetFont('helvetica', 'B', 13);
    $pdf->Cell(0, 8, 'Top vendidos (3M) con stock / mínimos / máximos', 0, 1, 'L');
    $pdf->Ln(2);
    $pdf->SetFont('helvetica', '', 9);

    $topHtml = $cleanTableHtml($tablaTop);
    if (!empty($topHtml)) {
        $pdf->writeHTML($tableCss . $topHtml, true, false, true, false, '');
    } else {
        $pdf->SetTextColor(200, 0, 0);
        $pdf->Cell(0, 6, 'No se recibió la tabla de Top vendidos.', 0, 1, 'L');
        $pdf->SetTextColor(0, 0, 0);
    }

    // Sin ventas + kits
    $pdf->Ln(4);
    $pdf->SetFont('helvetica', 'B', 13);
    $pdf->Cell(0, 8, 'Sin ventas (3M) + kits sugeridos', 0, 1, 'L');
    $pdf->Ln(2);
    $pdf->SetFont('helvetica', '', 9);

    $kitsHtml = $cleanTableHtml($tablaKits);
    if (!empty($kitsHtml)) {
        $pdf->writeHTML($tableCss . $kitsHtml, true, false, true, false, '');
    } else {
        $pdf->SetTextColor(200, 0, 0);
        $pdf->Cell(0, 6, 'No se recibió la tabla de Kits sugeridos.', 0, 1, 'L');
        $pdf->SetTextColor(0, 0, 0);
    }

    // ====== 7) Salida ======
    $filename = 'kpi_productos_' . date('Ymd_His') . '.pdf';
    // 'I' = mostrar en navegador; 'D' = descargar
    $pdf->Output($filename, 'I');
}



}