<?php

// Prueba Core
function to_object($array)
{

  return json_decode(json_encode($array));
}
// Prueba Core
function get_sitename()
{

  return 'XtinFIRE';
}

function json_output($json, $die = true)
{
  header('Access-Control-Allow-Origin: *');
  header('Content-type: application/json;charset=utf-8');

  if (is_array($json)) {
    $json = json_encode($json);
  }

  echo $json;
  if ($die) {
    die;
  }

  return true;
}

function json_build($status = 200, $data = null, $msg = '')
{
  if (empty($msg) || $msg == '') {
    switch ($status) {
      case 200:
        $msg = 'OK';
        break;
      case 201:
        $msg = 'Created';
        break;
      case 400:
        $msg = 'Invalid request';
        break;
      case 403:
        $msg = 'Access denied';
        break;
      case 404:
        $msg = 'Not found';
        break;
      case 500:
        $msg = 'Internal Server Error';
        break;
      case 550:
        $msg = 'Permission denied';
        break;
      default:
        break;
    }
  }

  http_response_code($status);

  $json =
    [
      'status' => $status,
      'error'  => false,
      'msg'    => $msg,
      'data'   => $data
    ];

  $error_codes = [400, 403, 404, 405, 500];

  if (in_array($status, $error_codes)) {
    $json['error'] = true;
  }

  return json_encode($json);
}

function get_module($view, $data = [])
{
  $file_to_include = MODULES . $view . 'Module.php';
  $output = '';

  // Por si queremos trabajar con objeto
  $d = to_object($data);

  if (!is_file($file_to_include)) {
    return false;
  }

  ob_start();
  require_once $file_to_include;
  $output = ob_get_clean();

  return $output;
}

function random_strings($length_of_string)
{

  // String of all alphanumeric character
  $str_result = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';

  // Shuffle the $str_result and returns substring
  // of specified length
  return substr(
    str_shuffle($str_result),
    0,
    $length_of_string
  );
}

function crear_qr($folio)
{
  //ini_set('error_reporting', E_ALL);
  //ini_set('display_errors', true);
  $ruta_wqr = ASSETS_PLUGINS . "qr/" . $folio . "-img.png";
  $ruta_rqr = ASSETS . "qr/" . $folio . "-img.png";
  $ruta_imagen = "";

  $size = 10;
  $level = "Q";
  $frameSize = 3;
  if (!file_exists($ruta_wqr)) {
    QRcode::png($folio, $ruta_wqr, $level, $size, $frameSize);
  }

  if (file_exists($ruta_wqr)) {
    $ruta_imagen = $ruta_rqr;
  }
  return $ruta_imagen;
}

function crear_qr_card($folio, $info, $conprecio)
{
  //ini_set('error_reporting', E_ALL);
  //ini_set('display_errors', true);
  $ruta_wqr = ASSETS_PLUGINS . "qr/" . $folio . "-prod-img.png";
  $ruta_rqr = ASSETS . "qr/" . $folio . "-prod-img.png";
  $ruta_imagen = "";

  $size = 2;
  $level = "Q";
  $frameSize = 3;

  // here our data
  $sku = $info->proSku;
  $precio = $info->proPrecioventa;
  $nombre = $info->proTitulo;
  $categoria = $info->catNombre;

  // we building raw data
  $codeContents  = 'BEGIN:VCARD' . "\n";
  $codeContents .= 'FN:' . 'SKU: ' . $sku . "\n";
  if ($conprecio == 1) {
    $codeContents .= 'FN:' . 'PRECIO: ' . $precio . "\n";
  }
  $codeContents .= 'FN:' . 'NOMBRE: ' . $nombre . "\n";
  $codeContents .= 'FN:' . 'CATEGORIA: ' . $categoria . "\n";
  $codeContents .= 'END:VCARD';

  /*
  if (!file_exists($ruta_wqr)) {
  }
  */
  QRcode::png($codeContents, $ruta_wqr, $level, $size, $frameSize);

  if (file_exists($ruta_wqr)) {
    $ruta_imagen = $ruta_rqr;
  }
  return $ruta_imagen;
}

function crear_qr_extintor($folio, $info, $conprecio)
{
  //ini_set('error_reporting', E_ALL);
  //ini_set('display_errors', true);
  $ruta_wqr = ASSETS_PLUGINS . "qr/" . $folio . "-extintor-img.png";
  $ruta_rqr = ASSETS . "qr/" . $folio . "-extintor-img.png";
  $ruta_imagen = "";

  $size = 3;
  $level = "Q";
  $frameSize = 3;

  // here our data
  $sku = $info->proSku;
  $precio = $info->proPrecioventa;
  $nombre = $info->proTitulo;
  $categoria = $info->catNombre;

  $ClaveExtintor = $info->ClaveExtintor;
  $FolioOrden = $info->FolioOrden;
  $Ubicacion = $info->Ubicacion;
  $IdCliente = $info->IdCliente;
  $FechaEntrega = $info->FechaEntrega;
  $Estatus = $info->Estatus;

  // we building raw data
  $codeContents  = 'BEGIN:VCARD' . "\n";
  $codeContents .= 'FN:' . 'SKU: ' . $sku . "\n";
  if ($conprecio == 1) {
    $codeContents .= 'FN:' . 'PRECIO: ' . $precio . "\n";
  }
  $codeContents .= 'FN:' . 'NOMBRE: ' . $nombre . "\n";
  $codeContents .= 'FN:' . 'CATEGORIA: ' . $categoria . "\n";

  $codeContents .= 'FN:' . 'CLAVE: ' . $ClaveExtintor . "\n";
  $codeContents .= 'FN:' . 'ORDEN: ' . $FolioOrden . "\n";
  $codeContents .= 'FN:' . 'UBICACIÓN: ' . $Ubicacion . "\n";
  $codeContents .= 'FN:' . 'CLIENTE ENTREGA: ' . $IdCliente . "\n";
  $codeContents .= 'FN:' . 'FECHA DE ENTREGA: ' . $FechaEntrega . "\n";
  $codeContents .= 'FN:' . 'ESTATUS: ' . $Estatus . "\n";
  $codeContents .= 'EMAIL:' . 'VER ORDEN: ' . URL . 'ordenes/detalle/' . $FolioOrden . "\n";
  $codeContents .= 'END:VCARD';

  /*
  if (!file_exists($ruta_wqr)) {
  }
  */
  QRcode::png($codeContents, $ruta_wqr, $level, $size, $frameSize);

  if (file_exists($ruta_wqr)) {
    $ruta_imagen = $ruta_rqr;
  }
  return $ruta_imagen;
}
