<?php
class ComplementosModel extends Db
{
    //---------------------Complemento----------------------//
    public $Id;
    public $IdOrden;
    public $Fecha;
    public $NMes;
    public $Cantidad;
    public $Nota;
    public $Estatus;

    /**
     * 
     * Metodo para cargar todos los complementos
     * @return void 
     */
    public function all()
    {
        $sql = "SELECT * FROM complementospagos";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar un registro usando su id
     * @return void 
     */
    public function one()
    {
        $sql = "SELECT * FROM complementospagos WHERE IdOrden =:IdOrden ORDER BY PartialityNumber DESC LIMIT 1";

        try {
            return ($rows = parent::query($sql, ['IdOrden' => $this->IdOrden])) ? $rows[0] : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar un registro usando su id
     * @return void 
     */
    public function one2()
    {
        $sql = "SELECT * FROM complementospagos WHERE IdOrden =:IdOrden";

        try {
            return ($rows = parent::query($sql, ['IdOrden' => $this->IdOrden])) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para crear complemento
     * @return integer 
     */
    public function create()
    {
        $sql = "INSERT INTO complementospagos ( IdOrden, Fecha, NMes, Cantidad, Nota, Estatus) 
        VALUES (:IdOrden, :Fecha, :NMes, :Cantidad, :Nota, :Estatus)";
        $data =
            [
                'IdOrden' => $this->IdOrden,
                'Fecha' => $this->Fecha,
                'NMes' => $this->NMes,
                'Cantidad' => $this->Cantidad,
                'Nota' => $this->Nota,
                'Estatus' => $this->Estatus
            ];

        try {
            return ($this->Id = parent::query($sql, $data)) ? $this->Id : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para actualizar un registro de la bd
     * @return bool 
     */
    public function update()
    {
        $sql = "UPDATE complementospagos SET 
        IdOrden=:IdOrden, Fecha=:Fecha, NMes=:NMes, Cantidad=:Cantidad, Nota=:Nota, Estatus=:Estatus
        WHERE Id=:Id";
        $data =
            [
                'IdOrden' => $this->IdOrden,
                'Fecha' => $this->Fecha,
                'NMes' => $this->Cantidad,
                'Nota' => $this->Nota,
                'Estatus' => $this->Estatus
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para actualizar un registro de la bd
     * @return bool 
     */
    public function updatepagar()
    {
        $sql = "UPDATE complementospagos SET Estatus=:Estatus, FechaPago=:FechaPago WHERE IdOrden=:IdOrden AND NMes=:NMes";
        $data =
            [
                'IdOrden' => $this->IdOrden,
                'NMes' => $this->NMes,
                'Estatus' => $this->Estatus,
                'FechaPago' => date("Y-m-d")
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }


    /**
     * 
     * Metodo para actualizar un registro de la bd
     * @return bool 
     */
    public function deletepagar()
    {
        $sql = "DELETE FROM complementospagos WHERE IdOrden = :IdOrden";
        $data =
            [
                'IdOrden' => $this->IdOrden
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para eliminar un complemento
     *  
     */
    public function delete()
    {
        $sql = "UPDATE complementospagos SET Estatus=:Estatus 
        WHERE Id=:Id";
        $data =
            [
                'Estatus' => 0,
                'Id' => $this->Id
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }
}
