<?php
class cajaModel extends Db
{
    //---------------------Orden----------------------//
    public $Idusuariomoviemientos;
    public $Estatus;
    public $Tipopago;
    public $IdUsuario;
    public $Departamento;
    public $Saldoinicial;
    public $ini;
    public $fin;
    public $idSesion;
    public $tipo;
    public $IdOrden;
    public $IdDetalle;
    public $concepto;
    public $TipoPago;
    public $monto;
    public $creado_por;
    public $resumen_json;
    public $idSolicitud;
    public $resuelto_por;
    public $total_esperado;
    public $total_contado;
    public $detalle_json;
    public $obs_supervisor;
    public $dia;
    public $diffs_json;
    public $sentencia;
    public $origen;
    public $estatus;
    public $PagadoCompleto;


    /**
     * 
     * Metodo para cargar todo
     * @return void 
     */

    public function caja_check_prevday_model()
    {
        $sql = "SELECT cs.*
            FROM caja_sesiones cs
            LEFT JOIN caja_cierres cc ON cc.idSesion = cs.idSesion
            WHERE cs.IdUsuario   = :IdUsuario
            AND cs.Departamento= :Departamento
            AND cs.estado      = 'ABIERTA'
            AND DATE(cs.fecha_apertura) < CURDATE()
            AND cc.idSesion IS NULL            -- no se ha cerrado
            ORDER BY cs.fecha_apertura DESC
            LIMIT 1;";
            $data = [
            'IdUsuario'    => $this->IdUsuario,
            'Departamento' => $this->Departamento
            ];

        try {
            return ($rows = parent::query($sql, $data)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

     /**
     * 
     * Metodo para cargar todo
     * @return void 
     */

    public function caja_open_model()
        {
            // Pre-check: NO permitir 2 sesiones ABIERTAS el mismo día para el mismo usuario+depto
            $sqlCheck = "
                SELECT idSesion
                FROM caja_sesiones
                WHERE IdUsuario = :IdUsuario
                AND Departamento = :Departamento
                AND estado = 'ABIERTA'
                AND fecha_dia = :fecha_dia
                LIMIT 1;
            ";
            $dataCheck = [
                'IdUsuario'    => $this->IdUsuario,
                'Departamento' => $this->Departamento,
                'fecha_dia'    => $this->dia,            // <-- YYYY-mm-dd
            ];

            try {
                $existeAbierta = parent::query($sqlCheck, $dataCheck);
                if ($existeAbierta && count($existeAbierta) > 0) {
                    // Ya hay una ABIERTA hoy → no insertamos otra
                    throw new Exception('Ya existe una caja ABIERTA hoy para este usuario/departamento.');
                }
                $dtMx  = new DateTime('now', new DateTimeZone('America/Mexico_City'));
                $faMx  = $dtMx->format('Y-m-d H:i:s'); // fecha_apertura
                
                // Inserta nueva sesión ABIERTA

                $sqlInsert = "INSERT INTO caja_sesiones
                    (IdUsuario, Departamento, fecha_apertura, fecha_dia, saldo_inicial, estado)
                  VALUES
                    (:IdUsuario, :Departamento, :fecha_apertura, :fecha_dia, :saldo_inicial, :estado);
                ";

                $dataInsert = [
                  'IdUsuario'     => $this->IdUsuario,
                  'Departamento'  => $this->Departamento,
                  'fecha_apertura'=> $faMx,
                  'fecha_dia'     => $this->dia,            // o $this->dia si ya lo traes
                  'saldo_inicial' => $this->Saldoinicial,
                  'estado'        => 'ABIERTA',
                ];

                parent::query($sqlInsert, $dataInsert);

                // Devuelve la sesión recién abierta (la más reciente ABIERTA de ese día)
                $sqlGet = "
                    SELECT *
                    FROM caja_sesiones
                    WHERE IdUsuario = :IdUsuario
                    AND Departamento = :Departamento
                    AND estado = 'ABIERTA'
                    AND fecha_dia = :fecha_dia
                    ORDER BY idSesion DESC
                    LIMIT 1;
                ";
                return parent::query($sqlGet, $dataCheck) ?: false;

            } catch (Exception $e) {
                throw $e;
            }
        }



     /**
     * 
     * Metodo para cargar todo
     * @return void 
     */

    public function caja_session_today_model()
    {
        $sql = "SELECT *
            FROM caja_sesiones
            WHERE IdUsuario    = :IdUsuario
            AND Departamento = :Departamento
            AND estado       = 'ABIERTA'
            AND DATE(fecha_apertura) = CURDATE()
            LIMIT 1;";
            $data = [
            'IdUsuario'    => $this->IdUsuario,
            'Departamento' => $this->Departamento
            ];


        try {
            return ($rows = parent::query($sql, $data)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }



    /**
     * Ventana real de una sesión: [desde, hasta)
     * - desde  = caja_sesiones.fecha_apertura
     * - hasta  = caja_cierres.fecha_cierre (si existe) o NOW() si sigue abierta
     *  @return void 
     */

    public function getSesionVentana(int $idSesion): array
    {
        $sql = "
            SELECT
                s.fecha_apertura                                  AS desde,
                COALESCE(MAX(c.fecha_cierre), NOW())              AS hasta,
                s.IdUsuario, s.Departamento, s.fecha_dia
            FROM caja_sesiones s
            LEFT JOIN caja_cierres c ON c.idSesion = s.idSesion
            WHERE s.idSesion = :idSesion
            GROUP BY s.idSesion
            LIMIT 1;
        ";

        $row = parent::query($sql, ['idSesion' => $idSesion]);
        if (!$row || !isset($row[0]['desde'])) {
            return [];
        }
        return [
            'desde'        => $row[0]['desde'],
            'hasta'        => $row[0]['hasta'],
            'IdUsuario'    => $row[0]['IdUsuario']   ?? null,
            'Departamento' => $row[0]['Departamento']?? null,
            'fecha_dia'    => $row[0]['fecha_dia']   ?? null,
        ];
    }


     /**
     * 
     * Metodo para cargar todo
     * @return void 
     */

    public function caja_ordenes_hoy_model()
{

    $IdUsuario    = $this->IdUsuario ?? 0;
    $Departamento = $this->Departamento ?? 0;
    $idSesion     = $this->idSesion;

    // === RAMA 1: con idSesion => usamos [desde, hasta) que te devuelve getSesionVentana ===
    if ($idSesion > 0) {
        $win = $this->getSesionVentana($idSesion); // Debe devolver ['desde'=>'Y-m-d H:i:s','hasta'=>'Y-m-d H:i:s']
        if (!$win || empty($win['desde']) || empty($win['hasta'])) {
            return [];
        }

        $params = [
            'IdUsuario' => $IdUsuario,
            'desde'     => $win['desde'],
            'hasta'     => $win['hasta'],
        ];

        $sql = "
        /* ÓRDENES QUE CUENTAN A CAJA (11,12) */
        SELECT
          'CAJA' AS categoria,
          o.IdOrden,
          DATE_FORMAT(o.Fecha, '%Y-%m-%d %H:%i:%s') AS Fecha,
          c.IdCliente,
          c.Nombre AS cliente,
          c.FisTelefono AS telefono,
          c.FisEmail AS email,
          u.Usuario AS vendedor,
          CAST(COALESCE(tp.Descripcion, 'SinTipodePago') AS CHAR CHARACTER SET utf8mb4) COLLATE utf8mb4_unicode_ci AS tipo_pago,
          COALESCE(o.TipoPago,'') AS fid_pago,
          CAST('Pagado' AS CHAR CHARACTER SET utf8mb4) COLLATE utf8mb4_unicode_ci AS estatus_text,
          SUM(
            CASE WHEN od.Eliminado=0
                 THEN CASE WHEN COALESCE(o.Siniva,0)=0 THEN od.Neto * 1.16 ELSE od.Neto END
                 ELSE 0 END
          ) AS total
        FROM ordenes o
        JOIN ordenesdetalle od ON od.IdOrden = o.IdOrden
        JOIN clientes c        ON c.IdCliente = o.IdCliente
        LEFT JOIN usuarios u   ON u.IdUsuario = o.IdUsuario
        LEFT JOIN tipos_pago tp ON tp.FidPago = o.TipoPago
        WHERE o.IdUsuario = :IdUsuario
          AND o.Fecha >= :desde AND o.Fecha < :hasta
          AND o.Estatus IN (11,12)
        GROUP BY o.IdOrden, o.Fecha, c.IdCliente, c.Nombre, c.FisTelefono, c.FisEmail, u.Usuario, tp.Descripcion, o.TipoPago

        UNION ALL
        /* PAGO PARCIAL (informativo) */
        SELECT
          'PARCIAL' AS categoria,
          o.IdOrden,
          DATE_FORMAT(o.Fecha, '%Y-%m-%d %H:%i:%s') AS Fecha,
          c.IdCliente,
          c.Nombre AS cliente,
          c.FisTelefono AS telefono,
          c.FisEmail AS email,
          u.Usuario AS vendedor,
          CAST(COALESCE(tp.Descripcion, 'SinTipodePago') AS CHAR CHARACTER SET utf8mb4) COLLATE utf8mb4_unicode_ci AS tipo_pago,
          COALESCE(o.TipoPago,'') AS fid_pago,
          CAST('Pago Parcial' AS CHAR CHARACTER SET utf8mb4) COLLATE utf8mb4_unicode_ci AS estatus_text,
          SUM(
            CASE WHEN od.Eliminado=0
                 THEN CASE WHEN COALESCE(o.Siniva,0)=0 THEN od.Neto * 1.16 ELSE od.Neto END
                 ELSE 0 END
          ) AS total
        FROM ordenes o
        JOIN ordenesdetalle od ON od.IdOrden = o.IdOrden
        JOIN clientes c        ON c.IdCliente = o.IdCliente
        LEFT JOIN usuarios u   ON u.IdUsuario = o.IdUsuario
        LEFT JOIN tipos_pago tp ON tp.FidPago = o.TipoPago
        WHERE o.IdUsuario = :IdUsuario
          AND o.Fecha >= :desde AND o.Fecha < :hasta
          AND o.Estatus = 3
        GROUP BY o.IdOrden, o.Fecha, c.IdCliente, c.Nombre, c.FisTelefono, c.FisEmail, u.Usuario, tp.Descripcion, o.TipoPago

        UNION ALL
        /* CRÉDITO (informativo: Estatus=31 + TipoPago=99) */
        SELECT
          'CREDITO' AS categoria,
          o.IdOrden,
          DATE_FORMAT(o.Fecha, '%Y-%m-%d %H:%i:%s') AS Fecha,
          c.IdCliente,
          c.Nombre AS cliente,
          c.FisTelefono AS telefono,
          c.FisEmail AS email,
          u.Usuario AS vendedor,
          CAST(COALESCE(tp.Descripcion, 'SinTipodePago') AS CHAR CHARACTER SET utf8mb4) COLLATE utf8mb4_unicode_ci AS tipo_pago,
          COALESCE(o.TipoPago,'') AS fid_pago,
          CAST('Crédito' AS CHAR CHARACTER SET utf8mb4) COLLATE utf8mb4_unicode_ci AS estatus_text,
          SUM(
            CASE WHEN od.Eliminado=0
                 THEN CASE WHEN COALESCE(o.Siniva,0)=0 THEN od.Neto * 1.16 ELSE od.Neto END
                 ELSE 0 END
          ) AS total
        FROM ordenes o
        JOIN ordenesdetalle od ON od.IdOrden = o.IdOrden
        JOIN clientes c        ON c.IdCliente = o.IdCliente
        LEFT JOIN usuarios u   ON u.IdUsuario = o.IdUsuario
        LEFT JOIN tipos_pago tp ON tp.FidPago = o.TipoPago
        WHERE o.IdUsuario = :IdUsuario
          AND o.Fecha >= :desde AND o.Fecha < :hasta
          AND o.Estatus = 31
          AND COALESCE(o.TipoPago,'') = '99'
        GROUP BY o.IdOrden, o.Fecha, c.IdCliente, c.Nombre, c.FisTelefono, c.FisEmail, u.Usuario, tp.Descripcion, o.TipoPago

        ORDER BY Fecha DESC, IdOrden DESC;
        ";


        return parent::query($sql, $params) ?: [];
    }

    // === RAMA 2: sin idSesion => fallback por día [ini, fin) (sin usar fecha_cierre) ===
    $ini = $this->ini ?? date('Y-m-d 00:00:00');
    $fin =  $this->fin ?? date('Y-m-d 23:59:59');

    $params = [
        'IdUsuario' => $IdUsuario,
        'ini'       => $ini,
        'fin'       => $fin,
    ];

    $sql = "
    SELECT
      'CAJA' AS categoria,
      o.IdOrden,
      DATE_FORMAT(o.Fecha, '%Y-%m-%d %H:%i:%s') AS Fecha,
      c.IdCliente,
      c.Nombre AS cliente,
      c.FisTelefono AS telefono,
      c.FisEmail AS email,
      u.Usuario AS vendedor,
      CAST(COALESCE(tp.Descripcion, 'SinTipodePago') AS CHAR CHARACTER SET utf8mb4) COLLATE utf8mb4_unicode_ci AS tipo_pago,
      COALESCE(o.TipoPago,'') AS fid_pago,
      CAST('Pagado' AS CHAR CHARACTER SET utf8mb4) COLLATE utf8mb4_unicode_ci AS estatus_text,
      SUM(
        CASE WHEN od.Eliminado=0
             THEN CASE WHEN COALESCE(o.Siniva,0)=0 THEN od.Neto * 1.16 ELSE od.Neto END
             ELSE 0 END
      ) AS total
    FROM ordenes o
    JOIN ordenesdetalle od ON od.IdOrden = o.IdOrden
    JOIN clientes c        ON c.IdCliente = o.IdCliente
    LEFT JOIN usuarios u   ON u.IdUsuario = o.IdUsuario
    LEFT JOIN tipos_pago tp ON tp.FidPago = o.TipoPago
    WHERE o.IdUsuario = :IdUsuario
      AND o.Fecha >= :ini AND o.Fecha < :fin
      AND o.Estatus IN (11,12)
    GROUP BY o.IdOrden, o.Fecha, c.IdCliente, c.Nombre, c.FisTelefono, c.FisEmail, u.Usuario, tp.Descripcion, o.TipoPago

    UNION ALL

    SELECT
      'PARCIAL' AS categoria,
      o.IdOrden,
      DATE_FORMAT(o.Fecha, '%Y-%m-%d %H:%i:%s') AS Fecha,
      c.IdCliente,
      c.Nombre AS cliente,
      c.FisTelefono AS telefono,
      c.FisEmail AS email,
      u.Usuario AS vendedor,
      CAST(COALESCE(tp.Descripcion, 'SinTipodePago') AS CHAR CHARACTER SET utf8mb4) COLLATE utf8mb4_unicode_ci AS tipo_pago,
      COALESCE(o.TipoPago,'') AS fid_pago,
      CAST('Pago Parcial' AS CHAR CHARACTER SET utf8mb4) COLLATE utf8mb4_unicode_ci AS estatus_text,
      SUM(
        CASE WHEN od.Eliminado=0
             THEN CASE WHEN COALESCE(o.Siniva,0)=0 THEN od.Neto * 1.16 ELSE od.Neto END
             ELSE 0 END
      ) AS total
    FROM ordenes o
    JOIN ordenesdetalle od ON od.IdOrden = o.IdOrden
    JOIN clientes c        ON c.IdCliente = o.IdCliente
    LEFT JOIN usuarios u   ON u.IdUsuario = o.IdUsuario
    LEFT JOIN tipos_pago tp ON tp.FidPago = o.TipoPago
    WHERE o.IdUsuario = :IdUsuario
      AND o.Fecha >= :ini AND o.Fecha < :fin
      AND o.Estatus = 3
    GROUP BY o.IdOrden, o.Fecha, c.IdCliente, c.Nombre, c.FisTelefono, c.FisEmail, u.Usuario, tp.Descripcion, o.TipoPago

    UNION ALL

    SELECT
      'CREDITO' AS categoria,
      o.IdOrden,
      DATE_FORMAT(o.Fecha, '%Y-%m-%d %H:%i:%s') AS Fecha,
      c.IdCliente,
      c.Nombre AS cliente,
      c.FisTelefono AS telefono,
      c.FisEmail AS email,
      u.Usuario AS vendedor,
      CAST(COALESCE(tp.Descripcion, 'SinTipodePago') AS CHAR CHARACTER SET utf8mb4) COLLATE utf8mb4_unicode_ci AS tipo_pago,
      COALESCE(o.TipoPago,'') AS fid_pago,
      CAST('Crédito' AS CHAR CHARACTER SET utf8mb4) COLLATE utf8mb4_unicode_ci AS estatus_text,
      SUM(
        CASE WHEN od.Eliminado=0
             THEN CASE WHEN COALESCE(o.Siniva,0)=0 THEN od.Neto * 1.16 ELSE od.Neto END
             ELSE 0 END
      ) AS total
    FROM ordenes o
    JOIN ordenesdetalle od ON od.IdOrden = o.IdOrden
    JOIN clientes c        ON c.IdCliente = o.IdCliente
    LEFT JOIN usuarios u   ON u.IdUsuario = o.IdUsuario
    LEFT JOIN tipos_pago tp ON tp.FidPago = o.TipoPago
    WHERE o.IdUsuario = :IdUsuario
      AND o.Fecha >= :ini AND o.Fecha < :fin
      AND o.Estatus = 31
      AND COALESCE(o.TipoPago,'') = '99'
    GROUP BY o.IdOrden, o.Fecha, c.IdCliente, c.Nombre, c.FisTelefono, c.FisEmail, u.Usuario, tp.Descripcion, o.TipoPago

    ORDER BY Fecha DESC, IdOrden DESC;
    ";

    return parent::query($sql, $params) ?: [];
}




     /**
     * 
     * Metodo para cargar todo
     * @return void 
     */

    public function caja_eliminadas_hoy_model()
    {
        $sql = "WITH win AS (
  SELECT s.idSesion,
         s.fecha_apertura AS dtini,
         COALESCE(c.fecha_cierre, NOW()) AS dtfin
  FROM caja_sesiones s
  LEFT JOIN caja_cierres c ON c.idSesion = s.idSesion
  WHERE s.idSesion = :idSesion
),
limites AS (
  SELECT
    COALESCE(MIN(win.dtini), :ini) AS dtini,
    COALESCE(MAX(win.dtfin), :fin) AS dtfin
  FROM win
)
SELECT
  o.IdOrden,
  DATE_FORMAT(o.Fecha, '%Y-%m-%d %H:%i:%s') AS Fecha,
  c.IdCliente,
  c.Nombre AS cliente,
  u.Usuario AS vendedor,
  CAST(COALESCE(tp.Descripcion, 'SinTipodePago') AS CHAR CHARACTER SET utf8mb4) COLLATE utf8mb4_unicode_ci AS tipo_pago,
  CAST('Eliminada' AS CHAR CHARACTER SET utf8mb4) COLLATE utf8mb4_unicode_ci AS estatus_text,
  SUM(
    CASE WHEN od.Eliminado = 0
         THEN od.Neto * (CASE WHEN COALESCE(o.Siniva,0)=0 THEN 1.16 ELSE 1 END)
         ELSE 0 END
  ) AS total_referencia
FROM ordenes o
JOIN ordenesdetalle od ON od.IdOrden = o.IdOrden
LEFT JOIN clientes c   ON c.IdCliente = o.IdCliente
LEFT JOIN usuarios u   ON u.IdUsuario = o.IdUsuario
LEFT JOIN tipos_pago tp ON tp.FidPago = o.TipoPago
JOIN limites L
WHERE o.IdUsuario = :IdUsuario
  AND o.Fecha >= L.dtini AND o.Fecha < L.dtfin
  AND o.Estatus = 6
GROUP BY o.IdOrden, o.Fecha, c.IdCliente, c.Nombre, u.Usuario, tp.Descripcion
ORDER BY o.Fecha DESC, o.IdOrden DESC;

";
            $data = [
              'IdUsuario' => $this->IdUsuario,
              'ini'       => $this->ini,       // 'YYYY-mm-dd HH:ii:ss'
              'fin'       => $this->fin,       // 'YYYY-mm-dd HH:ii:ss'
              'idSesion'  => $this->idSesion ?? null
            ];


        try {
            return ($rows = parent::query($sql, $data)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }


     /**
     * 
     * Metodo para cargar todo
     * @return void 
     */

    public function caja_resumen_pagos_hoy_model()
    {
        $sql = "WITH ses AS (
  /* Ventana real de la sesión: [dtini, dtfin) */
  SELECT
    s.idSesion,
    s.fecha_apertura                              AS dtini,
    COALESCE(MAX(c.fecha_cierre), NOW())          AS dtfin
  FROM caja_sesiones s
  LEFT JOIN caja_cierres c ON c.idSesion = s.idSesion
  WHERE s.idSesion = :idSesion
  GROUP BY s.idSesion
),

/* SOLO cuentan a caja: órdenes pagadas (11,12) dentro de la ventana de la sesión */
pagadas AS (
  SELECT
    CAST(COALESCE(o.TipoPago,'') AS CHAR CHARACTER SET utf8mb4) COLLATE utf8mb4_unicode_ci AS fid,
    SUM(
      CASE WHEN od.Eliminado = 0
           THEN CASE WHEN COALESCE(o.Siniva,0)=0 THEN od.Neto*1.16 ELSE od.Neto END
           ELSE 0 END
    ) AS monto
  FROM ordenes o
  JOIN ordenesdetalle od ON od.IdOrden = o.IdOrden
  JOIN ses L
  WHERE o.IdUsuario = :IdUsuario
    AND o.Fecha >= L.dtini AND o.Fecha < L.dtfin
    AND o.Estatus IN (11,12)
  GROUP BY CAST(COALESCE(o.TipoPago,'') AS CHAR CHARACTER SET utf8mb4) COLLATE utf8mb4_unicode_ci
),

/* Informativo: Pago Parcial (no suma a caja) */
parciales AS (
  SELECT
    CAST(COALESCE(o.TipoPago,'') AS CHAR CHARACTER SET utf8mb4) COLLATE utf8mb4_unicode_ci AS fid,
    SUM(
      CASE WHEN od.Eliminado = 0
           THEN CASE WHEN COALESCE(o.Siniva,0)=0 THEN od.Neto*1.16 ELSE od.Neto END
           ELSE 0 END
    ) AS monto
  FROM ordenes o
  JOIN ordenesdetalle od ON od.IdOrden = o.IdOrden
  JOIN ses L
  WHERE o.IdUsuario = :IdUsuario
    AND o.Fecha >= L.dtini AND o.Fecha < L.dtfin
    AND o.Estatus = 3
  GROUP BY CAST(COALESCE(o.TipoPago,'') AS CHAR CHARACTER SET utf8mb4) COLLATE utf8mb4_unicode_ci
),

/* Informativo: Crédito (no suma a caja) — Estatus=31, TipoPago=99 */
credito AS (
  SELECT
    CAST(COALESCE(o.TipoPago,'') AS CHAR CHARACTER SET utf8mb4) COLLATE utf8mb4_unicode_ci AS fid,
    SUM(
      CASE WHEN od.Eliminado = 0
           THEN CASE WHEN COALESCE(o.Siniva,0)=0 THEN od.Neto*1.16 ELSE od.Neto END
           ELSE 0 END
    ) AS monto
  FROM ordenes o
  JOIN ordenesdetalle od ON od.IdOrden = o.IdOrden
  JOIN ses L
  WHERE o.IdUsuario = :IdUsuario
    AND o.Fecha >= L.dtini AND o.Fecha < L.dtfin
    AND o.Estatus = 31
    AND COALESCE(o.TipoPago,'') = '99'
  GROUP BY CAST(COALESCE(o.TipoPago,'') AS CHAR CHARACTER SET utf8mb4) COLLATE utf8mb4_unicode_ci
),

/* Manuales de la sesión (ENTRADA/SALIDA) dentro de la ventana de la sesión */
entradas_manual AS (
  SELECT
    CAST(COALESCE(m.TipoPago,'') AS CHAR CHARACTER SET utf8mb4) COLLATE utf8mb4_unicode_ci AS fid,
    SUM(m.monto) AS monto
  FROM caja_movimientos m
  JOIN ses L ON L.idSesion = m.idSesion
  WHERE m.idSesion = :idSesion
    AND m.tipo = 'ENTRADA'
    AND m.creado_en >= L.dtini AND m.creado_en < L.dtfin
  GROUP BY CAST(COALESCE(m.TipoPago,'') AS CHAR CHARACTER SET utf8mb4) COLLATE utf8mb4_unicode_ci
),

salidas_manual AS (
  SELECT
    CAST(COALESCE(m.TipoPago,'') AS CHAR CHARACTER SET utf8mb4) COLLATE utf8mb4_unicode_ci AS fid,
    SUM(m.monto) AS monto
  FROM caja_movimientos m
  JOIN ses L ON L.idSesion = m.idSesion
  WHERE m.idSesion = :idSesion
    AND m.tipo = 'SALIDA'
    AND m.creado_en >= L.dtini AND m.creado_en < L.dtfin
  GROUP BY CAST(COALESCE(m.TipoPago,'') AS CHAR CHARACTER SET utf8mb4) COLLATE utf8mb4_unicode_ci
),

keys_all AS (
  SELECT fid FROM pagadas
  UNION SELECT fid FROM entradas_manual
  UNION SELECT fid FROM salidas_manual
)

/* Bloque 1: CAJA (sí suma) */
SELECT
  'CAJA' AS categoria,
  COALESCE(tp.Descripcion, 'SinTipodePago') AS tipo_pago,
  COALESCE(p.monto,0)  AS total_pagadas,
  COALESCE(em.monto,0) AS entradas_manuales,
  COALESCE(sm.monto,0) AS salidas_manuales,
  COALESCE(p.monto,0) + COALESCE(em.monto,0) - COALESCE(sm.monto,0) AS total_caja_hoy
FROM keys_all k
LEFT JOIN pagadas         p  ON p.fid  = k.fid
LEFT JOIN entradas_manual em ON em.fid = k.fid
LEFT JOIN salidas_manual  sm ON sm.fid = k.fid
LEFT JOIN tipos_pago      tp ON tp.FidPago = k.fid

UNION ALL
/* Bloque 2: PARCIAL (solo informativo) */
SELECT
  'PARCIAL' AS categoria,
  COALESCE(tp2.Descripcion, 'SinTipodePago') AS tipo_pago,
  COALESCE(pa.monto,0) AS total_pagadas,
  0 AS entradas_manuales,
  0 AS salidas_manuales,
  0 AS total_caja_hoy
FROM parciales pa
LEFT JOIN tipos_pago tp2 ON tp2.FidPago = pa.fid

UNION ALL
/* Bloque 3: CREDITO (solo informativo) */
SELECT
  'CREDITO' AS categoria,
  COALESCE(tp3.Descripcion, 'SinTipodePago') AS tipo_pago,
  COALESCE(cr.monto,0) AS total_pagadas,
  0 AS entradas_manuales,
  0 AS salidas_manuales,
  0 AS total_caja_hoy
FROM credito cr
LEFT JOIN tipos_pago tp3 ON tp3.FidPago = cr.fid

ORDER BY FIELD(categoria,'CAJA','PARCIAL','CREDITO'), tipo_pago;

";
            $data = [
              'IdUsuario' => $this->IdUsuario,
              'idSesion'  => $this->idSesion ?? null
            ];


        try {
            return ($rows = parent::query($sql, $data)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }


     /**
     * 
     * Metodo para cargar todo
     * @return void 
     */

    public function caja_sin_tipo_hoy_model()
    {
        $sql = "WITH win AS (
  SELECT s.idSesion,
         s.fecha_apertura AS dtini,
         COALESCE(c.fecha_cierre, NOW()) AS dtfin
  FROM caja_sesiones s
  LEFT JOIN caja_cierres c ON c.idSesion = s.idSesion
  WHERE s.idSesion = :idSesion
),
limites AS (
  SELECT
    COALESCE(MIN(win.dtini), :ini) AS dtini,
    COALESCE(MAX(win.dtfin), :fin) AS dtfin
  FROM win
)
SELECT 
  o.IdOrden,
  DATE_FORMAT(o.Fecha, '%Y-%m-%d %H:%i:%s') AS Fecha,
  e.Descripcion AS NombreEstatus,
  SUM(
    CASE WHEN od.Eliminado = 0
         THEN od.Neto * (CASE WHEN COALESCE(o.Siniva,0)=0 THEN 1.16 ELSE 1 END)
         ELSE 0 END
  ) AS Total
FROM ordenes o
JOIN ordenesdetalle od ON od.IdOrden = o.IdOrden AND od.Eliminado = 0
LEFT JOIN estatus e     ON e.IdEstatus = o.Estatus
JOIN limites L
WHERE o.IdUsuario = :IdUsuario
  AND o.Fecha >= L.dtini AND o.Fecha < L.dtfin
  AND o.Estatus IN (11,12)
  AND (o.TipoPago IS NULL OR o.TipoPago = '')
GROUP BY o.IdOrden, o.Fecha, e.Descripcion
ORDER BY o.Fecha DESC, o.IdOrden DESC;
";
        $data = [
  'IdUsuario' => $this->IdUsuario,
  'ini'       => $this->ini,       // 'YYYY-mm-dd HH:ii:ss'
  'fin'       => $this->fin,       // 'YYYY-mm-dd HH:ii:ss'
  'idSesion'  => $this->idSesion ?? null
];



        try {
            return ($rows = parent::query($sql, $data)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }


     /**
     * 
     * Metodo para cargar todo
     * @return void 
     */

    public function caja_movs_hoy_model()
    {
        $sql = "SELECT
        m.idMovimiento,
        m.idSesion,
        m.tipo,
        m.origen,
        m.IdOrden,
        m.IdDetalle,
        m.concepto,
        m.TipoPago              AS fid_pago,
        COALESCE(tp.Descripcion,'SinTipodePago') AS tipo_pago,
        m.monto,
        m.creado_por,
        u.Usuario               AS creado_por_nombre,
        m.creado_en,
        DATE_FORMAT(m.creado_en, '%Y-%m-%d %H:%i:%s') AS creado_en_fmt
        FROM caja_movimientos m
        LEFT JOIN tipos_pago tp ON tp.FidPago = m.TipoPago
        LEFT JOIN usuarios u    ON u.IdUsuario = m.creado_por
        WHERE m.idSesion = :idSesion
        ORDER BY m.creado_en DESC, m.idMovimiento DESC;";


        try {
            return ($rows = parent::query($sql, ['idSesion' => $this->idSesion])) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }


     /**
     * 
     * Metodo para cargar todo
     * @return void 
     */

    public function caja_add_mov_model()
{
    $sql = "INSERT INTO caja_movimientos
        (idSesion, tipo, origen, IdOrden, IdDetalle, concepto, TipoPago, monto, creado_por)
        VALUES
        (:idSesion, :tipo, COALESCE(NULLIF(:origen,''),'MANUAL'), :IdOrden, :IdDetalle, :concepto, :TipoPago, :monto, :creado_por);";

    $data = [
        'idSesion'   => $this->idSesion,
        'tipo'       => $this->tipo,
        'origen'     => $this->origen,   // '' o null -> 'MANUAL'
        'IdOrden'    => $this->IdOrden,
        'IdDetalle'  => $this->IdDetalle,
        'concepto'   => $this->concepto,
        'TipoPago'   => $this->TipoPago, // 01,03,04,28,52,99...
        'monto'      => $this->monto,
        'creado_por' => $this->creado_por
    ];

    try {
        // 1) Inserta el movimiento y conserva el id insertado
        $idMov = parent::query($sql, $data);
        if (!$idMov) return false;

        // 2) Si es ORDEN, actualiza la orden con Estatus/TipoPago/PagadoCompleto
        $origen   = isset($this->origen) ? (string)$this->origen : (string)($_POST['origen'] ?? '');
        $IdOrden  = isset($this->IdOrden) ? (int)$this->IdOrden  : (int)($_POST['IdOrden'] ?? 0);
        $estatus  = isset($this->estatus) ? (int)$this->estatus  : (int)($_POST['estatus'] ?? 0); // 11, 12 o 25
        $tipoPago = isset($this->TipoPago) ? $this->TipoPago     : ($_POST['TipoPago'] ?? null);

        if (strcasecmp($origen, 'ORDEN') === 0 && $IdOrden > 0 && in_array($estatus, [11, 12, 25], true)) {
            // PagadoCompleto: 1 si 11/12 (pagado), 0 si 25 (pago contra entrega)
            $pagadoCompleto = in_array($estatus, [11, 12], true) ? 1 : 0;

            if ($tipoPago !== null && $tipoPago !== '') {
                // Actualiza también TipoPago si viene
                parent::query(
                    "UPDATE ordenes
                     SET Estatus = :est,
                         PagadoCompleto = :pc,
                         TipoPago = :tp
                     WHERE IdOrden = :id",
                    [
                        'est' => $estatus,
                        'pc'  => $pagadoCompleto,
                        'tp'  => $tipoPago,
                        'id'  => $IdOrden
                    ]
                );
            } else {
                // Sin cambiar TipoPago
                parent::query(
                    "UPDATE ordenes
                     SET Estatus = :est,
                         PagadoCompleto = :pc
                     WHERE IdOrden = :id",
                    [
                        'est' => $estatus,
                        'pc'  => $pagadoCompleto,
                        'id'  => $IdOrden
                    ]
                );
            }
        }

        // Devuelve el id del movimiento insertado (comportamiento original)
        return $idMov;

    } catch (Exception $e) {
        throw $e;
    }
}



     /**
     * 
     * Metodo para cargar todo
     * @return void 
     */

    public function caja_solicitar_cierre_model()
    {
        $sql = "INSERT INTO caja_solicitudes_cierre
            (idSesion, IdUsuario, resumen_json)
            VALUES
            (:idSesion, :IdUsuario, :resumen_json);";
            $data = [
            'idSesion'     => $this->idSesion,
            'IdUsuario'    => $this->IdUsuario,
            'resumen_json' => $this->resumen_json
            ];


        try {
            return ($rows = parent::query($sql, $data)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }


     /**
     * 
     * Metodo para cargar todo
     * @return void 
     */

    public function caja_listar_solicitudes_model()
    {
        $sql = "SELECT
            sc.*,
            u.Usuario,
            cs.Departamento,
            cs.saldo_inicial,
            cs.fecha_apertura
          FROM caja_solicitudes_cierre sc
          JOIN caja_sesiones cs ON cs.idSesion = sc.idSesion
          LEFT JOIN usuarios u   ON u.IdUsuario = sc.IdUsuario
          -- Ya NO filtramos solo PENDIENTE para poder ver RECHAZADAS (motivo) y APROBADAS
          ORDER BY sc.solicitado_en DESC
          LIMIT 100;
          ";


        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todo
     * @return void 
     */

    public function caja_aprobar_cierre_model()
{
    $idSolicitud  = $this->idSolicitud;
    $idSesion_in  = $this->idSesion;     // por seguridad desde el front
    $resuelto_por = $this->resuelto_por;
    $diffs_json   = $this->diffs_json;     // opcional (si el front lo manda)

    try {
        // ---------- TX ----------
        parent::query3("START TRANSACTION");

        // 1) Leer solicitud (aseguramos que esté PENDIENTE)
        $sqlS = "SELECT idSesion, IdUsuario, resumen_json, estado
                 FROM caja_solicitudes_cierre
                 WHERE idSolicitud = :id
                 FOR UPDATE";
        $rowS = parent::query3($sqlS, ['id' => $idSolicitud]);
        if (!$rowS) { throw new Exception('Solicitud no encontrada'); }

        if ($rowS[0]['estado'] !== 'PENDIENTE') {
            throw new Exception('La solicitud no está en estado PENDIENTE.');
        }

        $idSesion = (int)$rowS[0]['idSesion'];
        $IdUsuarioSolicitud = (int)$rowS[0]['IdUsuario'];
        if ($idSesion_in && $idSesion_in !== $idSesion) {
            // Si vino idSesion desde front y no coincide, nos quedamos con el de la solicitud
            $idSesion = $idSesion_in;
        }

        // 2) CONSOLIDACIÓN: mover movs de otras sesiones ABIERTAS del mismo usuario a esta sesión
  
        $sqlMove = "UPDATE caja_movimientos m
                    JOIN caja_sesiones s ON s.idSesion = m.idSesion
                    SET m.idSesion = :sid
                    WHERE s.IdUsuario = :uid
                      AND s.estado = 'ABIERTA'
                      AND s.idSesion <> :sid";
        parent::query3($sqlMove, ['sid'=>$idSesion, 'uid'=>$IdUsuarioSolicitud]);

        // 3) Poner a 0 saldo_inicial de esas sesiones previas ABIERTAS
        $sqlZero = "UPDATE caja_sesiones
                    SET saldo_inicial = 0
                    WHERE IdUsuario = :uid
                      AND estado = 'ABIERTA'
                      AND idSesion <> :sid";
        parent::query3($sqlZero, ['uid'=>$IdUsuarioSolicitud, 'sid'=>$idSesion]);

        // 4) Cerrar esas sesiones previas ABIERTAS (quedarán en 0)
        $sqlClosePrev = "UPDATE caja_sesiones
                         SET estado = 'CERRADA',
                             aprobado_por = :u,
                             aprobado_en  = NOW()
                         WHERE IdUsuario = :uid
                           AND estado = 'ABIERTA'
                           AND idSesion <> :sid";
        parent::query3($sqlClosePrev, ['u'=>$resuelto_por,'uid'=>$IdUsuarioSolicitud,'sid'=>$idSesion]);

        // 4b) Asegurar registro en caja_cierres para esas previas (si falta)
        $sqlInsPrev = "INSERT INTO caja_cierres
                          (idSesion, IdUsuario, Departamento, fecha_cierre, total_esperado, total_contado, diferencia, detalle_json)
                       SELECT s.idSesion, s.IdUsuario, s.Departamento, NOW(), 0, 0, 0,
                              CONCAT('Cierre automático por consolidación; consolidado_en=', :sid)
                       FROM caja_sesiones s
                       LEFT JOIN caja_cierres c ON c.idSesion = s.idSesion
                       WHERE s.IdUsuario = :uid
                         AND s.estado   = 'CERRADA'
                         AND s.idSesion <> :sid
                         AND c.idCierre IS NULL";
        parent::query3($sqlInsPrev, ['sid'=>$idSesion,'uid'=>$IdUsuarioSolicitud]);

        // 5) Cerrar la sesión aprobada
        $sqlCloseMain = "UPDATE caja_sesiones
                         SET estado = 'CERRADA',
                             aprobado_por = :u,
                             aprobado_en  = NOW()
                         WHERE idSesion = :sid";
        parent::query3($sqlCloseMain, ['u'=>$resuelto_por,'sid'=>$idSesion]);

        // --- 5c) Totales/Discrepancias desde resumen_json ---
        $resumen   = json_decode($rowS[0]['resumen_json'] ?? '{}', true);
        $esperado  = $resumen['esperado'] ?? [];
        $contado   = $resumen['contado']  ?? [];

        // Pairs para mapear esperado(contado)
        $pares = [
            ['Efectivo','efectivo'],
            ['Transferencia','transferencia'],
            ['Tarjeta Crédito','tarjeta_credito'],
            ['Tarjeta Débito','tarjeta_debito'],
            ['Cheque','cheque'],
            ['SinTipodePago','sintipodepago'],
        ];

        $totalEsp = 0.00;
        $totalCnt = 0.00;
        $diffs    = [];

        foreach ($pares as [$nom,$key]) {
            $exp = (float)($esperado[$nom] ?? 0);
            $got = (float)($contado[$key] ?? 0);
            $totalEsp += $exp;
            $totalCnt += $got;
            $delta = round($got - $exp, 2);
            if (abs($delta) > 0.009) {
                $diffs[] = ['tipo_pago'=>$nom,'esperado'=>$exp,'contado'=>$got,'delta'=>$delta];
            }
        }

        // Si el front mandó diffs_json, lo respetamos
        $front_diffs = json_decode($diffs_json, true);
        if (is_array($front_diffs) && count($front_diffs)) { $diffs = $front_diffs; }

        // 5d) Guardar/actualizar cierre principal para esta sesión
        // (para evitar duplicados: borramos posible registro previo y reinsertamos)
        parent::query3("DELETE FROM caja_cierres WHERE idSesion = :sid", ['sid'=>$idSesion]);

        $sqlC = "INSERT INTO caja_cierres
                    (idSesion, IdUsuario, Departamento, fecha_cierre, total_esperado, total_contado, diferencia, detalle_json)
                 SELECT s.idSesion, s.IdUsuario, s.Departamento, NOW(), :te, :tc, :df, :det
                 FROM caja_sesiones s
                 WHERE s.idSesion = :sid
                 LIMIT 1";
        parent::query3($sqlC, [
            'te'  => round($totalEsp, 2),
            'tc'  => round($totalCnt, 2),
            'df'  => round($totalCnt - $totalEsp, 2),
            'det' => json_encode($resumen, JSON_UNESCAPED_UNICODE),
            'sid' => $idSesion
        ]);

        // 5e) Guardar desglose por forma de pago en caja_discrepancias
        parent::query3("DELETE FROM caja_discrepancias WHERE idSesion=:sid AND idSolicitud=:sol", ['sid'=>$idSesion,'sol'=>$idSolicitud]);

        $sqlD = "INSERT INTO caja_discrepancias
                 (idSesion, idSolicitud, tipo_pago, esperado, contado, diferencia, creado_en, creado_por)
                 VALUES (:sid, :sol, :tipo, :esp, :cnt, :dif, NOW(), :u)";

        foreach ($pares as [$nom,$key]) {
            $exp = (float)($esperado[$nom] ?? 0);
            $got = (float)($contado[$key] ?? 0);
            $dif = round($got - $exp, 2);
            parent::query3($sqlD, [
                'sid' => $idSesion,
                'sol' => $idSolicitud,
                'tipo'=> $nom,
                'esp' => $exp,
                'cnt' => $got,
                'dif' => $dif,
                'u'   => $resuelto_por
            ]);
        }

        // 6) Marcar la solicitud como APROBADA (solo si estaba PENDIENTE)
        $sqlMark = "UPDATE caja_solicitudes_cierre
                    SET estado='APROBADA', resuelto_por=:u, resuelto_en=NOW()
                    WHERE idSolicitud=:ids AND estado='PENDIENTE'";
        parent::query3($sqlMark, ['u'=>$resuelto_por, 'ids'=>$idSolicitud]);

        parent::query3("COMMIT");
        return ['ok' => 1];

    } catch (Exception $e) {
        parent::query3("ROLLBACK");
        throw $e;
    }
}



    /**
     * 
     * Metodo para cargar todo
     * @return void 
     */

    public function caja_rechazar_cierre_model()
    {
        $sql = "UPDATE caja_solicitudes_cierre
            SET estado='RECHAZADA',
                resuelto_por=:resuelto_por,
                resuelto_en=NOW(),
                obs_supervisor=:obs
            WHERE idSolicitud=:idSolicitud
            AND estado='PENDIENTE';";
            $data = [
            'idSolicitud'  => $this->idSolicitud,
            'resuelto_por' => $this->resuelto_por,
            'obs'          => $this->obs_supervisor
            ];


        try {
            return ($rows = parent::query($sql, $data)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * Lista TODAS las sesiones ABIERTAS para el usuario+depto,
     * ordenadas por fecha de apertura ASC (de más antigua a más reciente).
     * Devuelve fechas formateadas y una marca "desde_ayer".
     */
    public function caja_sesiones_abiertas_model()
    {
        $sql = "SELECT
                cs.idSesion,
                cs.IdUsuario,
                cs.Departamento,
                DATE_FORMAT(cs.fecha_apertura, '%Y-%m-%d %H:%i:%s') AS fecha_apertura,
                cs.fecha_dia,
                cs.saldo_inicial,
                cs.estado,
                cs.aprobado_por,
                DATE_FORMAT(cs.aprobado_en, '%Y-%m-%d %H:%i:%s') AS aprobado_en,
                CASE WHEN DATE(cs.fecha_apertura) < CURDATE() THEN 1 ELSE 0 END AS desde_ayer
                FROM caja_sesiones cs
                WHERE cs.IdUsuario = :IdUsuario
                AND cs.Departamento = :Departamento
                AND cs.estado = 'ABIERTA'
                ORDER BY cs.fecha_apertura ASC;";

        $data = [
            'IdUsuario'    => $this->IdUsuario,
            'Departamento' => $this->Departamento
        ];

        try {
            return ($rows = parent::query($sql, $data)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }


    public function orden_actualizar_pago_manual_model(){
        $sql = "UPDATE ordenes
                SET PagadoCompleto = :PagadoCompleto,
                    TipoPago       = :TipoPago
                WHERE IdOrden      = :IdOrden;";
        $data = [
            'PagadoCompleto' => $this->PagadoCompleto, // 11, 12 o 3
            'TipoPago'       => $this->TipoPago,       // '01','03','04','02','28' o ''
            'IdOrden'        => $this->IdOrden
        ];
        try{
            return parent::query($sql, $data) !== false;
        }catch(Exception $e){
            throw $e;
        }
        }

        /**
 * Listar solicitudes de cierre RECHAZADAS (histórico)
 * Devuelve: sc.* + nombre del solicitante + datos de la sesión + nombre del que rechazó
 */
public function caja_listar_solicitudes_rechazadas_model()
{
    $sql = "SELECT 
                sc.*,
                u.Usuario                         AS Usuario,                -- solicitante
                cs.Departamento, 
                cs.saldo_inicial, 
                cs.fecha_apertura,
                su.Usuario                        AS resuelto_por_usuario    -- supervisor que rechazó
            FROM caja_solicitudes_cierre sc
            JOIN caja_sesiones cs     ON cs.idSesion   = sc.idSesion
            LEFT JOIN usuarios u      ON u.IdUsuario   = sc.IdUsuario
            LEFT JOIN usuarios su     ON su.IdUsuario  = sc.resuelto_por
            WHERE sc.estado = 'RECHAZADA'
            ORDER BY sc.resuelto_en DESC, sc.solicitado_en DESC;
    ";

    try {
        return ($rows = parent::query($sql)) ? $rows : false;
    } catch (Exception $e) {
        throw $e;
    }
}


// models/CajaModel.php
public function caja_last_discrepancia_model() {
    $IdUsuario = $this->IdUsuario ?? 0;

    // Trae el último cierre del usuario
    $sqlC = "SELECT c.idSesion, c.fecha_cierre, c.total_esperado, c.total_contado, c.diferencia
             FROM caja_cierres c
             WHERE c.IdUsuario = :u
             ORDER BY c.fecha_cierre DESC
             LIMIT 1";
    $rowC = parent::query($sqlC, ['u'=>$IdUsuario]);
    if (!$rowC) return [];

    $idSesion = (int)$rowC[0]['idSesion'];

    // Trae desglose (si existe)
    $sqlD = "SELECT d.tipo_pago, d.esperado, d.contado, d.diferencia
             FROM caja_discrepancias d
             WHERE d.idSesion = :sid";
    $rowsD = parent::query($sqlD, ['sid'=>$idSesion]) ?: [];

    // Solo mostramos si hay diferencia o filas en discrepancias
    if (abs((float)$rowC[0]['diferencia']) < 0.01 && empty($rowsD)) return [];

    return [
        'cierre' => $rowC[0],
        'items'  => $rowsD
    ];
}


public function caja_discrepancias_list_model() {
    $fini =  $this->ini ?? date('Y-m-01');
    $ffin = $this->fin ?? date('Y-m-d');
    $IdUsuario = $this->IdUsuario ?? 0; // opcional (0 = todos)

    $params = ['ini'=>$fini.' 00:00:00', 'fin'=>$ffin.' 23:59:59'];
    $userCond = '';
    if ($IdUsuario > 0) {
        $userCond = ' AND c.IdUsuario = :u ';
        $params['u'] = $IdUsuario;
    }

    $sql = "SELECT c.fecha_cierre, c.idSesion, c.IdUsuario, u.Usuario,
                   d.tipo_pago, d.esperado, d.contado, d.diferencia
            FROM caja_cierres c
            JOIN caja_discrepancias d ON d.idSesion = c.idSesion
            LEFT JOIN usuarios u ON u.IdUsuario = c.IdUsuario
            WHERE c.fecha_cierre BETWEEN :ini AND :fin
            $userCond
            ORDER BY c.fecha_cierre DESC, c.idSesion DESC";
    return parent::query($sql, $params) ?: [];
}

  public function caja_listar_solicitudes_hist_model() {
      // Para que el lunes veas las del sábado:
      $sql = "SELECT sc.*, u.Usuario, cs.Departamento, cs.saldo_inicial, cs.fecha_apertura
              FROM caja_solicitudes_cierre sc
              JOIN caja_sesiones cs ON cs.idSesion = sc.idSesion
              LEFT JOIN usuarios u ON u.IdUsuario = sc.IdUsuario
              WHERE sc.estado IN ('APROBADA','RECHAZADA')
                AND sc.solicitado_en >= (CURDATE() - INTERVAL 3 DAY)
              ORDER BY sc.solicitado_en DESC";
      return parent::query($sql) ?: [];
  }

  public function codi_get_sesion_pdf(){
      $sql =  $this->sentencia;

        try {
            return ($rows = parent::query3($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
          }
  }

  public function codi_get_cierre_solicitudes_pdf(){
      $sql =  $this->sentencia;

        try {
            return ($rows = parent::query3($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
          }
  }

  public function codi_get_caja_movi_pdf(){
      $sql =  $this->sentencia;

        try {
            return ($rows = parent::query3($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
          }
  }

  public function caja_last_cierre_model()
    {
        $IdUsuario = $this->IdUsuario;
        $sql = "SELECT c.idSesion
                FROM caja_cierres c
                INNER JOIN caja_sesiones s ON s.idSesion = c.idSesion
                WHERE s.IdUsuario = :IdUsuario
                ORDER BY c.fecha_cierre DESC
                LIMIT 1";
        $row = parent::query($sql, ['IdUsuario'=>$IdUsuario]);
        return $row ? $row[0] : [];
    }





}