<?php
class calendarioModel extends Model
{
    public $evntId;
    public $evntTipoServicio;
    public $IdDomicilioClte;
    public $IdCliente;
    public $DC3Cliente;
    public $IdVendedor;
    public $IdCotizaciones;
    public $IdOrden;
    public $evtNParticipantes;
    public $evtObservaciones;
    public $evntFechaInicio;
    public $evntHoraInicio;
    public $evntFechaFin;
    public $evntHoraFin;
    public $envtInstructores;
    public $evntEstatus;
    public $eventPartida;
    public $alimentos;
    public $transporte;
    public $Partidas;
    public $tamano;
    public $tamanodos;
    public $filtrocapacitaciones;
    public $fechainic;
    public $fechafin;
    public $datetentativo;


    /**
     * 
     * Metodo para agregar nuevo usuario
     * @return integer 
     */

    public function add()
    {
        $sql = "INSERT INTO calendario (evntId,evntTipoServicio,IdDomicilioClte,IdCliente,DC3Cliente,IdVendedor,IdOrden,evtNParticipantes,evtObservaciones,evntFechaInicio,evntHoraInicio,evntFechaFin,evntHoraFin,envtInstructores,evntEstatus,PartidaO, IdCotizacion, PartidaO2,alimentoscal ,transportecal) 
        VALUES (:evntId,:evntTipoServicio,:IdDomicilioClte,:IdCliente,:DC3Cliente,:IdVendedor,:IdOrden,:evtNParticipantes,:evtObservaciones,:evntFechaInicio,:evntHoraInicio,:evntFechaFin,:evntHoraFin,:envtInstructores,:evntEstatus,:PartidaO, :IdCotizacion, :PartidaO2, :alimentoscal, :transportecal)";
        $data =
            [
                'evntId' => 0,
                'evntTipoServicio' => $this->evntTipoServicio,
                'IdDomicilioClte' => $this->IdDomicilioClte,
                'IdCliente' => $this->IdCliente,
                'DC3Cliente' => $this->DC3Cliente,
                'IdVendedor' => $this->IdVendedor,
                'IdOrden' => $this->IdOrden,
                'evtNParticipantes' => $this->evtNParticipantes,
                'evtObservaciones' => $this->evtObservaciones,
                'evntFechaInicio' => $this->evntFechaInicio,
                'evntHoraInicio' => $this->evntHoraInicio,
                'evntFechaFin' => $this->evntFechaFin,
                'evntHoraFin' => $this->evntHoraFin,
                'envtInstructores' => $this->envtInstructores,
                'evntEstatus' => $this->evntEstatus,
                'PartidaO' => $this->eventPartida,
                'IdCotizacion' => 0,
                'PartidaO2' => $this->Partidas,
                'alimentoscal' => $this->alimentos,
                'transportecal' => $this->transporte,

            ];

        try {
            return ($this->evntId = parent::query($sql, $data)) ? $this->evntId : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para agregar nuevo usuario
     * @return integer 
     */

    public function add_cot()
    {
        $sql = "INSERT INTO calendario (evntId,evntTipoServicio,IdDomicilioClte,IdCliente,DC3Cliente,IdVendedor,IdOrden,evtNParticipantes,
        evtObservaciones,evntFechaInicio,evntHoraInicio,evntFechaFin,evntHoraFin,envtInstructores,evntEstatus,PartidaO, IdCotizacion, PartidaO2, alimentoscal, transportecal) 
        VALUES (:evntId,:evntTipoServicio,:IdDomicilioClte,:IdCliente,:DC3Cliente,:IdVendedor,:IdOrden,:evtNParticipantes,
        :evtObservaciones,:evntFechaInicio,:evntHoraInicio,:evntFechaFin,:evntHoraFin,:envtInstructores,:evntEstatus,:PartidaO, :IdCotizacion, :PartidaO2, :alimentoscal, :transportecal)";

        $data =
            [
                'evntId' => 0,
                'evntTipoServicio' => $this->evntTipoServicio,
                'IdDomicilioClte' => $this->IdDomicilioClte,
                'IdCliente' => $this->IdCliente,
                'DC3Cliente' => $this->DC3Cliente,
                'IdVendedor' => $this->IdVendedor,
                'IdOrden' => 0,
                'evtNParticipantes' => $this->evtNParticipantes,
                'evtObservaciones' => $this->evtObservaciones,
                'evntFechaInicio' => $this->evntFechaInicio,
                'evntHoraInicio' => $this->evntHoraInicio,
                'evntFechaFin' => $this->evntFechaFin,
                'evntHoraFin' => $this->evntHoraFin,
                'envtInstructores' => $this->envtInstructores,
                'evntEstatus' => $this->evntEstatus,
                'PartidaO' => $this->eventPartida,
                'IdCotizacion' => $this->IdOrden,
                'PartidaO2' => $this->Partidas,
                'alimentoscal' => $this->alimentos,
                'transportecal' => $this->transporte

            ];

        try {
            return ($this->evntId = parent::query($sql, $data)) ? $this->evntId : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para agregar nuevo usuario
     * @return integer 
     */

    public function update()
    {
        $sql = "UPDATE calendario SET evntTipoServicio=:evntTipoServicio,IdDomicilioClte=:IdDomicilioClte,IdCliente=:IdCliente,DC3Cliente=:DC3Cliente,IdVendedor=:IdVendedor,IdOrden=:IdOrden,evtNParticipantes=:evtNParticipantes, evtObservaciones=:evtObservaciones,evntFechaInicio=:evntFechaInicio,evntHoraInicio=:evntHoraInicio,evntFechaFin=:evntFechaFin,evntHoraFin=:evntHoraFin,envtInstructores=:envtInstructores,evntEstatus=:evntEstatus, PartidaO2 = :PartidaO2, alimentoscal= :alimentoscal, transportecal =:transportecal
         WHERE evntId=:evntId AND PartidaO=:PartidaO";

        $data =
            [
                'evntId' => $this->evntId,
                'evntTipoServicio' => $this->evntTipoServicio,
                'IdDomicilioClte' => $this->IdDomicilioClte,
                'IdCliente' => $this->IdCliente,
                'DC3Cliente' => $this->DC3Cliente,
                'IdVendedor' => $this->IdVendedor,
                'IdOrden' => $this->IdOrden,
                'evtNParticipantes' => $this->evtNParticipantes,
                'evtObservaciones' => $this->evtObservaciones,
                'evntFechaInicio' => $this->evntFechaInicio,
                'evntHoraInicio' => $this->evntHoraInicio,
                'evntFechaFin' => $this->evntFechaFin,
                'evntHoraFin' => $this->evntHoraFin,
                'envtInstructores' => $this->envtInstructores,
                'evntEstatus' => $this->evntEstatus,
                'PartidaO' => $this->eventPartida,
                'PartidaO2' => $this->Partidas,
                'alimentoscal' => $this->alimentos,
                'transportecal' => $this->transporte

            ];
        try {

            return ($this->evntId = parent::query($sql, $data)) ? $this->evntId : false;
        } catch (Exception $e) {
            throw $e;
        }
    }


    /**
     * 
     * Metodo para agregar nuevo usuario
     * @return integer 
     */

    public function update_en_orden()
    {
        $sql = "UPDATE calendario SET IdOrden = :IdOrden, evntFechaInicio = :evntFechaInicio, evntFechaFin = :evntFechaFin WHERE IdCotizacion = :IdCotizacion AND PartidaO = :PartidaO";

        $data =
            [
                'IdOrden' => $this->IdOrden,
                'evntFechaInicio' => $this->datetentativo,
                'evntFechaFin' => $this->datetentativo,
                'PartidaO' => $this->eventPartida,
                'IdCotizacion' => $this->IdCotizaciones
        
            ];

        try {

            return ($this->IdOrden = parent::query($sql, $data)) ? $this->IdOrden : false;
        } catch (Exception $e) {
            throw $e;
        }
    }


    /**
     * 
     * Metodo para cargar todos los usuarios
     * @return void 
     */

    public function all()
    {
        $filtrotipo = $this->filtrocapacitaciones;
        $textosql = "";
        if($filtrotipo == 1){
            $textosql = "AND c.IdCotizacion = 0";
        }else if($filtrotipo == 2){
            $textosql = "AND c.IdCotizacion != 0";;
        }
        //$sql = "SELECT * FROM calendario";
        $sql = "SELECT c.evntId AS id,c.PartidaO AS partida, CONCAT(c.evntId,' ',c.evntTipoServicio) AS title, CONCAT(c.evntFechaInicio,'T',c.evntHoraInicio) AS start, CONCAT(c.evntFechaFin,'T',c.evntHoraFin) AS end, 
		  (CASE 
        WHEN c.evntEstatus = 1 THEN 'fc-event-nuevo'
        WHEN c.evntEstatus = 2 THEN 'fc-event-danger'
        WHEN c.evntEstatus = 3 THEN 'fc-event-warning'
        WHEN c.evntEstatus = 4 THEN 'fc-event-success'
        ELSE 1
    END) AS className, c.evtObservaciones AS description 
        , c.evntId, c.evntTipoServicio, c.IdDomicilioClte, c.IdCliente, c.DC3Cliente, c.IdVendedor, c.IdOrden, c.evtNParticipantes, c.evtObservaciones, c.envtInstructores,
        c.evntFechaInicio, c.evntHoraInicio, c.evntFechaFin, c.evntHoraFin, c.evntEstatus,c.PartidaO2,c.alimentoscal,c.transportecal, t.Nombre, t.FisTelefono, t.FisEmail, 
        CONCAT('Domicilio: ',d.EntCalle,' #', d.EntNExt,' Int:', d.EntNInt,' Colonia ', d.EntColonia,' C.P. ', d.EntCP, ' ',d.EntMunicipio, ', ', d.EntEstado) AS Domicilio, 
        d.EntCruces, d.EntObservaciones, u.NombreUsuario, u.Usuario, o.FolioOrden FROM calendario c LEFT JOIN usuarios u ON c.IdVendedor = u.IdUsuario
        LEFT JOIN clientes t ON c.IdCliente = t.IdCliente LEFT JOIN domentregacltes d ON c.IdDomicilioClte = d.IdDomicilio LEFT JOIN ordenes o ON o.IdOrden = c.IdOrden WHERE c.evntEstatus!=0 $textosql";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los usuarios
     * @return void 
     */

    public function one()
    {
        //$sql = "SELECT * FROM calendario";
        $sql = "SELECT c.evntId AS id, CONCAT(c.evntId,' ',c.evntTipoServicio) AS title, CONCAT(c.evntFechaInicio,'T',c.evntHoraInicio) AS start,
         CONCAT(c.evntFechaFin,'T',c.evntHoraFin) AS end, 'fc-event-info' AS className, c.evtObservaciones AS description 
         , c.evntId, c.evntTipoServicio, c.IdDomicilioClte, c.IdCliente, c.DC3Cliente, c.IdVendedor, c.IdOrden, c.evtNParticipantes, c.evtObservaciones, c.envtInstructores,
         c.evntFechaInicio, c.evntHoraInicio, c.evntFechaFin, c.evntHoraFin, c.evntEstatus, t.Nombre, t.FisTelefono, t.FisEmail, 
         CONCAT('Domicilio: ',d.EntCalle,' #', d.EntNExt,' Int:', d.EntNInt,' Colonia ', d.EntColonia,' C.P. ', d.EntCP, ' ',d.EntMunicipio, ', ', d.EntEstado) AS Domicilio, 
         d.EntCruces, d.EntObservaciones, u.NombreUsuario, u.Usuario, o.FolioOrden FROM calendario c LEFT JOIN usuarios u ON c.IdVendedor = u.IdUsuario
         LEFT JOIN clientes t ON c.IdCliente = t.IdCliente LEFT JOIN domentregacltes d ON c.IdDomicilioClte = d.IdDomicilio LEFT JOIN ordenes o ON o.IdOrden = c.IdOrden WHERE c.evntId=:evntId;";
        try {
            return ($rows = parent::query($sql, ['evntId' => $this->evntId])) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los usuarios
     * @return void 
     */

    public function todos_eventos_clientes()
    {
        $fechaini = $this->fechainic ? $this->fechainic : date("Y-m-01");
        $fechafin = $this->fechafin ? $this->fechafin : date("Y-m-d");
        $fechafinal = "AND c.evntFechaInicio BETWEEN  '$fechaini' AND  '$fechafin'";
        //$sql = "SELECT * FROM calendario";
        $sql = "SELECT c.evntId AS id, CONCAT(c.evntId,' ',c.evntTipoServicio) AS title, CONCAT(c.evntFechaInicio,'T',c.evntHoraInicio) AS start,
         CONCAT(c.evntFechaFin,'T',c.evntHoraFin) AS end, 'fc-event-info' AS className, c.evtObservaciones AS description 
         , c.evntId, c.evntTipoServicio, c.IdDomicilioClte, c.IdCliente, c.DC3Cliente, c.IdVendedor, c.IdOrden, c.evtNParticipantes, c.evtObservaciones, c.envtInstructores,
         c.evntFechaInicio, c.evntHoraInicio, c.evntFechaFin, c.evntHoraFin, c.evntEstatus, t.Nombre, t.FisTelefono, t.FisEmail, 
         CONCAT('Domicilio: ',d.EntCalle,' #', d.EntNExt,' Int:', d.EntNInt,' Colonia ', d.EntColonia,' C.P. ', d.EntCP, ' ',d.EntMunicipio, ', ', d.EntEstado) AS Domicilio, 
         d.EntCruces, d.EntObservaciones, u.NombreUsuario, u.Usuario, o.FolioOrden FROM calendario c LEFT JOIN usuarios u ON c.IdVendedor = u.IdUsuario
         LEFT JOIN clientes t ON c.IdCliente = t.IdCliente LEFT JOIN domentregacltes d ON c.IdDomicilioClte = d.IdDomicilio LEFT JOIN ordenes o ON o.IdOrden = c.IdOrden WHERE c.IdCliente=:IdCliente $fechafinal";
        try {
            return ($rows = parent::query($sql, ['IdCliente' => $this->IdCliente])) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para actualizar un registro de la bd
     * @return bool 
     */

    public function delete()
    {
        $tamano = $this->tamano;
        $tamano2 = $this->tamanodos;
        $sql = "UPDATE calendario SET evntEstatus=:evntEstatus WHERE evntId=:evntId";
        $sql2 = "UPDATE ordenesdetalle SET agendaCap=:agendaCap WHERE IdOrden=:IdOrden AND Partida=:Partida";
        $data =
            [
                'evntEstatus' => 0,
                'evntId' => $this->evntId,
            ];

            $data2 =
            [
                'agendaCap' => 0,
                'IdOrden' => $this->IdOrden,
                'Partida' => $this->eventPartida,
            ];
        try {
            if($tamano == $tamano2){
                parent::query($sql2, $data2);
                return (parent::query($sql, $data)) ? true : false;
            }else{
                return (parent::query($sql2, $data2)) ? true : false;
            }
            
        } catch (Exception $e) {
            throw $e;
        }
    }
}
