<?php
class clientesModel extends Db
{
    public $IdCliente;
    public $Nombre;
    public $RFC;
    public $FisTelefono;
    public $FisEmail;
    public $moroso;

    public $Persona;
    public $CFDI;
    public $RegimenFiscal;
    public $TipoPago;
    //Domicilio Fiscal
    public $FisCalle;
    public $FisNExt;
    public $FisNInt;
    public $FisColonia;
    public $FisCP;
    public $FisMunicipio;
    public $FisEstado;
    //Domicilio Entrega
    public $IdDomicilio;
    public $EntCalle;
    public $EntNExt;
    public $EntNInt;
    public $EntColonia;
    public $EntCP;
    public $EntMunicipio;
    public $EntEstado;
    public $EntGiro;
    public $EntDesde;
    public $EntHasta;
    public $EntCruces;
    public $EntObservaciones;
    public $numdomicilio;
    public $busqueda;

    public $activo;
    /**
     * 
     * Metodo para agregar nuevo usuario
     * @return integer 
     */

    public function add()
    {
        $sql = "INSERT INTO clientes (Nombre, Clave, RFC, Persona, CFDI, RegimenFiscal, TipoPago, FisTelefono, FisEmail, FisCalle, FisNExt, FisNInt, FisColonia, FisCP, FisMunicipio, FisEstado, Activo) 
        VALUES (:Nombre, :Clave, :RFC, :Persona, :CFDI, :RegimenFiscal, :TipoPago, :FisTelefono, :FisEmail, :FisCalle, :FisNExt, :FisNInt, :FisColonia, :FisCP, :FisMunicipio, :FisEstado, :Activo)";
        $data =
            [
                'Nombre' => $this->Nombre,
                'Clave' => random_strings(8),
                'RFC' => $this->RFC,
                'Persona' => $this->Persona,
                'CFDI' => $this->CFDI,
                'RegimenFiscal' => $this->RegimenFiscal,
                'TipoPago' => $this->TipoPago,
                'FisTelefono' => $this->FisTelefono,
                'FisEmail' => $this->FisEmail,
                'FisCalle' => $this->FisCalle,
                'FisNExt' => $this->FisNExt,
                'FisNInt' => $this->FisNInt,
                'FisColonia' => $this->FisColonia,
                'FisCP' => $this->FisCP,
                'FisMunicipio' => $this->FisMunicipio,
                'FisEstado' => $this->FisEstado,
                'Activo' => 1,
            ];

        try {
            return ($this->IdCliente = parent::query($sql, $data)) ? $this->IdCliente : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

     /**
     * 
     * Metodo para cargar todos los usuarios
     * @return void 
     */

 
    public function rfc()
    {
        $sql = "SELECT c.IdCliente, c.RFC,c.Nombre FROM clientes c WHERE c.RFC = '$this->RFC'";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    public function add_domicilio()
    {   $Contardomicilio = $this->numdomicilio;

        if($Contardomicilio == 0 || $Contardomicilio == null || $Contardomicilio == ""){
            $Contardomicilio = 1;
        }else{
            $Contardomicilio = $Contardomicilio + 1;
        }
        
        $sql = "INSERT INTO domentregacltes (IdCliente, NumDomicilio, EntCalle, EntNExt, EntNInt, EntColonia, EntCP, EntMunicipio, EntEstado, EntGiro, EntDesde, EntHasta, EntCruces, EntObservaciones) 
        VALUES (:IdCliente, :NumDomicilio, :EntCalle, :EntNExt, :EntNInt, :EntColonia, :EntCP, :EntMunicipio, :EntEstado, :EntGiro, :EntDesde, :EntHasta, :EntCruces, :EntObservaciones)";
        $data =
            [
                'IdCliente' => $this->IdCliente,
                'NumDomicilio' => $Contardomicilio,
                'EntCalle' => $this->EntCalle,
                'EntNExt' => $this->EntNExt,
                'EntNInt' => $this->EntNInt,
                'EntColonia' => $this->EntColonia,
                'EntCP' => $this->EntCP,
                'EntMunicipio' => $this->EntMunicipio,
                'EntEstado' => $this->EntEstado,
                'EntGiro' => $this->EntGiro,
                'EntDesde' => $this->EntDesde,
                'EntHasta' => $this->EntHasta,
                'EntCruces' => $this->EntCruces,
                'EntObservaciones' => $this->EntObservaciones,
            ];

        try {
            return ($this->IdDomicilio = parent::query($sql, $data)) ? $this->IdDomicilio : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los usuarios
     * @return void 
     */

    public function all()
    {
        $sql = "SELECT c.IdCliente,c.Nombre,c.Clave,c.Clave, c.RFC, c.Persona, c.CFDI, c.RegimenFiscal, c.TipoPago, c.FisTelefono, c.FisEmail, c.FisCalle,c.FisNExt,c.FisNInt,
        c.FisColonia, c.FisCP, c.FisMunicipio, c.FisEstado, d.IdDomicilio, d.EntCalle, d.EntNExt, d.EntNInt, d.EntColonia, d.EntCP,
        d.EntMunicipio, d.EntEstado, d.EntGiro, d.EntDesde, d.EntHasta, d.EntCruces, d.EntObservaciones, g.Descripcion
         FROM clientes c LEFT JOIN domentregacltes d ON  d.IdCliente = c.IdCliente  LEFT JOIN giros g ON d.EntGiro = g.IdGiro 
         WHERE c.activo=1 AND d.NumDomicilio = 1 ORDER BY c.IdCliente";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }


    /**
     * 
     * Metodo para cargar todos los usuarios
     * @return void 
     */

    public function all_dom()
    {
        $sql = "SELECT * FROM domentregacltes WHERE IdCliente = $this->IdCliente";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los usuarios
     * @return void 
     */

    public function one_dom()
    {
        $sql = "SELECT * FROM domentregacltes WHERE IdDomicilio = $this->IdDomicilio";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los usuarios
     * @return void 
     */

    public function all2()
    {  
         $dbDetails = array(
            'host' => DB_HOST,
            'user'=> DB_USER,
            'pass'=> DB_PASS,
            'db' => DB_NAME
         );

         $table = <<<EOT
            (
            SELECT 
            c.IdCliente,
            c.Nombre,
            c.Clave,
            c.RFC,
            c.Persona,
            c.CFDI,
            c.RegimenFiscal,
            c.TipoPago,
            c.FisTelefono,
            c.FisEmail,
            c.FisCalle,
            c.FisNExt,
            c.FisNInt,
            c.FisColonia,
            c.FisCP,
            c.FisMunicipio,
            c.FisEstado,
            c.Activo,
            d.IdDomicilio,
            d.EntCalle,
            d.EntNExt,
            d.EntNInt,
            d.EntColonia,
            d.EntCP,
            d.EntMunicipio,
            d.EntEstado,
            d.EntGiro,
            d.EntDesde,
            d.EntHasta,
            d.EntCruces,
            d.EntObservaciones,
            g.Descripcion
            FROM clientes c
            LEFT JOIN domentregacltes d ON  d.IdCliente = c.IdCliente
            LEFT JOIN giros g ON d.EntGiro = g.IdGiro
            WHERE c.Activo=1
            AND d.NumDomicilio = 1
            ORDER BY c.IdCliente) temp
            EOT;

         $primaryKey = 'IdCliente';

         $columns = array(
            array('db' => 'IdCliente', 'dt' => 'IdCliente'),
            array('db' => 'Nombre', 'dt' => 'Nombre'),
            array('db' => 'RFC',  'dt' => 'RFC'),
            array('db' => 'FisEmail',   'dt' => 'FisEmail'),
            array('db' => 'FisTelefono',     'dt' => 'FisTelefono'),
            array('db' => 'FisMunicipio',     'dt' => 'FisMunicipio'),
            array('db' => 'Clave',     'dt' => 'Clave'),
            array('db' => 'Persona',     'dt' => 'Persona'),
            array('db' => 'CFDI',     'dt' => 'CFDI'),
            array('db' => 'RegimenFiscal',     'dt' => 'RegimenFiscal'),
            array('db' => 'TipoPago',     'dt' => 'TipoPago'),
            array('db' => 'FisCalle',     'dt' => 'FisCalle'),
            array('db' => 'FisNExt',     'dt' => 'FisNExt'),
            array('db' => 'FisNInt',     'dt' => 'FisNInt'),
            array('db' => 'FisColonia',     'dt' => 'FisColonia'),
            array('db' => 'FisCP',     'dt' => 'FisCP'),
            array('db' => 'FisMunicipio',     'dt' => 'FisMunicipio'),
            array('db' => 'FisEstado',     'dt' => 'FisEstado'),
            array('db' => 'Activo',     'dt' => 'Activo'),
            array('db' => 'IdDomicilio',     'dt' => 'IdDomicilio'),
            array('db' => 'EntCalle',     'dt' => 'EntCalle'),
            array('db' => 'EntNExt',     'dt' => 'EntNExt'),
            array('db' => 'EntNInt',     'dt' => 'EntNInt'),
            array('db' => 'EntColonia',     'dt' => 'EntColonia'),
            array('db' => 'EntCP',     'dt' => 'EntCP'),
            array('db' => 'EntMunicipio',     'dt' => 'EntMunicipio'),
            array('db' => 'EntEstado',     'dt' => 'EntEstado'),
            array('db' => 'EntDesde',     'dt' => 'EntDesde'),
            array('db' => 'EntHasta',     'dt' => 'EntHasta'),
            array('db' => 'EntCruces',     'dt' => 'EntCruces'),
            array('db' => 'EntObservaciones',     'dt' => 'EntObservaciones'),
            array('db' => 'Descripcion',     'dt' => 'Descripcion'),
        );

        return json_encode(
            parent::simple($_POST, $dbDetails, $table, $primaryKey, $columns)
        );
    }

    /**
     * 
     * Metodo para cargar un registro usando su id
     * @return void 
     */

    public function one()
    {
        $sql = "SELECT c.*, d.IdDomicilio, d.EntCalle, d.EntNExt, d.EntNInt, d.EntColonia, d.EntCP,
        d.EntMunicipio, d.EntEstado, d.EntGiro, d.EntDesde, d.EntHasta, d.EntCruces, d.EntObservaciones, g.Descripcion
         FROM clientes c LEFT JOIN domentregacltes d ON  d.IdCliente = c.IdCliente  LEFT JOIN giros g ON d.EntGiro = g.IdGiro 
         WHERE d.NumDomicilio = 1 AND c.IdCliente=:IdCliente LIMIT 1";
        try {
            return ($rows = parent::query($sql, ['IdCliente' => $this->IdCliente])) ? $rows[0] : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar un registro usando su id
     * @return void 
     */

    public function one_busqueda()
    {   
        $sql = "";
        $rfc = $this->RFC ? $this->RFC : "";
        $nombre = $this->Nombre ? $this->Nombre : "";
        if($rfc != "" AND $nombre == ""){
             $sql = "SELECT * FROM `clientes` WHERE `RFC`='$rfc'";
        }
        if($rfc == "" AND $nombre != ""){
             $sql = "SELECT * FROM `clientes` WHERE `Nombre` LIKE '%$nombre%'";
        }

        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar un registro usando su id
     * @return void 
     */

    public function onekeyup()
    {
        $sql = "SELECT c.*, d.IdDomicilio, d.EntCalle, d.EntNExt, d.EntNInt, d.EntColonia, d.EntCP,
        d.EntMunicipio, d.EntEstado, d.EntGiro, d.EntDesde, d.EntHasta, d.EntCruces, d.EntObservaciones, g.Descripcion
         FROM clientes c LEFT JOIN domentregacltes d ON  d.IdCliente = c.IdCliente  LEFT JOIN giros g ON d.EntGiro = g.IdGiro 
         WHERE d.NumDomicilio = 1 AND c.Nombre LIKE '%$this->Nombre%' AND c.Activo != 0 ";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }


    /**
     * 
     * Metodo para actualizar un registro de la bd
     * @return bool 
     */

    public function update()
    {
        $sql = "UPDATE clientes SET 
        Nombre=:Nombre, RFC=:RFC, Persona=:Persona, CFDI=:CFDI, RegimenFiscal=:RegimenFiscal, TipoPago=:TipoPago,  
        FisTelefono=:FisTelefono,FisEmail=:FisEmail, FisCalle=:FisCalle, FisNExt=:FisNExt, FisNInt=:FisNInt, 
        FisColonia=:FisColonia, FisCP=:FisCP, FisMunicipio=:FisMunicipio, FisEstado=:FisEstado
        WHERE IdCliente=:IdCliente";
        $data =
            [
                'Nombre' => $this->Nombre,
                'RFC' => $this->RFC,
                'Persona' => $this->Persona,
                'CFDI' => $this->CFDI,
                'RegimenFiscal' => $this->RegimenFiscal,
                'TipoPago' => $this->TipoPago,
                'FisTelefono' => $this->FisTelefono,
                'FisEmail' => $this->FisEmail,
                'FisCalle' => $this->FisCalle,
                'FisNExt' => $this->FisNExt,
                'FisNInt' => $this->FisNInt,
                'FisColonia' => $this->FisColonia,
                'FisCP' => $this->FisCP,
                'FisMunicipio' => $this->FisMunicipio,
                'FisEstado' => $this->FisEstado,
                'IdCliente' => $this->IdCliente,
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    public function update_domicilio()
    {
        $sql = "UPDATE domentregacltes SET 
        EntCalle=:EntCalle, EntNExt=:EntNExt, EntNInt=:EntNInt, 
        EntColonia=:EntColonia, EntCP=:EntCP, EntMunicipio=:EntMunicipio, EntEstado=:EntEstado, 
        EntGiro=:EntGiro, EntDesde=:EntDesde, EntHasta=:EntHasta, EntCruces=:EntCruces,EntObservaciones=:EntObservaciones
        WHERE IdDomicilio=:IdDomicilio";
        $data =
            [
                'EntCalle' => $this->EntCalle,
                'EntNExt' => $this->EntNExt,
                'EntNInt' => $this->EntNInt,
                'EntColonia' => $this->EntColonia,
                'EntCP' => $this->EntCP,
                'EntMunicipio' => $this->EntMunicipio,
                'EntEstado' => $this->EntEstado,
                'EntGiro' => $this->EntGiro,
                'EntDesde' => $this->EntDesde,
                'EntHasta' => $this->EntHasta,
                'EntCruces' => $this->EntCruces,
                'EntObservaciones' => $this->EntObservaciones,
                'IdDomicilio' => $this->IdDomicilio,
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }


    /**
     * 
     * Metodo para actualizar un registro de la bd
     * @return bool 
     */

    public function updatemoroso()
    {
        $sql = "UPDATE clientes SET Moroso=:Moroso WHERE IdCliente=:IdCliente";
        $data =
            [   'IdCliente' => $this->IdCliente,
                'Moroso' => $this->moroso
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    public function buscaronline()
{
    $busqueda = isset($_POST['q']) ? trim($_POST['q']) : '';
    if ($busqueda === '') { return false; }

    $sql = "
        SELECT
            c.IdCliente,
            c.Nombre AS Cliente,
            u.IdUsuario,
            u.Usuario       AS Usuario,   -- 👈 nombre que se mostrará en UI
            u.Telefono,
            u.Correo
        FROM clientes c
        LEFT JOIN (
            SELECT o1.IdCliente, o1.IdUsuario
            FROM ordenes o1
            JOIN (
                SELECT IdCliente, MAX(Fecha) AS MaxFecha
                FROM ordenes
                GROUP BY IdCliente
            ) ult
              ON ult.IdCliente = o1.IdCliente
             AND ult.MaxFecha  = o1.Fecha
        ) lo  ON lo.IdCliente = c.IdCliente
        LEFT JOIN usuarios u ON u.IdUsuario = lo.IdUsuario
        WHERE c.Activo = 1
          AND (
                c.RFC LIKE CONCAT('%', :q, '%')
             OR c.Nombre LIKE CONCAT('%', :q, '%')
             OR CAST(c.IdCliente AS CHAR) LIKE CONCAT('%', :q, '%')
          )
        ORDER BY c.Nombre
        LIMIT 10;
    ";

    try {
        return ($rows = parent::query($sql, [':q' => $busqueda])) ? $rows : false;
    } catch (Exception $e) {
        throw $e;
    }
}


    /**
     * 
     * Metodo para actualizar un registro de la bd
     * @return bool 
     */

    public function delete()
    {

        $sql = "UPDATE clientes SET Activo=:activo WHERE IdCliente=:IdCliente";
        $data =
            [
                'activo' => $this->activo,
                'IdCliente' => $this->IdCliente
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }
}
