<?php
class comprasModel extends Model
{
    public $id;
    public $descripcion;
    public $precio;
    public $cantidad;
    public $idOrden;
    public $idProveedor;
    public $estado;
    public $monto;
    public $montoj;
    public $fecha;
    public $tipoPago;
    public $coutas;
    public $inicioPago;
    public $finPago;
    public $recibido;
    public $departamento;
    public $aprobada;
    public $filas;
    public $iddetalle;
    public $partida;
    public $numeroprov;
    public $filename;
    public $temppath;
    public $tipo;
    public $variosprov;
    public $eliminado;
    public $idordenoriginal;
    public $sentencia;

    public function all()
    {
        $sql = "SELECT c.id, c.descripcion, c.idOrden, c.precio, c.cantidad,c.estado, c.tipoPago, c.estatus, c.aprobada, c.FacturaPdf, c.FacturaXml, c.variosprov, x.DeptoDescripcion FROM compras c LEFT JOIN departamentos x ON c.departamento = x.IdDepto WHERE c.estatus NOT IN (3)";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar un producto
     * @return void 
     */
    public function add()
    {
    
        $sql = "INSERT INTO compras (descripcion, idProveedor, idOrden, cantidad, precio, monto, estado, fecha, tipoPago, coutas, inicioPago, finPago, departamento, aprobada, variosprov) VALUES 
        (:descripcion,:idProveedor, :idOrden, :cantidad, :precio, :monto,:estado, :fecha, :tipoPago, :coutas, :inicioPago, :finPago, :departamento, :aprobada, :variosprov)";
        $data =
            [
                'idOrden' => $this->idOrden,
                'idProveedor' => $this->idProveedor,
                'descripcion' => $this->descripcion,
                'cantidad' => $this->cantidad,
                'precio' => $this->precio,
                'monto' => $this->montoj,
                'estado' => $this->estado,
                'fecha' => $this->fecha,
                'tipoPago' => $this->tipoPago,
                'coutas' => $this->coutas,
                'inicioPago' => $this->inicioPago,
                'finPago' => $this->finPago,
                'departamento' => $this->departamento,
                'aprobada' => $this->aprobada,
                'variosprov' => $this->variosprov
            ];

            

        try {
            return ($this->id = parent::query($sql, $data)) ? $this->id : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    public function one()
    {
        $sql = "SELECT * FROM compras c LEFT JOIN departamentos d ON c.departamento = d.IdDepto WHERE id = :id";

        if($this->idordenoriginal == 0){
            $sql2 = "SELECT D.*,p.*, v.nombre, c.idOrden FROM comprasDetalle D INNER JOIN productos p ON p.proId = D.idProducto INNER JOIN proveedores v ON v.id = D.idProveedor INNER JOIN compras c ON c.id = D.idCompra WHERE D.idCompra = :id";
        }else{
            $sql2 = "SELECT D.*,p.*, v.nombre, od.Eliminado,od.Partida, c.idOrden FROM comprasDetalle D INNER JOIN productos p ON p.proId = D.idProducto INNER JOIN proveedores v ON v.id = D.idProveedor INNER JOIN compras c ON c.id = D.idCompra INNER JOIN ordenesdetalle od ON c.idOrden = od.IdOrden WHERE idCompra = :id AND od.Partida = D.partida";
        }
        
        
        try {
            $compra = parent::query($sql, ['id' => $this->id]);

            $proveedor = $compra[0]['idProveedor'];
            $idOrden = $compra[0]['idOrden'];
            $sqlProveedor = "SELECT * FROM proveedores WHERE id = '$proveedor' ";
            $sqlTodosProv = "SELECT * FROM proveedores WHERE 1 ";
            $ganancia = "SELECT * FROM ganancia WHERE 1 ";
            $sqlOrden = "SELECT * FROM ordenes WHERE IdOrden = '$idOrden'";
            $compraDetalle = parent::query($sql2, ['id' => $this->id]);
            $selectProveedor = parent::query($sqlProveedor);
            $selectOrden = parent::query($sqlOrden);
            $selectprovtodos = parent::query($sqlTodosProv);
            $selectganancia = parent::query($ganancia);
            $compra[0]['ganancia'] = $selectganancia;
            $compra[0]['todoprov'] = $selectprovtodos;
            $compra[0]['detalleCompra'] = $compraDetalle;
            $compra[0]['idProveedor'] = $selectProveedor[0] ? $selectProveedor[0]: 1;
            $compra[0]['idOrden'] = $compra[0]['idOrden'] ? $selectOrden[0] : false;

            return $compra[0] ? $compra[0] : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    public function one_orden()
    {
        $sql = "SELECT * FROM compras c LEFT JOIN departamentos d ON c.departamento = d.IdDepto WHERE idOrden = :idOrden";
        
        try {
            $compra = parent::query($sql, ['idOrden' => $this->idOrden]);
            $proveedor = $compra[0]['idProveedor'];
            $proveedor2 = $compra[0]['idProveedor2'];
            $proveedor3 = $compra[0]['idProveedor3'];
            $proveedor4 = $compra[0]['idProveedor4'];
            $proveedor5 = $compra[0]['idProveedor5'];
            $idOrden = $compra[0]['idOrden'];
            $sqlProveedor = "SELECT * FROM proveedores WHERE id = '$proveedor' ";
            $sqlProveedor2 = "SELECT * FROM proveedores WHERE id = '$proveedor2' ";
            $sqlProveedor3 = "SELECT * FROM proveedores WHERE id = '$proveedor3' ";
            $sqlProveedor4 = "SELECT * FROM proveedores WHERE id = '$proveedor4' ";
            $sqlProveedor5 = "SELECT * FROM proveedores WHERE id = '$proveedor5' ";
            $sqlOrden = "SELECT * FROM ordenes WHERE IdOrden = '$idOrden' ";
            $sql2 = "SELECT * FROM comprasDetalle WHERE idCompra = :id";
            $compraDetalle = parent::query($sql2, ['id' => $compra[0]['id']]);
            $selectProveedor = parent::query($sqlProveedor);
            $selectProveedor2 = parent::query($sqlProveedor2);
            $selectProveedor3 = parent::query($sqlProveedor3);
            $selectProveedor4 = parent::query($sqlProveedor4);
            $selectProveedor5 = parent::query($sqlProveedor5);
            $selectOrden = parent::query($sqlOrden);

            $compra[0]['detalleCompra'] = $compraDetalle;
            $compra[0]['idProveedor'] = $selectProveedor[0];
            $compra[0]['idProveedor2'] = $selectProveedor2[0];
            $compra[0]['idProveedor3'] = $selectProveedor3[0];
            $compra[0]['idProveedor4'] = $selectProveedor4[0];
            $compra[0]['idProveedor5'] = $selectProveedor5[0];
            $compra[0]['idOrden'] = $compra[0]['idOrden'] ? $selectOrden[0] : false;

            return $compra[0] ? $compra[0] : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    public function delete()
    {

        $sql = "UPDATE  compras SET estado=:estado, estatus=:estatus WHERE id=:id";
        $data =
            [
                'estado' => $this->estado,
                'estatus' => 3,
                'id' => $this->id
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }



    public function multiple_prov()
    {

        $sql = "UPDATE compras SET variosProv=$this->variosprov WHERE id='$this->id'";

        try {
            return (parent::query($sql)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    public function compras_por_autorizar()
    {

        $sql = "SELECT * FROM compras WHERE aprobada=0";

        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    

    public function eliminar_fila()
    {

        $sql = "UPDATE comprasDetalle SET cantidad=$this->cantidad, precio=$this->precio, monto=$this->monto,   Celiminado=$this->eliminado WHERE idCompra='$this->id' AND partida='$this->partida'";

        try {
            return (parent::query($sql)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    public function update_estado_compra()
    {

        $sql = "UPDATE  compras SET estado=2 WHERE id='$this->id'";

        try {
            return (parent::query($sql)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    public function codi_agregar_fecha_entrega_prove(){

        $sql = "UPDATE  compras SET fechaEntrega='$this->fecha', estatus = 4 WHERE id='$this->id'";

        try {
            return (parent::query($sql)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    public function codi_addpd_fsbf()
    {
        $uploadTo = FACTURAPROV;
        $allowFileType = array('pdf');
        $basename = basename($this->filename);
        $originalPath = $uploadTo.$basename;
        $urlhttps = "https://grupoxtinfire.com/";
        $originalPath2 = $urlhttps. substr($originalPath,55); 
        $fileType = pathinfo($originalPath, PATHINFO_EXTENSION); 
        if(!empty($this->filename)){ 
        
           if(in_array($fileType, $allowFileType)){ 
             // Upload file to server 
             if(move_uploaded_file($this->temppath,$originalPath)){ 
                if($this->tipo == 1){
                    $sql = "UPDATE  compras SET Factura=:Factura WHERE id=:id";
                }else if($this->tipo == 2){
                    $sql = "UPDATE  compras SET Factura2=:Factura2 WHERE id=:id";
                }else if($this->tipo == 3){
                    $sql = "UPDATE  compras SET Factura3=:Factura3 WHERE id=:id";
                }else if($this->tipo == 4){
                    $sql = "UPDATE  compras SET Factura4=:Factura4 WHERE id=:id";
                }else{
                    $sql = "UPDATE  compras SET Factura5=:Factura5 WHERE id=:id";
                }

                    $data =
                        [
                            'id' => $this->id,
                            'Factura' => $originalPath2
                        ];
                    try {
                        return ($this->Id = parent::query($sql, $data)) ? $this->id : false;
                    } catch (Exception $e) {
                        throw $e;
                    }
              
              }else{ 
                echo 'File Not uploaded ! try again';
              } 
          }else{
             echo $fileType." file type not allowed";
          }
       }else{  
         echo "Please Select a file";
       }    
        
    }

    public function cambiar_proveedor_general()
    {

        $sql = "UPDATE  comprasDetalle SET idProveedor='$this->idProveedor' WHERE idCompra='$this->iddetalle'";
        $sql2 = "UPDATE  compras SET idProveedor='$this->idProveedor' WHERE id='$this->iddetalle'";

        try {
            $f = parent::query($sql2);
            return (parent::query($sql)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    public function cambiarproveedor_unitario(){

     $sql = "UPDATE  comprasDetalle SET idProveedor='$this->idProveedor' WHERE idCompra='$this->iddetalle' AND partida='$this->partida'";
        if($this->numeroprov == 1){
            $sql2 = "UPDATE  compras SET idProveedor='$this->idProveedor' WHERE id='$this->iddetalle'";
        }else if($this->numeroprov == 2){
            $sql2 = "UPDATE  compras SET idProveedor2='$this->idProveedor' WHERE id='$this->iddetalle'";
        }else if($this->numeroprov == 3){
            $sql2 = "UPDATE  compras SET idProveedor3='$this->idProveedor' WHERE id='$this->iddetalle'";
        }else if($this->numeroprov == 4){
            $sql2 = "UPDATE  compras SET idProveedo4='$this->idProveedor' WHERE id='$this->iddetalle'";
        }else if($this->numeroprov == 5){
            $sql2 = "UPDATE  compras SET idProveedor5='$this->idProveedor' WHERE id='$this->iddetalle'";
        }
        
        try {
            $f = parent::query($sql2);
            return (parent::query($sql)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }   
    }


     public function aprobar_compra()
    {
        $fila = $this->filas;
        $sql = "UPDATE  compras SET aprobada=1 WHERE id='$this->id'";
         
         
        try {

            foreach ($fila as $key => $value) {
            $iddetalle = $value['id'];
            $partida = $value['partida'];
            $cantidad = $value['cantidad'];
            $monto = $cantidad * $value['precioventa'];
            $sql2 = "UPDATE  comprasDetalle SET cantidad='$cantidad', monto = '$monto' WHERE id='$iddetalle' AND partida='$partida'";

                $f = parent::query($sql2);
            }

            return (parent::query($sql)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

     public function aprobar_compra_final_sistema()
    {ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);
        try {

            $fila = $this->filas;
            $sql = "UPDATE  compras SET estatus = 4 WHERE id='$this->id'";
            $ordenEstatus = 16;
            $valcompletar = 1;
            $fecha = date("Y-m-d");
            foreach ($fila as $key => $value) {
            $partida = $value['partida'];
            $cantidad = $value['cantidad'];
            $costo = $value['costo'];
            $precioventa = $value['precioventa'];
            $monto = $value['monto'];
            $recibido = $value['recibido'];
            $idproducto = $value['idproducto'];
            $proveedor = $value['proveedor'];
            $moneda = $value['moneda'];
           
            $sql5 = "SELECT recibido FROM comprasDetalle WHERE idCompra='$this->id' AND partida='$partida'";
            $pf = parent::query($sql5);
            $recibidoanterior = $pf[0]['recibido'];
            $sql6 = "SELECT proExistencia FROM productos WHERE proId='$idproducto'";
            $pE = parent::query($sql6);
            $proExistenciaAnterior = $pE[0]['proExistencia'];
 
            if($recibido < $cantidad){
                $sql = "UPDATE  compras SET estatus = 2 WHERE id='$this->id'";
                $ordenEstatus = 17;
                $valcompletar = 0;
            }else if($recibido > $cantidad){
                $valcompletar = 0;
              
            }

            if($recibido < $recibidoanterior){
                          
            }else if($recibido <= $cantidad){
                if($proveedor != null || $proveedor != ''){
                $sql2 = "UPDATE  comprasDetalle SET cantidad='$cantidad', monto = '$monto', recibido=$recibido, idProveedor = '$proveedor' WHERE idCompra='$this->id' AND partida='$partida'";
                 $f = parent::query($sql2);
                
                }else{
                $sql2 = "UPDATE  comprasDetalle SET cantidad='$cantidad', monto = '$monto', recibido='$recibido' WHERE idCompra='$this->id' AND partida='$partida'";
                 $f = parent::query($sql2);
                
                }
            }
            


            if($recibido == $cantidad){
                $insertar = $recibido - $recibidoanterior;
                $insertarFinal = $proExistenciaAnterior + $insertar;
                $sql3 = "UPDATE  productos SET proPreciocosto='$costo', proExistencia = $insertarFinal, proPrecioventa='$precioventa', proMoneda = '$moneda', FechaActualizacion= '$fecha' WHERE proId='$idproducto'";
                $p = parent::query($sql3);
            }else if($recibidoanterior == 0 && $cantidad > $recibido){
                $insertarFinal = $proExistenciaAnterior + $recibido;
                $sql3 = "UPDATE  productos SET proPreciocosto='$costo', proExistencia = $insertarFinal, proPrecioventa='$precioventa', proMoneda = '$moneda', FechaActualizacion= '$fecha'  WHERE proId='$idproducto'";
                $p = parent::query($sql3);
            }else if($recibido == $recibidoanterior){
                $sql3 = "UPDATE  productos SET proPreciocosto='$costo', proExistencia =$proExistenciaAnterior, proPrecioventa='$precioventa', proMoneda = '$moneda', FechaActualizacion= '$fecha'  WHERE proId='$idproducto'";
                $p = parent::query($sql3);
            }else if($recibido > $recibidoanterior && $cantidad > $recibido){ 
                $insertarFinal = $recibido - $recibidoanterior;
                $profinal = $proExistenciaAnterior + $insertarFinal;
                $sql3 = "UPDATE  productos SET proPreciocosto='$costo', proExistencia = $profinal, proPrecioventa='$precioventa', proMoneda = '$moneda', FechaActualizacion= '$fecha'  WHERE proId='$idproducto'";
                $p = parent::query($sql3);
            }else if($recibidoanterior > $recibido){
                $sql3 = "UPDATE  productos SET proPreciocosto='$costo', proPrecioventa='$precioventa', proMoneda = '$moneda', FechaActualizacion= '$fecha'  WHERE proId='$idproducto'";
                $p = parent::query($sql3);
                
                }
                
            }

            if($valcompletar == 1){
                $sql = "UPDATE  compras SET estatus = 1 WHERE id='$this->id'";
                $ordenEstatus = 16;
            }
            $sql4 = "UPDATE  ordenes SET Estatus='$ordenEstatus' WHERE IdOrden='$this->idOrden'";
            $o = parent::query($sql4);

            return (parent::query($sql)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    public function codi_hacer_devolucion(){
ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);
        $fila = $this->filas;

        try {
            foreach ($fila as $key => $value) {

                $partida = $value['partida'];
                $cantidad = $value['cantidad'];
                $cantidad2 = $value['cantidad2'];
                $costo = $value['costo'];
                $precioventa = $value['precioventa'];
                $monto = $value['monto'];
                $recibido = $value['recibido'];
                $idproducto = $value['idproducto'];
                $proveedor = $value['proveedor'];
                $moneda = $value['moneda'];
                $devolucion = $value['devolucion'];

                $sql2 = "SELECT recibido, Devuelto FROM comprasDetalle WHERE idCompra='$this->id' AND partida='$partida'";
                $dev = parent::query($sql2);
                $devueltoanterior = $dev[0]['Devuelto'];
                $recibidotabla = $dev[0]['recibido'];

                $sqlC = "SELECT estatus FROM compras WHERE id='$this->id'";
                $deve = parent::query($sqlC);
                $Restatus = $deve[0]['estatus'];

                $sqltipo = "UPDATE  compras SET estatus = $Restatus WHERE  id='$this->id'";
                $sql4 = "SELECT proExistencia FROM productos WHERE proId= '$idproducto'";
                $proExt = parent::query($sql4);
                $proExistencianterior = $proExt[0]['proExistencia'];
                $tipoCompra = $this->tipo;
    
                if($tipoCompra == "5"){

                    //compra completa
                    $sql = "UPDATE  comprasDetalle SET Devuelto=$recibidotabla WHERE  idCompra='$this->id' AND partida = '$partida'";
                    parent::query($sql);
                    $recibidoresta =  $recibidotabla - $devueltoanterior;
                    $Einsert = $proExistencianterior - $recibidoresta;
                    $sql3 = "UPDATE  productos SET  proExistencia = $Einsert WHERE proId='$idproducto'";
                    $p = parent::query($sql3);
                    $sqltipo = "UPDATE  compras SET estatus= $this->tipo WHERE  id='$this->id'";
                }

                if($tipoCompra == "6"){
                    //compra parcial   cantidad  = 5  2  2
                    // recibido tabla = es igual lo que manda sql $cantidad2  = float de cantiadad ajax devolucion
                    // lo que mande ajax $devolucion
                    // 2 - 4 
                     $restadevant = $devolucion -$devueltoanterior;    
                    if($devueltoanterior == 0){
                        
                        $nuevaexistencia = $proExistencianterior - $devolucion;

                        $sql = "UPDATE  comprasDetalle SET Devuelto=$devolucion WHERE  idCompra='$this->id' AND partida = '$partida'";
                        parent::query($sql);
                        $sql3 = "UPDATE  productos SET  proExistencia = $nuevaexistencia WHERE proId='$idproducto'";
                    $p = parent::query($sql3);
                        $sqltipo = "UPDATE  compras SET estatus= $this->tipo WHERE  id='$this->id'";
                                       
                    }else if($recibidotabla >= $devolucion && $devueltoanterior != 0 && $devueltoanterior < $devolucion){

                        $nuevaexistencia = $proExistencianterior - $restadevant;
                       $sql = "UPDATE  comprasDetalle SET Devuelto=$devolucion WHERE  idCompra='$this->id' AND partida = '$partida'";
                        parent::query($sql);
                        $sql3 = "UPDATE  productos SET  proExistencia = $nuevaexistencia WHERE proId='$idproducto'";
                    $p = parent::query($sql3);
                        $sqltipo = "UPDATE  compras SET estatus= $this->tipo WHERE  id='$this->id'";

                    }
                    
                }
                
            }

            return (parent::query($sqltipo)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }
    

    public function update_estado_compra_detalle()
    {

        $sql = "UPDATE  comprasDetalle SET recibido='$this->recibido' WHERE id='$this->id'";

        try {
            return (parent::query($sql)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    public function comprasreporte()
    {
        $sql = $this->sentencia;
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

}
