<?php
class cotizacionesModel extends Db
{
    //---------------------Cotizacion----------------------//
    public $IdCotizacion;
    public $FolioCotizacion;
    public $IdCliente;
    public $IdDomicilio;
    public $Fecha;
    public $Tipo;
    public $Descripcion;
    public $Descuento;
    public $Estatus;
    public $TipoPago;
    public $EstadoTransito;
    public $TipoOrden;
    public $TipoServicio;
	public $IdUsuario;
    public $tipoordendetalle;
    //---------------------Cotizacion Detalle----------------------//
    public $IdDetalle;
    public $Partida;
    public $IdProducto;
    public $Cantidad;
    public $PrecioVenta;
    public $DescuentoDetalle;
    public $DescPesos;
    public $Neto;
    public $llaveOrden;
    public $autorizacionOrden;
    public $llaveOrdenAutorizacion;
    public $pdfval;
    public $comagentetotal;
    public $comagenteind;
    public $datetentativo;
    public $descripciondetalle;
    public $alimentosli;
    public $transporteli;
    public $dc3li;
    public $textocursos;
    public $Fechacierre;
    public $FechaInicio;
    public $FechaTermino;
    public $agendaCap;
    /**
     * 
     * Metodo para agregar nuevo usuario
     * @return integer 
     */

    public function add()
    {
        $sql = "INSERT INTO cotizaciones (FolioCotizacion, IdCliente, IdDomicilio, Fecha, Tipo, Descripcion, Descuento, Estatus, TipoPago, EstadoTransito, TipoOrden, TipoServicio, IdUsuario, llaveOrden, totalComision,alimentosli,transporteli,dc3li,textocursos) 
        VALUES (:FolioCotizacion, :IdCliente, :IdDomicilio, :Fecha, :Tipo, :Descripcion, :Descuento, :Estatus, :TipoPago, :EstadoTransito, :TipoOrden, :TipoServicio, :IdUsuario, :llaveOrden, :totalComision, :alimentosli, :transporteli, :dc3li, :textocursos)";
        $data =
            [
                'FolioCotizacion' => $this->FolioCotizacion,
                'IdCliente' => $this->IdCliente,
                'IdDomicilio' => $this->IdDomicilio,
                'Fecha' => $this->Fecha,
                'Tipo' => $this->Tipo,
                'Descripcion' => $this->Descripcion,
                'Descuento' => $this->Descuento,
                'Estatus' => $this->Estatus,
                'TipoPago' => $this->TipoPago,
                'EstadoTransito' => $this->EstadoTransito, //Almacen
                'TipoOrden' => $this->TipoOrden,
                'TipoServicio' => $this->TipoServicio,
				'IdUsuario' => $this->IdUsuario,
                'llaveOrden' => $this->llaveOrden,
                'totalComision' => $this->comagentetotal,
                'alimentosli' => $this->alimentosli,
                'transporteli' => $this->transporteli,
                'dc3li' => $this->dc3li,
                'textocursos' => $this->textocursos
            ];

        try {
            return ($this->IdCotizacion = parent::query($sql, $data)) ? $this->IdCotizacion : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    public function add_detalle()
    {
        $tipoordendetalle = $this->tipoordendetalle;
        $descripciondetalle = $this->descripciondetalle;
        if($tipoordendetalle != 7){
            $descripciondetalle = "";
        }
        $sql = "INSERT INTO cotizacionesdetalle (IdCotizacion, FolioCotizacion, Partida, IdProducto, Cantidad, PrecioVenta,DescuentoDetalle,DescPesos,Neto, ComisionInd, fechaCapacitacionOrd, DescripcionNueva) 
        VALUES (:IdCotizacion, :FolioCotizacion, :Partida, :IdProducto, :Cantidad,:Neto, :DescuentoDetalle, :DescPesos,:PrecioVenta, :ComisionInd, :fechaCapacitacionOrd,:DescripcionNueva)";
        $data =
            [
                'IdCotizacion' => $this->IdCotizacion,
                'FolioCotizacion' => $this->FolioCotizacion,
                'Partida' => $this->Partida,
                'IdProducto' => $this->IdProducto,
                'Cantidad' => $this->Cantidad,
                'PrecioVenta' => $this->Neto,
                'DescuentoDetalle' => $this->DescuentoDetalle,
                'DescPesos' => $this->DescPesos,
                'Neto' => $this->PrecioVenta,
                'ComisionInd'=> $this->comagenteind,
                'DescripcionNueva' => $descripciondetalle,
                'fechaCapacitacionOrd' => $this->datetentativo
            ];

        try {
            return ($this->IdDomicilio = parent::query($sql, $data)) ? $this->IdDomicilio : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los usuarios
     * @return void 
     */

    public function all()
    {
        $sql = "SELECT o.IdCotizacion, o.FolioCotizacion, o.IdCliente, o.IdDomicilio, o.Fecha, o.Descripcion, o.Tipo, o.Estatus, o.Descuento, o.TipoOrden, o.TipoServicio,o.IdUsuario, o.alimentosli, o.transporteli, o.dc3li, o.textocursos, u.Usuario, u.IdUsuario, c.Nombre,
        COUNT(d.IdDetalle) AS Items, COALESCE(SUM(d.Cantidad * d.PrecioVenta)-SUM(d.DescPesos),0) AS TotalCotizacion, e.Descripcion AS NombreEstatus, x.DeptoDescripcion 
		FROM cotizaciones o LEFT JOIN clientes c ON o.IdCliente = c.IdCliente
        LEFT JOIN estatuscotizaciones e ON o.Estatus = e.IdEstatus
        LEFT JOIN usuarios u ON o.IdUsuario = u.IdUsuario
        LEFT JOIN departamentos x ON o.EstadoTransito = x.IdDepto
        LEFT JOIN cotizacionesdetalle d ON o.IdCotizacion = d.IdCotizacion WHERE o.Estatus NOT IN (2,3,4,9) GROUP BY o.IdCotizacion ORDER BY o.IdCotizacion DESC;";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }



    /**
     * 
     * Metodo para cargar todos los usuarios
     * @return void 
     */

    public function all2()
    {  
         $dbDetails = array(
            'host' => DB_HOST,
            'user'=> DB_USER,
            'pass'=> DB_PASS,
            'db' => DB_NAME
         );

         $table = <<<EOT
            (
            SELECT 
            o.IdCotizacion,
            o.FolioCotizacion,
            o.IdCliente,
            o.IdDomicilio,
            o.Fecha,
            o.Descripcion,
            o.Tipo,
            o.Estatus,
            o.Descuento,
            o.TipoOrden,
            o.TipoServicio,
            o.IdUsuario,
            o.alimentosli,
            o.transporteli,
            o.dc3li,
            o.textocursos,
            u.Usuario,
            u.IdUsuario as IdUsuarioU,
            c.Nombre,
            COUNT(d.IdDetalle) AS Items,
            COALESCE(SUM(d.Cantidad * d.PrecioVenta)-SUM(d.DescPesos),0) AS TotalCotizacion,
            e.Descripcion AS NombreEstatus,
            x.DeptoDescripcion 
            FROM cotizaciones o LEFT JOIN clientes c ON o.IdCliente = c.IdCliente
            LEFT JOIN estatuscotizaciones e ON o.Estatus = e.IdEstatus
            LEFT JOIN usuarios u ON o.IdUsuario = u.IdUsuario
            LEFT JOIN departamentos x ON o.EstadoTransito = x.IdDepto
            LEFT JOIN cotizacionesdetalle d ON o.IdCotizacion = d.IdCotizacion
            WHERE o.Estatus NOT IN (2,3,4,9)
            GROUP BY o.IdCotizacion) temp
            EOT;

         $primaryKey = 'IdCotizacion';

         $columns = array(
            array('db' => 'IdCotizacion', 'dt' => 'IdCotizacion'),
            array('db' => 'FolioCotizacion', 'dt' => 'FolioCotizacion'),
            array('db' => 'IdCliente',  'dt' => 'IdCliente'),
            array('db' => 'IdDomicilio',   'dt' => 'IdDomicilio'),
            array('db' => 'Fecha',     'dt' => 'Fecha'),
            array('db' => 'Descripcion',     'dt' => 'Descripcion'),
            array('db' => 'Tipo',     'dt' => 'Tipo'),
            array('db' => 'Estatus',     'dt' => 'Estatus'),
            array('db' => 'Descuento',     'dt' => 'Descuento'),
            array('db' => 'TipoOrden',     'dt' => 'TipoOrden'),
            array('db' => 'TipoServicio',     'dt' => 'TipoServicio'),
            array('db' => 'IdUsuario',     'dt' => 'IdUsuario'),
            array('db' => 'alimentosli',     'dt' => 'alimentosli'),
            array('db' => 'transporteli',     'dt' => 'transporteli'),
            array('db' => 'dc3li',     'dt' => 'dc3li'),
            array('db' => 'textocursos',     'dt' => 'textocursos'),
            array('db' => 'Usuario',     'dt' => 'Usuario'),
            array('db' => 'IdUsuario',     'dt' => 'IdUsuario'),
            array('db' => 'Nombre',     'dt' => 'Nombre'),
            array('db' => 'Items',     'dt' => 'Items'),
            array('db' => 'TotalCotizacion',     'dt' => 'TotalCotizacion'),
            array('db' => 'NombreEstatus',     'dt' => 'NombreEstatus'),
            array('db' => 'DeptoDescripcion',     'dt' => 'DeptoDescripcion')
       
        );

        return json_encode(
            parent::simple($_POST, $dbDetails, $table, $primaryKey, $columns)
        );
    }

    /**
     * 
     * Metodo para cargar todos los usuarios
     * @return void 
     */

    public function all_departamento()
    {
        $estadotransito = $this->EstadoTransito;
        $where = "o.IdUsuario=$this->IdUsuario";
        if($estadotransito == 3){
            $where = "o.EstadoTransito=$this->EstadoTransito";
        }

        $sql = "SELECT o.IdCotizacion, o.FolioCotizacion, o.IdCliente, o.IdDomicilio, o.Fecha, o.Descripcion, o.Tipo, o.Estatus, o.Descuento, o.TipoOrden, o.TipoServicio,o.IdUsuario, o.alimentosli, o.transporteli, o.dc3li,u.Usuario,o.EstadoTransito, u.IdUsuario, c.Nombre,
        COUNT(d.IdDetalle) AS Items, COALESCE(SUM(d.Cantidad * d.PrecioVenta)-SUM(d.DescPesos),0) AS TotalCotizacion, e.Descripcion AS NombreEstatus, x.DeptoDescripcion 
        FROM cotizaciones o LEFT JOIN clientes c ON o.IdCliente = c.IdCliente
        LEFT JOIN estatuscotizaciones e ON o.Estatus = e.IdEstatus
        LEFT JOIN usuarios u ON o.IdUsuario = u.IdUsuario
        LEFT JOIN departamentos x ON o.EstadoTransito = x.IdDepto
        LEFT JOIN cotizacionesdetalle d ON o.IdCotizacion = d.IdCotizacion WHERE $where GROUP BY o.IdCotizacion ORDER BY o.IdCotizacion DESC;";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

     /**
     * 
     * Metodo para cargar todos los estatus
     * @return void 
     */

    public function talleractivos_almacen()
    {
        $sql = "SELECT * FROM cotizaciones WHERE TipoOrden = 8 AND IdCliente = 7265 AND CotizacionCerrada = 0";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los estatus
     * @return void 
     */

    public function talleractivos_capacitaciones()
    {
        $sql = "SELECT * FROM cotizaciones WHERE TipoOrden = 8 AND IdCliente = 7274 AND CotizacionCerrada = 0";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los estatus
     * @return void 
     */

    public function almacen_talleratendidashoy()
    {   
        $Fechacierretrabajo = date("Y-m-d");
        $sql = "SELECT * FROM cotizaciones WHERE TipoOrden = 8 AND IdCliente = 7265  AND CotizacionCerrada = 1 AND  FechaCierreTrabajo = '$Fechacierretrabajo'";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los estatus
     * @return void 
     */

    public function capacitaciones_talleratendidashoy()
    {   
        $Fechacierretrabajo = date("Y-m-d");
        $sql = "SELECT * FROM cotizaciones WHERE TipoOrden = 8 AND IdCliente = 7274 AND CotizacionCerrada = 1 AND FechaCierreTrabajo = '$Fechacierretrabajo'";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los estatus
     * @return void 
     */

    public function solicitudesctivosfechas()
    {   
        $FechaInicio = $this->FechaInicio;
        $FechaTermino = $this->FechaTermino;

        $sql = "SELECT * FROM cotizaciones WHERE TipoOrden = 8  AND FechaCierreTrabajo BETWEEN '$FechaInicio' AND '$FechaTermino'";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para el detalle de una Cotizacion
     * @return void 
     */

    public function detalle()
    {
        if($this->pdfval == 1){
        $sql = "SELECT o.IdDetalle,o.IdCotizacion,o.FolioCotizacion,o.Partida,o.IdProducto,sum(o.Cantidad) as Cantidad,o.PrecioVenta,o.DescuentoDetalle,sum(o.DescPesos) as DescPesos,sum(o.Neto) as Neto,o.fechaCapacitacion,o.DescripcionNueva,o.Partidacalendario,o.agendaCap,o.fechaCapacitacionOrd, p.proId, p.prodClave, p.proCatId, p.proTitulo, p.proExistencia, p.proImagen,p.proSku
        FROM cotizacionesdetalle o LEFT JOIN productos p ON o.IdProducto = p.proId WHERE o.IdCotizacion= :IdCotizacion GROUP BY p.prodClave";
        }else{
            $sql = "SELECT o.*, p.proId, p.prodClave, p.proCatId, p.proTitulo, p.proExistencia, p.proImagen,p.proSku
        FROM cotizacionesdetalle o LEFT JOIN productos p ON o.IdProducto = p.proId WHERE o.IdCotizacion= :IdCotizacion";
        }
        
        try {
            return ($rows = parent::query($sql, ['IdCotizacion' => $this->IdCotizacion])) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar un registro usando su id
     * @return void 
     */

    public function one()
    {
        $sql = "SELECT o.IdCotizacion, o.FolioCotizacion, o.IdCliente, o.IdDomicilio, o.Fecha, o.Descripcion, o.Tipo, o.Descuento, o.TipoPago, o.Estatus, o.EstadoTransito, o.TipoOrden, o.TipoServicio,o.IdUsuario,o.llaveOrden,o.autorizacionOrden,o.llaveOrdenAutorizacion, o.urlPago, o.alimentosli, o.transporteli, o.dc3li, o.textocursos,o.AceptarTaller,o.FechadeInicioTrabajo,o.FechaCierreTrabajo,o.CotizacionCerrada, c.Nombre, c.FisTelefono, c.FisEmail, c.Moroso, d.EntCalle, d.EntNExt, d.EntColonia, d.EntCP, d.EntMunicipio, d.EntEstado, d.EntDesde,d.EntHasta, d.EntCruces, d.EntObservaciones,
        e.Descripcion AS NombreEstatus, x.DeptoDescripcion, u.Usuario AS NombreUsuario, u.Telefono as telvendedor,u.IdUsuario AS usuarioVendedorId, u.Departamento, noti.Leido 
        FROM cotizaciones o 
        LEFT JOIN clientes c ON o.IdCliente = c.IdCliente 
        LEFT JOIN domentregacltes d ON o.IdDomicilio = d.IdDomicilio 
        LEFT JOIN estatuscotizaciones e ON o.Estatus = e.IdEstatus
        LEFT JOIN departamentos x ON o.EstadoTransito = x.IdDepto
		LEFT JOIN usuarios u ON o.IdUsuario = u.IdUsuario
        LEFT JOIN notificaciones noti ON o.IdCotizacion = noti.Folio
        WHERE o.IdCotizacion =:IdCotizacion LIMIT 1";
        try {
            return ($rows = parent::query($sql, ['IdCotizacion' => $this->IdCotizacion])) ? $rows[0] : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Obtener max id y sumarle 1
     * @return void 
     */

    public function folio($longitud)
    {
        $sql = "SELECT MAX(IdCotizacion) as Folio FROM cotizaciones LIMIT 1";
        try {

            $rows = parent::query($sql);
            $Folio = $rows[0]['Folio'];
            if ($Folio == "") {
                $Folio = 1;
            } else {
                $Folio++;
            }

            return (str_pad($Folio, $longitud, "0", STR_PAD_LEFT));
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los estatus
     * @return void 
     */

    public function estatuscotizaciones()
    {
        $sql = "SELECT * FROM estatuscotizaciones ORDER BY IdEstatus ASC;";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los estatus
     * @return void 
     */

    public function estatus()
    {
        $sql = "SELECT * FROM estatus ORDER BY IdEstatus ASC;";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para actualizar un registro de la bd
     * @return bool 
     */

    public function update()
    {
        $sql = "UPDATE cotizaciones SET 
        Estatus=:Estatus, EstadoTransito=:EstadoTransito, TipoOrden=:TipoOrden, TipoServicio=:TipoServicio ,autorizacionOrden =:autorizacionOrden,llaveOrdenAutorizacion=:llaveOrdenAutorizacion
        WHERE IdCotizacion=:IdCotizacion";
        $data =
            [
                'Estatus' => $this->Estatus,
                'EstadoTransito' => "8",
                'TipoOrden' => $this->TipoOrden,
                'TipoServicio' => $this->TipoServicio,
                'IdCotizacion' => $this->IdCotizacion,
                'autorizacionOrden' => 0,
                'llaveOrdenAutorizacion' => ""
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para actualizar un registro de la bd
     * @return bool 
     */

    public function update_cursos()
    {
        $sql = "UPDATE cotizaciones SET alimentosli = :alimentosli, transporteli = :transporteli, dc3li = :dc3li, textocursos = :textocursos WHERE IdCotizacion=:IdCotizacion";
        $data =
            [ 
                'alimentosli' => $this->alimentosli,
                'transporteli' => $this->transporteli,
                'dc3li' => $this->dc3li,
                'textocursos' => $this->textocursos,
                'IdCotizacion' => $this->IdCotizacion
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para actualizar un registro de la llave
     * @return bool 
     */

    public function updatellave()
    {
        $sql = "UPDATE cotizaciones SET autorizacionOrden=:autorizacionOrden, llaveOrdenAutorizacion=:llaveOrdenAutorizacion,Estatus=:Estatus WHERE IdCotizacion=:IdCotizacion";
        $data =
            [
                'autorizacionOrden' => $this->autorizacionOrden,
                'llaveOrdenAutorizacion' => $this->llaveOrdenAutorizacion,
                "Estatus"=>10,
                'IdCotizacion' => $this->IdCotizacion
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para actualizar un registro de la llave
     * @return bool 
     */

    public function update_fecha_cotizacion()
    {   
        $fecha = date("Y-m-d H:i:s");
        $sql = "UPDATE cotizaciones SET Fecha=:Fecha WHERE IdCotizacion=:IdCotizacion";
        $data =
            [
                'Fecha' => $fecha,
                'IdCotizacion' => $this->IdCotizacion
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para actualizar un registro de la llave
     * @return bool 
     */

    public function aceptar_taller_cotizacion()
    {   
        $sql = "UPDATE cotizaciones SET AceptarTaller=:AceptarTaller WHERE IdCotizacion=:IdCotizacion";
        $data =
            [
                'AceptarTaller' => 1,
                'IdCotizacion' => $this->IdCotizacion
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para actualizar un registro de la llave
     * @return bool 
     */

    public function update_fecha_cotizacion_taller_inicio()
    {   
        $fecha = date("Y-m-d H:i:s");
        $sql = "UPDATE cotizaciones SET FechadeInicioTrabajo=:FechadeInicioTrabajo, Estatus=:Estatus WHERE IdCotizacion=:IdCotizacion";
        $data =
            [
                'FechadeInicioTrabajo' => $fecha,
                'Estatus' => 11,
                'IdCotizacion' => $this->IdCotizacion
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para actualizar un registro de la llave
     * @return bool 
     */

    public function update_fecha_cotizacion_taller_final()
    {   
        $fecha = date("Y-m-d H:i:s");
        $sql = "UPDATE cotizaciones SET FechaCierreTrabajo=:FechaCierreTrabajo WHERE IdCotizacion=:IdCotizacion";
        $data =
            [
                'FechaCierreTrabajo' => $fecha,
                'IdCotizacion' => $this->IdCotizacion
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para actualizar un registro de la llave
     * @return bool 
     */

    public function terminar_taller_cotizacion()
    {   
        $sql = "UPDATE cotizaciones SET CotizacionCerrada=:CotizacionCerrada, Estatus=:Estatus WHERE IdCotizacion=:IdCotizacion";
        $data =
            [
                'CotizacionCerrada' => 1,
                'Estatus' => 12,
                'IdCotizacion' => $this->IdCotizacion
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

     /**
     * 
     * Metodo para actualizar un registro de la bd
     * @return bool 
     */

    public function update_calendario()
    {
       $sql = "UPDATE cotizacionesdetalle SET agendaCap=:agendaCap, fechaCapacitacionOrd=:fechaCapacitacionOrd, Partidacalendario = :Partidacalendario WHERE IdCotizacion=:IdCotizacion AND Partida=:Partida";
        $data =
            [
                'Partida' => $this->Partida,
                'Partidacalendario' => $this->Partida,
                'agendaCap' => $this->agendaCap,
                'fechaCapacitacionOrd' => $this->Fecha,
                'IdCotizacion' => $this->IdCotizacion
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para actualizar un registro de la bd
     * @return bool 
     */

    public function update_detalle()
    {

        $sql = "DELETE FROM cotizacionesdetalle WHERE IdCotizacion=:IdCotizacion;";
        $data =
            [
                'IdCotizacion' => $this->IdCotizacion
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    public function delete()
    {

        $sql = "UPDATE cotizaciones SET Estatus=:Estatus WHERE IdCotizacion=:IdCotizacion";
        $data =
            [
                'Estatus' => "4",
                'IdCotizacion' => $this->IdCotizacion
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }
}
