<?php

class dashboardModel extends Model
{
    public $FechaInicio;
    public $FechaFin;
    public $Vendedor;
    public $TipoOrden;

    // ===============================================
    // APLICAR FILTROS DINÁMICOS
    // ===============================================
    private function buildFilters()
    {
        $where = " WHERE o.Estatus NOT IN (5,6) ";
        $params = [];

        // FECHAS
        if (!empty($this->FechaInicio) && !empty($this->FechaFin)) {
            $where .= " AND o.Fecha BETWEEN :inicio AND :fin ";
            $params['inicio'] = $this->FechaInicio;
            $params['fin']    = $this->FechaFin;
        } else {
            // Por defecto últimos 12 meses
            $where .= " AND o.Fecha >= DATE_SUB(CURDATE(), INTERVAL 12 MONTH) ";
        }

        // VENDEDOR
        if (!empty($this->Vendedor)) {
            $where .= " AND o.IdUsuario = :vendedor ";
            $params['vendedor'] = $this->Vendedor;
        }

        // TIPO ORDEN
        if (!empty($this->TipoOrden)) {
            $where .= " AND o.TipoOrden = :tipo ";
            $params['tipo'] = $this->TipoOrden;
        }

        return ['where' => $where, 'params' => $params];
    }


    // ============================================================
    // 1) VENTAS POR VENDEDOR / TIPO
    // ============================================================
    public function dashboard_ventas_read_model()
    {
        $filter = $this->buildFilters();

        $sql = "SELECT
                o.IdUsuario,
                u.Usuario AS vendedor,
                o.TipoOrden,
                COALESCE(t.descripcion, 'SIN TIPO') AS tipo_orden,
                COUNT(DISTINCT o.IdOrden) AS total_ordenes_tipo,
                SUM(od.Neto) AS total_neto_tipo
            FROM ordenes o
            INNER JOIN ordenesdetalle od
                ON od.IdOrden = o.IdOrden AND od.Eliminado = 0
            INNER JOIN usuarios u
                ON u.IdUsuario = o.IdUsuario
            LEFT JOIN tipo_orden t
                ON t.id = o.TipoOrden
            " . $filter['where'] . "
            GROUP BY
                o.IdUsuario, u.Usuario, o.TipoOrden, t.descripcion
            ORDER BY u.Usuario ASC;";

        return parent::query($sql, $filter['params']);
    }


    // ============================================================
    // 2) TENDENCIA DE 12 MESES
    // ============================================================
    public function dashboard_tendencia_model()
    {
        $filter = $this->buildFilters();

        $sql = "SELECT 
                DATE_FORMAT(o.Fecha, '%Y-%m') AS Mes,
                COUNT(DISTINCT o.IdOrden) AS TotalOrdenes,
                SUM(od.Neto) AS TotalDinero
            FROM ordenes o
            INNER JOIN ordenesdetalle od
                ON od.IdOrden = o.IdOrden AND od.Eliminado = 0
            " . $filter['where'] . "
            GROUP BY Mes
            ORDER BY Mes ASC";

        return parent::query($sql, $filter['params']);
    }


    // ============================================================
    // 3) DONUT POR TIPO DE ORDEN
    // ============================================================
    public function dashboard_donut_model()
    {
        $filter = $this->buildFilters();

        $sql = "SELECT 
                o.TipoOrden,
                COUNT(DISTINCT o.IdOrden) AS TotalOrdenes,
                SUM(od.Neto) AS TotalDinero
            FROM ordenes o
            INNER JOIN ordenesdetalle od
                ON od.IdOrden = o.IdOrden AND od.Eliminado = 0
            " . $filter['where'] . "
            GROUP BY o.TipoOrden
            ORDER BY o.TipoOrden ASC";

        return parent::query($sql, $filter['params']);
    }


    // ============================================================
    // 4) STACKED POR VENDEDOR / TIPO
    // ============================================================
    public function dashboard_stacked_model()
    {
        $filter = $this->buildFilters();

        $sql = "SELECT 
                usu.IdUsuario,
                usu.Usuario AS Vendedor,
                o.TipoOrden,
                COUNT(DISTINCT o.IdOrden) AS TotalOrdenes,
                SUM(od.Neto) AS TotalDinero
            FROM usuarios usu
            LEFT JOIN ordenes o 
                ON o.IdUsuario = usu.IdUsuario
            LEFT JOIN ordenesdetalle od 
                ON od.IdOrden = o.IdOrden AND od.Eliminado = 0
            " . $filter['where'] . "
            AND usu.Departamento IN (8,17,9,25)
            GROUP BY usu.IdUsuario, o.TipoOrden
            ORDER BY usu.IdUsuario ASC, o.TipoOrden ASC";

        return parent::query($sql, $filter['params']);
    }


    // ============================================================
    // 5) RANKING
    // ============================================================
    public function dashboard_ranking_model()
    {
        $filter = $this->buildFilters();

        $sql = "SELECT 
                usu.IdUsuario,
                usu.Usuario AS Vendedor,
                COUNT(DISTINCT o.IdOrden) AS TotalOrdenes,
                SUM(od.Neto) AS TotalDinero
            FROM usuarios usu
            LEFT JOIN ordenes o 
                ON o.IdUsuario = usu.IdUsuario
            LEFT JOIN ordenesdetalle od 
                ON od.IdOrden = o.IdOrden AND od.Eliminado = 0
            " . $filter['where'] . "
            AND usu.Departamento IN (8,17,9,25)
            GROUP BY usu.IdUsuario
            ORDER BY TotalDinero DESC";

        return parent::query($sql, $filter['params']);
    }


    // ============================================================
    // 6) LISTA DE VENDEDORES
    // ============================================================
    public function dashboard_get_vendedores_model()
    {
        $sql = "SELECT IdUsuario, Usuario 
                FROM usuarios 
                WHERE Departamento IN (8,17,9,25)
                ORDER BY Usuario ASC";

        return parent::query($sql);
    }
}
