<?php
class descuentosModel extends Db
{
    //---------------------Orden----------------------//
    public $IdDescuento;
    public $Departamento;
    public $Descuento;
    public $Estatus;
    /**
     * 
     * Metodo para agregar nuevo descuento
     * @return integer 
     */

    public function add()
    {
        $sql = "INSERT INTO descuentos (Departamento, Descuento, Estatus) 
        VALUES (:Departamento, :Descuento, :Estatus)";
        $data =
            [
                'Departamento' => $this->Departamento,
                'Descuento' => $this->Descuento,
                'Estatus' => 1
            ];

        try {
            return ($this->IdDescuento = parent::query($sql, $data)) ? $this->IdDescuento : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los usuarios
     * @return void 
     */

    public function all()
    {
        $sql = "SELECT * FROM descuentos d LEFT JOIN departamentos x ON x.IdDepto = d.Departamento WHERE d.Estatus != 0;";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar un registro usando su id
     * @return void 
     */

    public function one()
    {
        $sql = "SELECT * FROM descuentos d LEFT JOIN departamentos x ON x.IdDepto = d.Departamento  WHERE d.Departamento =:Departamento AND d.Estatus != 0 LIMIT 1";
        try {
            return ($rows = parent::query($sql, ['Departamento' => $this->Departamento])) ? $rows[0] : false;
        } catch (Exception $e) {
            throw $e;
        }
    }


    /**
     * 
     * Metodo para actualizar un registro de la bd
     * @return bool 
     */

    public function update()
    {
        $sql = "UPDATE descuentos SET Descuento=:Descuento
        WHERE IdDescuento=:IdDescuento";
        $data =
            [
                'Descuento' => $this->Descuento,
                'IdDescuento' => $this->IdDescuento,
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    public function delete()
    {

        $sql = "UPDATE descuentos SET Estatus=:Estatus 
        WHERE IdDescuento=:IdDescuento";
        $data =
            [
                'Estatus' => 0,
                'IdDescuento' => $this->IdDescuento,
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }
}
