<?php
class extintoresModel extends Db
{
    //---------------------Orden----------------------//
    public $IdExtintor;
    public $FechaAlta;
    public $ClaveExtintor;
    public $FolioOrden;
    public $IdProducto;
    public $Marca;
    public $Capacidad;
    public $TipoExtintor;
    public $Agentes;
    public $Ubicacion;
    public $IdCliente;
    public $FechaEntrega;
    public $Vencimiento;
    public $UltimaRevisionPH;
    public $CausaBaja;
    public $Estatus;
    /**
     * 
     * Metodo para agregar nuevo usuario
     * @return integer 
     */

    public function add()
    {
        $sql = "INSERT INTO extintores (FechaAlta, ClaveExtintor, IdProducto, Marca, Capacidad, TipoExtintor, Agentes, FolioOrden, Ubicacion, IdCliente, FechaEntrega, Estatus, Vencimiento, UltimaRevisionPH) 
        VALUES (NOW(),:ClaveExtintor, :IdProducto, :Marca, :Capacidad, :TipoExtintor, :Agentes, :FolioOrden, :Ubicacion, :IdCliente, :FechaEntrega, :Estatus, :Vencimiento, :UltimaRevisionPH)";
        $data =
            [
                'ClaveExtintor' => $this->ClaveExtintor,
                'IdProducto' => $this->IdProducto,
                'Marca' => $this->Marca,
                'Capacidad' => $this->Capacidad,
                'TipoExtintor' => $this->TipoExtintor,
                'Agentes' => $this->Agentes,
                'FolioOrden' => $this->FolioOrden,
                'Ubicacion' => $this->Ubicacion,
                'IdCliente' => $this->IdCliente,
                'FechaEntrega' => $this->FechaEntrega,
                'Estatus' => $this->Estatus,
                'Vencimiento' => $this->Vencimiento,
                'UltimaRevisionPH' => NULL,
            ];

        try {
            return ($this->IdExtintor = parent::query($sql, $data)) ? $this->IdExtintor : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los usuarios
     * @return void 
     */

    public function all()
    {
        $sql = "SELECT e.IdExtintor, e.ClaveExtintor, e.IdProducto, e.FolioOrden, e.Ubicacion, e.IdCliente, e.FechaEntrega, e.Estatus, 
        p.proTitulo, p.proSku, p.proPrecioventa, p.proCatId, b.catNombre, c.Nombre FROM extintores e
        LEFT JOIN productos p ON p.proId = e.IdProducto
        LEFT JOIN clientes c ON c.IdCliente = e.IdCliente 
        LEFT JOIN categorias b ON p.proCatId = b.catId;";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }


    /**
     * 
     * Metodo para cargar todos los usuarios
     * @return void 
     */

    public function all_orden()
    {
        $sql = "SELECT e.IdExtintor, e.FechaAlta, e.ClaveExtintor, e.FolioOrden, e.IdProducto, e.Marca, e.Capacidad, e.TipoExtintor, e.Agentes, 
                e.Ubicacion, e.IdCliente, e.FechaEntrega, e.Vencimiento, e.UltimaRevisionPH, e.CausaBaja, e.Estatus,
                p.proTitulo, p.proSku, p.proPrecioventa, p.proCatId, b.catNombre, c.Nombre FROM extintores e
                LEFT JOIN productos p ON p.proId = e.IdProducto
                LEFT JOIN clientes c ON c.IdCliente = e.IdCliente 
                LEFT JOIN categorias b ON p.proCatId = b.catId WHERE e.FolioOrden=:FolioOrden;";
        try {
            return ($rows = parent::query($sql, ['FolioOrden' => $this->FolioOrden])) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar un registro usando su id
     * @return void 
     */

    public function one()
    {
        $sql = "SELECT e.IdExtintor, e.FechaAlta, e.ClaveExtintor, e.FolioOrden, e.IdProducto, e.Marca, e.Capacidad, e.TipoExtintor, e.Agentes, 
        e.Ubicacion, e.IdCliente, e.FechaEntrega, e.Vencimiento, e.UltimaRevisionPH, e.CausaBaja, e.Estatus,
        p.proTitulo, p.proSku, p.proPrecioventa, p.proCatId, b.catNombre, c.Nombre FROM extintores e
        LEFT JOIN productos p ON p.proId = e.IdProducto
        LEFT JOIN clientes c ON c.IdCliente = e.IdCliente 
        LEFT JOIN categorias b ON p.proCatId = b.catId WHERE e.IdExtintor =:IdExtintor LIMIT 1";
        try {
            return ($rows = parent::query($sql, ['IdExtintor' => $this->IdExtintor])) ? $rows[0] : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar un registro usando su id
     * @return void 
     */

    public function one_clave()
    {
        $sql = " SELECT e.IdExtintor, e.FechaAlta, e.ClaveExtintor, e.FolioOrden, e.IdProducto, e.Marca, e.Capacidad, e.TipoExtintor, e.Agentes, 
        e.Ubicacion, e.IdCliente, e.FechaEntrega, e.Vencimiento, e.UltimaRevisionPH, e.CausaBaja, e.Estatus,
        p.proTitulo, p.proSku, p.proPrecioventa, p.proCatId, b.catNombre, c.Nombre FROM extintores e
        LEFT JOIN productos p ON p.proId = e.IdProducto
        LEFT JOIN clientes c ON c.IdCliente = e.IdCliente 
        LEFT JOIN categorias b ON p.proCatId = b.catId WHERE e.ClaveExtintor=:ClaveExtintor LIMIT 1";
        try {
            return ($rows = parent::query($sql, ['ClaveExtintor' => $this->ClaveExtintor])) ? $rows[0] : false;
        } catch (Exception $e) {
            throw $e;
        }
    }
    /**
     * 
     * Metodo para actualizar un registro de la bd
     * @return bool 
     */

    public function update()
    {
        $sql = "UPDATE extintores SET FolioOrden=:FolioOrden, Ubicacion=:Ubicacion, IdCliente=:IdCliente, FechaEntrega=:FechaEntrega, Estatus=:Estatus WHERE IdExtintor=:IdExtintor";
        $data =
            [
                'FolioOrden' => $this->FolioOrden,
                'Ubicacion' => $this->Ubicacion,
                'IdCliente' => $this->IdCliente,
                'FechaEntrega' => $this->FechaEntrega,
                'Estatus' => $this->Estatus,
                'IdExtintor' => $this->IdExtintor
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    public function baja()
    {
        $sql = "UPDATE extintores SET Estatus=:Estatus WHERE IdExtintor=:IdExtintor";
        $data =
            [
                'Estatus' => $this->Estatus,
                'IdExtintor' => $this->IdExtintor
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    public function delete()
    {

        $sql = "UPDATE extintores SET Estatus=:Estatus WHERE IdExtintor=:IdExtintor";
        $data =
            [
                'Estatus' => $this->Estatus,
                'IdExtintor' => $this->IdExtintor
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }
}
