<?php
class historialOrdenModel extends Db
{
    //---------------------Orden----------------------//
    public $Id;
    public $IdDepartamento;
    public $FolioOrden;
    public $IdUsuario;
    public $Fecha;
    public $Hora;
    public $Nota;

    /**
     * 
     * Metodo para agregar
     * @return integer 
     */

    public function add()
    {
        $sql = "INSERT INTO historialOrden(IdDepartamento,FolioOrden,IdUsuario,Fecha,Hora,Nota) 
        VALUES (:IdDepartamento,:FolioOrden,:IdUsuario,:Fecha,:Hora,:Nota)";
        $data =
            [
                'IdDepartamento' => $this->IdDepartamento,
                'FolioOrden' => $this->FolioOrden,
                'IdUsuario' => $this->IdUsuario,
                'Fecha' => $this->Fecha,
                'Hora' => $this->Hora,
                'Nota' => $this->Nota,
            ];

        try {
            return ($this->Id = parent::query($sql, $data)) ? $this->Id : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todo
     * @return void 
     */

    public function all()
    {
        $sql = "SELECT h.*, u.Usuario, d.DeptoDescripcion FROM historialOrden h 
        LEFT JOIN usuarios u ON h.IdUsuario = u.IdUsuario 
        LEFT JOIN departamentos d ON h.IdDepartamento = d.IdDepto
        WHERE h.FolioOrden =:FolioOrden";

        try {
            return ($rows = parent::query($sql, ['FolioOrden' => $this->FolioOrden])) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }
}
