<?php
class invoicesModel extends Db
{
    //---------------------Orden----------------------//
    public $IdInvoice;
    public $FolioOrden;
    public $FolioInvoice;
    public $IdCliente;
    public $IdDomicilio;
    public $Fecha;
    public $Tipo;
    public $Descripcion;
    public $Descuento;
    public $Estatus;
    public $TipoPago;
    public $EstadoTransito;
    public $TipoOrden;
    public $TipoServicio;
    public $Pago;
    public $InicioPeriodoPago;
    public $Factura;
    public $IdFactura;
    public $GenerarComprobante;
    public $IdUsuario;
    public $Partida;
    public $partidacincuenta;
    public $moroso;
    public $suma;
    public $folionuevo;
    public $cancelado;
    public $folioanteriorasignado;
    public $serie;
    public $valeliminadoinvoice;
    public $FechaInicio;
    public $FechaTermino;

    /**
     * 
     * Metodo para agregar nuevo invoice
     * @return integer 
     */

    public function add()
    {
        $sql = "INSERT INTO invoices (FolioOrden, FolioInvoice, IdCliente, IdDomicilio, Fecha, Tipo, Descripcion, Descuento, Estatus, TipoPago, EstadoTransito, TipoOrden, TipoServicio, IdUsuario, PartidaOrden,Partidacincuenta) 
        VALUES (:FolioOrden, :FolioInvoice, :IdCliente, :IdDomicilio, :Fecha, :Tipo, :Descripcion, :Descuento, :Estatus, :TipoPago, :EstadoTransito, :TipoOrden, :TipoServicio, :IdUsuario, :PartidaOrden, :Partidacincuenta)";
        $data =
            [
                'FolioOrden' => $this->FolioOrden,
                'FolioInvoice' => $this->FolioInvoice,
                'IdCliente' => $this->IdCliente,
                'IdDomicilio' => $this->IdDomicilio,
                'Fecha' => $this->Fecha,
                'Tipo' => $this->Tipo,
                'Descripcion' => $this->Descripcion,
                'Descuento' => $this->Descuento,
                'Estatus' => $this->Estatus,
                'TipoPago' => $this->TipoPago,
                'TipoOrden' => $this->TipoOrden,
                'TipoServicio' => $this->TipoServicio,
                'EstadoTransito' => $this->EstadoTransito,
                'IdUsuario' => $this->IdUsuario,
                'PartidaOrden'=> $this->Partida,
                'Partidacincuenta'=> $this->partidacincuenta
                
            ];

        try {
            return ($this->IdInvoice = parent::query($sql, $data)) ? $this->IdInvoice : false;
        } catch (Exception $e) {
            throw $e;
        }
    }


    /**
     * 
     * Metodo para cargar todos los invoices
     * @return void 
     */

    public function all()
    {
        $sql = "SELECT o.IdInvoice, o.FolioOrden, o.FolioInvoice, o.IdCliente, o.IdDomicilio, o.Fecha,o.IdUSuario, o.Descripcion, o.Tipo, o.Estatus, c.Nombre,
        COUNT(d.IdDetalle) AS Items, COALESCE(SUM(d.Cantidad * d.PrecioVenta),0) AS TotalInvoice, e.Descripcion AS NombreEstatus, x.DeptoDescripcion, u.Usuario AS NombreUsuario 
        FROM invoices o LEFT JOIN clientes c ON o.IdCliente = c.IdCliente
        LEFT JOIN estatus e ON o.Estatus = e.IdEstatus
        LEFT JOIN usuarios u ON o.IdUSuario = u.IdUsuario
        LEFT JOIN departamentos x ON o.EstadoTransito = x.IdDepto
        LEFT JOIN ordenesdetalle d ON o.FolioOrden = d.IdOrden 
        GROUP BY o.IdInvoice ORDER BY o.IdInvoice ASC;";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los usuarios
     * @return void 
     */

    public function all2()
    {  
         $dbDetails = array(
            'host' => DB_HOST,
            'user'=> DB_USER,
            'pass'=> DB_PASS,
            'db' => DB_NAME
         );

         $table = <<<EOT
            (
            SELECT
            o.IdInvoice,
            o.FolioOrden,
            o.FolioInvoice,
            o.IdCliente,
            o.IdDomicilio,
            o.Fecha,
            o.IdUSuario,
            o.Descripcion,
            o.Tipo,
            o.Estatus,
            o.PartidaOrden,
            c.Nombre,
            COUNT(d.IdDetalle) AS Items,
            SUM(d.Neto) AS TotalInvoice,
            SUM(REPLACE(FORMAT(neto * .16,2), ',', '')) as iva,
            d.IdOrden,
            e.Descripcion AS NombreEstatus,
            x.DeptoDescripcion,
            u.Usuario AS NombreUsuario 
            FROM invoices o
            LEFT JOIN clientes c ON o.IdCliente = c.IdCliente
            LEFT JOIN estatus e ON o.Estatus = e.IdEstatus
            LEFT JOIN usuarios u ON o.IdUSuario = u.IdUsuario
            LEFT JOIN departamentos x ON o.EstadoTransito = x.IdDepto
            LEFT JOIN ordenesdetalle d ON o.FolioOrden = d.IdOrden 
            GROUP BY o.IdInvoice ORDER BY o.IdInvoice ASC) temp
            EOT;

         $primaryKey = 'IdCliente';

         $columns = array(
            array('db' => 'IdInvoice', 'dt' => 'IdInvoice'),
            array('db' => 'FolioOrden', 'dt' => 'FolioOrden'),
            array('db' => 'IdOrden', 'dt' => 'IdOrden'),
            array('db' => 'PartidaOrden', 'dt' => 'PartidaOrden'),
            array('db' => 'FolioInvoice',  'dt' => 'FolioInvoice'),
            array('db' => 'IdCliente',   'dt' => 'IdCliente'),
            array('db' => 'IdDomicilio',     'dt' => 'IdDomicilio'),
            array('db' => 'Fecha',     'dt' => 'Fecha'),
            array('db' => 'IdUSuario',     'dt' => 'IdUSuario'),
            array('db' => 'Descripcion',     'dt' => 'Descripcion'),
            array('db' => 'Tipo',     'dt' => 'Tipo'),
            array('db' => 'Estatus',     'dt' => 'Estatus'),
            array('db' => 'Nombre',     'dt' => 'Nombre'),
            array('db' => 'Items',     'dt' => 'Items'),
            array('db' => 'TotalInvoice',     'dt' => 'TotalInvoice'),
            array('db' => 'NombreEstatus',     'dt' => 'NombreEstatus'),
            array('db' => 'DeptoDescripcion',     'dt' => 'DeptoDescripcion'),
            array('db' => 'NombreUsuario',     'dt' => 'NombreUsuario'),
            array('db' => 'iva',     'dt' => 'iva'),
        );

        return json_encode(
            parent::simple($_POST, $dbDetails, $table, $primaryKey, $columns)
        );
    }

    /**
     * 
     * Metodo para cargar un registro usando su id
     * @return void 
     */

    public function one()
    {
        $sql = "SELECT r.IdOrden, o.IdInvoice, o.FolioOrden, o.FolioInvoice, o.IdCliente, o.IdDomicilio, o.Fecha, o.Descripcion, o.Tipo, o.Descuento, o.TipoPago, o.Estatus, o.EstadoTransito, 
        o.TipoServicio, o.TipoOrden, o.Pago, o.InicioPeriodoPago, o.Factura, o.GenerarComprobante,o.FacturaXml,o.FacturaPdf,o.PartidaOrden,o.FolioOrdenRelacionado,o.Partidacincuenta,o.Uudiscomplemto,o.IdFacturaInv,o.FolioCancelacionAntInv,o.IdCanceladaInv,o.sumaproductos,o.folioasignado,o.folioanteriorasignado, r.IdOrden,r.IdFactura,r.TipoPago AS TipoPagoOrden,r.IdCancelada,r.IdComplementos,r.PublicoGeneral,r.MotivoCancelacion,r.FolioCancelacionAnt,r.RfcEmisor,r.TipoFactura,r.usoCdfi,r.MetPago,r.FolioFiscalActivo,r.urlConstancia,r.urlPago,r.Separaproductos, c.Nombre, 
        c.FisTelefono, c.FisEmail, c.RFC,c.Persona,c.CFDI,c.RegimenFiscal,c.TipoPago,c.FisEmail,c.FisCalle,c.FisNExt,c.FisNInt,c.FisColonia,c.FisCP,c.FisMunicipio,c.FisEstado,c.urlConstanciaCliente, c.Moroso, d.EntCalle, d.EntNExt, d.EntColonia, d.EntCP, d.EntMunicipio, d.EntEstado, d.EntDesde,d.EntHasta, d.EntCruces, d.EntObservaciones,
        e.Descripcion AS NombreEstatus, t.descripcion AS NombreTipoOrden, x.DeptoDescripcion, u.Usuario AS NombreUsuario,u.Correo AS Correovendedor,u.Telefono as Tel
        FROM invoices o 
        LEFT JOIN ordenes r ON r.FolioOrden = o.FolioOrden
        LEFT JOIN clientes c ON o.IdCliente = c.IdCliente 
        LEFT JOIN domentregacltes d ON o.IdDomicilio = d.IdDomicilio 
        LEFT JOIN estatus e ON o.Estatus = e.IdEstatus
        LEFT JOIN departamentos x ON o.EstadoTransito = x.IdDepto
        LEFT JOIN tipo_orden t ON o.TipoOrden = t.id
		LEFT JOIN usuarios u ON o.IdUsuario = u.IdUsuario
        WHERE o.IdInvoice =:IdInvoice LIMIT 1";
        try {
            return ($rows = parent::query($sql, ['IdInvoice' => $this->IdInvoice])) ? $rows[0] : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar un registro usando su id
     * @return void 
     */

    public function invoice_orden()
    {
        $sql = "SELECT * FROM invoices WHERE FolioOrden = $this->FolioOrden";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }


    /**
     * 
     * Metodo para cargar un registro usando su id
     * @return void 
     */

    public function codi_factura_dinero_cobrado()
    {   
        $fechainicio = $this->FechaInicio;
        $fechatermino = $this->FechaTermino;
        $sql = "SELECT od.IdOrden,od.Estatus,od.EstadoTransito,od.Fecha,od.PagadoCompleto,odet.IdOrden as odetidorden,SUM(odet.Neto) as Neto , odet.Eliminado FROM ordenes od INNER JOIN ordenesdetalle odet ON od.IdOrden = odet.IdOrden WHERE od.Fecha BETWEEN '$fechainicio' AND '$fechatermino' AND odet.Eliminado = 0 AND od.Estatus IN (4,11,12,25) GROUP BY DATE_FORMAT(od.Fecha, '%Y-%m-%d');";

        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar un registro usando su id
     * @return void 
     */

    public function codi_factura_dinero_sincobrar()
    {   
        $fechainicio = $this->FechaInicio;
        $fechatermino = $this->FechaTermino;
        $sql = "SELECT od.IdOrden,od.Estatus,od.EstadoTransito,od.Fecha,od.PagadoCompleto,odet.IdOrden as odetidorden,SUM(odet.Neto) as Neto , odet.Eliminado FROM ordenes od INNER JOIN ordenesdetalle odet ON od.IdOrden = odet.IdOrden WHERE od.Fecha BETWEEN '$fechainicio' AND '$fechatermino' AND odet.Eliminado = 0 AND od.Estatus NOT IN (4,11,12,25,6,5) GROUP BY DATE_FORMAT(od.Fecha, '%Y-%m-%d')";

        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }
    

    /**
     * 
     * Metodo para cargar un registro usando su id
     * @return void 
     */

    public function buscarfolio()
    {
        $sql = "SELECT f.conteo FROM Foliocomplemento f WHERE 1";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar un registro usando su id
     * @return void 
     */

    public function buscarfoliofactura()
    {
        $sql = "SELECT f.ConteoFactura, f.LetraFolio, f.Leido, f.IFoliofactura FROM Foliosfactura f WHERE 1";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para actualizar un registro de la bd
     * @return bool 
     */

    public function conteo_invoice()
    {   $nuevoconteo = $this->folionuevo + 1;
        $sql = "UPDATE Foliosfactura SET ConteoFactura=:ConteoFactura";
        $data =
            [
                'ConteoFactura' => $nuevoconteo
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para actualizar un registro de la bd
     * @return bool 
     */

    public function conteo_invoice_leido()
    {   
        $sql = "UPDATE Foliosfactura SET ConteoFactura=:ConteoFactura, LetraFolio = :LetraFolio, Leido = :Leido";
        $data =
            [
                'ConteoFactura' => $this->folionuevo,
                'LetraFolio' => $this->serie,
                'Leido' => 1
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar un registro usando su id
     * @return void 
     */

    public function invoice_orden_complemento()
    {   $cancelado = $this->cancelado;
        $pago = $this->Pago;
        $valeliminado = $this->valeliminadoinvoice;
        $sql = "";
        if($cancelado != '' || $valeliminado != 0){

                if($valeliminado == 1){
                    $sql = "SELECT * , ordenesdetalle.Neto, ordenesdetalle.DescPesos FROM invoices INNER JOIN ordenes ON invoices.FolioOrden = ordenes.FolioOrden INNER JOIN ordenesdetalle ON invoices.FolioOrden = ordenesdetalle.FolioOrden WHERE invoices.FolioOrden = $this->FolioOrden";
                }else{
                    $sql = "SELECT * , ordenesdetalle.Neto, ordenesdetalle.DescPesos,complementospagos.PartidaInvoceComplemento,complementospagos.Compleeliminado FROM invoices INNER JOIN ordenes ON invoices.FolioOrden = ordenes.FolioOrden INNER JOIN ordenesdetalle ON invoices.FolioOrden = ordenesdetalle.FolioOrden LEFT JOIN complementospagos ON complementospagos.IdOrden = invoices.FolioOrden WHERE invoices.FolioOrden = $this->FolioOrden AND ordenesdetalle.Eliminado = 0 AND (IF(complementospagos.Compleeliminado IS NULL, true,false) = 1 OR complementospagos.Compleeliminado = 0)";
                }
             
        }else{
            if($pago > 0){
                $sql = "SELECT * , ordenesdetalle.Neto, ordenesdetalle.DescPesos,complementospagos.PartidaInvoceComplemento,complementospagos.Compleeliminado FROM invoices INNER JOIN ordenes ON invoices.FolioOrden = ordenes.FolioOrden INNER JOIN ordenesdetalle ON invoices.FolioOrden = ordenesdetalle.FolioOrden LEFT JOIN complementospagos ON complementospagos.IdOrden = invoices.FolioOrden WHERE invoices.FolioOrden = $this->FolioOrden AND complementospagos.partialityNumber = $pago";
            }else{
                $sql = "SELECT * , ordenesdetalle.Neto, ordenesdetalle.DescPesos,complementospagos.PartidaInvoceComplemento,complementospagos.Compleeliminado FROM invoices INNER JOIN ordenes ON invoices.FolioOrden = ordenes.FolioOrden INNER JOIN ordenesdetalle ON invoices.FolioOrden = ordenesdetalle.FolioOrden LEFT JOIN complementospagos ON complementospagos.IdOrden = invoices.FolioOrden WHERE invoices.FolioOrden = $this->FolioOrden";
            }
            
        }


        //SELECT * , ordenesdetalle.Neto,  OR complementospagos.Compleeliminado = 1ordenesdetalle.DescPesos,complementospagos.PartidaInvoceComplemento,complementospagos.Compleeliminado FROM invoices INNER JOIN ordenes ON invoices.FolioOrden = ordenes.FolioOrden INNER JOIN ordenesdetalle ON invoices.FolioOrden = ordenesdetalle.FolioOrden LEFT JOIN complementospagos ON complementospagos.IdOrden = invoices.FolioOrden WHERE invoices.FolioOrden = 1217;
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar un registro usando su id
     * @return void 
     */

    public function invoice_orden_partidas_invoice()
    {
        $sql = "SELECT * FROM invoices WHERE invoices.FolioOrden  = $this->FolioOrden";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Obtener max id y sumarle 1
     * @return void 
     */

    public function folio($longitud)
    {
        $sql = "SELECT MAX(IdInvoice) as Folio FROM invoices LIMIT 1";
        try {

            $rows = parent::query($sql);
            $Folio = $rows[0]['Folio'];
            if ($Folio == "") {
                $Folio = 1;
            } else {
                $Folio++;
            }

            return (str_pad($Folio, $longitud, "0", STR_PAD_LEFT));
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los estatus
     * @return void 
     */

    public function estatus()
    {
        $sql = "SELECT * FROM estatus ORDER BY IdEstatus ASC;";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para actualizar un registro de la bd
     * @return bool 
     */

    public function update()
    {
        $sql = "UPDATE invoices SET 
        Estatus=:Estatus, EstadoTransito=:EstadoTransito, Pago=:Pago, InicioPeriodoPago=:InicioPeriodoPago,
        Factura=:Factura, GenerarComprobante=:GenerarComprobante
        WHERE IdInvoice=:IdInvoice";
        $data =
            [
                'Estatus' => $this->Estatus,
                'EstadoTransito' => $this->EstadoTransito,
                'Pago' => $this->Pago,
                'InicioPeriodoPago' => $this->InicioPeriodoPago,
                'Factura' => $this->Factura,
                'GenerarComprobante' => $this->GenerarComprobante,
                'IdInvoice' => $this->IdInvoice
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para actualizar un registro de la bd
     * @return bool 
     */

    public function update_asignar_folios()
    {   
        $cancelado = $this->cancelado;
        if($cancelado != ''){
            $sql = "UPDATE invoices SET folioasignado=:folioasignado, folioanteriorasignado = :folioanteriorasignado WHERE IdInvoice=:IdInvoice";
            $data =
            [
                'folioasignado' => $this->folionuevo,
                'folioanteriorasignado' => $this->folioanteriorasignado,
                'IdInvoice' => $this->IdInvoice
            ];
            
        }else{
            $sql = "UPDATE invoices SET folioasignado=:folioasignado WHERE IdInvoice=:IdInvoice";
            $data =
            [
                'folioasignado' => $this->folionuevo,
                'IdInvoice' => $this->IdInvoice
            ];
        }
        

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para actualizar un registro de la bd
     * @return bool 
     */

    public function update_invoice_productos()
    {
        $sql = "UPDATE invoices SET sumaproductos=:sumaproductos WHERE IdInvoice=:IdInvoice";
        $data =
            [
                'sumaproductos' => $this->suma,
                'IdInvoice' => $this->IdInvoice
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para actualizar un registro de la bd
     * @return bool 
     */

    public function actualizarfolio_fiscal2()
    {
        $sql = "UPDATE invoices SET FacturaPdf=:FacturaPdf, IdFacturaInv=:IdFacturaInv
        WHERE IdInvoice=:IdInvoice AND PartidaOrden=:PartidaOrden";
        $data =
            [   'IdFacturaInv' => $this->IdFactura,
                'FacturaPdf' => $this->Factura,
                'PartidaOrden' => $this->Partida,
                'IdInvoice' => $this->IdInvoice
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }


    /**
     * 
     * Metodo para actualizar un registro de la bd
     * @return bool 
     */

    public function relacionar_orden_invoice()
    {
        $sql = "UPDATE invoices SET FolioOrdenRelacionado=:FolioOrdenRelacionado WHERE IdInvoice=:IdInvoice";
        $data =
            [
                'FolioOrdenRelacionado' => $this->FolioOrden,
                'IdInvoice' => $this->IdInvoice
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }


    public function delete()
    {

        $sql = "UPDATE invoices SET Estatus=:Estatus WHERE IdInvoice=:IdInvoice";
        $data =
            [
                'Estatus' => $this->Estatus,
                'IdInvoice' => $this->IdInvoice
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }
}
