<?php
class ordenesModel extends Db
{
    //---------------------Orden----------------------//
    public $IdOrden;
    public $FolioOrden;
    public $IdCliente;
    public $IdDomicilio;
    public $Fecha;
    public $Tipo;
    public $Descripcion;
    public $Descuento;
    public $Estatus;
    public $TipoPago;
    public $EstadoTransito;
    public $IdCotizacion;
    public $TipoOrden;
    public $TipoServicio;
    public $MaxDescuento;
    public $IdUsuario;
    public $Motivo;
    public $CantidadEliminar;
    public $FechaInicioPipc;
    public $FechaTerminoPipc;
    public $FechaInicio;
    public $FechaTermino;
    public $tipoordendetalle;
    //---------------------Orden Detalle----------------------//
    public $IdDetalle;
    public $Partida;
    public $IdProducto;
    public $Cantidad;
    public $PrecioVenta;
    public $Entregados;
    public $ClaveExtintor;
    public $DescuentoDetalle;
    public $DescPesos;
    public $Neto;
    public $llaveOrden;
    public $autorizacionOrden;
    public $llaveOrdenAutorizacion;
    public $pdfval;
    public $comagentetotal;
    public $comagenteind;
    public $compracreada;
    public $eliminado;
    public $datetentativo;
    public $movconvertida;
    public $agendaCap;
    public $aceporden;
    public $IdFactura;
    public $Pgeneral;
    public $IdFactAnterior;
    public $IdCancelada;
    public $ObjImpuesto;
    public $rfcEmisor;
    public $usoCfdi;
    public $MP;
    public $tipoFactura;
    public $Foliofiscal;
    public $numeropago;
    public $AmountPaid;
    public $ImpSaldoInsoluto;
    public $PreviousBalanceAmount;
    public $PartidaInvoce;
    public $ancla;
    public $IdInvoice;
    public $ordenRelacionada;
    public $pagocompleto;
    public $descripciondetalle;
    public $Domprogramaintero;
    public $Percontacto;
    public $Telecontacto;
    public $Mailcontacto;
    public $duplicadoorden;
    public $contadorjson;
    public $porcentajejson;
    public $alimentosli;
    public $transporteli;
    public $dc3li;
    public $textocursos;
    public $suma;
    public $folionuevo;
    public $departamento;
    public $filtrado;
    public $separar;
    public $sentencia;
    public $tabla;
    public $deptoId;
    public $estatusId;
    /**
     * 
     * Metodo para agregar nuevo usuario
     * @return integer 
     */

    public function add()
    {   
        $sql = "INSERT INTO ordenes (FolioOrden, IdCliente, IdDomicilio, Fecha, Tipo, Descripcion, Descuento, Estatus, TipoPago, TipoOrden, TipoServicio, EstadoTransito, IdCotizacion, IdUsuario, llaveOrden, autorizacionOrden, llaveOrdenAutorizacion, totalComision,Domprogramaintero,Percontacto,    Telecontacto,Mailcontacto, duplicadoorden, contadorjson, porcentajejson,alimentosli,transporteli,dc3li,textocursos,Separaproductos) 
                VALUES (:FolioOrden,:IdCliente,:IdDomicilio,:Fecha,:Tipo, :Descripcion,:Descuento,:Estatus,:TipoPago,:TipoOrden,:TipoServicio,:EstadoTransito, :IdCotizacion,:IdUsuario, :llaveOrden, :autorizacionOrden, :llaveOrdenAutorizacion, :totalComision, :Domprogramaintero, :Percontacto, :Telecontacto, :Mailcontacto,:duplicadoorden, :contadorjson, :porcentajejson,:alimentosli,:transporteli,:dc3li, :textocursos,:Separaproductos)";
        $data =
            [
                'FolioOrden' => $this->FolioOrden,
                'IdCliente' => $this->IdCliente,
                'IdDomicilio' => $this->IdDomicilio,
                'Fecha' => $this->Fecha,
                'Tipo' => $this->Tipo,
                'Descripcion' => $this->Descripcion,
                'Descuento' => $this->Descuento,
                'Estatus' => $this->Estatus,
                'TipoPago' => $this->TipoPago,
                'TipoOrden' => $this->TipoOrden,
                'TipoServicio' => $this->TipoServicio,
                'EstadoTransito' => $this->EstadoTransito, //Almacen
                'IdCotizacion' => $this->IdCotizacion,
                'IdUsuario' => $this->IdUsuario,
                'llaveOrden' => $this->llaveOrden,
                'autorizacionOrden' => $this->movconvertida == 0 ? $this->autorizacionOrden : 0,
                'llaveOrdenAutorizacion' => $this->movconvertida == 0 ? $this->llaveOrdenAutorizacion : "",
                'totalComision' => $this->comagentetotal,
                'Domprogramaintero' => $this->Domprogramaintero,
                'Percontacto' => $this->Percontacto,
                'Telecontacto' => $this->Telecontacto,
                'Mailcontacto' => $this->Mailcontacto,
                'duplicadoorden' => $this->duplicadoorden,
                'contadorjson' => $this->contadorjson,
                'porcentajejson' => $this->porcentajejson,
                'alimentosli' => $this->alimentosli,
                'transporteli' => $this->transporteli,
                'dc3li' => $this->dc3li,
                'textocursos' => $this->textocursos,
                'Separaproductos' => $this->separar

            ];
        try {
            return ($this->IdOrden = parent::query($sql, $data)) ? $this->IdOrden : false;
        } catch (Exception $e) {
            throw $e;
        }
    }
    
    public function add_detalle()
    {   $tipoordendetalle = $this->tipoordendetalle;
        $descripciondetalle = $this->descripciondetalle;
        if($tipoordendetalle != 7){
            $descripciondetalle = "";
        }

        $sql = "INSERT INTO ordenesdetalle (IdOrden, FolioOrden, Partida, IdProducto, Cantidad, PrecioVenta, Entregados, ClaveExtintor,DescuentoDetalle,DescPesos,Neto,ComisionInd,compraCreada,Eliminado,fechaCapacitacionOrd, agendaCap,DescripcionNueva) 
				VALUES (:IdOrden, :FolioOrden, :Partida, :IdProducto, :Cantidad, :Neto, :Entregados, :ClaveExtintor, :DescuentoDetalle, :DescPesos, :PrecioVenta, :ComisionInd, :compraCreada, :Eliminado, :fechaCapacitacionOrd, :agendaCap,:DescripcionNueva)";

        $data =
            [
                'IdOrden' => $this->IdOrden,
                'FolioOrden' => $this->FolioOrden,
                'Partida' => $this->Partida,
                'IdProducto' => $this->IdProducto,
                'Cantidad' => $this->Cantidad,
                'PrecioVenta' => $this->Neto,
                'Entregados' => $this->Entregados,
                'ClaveExtintor' => $this->ClaveExtintor,
                'DescuentoDetalle' => $this->DescuentoDetalle,
                'DescPesos' => $this->DescPesos,
                'Neto' => $this->PrecioVenta,
                'ComisionInd'=> $this->comagenteind,
                'compraCreada'=> $this->compracreada,
                'Eliminado'=> $this->eliminado,
                'fechaCapacitacionOrd' => $this->datetentativo,
                'agendaCap' => $this->agendaCap,
                'DescripcionNueva' => $descripciondetalle

            ];


        try {
            return ($this->IdDomicilio = parent::query($sql, $data)) ? $this->IdDomicilio : false;
        } catch (Exception $e) {
            throw $e;
        }
    }


    public function update_detallereal()
    {
        $sql = "UPDATE ordenesdetalle SET Cantidad=:Cantidad, Neto=:Neto, Entregados=:Entregados, ClaveExtintor=:ClaveExtintor, DescuentoDetalle=:DescuentoDetalle, DescPesos=:DescPesos, PrecioVenta=:PrecioVenta,ComisionInd=:ComisionInd, compraCreada=:compraCreada, Eliminado=:Eliminado, fechaCapacitacionOrd=:fechaCapacitacionOrd WHERE IdOrden=:IdOrden AND Partida=:Partida";

        $data =
            [
                'IdOrden' => $this->IdOrden,
                'Partida' => $this->Partida,
                'Cantidad' => $this->Cantidad,
                'PrecioVenta' => $this->PrecioVenta,
                'Entregados' => $this->Entregados,
                'ClaveExtintor' => $this->ClaveExtintor,
                'DescuentoDetalle' => $this->DescuentoDetalle,
                'DescPesos' => $this->DescPesos,
                'Neto' => $this->Neto,
                'ComisionInd'=> $this->comagenteind,
                'compraCreada'=> $this->compracreada,
                'Eliminado'=> $this->eliminado,
                'fechaCapacitacionOrd' => $this->datetentativo

            ];


        try {
            return ($this->IdDomicilio = parent::query($sql, $data)) ? $this->IdDomicilio : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    public function baja_danado()
    {
       $sql = "SELECT proExistencia FROM productos WHERE proId = $this->IdProducto";
       $Existencia = 0;
        try {

            $rows = parent::query($sql);
            $Existencia = $rows[0]['proExistencia'];

        } catch (Exception $e) {
            throw $e;
        }

        $ExistenciaNueva = $Existencia - $this->CantidadEliminar;

        $sql = "UPDATE productos SET proExistencia=:proExistencia WHERE proId = $this->IdProducto";
        $data =
            [
                'proExistencia' => $ExistenciaNueva,

            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }
    public function baja_danado_producto()
        {
            $sql = "UPDATE ordenesdetalle SET Cantidad=:Cantidad, Neto=:Neto, ComisionInd=:ComisionInd  WHERE FolioOrden = $this->FolioOrden AND Partida = $this->Partida";
            $data =
                [
                    'Cantidad' => 0,
                    'Neto' => 0,
                    'ComisionInd'=>0
                ];

            try {
                return (parent::query($sql, $data)) ? true : false;
            } catch (Exception $e) {
                throw $e;
            }
    }

    function historalBaja(){

            $sql2 = "SELECT proExistencia FROM productos WHERE proId = $this->IdProducto";
            $rows = parent::query($sql2);
            $Existencia2 = $rows[0]['proExistencia'];

            $sql = "INSERT INTO historialBajas (FolioOrden, Descripcion, Motivo, Partida, IdOrden, IdProducto, CantidadActual, CantidadActualAlmacen, CantidadEliminar) 
                VALUES (:FolioOrden, :Descripcion, :Motivo, :Partida, :IdOrden, :IdProducto, :CantidadActual,:CantidadActualAlmacen, :CantidadEliminar)";
        $data =
            [
                'FolioOrden' => $this->FolioOrden,
                'Descripcion' => $this->Descripcion,
                'Motivo' => $this->Motivo,
                'Partida' => $this->Partida,
                'IdOrden' => $this->IdOrden,
                'IdProducto' => $this->IdProducto,
                'CantidadActual' => $this->Cantidad,
                'CantidadActualAlmacen' => $Existencia2,
                'CantidadEliminar' => $this->CantidadEliminar
            ];

        try {
            return ($this->IdOrden = parent::query($sql, $data)) ? $this->IdOrden : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los usuarios
     * @return void 
     */

    public function all()
    {
        $sql = "SELECT o.IdOrden, o.FolioOrden, o.IdCliente, o.IdDomicilio, o.Fecha, o.Descripcion, o.Tipo, o.Estatus, o.Descuento, o.IdUSuario, o.EstadoTransito,o.PagadoCompleto AS PagadoCompleto, c.Nombre,c.RFC,c.Clave,c.fisTelefono,c.FisEmail,c.FisCalle,c.FisNExt,c.FisNInt,c.FisColonia,c.FisCP,c.FisMunicipio,c.FisEstado,c.Persona,c.CFDI,c.RegimenFiscal,
        COUNT(d.IdDetalle) AS Items, SUM(d.Neto) AS TotalOrden, SUM(REPLACE(FORMAT(neto * .16,2), ',', '')) as iva,e.Descripcion AS NombreEstatus, u.Usuario AS NombreUsuario,
           t.descripcion AS NombreTipoOrden, o.TipoOrden, x.DeptoDescripcion 
        FROM ordenes o LEFT JOIN clientes c ON o.IdCliente = c.IdCliente
        LEFT JOIN tipo_orden t ON o.TipoOrden = t.id
        LEFT JOIN estatus e ON o.Estatus = e.IdEstatus
        LEFT JOIN usuarios u ON o.IdUSuario = u.IdUsuario
        LEFT JOIN departamentos x ON o.EstadoTransito = x.IdDepto
        LEFT JOIN ordenesdetalle d ON o.IdOrden = d.IdOrden 
        WHERE IdEstatus NOT IN (5,6,9,14,27) GROUP BY o.IdOrden ORDER BY o.Fecha ASC";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }


    /**
     * 
     * Metodo para cargar todos los usuarios
     * @return void 
     */

    public function kpi_ordenes_3m_reporte()
    {
        $sql = "SELECT
            COUNT(DISTINCT o.IdOrden)           AS ordenes_3m,
            COUNT(DISTINCT o.IdCliente)         AS clientes_3m,
            COALESCE(SUM(od.Neto), 0)           AS ingresos_3m,
            CASE WHEN COUNT(DISTINCT o.IdOrden)=0 THEN 0
                ELSE COALESCE(SUM(od.Neto),0) / COUNT(DISTINCT o.IdOrden) END AS ticket_promedio_3m
            FROM ordenes o
            JOIN ordenesdetalle od ON od.IdOrden = o.IdOrden
            WHERE o.Fecha >= DATE_FORMAT(DATE_SUB(CURDATE(), INTERVAL 2 MONTH), '%Y-%m-01')
            AND o.Fecha <  DATE_ADD(DATE_FORMAT(CURDATE(), '%Y-%m-01'), INTERVAL 1 MONTH)";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los usuarios
     * @return void 
     */

    public function tendencia_ordenes_mensual_3m_reporte()
    {
        $sql = "SELECT
            DATE_FORMAT(o.Fecha, '%Y-%m')                     AS mes_key,
            DATE_FORMAT(o.Fecha, '%b %Y')                     AS mes_label,
            COUNT(DISTINCT o.IdOrden)                         AS ordenes,
            COALESCE(SUM(od.Neto),0)                          AS ingresos
            FROM ordenes o
            JOIN ordenesdetalle od ON od.IdOrden = o.IdOrden
            WHERE o.Fecha >= DATE_FORMAT(DATE_SUB(CURDATE(), INTERVAL 2 MONTH), '%Y-%m-01')
            AND o.Fecha <  DATE_ADD(DATE_FORMAT(CURDATE(), '%Y-%m-01'), INTERVAL 1 MONTH)
            GROUP BY DATE_FORMAT(o.Fecha, '%Y-%m'), DATE_FORMAT(o.Fecha, '%b %Y')
            ORDER BY mes_key";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }
    /**
     * 
     * Metodo para cargar todos los usuarios
     * @return void 
     */

    public function top10_clientes_3m_reporte()
    {
        $sql = "SELECT
            c.IdCliente,
            c.Nombre                               AS cliente,
            COUNT(DISTINCT o.IdOrden)              AS ordenes,
            COALESCE(SUM(od.Neto),0)               AS ingresos
            FROM ordenes o
            JOIN clientes c        ON c.IdCliente = o.IdCliente
            JOIN ordenesdetalle od ON od.IdOrden = o.IdOrden
            WHERE o.Fecha >= DATE_FORMAT(DATE_SUB(CURDATE(), INTERVAL 2 MONTH), '%Y-%m-01')
            AND o.Fecha <  DATE_ADD(DATE_FORMAT(CURDATE(), '%Y-%m-01'), INTERVAL 1 MONTH)
            GROUP BY c.IdCliente, c.Nombre
            ORDER BY ingresos DESC
            LIMIT 10";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }
     
    /**
     * 
     * Metodo para cargar todos los usuarios
     * @return void 
     */

    public function productos_top_clientes_3m_reporte()
    {
        $sql = "SELECT
  c.IdCliente,
  c.Nombre           AS cliente,
  p.proSku,
  p.proTitulo        AS producto,
  cat.catNombre      AS categoria,
  SUM(od.Cantidad)   AS unidades,
  COALESCE(SUM(od.Neto),0) AS ingresos
FROM ordenes o
JOIN clientes c        ON c.IdCliente = o.IdCliente
JOIN ordenesdetalle od ON od.IdOrden  = o.IdOrden
JOIN productos p       ON p.proId     = od.IdProducto
LEFT JOIN categorias cat ON cat.catId = p.proCatId
WHERE o.Fecha >= DATE_FORMAT(DATE_SUB(CURDATE(), INTERVAL 2 MONTH), '%Y-%m-01')
  AND o.Fecha <  DATE_ADD(DATE_FORMAT(CURDATE(), '%Y-%m-01'), INTERVAL 1 MONTH)
  AND c.IdCliente IN (/* lista de 10 clientes */ 0)
GROUP BY c.IdCliente, c.Nombre, p.proSku, p.proTitulo, cat.catNombre
ORDER BY c.Nombre, ingresos DESC";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }
    /**
     * 
     * Metodo para cargar todos los usuarios
     * @return void 
     */

    public function totales_transito_3m_reporte()
    {
        $sql = "SELECT
  d.IdDepto,
  d.DeptoDescripcion AS transito,
  COUNT(DISTINCT o.IdOrden) AS ordenes
FROM ordenes o
LEFT JOIN departamentos d ON d.IdDepto = o.EstadoTransito
WHERE o.Fecha >= DATE_FORMAT(DATE_SUB(CURDATE(), INTERVAL 2 MONTH), '%Y-%m-01')
  AND o.Fecha <  DATE_ADD(DATE_FORMAT(CURDATE(), '%Y-%m-01'), INTERVAL 1 MONTH)
GROUP BY d.IdDepto, d.DeptoDescripcion
ORDER BY ordenes DESC";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }
    /**
     * 
     * Metodo para cargar todos los usuarios
     * @return void 
     */

    public function detalle_transito_3m_reporte()
    {
        $deptoId = $this->deptoId;
        $sql = "SELECT
  o.IdOrden,
  DATE_FORMAT(o.Fecha, '%Y-%m-%d %H:%i:%s') AS Fecha,
  c.Nombre                           AS cliente,
  e.Descripcion                      AS estatus_orden,
  t.descripcion                      AS tipo_orden,
  u.Usuario                          AS vendedor,
  COALESCE(SUM(od.Neto), 0)          AS total
FROM ordenes o
JOIN ordenesdetalle od     ON od.IdOrden  = o.IdOrden
LEFT JOIN clientes c       ON c.IdCliente = o.IdCliente
LEFT JOIN estatus e        ON e.IdEstatus = o.Estatus
LEFT JOIN tipo_orden t     ON t.id        = o.TipoOrden
LEFT JOIN usuarios u       ON u.IdUsuario = o.IdUsuario
WHERE o.Fecha >= DATE_FORMAT(DATE_SUB(CURDATE(), INTERVAL 2 MONTH), '%Y-%m-01')
  AND o.Fecha <  DATE_ADD(DATE_FORMAT(CURDATE(), '%Y-%m-01'), INTERVAL 1 MONTH)
  AND o.EstadoTransito = {$deptoId}
GROUP BY o.IdOrden, o.Fecha, c.Nombre, e.Descripcion, t.descripcion, u.Usuario
ORDER BY o.Fecha DESC, o.IdOrden DESC";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }
    /**
     * 
     * Metodo para cargar todos los usuarios
     * @return void 
     */

    public function totales_estatus_orden_3m_reporte()
    {
        $sql = "SELECT
  e.IdEstatus,
  e.Descripcion AS estatus,
  COUNT(DISTINCT o.IdOrden) AS ordenes
FROM ordenes o
LEFT JOIN estatus e ON e.IdEstatus = o.Estatus
WHERE o.Fecha >= DATE_FORMAT(DATE_SUB(CURDATE(), INTERVAL 2 MONTH), '%Y-%m-01')
  AND o.Fecha <  DATE_ADD(DATE_FORMAT(CURDATE(), '%Y-%m-01'), INTERVAL 1 MONTH)
GROUP BY e.IdEstatus, e.Descripcion
ORDER BY ordenes DESC";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }
    /**
     * 
     * Metodo para cargar todos los el estatus de los detalles 3 meses
     * @return void 
     */

    public function detalle_estatus_orden_3m_reporte()
    {   $estatusId = $this->estatusId;
        $sql = "SELECT
  o.IdOrden,
  DATE_FORMAT(o.Fecha, '%Y-%m-%d %H:%i:%s') AS Fecha,
  c.Nombre                           AS cliente,
  d.DeptoDescripcion                 AS transito,
  t.descripcion                      AS tipo_orden,
  u.Usuario                          AS vendedor,
  COALESCE(SUM(od.Neto), 0)          AS total
FROM ordenes o
JOIN ordenesdetalle od     ON od.IdOrden  = o.IdOrden
LEFT JOIN clientes c       ON c.IdCliente = o.IdCliente
LEFT JOIN departamentos d  ON d.IdDepto   = o.EstadoTransito
LEFT JOIN tipo_orden t     ON t.id        = o.TipoOrden
LEFT JOIN usuarios u       ON u.IdUsuario = o.IdUsuario
WHERE o.Fecha >= DATE_FORMAT(DATE_SUB(CURDATE(), INTERVAL 2 MONTH), '%Y-%m-01')
  AND o.Fecha <  DATE_ADD(DATE_FORMAT(CURDATE(), '%Y-%m-01'), INTERVAL 1 MONTH)
  AND o.Estatus = {$estatusId}
GROUP BY o.IdOrden, o.Fecha, c.Nombre, d.DeptoDescripcion, t.descripcion, u.Usuario
ORDER BY o.Fecha DESC, o.IdOrden DESC;
";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los usuarios
     * @return void 
     */

    public function ordenes_por_vendedor_3m_reporte()
    {
        $sql = "SELECT
  u.IdUsuario,
  u.Usuario           AS vendedor,
  COUNT(DISTINCT o.IdOrden) AS ordenes,
  COALESCE(SUM(od.Neto),0)  AS ingresos
FROM ordenes o
LEFT JOIN usuarios u    ON u.IdUsuario = o.IdUsuario
JOIN  ordenesdetalle od ON od.IdOrden  = o.IdOrden
WHERE o.Fecha >= DATE_FORMAT(DATE_SUB(CURDATE(), INTERVAL 2 MONTH), '%Y-%m-01')
  AND o.Fecha <  DATE_ADD(DATE_FORMAT(CURDATE(), '%Y-%m-01'), INTERVAL 1 MONTH)
GROUP BY u.IdUsuario, u.Usuario
ORDER BY ingresos DESC, ordenes DESC";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los usuarios
     * @return void 
     */

    public function ordenes_vendedor_categoria_3m_reporte()
    {
        $sql = "SELECT
  u.IdUsuario,
  u.Usuario        AS vendedor,
  cat.catId,
  cat.catNombre    AS categoria,
  COUNT(DISTINCT o.IdOrden) AS ordenes,
  COALESCE(SUM(od.Neto),0)  AS ingresos
FROM ordenes o
JOIN ordenesdetalle od ON od.IdOrden = o.IdOrden
JOIN productos p       ON p.proId   = od.IdProducto
LEFT JOIN categorias cat ON cat.catId = p.proCatId
LEFT JOIN usuarios u     ON u.IdUsuario = o.IdUsuario
WHERE o.Fecha >= DATE_FORMAT(DATE_SUB(CURDATE(), INTERVAL 2 MONTH), '%Y-%m-01')
  AND o.Fecha <  DATE_ADD(DATE_FORMAT(CURDATE(), '%Y-%m-01'), INTERVAL 1 MONTH)
GROUP BY u.IdUsuario, u.Usuario, cat.catId, cat.catNombre
ORDER BY u.Usuario, ingresos DESC";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }
    
    /**
     * 
     * Metodo para cargar todos los usuarios
     * @return void 
     */

    public function ordenes_por_tipo_orden_3m_reporte()
    {
        $sql = "SELECT
  t.id,
  t.descripcion AS tipo_orden,
  COUNT(DISTINCT o.IdOrden) AS ordenes,
  COALESCE(SUM(od.Neto),0)  AS ingresos
FROM ordenes o
LEFT JOIN tipo_orden t ON t.id = o.TipoOrden
JOIN  ordenesdetalle od ON od.IdOrden = o.IdOrden
WHERE o.Fecha >= DATE_FORMAT(DATE_SUB(CURDATE(), INTERVAL 2 MONTH), '%Y-%m-01')
  AND o.Fecha <  DATE_ADD(DATE_FORMAT(CURDATE(), '%Y-%m-01'), INTERVAL 1 MONTH)
GROUP BY t.id, t.descripcion
ORDER BY ordenes DESC";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los usuarios
     * @return void 
     */

    public function ordenes_recarga_mantenimiento_recall_reporte()
    {   $estatusId = $this->estatusId;
        $sql = "SELECT
            o.IdOrden,
            DATE_FORMAT(o.Fecha, '%Y-%m-%d %H:%i:%s') AS Fecha,
            o.IdUsuario,                   -- ← para filtrar por usuario en frontend
            u.Usuario         AS vendedor, -- nombre del vendedor
            c.IdCliente,
            c.Nombre          AS cliente,
            c.FisTelefono     AS telefono,
            c.FisEmail        AS email,
            COUNT(od.IdDetalle)           AS items,
            COALESCE(SUM(od.Cantidad),0)  AS unidades,
            COALESCE(SUM(od.Neto),0)      AS total,
            cm.IdOrden        AS orden_mes_actual,
            DATE_FORMAT(cm.Fecha, '%Y-%m-%d %H:%i:%s') AS fecha_mes_actual
            FROM ordenes o
            JOIN ordenesdetalle od  ON od.IdOrden  = o.IdOrden
            JOIN clientes c         ON c.IdCliente = o.IdCliente
            LEFT JOIN usuarios u    ON u.IdUsuario = o.IdUsuario
            LEFT JOIN (
            SELECT o2.IdCliente, MAX(o2.IdOrden) AS IdOrden, MAX(o2.Fecha) AS Fecha
            FROM ordenes o2
            WHERE o2.Fecha >= DATE_FORMAT(CURDATE(), '%Y-%m-01')
                AND o2.Fecha <  DATE_ADD(DATE_FORMAT(CURDATE(), '%Y-%m-01'), INTERVAL 1 MONTH)
            GROUP BY o2.IdCliente
            ) cm ON cm.IdCliente = o.IdCliente
            WHERE o.TipoOrden = 2
            AND o.Fecha >= DATE_FORMAT(DATE_SUB(CURDATE(), INTERVAL 11 MONTH), '%Y-%m-01')
            AND o.Fecha <  DATE_FORMAT(DATE_SUB(CURDATE(), INTERVAL 9  MONTH), '%Y-%m-01')
            GROUP BY
            o.IdOrden, o.Fecha, o.IdUsuario, u.Usuario, c.IdCliente, c.Nombre, c.FisTelefono, c.FisEmail,
            cm.IdOrden, cm.Fecha
            ORDER BY o.Fecha DESC, o.IdOrden DESC;
                ";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }


    /**
     * 
     * Metodo para cargar todos los usuarios
     * @return void 
     */

    public function detalle_orden_by_id_reporte()
    {   $IdOrden = $this->IdOrden;
        $sql = "SELECT
                od.IdDetalle,
                p.proSku,
                p.proTitulo     AS producto,
                od.Cantidad,
                od.PrecioVenta,
                od.Neto
                FROM ordenesdetalle od
                LEFT JOIN productos p ON p.proId = od.IdProducto
                WHERE od.IdOrden = {$IdOrden}
                ORDER BY od.IdDetalle";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }
    

     /**
     * 
     * Metodo para cargar todos los usuarios
     * @return void 
     */

    public function ventasGenerales()
    {
        $sql = $this->sentencia;
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los usuarios
     * @return void 
     */

    public function ventasPorProducto()
    {
        $sql = $this->sentencia;
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }


    /**
     * 
     * Metodo para cargar todos los usuarios
     * @return void 
     */

    public function ventasPorCategoria()
    {
        $sql = $this->sentencia;
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }


    /**
     * 
     * Metodo para cargar todos los usuarios
     * @return void 
     */

    public function all2()
    {  
         $departamento = $this->departamento;
         $sentencia = "AND x.IdDepto NOT IN (9)";
         $filtradotodo = $this->filtrado;
         if($departamento == 9){
            $sentencia = "AND x.IdDepto = $this->departamento";
         }
         if($filtradotodo == 1){
            $sentencia = "";
         }
         $dbDetails = array(
            'host' => DB_HOST,
            'user'=> DB_USER,
            'pass'=> DB_PASS,
            'db' => DB_NAME
         );

         $table = <<<EOT
            (
            SELECT
            o.IdOrden,
            o.FolioOrden,
            o.IdCliente,
            o.IdDomicilio,
            o.Fecha,
            o.Descripcion,
            o.Tipo,
            o.Estatus,
            o.Descuento,
            o.IdUSuario,
            o.EstadoTransito,
            o.PagadoCompleto AS PagadoCompleto,
            c.Nombre,
            c.RFC,
            c.Clave,
            c.fisTelefono,
            c.FisEmail,
            c.FisCalle,
            c.FisNExt,
            c.FisNInt,
            c.FisColonia,
            c.FisCP,
            c.FisMunicipio,
            c.FisEstado,
            c.Persona,
            c.CFDI,
            c.RegimenFiscal,
            COUNT(d.IdDetalle) AS Items,
            SUM(d.Neto) AS TotalOrden,
            SUM(REPLACE(FORMAT(neto * .16,2), ',', '')) as iva,
            e.Descripcion AS NombreEstatus,
            u.Usuario AS NombreUsuario,
            t.descripcion AS NombreTipoOrden,
            o.TipoOrden,
            x.DeptoDescripcion
            FROM ordenes o LEFT JOIN clientes c ON o.IdCliente = c.IdCliente
            LEFT JOIN tipo_orden t ON o.TipoOrden = t.id
            LEFT JOIN estatus e ON o.Estatus = e.IdEstatus
            LEFT JOIN usuarios u ON o.IdUSuario = u.IdUsuario
            LEFT JOIN departamentos x ON o.EstadoTransito = x.IdDepto
            LEFT JOIN ordenesdetalle d ON o.IdOrden = d.IdOrden 
            WHERE IdEstatus NOT IN (5,6,9,14,27) $sentencia 
            GROUP BY o.IdOrden ORDER BY o.Fecha ASC) temp
            EOT;

         $primaryKey = 'IdOrden';

         $columns = array(
            array('db' => 'IdOrden', 'dt' => 'IdOrden'),
            array('db' => 'FolioOrden', 'dt' => 'FolioOrden'),
            array('db' => 'IdCliente',  'dt' => 'IdCliente'),
            array('db' => 'IdDomicilio',   'dt' => 'IdDomicilio'),
            array('db' => 'Fecha',     'dt' => 'Fecha'),
            array('db' => 'Descripcion',     'dt' => 'Descripcion'),
            array('db' => 'Tipo',     'dt' => 'Tipo'),
            array('db' => 'Estatus',     'dt' => 'Estatus'),
            array('db' => 'Descuento',     'dt' => 'Descuento'),
            array('db' => 'IdUSuario',     'dt' => 'IdUSuario'),
            array('db' => 'EstadoTransito',     'dt' => 'EstadoTransito'),
            array('db' => 'PagadoCompleto',     'dt' => 'PagadoCompleto'),
            array('db' => 'Nombre',     'dt' => 'Nombre'),
            array('db' => 'RFC',     'dt' => 'RFC'),
            array('db' => 'Clave',     'dt' => 'Clave'),
            array('db' => 'fisTelefono',     'dt' => 'fisTelefono'),
            array('db' => 'FisEmail',     'dt' => 'FisEmail'),
            array('db' => 'FisCalle',     'dt' => 'FisCalle'),
            array('db' => 'FisNExt',     'dt' => 'FisNExt'),
            array('db' => 'FisNInt',     'dt' => 'FisNInt'),
            array('db' => 'FisColonia',     'dt' => 'FisColonia'),
            array('db' => 'FisCP',     'dt' => 'FisCP'),
            array('db' => 'FisMunicipio',     'dt' => 'FisMunicipio'),
            array('db' => 'FisEstado',     'dt' => 'FisEstado'),
            array('db' => 'Persona',     'dt' => 'Persona'),
            array('db' => 'CFDI',     'dt' => 'CFDI'),
            array('db' => 'RegimenFiscal',     'dt' => 'RegimenFiscal'),
            array('db' => 'Items',     'dt' => 'Items'),
            array('db' => 'TotalOrden',     'dt' => 'TotalOrden'),
            array('db' => 'iva',     'dt' => 'iva'),
            array('db' => 'NombreEstatus',     'dt' => 'NombreEstatus'),
            array('db' => 'NombreUsuario',     'dt' => 'NombreUsuario'),
            array('db' => 'NombreTipoOrden',     'dt' => 'NombreTipoOrden'),
            array('db' => 'TipoOrden',     'dt' => 'TipoOrden'),
            array('db' => 'DeptoDescripcion',     'dt' => 'DeptoDescripcion')
       
        );

        return json_encode(
            parent::simple($_POST, $dbDetails, $table, $primaryKey, $columns)
        );
    }

    /**
     * 
     * Metodo para cargar todos los usuarios
     * @return void 
     */

    public function all_entregadasx_fechas()
    {
        $sql = "SELECT o.IdOrden, o.FolioOrden, o.IdCliente, o.IdDomicilio, o.Fecha, o.Descripcion, o.Tipo, o.Estatus, o.Descuento, o.IdUSuario, o.EstadoTransito,o.PagadoCompleto AS PagadoCompleto, c.Nombre,c.RFC,c.Clave,c.fisTelefono,c.FisEmail,c.FisCalle,c.FisNExt,c.FisNInt,c.FisColonia,c.FisCP,c.FisMunicipio,c.FisEstado,c.Persona,c.CFDI,c.RegimenFiscal,
        COUNT(d.IdDetalle) AS Items, SUM(d.Neto) AS TotalOrden, SUM(REPLACE(FORMAT(neto * .16,2), ',', '')) as iva,e.Descripcion AS NombreEstatus, u.Usuario AS NombreUsuario,
           t.descripcion AS NombreTipoOrden, o.TipoOrden, x.DeptoDescripcion 
        FROM ordenes o LEFT JOIN clientes c ON o.IdCliente = c.IdCliente
        LEFT JOIN tipo_orden t ON o.TipoOrden = t.id
        LEFT JOIN estatus e ON o.Estatus = e.IdEstatus
        LEFT JOIN usuarios u ON o.IdUSuario = u.IdUsuario
        LEFT JOIN departamentos x ON o.EstadoTransito = x.IdDepto
        LEFT JOIN ordenesdetalle d ON o.IdOrden = d.IdOrden 
        WHERE IdEstatus IN (14,27) GROUP BY o.IdOrden ORDER BY o.Fecha ASC;";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los usuarios
     * @return void 
     */

    public function all_departamento()
    {
        $usuariotransito = $this->EstadoTransito;
        if($usuariotransito == 19){
        $sql = "SELECT o.IdOrden, o.FolioOrden, o.IdCliente, o.IdDomicilio, o.Fecha, o.Descripcion, o.Tipo, o.Estatus, o.EstadoTransito,o.Descuento,o.PagadoCompleto AS PagadoCompleto, o.FechaInicioPipc, o.FechaTerminoPipc, c.Nombre, COUNT(d.IdDetalle) AS Items, SUM(d.Neto) AS TotalOrden, SUM(REPLACE(FORMAT(neto * .16,2), ',', '')) as iva, e.Descripcion AS NombreEstatus, u.Usuario AS NombreUsuario,
           t.descripcion AS NombreTipoOrden, o.TipoOrden, x.DeptoDescripcion 
        FROM ordenes o LEFT JOIN clientes c ON o.IdCliente = c.IdCliente
        LEFT JOIN tipo_orden t ON o.TipoOrden = t.id
        LEFT JOIN estatus e ON o.Estatus = e.IdEstatus
        LEFT JOIN usuarios u ON o.IdUSuario = u.IdUsuario
        LEFT JOIN departamentos x ON o.EstadoTransito = x.IdDepto
        LEFT JOIN ordenesdetalle d ON o.IdOrden = d.IdOrden 
        WHERE IdEstatus NOT IN (14,5,6) AND o.PagadoCompleto IN (0,2,3) GROUP BY o.IdOrden ORDER BY o.IdOrden DESC;";
        }else if($usuariotransito == 12){
           $sql = "SELECT o.IdOrden, o.FolioOrden, o.IdCliente, o.IdDomicilio, o.Fecha, o.Descripcion, o.Tipo, o.Estatus, o.EstadoTransito,o.Descuento,o.PagadoCompleto AS PagadoCompleto,o.FechaInicioPipc, o.FechaTerminoPipc, c.Nombre,
        COUNT(d.IdDetalle) AS Items, COALESCE(SUM(d.Cantidad * d.PrecioVenta),0) AS TotalOrden,SUM(REPLACE(FORMAT(neto * .16,2), ',', '')) as iva, e.Descripcion AS NombreEstatus, u.Usuario AS NombreUsuario,
           t.descripcion AS NombreTipoOrden, o.TipoOrden, x.DeptoDescripcion 
        FROM ordenes o LEFT JOIN clientes c ON o.IdCliente = c.IdCliente
        LEFT JOIN tipo_orden t ON o.TipoOrden = t.id
        LEFT JOIN estatus e ON o.Estatus = e.IdEstatus
        LEFT JOIN usuarios u ON o.IdUSuario = u.IdUsuario
        LEFT JOIN departamentos x ON o.EstadoTransito = x.IdDepto
        LEFT JOIN ordenesdetalle d ON o.IdOrden = d.IdOrden 
        WHERE IdEstatus NOT IN (14,5,6) AND o.EstadoTransito IN ($this->EstadoTransito,21) GROUP BY o.IdOrden ORDER BY o.IdOrden DESC;"; 
        }else if($usuariotransito == 16){
           $sql = "SELECT o.IdOrden, o.FolioOrden, o.IdCliente, o.IdDomicilio, o.Fecha, o.Descripcion, o.Tipo, o.Estatus, o.EstadoTransito,o.Descuento,o.PagadoCompleto AS PagadoCompleto, o.FechaInicioPipc, o.FechaTerminoPipc, c.Nombre,
        COUNT(d.IdDetalle) AS Items, COALESCE(SUM(d.Cantidad * d.PrecioVenta),0) AS TotalOrden,SUM(REPLACE(FORMAT(neto * .16,2), ',', '')) as iva, e.Descripcion AS NombreEstatus, u.Usuario AS NombreUsuario,
           t.descripcion AS NombreTipoOrden, o.TipoOrden, x.DeptoDescripcion 
        FROM ordenes o LEFT JOIN clientes c ON o.IdCliente = c.IdCliente
        LEFT JOIN tipo_orden t ON o.TipoOrden = t.id
        LEFT JOIN estatus e ON o.Estatus = e.IdEstatus
        LEFT JOIN usuarios u ON o.IdUSuario = u.IdUsuario
        LEFT JOIN departamentos x ON o.EstadoTransito = x.IdDepto
        LEFT JOIN ordenesdetalle d ON o.IdOrden = d.IdOrden 
        WHERE IdEstatus NOT IN (14,5,6) AND o.EstadoTransito IN ($this->EstadoTransito,21) GROUP BY o.IdOrden ORDER BY o.IdOrden DESC;"; 
        }else{
           $sql = "SELECT o.IdOrden, o.FolioOrden, o.IdCliente, o.IdDomicilio, o.Fecha, o.Descripcion, o.Tipo, o.Estatus, o.EstadoTransito,o.Descuento,o.PagadoCompleto AS PagadoCompleto, o.FechaInicioPipc, o.FechaTerminoPipc, c.Nombre,
        COUNT(d.IdDetalle) AS Items, COALESCE(SUM(d.Cantidad * d.PrecioVenta),0) AS TotalOrden, SUM(REPLACE(FORMAT(neto * .16,2), ',', '')) as iva, e.Descripcion AS NombreEstatus, u.Usuario AS NombreUsuario,
           t.descripcion AS NombreTipoOrden, o.TipoOrden, x.DeptoDescripcion 
        FROM ordenes o LEFT JOIN clientes c ON o.IdCliente = c.IdCliente
        LEFT JOIN tipo_orden t ON o.TipoOrden = t.id
        LEFT JOIN estatus e ON o.Estatus = e.IdEstatus
        LEFT JOIN usuarios u ON o.IdUSuario = u.IdUsuario
        LEFT JOIN departamentos x ON o.EstadoTransito = x.IdDepto
        LEFT JOIN ordenesdetalle d ON o.IdOrden = d.IdOrden 
        WHERE IdEstatus NOT IN (14,5,6) AND o.EstadoTransito = $this->EstadoTransito GROUP BY o.IdOrden ORDER BY o.IdOrden DESC;"; 
        }
        
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para el detalle de una orden InvoiceRelacionado y ordenRelacionada hay que revisar
     * @return void 
     */
    public function detalle()
    {   $separar = $this->separar;

        if($this->pdfval == 1){
            if($separar == 1){
                $separar = "GROUP BY o.Partida";
            }else{
                $separar = "GROUP BY p.prodClave";
            }
            $sql = "SELECT o.IdDetalle,o.IdOrden,o.FolioOrden,o.Partida,o.IdProducto,sum(o.Cantidad) as Cantidad,o.Entregados,o.PrecioVenta,o.ClaveExtintor,o.DescuentoDetalle,sum(o.DescPesos) as DescPesos,sum(o.Neto) as Neto, o.ObjImpuesto,o.PartidaInvoce,o.DescripcionNueva,o.agendaCap,o.fechaCapacitacionOrd,o.Eliminado, c.id, p.proId, p.proAlmId, p.proCatId, p.prodClave, p.proTitulo, p.proPreciocosto,p.proExistencia, p.proPrecioventa, p.proSku, p.proImagen, p.proSubCategoria,p.proMoneda,p.ClaveSat,p.UnidadSat
        FROM ordenesdetalle o LEFT JOIN productos p ON o.IdProducto = p.proId 
          LEFT JOIN compras c ON o.idOrden = c.idOrden
          WHERE o.IdOrden= :IdOrden AND o.Eliminado NOT IN(1) $separar";
      }else{
        $sql = "SELECT o.*, c.id, p.proId, p.proAlmId, p.proCatId, p.prodClave, p.proTitulo, p.proPreciocosto,p.proExistencia, p.proPrecioventa, p.proSku, p.proImagen, p.proSubCategoria,p.proMoneda
        FROM ordenesdetalle o LEFT JOIN productos p ON o.IdProducto = p.proId 
          LEFT JOIN compras c ON o.idOrden = c.idOrden
          WHERE o.IdOrden= :IdOrden";
      }

        try {
            return ($rows = parent::query($sql, ['IdOrden' => $this->IdOrden])) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para el detalle de una orden InvoiceRelacionado y ordenRelacionada hay que revisar
     * @return void 
     */
    public function detalle_cantidad_cero_pdf()
    {
    
            $sql = "SELECT * FROM ordenesdetalle o WHERE o.IdOrden=:IdOrden AND o.Eliminado NOT IN(1);";

        try {
            return ($rows = parent::query($sql, ['IdOrden' => $this->IdOrden])) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }


    /**
     * 
     * Metodo para el detalle de una orden InvoiceRelacionado y ordenRelacionada hay que revisar
     * @return void 
     */
    public function contarproductos()
    {
        $sql = "SELECT COUNT(o.IdProducto) AS contarproductos, o.IdProducto, c.id, p.proId, p.proAlmId, p.proCatId, p.prodClave, p.proTitulo, p.proPreciocosto,p.proExistencia, p.proPrecioventa, p.proSku, p.proImagen, p.proSubCategoria,p.proMoneda
        FROM ordenesdetalle o LEFT JOIN productos p ON o.IdProducto = p.proId 
          LEFT JOIN compras c ON o.idOrden = c.idOrden
          WHERE o.IdOrden = :IdOrden GROUP BY o.IdProducto";
  
        try {
            return ($rows = parent::query($sql, ['IdOrden' => $this->IdOrden])) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }


    /**
     * 
     * Metodo para el detalle de una orden InvoiceRelacionado y ordenRelacionada hay que revisar
     * @return void 
     */
    public function codiget_ondenes_duplicadas()
    {
        $sql = "SELECT o.IdCliente, o.IdOrden, o.EstadoTransito, o.TipoOrden, cd.IdProducto, cd.Cantidad FROM ordenes o LEFT JOIN ordenesdetalle cd ON o.IdOrden = cd.IdOrden WHERE o.IdCliente = :IdCliente AND o.TipoOrden = :TipoOrden AND o.EstadoTransito NOT IN (5,6,9,14,27,29)";
  
        try {
            return ($rows = parent::query($sql, ['IdCliente' => $this->IdCliente, 'TipoOrden' => $this->TipoOrden])) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    public function detalle_para_invoice()
    {
        $suma = $this->suma;
        $separar = $this->separar;
        $groupby = "";
        if($suma == 0){
            $groupby = "GROUP BY p.prodClave";
        }else{
            $groupby = "GROUP BY o.IdOrden , p.prodClave";
        }

        if($separar == 1){
            $groupby = "GROUP BY o.Partida";
        }

        if($this->pdfval == 1 AND $this->ordenRelacionada == ''){
            $sql = "SELECT o.IdDetalle,o.IdOrden,o.FolioOrden,o.Partida,o.IdProducto,sum(o.Cantidad) as Cantidad,o.Entregados,o.PrecioVenta,o.ClaveExtintor,o.DescuentoDetalle,sum(o.DescPesos) as DescPesos,sum(o.Neto) as Neto, o.ObjImpuesto, o.PartidaInvoce, o.AdelantoPrecio as AdelaPrecio, o.DescripcionNueva, o.Eliminado, c.id, p.proId, p.proAlmId, p.proCatId, p.prodClave, p.proTitulo, p.proPreciocosto,p.proExistencia, p.proPrecioventa, p.proSku, p.proImagen, p.proSubCategoria,p.proMoneda,p.ClaveSat,p.UnidadSat
        FROM ordenesdetalle o LEFT JOIN productos p ON o.IdProducto = p.proId 
          LEFT JOIN compras c ON o.idOrden = c.idOrden
          WHERE o.IdOrden=$this->IdOrden AND o.PartidaInvoce=$this->PartidaInvoce AND o.Eliminado NOT IN(1) $groupby";
      }else if($this->pdfval == 1 AND $this->ordenRelacionada != ''){
        $sql = "SELECT o.IdDetalle,o.IdOrden,o.FolioOrden,o.Partida,o.IdProducto,sum(o.Cantidad) as Cantidad,o.Entregados,o.PrecioVenta,o.ClaveExtintor,o.DescuentoDetalle,sum(o.DescPesos) as DescPesos,sum(o.Neto) as Neto, o.ObjImpuesto, o.PartidaInvoce, o.AdelantoPrecio as AdelaPrecio, o.DescripcionNueva, o.Eliminado, c.id, p.proId, p.proAlmId, p.proCatId, p.prodClave, p.proTitulo, p.proPreciocosto,p.proExistencia, p.proPrecioventa, p.proSku, p.proImagen, p.proSubCategoria,p.proMoneda,p.ClaveSat,p.UnidadSat
        FROM ordenesdetalle o LEFT JOIN productos p ON o.IdProducto = p.proId 
          LEFT JOIN compras c ON o.idOrden = c.idOrden
          WHERE o.IdOrden IN ($this->IdOrden,$this->ordenRelacionada) AND o.PartidaInvoce=$this->PartidaInvoce AND o.Eliminado NOT IN(1) $groupby";
      }else{
        $sql = "SELECT o.*, c.id, p.proId, p.proAlmId, p.proCatId, p.prodClave, p.proTitulo, p.proPreciocosto,p.proExistencia, p.proPrecioventa, p.proSku, p.proImagen, p.proSubCategoria,p.proMoneda
        FROM ordenesdetalle o LEFT JOIN productos p ON o.IdProducto = p.proId 
          LEFT JOIN compras c ON o.idOrden = c.idOrden
          WHERE o.IdOrden=$this->IdOrden AND o.PartidaInvoce=$this->PartidaInvoce AND o.Eliminado NOT IN(1)";
      }
 
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

        /**
     * 
     * Metodo para el detalle de una orden
     * @return void 
     */

    public function detallediferente()
    {   $suma = $this->suma;
        $groupby = "";
        if($suma == 0){
            $groupby = "GROUP BY p.prodClave";
        }
        $sql = "SELECT DISTINCT o.*, c.id, cd.idProducto as idprodcompradetalle, cd.recibido as recibidodetalle,cd.cantidad as cantidaddetalle,p.proId, p.proAlmId, p.proCatId, p.prodClave, p.proTitulo, p.proPreciocosto,p.proExistencia, p.proPrecioventa, p.proSku, p.proImagen, p.proSubCategoria,p.proMoneda
        FROM ordenesdetalle o LEFT JOIN productos p ON o.IdProducto = p.proId 
          LEFT JOIN compras c ON o.idOrden = c.idOrden
          LEFT JOIN comprasDetalle cd ON c.id = cd.idCompra
          WHERE o.IdOrden= :IdOrden $groupby";
        try {
            return ($rows = parent::query($sql, ['IdOrden' => $this->IdOrden])) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para el detalle de una orden
     * @return void 
     */

    public function detalle_con_compra()
    {   
        $sql = "SELECT DISTINCT o.IdDetalle, o.*, c.id, cd.idProducto as idprodcompradetalle,cd.recibido as recibidodetalle,cd.cantidad as cantidaddetalle,p.proId, p.proAlmId, p.proCatId, p.prodClave, p.proTitulo, p.proPreciocosto,p.proExistencia, p.proPrecioventa, p.proSku, p.proImagen, p.proSubCategoria, p.proMoneda
        FROM ordenesdetalle o LEFT JOIN productos p ON o.IdProducto = p.proId 
          LEFT JOIN compras c ON o.idOrden = c.idOrden
          LEFT JOIN comprasDetalle cd ON c.id = cd.idCompra  
          WHERE o.IdOrden= :IdOrden AND cd.idProducto = o.IdProducto";
        try {
            return ($rows = parent::query($sql, ['IdOrden' => $this->IdOrden])) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar un registro usando su id
     * @return void 
     */

    public function one()
    {
        $sql = "SELECT o.IdOrden, o.FolioOrden, o.IdCliente, o.IdDomicilio, o.Fecha, o.Descripcion, o.Tipo, o.Descuento, o.TipoPago, o.Estatus, o.EstadoTransito, o.TipoServicio, o.TipoOrden, o.IdUsuario,o.llaveOrden,o.autorizacionOrden,o.llaveOrdenAutorizacion,o.AceptarOrdenTaller,o.totalComision,o.PagadoCompleto,o.OrdenesRelacionadas,o.InvoiceRelacionado,o.InvoiceRelacionado,o.urlCroquis,o.urlPago,o.Siniva,o.FechaInicioPipc,o.FechaTerminoPipc,o.Domprogramaintero,o.Percontacto,o.Telecontacto,o.Mailcontacto,o.duplicadoorden,o.contadorjson,o.porcentajejson, o.alimentosli, o.transporteli, o.dc3li, o.textocursos, o.urlfirma,o.Nombrerecibe,o.Separaproductos,n.Leido,n.Usuario as UsuarioNotificacion,n.IdNoti,n.Departamento, c.Nombre, 
        c.FisTelefono, c.FisEmail,c.urlConstanciaCliente, d.EntCalle, d.EntNExt, d.EntColonia, d.EntCP, d.EntMunicipio, d.EntEstado, d.EntDesde,d.EntHasta, d.EntCruces, d.EntObservaciones,
        e.Descripcion AS NombreEstatus, t.descripcion AS NombreTipoOrden, x.DeptoDescripcion, u.Usuario AS NombreUsuario, u.Telefono as telvendedor
        FROM ordenes o 
        LEFT JOIN clientes c ON o.IdCliente = c.IdCliente 
        LEFT JOIN domentregacltes d ON o.IdDomicilio = d.IdDomicilio 
        LEFT JOIN tipo_orden t ON o.TipoOrden = t.id
        LEFT JOIN estatus e ON o.Estatus = e.IdEstatus
        LEFT JOIN departamentos x ON o.EstadoTransito = x.IdDepto
        LEFT JOIN usuarios u ON o.IdUsuario = u.IdUsuario
        LEFT JOIN notificaciones n ON o.IdOrden = n.Folio
         WHERE o.IdOrden =:IdOrden  ORDER BY n.IdNoti DESC LIMIT 1;";
        try {
            return ($rows = parent::query($sql, ['IdOrden' => $this->IdOrden])) ? $rows[0] : false;
        } catch (Exception $e) {
            throw $e;
        }
    }


    /**
     * 
     * Metodo para cargar un registro usando su id
     * @return void 
     */

    public function one_orden()
    {   $tabla = $this->tabla;
        $key = "IdCotizacion";
        if($tabla == "ordenes"){
            $key = "o.IdOrden";
        }
        $buscar = $this->IdCliente;
        $IdOrden = $this->IdOrden;
        $variabletabla = "o.IdCliente";
        if($IdOrden != ""){
            $variabletabla ="o.IdOrden";
            $buscar = $this->IdOrden;
        }

        $sql = "SELECT $key, o.Fecha, o.Estatus, o.EstadoTransito,o.TipoOrden,o.IdFactura, e.Descripcion AS NombreEstatus, t.descripcion AS NombreTipoOrden,x.DeptoDescripcion FROM $tabla o 
        LEFT JOIN estatus e ON o.Estatus = e.IdEstatus
        LEFT JOIN departamentos x ON o.EstadoTransito = x.IdDepto
        LEFT JOIN tipo_orden t ON o.TipoOrden = t.id 
        WHERE $variabletabla = $buscar ORDER BY $key DESC";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar un registro usando su id
     * @return void 
     */

    public function one_calendario()
    {
        $sql = "SELECT o.IdOrden,od.Partida,p.proSku,p.proTitulo FROM ordenes o LEFT JOIN ordenesdetalle od ON o.IdOrden = od.IdOrden  LEFT JOIN productos p ON od.IdProducto = p.proId
         WHERE o.IdOrden =:IdOrden";
        try {
            return ($rows = parent::query($sql, ['IdOrden' => $this->IdOrden])) ? $rows[0] : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Obtener max id y sumarle 1
     * @return void 
     */

    public function folio($longitud)
    {
        $sql = "SELECT MAX(IdOrden) as Folio FROM ordenes LIMIT 1";
        try {

            $rows = parent::query($sql);
            $Folio = $rows[0]['Folio'];
            if ($Folio == "") {
                $Folio = 1;
            } else {
                $Folio++;
            }

            return (str_pad($Folio, $longitud, "0", STR_PAD_LEFT));
        } catch (Exception $e) {
            throw $e;
        }
    }


    /**
     * 
     * Obtener Vendedores
     * @return void 
     */

    public function vendedoresdatos()
    {
        $sql = "SELECT usu.IdUsuario,usu.Usuario,usu.activo,usu.Correo,o.IdOrden,o.Fecha, COUNT(DISTINCT o.IdOrden) as TotalOrdenes,SUM(o.TipoOrden = 1) as Equiponuevo,SUM(o.TipoOrden = 2) as RecargayMantenimiento, SUM(o.TipoOrden = 3) as Capacitaciones, SUM(o.TipoOrden = 6) as PiPc, SUM(o.TipoOrden = 7) as ProyectosEspeciales, SUM(OD.TotalDinero) as TotalDinero, SUM(case when o.TipoOrden = 1 then OD.TotalDinero else 0 end) as dineroequiponuevo,SUM(case when o.TipoOrden = 2 then OD.TotalDinero else 0 end) as dinerorecarga, SUM(case when o.TipoOrden = 3 then OD.TotalDinero else 0 end) as dinerocapacitaciones, SUM(case when o.TipoOrden = 6 then OD.TotalDinero else 0 end) as dineropipc,SUM(case when o.TipoOrden = 7 then OD.TotalDinero else 0 end) as dineroproyectoespecial, OD.odID FROM usuarios usu LEFT JOIN ordenes o ON o.IdUsuario = usu.IdUsuario INNER JOIN ( SELECT SUM(ordenesdetalle.Neto) as TotalDinero, ordenesdetalle.IdOrden as odID FROM ordenesdetalle GROUP BY odID) OD ON o.IdOrden = OD.odID WHERE usu.Departamento IN (8,17,9,25) AND o.Fecha BETWEEN '$this->FechaInicio 00:00:00' AND '$this->FechaTermino 23:59:59' GROUP BY usu.IdUsuario";

        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Obtener Vendedores
     * @return void 
     */

    public function codi_get_ordenes_ventas_individual()
    {
        $sql =  $this->sentencia;

        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los estatus
     * @return void 
     */

    public function estatus()
    {
        $sql = "SELECT * FROM estatus ORDER BY IdEstatus ASC;";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los departamentos
     * @return void 
     */

    public function departamentos()
    {
        $sql = "SELECT * FROM departamentos ORDER BY IdDepto  ASC;";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los ventasPorVendedor 1
     * @return void 
     */

    public function ventasPorVendedor()
    {
        $sql = $this->sentencia;
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los ventasPorVendedorTopProductos 2
     * @return void 
     */

    public function ventasPorVendedorTopProductos()
    {
        $sql = $this->sentencia;
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los ventasPorVendedorPorEstatus 3
     * @return void 
     */

    public function ventasPorVendedorPorEstatus()
    {
        $sql = $this->sentencia;
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los ventasPorVendedorPorTransito 4
     * @return void 
     */

    public function ventasPorVendedorPorTransito()
    {
        $sql = $this->sentencia;
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los ventasPorVendedorPorTransito 4
     * @return void 
     */

    public function pipcReportes()
    {
        $sql = $this->sentencia;
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los ventasPorVendedorPorTransito 4
     * @return void 
     */

    public function desgloseCapacitaciones()
    {
        $sql = $this->sentencia;
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los estatus
     * @return void 
     */

    public function talleractivos()
    {
        $sql = "SELECT * FROM ordenes WHERE TipoOrden = 2 AND EstadoTransito = 3";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los estatus
     * @return void 
     */

    public function talleractivosfechas()
    {   
        $FechaInicio = $this->FechaInicio;
        $FechaTermino = $this->FechaTermino;

        $sql = "SELECT * FROM ordenes WHERE TipoOrden = 2 AND EstadoTransito = 3 AND Fecha BETWEEN '$FechaInicio' AND '$FechaTermino'";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los estatus
     * @return void 
     */

    public function talleratendidashoy()
    {   
        $FechaInicio = date("Y-m-d");
        $sql = "SELECT * FROM ordenes WHERE TipoOrden = 2 AND fechaaceptadataller = '$FechaInicio'";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los estatus
     * @return void 
     */

    public function cantidad_ordenes_almacen()
    {   
        $FechaInicio = date("Y-m-d");
        $sql = "SELECT * FROM ordenes WHERE EstadoTransito = 12";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los estatus
     * @return void 
     */

    public function reparto_datos()
    {   
        $FechaInicio = $this->FechaInicio;
        $FechaTermino = $this->FechaTermino;

        $sql = "SELECT * FROM ordenes WHERE EstadoTransito IN (14,16,21,22,27) AND TipoOrden IN (1,2) AND Fecha BETWEEN '$FechaInicio' AND '$FechaTermino'";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los estatus
     * @return void 
     */

    public function reparto_statusreparto()
    {   
        $FechaInicio = $this->FechaInicio;
        $FechaTermino = $this->FechaTermino;

        $sql = "SELECT od.*,usu.IdUsuario,usu.Usuario,tpo.id,tpo.descripcion FROM ordenes od LEFT JOIN usuarios usu ON  od.RepartoAsignado = usu.Departamento INNER JOIN tipo_orden tpo ON od.TipoOrden = tpo.id WHERE EstadoTransito IN (14,21,22,27) AND TipoOrden IN (1,2) AND Fecha BETWEEN '$FechaInicio' AND '$FechaTermino'";
        
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }
 

    /**
     * 
     * Metodo para cargar todos los estatus
     * @return void 
     */

    public function cantidades_disperas()
    {   
        $FechaInicio = date("Y-m-d");
        $sql = "SELECT * FROM ordenes WHERE TipoOrden = 2 AND EstadoTransito NOT IN (3,27)";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los estatus
     * @return void 
     */

    public function pipc_traer_datos()
    {   

        $sql = "SELECT * FROM ordenes WHERE TipoOrden = 6 AND Estatus IN (2,3,4,11,12,25)";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los estatus
     * @return void 
     */

    public function codi_factura_cobradas()
    {   $FechaInicio = $this->FechaInicio;
        $FechaTermino  = $this->FechaTermino;

        $sql = "SELECT COUNT(od.IdOrden) as cantidad FROM `ordenes` od WHERE od.Fecha BETWEEN '$FechaInicio' AND '$FechaTermino' AND od.PagadoCompleto IN (4,11,12,25);";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los estatus
     * @return void 
     */

    public function codi_factura_x_cobrar()
    {   $FechaInicio = $this->FechaInicio;
        $FechaTermino  = $this->FechaTermino;

        $sql = "SELECT COUNT(od.IdOrden) as cantidad FROM `ordenes` od WHERE od.Fecha BETWEEN '$FechaInicio' AND '$FechaTermino' AND od.PagadoCompleto NOT IN (4,11,12,25,5,6);";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los estatus
     * @return void 
     */

    public function capa_traer_datos()
    {   

        $sql = "SELECT od.*, cl.IdCliente, cl.Nombre, cl.FisTelefono, cl.FisEmail FROM ordenes od INNER JOIN clientes cl ON od.IdCliente = cl.IdCliente WHERE TipoOrden = 3";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los estatus
     * @return void 
     */

    public function capa_traer_datos_detalle()
    {   

        $sql = "SELECT od.IdOrden, od.Estatus, od.Fecha, od.EstadoTransito, od.TipoOrden, od.PagadoCompleto, odet.IdOrden AS IdOdetalle, odet.Eliminado, odet.fechaCapacitacionOrd,odet.agendaCap, cal.evntEstatus, cal.IdOrden AS IdOcalendario, cal.PartidaO2, cl.IdCliente, cl.Nombre, cl.FisTelefono, cl.FisEmail FROM ordenes od INNER JOIN ordenesdetalle odet ON od.IdOrden = odet.IdOrden LEFT JOIN calendario cal ON od.IdOrden = cal.IdOrden INNER JOIN clientes cl ON od.IdCliente = cl.IdCliente WHERE od.TipoOrden = 3";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los estatus
     * @return void 
     */

    public function talleratendidasmes()
    {   
        $FechaInicio = $this->FechaInicio;
        $FechaTermino = $this->FechaTermino;

        $sql = "SELECT * FROM ordenes WHERE TipoOrden = 2 AND fechaaceptadataller BETWEEN '$FechaInicio' AND '$FechaTermino'";

        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los estatus
     * @return void 
     */

    public function slect_ordenes_anclabes()
    {
        $sql = "SELECT * FROM ordenes INNER JOIN departamentos ON ordenes.EstadoTransito = departamentos.IdDepto WHERE ordenes.IdCliente = $this->IdCliente AND ordenes.OrdenesRelacionadas = '0' AND ordenes.Estatus NOT IN (5,6,13,14)";

        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los estatus
     * @return void 
     */

    public function slect_ordenes_anclabes_invoice()
    {
        //AND ordenes.FolioFiscalActivo IS NULL
        $sql = "SELECT * FROM ordenes INNER JOIN departamentos ON ordenes.EstadoTransito = departamentos.IdDepto WHERE ordenes.IdCliente = $this->IdCliente  AND ordenes.Estatus NOT IN (5,6,13,14)";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los estatus
     * @return void 
     */

    public function slect_ordenes_anclabes_invoice_complemento()
    {
        //AND ordenes.FolioFiscalActivo IS NOT NULL
        $sql = "SELECT * FROM ordenes INNER JOIN departamentos ON ordenes.EstadoTransito = departamentos.IdDepto WHERE ordenes.IdCliente = $this->IdCliente AND ordenes.Estatus NOT IN (5,6)";

        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }
    

    /**
     * 
     * Metodo para cargar todos los estatus
     * @return void 
     */

    public function bloqueo_estatus($estatus)
    {
        $sql = "SELECT * FROM estatus WHERE IdEstatus IN ($estatus) ORDER BY IdEstatus ASC;";
        try {
            return ($rows = parent::query2($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los estatus
     * @return void 
     */

    public function bloqueo_transito($estatus)
    {
        $sql = "SELECT * FROM departamentos WHERE IdDepto IN ($estatus) ORDER BY DeptoDescripcion ASC;";
        try {
            return ($rows = parent::query2($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para actualizar un registro de la bd
     * @return bool 
     */

    public function update()
    {   $estadotras = $this->EstadoTransito;
        if($estadotras == 14 ||  $estadotras == 22){

        }else{
            $estadotras = 0;
        }
   
        $sql = "UPDATE ordenes SET  TipoPago=:TipoPago,Estatus=:Estatus, EstadoTransito=:EstadoTransito, TipoOrden=:TipoOrden, TipoServicio=:TipoServicio, Descripcion=:Descripcion,PagadoCompleto = :PagadoCompleto, RepartoAsignado = :RepartoAsignado
        WHERE IdOrden=:IdOrden";
        $data =
            [   'TipoPago' => $this->TipoPago,
                'Estatus' => $this->Estatus,
                'EstadoTransito' => $this->EstadoTransito,
                'TipoOrden' => $this->TipoOrden,
                'TipoServicio' => $this->TipoServicio,
                'Descripcion' => $this->Descripcion,
                'PagadoCompleto' => $this->pagocompleto,
                'RepartoAsignado' => $estadotras,
                'IdOrden' => $this->IdOrden,
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para actualizar un registro de la bd
     * @return bool 
     */

    public function relacionar_invoice_orden()
    {
        $sql = "UPDATE ordenes SET InvoiceRelacionado=:InvoiceRelacionado WHERE IdOrden=:IdOrden";
        $data =
            [
                'InvoiceRelacionado' => $this->IdInvoice,
                'IdOrden' => $this->IdOrden
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para actualizar un registro de la bd
     * @return bool 
     */

    public function updateorden_desde_compra_cancelada()
    {
        $sql = "UPDATE ordenes SET Estatus=:Estatus WHERE IdOrden=:IdOrden";
        $data =
            [
                'Estatus' => 29,
                'IdOrden' => $this->IdOrden
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para actualizar un registro de la bd
     * @return bool 
     */

    public function conteo_invoice()
    {   $nuevoconteo = $this->IdInvoice + 1;
        $sql = "UPDATE Foliocomplemento SET conteo=:conteo";
        $data =
            [
                'conteo' => $nuevoconteo
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }


    /**
     * 
     * Metodo para agregar nuevo usuario
     * @return integer 
     */

    public function insert_factura_complemento()
    {   
   
        $sql = "INSERT INTO complementospagos (IdOrden, ComplementoUid, PartialityNumber, PreviousBalanceAmount, AmountPaid, ImpSaldoInsoluto, FechaPago,idFolio, idFolioFactura) 
                VALUES (:IdOrden, :ComplementoUid, :PartialityNumber, :PreviousBalanceAmount, :AmountPaid, :ImpSaldoInsoluto, :FechaPago,:idFolio, :idFolioFactura)";

        $data =
            [
                'IdOrden' => $this->IdOrden,
                'ComplementoUid' => $this->IdFactura,
                'PartialityNumber' => $this->numeropago,
                'PreviousBalanceAmount' => $this->PreviousBalanceAmount,
                'AmountPaid' => $this->AmountPaid,
                'ImpSaldoInsoluto' => $this->ImpSaldoInsoluto,
                'FechaPago' => $this->Fecha,
                'idFolio'=>$this->IdInvoice,
                'idFolioFactura'=>$this->folionuevo

            ];
        try {
            return ($this->IdOrden = parent::query($sql, $data)) ? $this->IdOrden : false;
        } catch (Exception $e) {
            throw $e;
        }
    }


    /**
     * 
     * Metodo para agregar nuevo usuario
     * @return integer 
     */

    public function insert_ancla()
    {   
   
        $sql = "UPDATE ordenes SET OrdenesRelacionadas='$this->ancla' WHERE IdOrden=$this->IdOrden";
        try {
            return ($this->IdOrden = parent::query($sql)) ? $this->IdOrden : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para agregar nuevo usuario
     * @return integer 
     */

    public function insert_fecha_pipc()
    {   
   
        $sql = "UPDATE ordenes SET FechaInicioPipc='$this->FechaInicioPipc', FechaTerminoPipc='$this->FechaTerminoPipc' WHERE IdOrden=$this->IdOrden";

        try {
            return ($this->IdOrden = parent::query($sql)) ? $this->IdOrden : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para actualizar un registro de la bd
     * @return bool 
     */

    public function update_factura_Id()
    {   $partida = $this->Partida;

        if($partida != 1){
            $sql = "UPDATE ordenes SET TipoPago=:TipoPago, PublicoGeneral=:PublicoGeneral, RfcEmisor=:RfcEmisor,usoCdfi=:usoCdfi,MetPago=:MetPago,TipoFactura=:TipoFactura WHERE IdOrden=:IdOrden";
        $data =
            [   
                'TipoPago' => $this->Tipo,
                'IdOrden' => $this->IdOrden,
                'PublicoGeneral' => $this->Pgeneral,
                'RfcEmisor' => $this->rfcEmisor,
                'usoCdfi' => $this->usoCfdi,
                'MetPago' => $this->MP,
                'TipoFactura' => $this->tipoFactura
            ];
        }else{
            $sql = "UPDATE ordenes SET TipoPago=:TipoPago, IdFactura=:IdFactura, PublicoGeneral=:PublicoGeneral, RfcEmisor=:RfcEmisor,usoCdfi=:usoCdfi,MetPago=:MetPago,TipoFactura=:TipoFactura,FolioFiscalActivo=:FolioFiscalActivo WHERE IdOrden=:IdOrden";
        $data =
            [   
                'TipoPago' => $this->Tipo,
                'IdFactura' => $this->IdFactura,
                'IdOrden' => $this->IdOrden,
                'PublicoGeneral' => $this->Pgeneral,
                'RfcEmisor' => $this->rfcEmisor,
                'usoCdfi' => $this->usoCfdi,
                'MetPago' => $this->MP,
                'TipoFactura' => $this->tipoFactura,
                'FolioFiscalActivo' => $this->Foliofiscal,
            ];
        }
        

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }


    /**
     * 
     * Metodo para actualizar un registro de la bd
     * @return bool 
     */

    public function update_factura_Id_detalle()
    {
        $sql = "UPDATE ordenesdetalle SET ObjImpuesto=:ObjImpuesto WHERE IdOrden=:IdOrden AND Partida=:Partida";
        $data =
            [
                'ObjImpuesto' => $this->ObjImpuesto,
                'IdOrden' => $this->IdDetalle,
                'Partida' => $this->Partida
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para actualizar un registro de la bd
     * @return bool 
     */

    public function desfragmentar_detalleorden()
    {
        $sql = "UPDATE ordenesdetalle SET PartidaInvoce=:PartidaInvoce WHERE IdOrden=:IdOrden AND IdProducto=:IdProducto";
        $data =
            [
                'PartidaInvoce' => $this->PartidaInvoce,
                'IdOrden' => $this->IdDetalle,
                'IdProducto' => $this->IdProducto
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para actualizar un registro de la bd
     * @return bool 
     */

    public function desfragmentar_detalleorden_cincuenta()
    {
        $sql = "UPDATE ordenesdetalle SET AdelantoPrecio=$this->PrecioVenta WHERE IdOrden=$this->IdDetalle AND IdProducto=$this->IdProducto";

        try {
            return (parent::query($sql)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para actualizar un registro de la bd
     * @return bool 
     */

    public function update_factura_Id_cancelar()
    {

        $sql = "UPDATE ordenes SET IdFactura=:IdFactura, MotivoCancelacion=:MotivoCancelacion, FolioCancelacionAnt=:FolioCancelacionAnt,IdCancelada=:IdCancelada WHERE IdOrden=:IdOrden";
        $data =
            [
                'IdFactura' => $this->IdFactura,
                'IdOrden' => $this->IdOrden,
                'MotivoCancelacion' => $this->Motivo,
                'FolioCancelacionAnt' => $this->IdFactAnterior,
                'IdCancelada' => $this->IdCancelada
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }


    /**
     * 
     * Metodo para actualizar un registro de la bd
     * @return bool 
     */

    public function update_factura_Id_cancelar_comple()
    {

        $sql = "UPDATE complementospagos SET Compleeliminado=:Compleeliminado, UUidCanceladoComple=:UUidCanceladoComple WHERE ComplementoUid=:ComplementoUid";
        $data =
            [
                'Compleeliminado' => 1,
                'UUidCanceladoComple' => $this->IdCancelada,
                'ComplementoUid' => $this->IdFactAnterior
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para actualizar un registro de la bd
     * @return bool 
     */

    public function updatecompraorden()
    {
        $sql = "UPDATE ordenes SET 
        Estatus=:Estatus
        WHERE IdOrden=:IdOrden";
        $data =
            [
                'Estatus' => 15,
                'IdOrden' => $this->IdOrden,
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

     /**
     * 
     * Metodo para actualizar un registro de la llave
     * @return bool 
     */

    public function updatellave()
    {
        $sql = "UPDATE ordenes SET autorizacionOrden=:autorizacionOrden, llaveOrdenAutorizacion=:llaveOrdenAutorizacion WHERE IdOrden=:IdOrden";
        $data =
            [
                'autorizacionOrden' => $this->autorizacionOrden,
                'llaveOrdenAutorizacion' => $this->llaveOrdenAutorizacion,
                'IdOrden' => $this->IdOrden
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }
/**
     * 
     * Metodo para actualizar un registro de la llave
     * @return bool 
     */
    public function updateordentaller()
    {
        $sql = "UPDATE ordenes SET Estatus=:Estatus, AceptarOrdenTaller=:AceptarOrdenTaller, fechaaceptadataller=:fechaaceptadataller WHERE IdOrden=:IdOrden";
        $data =
            [
                'Estatus' => 18,
                'AceptarOrdenTaller' => 1,
                'fechaaceptadataller' => date("Y-m-d"),
                'IdOrden' => $this->IdOrden,
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }


    /**
     * 
     * Metodo para actualizar un registro de la bd
     * @return bool 
     */

    public function update_estatus()
    {
        $sql = "UPDATE ordenes SET PagadoCompleto=:PagadoCompleto, Estatus=:Estatus WHERE IdOrden=:IdOrden";
        $data =
            [
                'Estatus' => $this->Estatus,
                /*'EstadoTransito' => $this->EstadoTransito,*/
                'PagadoCompleto' => $this->Estatus,
                'IdOrden' => $this->IdOrden
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para actualizar un registro de la bd
     * @return bool 
     */

    public function update_cursos()
    {
        $sql = "UPDATE ordenes SET alimentosli = :alimentosli, transporteli = :transporteli, dc3li = :dc3li, textocursos = :textocursos WHERE IdOrden=:IdOrden";
        $data =
            [ 
                'alimentosli' => $this->alimentosli,
                'transporteli' => $this->transporteli,
                'dc3li' => $this->dc3li,
                'textocursos' => $this->textocursos,
                'IdOrden' => $this->IdOrden
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para actualizar un registro de la bd
     * @return bool 
     */

    public function delete_detalle()
    {

        $sql = "DELETE FROM ordenesdetalle WHERE IdOrden=:IdOrden;";
        $data =
            [
                'IdOrden' => $this->IdOrden
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para actualizar un registro de la bd
     * @return bool 
     */

    public function update_calendario()
    {

       $sql = "UPDATE ordenesdetalle SET agendaCap=:agendaCap, fechaCapacitacionOrd=:fechaCapacitacionOrd WHERE IdOrden=:IdOrden AND Partida=:Partida";
        $data =
            [
                'Partida' => $this->Partida,
                'agendaCap' => $this->agendaCap,
                'fechaCapacitacionOrd' => $this->Fecha,
                'IdOrden' => $this->IdOrden 
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para actualizar un registro de la bd
     * @return bool 
     */

    public function update_estatus_transito_por_fechas()
    {
        $sql = "UPDATE ordenes SET 
        EstadoTransito=:EstadoTransito
        WHERE IdOrden=:IdOrden";
        $data =
            [
                'EstadoTransito' => 23,
                'IdOrden' => $this->IdOrden,
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    public function delete()
    {

        $sql = "UPDATE ordenes SET Estatus=:Estatus WHERE IdOrden=:IdOrden";
        $data =
            [
                'Estatus' => $this->Estatus,
                'IdOrden' => $this->IdOrden
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }
}
