<?php
class productosModel extends Model
{
    public $proId;
    public $prodClave;
    public $proAlmId;
    public $proCatId;
    public $proTitulo;
    public $proDescripcion;
    public $proPreciocosto;
    public $proExistencia;
    public $proPrecioventa;
    public $proEstatus;
    public $proSku;
    public $tipo;
    public $proImagen;

    public $trAlmacen;
    public $trCantidad;
    public $trUsuario;
    public $trPassword;

    public $cantidad;
    public $folioOrden; 
    public $proMarca;
    public $proCapacidad;
    public $proTipoExtintor;
    public $promotivo;
    public $proAlmIdNuevo;
    public $proMax;
    public $proMin;
    public $proMoneda;
    public $proTipoCambio;
    public $proSubCategoria;
    public $valentregados;
    public $actventas;
    public $temporal;
    public $online;
    public $preciopromo;
    public $fechafinal;
    public $fechainicial;
    public $clavesat;
    public $unidadsat;
    public $precioventaoriginal;

    public $sentencia;

    /**
     * 
     * Metodo para agregar nuevo usuario
     * @return integer 
     */

    public function add()
    {
        $proClave = random_strings(7);

        $sql = "INSERT INTO productos (prodClave, proTitulo, proAlmId, proDescripcion,proPreciocosto,proPrecioventa,proExistencia,proSku,proCatId,proMarca,proCapacidad,proTipoExtintor,proImagen,proMax,proMin,proMoneda,proTipoCambio,proSubCategoria,Activo,MostrarPagina,Temporal,ClaveSat,UnidadSat) VALUES (:proClave,:proTitulo, :proAlmId, '', :proPreciocosto,:proPrecioventa,:proExistencia,:proSku,:proCatId,:proMarca,:proCapacidad,:proTipoExtintor,:proImagen,:proMax,:proMin,:proMoneda,:proTipoCambio,:proSubCategoria,:Activo,:MostrarPagina,:Temporal,:ClaveSat,:UnidadSat)";
 
        if($this->proImagen == ""){
            $proImagen = "https://grupoxtinfire.com/admin/assets/img/imagen-no-dispoble.jpg";
        }else{
            $proImagen = procesarArchivo($this->proImagen);
        }
        $data =
            [
                'proClave' => $proClave,
                'proTitulo' => $this->proTitulo,
                'proAlmId' => $this->proAlmId,
                'proPreciocosto' => $this->proPreciocosto,
                'proPrecioventa' => $this->proPrecioventa,
                'proExistencia' => $this->proExistencia,
                'proSku' => $this->proSku,
                'proCatId' => $this->proCatId,
                'proMarca' => $this->proMarca,
                'proCapacidad' => $this->proCapacidad,
                'proTipoExtintor' => $this->proTipoExtintor,
                'proImagen' => $proImagen,
                'proMax' => $this->proMax,
                'proMin' => $this->proMin,
                'proMoneda' => $this->proMoneda,
                'proTipoCambio' => $this->proTipoCambio,
                'proSubCategoria' => $this->proSubCategoria,
                'Activo' => $this->actventas,
                'MostrarPagina' => $this->online,
                'Temporal' => $this->temporal,
                'ClaveSat' => $this->clavesat,
                'UnidadSat' => $this->unidadsat

            ];

        try {
            return ($this->proId = parent::query($sql, $data)) ? $this->proId : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para agregar nuevo usuario
     * @return integer 
     */

    public function asginarproducto()
    {

        $sql = "INSERT INTO insumosUsados (FolioOrden, NombreProducto, IdProducto, Cantidad,MotivoSolicitud,Sku) 
 VALUES (:FolioOrden,:NombreProducto, :IdProducto, :Cantidad,:MotivoSolicitud,:Sku)";

        $data =
            [
                'FolioOrden' => $this->folioOrden,
                'NombreProducto' => $this->proTitulo,
                'IdProducto' => $this->proId,
                'Cantidad' => $this->cantidad,
                'MotivoSolicitud' => $this->promotivo,
                'Sku' => $this->proSku,
            ];

        try {
            return ($this->proId = parent::query($sql, $data)) ? $this->proId : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los productos
     * @return void 
     */

    public function all()
    {
        $sql = "SELECT * FROM productos a INNER JOIN categorias b ON a.proCatId = b.catId INNER JOIN almacenes am ON a.proAlmId = am.almId INNER JOIN subCategorias sbc ON a.proSubCategoria = sbc.IdsubCategoria WHERE a.proEstatus = 1 ORDER BY  a.proId";
        //$sql = "SELECT p.proId, p.proImagen, p.proTitulo, p.proSku, p.proPreciocosto, p.proExistencia FROM productos p INNER JOIN categorias c ON p.proCatId = c.catId WHERE p.proEstatus = 1 ORDER BY p.proId";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }


    /**
     * 
     * Metodo para cargar todos los productos
     * @return void 
     */

    public function catalogoproductos()
    {
        $sql = $this->sentencia;
        //$sql = "SELECT p.proId, p.proImagen, p.proTitulo, p.proSku, p.proPreciocosto, p.proExistencia FROM productos p INNER JOIN categorias c ON p.proCatId = c.catId WHERE p.proEstatus = 1 ORDER BY p.proId";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los productos
     * @return void 
     */

    public function productos_vale()
    {
        $sql = "SELECT * FROM productos a INNER JOIN categorias b ON a.proCatId = b.catId INNER JOIN almacenes am ON a.proAlmId = am.almId INNER JOIN subCategorias sbc ON a.proSubCategoria = sbc.IdsubCategoria WHERE a.proEstatus = 1 AND a.proCatId = 47 ORDER BY  a.proId";
        //$sql = "SELECT p.proId, p.proImagen, p.proTitulo, p.proSku, p.proPreciocosto, p.proExistencia FROM productos p INNER JOIN categorias c ON p.proCatId = c.catId WHERE p.proEstatus = 1 ORDER BY p.proId";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los usuarios
     * @return void 
     */
    public function all2()
    {  
         $dbDetails = array(
            'host' => DB_HOST,
            'user'=> DB_USER,
            'pass'=> DB_PASS,
            'db' => DB_NAME
         );

         $table = <<<EOT
            (
            SELECT
            a.proId,
            a.proAlmId,
            a.proCapacidad,
            a.proTipoExtintor,
            a.proMarca,
            a.proCatId,
            a.proTitulo,
            a.proDescripcion,
            a.proPreciocosto,
            a.proExistencia,
            a.proPrecioventa,
            a.proEstatus,
            a.prodClave,
            a.proSku,
            a.proImagen,
            a.proPdf,
            a.proMax,
            a.proMin,
            a.fechaInicialPromo,
            a.proPromo,
            a.fechaFinalPromo,
            a.proDesc,
            a.proMoneda,
            a.proTipoCambio,
            a.proSubCategoria,
            a.Activo,
            a.MostrarPagina,
            a.Temporal,
            a.promoActivada,
            a.FechaInicial,
            a.FechaFinal,
            a.preciopromo,
            a.ClaveSat,
            a.UnidadSat,
            a.FechaActualizacion,
            b.catId,
            b.catNombre,
            b.catEstatus,
            b.faimagen,
            b.ImagenLand,
            b.ImgLand2,
            b.acomodarpagina,
            b.mostrarpagina AS mostrarpaginacat,
            am.almId,
            am.almNombre,
            am.almEstatus,
            am.almModificable,
            am.selectDepartamento,
            sbc.IdsubCategoria,
            sbc.NsubCategoria,
            sbc.IdCatego,
            sbc.NomCategoria,
            sbc.EstatusSub
            FROM productos a 
            INNER JOIN categorias b ON a.proCatId = b.catId 
            INNER JOIN almacenes am ON a.proAlmId = am.almId 
            INNER JOIN subCategorias sbc ON a.proSubCategoria = sbc.IdsubCategoria
            WHERE a.proEstatus = 1 
            ORDER BY a.proId) temp
            EOT;

         $primaryKey = 'proId';

         $columns = array(
            array('db' => 'proId', 'dt' => 'proId'),
            array('db' => 'proAlmId', 'dt' => 'proAlmId'),
            array('db' => 'proCapacidad',  'dt' => 'proCapacidad'),
            array('db' => 'proTipoExtintor',   'dt' => 'proTipoExtintor'),
            array('db' => 'proMarca',     'dt' => 'proMarca'),
            array('db' => 'proCatId',     'dt' => 'proCatId'),
            array('db' => 'proTitulo',     'dt' => 'proTitulo'),
            array('db' => 'proDescripcion',     'dt' => 'proDescripcion'),
            array('db' => 'proPreciocosto',     'dt' => 'proPreciocosto'),
            array('db' => 'proExistencia',     'dt' => 'proExistencia'),
            array('db' => 'proPrecioventa',     'dt' => 'proPrecioventa'),
            array('db' => 'proEstatus',     'dt' => 'proEstatus'),
            array('db' => 'prodClave',     'dt' => 'prodClave'),
            array('db' => 'proSku',     'dt' => 'proSku'),
            array('db' => 'proImagen',     'dt' => 'proImagen'),
            array('db' => 'proPdf',     'dt' => 'proPdf'),
            array('db' => 'proMax',     'dt' => 'proMax'),
            array('db' => 'proMin',     'dt' => 'proMin'),
            array('db' => 'fechaInicialPromo',     'dt' => 'fechaInicialPromo'),
            array('db' => 'proPromo',     'dt' => 'proPromo'),
            array('db' => 'fechaFinalPromo',     'dt' => 'fechaFinalPromo'),
            array('db' => 'proDesc',     'dt' => 'proDesc'),
            array('db' => 'proMoneda',     'dt' => 'proMoneda'),
            array('db' => 'proTipoCambio',     'dt' => 'proTipoCambio'),
            array('db' => 'proSubCategoria',     'dt' => 'proSubCategoria'),
            array('db' => 'Activo',     'dt' => 'Activo'),
            array('db' => 'MostrarPagina',     'dt' => 'MostrarPagina'),
            array('db' => 'Temporal',     'dt' => 'Temporal'),
            array('db' => 'promoActivada',     'dt' => 'promoActivada'),
            array('db' => 'FechaInicial',     'dt' => 'FechaInicial'),
            array('db' => 'FechaFinal',     'dt' => 'FechaFinal'),
            array('db' => 'preciopromo',     'dt' => 'preciopromo'),
            array('db' => 'ClaveSat',     'dt' => 'ClaveSat'),
            array('db' => 'UnidadSat',     'dt' => 'UnidadSat'),
            array('db' => 'FechaActualizacion',     'dt' => 'FechaActualizacion'),
            array('db' => 'catId',     'dt' => 'catId'),
            array('db' => 'catNombre',     'dt' => 'catNombre'),
            array('db' => 'catEstatus',     'dt' => 'catEstatus'),
            array('db' => 'faimagen',     'dt' => 'faimagen'),
            array('db' => 'ImagenLand',     'dt' => 'ImagenLand'),
            array('db' => 'ImgLand2',     'dt' => 'ImgLand2'),
            array('db' => 'acomodarpagina',     'dt' => 'acomodarpagina'),
            array('db' => 'mostrarpaginacat',     'dt' => 'mostrarpaginacat'),
            array('db' => 'almId',     'dt' => 'almId'),
            array('db' => 'almNombre',     'dt' => 'almNombre'),
            array('db' => 'almEstatus',     'dt' => 'almEstatus'),
            array('db' => 'almModificable',     'dt' => 'almModificable'),
            array('db' => 'selectDepartamento',     'dt' => 'selectDepartamento'),
            array('db' => 'IdsubCategoria',     'dt' => 'IdsubCategoria'),
            array('db' => 'NsubCategoria',     'dt' => 'NsubCategoria'),
            array('db' => 'IdCatego',     'dt' => 'IdCatego'),
            array('db' => 'NomCategoria',     'dt' => 'NomCategoria'),
            array('db' => 'EstatusSub',     'dt' => 'EstatusSub')
        );

        return json_encode(
            parent::simple($_POST, $dbDetails, $table, $primaryKey, $columns)
        );
    }

    /**
     * 
     * Metodo para cargar todos los usuarios
     * @return void 
     */
    public function all3()
    {  
         
            $sql = "SELECT
            a.proId,
            a.proAlmId,
            a.proCapacidad,
            a.proTipoExtintor,
            a.proMarca,
            a.proCatId,
            a.proTitulo,
            a.proDescripcion,
            a.proPreciocosto,
            a.proExistencia,
            a.proPrecioventa,
            a.proEstatus,
            a.prodClave,
            a.proSku,
            a.proImagen,
            a.proPdf,
            a.proMax,
            a.proMin,
            a.fechaInicialPromo,
            a.proPromo,
            a.fechaFinalPromo,
            a.proDesc,
            a.proMoneda,
            a.proTipoCambio,
            a.proSubCategoria,
            a.Activo,
            a.MostrarPagina,
            a.Temporal,
            a.promoActivada,
            a.FechaInicial,
            a.FechaFinal,
            a.preciopromo,
            a.ClaveSat,
            a.UnidadSat,
            a.FechaActualizacion,

            b.catId,
            b.catNombre,
            b.catEstatus,
            b.faimagen,
            b.ImagenLand,
            b.ImgLand2,
            b.acomodarpagina,
            b.mostrarpagina AS mostrarpaginacat,

            am.almId,
            am.almNombre,
            am.almEstatus,
            am.almModificable,
            am.selectDepartamento,

            sbc.IdsubCategoria,
            sbc.NsubCategoria,
            sbc.IdCatego,
            sbc.NomCategoria,
            sbc.EstatusSub,

            COALESCE(od.Vendidos, 0) AS Vendidos
            FROM productos a
            INNER JOIN categorias b       ON a.proCatId       = b.catId
            INNER JOIN almacenes am       ON a.proAlmId       = am.almId
            INNER JOIN subCategorias sbc  ON a.proSubCategoria = sbc.IdsubCategoria
            LEFT JOIN (
            SELECT IdProducto, SUM(Cantidad) AS Vendidos
            FROM ordenesdetalle
            GROUP BY IdProducto
            ) od ON od.IdProducto = a.proId
            WHERE a.MostrarPagina = 1
            AND a.Activo = 1
            AND a.proAlmId NOT IN (4,6)
            ORDER BY a.proId";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    public function seisvendidos()
    {   $fechainicial = $this->fechainicial;
        $fechafinal = $this->fechafinal;
        $sql = "SELECT o.Fecha,p.proTitulo,p.proPrecioventa,p.proExistencia,p.proSku,p.proImagen,p.proPdf,p.FechaInicial,p.FechaFinal,p.promoActivada,od.Cantidad FROM ordenes o INNER JOIN ordenesdetalle od ON od.IdOrden=o.IdOrden INNER JOIN productos p ON p.proId=od.IdProducto WHERE o.Fecha BETWEEN '$fechainicial' AND '$fechafinal' GROUP BY od.IdProducto ORDER BY od.Cantidad DESC LIMIT 6";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    public function onever()
    {
        $sql = "SELECT * FROM productos a INNER JOIN categorias b ON a.proCatId = b.catId INNER JOIN almacenes am ON a.proAlmId = am.almId INNER JOIN subCategorias sbc ON a.proSubCategoria = sbc.IdsubCategoria WHERE a.proEstatus = 1 AND a.proId = $this->proId  ORDER BY  a.proId";
        //$sql = "SELECT p.proId, p.proImagen, p.proTitulo, p.proSku, p.proPreciocosto, p.proExistencia FROM productos p INNER JOIN categorias c ON p.proCatId = c.catId WHERE p.proEstatus = 1 ORDER BY p.proId";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    public function xcategoria($proCatIdx)
    {
        $sql = "SELECT * FROM productos a INNER JOIN categorias b ON a.proCatId = b.catId INNER JOIN almacenes am ON a.proAlmId = am.almId WHERE a.proEstatus = 1 AND a.proCatId = $proCatIdx ORDER BY rand() LIMIT 6";
        //$sql = "SELECT p.proId, p.proImagen, p.proTitulo, p.proSku, p.proPreciocosto, p.proExistencia FROM productos p INNER JOIN categorias c ON p.proCatId = c.catId WHERE p.proEstatus = 1 ORDER BY p.proId";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los productos
     * @return void 
     */

    public function ganancia()
    {
        $idGanancia = $_POST['moneda'];
        $sql = "SELECT * FROM ganancia WHERE IdGanancia = $idGanancia";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los productos
     * @return void 
     */

    public function all_almacen()
    {
        $sql = "SELECT * FROM productos a INNER JOIN categorias b ON a.proCatId = b.catId WHERE a.proEstatus = 1 AND a.proAlmId=:proAlmId ORDER BY  a.proId";
        try {
            return ($rows = parent::query($sql, ['proAlmId' => $this->proAlmId])) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

     /**
     * 
     * Metodo para cargar todos los estatus
     * @return void 
     */

    public function productos_sinstock()
    {   
        $FechaInicio = date("Y-m-d");
        $sql = "SELECT * FROM productos WHERE proExistencia = 0";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }


    /**
     * 
     * Metodo para cargar todos los productos
     * @return void 
     */

    public function all_almacen_ind()
    {  
        $almid = $this->proAlmId;

        if($this->tipo == 2){
            if($almid == 3){
               $CatId = 1; 
           }else{
                $CatId = 31;
           }
            $sql = "SELECT * FROM productos a INNER JOIN categorias b ON a.proCatId = b.catId WHERE a.proEstatus = 1 AND a.proAlmId=$almid AND proCatId = $CatId  ORDER BY  a.proId";
        }else if($this->tipo == 3){
            $CatId = 33;
            $sql = "SELECT * FROM productos a INNER JOIN categorias b ON a.proCatId = b.catId WHERE a.proEstatus = 1 AND a.proAlmId=$almid AND proCatId = $CatId  ORDER BY  a.proId";

        }else if($this->tipo == 6){
            $CatId = 44;
            $sql = "SELECT * FROM productos a INNER JOIN categorias b ON a.proCatId = b.catId WHERE a.proEstatus = 1 AND a.proAlmId=$almid AND proCatId = $CatId  ORDER BY  a.proId";
        }else if($this->tipo == 7){
            $CatId = 45;
            $sql = "SELECT * FROM productos a INNER JOIN categorias b ON a.proCatId = b.catId WHERE a.proEstatus = 1 AND a.proAlmId=$almid AND proCatId = $CatId  ORDER BY  a.proId";
        }else{ // color un IN
            $almid = $almid .","."3";
            $sql = "SELECT * FROM productos a INNER JOIN categorias b ON a.proCatId = b.catId WHERE a.proEstatus = 1 AND a.proAlmId IN ($almid) AND proCatId NOT IN (1,31,33,44,45) ORDER BY  a.proId";
        }


        try {

            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los productos
     * @return void 
     */

    public function all_categoria()
    {
        $sql = "SELECT * FROM productos a INNER JOIN categorias b ON a.proCatId = b.catId WHERE a.proEstatus = 1 AND a.proCatId=:proCatId ORDER BY  a.proId";
        //$sql = "SELECT p.proId, p.proImagen, p.proTitulo, p.proSku, p.proPreciocosto, p.proExistencia FROM productos p INNER JOIN categorias c ON p.proCatId = c.catId WHERE p.proEstatus = 1 ORDER BY p.proId";
        try {
            return ($rows = parent::query($sql, ['proCatId' => $this->proCatId])) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar un producto
     * @return void 
     */

    public function one()
    {
        $sql = "SELECT p.*, COALESCE(SUM(o.Cantidad),0) AS PendientesEntrega, c.catNombre FROM productos p 
        LEFT JOIN ordenesdetalle o ON o.IdProducto = p.proId  
        LEFT JOIN ordenes x ON o.IdOrden = x.IdOrden
        LEFT JOIN categorias c ON c.catId = p.proCatId
        WHERE proId =:proId AND x.Estatus NOT IN(5,6,13,14);";
        try {
            return ($rows = parent::query($sql, ['proId' => $this->proId])) ? $rows[0] : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    

    public function oneAll()
    {
        $sql = "SELECT p.*, COALESCE(SUM(o.Cantidad),0) AS PendientesEntrega, c.catNombre, alm.almNombre FROM productos p 
        LEFT JOIN ordenesdetalle o ON o.IdProducto = p.proId  
        LEFT JOIN ordenes x ON o.IdOrden = x.IdOrden
        LEFT JOIN categorias c ON c.catId = p.proCatId
        LEFT JOIN almacenes alm ON alm.almId = p.proAlmId
        WHERE proId =:proId AND x.Estatus NOT IN(5,6,9,13,14,16)";

        $sql2 = "SELECT p.*, c.catNombre, alm.almNombre FROM productos p 
        LEFT JOIN categorias c ON c.catId = p.proCatId
        LEFT JOIN almacenes alm ON alm.almId = p.proAlmId
        WHERE proId =:proId";

        try {
            $productos = parent::query($sql, ['proId' => $this->proId]);
            $validar = $productos[0]["proId"];
            if($validar == null){
                $productos = parent::query($sql2, ['proId' => $this->proId]);
            }

            return $productos ? $productos[0] : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    public function update()
    {

            $sql = "";
            $data = "";
            $sentenciasql = "";
            $datsql = "";
            if($this->proPrecioventa != $this->precioventaoriginal){
                $sentenciasql = ",FechaActualizacion=:FechaActualizacion";
                $datsql = date("Y-m-d");
            }
            
            if($this->proImagen != null){
                $sql = "UPDATE  productos 
                    SET proTitulo=:proTitulo, 
                    proAlmId=:proAlmId, 
                    proPreciocosto=:proPreciocosto,
                    proPrecioventa=:proPrecioventa,
                    proExistencia=:proExistencia,
                    proSku=:proSku,
                    proCatId=:proCatId,
                    proMarca=:proMarca,
                    proCapacidad=:proCapacidad,
                    proTipoExtintor=:proTipoExtintor,
                    proImagen=:proImagen,proMax=:proMax,proMin=:proMin,proMoneda=:proMoneda,proTipoCambio = :proTipoCambio, proSubCategoria = :proSubCategoria, Activo = :Activo,MostrarPagina = :MostrarPagina,Temporal = :Temporal,ClaveSat = :ClaveSat,UnidadSat = :UnidadSat $sentenciasql WHERE proId=:proId";
               $proImagen = procesarArchivo($this->proImagen);
               if($datsql != ""){
                    $data =
                    [
                        'proTitulo' => $this->proTitulo,
                        'proAlmId' => $this->proAlmId,
                        'proPreciocosto' => $this->proPreciocosto,
                        'proPrecioventa' => $this->proPrecioventa,
                        'proExistencia' => $this->proExistencia,
                        'proSku' => $this->proSku,
                        'proCatId' => $this->proCatId,
                        'proMarca' => $this->proMarca,
                        'proCapacidad' => $this->proCapacidad,
                        'proTipoExtintor' => $this->proTipoExtintor,
                        'proId' => $this->proId,
                        'proImagen' => $proImagen,
                        'proMax' => $this->proMax,
                        'proMin' => $this->proMin,
                        'proMoneda' => $this->proMoneda,
                        'proTipoCambio' => $this->proTipoCambio,
                        'proSubCategoria' => $this->proSubCategoria,
                        'Activo' => $this->actventas,
                        'MostrarPagina' => $this->online,
                        'Temporal' => $this->temporal,
                        'ClaveSat' => $this->clavesat,
                        'UnidadSat' => $this->unidadsat,
                        'FechaActualizacion' => $datsql

                    ];
      
               }else{
                    $data =
                    [
                        'proTitulo' => $this->proTitulo,
                        'proAlmId' => $this->proAlmId,
                        'proPreciocosto' => $this->proPreciocosto,
                        'proPrecioventa' => $this->proPrecioventa,
                        'proExistencia' => $this->proExistencia,
                        'proSku' => $this->proSku,
                        'proCatId' => $this->proCatId,
                        'proMarca' => $this->proMarca,
                        'proCapacidad' => $this->proCapacidad,
                        'proTipoExtintor' => $this->proTipoExtintor,
                        'proId' => $this->proId,
                        'proImagen' => $proImagen,
                        'proMax' => $this->proMax,
                        'proMin' => $this->proMin,
                        'proMoneda' => $this->proMoneda,
                        'proTipoCambio' => $this->proTipoCambio,
                        'proSubCategoria' => $this->proSubCategoria,
                        'Activo' => $this->actventas,
                        'MostrarPagina' => $this->online,
                        'Temporal' => $this->temporal,
                        'ClaveSat' => $this->clavesat,
                        'UnidadSat' => $this->unidadsat

                    ];
               }
               
            }else{

                
                $sql = "UPDATE  productos 
            SET proTitulo=:proTitulo, 
            proAlmId=:proAlmId, 
            proPreciocosto=:proPreciocosto,
            proPrecioventa=:proPrecioventa,
            proExistencia=:proExistencia,
            proSku=:proSku,
            proCatId=:proCatId,
            proMarca=:proMarca,
            proCapacidad=:proCapacidad,
            proTipoExtintor=:proTipoExtintor,proMax=:proMax,proMin=:proMin,proMoneda=:proMoneda,proTipoCambio = :proTipoCambio,proSubCategoria = :proSubCategoria,Activo = :Activo,MostrarPagina = :MostrarPagina,Temporal = :Temporal,ClaveSat = :ClaveSat,UnidadSat = :UnidadSat $sentenciasql WHERE proId=:proId";
  
                if($datsql != ""){
                    $data =
                    [
                        'proTitulo' => $this->proTitulo,
                        'proAlmId' => $this->proAlmId,
                        'proPreciocosto' => $this->proPreciocosto,
                        'proPrecioventa' => $this->proPrecioventa,
                        'proExistencia' => $this->proExistencia,
                        'proSku' => $this->proSku,
                        'proCatId' => $this->proCatId,
                        'proMarca' => $this->proMarca,
                        'proCapacidad' => $this->proCapacidad,
                        'proTipoExtintor' => $this->proTipoExtintor,
                        'proId' => $this->proId,
                        'proMax' => $this->proMax,
                        'proMin' => $this->proMin,
                        'proMoneda' => $this->proMoneda,
                        'proTipoCambio' => $this->proTipoCambio,
                        'proSubCategoria' => $this->proSubCategoria,
                        'Activo' => $this->actventas,
                        'MostrarPagina' => $this->online,
                        'Temporal' => $this->temporal,
                        'ClaveSat' => $this->clavesat,
                        'UnidadSat' => $this->unidadsat,
                        'FechaActualizacion'=> $datsql
                    ];
                    
                }else{
                    $data =
                    [
                        'proTitulo' => $this->proTitulo,
                        'proAlmId' => $this->proAlmId,
                        'proPreciocosto' => $this->proPreciocosto,
                        'proPrecioventa' => $this->proPrecioventa,
                        'proExistencia' => $this->proExistencia,
                        'proSku' => $this->proSku,
                        'proCatId' => $this->proCatId,
                        'proMarca' => $this->proMarca,
                        'proCapacidad' => $this->proCapacidad,
                        'proTipoExtintor' => $this->proTipoExtintor,
                        'proId' => $this->proId,
                        'proMax' => $this->proMax,
                        'proMin' => $this->proMin,
                        'proMoneda' => $this->proMoneda,
                        'proTipoCambio' => $this->proTipoCambio,
                        'proSubCategoria' => $this->proSubCategoria,
                        'Activo' => $this->actventas,
                        'MostrarPagina' => $this->online,
                        'Temporal' => $this->temporal,
                        'ClaveSat' => $this->clavesat,
                        'UnidadSat' => $this->unidadsat
                    ];
                } 
                
            }

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    public function update_almacen()
    {

        $sql = "UPDATE productos SET proAlmId=:proAlmIdNuevo WHERE proAlmId=:proAlmId";
        $data =
            [
                'proAlmIdNuevo' => $this->proAlmIdNuevo,
                'proAlmId' => $this->proAlmId,
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    public function codi_promocion_update()
    {

        $sql = "UPDATE productos SET preciopromo=:preciopromo,FechaInicial=:FechaInicial,FechaFinal=:FechaFinal,promoActivada=:promoActivada WHERE proId=:proId";
        $data =
            [
                'preciopromo' => $this->preciopromo,
                'FechaInicial' => $this->fechainicial,
                'FechaFinal' => $this->fechafinal,
                'promoActivada' => 1,
                'proId' => $this->proId,
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

public function update_producto_asignar()
    {

        $sqlExistencia = "SELECT * FROM productos WHERE proId = $this->proId";
        $existencia = parent::query($sqlExistencia);

        $existenciaAcual = $existencia[0]['proExistencia'] - $this->cantidad;

        $sql = "UPDATE  productos SET proExistencia=:proExistencia WHERE proId=:proId";

            $data = [
                'proExistencia' => $existenciaAcual,
                'proId' => $this->proId,
            ];

        try {
            return (parent::query($sql,$data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    public function update_producto_compra()
    {

        $sqlExistencia = "SELECT * FROM productos WHERE proId = '$this->proId'";
        $existencia = parent::query($sqlExistencia);

        $existenciaAcual = $existencia[0]['proExistencia'] + $this->cantidad;


        $sql = "UPDATE  productos SET proExistencia='$existenciaAcual' WHERE proId='$this->proId'";


        try {
            return (parent::query($sql)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }


    public function update_producto_orden()
    {

        $sqlExistencia = "SELECT * FROM productos WHERE proId = '$this->proId'";
        $existencia = parent::query($sqlExistencia);

        $existenciaAcual = $existencia[0]['proExistencia'];
        if($existenciaAcual < 0){
            $proExistenciaActual = floatval($existenciaAcual + $this->trCantidad);
        }else{
            $proExistenciaActual = floatval($existenciaAcual - $this->trCantidad);
        }

        $sql = "UPDATE  productos SET proExistencia='$proExistenciaActual' WHERE proId='$this->proId'";


        try {
            return (parent::query($sql)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }


    /**
     * 
     * Metodo para actualizar un registro de la bd
     * @return bool 
     */

    public function delete()
    {

        $sql = "UPDATE productos SET proAlmId=:proAlmId, proEstatus=:proEstatus WHERE proId=:proId";
        $data =
            [
                'proAlmId' => $this->proAlmId,
                'proEstatus' => $this->proEstatus,
                'proId' => $this->proId
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    public function traspasar()
    {

        $proClave = random_strings(7);

        if($this->proExistencia < 0){
            $proExistenciaActual = floatval($this->proExistencia + $this->trCantidad);
        }else{
            $proExistenciaActual = floatval($this->proExistencia - $this->trCantidad);
        }

        

        $sqlValidarUsuario = "SELECT * FROM usuarios WHERE Correo='$this->trUsuario'";
        $sqlExistenciaProductoAlmacen = "SELECT * FROM productos WHERE proAlmId = '$this->trAlmacen' AND proSku = '$this->proSku'";
        $sqlRestarCantidad = "UPDATE  productos SET proExistencia=:proExistenciaActual WHERE proId=:proId";


        $sqlInsertarTraspaso = "INSERT INTO productos (prodClave, proTitulo, proAlmId, proDescripcion,proPreciocosto,proPrecioventa,proExistencia,proSku,proCatId,proMarca,proCapacidad,proTipoExtintor, proImagen, proMoneda, proTipoCambio,proSubCategoria) 
        VALUES ('$proClave',:proTitulo, :trAlmacen, '', :proPreciocosto,:proPrecioventa,:proExistencia,:proSku,:proCatId,:proMarca,:proCapacidad,:proTipoExtintor, :proImagen, :proMoneda, :proTipoCambio,:proSubCategoria)";

        $dataRestarCantidad =
            [
                'proExistenciaActual' => $proExistenciaActual,
                'proId' => $this->proId,
            ];

        $dataInsertarTraspaso =
            [
                'proTitulo' => $this->proTitulo,
                'proPreciocosto' => $this->proPreciocosto,
                'proPrecioventa' => $this->proPrecioventa,
                'proExistencia' => $this->trCantidad,
                'proSku' => $this->proSku,
                'proCatId' => $this->proCatId,
                'proImagen' => $this->proImagen,
                'trAlmacen' => $this->trAlmacen,
                'proMarca' => $this->proMarca,
                'proCapacidad' => $this->proCapacidad,
                'proTipoExtintor' => $this->proTipoExtintor,
                'proMoneda' => $this->proMoneda,
                'proTipoCambio' => $this->proTipoCambio,
                'proSubCategoria' => $this->proSubCategoria
            ];

            $datahistorialtraspaso =
            [
                'IdProductoTraspaso' => $this->proId,
                'historialproSku'=>$this->proSku,
                'correoTraspaso' => $this->trUsuario,
                'fechaTraspaso' => date('Y-m-d H:i:s'),
                'cantidadTraspaso' => $this->trCantidad,
                'motivoTraspaso' => "Faltan productos en tienda",
                'AlmacenDestino'=>$this->trAlmacen
            ];



        $user = parent::query($sqlValidarUsuario);
        $password_response = $user[0]["Contra"];
        $historialtraspaso = "INSERT INTO historial_traspaso (IdProductoTraspaso,historialproSku,correoTraspaso,fechaTraspaso,cantidadTraspaso,motivoTraspaso,AlmacenDestino) values (:IdProductoTraspaso,:historialproSku,:correoTraspaso,:fechaTraspaso,:cantidadTraspaso,:motivoTraspaso,:AlmacenDestino)";
        
        try {
            if (password_verify($this->trPassword, $password_response) && $this->proExistencia > $this->trCantidad) {

                if (((parent::query($sqlExistenciaProductoAlmacen)) ? true : false) &&  parent::query($sqlRestarCantidad, $dataRestarCantidad)) {
                    $rows = parent::query($sqlExistenciaProductoAlmacen);
                    $idProductoExistente = $rows[0]["proId"];
                    $existenciaCantidad = $rows[0]["proExistencia"] + $this->trCantidad;

                    $dataRestarCantidad =
                        [
                            'proExistenciaActual' => $existenciaCantidad,
                            'proId' => $idProductoExistente,
                        ];

                    $sqlUpdateProductoExistente = "UPDATE  productos SET proExistencia=:proExistenciaActual WHERE proId =:proId ";
                    parent::query($historialtraspaso, $datahistorialtraspaso);
                    return (parent::query($sqlUpdateProductoExistente, $dataRestarCantidad)) ? true : false;
                } else {

                    if ((parent::query($sqlRestarCantidad, $dataRestarCantidad)) ? true : false) {
                        parent::query($historialtraspaso, $datahistorialtraspaso);
                        return ($this->proId = parent::query($sqlInsertarTraspaso, $dataInsertarTraspaso)) ? $this->proId : false;
                    }
                }
            } else {
                return false;
            }
        } catch (Exception $e) {
            throw "$e";
        }
    }

    public function subcategoria()
    {
        $sql = "SELECT * FROM subCategorias WHERE EstatusSub=1";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    public function subcategoria2()
    {
        $sql = "SELECT * FROM subCategorias WHERE EstatusSub=1 AND IdCatego = $this->proSubCategoria";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    public function categorias()
    {
        $sql = "SELECT catId, catNombre FROM categorias WHERE catEstatus=1";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    public function kpiglobalsql(){
        $sql = "SELECT
            COALESCE(SUM(COALESCE(od.Neto, od.PrecioVenta * od.Cantidad)), 0)      AS ingresos_3m,
            COALESCE(SUM(od.Cantidad), 0)                                           AS unidades_3m,
            COUNT(DISTINCT o.IdOrden)                                               AS ordenes_3m,
            CASE WHEN COUNT(DISTINCT o.IdOrden) = 0 THEN 0
                ELSE COALESCE(SUM(COALESCE(od.Neto, od.PrecioVenta * od.Cantidad)), 0) / COUNT(DISTINCT o.IdOrden)
            END                                                                     AS ticket_promedio_3m
            FROM ordenesdetalle od
            JOIN ordenes o    ON o.IdOrden = od.IdOrden AND o.Fecha >= DATE_SUB(CURDATE(), INTERVAL 3 MONTH)
            JOIN productos p  ON p.proId = od.IdProducto AND p.Activo = 1
            WHERE od.Eliminado = 0";
            
            try {
            return ($rows = parent::query($sql)) ? $rows : false;
            } catch (Exception $e) {
                throw $e;
            }
    }

    public function tendenciamensualsql(){
        $sql = "SELECT
            DATE_FORMAT(o.Fecha, '%Y-%m') AS mes,
            SUM(COALESCE(od.Neto, od.PrecioVenta * od.Cantidad)) AS ingresos,
            SUM(od.Cantidad) AS unidades
            FROM ordenesdetalle od
            JOIN ordenes o   ON o.IdOrden = od.IdOrden AND o.Fecha >= DATE_SUB(CURDATE(), INTERVAL 3 MONTH)
            JOIN productos p ON p.proId = od.IdProducto AND p.Activo = 1
            WHERE od.Eliminado = 0
            GROUP BY DATE_FORMAT(o.Fecha, '%Y-%m')
            ORDER BY mes;";

            try {
            return ($rows = parent::query($sql)) ? $rows : false;
            } catch (Exception $e) {
                throw $e;
            }

    }

    public function ventasporalmacensql(){
        $sql = "SELECT
            a.almId,
            a.almNombre,
            COALESCE(SUM(od.Cantidad), 0) AS unidades,
            COALESCE(SUM(COALESCE(od.Neto, od.PrecioVenta * od.Cantidad)), 0) AS ingresos
            FROM almacenes a
            LEFT JOIN productos p    ON p.proAlmId = a.almId AND p.Activo = 1
            LEFT JOIN ordenesdetalle od ON od.IdProducto = p.proId AND od.Eliminado = 0
            LEFT JOIN ordenes o      ON o.IdOrden = od.IdOrden AND o.Fecha >= DATE_SUB(CURDATE(), INTERVAL 3 MONTH)
            WHERE a.almId IN (1,2,5)
            GROUP BY a.almId, a.almNombre
            ORDER BY a.almId;";
            try {
            return ($rows = parent::query($sql)) ? $rows : false;
            } catch (Exception $e) {
                throw $e;
            }

    }

    public function tendenciaalmacensql(){
        $sql = "SELECT
            a.almId,
            a.almNombre,
            DATE_FORMAT(o.Fecha, '%Y-%m') AS mes,
            SUM(od.Cantidad) AS unidades,
            SUM(COALESCE(od.Neto, od.PrecioVenta * od.Cantidad)) AS ingresos
            FROM almacenes a
            JOIN productos p       ON p.proAlmId = a.almId AND p.Activo = 1
            JOIN ordenesdetalle od ON od.IdProducto = p.proId AND od.Eliminado = 0
            JOIN ordenes o         ON o.IdOrden = od.IdOrden AND o.Fecha >= DATE_SUB(CURDATE(), INTERVAL 3 MONTH)
            WHERE a.almId IN (1,2,5)
            GROUP BY a.almId, a.almNombre, DATE_FORMAT(o.Fecha, '%Y-%m')
            ORDER BY mes, a.almId;
            ";

            try {
            return ($rows = parent::query($sql)) ? $rows : false;
            } catch (Exception $e) {
                throw $e;
            }

    }

    public function masvendidossql(){
        $sql = "SELECT
            base.proSku,
            repP.proTitulo,
            COALESCE(sales.unidades_vendidas, 0)   AS unidades_vendidas,
            COALESCE(sales.ingresos, 0)            AS ingresos,
            exi.existencia_total,
            c.catNombre                             AS categoria,
            CASE
                WHEN repP.promoActivada = 1 AND CURDATE() BETWEEN repP.FechaInicial AND repP.FechaFinal AND repP.preciopromo IS NOT NULL
                THEN repP.preciopromo
                ELSE repP.proPrecioventa
            END                                     AS precio_actual,
            repP.proImagen
            FROM ( SELECT proSku FROM productos WHERE Activo = 1 GROUP BY proSku ) base
            LEFT JOIN (
            SELECT p.proSku,
                    SUM(od.Cantidad)                                        AS unidades_vendidas,
                    SUM(COALESCE(od.Neto, od.PrecioVenta * od.Cantidad))    AS ingresos
            FROM productos p
            JOIN ordenesdetalle od ON od.IdProducto = p.proId AND od.Eliminado = 0
            JOIN ordenes o         ON o.IdOrden = od.IdOrden AND o.Fecha >= DATE_SUB(CURDATE(), INTERVAL 3 MONTH)
            WHERE p.Activo = 1
            GROUP BY p.proSku
            ) sales ON sales.proSku = base.proSku
            LEFT JOIN (
            SELECT proSku, SUM(proExistencia) AS existencia_total
            FROM productos
            WHERE Activo = 1
            GROUP BY proSku
            ) exi ON exi.proSku = base.proSku
            LEFT JOIN (
            -- Producto representante por SKU (última actualización; si empata, el de menor proId)
            SELECT t.proSku, MIN(p.proId) AS repProId
            FROM productos p
            JOIN (
                SELECT proSku, MAX(FechaActualizacion) AS maxF
                FROM productos
                WHERE Activo = 1
                GROUP BY proSku
            ) t ON t.proSku = p.proSku AND p.FechaActualizacion = t.maxF
            WHERE p.Activo = 1
            GROUP BY t.proSku
            ) rep ON rep.proSku = base.proSku
            LEFT JOIN productos  repP ON repP.proId = rep.repProId
            LEFT JOIN categorias c    ON c.catId    = repP.proCatId
            ORDER BY COALESCE(sales.unidades_vendidas,0) DESC, COALESCE(sales.ingresos,0) DESC
            LIMIT 10";

            try {
            return ($rows = parent::query($sql)) ? $rows : false;
            } catch (Exception $e) {
                throw $e;
            }

    }

    public function sinventasql(){
        $sql = "SELECT
                base.proSku,
                repP.proTitulo,
                exi.existencia_total,
                c.catNombre AS categoria,
                CASE
                    WHEN repP.promoActivada = 1 AND CURDATE() BETWEEN repP.FechaInicial AND repP.FechaFinal AND repP.preciopromo IS NOT NULL
                    THEN repP.preciopromo
                    ELSE repP.proPrecioventa
                END AS precio_actual,
                repP.proImagen,
                upd.ultima_actualizacion,
                COALESCE(sales.unidades_vendidas, 0) AS unidades_3m
                FROM ( SELECT proSku FROM productos WHERE Activo = 1 GROUP BY proSku ) base
                LEFT JOIN (
                SELECT p.proSku,
                        SUM(od.Cantidad)                                     AS unidades_vendidas
                FROM productos p
                JOIN ordenesdetalle od ON od.IdProducto = p.proId AND od.Eliminado = 0
                JOIN ordenes o         ON o.IdOrden = od.IdOrden AND o.Fecha >= DATE_SUB(CURDATE(), INTERVAL 3 MONTH)
                WHERE p.Activo = 1
                GROUP BY p.proSku
                ) sales ON sales.proSku = base.proSku
                LEFT JOIN (
                SELECT proSku, SUM(proExistencia) AS existencia_total
                FROM productos
                WHERE Activo = 1
                GROUP BY proSku
                ) exi ON exi.proSku = base.proSku
                LEFT JOIN (
                SELECT proSku, MIN(FechaActualizacion) AS ultima_actualizacion
                FROM productos
                WHERE Activo = 1
                GROUP BY proSku
                ) upd ON upd.proSku = base.proSku
                LEFT JOIN (
                -- Producto representante por SKU (última actualización; si empata, menor proId)
                SELECT t.proSku, MIN(p.proId) AS repProId
                FROM productos p
                JOIN (
                    SELECT proSku, MAX(FechaActualizacion) AS maxF
                    FROM productos
                    WHERE Activo = 1
                    GROUP BY proSku
                ) t ON t.proSku = p.proSku AND p.FechaActualizacion = t.maxF
                WHERE p.Activo = 1
                GROUP BY t.proSku
                ) rep ON rep.proSku = base.proSku
                LEFT JOIN productos  repP ON repP.proId = rep.repProId
                LEFT JOIN categorias c    ON c.catId    = repP.proCatId
                HAVING unidades_3m = 0
                ORDER BY exi.existencia_total DESC, upd.ultima_actualizacion ASC
                LIMIT 10
            ";

            try {
            return ($rows = parent::query($sql)) ? $rows : false;
            } catch (Exception $e) {
                throw $e;
            }

    }

    public function ventasxskualmacensql(){
        $sql = "SELECT
            s.almId,
            s.almNombre,
            s.proSku,
            repP.proTitulo,
            s.unidades,
            s.ingresos
            FROM (
            SELECT
                a.almId,
                a.almNombre,
                p.proSku,
                SUM(od.Cantidad)                                      AS unidades,
                SUM(COALESCE(od.Neto, od.PrecioVenta * od.Cantidad))  AS ingresos
            FROM productos p
            JOIN almacenes a       ON a.almId = p.proAlmId
            JOIN ordenesdetalle od ON od.IdProducto = p.proId AND od.Eliminado = 0
            JOIN ordenes o         ON o.IdOrden = od.IdOrden AND o.Fecha >= DATE_SUB(CURDATE(), INTERVAL 3 MONTH)
            WHERE p.Activo = 1
                AND a.almId IN (1,2,5)    -- quita este filtro si quieres todos
            GROUP BY a.almId, a.almNombre, p.proSku
            ) s
            LEFT JOIN (
            -- Producto representante por (almId, SKU) con última actualización; si empata, menor proId
            SELECT y.proAlmId AS almId, y.proSku, MIN(y.proId) AS repProId
            FROM productos y
            JOIN (
                SELECT proAlmId, proSku, MAX(FechaActualizacion) AS maxF
                FROM productos
                WHERE Activo = 1
                GROUP BY proAlmId, proSku
            ) z ON z.proAlmId = y.proAlmId AND z.proSku = y.proSku AND y.FechaActualizacion = z.maxF
            WHERE y.Activo = 1
            GROUP BY y.proAlmId, y.proSku
            ) rep ON rep.almId = s.almId AND rep.proSku = s.proSku
            LEFT JOIN productos repP ON repP.proId = rep.repProId
            ORDER BY s.almId, s.ingresos DESC";

            try {
            return ($rows = parent::query($sql)) ? $rows : false;
            } catch (Exception $e) {
                throw $e;
            }

    }

    public function promoactivashoysql(){
        $sql = "SELECT
                p.proSku, p.proTitulo, p.proPrecioventa, p.preciopromo,
                p.FechaInicial, p.FechaFinal, p.proImagen
                FROM productos p
                WHERE p.Activo = 1
                AND p.promoActivada = 1
                AND CURDATE() BETWEEN p.FechaInicial AND p.FechaFinal;
                ";

            try {
            return ($rows = parent::query($sql)) ? $rows : false;
            } catch (Exception $e) {
                throw $e;
            }

    }

    public function saludinventarioskuql(){
        $sql = "SELECT
        g.proSku,
        repP.proTitulo,
        g.stock_total,
        g.stock_min_total,
        g.stock_max_total
        FROM (
        SELECT
            proSku,
            SUM(proExistencia) AS stock_total,
            SUM(proMin)        AS stock_min_total,
            SUM(proMax)        AS stock_max_total
        FROM productos
        WHERE Activo = 1
        GROUP BY proSku
        ) g
        LEFT JOIN (
        -- Representante por SKU por última actualización (si empata, menor proId)
        SELECT t.proSku, MIN(p.proId) AS repProId
        FROM productos p
        JOIN (
            SELECT proSku, MAX(FechaActualizacion) AS maxF
            FROM productos
            WHERE Activo = 1
            GROUP BY proSku
        ) t ON t.proSku = p.proSku AND p.FechaActualizacion = t.maxF
        WHERE p.Activo = 1
        GROUP BY t.proSku
        ) rep ON rep.proSku = g.proSku
        LEFT JOIN productos repP ON repP.proId = rep.repProId
        WHERE g.stock_total < g.stock_min_total OR g.stock_total > g.stock_max_total
        ORDER BY g.proSku";

            try {
            return ($rows = parent::query($sql)) ? $rows : false;
            } catch (Exception $e) {
                throw $e;
            }

    }

    public function salud_inventario_almacensql(){
        $sql = "SELECT
            s.almId,
            s.almNombre,
            s.proSku,
            repP.proTitulo,
            s.stock,
            s.stock_min,
            s.stock_max
            FROM (
            SELECT
                a.almId,
                a.almNombre,
                p.proSku,
                SUM(p.proExistencia) AS stock,
                SUM(p.proMin)        AS stock_min,
                SUM(p.proMax)        AS stock_max
            FROM productos p
            JOIN almacenes a ON a.almId = p.proAlmId
            WHERE p.Activo = 1
                AND a.almId IN (1,2,5)  -- quita este filtro si quieres todos
            GROUP BY a.almId, a.almNombre, p.proSku
            ) s
            LEFT JOIN (
            -- Representante por (almId, SKU) por última actualización (si empata, menor proId)
            SELECT y.proAlmId AS almId, y.proSku, MIN(y.proId) AS repProId
            FROM productos y
            JOIN (
                SELECT proAlmId, proSku, MAX(FechaActualizacion) AS maxF
                FROM productos
                WHERE Activo = 1
                GROUP BY proAlmId, proSku
            ) z ON z.proAlmId = y.proAlmId AND z.proSku = y.proSku AND y.FechaActualizacion = z.maxF
            WHERE y.Activo = 1
            GROUP BY y.proAlmId, y.proSku
            ) rep ON rep.almId = s.almId AND rep.proSku = s.proSku
            LEFT JOIN productos repP ON repP.proId = rep.repProId
            WHERE s.stock < s.stock_min OR s.stock > s.stock_max
            ORDER BY s.almId, s.proSku";

            try {
            return ($rows = parent::query($sql)) ? $rows : false;
            } catch (Exception $e) {
                throw $e;
            }
    }

    public function vendidos_stock_top_3m(){
        $sql = "SELECT
            base.proSku,
            repP.proTitulo,
            COALESCE(sales.unidades_vendidas,0)                                    AS unidades_vendidas,
            COALESCE(sales.ingresos,0)                                             AS ingresos,
            exi.stock_total,
            exi.stock_min_total,
            exi.stock_max_total,
            c.catNombre                                                            AS categoria
            FROM ( SELECT proSku FROM productos WHERE Activo=1 GROUP BY proSku ) base
            JOIN (
            SELECT p.proSku,
                    SUM(od.Cantidad)                                  AS unidades_vendidas,
                    SUM(COALESCE(od.Neto, od.PrecioVenta*od.Cantidad)) AS ingresos
            FROM productos p
            JOIN ordenesdetalle od ON od.IdProducto=p.proId AND od.Eliminado=0
            JOIN ordenes o        ON o.IdOrden=od.IdOrden AND o.Fecha>=DATE_SUB(CURDATE(), INTERVAL 3 MONTH)
            WHERE p.Activo=1
            GROUP BY p.proSku
            ) sales ON sales.proSku=base.proSku
            LEFT JOIN (
            SELECT proSku,
                    SUM(proExistencia) AS stock_total,
                    SUM(proMin)        AS stock_min_total,
                    SUM(proMax)        AS stock_max_total
            FROM productos
            WHERE Activo=1
            GROUP BY proSku
            ) exi ON exi.proSku=base.proSku
            LEFT JOIN (
            -- representante por SKU: última actualización; si empata, menor proId
            SELECT t.proSku, MIN(p.proId) AS repProId
            FROM productos p
            JOIN (
                SELECT proSku, MAX(FechaActualizacion) AS maxF
                FROM productos WHERE Activo=1 GROUP BY proSku
            ) t ON t.proSku=p.proSku AND p.FechaActualizacion=t.maxF
            WHERE p.Activo=1
            GROUP BY t.proSku
            ) rep ON rep.proSku=base.proSku
            LEFT JOIN productos  repP ON repP.proId=rep.repProId
            LEFT JOIN categorias c    ON c.catId = repP.proCatId
            ORDER BY unidades_vendidas DESC, ingresos DESC
            LIMIT 10";

            try {
            return ($rows = parent::query($sql)) ? $rows : false;
            } catch (Exception $e) {
                throw $e;
            }

    }


    public function sin_ventas_stock(){
        $sql = "SELECT
            base.proSku,
            repP.proTitulo,
            exi.stock_total      AS existencia_total,
            exi.stock_min_total  AS stock_min_total,
            exi.stock_max_total  AS stock_max_total,
            c.catNombre          AS categoria,
            upd.ultima_actualizacion
            FROM ( SELECT proSku FROM productos WHERE Activo=1 GROUP BY proSku ) base
            LEFT JOIN (
            SELECT p.proSku, SUM(od.Cantidad) AS unidades_3m
            FROM productos p
            JOIN ordenesdetalle od ON od.IdProducto=p.proId AND od.Eliminado=0
            JOIN ordenes o        ON o.IdOrden=od.IdOrden AND o.Fecha>=DATE_SUB(CURDATE(), INTERVAL 3 MONTH)
            WHERE p.Activo=1
            GROUP BY p.proSku
            ) sales ON sales.proSku=base.proSku
            LEFT JOIN (
            SELECT proSku,
                    SUM(proExistencia) AS stock_total,
                    SUM(proMin)        AS stock_min_total,
                    SUM(proMax)        AS stock_max_total
            FROM productos
            WHERE Activo=1
            GROUP BY proSku
            ) exi ON exi.proSku=base.proSku
            LEFT JOIN (
            SELECT proSku, MIN(FechaActualizacion) AS ultima_actualizacion
            FROM productos WHERE Activo=1 GROUP BY proSku
            ) upd ON upd.proSku=base.proSku
            LEFT JOIN (
            SELECT t.proSku, MIN(p.proId) AS repProId
            FROM productos p
            JOIN (
                SELECT proSku, MAX(FechaActualizacion) AS maxF
                FROM productos WHERE Activo=1 GROUP BY proSku
            ) t ON t.proSku=p.proSku AND p.FechaActualizacion=t.maxF
            WHERE p.Activo=1
            GROUP BY t.proSku
            ) rep ON rep.proSku=base.proSku
            LEFT JOIN productos  repP ON repP.proId=rep.repProId
            LEFT JOIN categorias c    ON c.catId = repP.proCatId
            WHERE COALESCE(sales.unidades_3m,0)=0
            ORDER BY exi.stock_total DESC, upd.ultima_actualizacion ASC
            LIMIT 10";

            try {
            return ($rows = parent::query($sql)) ? $rows : false;
            } catch (Exception $e) {
                throw $e;
            }

    }

    public function unsold_sku_6m_reporte(){
        $sql = "SELECT
                p.proSku,
                COALESCE(MIN(p.proTitulo), '(Sin título)')    AS titulo,            -- representante
                COALESCE(c.catNombre,'(Sin categoría)')       AS categoria,
                COUNT(DISTINCT p.proId)                       AS variantes,
                SUM(p.proExistencia)                          AS existencia_total,
                SUM(p.proExistencia * p.proPrecioventa)       AS valor_inventario,
                MAX(p.FechaActualizacion)                     AS ultima_actualizacion,
                MAX(p.promoActivada)                          AS promo_activada,
                MIN(p.proMin)                                 AS min_ref,
                MAX(p.proMax)                                 AS max_ref
                FROM productos p
                LEFT JOIN categorias c ON c.catId = p.proCatId
                LEFT JOIN (
                SELECT pr.proSku, SUM(od.Cantidad) AS unidades_6m
                FROM ordenesdetalle od
                JOIN ordenes o   ON o.IdOrden = od.IdOrden
                JOIN productos pr ON pr.proId = od.IdProducto
                WHERE o.Fecha >= DATE_SUB(CURDATE(), INTERVAL 6 MONTH)
                    AND pr.Activo = 1
                    AND pr.proAlmId NOT IN (4,6)
                GROUP BY pr.proSku
                ) s ON s.proSku = p.proSku
                WHERE p.Activo = 1
                AND p.proAlmId NOT IN (4,6)
                GROUP BY p.proSku, c.catNombre
                HAVING COALESCE(MAX(s.unidades_6m),0) = 0
                ORDER BY existencia_total DESC, valor_inventario DESC
                ";

            try {
            return ($rows = parent::query($sql)) ? $rows : false;
            } catch (Exception $e) {
                throw $e;
            }

    }

    public function unsold_sku_almacen_6m_reporte(){
        $sql = "SELECT
            p.proSku,
            a.almId,
            a.almNombre,
            p.proId,
            p.proTitulo,
            p.proExistencia,
            p.proPrecioventa,
            (p.proExistencia * p.proPrecioventa) AS valor_inventario,
            p.FechaActualizacion
            FROM productos p
            JOIN almacenes a ON a.almId = p.proAlmId
            LEFT JOIN (
            SELECT pr.proId, SUM(od.Cantidad) AS unidades_6m
            FROM ordenesdetalle od
            JOIN ordenes o ON o.IdOrden = od.IdOrden
            JOIN productos pr ON pr.proId = od.IdProducto
            WHERE o.Fecha >= DATE_SUB(CURDATE(), INTERVAL 6 MONTH)
            GROUP BY pr.proId
            ) s ON s.proId = p.proId
            WHERE p.Activo = 1
            AND p.proAlmId NOT IN (4,6)
            AND p.proSku IN (
                SELECT p2.proSku
                FROM productos p2
                LEFT JOIN (
                SELECT pr2.proSku, SUM(od2.Cantidad) AS unidades_6m
                FROM ordenesdetalle od2
                JOIN ordenes o2 ON o2.IdOrden = od2.IdOrden
                JOIN productos pr2 ON pr2.proId = od2.IdProducto
                WHERE o2.Fecha >= DATE_SUB(CURDATE(), INTERVAL 6 MONTH)
                    AND pr2.Activo = 1
                    AND pr2.proAlmId NOT IN (4,6)
                GROUP BY pr2.proSku
                ) sx ON sx.proSku = p2.proSku
                WHERE p2.Activo=1 AND p2.proAlmId NOT IN (4,6)
                GROUP BY p2.proSku
                HAVING COALESCE(MAX(sx.unidades_6m),0)=0
            )
            ORDER BY p.proSku, a.almId
                ";

            try {
            return ($rows = parent::query($sql)) ? $rows : false;
            } catch (Exception $e) {
                throw $e;
            }

    }

    public function top_sellers_by_category_3m_reporte(){
        $sql = "SELECT
                COALESCE(c.catNombre,'(Sin categoría)') AS categoria,
                pr.proSku,
                pr.proTitulo,
                SUM(od.Cantidad) AS unidades_3m,
                SUM(od.Neto)     AS ingresos_3m
                FROM ordenesdetalle od
                JOIN ordenes o   ON o.IdOrden   = od.IdOrden
                JOIN productos pr ON pr.proId   = od.IdProducto
                LEFT JOIN categorias c ON c.catId = pr.proCatId
                WHERE o.Fecha >= DATE_SUB(CURDATE(), INTERVAL 3 MONTH)
                AND pr.Activo = 1
                AND pr.proAlmId NOT IN (4,6)
                GROUP BY c.catNombre, pr.proSku, pr.proTitulo
                ORDER BY c.catNombre, unidades_3m DESC, ingresos_3m DESC
                ";

            try {
            return ($rows = parent::query($sql)) ? $rows : false;
            } catch (Exception $e) {
                throw $e;
            }

    }

    public function last_sale_date_sku_reporte(){
        $sql = "SELECT
                pr.proSku,
                MAX(o.Fecha) AS ultima_venta
                FROM ordenesdetalle od
                JOIN ordenes o ON o.IdOrden = od.IdOrden
                JOIN productos pr ON pr.proId = od.IdProducto
                WHERE pr.Activo=1
                AND pr.proAlmId NOT IN (4,6)
                GROUP BY pr.proSku;
                ";

            try {
            return ($rows = parent::query($sql)) ? $rows : false;
            } catch (Exception $e) {
                throw $e;
            }

    }
    
}
