<?php
class proveedoresModel extends Model
{
    public $id;
    public $nombre;
    public $descripcion;
    public $email;
    public $telefono;
    public $calle;
    public $ninterior;
    public $nexterior;
    public $cp;
    public $municipio;
    public $estado;
    public $estatus;


    public function all()
    {
        $sql = "SELECT * FROM proveedores where estatus=1";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    public function update()
    {

        $sql = "UPDATE  proveedores SET nombre=:nombre, descripcion=:descripcion, email=:email, telefono=:telefono, calle=:calle, 
        ninterior=:ninterior, nexterior=:nexterior, cp=:cp, municipio=:municipio, estado=:estado WHERE id=:id";
        $data =
            [
                'nombre' => $this->nombre,
                'descripcion' => $this->descripcion,
                'email' => $this->email,
                'telefono' => $this->telefono,
                'calle' => $this->calle,
                'ninterior' => $this->ninterior,
                'nexterior' => $this->nexterior,
                'cp' => $this->cp,
                'municipio' => $this->municipio,
                'estado' => $this->estado,
                'id' => $this->id
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    public function delete()
    {

        $sql = "UPDATE proveedores 
                SET estatus =:estatus  
                WHERE id=:id";
        $data =
            [
                'estatus' => 0,
                'id' => $this->id
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    public function add()
    {

        $sql = "INSERT INTO proveedores (nombre, descripcion, email, telefono, calle, ninterior, nexterior, cp, municipio, estado, estatus) 
        VALUES (:nombre,:descripcion,:email,:telefono, :calle, :ninterior, :nexterior, :cp, :municipio, :estado, :estatus)";
        $data =
            [
                'nombre' => $this->nombre,
                'descripcion' => $this->descripcion,
                'email' => $this->email,
                'telefono' => $this->telefono,
                'calle' => $this->calle,
                'ninterior' => $this->ninterior,
                'nexterior' => $this->nexterior,
                'cp' => $this->cp,
                'municipio' => $this->municipio,
                'estado' => $this->estado,
                'estatus' => 1,
            ];

        try {
            return ($this->id = parent::query($sql, $data)) ? $this->id : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    public function one()
    {
        $sql = "SELECT * FROM proveedores WHERE id =:id";

        try {
            return ($rows = parent::query($sql, ['id' => $this->id])) ? $rows[0] : false;
        } catch (Exception $e) {
            throw $e;
        }
    }
}
