<?php

class puntodeventaModel extends Model {

    public $buscar;
    public $porNombre; 
    public $tipoOrden;
    public $idProd;
    public $idCliente;
    public $venta;
    public $idUsuario;
    public $idOrden; // agregar si no existe
    public $tmpKey;
    public $jsonData;
    public $cliente;
    public $domicilio;
    public $carrito;
    public $metodoPago;
    public $sinIVA;
    public $validarStock = false; // false = vender sin stock / true = validar existencia real

    /*************************************************
     * GENERAR FOLIO
     *************************************************/
    private function generarFolio()
    {
        $sql = "SELECT MAX(FolioOrden) AS f FROM ordenes";
        $r = parent::query($sql, [], true);
        return $r && $r["f"] ? $r["f"] + 1 : 1000;
    }

    /*************************************************
     * GENERAR LLAVE
     *************************************************/
    private function generarLlave()
    {
        return strtoupper(bin2hex(random_bytes(6)));
    }

    /*************************************************
     * ESTADO SEGÚN TIPO
     *************************************************/
    private function estadoSegunTipo($tipo)
    {
        switch ($tipo) {
            case 1: return 12;  
            case 2: return 25;  
            case 3: return 2;   
            case 6: return 4;   
            case 7: return 15;  
            case 8: return 3;   
            default: return 25;
        }
    }


    /*************************************************
     * BUSCAR PRODUCTOS
     *************************************************/
    public function buscarProductosPOS()
    {
        $buscar    = $this->buscar;
        $porNombre = $this->porNombre;
        $tipoOrden = $this->tipoOrden;

        if($tipoOrden == 2){
            $where = " WHERE proAlmId = 3";
        }else{
            $where = " WHERE proAlmId = 5 ";
        }
        

        switch ($tipoOrden) {
            case 2: $where .= " AND proCatId IN (1) "; break;
            case 3: $where .= " AND proCatId IN (33) "; break;
            case 6: $where .= " AND proCatId IN (44) "; break;
            case 7: $where .= " AND proCatId IN (45) "; break;
            case 8: $where .= " AND proCatId IN (1) "; break;
            case 1:
            default:
                $where .= " AND proCatId NOT IN (1,33,44,45) ";
            break;
        }

        if ($porNombre == 1) {
            $parts = explode(" ", $buscar);
            foreach ($parts as $p) {
                $where .= " AND proTitulo LIKE '%$p%' ";
            }
        } else {
            $where .= " AND proSku LIKE '%$buscar%' ";
        }

        $where .= " AND Activo = 1 AND proEstatus = 1 ";

        $sql = "SELECT proId, proTitulo, proSku, proImagen, proPrecioventa
                FROM productos
                $where
                ORDER BY proTitulo ASC
                LIMIT 50";

        return parent::query($sql);
    }


    /*************************************************
     * OBTENER PRODUCTO POR ID
     *************************************************/
    public function obtenerProductoPorID()
    {
        $sql = "SELECT 
                    proId,
                    proTitulo,
                    proSku,
                    proPrecioventa,
                    proImagen,
                    proExistencia
                FROM productos
                WHERE proId = ?
                AND Activo = 1
                AND proEstatus = 1
                LIMIT 1";

        $prod = parent::query($sql, [$this->idProd], true);

        if (!$prod) return null;

        // Validación opcional de stock
        if (!$this->validarStockProducto($prod, $this->tipoOrden)) {
            throw new Exception("Sin stock para este producto.");
        }

        return $prod;
    }


public function validarStockProducto($producto, $tipoOrden)
{
    // Siempre se permite venta negativa para tipoOrden = 2
    if (intval($tipoOrden) === 2) {
        return true;
    }

    // Si la validación de stock está apagada → vender siempre
    if (!$this->validarStock) {
        return true;
    }

    // Validación real
    if ($producto["proExistencia"] < 1) {
        return false;
    }

    return true;
}

    /*************************************************
     * BUSCAR CLIENTES
     *************************************************/
    public function buscarClientesPOS()
    {
        $buscar = trim($this->buscar);
        $porNombre = $this->porNombre;

        if ($buscar === "") return [];

        $where = " WHERE Activo = 1 ";

        if ($porNombre == 1) {
            $parts = explode(" ", $buscar);
            foreach ($parts as $p) {
                $where .= " AND Nombre LIKE '%$p%' ";
            }
        } else {
            $parts = explode(" ", $buscar);
            foreach ($parts as $p) {
                $where .= " AND RFC LIKE '%$p%' ";
            }
        }

        $sql = "SELECT 
                    IdCliente,
                    Nombre,
                    RFC,
                    FisMunicipio,
                    Moroso
                FROM clientes
                $where
                ORDER BY Nombre ASC
                LIMIT 50";

        return parent::query($sql);
    }


    /*************************************************
     * OBTENER DOMICILIOS
     *************************************************/
    public function obtenerDomiciliosClientePOS()
    {
        $idCliente = intval($this->idCliente);

        $sql = "SELECT 
                    EntId,
                    EntCalle,
                    EntNExt,
                    EntNInt,
                    EntColonia,
                    EntCP,
                    EntMunicipio,
                    EntEstado
                FROM clientes_domicilios
                WHERE IdCliente = ?
                  AND Activo = 1
                ORDER BY EntId DESC";

        return parent::query($sql, [$idCliente]);
    }



    /*************************************************
     * CREAR ORDEN
     *************************************************/
    public function crearOrden()
    {
        $venta = $this->venta;

        if (!$venta || !isset($venta["carrito"])) {
            throw new Exception("Datos de venta incompletos.");
        }

        $cliente   = $venta["cliente"];
        $dom       = $venta["domicilio"];
        $carrito   = $venta["carrito"];
        $metodo    = $venta["metodoPago"];
        $sinIVA    = $venta["sinIVA"];
        $tipoOrden = intval($venta["tipoOrden"]);

        if (!isset($dom["IdDomicilio"])) {
            throw new Exception("Domicilio no válido.");
        }

        if (count($carrito) === 0) {
            throw new Exception("No hay productos en la venta.");
        }

        $sqlMoroso = "SELECT Moroso FROM clientes WHERE IdCliente = ?";
        $mor = parent::query($sqlMoroso, [$cliente["id"]], true);

        if ($mor && $mor["Moroso"] == 1 && $metodo != "01") {
            throw new Exception("Cliente moroso: solo CONTADO.");
        }
        
        $subtotal = 0;
        foreach ($carrito as $p) {
            $subtotal += $p["precio"] * $p["cantidad"];
        }

        $iva = $sinIVA ? 0 : ($subtotal * 0.16);
        $total = $subtotal + $iva;

        $folio = $this->generarFolio();
        $llave = $this->generarLlave();
        $estadoTransito = $this->estadoSegunTipo($tipoOrden);
        
        foreach ($carrito as $p) {

            $sqlStock = "SELECT proExistencia FROM productos WHERE proId = ?";
            $st = parent::query($sqlStock, [$p["id"]], true);

            if (!$st || $st["proExistencia"] < $p["cantidad"]) {
                throw new Exception("Stock insuficiente del producto ID: " . $p["id"]);
            }
        }

        /* INSERT ORDEN — NECESITAMOS ID AUTOINCREMENTAL */
        $sql = "INSERT INTO ordenes
                (FolioOrden, IdCliente, IdDomicilio, Fecha, Descripcion,
                 TipoPago, Estatus, EstadoTransito, TipoOrden, IdUsuario,
                 llaveOrden, autorizacionOrden, totalComision, Siniva)
                VALUES (?, ?, ?, NOW(), '', ?, 1, ?, ?, ?, ?, 0, ?)";

        $idOrden = parent::query($sql, [
            $folio,
            $cliente["id"],
            $dom["IdDomicilio"],
            $metodo,
            $estadoTransito,
            $tipoOrden,
            $_SESSION["IdUsuario"],
            $llave,
            $sinIVA
        ]);

        if (!$idOrden) {
            throw new Exception("Error al guardar orden.");
        }

        /* DETALLES */
        $partida = 1;

        foreach ($carrito as $p) {

            if (!$this->validarStockProducto($p, $tipoOrden)) {
                throw new Exception("El producto '{$p["titulo"]}' no tiene stock suficiente.");
            }


            $neto = $p["precio"] * $p["cantidad"];

            $sqlDet = "INSERT INTO ordenesdetalle
                        (IdOrden, FolioOrden, Partida, IdProducto, Cantidad,
                         Entregados, PrecioVenta, DescuentoDetalle,
                         DescPesos, Neto, ComisionInd, compraCreada, Eliminado)
                        VALUES (?, ?, ?, ?, ?, ?, ?, 0, 0, ?, 0, 0, 0)";

            parent::query($sqlDet, [
                $idOrden,
                $folio,
                $partida,
                $p["id"],
                $p["cantidad"],
                0,
                $p["precio"],
                $neto
            ]);

            $partida++;
        }

        return [
            "IdOrden"    => $idOrden,
            "FolioOrden" => $folio,
            "Total"      => $total
        ];
    }

public function obtenerOrdenesActivasPOS()
{
    $idUsuario = intval($this->idUsuario);

    $sql = "
        SELECT 
            o.IdOrden,
            o.FolioOrden,
            o.Fecha,
            o.Estatus,
            o.EstadoTransito,
            o.TipoOrden,
            COALESCE(SUM(d.Neto), 0) AS Total
        FROM ordenes o
        LEFT JOIN ordenesdetalle d ON d.IdOrden = o.IdOrden
        WHERE o.IdUsuario = ?
          AND o.Estatus IN (1, 2, 3)
        GROUP BY o.IdOrden
        ORDER BY o.IdOrden DESC
        LIMIT 20
    ";

    return parent::query($sql, [$idUsuario]);
}




public function obtenerOrdenCompletaPOS()
{
    $id = intval($this->idOrden);

    // ============================
    // 1. CABECERA
    // ============================
    $sqlCab = "SELECT 
                    o.IdOrden,
                    o.FolioOrden,
                    o.IdCliente,
                    o.IdDomicilio,
                    o.TipoOrden,
                    o.TipoPago,
                    o.Siniva
               FROM ordenes o
               WHERE o.IdOrden = ?
               LIMIT 1";

    $cab = parent::query($sqlCab, [$id], true);
    if (!$cab) {
        throw new Exception("Orden no encontrada.");
    }

    // ============================
    // 2. CLIENTE
    // ============================
    $sqlCli = "SELECT 
                    IdCliente,
                    Nombre,
                    RFC
               FROM clientes
               WHERE IdCliente = ?
               LIMIT 1";

    $cliente = parent::query($sqlCli, [$cab["IdCliente"]], true);

    // ============================
    // 3. DOMICILIO
    // ============================
    $sqlDom = "SELECT 
                    EntId AS IdDomicilio,
                    EntCalle,
                    EntNExt,
                    EntNInt,
                    EntColonia,
                    EntCP,
                    EntMunicipio,
                    EntEstado
               FROM clientes_domicilios
               WHERE EntId = ?
               LIMIT 1";

    $dom = parent::query($sqlDom, [$cab["IdDomicilio"]], true);

    // ============================
    // 4. DETALLE (PRODUCTOS)
    // ============================
    $sqlDet = "SELECT 
                    d.IdProducto,
                    d.Cantidad,
                    p.proTitulo,
                    p.proSku,
                    p.proPrecioventa,
                    p.proImagen
               FROM ordenesdetalle d
               INNER JOIN productos p ON p.proId = d.IdProducto
               WHERE d.IdOrden = ?";

    $detalle = parent::query($sqlDet, [$id]);

            // ============================
            // 5. TOTAL (sumar Neto)
            // ============================
            $total = 0;
            foreach ($detalle as $p) {
                $total += ($p["proPrecioventa"] * $p["Cantidad"]);
            }

            return [
                "cabecera" => $cab,
                "cliente"  => $cliente,
                "domicilio" => $dom,
                "detalle"  => $detalle,
                "total" => $total
            ];

}

public function guardarTmp()
{
    $idUsuario = intval($this->idUsuario);
    $json = addslashes($this->jsonData);

    // ¿Existe un TMP previo?
    $sqlCheck = "SELECT tmpId FROM ordenes_tmp WHERE IdUsuario = $idUsuario LIMIT 1";
    $existe = parent::query($sqlCheck, [], false);

    if ($existe && count($existe) > 0) {
        $tmpId = $existe[0]["tmpId"];

        // UPDATE
        $sql = "UPDATE ordenes_tmp
                SET jsonData = '$json', FechaUpdate = NOW()
                WHERE tmpId = $tmpId";
    } else {
        // INSERT
        $sql = "INSERT INTO ordenes_tmp (IdUsuario, jsonData, FechaUpdate)
                VALUES ($idUsuario, '$json', NOW())";
    }

    return parent::query($sql);
}


public function obtenerOrdenTmpPorUsuario()
{
    $sql = "SELECT tmpId, jsonData, FechaUpdate
            FROM ordenes_tmp
            WHERE IdUsuario = ?
            ORDER BY tmpId DESC
            LIMIT 1";

    return parent::query($sql, [$this->idUsuario], true);
}


public function eliminarOrdenTmpPorUsuario()
{
    $sql = "DELETE FROM ordenes_tmp WHERE IdUsuario = ?";
    return parent::query($sql, [$this->idUsuario]);
}



}
