<?php
// === MODELO REPARTO ===
class repartoModel extends Model {
    // --------- Orden (ya tienes varias; agrego/uso estas) ---------
    public $IdOrden;
    public $FechaInicio;
    public $FechaTermino;
    public $EstadoTransito;
    public $IdUsuario;         // repartidor asignado (usuario)
    public $Departamento;      // 14/22
    public $Motivo;
    public $IdUsuarioAccion;   // quien ejecuta

    // === LISTAR PENDIENTES (EstadoTransito 16/21) ===
    public function reparto_ordenes_pendientes_model(){
        $filtroFecha = '';
        $data = [];
        if (!empty($this->FechaInicio) && !empty($this->FechaTermino)) {
            $filtroFecha = " AND o.Fecha BETWEEN :ini AND :fin ";
            $data['ini'] = $this->FechaInicio;
            $data['fin'] = $this->FechaTermino;
        }

        $sql = "SELECT 
                o.IdOrden, o.FolioOrden, o.IdCliente, o.IdDomicilio,
                o.Fecha, o.TipoPago, o.Estatus, o.EstadoTransito,
                tp.Descripcion AS TipoPagoNombre,
                c.Nombre      AS Cliente,
                TRIM(CONCAT_WS(' ',
                    d.EntCalle, d.EntNExt, d.EntNInt, d.EntColonia,
                    d.EntCP, d.EntMunicipio, d.EntEstado
                )) AS Domicilio,
                NULL AS idGuia, NULL AS IdUsuario, NULL AS Repartidor, NULL AS Departamento,
                'PENDIENTE' AS estatus_reparto
                FROM ordenes o
                LEFT JOIN tipos_pago      tp ON tp.IdPago   = o.TipoPago
                LEFT JOIN clientes        c  ON c.IdCliente   = o.IdCliente
                LEFT JOIN domentregacltes d  ON d.IdDomicilio = o.IdDomicilio
                WHERE o.EstadoTransito IN (16,21)
                $filtroFecha
                ORDER BY o.Fecha DESC, o.IdOrden DESC";
        return ($rows = parent::query($sql, $data)) ? $rows : [];
    }

    public function reparto_ordenes_asignadas_model(){
        $filtro = " WHERE o.EstadoTransito IN (14,22) ";
        $data = [];
        if (!empty($this->Departamento)) { $filtro .= " AND o.EstadoTransito = :dep "; $data['dep'] = $this->Departamento; }
        if (!empty($this->IdUsuario))    { $filtro .= " AND g.IdUsuario = :usr ";     $data['usr'] = $this->IdUsuario;   }

        $sql = "SELECT 
                o.IdOrden, o.FolioOrden, o.IdCliente, o.IdDomicilio,
                o.Fecha, o.TipoPago, o.Estatus, o.EstadoTransito,
                tp.Descripcion AS TipoPagoNombre,
                c.Nombre      AS Cliente,
                TRIM(CONCAT_WS(' ',
                    d.EntCalle, d.EntNExt, d.EntNInt, d.EntColonia,
                    d.EntCP, d.EntMunicipio, d.EntEstado
                )) AS Domicilio,
                g.idGuia, g.IdUsuario, u.Usuario AS Repartidor, g.Departamento,
                g.estatus AS estatus_reparto, g.fecha_asignado, g.fecha_salida, g.fecha_entrega
                FROM ordenes o
                LEFT JOIN reparto_guias   g  ON g.IdOrden     = o.IdOrden
                LEFT JOIN usuarios        u  ON u.IdUsuario   = g.IdUsuario
                LEFT JOIN tipos_pago      tp ON tp.IdPago   = o.TipoPago
                LEFT JOIN clientes        c  ON c.IdCliente   = o.IdCliente
                LEFT JOIN domentregacltes d  ON d.IdDomicilio = o.IdDomicilio
                $filtro
                ORDER BY o.Fecha DESC, o.IdOrden DESC";
        return ($rows = parent::query($sql, $data)) ? $rows : [];
    }


    // === LISTA DE REPARTIDORES (usuarios por departamento 14/22) ===
    public function reparto_repartidores_model(){
        $filtro = "WHERE Activo=1 AND Departamento IN (14,22)";
        $data = [];
        if (!empty($this->Departamento)) {
            $filtro = "WHERE Activo=1 AND Departamento = :dep";
            $data['dep'] = $this->Departamento;
        }
        $sql = "SELECT IdUsuario, Usuario, Departamento FROM usuarios $filtro ORDER BY Usuario ASC";
        return ($rows = parent::query($sql, $data)) ? $rows : [];
    }

    
// ================== PHP (solo la función del MODEL ajustada) ==================
public function reparto_asignar_orden_model(){
    if (empty($this->IdOrden) || empty($this->Departamento) || empty($this->IdUsuario)) {
        throw new Exception("Parámetros incompletos");
    }

    // IMPORTANTE: evitar NULL por zonas horarias no cargadas.
    // Usamos UTC_TIMESTAMP() con offset fijo (-06:00) vía TIMESTAMPADD (no requiere tablas tz).
    $now_mx = "TIMESTAMPADD(HOUR, -6, UTC_TIMESTAMP())";

    // 1) Actualiza la orden a 14/22
    $sql1 = "UPDATE ordenes 
             SET EstadoTransito = :dep
             WHERE IdOrden = :id";
    parent::query($sql1, ['dep'=>$this->Departamento, 'id'=>$this->IdOrden]);

    // 2) UPSERT guía de reparto (IdUsuario, Departamento, estatus, fechas)
    $sql2 = "INSERT INTO reparto_guias
               (IdOrden, IdUsuario, Departamento, estatus, fecha_asignado, created_by, updated_by, updated_at)
             VALUES
               (:id, :usr, :dep, 'ASIGNADA', {$now_mx}, :actor, :actor, {$now_mx})
             ON DUPLICATE KEY UPDATE
               IdUsuario      = VALUES(IdUsuario),
               Departamento   = VALUES(Departamento),
               estatus        = 'ASIGNADA',
               fecha_asignado = VALUES(fecha_asignado),
               updated_by     = VALUES(updated_by),
               updated_at     = VALUES(updated_at)";
    parent::query($sql2, [
        'id'=>$this->IdOrden,
        'usr'=>$this->IdUsuario,
        'dep'=>$this->Departamento,
        'actor'=>$this->IdUsuarioAccion ?: $this->IdUsuario
    ]);

    // 3) Evento de bitácora
    $sql3 = "INSERT INTO reparto_eventos (idGuia, estatus, ts, nota)
             SELECT g.idGuia, 'ASIGNADA', {$now_mx}, 'Asignada a repartidor'
             FROM reparto_guias g WHERE g.IdOrden = :id";
    parent::query($sql3, ['id'=>$this->IdOrden]);

    return true;
}


    // === EN RUTA: solo guía (EstadoTransito permanece 14/22) ===
    public function reparto_en_ruta_model(){
        if (empty($this->IdOrden)) throw new Exception("IdOrden requerido");
        $sql = "UPDATE reparto_guias
                SET estatus='EN_RUTA',
                    fecha_salida=CONVERT_TZ(UTC_TIMESTAMP(),'+00:00','America/Mexico_City'),
                    updated_by=:actor,
                    updated_at=CONVERT_TZ(UTC_TIMESTAMP(),'+00:00','America/Mexico_City')
                WHERE IdOrden=:id";
        parent::query($sql, ['id'=>$this->IdOrden, 'actor'=>$this->IdUsuarioAccion ?: 0]);

        $sqlE = "INSERT INTO reparto_eventos (idGuia, estatus, ts, nota)
                 SELECT g.idGuia, 'EN_RUTA',
                        CONVERT_TZ(UTC_TIMESTAMP(),'+00:00','America/Mexico_City'),
                        'Salida a ruta'
                 FROM reparto_guias g WHERE g.IdOrden=:id";
        parent::query($sqlE, ['id'=>$this->IdOrden]);

        return true;
    }

    // === REASIGNAR: cambia repartidor y/o departamento (mantiene 14/22 coherente) ===
    public function reparto_reasignar_model(){
        if (empty($this->IdOrden) || empty($this->Departamento) || empty($this->IdUsuario)) {
            throw new Exception("Parámetros incompletos");
        }
        // Orden a nuevo dep
        $sql1 = "UPDATE ordenes SET EstadoTransito = :dep WHERE IdOrden = :id";
        parent::query($sql1, ['dep'=>$this->Departamento, 'id'=>$this->IdOrden]);

        // Guía
        $sql2 = "UPDATE reparto_guias
                 SET IdUsuario=:usr, Departamento=:dep, estatus='ASIGNADA',
                     updated_by=:actor,
                     updated_at=CONVERT_TZ(UTC_TIMESTAMP(),'+00:00','America/Mexico_City')
                 WHERE IdOrden=:id";
        parent::query($sql2, [
            'usr'=>$this->IdUsuario,
            'dep'=>$this->Departamento,
            'actor'=>$this->IdUsuarioAccion ?: $this->IdUsuario,
            'id'=>$this->IdOrden
        ]);

        $sqlE = "INSERT INTO reparto_eventos (idGuia, estatus, ts, nota)
                 SELECT g.idGuia, 'ASIGNADA',
                        CONVERT_TZ(UTC_TIMESTAMP(),'+00:00','America/Mexico_City'),
                        'Reasignada'
                 FROM reparto_guias g WHERE g.IdOrden=:id";
        parent::query($sqlE, ['id'=>$this->IdOrden]);

        return true;
    }

    // === DEVOLVER A ALMACÉN: orden -> 21, guía -> CANCELADA ===
    public function reparto_devolver_almacen_model(){
        if (empty($this->IdOrden)) throw new Exception("IdOrden requerido");

        $sql1 = "UPDATE ordenes SET EstadoTransito = 21 WHERE IdOrden = :id";
        parent::query($sql1, ['id'=>$this->IdOrden]);

        $sql2 = "UPDATE reparto_guias
                 SET estatus='CANCELADA',
                     motivo_falla=:motivo,
                     updated_by=:actor,
                     updated_at=CONVERT_TZ(UTC_TIMESTAMP(),'+00:00','America/Mexico_City')
                 WHERE IdOrden=:id";
        parent::query($sql2, [
            'motivo' => $this->Motivo ?: 'Devuelto a almacén',
            'actor'  => $this->IdUsuarioAccion ?: 0,
            'id'     => $this->IdOrden
        ]);

        $sqlE = "INSERT INTO reparto_eventos (idGuia, estatus, ts, nota)
                 SELECT g.idGuia, 'CANCELADA',
                        CONVERT_TZ(UTC_TIMESTAMP(),'+00:00','America/Mexico_City'),
                        :motivo
                 FROM reparto_guias g WHERE g.IdOrden=:id";
        parent::query($sqlE, [
            'motivo' => $this->Motivo ?: 'Devuelto a almacén',
            'id'     => $this->IdOrden
        ]);

        return true;
    }
}
