<?php
class usuariosModel extends Db
{
    public $IdUsuario;
    public $Usuario;
    public $Correo;
    public $Telefono;
    public $Departamento;
    public $NombreUsuario;
    public $Contra;
    public $activo;
    public $nomgrupo;
    public $idGrupo;
    public $idVendedor;
    public $NombreVendedor;
    public $TipoIntegrante;
    public $PartidaIntegrante;
    public $IdGrupoUsMeta;
    public $idUsuarioVen;
    public $TipodeUsuario;
    public $PeriodoInicial;
    public $PeriodoFinal;
    public $MetaDinero;
    public $MetaTotal;
    public $MetaFacturas;
    public $usuvalRegistro;
    public $usuvalidFi;
    public $usuvalidFf;
    public $darkmode;
    public $rfc;

    /**
     * 
     * Metodo para agregar nuevo usuario
     * @return integer 
     */

    public function add()
    {
        $str = preg_replace('/\x00|<[^>]*>?/', '', $this->Contra);
        $haspassword = str_replace(["'", '"'], ['&#39;', '&#34;'], $str);
        $p_hashed = password_hash($haspassword, PASSWORD_BCRYPT);
        $sql = "INSERT INTO usuarios (Usuario,Correo,Telefono,Departamento,NombreUsuario,Contra) VALUES (:Usuario,:Correo,:Telefono,:Departamento,:NombreUsuario,:Contra)";
        $data =
            [
                'Usuario' => $this->Usuario,
                'Correo' => $this->Correo,
                'Telefono' => $this->Telefono,
                'Departamento' => $this->Departamento,
                'NombreUsuario' => $this->NombreUsuario,
                'Contra' => $p_hashed
            ];

        try {
            return ($this->IdUsuario = parent::query($sql, $data)) ? $this->IdUsuario : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los usuarios
     * @return void 
     */

 
    public function all()
    {
        $sql = "SELECT u.IdUsuario, u.Usuario, u.Correo, u.Telefono, u.Departamento, u.NombreUsuario, u.activo, d.DeptoDescripcion FROM usuarios u LEFT JOIN departamentos d ON u.Departamento = d.IdDepto WHERE activo=1 ORDER BY IdUsuario";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }


    /**
     * 
     * Metodo para cargar todos los usuarios
     * @return void 
     */

 
    public function valregistro_meta()
    {
        $sql = "SELECT * FROM MetasVendedor WHERE idUsuarioVen=$this->usuvalRegistro AND PeriodoInicial = '$this->usuvalidFi' AND PeriodoFinal = '$this->usuvalidFf'";
  
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los usuarios vendedores
     * @return void 
     */

    public function vendedores()
    {
        $sql = "SELECT u.IdUsuario, u.Usuario, d.DeptoDescripcion FROM usuarios u LEFT JOIN departamentos d ON u.Departamento = d.IdDepto WHERE activo=1 AND departamento IN (7,8,9) ORDER BY u.Usuario";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los usuarios vendedores
     * @return void 
     */

    public function numerogrupos()
    {
        $sql = "SELECT * FROM GruposComision WHERE GrupoActivo=1  GROUP BY IdGrupoUs";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }


    /**
     * 
     * Metodo para cargar todos los usuarios vendedores
     * @return void 
     */

    public function vendedorescheck()
    {
        $sql = "SELECT * FROM GruposComision WHERE IdUsuario=:IdUsuario AND GrupoActivo=:GrupoActivo";

        $data =
            [
                'IdUsuario' => $this->IdUsuario,
                'GrupoActivo' => 1
            ];
        try {
            return ($rows = parent::query($sql,$data)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }


    /**
     * 
     * Metodo para agregar nuevo grupo
     * @return integer 
     */

    public function add_grupo()
    {
        $sql = "INSERT INTO GruposComision (IdGrupoUs,NombreGrupo,PartidaIntegrante,TipoIntegrante,IdUsuario,NombreVendedor,GrupoActivo) VALUES (:IdGrupoUs,:NombreGrupo,:PartidaIntegrante,:TipoIntegrante,:IdUsuario,:NombreVendedor,:GrupoActivo)";
        $data =
            [
                'IdGrupoUs' => $this->idGrupo,
                'NombreGrupo' => $this->nomgrupo,
                'PartidaIntegrante' => $this->PartidaIntegrante,
                'TipoIntegrante' => $this->TipoIntegrante,
                'IdUsuario' => $this->IdUsuario,
                'NombreVendedor' => $this->NombreVendedor,
                'GrupoActivo' => 1
            ];

        try {
            return ($this->IdUsuario = parent::query($sql, $data)) ? $this->IdUsuario : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los usuarios vendedores
     * @return void 
     */

    public function gruposventas()
    {
        $sql = "SELECT * FROM GruposComision  WHERE GrupoActivo=1";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para agregar nuevo grupo
     * @return integer 
     */

    public function add_meta()
    {
        $sql = "INSERT INTO MetasVendedor (IdGrupoUsMeta,idUsuarioVen,TipodeUsuario,MetaDinero,PeriodoInicial,PeriodoFinal,MetaFacturas,NombreVendedor,MetaTotal) VALUES (:IdGrupoUsMeta,:idUsuarioVen,:TipodeUsuario,:MetaDinero,:PeriodoInicial,:PeriodoFinal,:MetaFacturas,:NombreVendedor,:MetaTotal)";
        $data =
            [
                'IdGrupoUsMeta' => $this->IdGrupoUsMeta,
                'idUsuarioVen' => $this->idUsuarioVen,
                'TipodeUsuario' => $this->TipodeUsuario,
                'MetaDinero' => $this->MetaDinero,
                'PeriodoInicial' => $this->PeriodoInicial,
                'PeriodoFinal' => $this->PeriodoFinal,
                'MetaFacturas' => $this->MetaFacturas,
                'NombreVendedor' => $this->NombreVendedor,
                'MetaTotal' => $this->MetaTotal
            ];

        try {
            return ($this->IdUsuario = parent::query($sql, $data)) ? $this->IdUsuario : false;
        } catch (Exception $e) {
            throw $e;
        }
    }


    /**
     * 
     * Metodo para cargar todos los usuarios vendedores
     * @return void 
     */

    public function traergrupouni()
    {
        $sql = "SELECT * FROM GruposComision  WHERE GrupoActivo=1 AND IdGrupoUs=$this->idGrupo";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }


    /**
     * 
     * Metodo para actualizar un registro de la bd
     * @return bool 
     */

    public function update_facturador_uni()
    {

        $sql = "UPDATE  GruposComision SET IdUsuario='$this->idVendedor', NombreVendedor='$this->NombreVendedor' WHERE TipoIntegrante='2' AND IdGrupoUs='$this->idGrupo'";

        try {
            return (parent::query($sql)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }


    /**
     * 
     * Metodo para cargar todos los usuarios vendedores
     * @return void 
     */

    public function userfacturas()
    {
        $sql = "SELECT u.IdUsuario, u.Usuario, d.DeptoDescripcion FROM usuarios u LEFT JOIN departamentos d ON u.Departamento = d.IdDepto WHERE activo=1 AND departamento IN (19) ORDER BY u.Usuario";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los usuarios instructores
     * @return void 
     */

    public function instructores()
    {
        $sql = "SELECT u.IdUsuario, u.Usuario, d.DeptoDescripcion FROM usuarios u LEFT JOIN departamentos d ON u.Departamento = d.IdDepto WHERE activo=1 AND departamento=2 ORDER BY u.Usuario";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los usuarios instructores
     * @return void 
     */

    public function correos()
    {
        $sql = "SELECT DISTINCT(Correo) AS Correo FROM usuarios u WHERE Departamento IN (12, 7,8,9, 14, 16) AND activo!=0;";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar un registro usando su id
     * @return void 
     */

    public function one()
    {
        $sql = "SELECT * FROM usuarios WHERE IdUsuario=:IdUsuario LIMIT 1";
        try {
            return ($rows = parent::query($sql, ['IdUsuario' => $this->IdUsuario])) ? $rows[0] : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para actualizar un registro de la bd
     * @return bool 
     */

    public function update()
    {
        $str = preg_replace('/\x00|<[^>]*>?/', '', $this->Contra);
        $haspassword = str_replace(["'", '"'], ['&#39;', '&#34;'], $str);
        $p_hashed = password_hash($haspassword, PASSWORD_BCRYPT);
        if ($this->Contra != '' && $this->Departamento != '') {
           
            $sql = "UPDATE usuarios SET Telefono=:Telefono, Departamento=:Departamento, Contra=:Contra WHERE IdUsuario=:IdUsuario";
            $data =
                [
                    'Telefono' => $this->Telefono,
                    'Departamento' => $this->Departamento,
                    'Contra' => $p_hashed,
                    'IdUsuario' => $this->IdUsuario
                ];
        } else if($this->Departamento == '' && $this->Contra != ''){
            $sql = "UPDATE usuarios SET Telefono=:Telefono,  Contra=:Contra WHERE IdUsuario=:IdUsuario";
            $data =
                [
                    'Telefono' => $this->Telefono,
                    'Contra' => $p_hashed,
                    'IdUsuario' => $this->IdUsuario
                ];
        }else if($this->Departamento == '' && $this->Contra == ''){
            $sql = "UPDATE usuarios SET Telefono=:Telefono WHERE IdUsuario=:IdUsuario";
            $data =
                [
                    'Telefono' => $this->Telefono,
                    'IdUsuario' => $this->IdUsuario
                ];
        }else {
            $sql = "UPDATE  usuarios SET Telefono=:Telefono WHERE IdUsuario=:IdUsuario";
            $data =
                [
                    'Telefono' => $this->Telefono,
                    'IdUsuario' => $this->IdUsuario
                ];
        }
        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para actualizar un registro de la bd
     * @return bool 
     */

    public function update_tema()
    {
        
            $sql = "UPDATE  usuarios SET Darkmode=:Darkmode WHERE IdUsuario=:IdUsuario";
            $data =
                [
                    'Darkmode' => $this->darkmode,
                    'IdUsuario' => $this->IdUsuario
                ];
        
        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para actualizar un registro de la bd
     * @return bool 
     */

    public function delete()
    {

        $sql = "UPDATE  usuarios SET activo=:activo WHERE idUsuario=:idUsuario";
        $data =
            [
                'activo' => $this->activo,
                'idUsuario' => $this->IdUsuario
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para actualizar un registro de la bd
     * @return bool 
     */

    public function delete_usuario_meta()
    {

        $sql = "DELETE FROM GruposComision WHERE IdGrupoUs=:IdGrupoUs AND IdUsuario=:IdUsuario";

        $data =
            [
                'IdGrupoUs' => $this->idGrupo,
                'IdUsuario' => $this->IdUsuario
            ];
        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }


    /**
     * 
     * Metodo para actualizar un registro de la bd
     * @return bool 
     */

    public function delete_gpr_meta()
    {

        $sql = "DELETE FROM GruposComision WHERE IdGrupoUs=:IdGrupoUs";

        $data =
            [
                'IdGrupoUs' => $this->idGrupo
            ];
        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    public function departamento()
    {
        $sql = "SELECT * FROM departamentos WHERE Estatus = 1";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

}
