<?php
class visitasModel extends Model
{

    public $tipovisita;
    public $motivovisita;
    public $cliente;
    public $nombrecontacto;
    public $telcontacto;
    public $fechapicker;
    public $horapicker;
    public $descripcion;
    public $idcliente;
    public $domicilio;
    public $usuid;
    public $idvisita;

    public function all()
    {
        $sql = "SELECT * FROM proveedores where estatus=1";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    public function update()
    {

        $sql = "UPDATE  Visitas SET nombre=:nombre, descripcion=:descripcion, email=:email, telefono=:telefono, calle=:calle, 
        ninterior=:ninterior, nexterior=:nexterior, cp=:cp, municipio=:municipio, estado=:estado WHERE id=:id";
        $data =
            [
                'nombre' => $this->nombre,
                'descripcion' => $this->descripcion,
                'email' => $this->email,
                'telefono' => $this->telefono,
                'calle' => $this->calle,
                'ninterior' => $this->ninterior,
                'nexterior' => $this->nexterior,
                'cp' => $this->cp,
                'municipio' => $this->municipio,
                'estado' => $this->estado,
                'id' => $this->id
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    public function delete()
    {

        $sql = "UPDATE visita 
                SET estatus =:estatus  
                WHERE id=:id";
        $data =
            [
                'estatus' => 0,
                'id' => $this->id
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    public function add()
    {

        $sql = "INSERT INTO Visitas (IdCliente, TipoVisita, MotivoVisita, FechaVisita, HoraVisita, DescripcionVisita, EstatusVisita, DomicilioVisita, NombreContact, VendedorId, telContacto, NombreCliente) 
        VALUES (:IdCliente, :TipoVisita, :MotivoVisita, :FechaVisita, :HoraVisita, :DescripcionVisita, :EstatusVisita, :DomicilioVisita, :NombreContact, :VendedorId, :telContacto, :NombreCliente)";
        $data =

            [
                'IdCliente' => $this->idcliente,
                'TipoVisita' => $this->tipovisita,
                'MotivoVisita' => $this->motivovisita,
                'FechaVisita' => $this->fechapicker,
                'HoraVisita' => $this->horapicker,
                'DescripcionVisita' => $this->descripcion,
                'EstatusVisita' => 1,
                'DomicilioVisita' => $this->domicilio,
                'NombreContact' => $this->nombrecontacto,
                'VendedorId' => $this->usuid,
                'telContacto' => $this->telcontacto,
                'NombreCliente' => $this->cliente,
            ];

        try {
            return ($this->id = parent::query($sql, $data)) ? $this->id : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    public function updatevisita()
    {

        $sql = "UPDATE  Visitas SET MotivoVisita=:MotivoVisita, FechaVisita=:FechaVisita, HoraVisita=:HoraVisita, DescripcionVisita=:DescripcionVisita, DomicilioVisita=:DomicilioVisita, NombreContact=:NombreContact, telContacto=:telContacto, NombreCliente=:NombreCliente WHERE IdVisita=:IdVisita";
        $data =
            [
                'MotivoVisita' => $this->motivovisita,
                'FechaVisita' => $this->fechapicker,
                'HoraVisita' => $this->horapicker,
                'DescripcionVisita' => $this->descripcion,
                'DomicilioVisita' => $this->domicilio,
                'NombreContact' => $this->nombrecontacto,
                'telContacto' => $this->telcontacto,
                'NombreCliente' => $this->cliente,
                'IdVisita' => $this->idvisita
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    public function buscarone()
    {
        $sql = "SELECT v.*,ev.NombreEstatus FROM  Visitas v INNER JOIN EstatusVisita ev ON v.EstatusVisita = ev.IdEstatusv  WHERE IdCliente = :IdCliente AND EstatusVisita NOT IN (11,9)";

        try {
            return ($rows = parent::query($sql, ['IdCliente' => $this->idcliente])) ? $rows[0] : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los usuarios
     * @return void 
     */

    public function all2()
    {  
         $dbDetails = array(
            'host' => DB_HOST,
            'user'=> DB_USER,
            'pass'=> DB_PASS,
            'db' => DB_NAME
         );

         $table = <<<EOT
            (
            SELECT 
            v.IdVisita,
            v.IdCliente,
            v.TipoVisita,
            v.MotivoVisita,
            v.FechaVisita,
            v.HoraVisita,
            v.DescripcionVisita,
            v.EstatusVisita,
            v.CotizacionAsignada,
            v.OrdenAsignada,
            v.DomicilioVisita,
            v.NombreContact,
            v.VendedorId,
            v.telContacto,
            v.NombreCliente,
            ev.NombreEstatus as visitaNombreEstatus,
            ct.Estatus,
            ect.IdEstatus as IdEstatusCot,
            ect.Descripcion as DescripcionEstatus,
            o.estatus as ordenestatus,
            est.IdEstatus as IdEstatusOrd,
            est.Descripcion as nombreordenestatus
            FROM Visitas v
            INNER JOIN EstatusVisita ev ON  v.EstatusVisita = ev.IdEstatusv 
            LEFT JOIN cotizaciones ct ON v.CotizacionAsignada = ct.IdCotizacion
            LEFT JOIN estatuscotizaciones ect ON ct.Estatus = ect.IdEstatus 
            LEFT JOIN ordenes o ON v.OrdenAsignada = o.IdOrden
            LEFT JOIN estatus est ON est.IdEstatus  = o.estatus 
            WHERE v.EstatusVisita NOT IN (11,9,8,7)) temp
            EOT;

         $primaryKey = 'IdVisita';

         $columns = array(
            array('db' => 'IdVisita', 'dt' => 'IdVisita'),
            array('db' => 'IdCliente', 'dt' => 'IdCliente'),
            array('db' => 'TipoVisita',  'dt' => 'TipoVisita'),
            array('db' => 'MotivoVisita',   'dt' => 'MotivoVisita'),
            array('db' => 'FechaVisita',     'dt' => 'FechaVisita'),
            array('db' => 'HoraVisita',     'dt' => 'HoraVisita'),
            array('db' => 'DescripcionVisita',     'dt' => 'DescripcionVisita'),
            array('db' => 'EstatusVisita',     'dt' => 'EstatusVisita'),
            array('db' => 'CotizacionAsignada',     'dt' => 'CotizacionAsignada'),
            array('db' => 'OrdenAsignada',     'dt' => 'OrdenAsignada'),
            array('db' => 'DomicilioVisita',     'dt' => 'DomicilioVisita'),
            array('db' => 'NombreContact',     'dt' => 'NombreContact'),
            array('db' => 'VendedorId',     'dt' => 'VendedorId'),
            array('db' => 'telContacto',     'dt' => 'telContacto'),
            array('db' => 'NombreCliente',     'dt' => 'NombreCliente'),
            array('db' => 'visitaNombreEstatus',     'dt' => 'visitaNombreEstatus'),
            array('db' => 'Estatus',     'dt' => 'Estatus'),
            array('db' => 'DescripcionEstatus',     'dt' => 'DescripcionEstatus'),
            array('db' => 'ordenestatus',     'dt' => 'ordenestatus'),
            array('db' => 'nombreordenestatus',     'dt' => 'nombreordenestatus'),

        );

        return json_encode(
            parent::simple($_POST, $dbDetails, $table, $primaryKey, $columns)
        );
    }
}
