/* recall_rm_m11_m10.min.js — Recall Recarga/Mantenimiento (m-11 y m-10) con permisos por usuario */
(() => {
  const API_BASE='https://grupoxtinfire.com/admin/ajax/';
  const HOOK='codi_hook', ACTION='load';
  const ENDPOINTS={ recall:'ordenes_recarga_mantenimiento_recall', ordenDetalle:'detalle_orden_by_id' };
  const ORDER_URL_BASE='/admin/ordenes/detalle/';
  const SUPS=new Set([1,46,47,77,51]);

  const $=(s,c=document)=>c.querySelector(s);
  const el=(t,a,...k)=>{const n=document.createElement(t);if(a)Object.entries(a).forEach(([k2,v])=>{if(v==null||v===false)return;
    if(k2==='class')n.className=v; else if(k2.startsWith('on')&&typeof v==='function')n.addEventListener(k2.slice(2),v); else n.setAttribute(k2,v);});
    k.flat().forEach(x=>{if(x==null||x===false)return; n.appendChild(typeof x==='string'||typeof x==='number'?document.createTextNode(String(x)):x);});return n;};
  const normalize=s=>(s||'').toString().toLowerCase().normalize('NFD').replace(/\p{Diacritic}/gu,'');
  const currency=new Intl.NumberFormat('es-MX',{style:'currency',currency:'MXN'});
  const spinner=()=>el('div',{class:'d-flex justify-content-center my-4'},el('div',{class:'spinner-border text-danger',role:'status'}),el('span',{class:'ms-2'},'Cargando...'));

  const getUserId=()=>{ // intenta vanilla y jQuery (si existe)
    let v=null;
    const inp=document.getElementById('Idusu'); if(inp && inp.value!=null) v=inp.value;
    if((v==null||v==='') && window.jQuery){ try{ v=window.jQuery('#Idusu').val(); }catch(_){/*no-op*/} }
    const id=parseInt(v,10); return Number.isFinite(id)?id:0;
  };

  const apiPost=async(fn,params={})=>{
    const body=new URLSearchParams({hook:HOOK,action:ACTION,...params});
    const res=await fetch(API_BASE+fn,{method:'POST',headers:{'Content-Type':'application/x-www-form-urlencoded;charset=UTF-8'},body});
    if(!res.ok) throw new Error('HTTP '+res.status);
    const j=await res.json(); if(!j||j.status!==200||j.error) throw new Error(j?.msg||'Error API'); return j.data||[];
  };

  const makeTableUI=({title,columns,data,renderRow})=>{
    const search=el('input',{type:'search',class:'form-control',placeholder:'Buscar (multi-palabra)'});
    const pageSel=el('select',{class:'form-select'},el('option',{value:'50'},'50'),el('option',{value:'100'},'100'),el('option',{value:'all'},'Todos'));
    const table=el('table',{class:'table table-sm align-middle table-hover','data-table':'recall-rm'},el('thead',{},el('tr',{},...columns.map(c=>el('th',{},c)))),el('tbody',{}));
    const info=el('div',{class:'text-muted small'}), prev=el('button',{type:'button',class:'btn btn-sm btn-outline-danger'},'Anterior'), next=el('button',{type:'button',class:'btn btn-sm btn-outline-danger'},'Siguiente');
    const card=el('div',{class:'card mt-2'},el('div',{class:'card-body'},
      el('div',{class:'d-flex justify-content-between align-items-center mb-2'},el('h6',{class:'m-0'},title), el('div',{},search)),
      el('div',{class:'mb-2'}, el('label',{class:'small text-muted me-2'},'Mostrar:'), pageSel),
      el('div',{class:'table-responsive'},table),
      el('div',{class:'d-flex justify-content-between align-items-center mt-2'},info,el('div',{class:'d-flex gap-2'},prev,next))
    ));
    let pageSize=50,pageIndex=0,tokens=[];
    const normRow=r=>normalize(JSON.stringify(r));
    const getFiltered=()=> (data||[]).filter(r=>tokens.every(t=>normRow(r).includes(t)));
    const render=()=>{
      const list=getFiltered(), total=list.length, ps=pageSize===Infinity?total:pageSize, pages=ps?Math.ceil(total/ps):1;
      if(pageIndex>=pages) pageIndex=0;
      table.tBodies[0].innerHTML='';
      const start=pageIndex*(ps||1), end=pageSize===Infinity?total:Math.min(start+ps,total), slice=pageSize===Infinity?list:list.slice(start,end);
      slice.forEach(r=>table.tBodies[0].appendChild(renderRow(r)));
      const from=total?(start+1):0; info.textContent=`Mostrando ${from}-${end} de ${total}`;
      prev.disabled=(pageIndex<=0); next.disabled=(pageIndex>=pages-1||pages<=1);
    };
    search.addEventListener('input',()=>{tokens=normalize(search.value).split(/\s+/).filter(Boolean);pageIndex=0;render();});
    pageSel.addEventListener('change',()=>{pageSize=pageSel.value==='all'?Infinity:parseInt(pageSel.value,10);pageIndex=0;render();});
    prev.addEventListener('click',()=>{if(pageIndex>0){pageIndex--;render();}}); next.addEventListener('click',()=>{pageIndex++;render();});
    return {card,table,render};
  };

  const ensureModal=(id,title='Detalle de Orden')=>{
    let m=document.getElementById(id);
    if(!m){ m=el('div',{class:'modal fade',id,tabindex:'-1'},
      el('div',{class:'modal-dialog modal-xl modal-dialog-scrollable'},
        el('div',{class:'modal-content'},
          el('div',{class:'modal-header'}, el('h5',{class:'modal-title'},title), el('button',{type:'button',class:'btn-close','data-bs-dismiss':'modal','aria-label':'Close'})),
          el('div',{class:'modal-body',id:id+'-body'},'Cargando...'),
          el('div',{class:'modal-footer'}, el('button',{type:'button',class:'btn btn-danger','data-bs-dismiss':'modal'},'Cerrar'))
        )
      )
    ); document.body.appendChild(m); }
    return m;
  };
  const modal=ensureModal('modal-orden-detalle','Detalle de Orden');
  const modalBody=()=>$('#modal-orden-detalle-body');

  const verDetalleOrden=async(IdOrden)=>{
    const body=modalBody(); body.innerHTML='Cargando...';
    try{
      const det=await apiPost(ENDPOINTS.ordenDetalle,{ IdOrden: parseInt(IdOrden,10)||0 });
      const ui=makeTableUI({
        title:`Orden #${IdOrden} — Productos`,
        columns:['SKU','Producto','Cantidad','Precio','Neto'],
        data:det||[],
        renderRow:r=>el('tr',{},
          el('td',{}, r.proSku||''),
          el('td',{}, r.producto||r.proTitulo||''),
          el('td',{}, (r.Cantidad??r.cantidad??0)),
          el('td',{}, currency.format(r.PrecioVenta??r.precio??0)),
          el('td',{}, currency.format(r.Neto??0))
        )
      });
      body.innerHTML=''; body.appendChild(ui.card); ui.render();
    }catch(e){ body.innerHTML=`<div class="alert alert-danger">No se pudo cargar el detalle: ${e.message}</div>`; }
    new bootstrap.Modal(modal).show();
  };

  const buildRecallTable=(root,rows)=>{
    const ui=makeTableUI({
      title:'Recall Recarga/Mantenimiento (tipo_orden = 2) — Meses m-11 y m-10',
      columns:['Fecha Orden','Orden','Cliente','Teléfono','Correo','Vendedor','Ítems','Unidades','Total','Pedido actual (mes)'],
      data:rows||[],
      renderRow:r=>{
        const link=el('a',{href:ORDER_URL_BASE+r.IdOrden,target:'_blank',class:'text-decoration-none'},'#'+r.IdOrden);
        const btn=el('button',{type:'button',class:'btn btn-sm btn-outline-danger ms-2',onclick:()=>verDetalleOrden(r.IdOrden)},'Ver');
        let pedidoActual=el('span',{class:'text-muted'},'—');
        if(r.orden_mes_actual){
          const a=el('a',{href:ORDER_URL_BASE+r.orden_mes_actual,target:'_blank',class:'text-decoration-none'},'#'+r.orden_mes_actual);
          const bv=el('button',{type:'button',class:'btn btn-sm btn-outline-danger ms-2',onclick:()=>verDetalleOrden(r.orden_mes_actual)},'Ver');
          pedidoActual=el('span',{}, el('span',{class:'badge text-bg-danger me-2'},'Sí'), a, bv);
        } else {
          pedidoActual=el('span',{}, el('span',{class:'badge text-bg-secondary'},'No'));
        }
        return el('tr',{},
          el('td',{}, r.Fecha||''),
          el('td',{}, link, btn),
          el('td',{}, r.cliente||''),
          el('td',{}, r.telefono||''),
          el('td',{}, r.email||''),
          el('td',{}, r.vendedor||''),
          el('td',{}, (r.items??0)),
          el('td',{}, (r.unidades??0)),
          el('td',{}, currency.format(r.total??0)),
          el('td',{}, pedidoActual)
        );
      }
    });
    root.appendChild(ui.card); ui.render();
  };

  const mount=async()=>{
    const root=$('#recall-card-body'); if(!root) return;
    root.innerHTML='';
    const spin=spinner(); root.appendChild(spin);

    const uid=getUserId(); const isSup=SUPS.has(uid);

    try{
      // Enviar IdUsuario si NO es supervisor
      const params = isSup ? {} : { IdUsuario: uid };
      let rows = await apiPost(ENDPOINTS.recall, params);

      // Doble seguridad: si el back no filtró, filtramos en front por IdUsuario
      if(!isSup){
        rows = (rows||[]).filter(r => String(r.IdUsuario||'') === String(uid));
      }

      spin.remove();
      // Etiqueta de modo (opcional)
      const badge = el('div',{class:'mb-2'}, el('span',{class:`badge ${isSup?'text-bg-danger':'text-bg-secondary'}`}, isSup?'Supervisor: ve todas las órdenes':'Vista restringida: solo tus órdenes'));
      root.appendChild(badge);

      buildRecallTable(root, rows);
    }catch(e){
      console.error(e);
      spin.replaceWith(el('div',{class:'alert alert-danger'},'No se pudo cargar el reporte. ', el('small',{class:'text-muted d-block mt-1'},e.message)));
    }
  };

  document.addEventListener('DOMContentLoaded', mount);
})();
