

$(function () {
  "use strict";
var apibase = "https://grupoxtinfire.com/admin/";

  /* scrollar */

  new PerfectScrollbar(".notify-list")

  new PerfectScrollbar(".search-content")

  // new PerfectScrollbar(".mega-menu-widgets")



/* toggle button + hover bind seguro */
function bindSidebarHover() {
  var $sw = $(".sidebar-wrapper");
  $sw.off(".hoverSidebar");
  $sw.on("mouseenter.hoverSidebar", function () {
    $("body").addClass("sidebar-hovered");
  });
  $sw.on("mouseleave.hoverSidebar", function () {
    $("body").removeClass("sidebar-hovered");
  });
}

function unbindSidebarHover() {
  var $sw = $(".sidebar-wrapper");
  $sw.off(".hoverSidebar");
  $("body").removeClass("sidebar-hovered");
}

// Aplica estado al iniciar (clave si el <body> ya tiene 'toggled')
function applySidebarStateFromBody() {
  if ($("body").hasClass("toggled")) {
    bindSidebarHover();
  } else {
    unbindSidebarHover();
  }
}

// 1) Estado al cargar
applySidebarStateFromBody();

// 2) Click del botón
$(".btn-toggle").off("click").on("click", function () {
  $("body").toggleClass("toggled");
  applySidebarStateFromBody();
});

// 3) Botón de cerrar lateral (si existe)
$(".sidebar-close").off("click").on("click", function () {
  $("body").addClass("toggled");
  applySidebarStateFromBody();
});





  /* menu */

  $(function () {
    $('#sidenav').metisMenu();
  });

  $(".sidebar-close").on("click", function () {
    $("body").removeClass("toggled")
  })



  /* dark mode button */

  $(".dark-mode i").click(function () {
    $(this).text(function (i, v) {
      return v === 'dark_mode' ? 'light_mode' : 'dark_mode'
    })
  });


  $(".dark-mode").click(function () {
    $("html").attr("data-bs-theme", function (i, v) {
      return v === 'dark' ? 'light' : 'dark';
    })
  })


  function temaselected(temanumber){
    var hook = 'codi_hook';
    var action = 'update';
    var darkmode = temanumber;
    var colorswal = colortema();
    var IdUsuario = $("#usuarioId").val(); 
      $.ajax({
    url: apibase +'ajax/codi_update_tema',
    type: 'POST',
    dataType: 'json',
    cache: false,
    data: { hook, action, darkmode, IdUsuario},
    beforeSend: function () {
        
    }
      }).done(function (res) {
  
    if (res.status === 200) {
        const Toast = Swal.mixin({
        toast: true,
        position: "top-end",
        showConfirmButton: false,
        timer: 3000,
        timerProgressBar: true,
        didOpen: (toast) => {
          toast.onmouseenter = Swal.stopTimer;
          toast.onmouseleave = Swal.resumeTimer;
        }
      });
      Toast.fire({
        icon: "success",
        title: "Tema cambiado correctamente",
        theme: colorswal
      });
     setTimeout(() => {
          window.location.reload()
        }, 3000); // 2000 milliseconds = 2 seconds
    } else {
        const Toast = Swal.mixin({
          toast: true,
          position: "top-end",
          showConfirmButton: false,
          timer: 3000,
          timerProgressBar: true,
          didOpen: (toast) => {
            toast.onmouseenter = Swal.stopTimer;
            toast.onmouseleave = Swal.resumeTimer;
          }
        });
        Toast.fire({
          icon: "error",
          title: "Hubo un error en la aplicación",
          theme: colorswal
        });

    }
})
    .fail(function (err) {
        const Toast = Swal.mixin({
          toast: true,
          position: "top-end",
          showConfirmButton: false,
          timer: 3000,
          timerProgressBar: true,
          didOpen: (toast) => {
            toast.onmouseenter = Swal.stopTimer;
            toast.onmouseleave = Swal.resumeTimer;
          }
        });
        Toast.fire({
          icon: "error",
          title: "Hubo un error en la aplicación",
          theme: colorswal
        });
    })
    .always(function () {

    });
  }


  function traerordenesporvendedor() {
  var hook = 'codi_hook';
  var action = 'update';
  var IdUsuario = $("#usuarioId").val();
  var colorswal = colortema();

  $.ajax({
    url: apibase + 'ajax/codi_get_ordenes_ventas_individual',
    type: 'POST',
    dataType: 'json',
    cache: false,
    data: { hook, action, IdUsuario },
    beforeSend: function () { /* opcional: loader */ }
  })
  .done(function (res) {
    if (res.status === 200) {
      const orders = normalizeOrders(res);
      renderOrdersHTML(orders);
    } else {
      const Toast = Swal.mixin({
        toast: true, position: "top-end", showConfirmButton: false,
        timer: 3000, timerProgressBar: true,
        didOpen: (t) => { t.onmouseenter = Swal.stopTimer; t.onmouseleave = Swal.resumeTimer; }
      });
      Toast.fire({ icon: "error", title: "Hubo un error en la aplicación", theme: colorswal });
    }
  })
  .fail(function () {
    const Toast = Swal.mixin({
      toast: true, position: "top-end", showConfirmButton: false,
      timer: 3000, timerProgressBar: true,
      didOpen: (t) => { t.onmouseenter = Swal.stopTimer; t.onmouseleave = Swal.resumeTimer; }
    });
    Toast.fire({ icon: "error", title: "Hubo un error en la aplicación", theme: colorswal });
  });

  // --- Helpers ---
  function normalizeOrders(res) {
    let arr = [];
    if (Array.isArray(res.data)) arr = res.data;
    else if (typeof res.data === 'string') { try { arr = JSON.parse(res.data); } catch(e){} }
    else if (Array.isArray(res.rows)) arr = res.rows;
    else if (Array.isArray(res.result)) arr = res.result;
    else if (Array.isArray(res)) arr = res;
    return arr;
  }

  function renderOrdersHTML(data) {
    const $list = $('.order-list');
    const mxn = new Intl.NumberFormat('es-MX', { style: 'currency', currency: 'MXN' });
    const PLACEHOLDER = 'https://grupoxtinfire.com/admin/assets/img/imagen-no-dispoble.jpg';
    
    if (!Array.isArray(data) || data.length === 0) {
      $list.html('<div class="p-3 text-muted">Sin órdenes para este usuario.</div>');
      return;
    }
    $('#onentregadoslabel').text("Ordenes Activas: " + data.length);
    $('#cafaltantes').text(data.length);
    const STATUS_BADGE_CLASS   = 'badge rounded-pill bg-dark';             // fijo
    const TRANSITO_BADGE_CLASS = 'badge rounded-pill bg-info text-dark';   // fijo
    const html = data.map(o => {
      const img = o.ProductoImagen || PLACEHOLDER;
      const total = Number(o.TotalOrden || 0);
      const detalleURL = `https://grupoxtinfire.com/admin/ordenes/detalle/${encodeURIComponent(o.IdOrden)}`;
      $('#offentregadoslabel').text("Ordenes Entregadas: " + o.TotalEntregadasMes);
      return `
        <div class="order-item d-flex align-items-center gap-3 p-3 border-bottom">
          <div class="order-img">
            <img src="${escapeAttr(img)}" alt=""
                 loading="lazy"
                 onerror="this.src='${PLACEHOLDER}'">
          </div>

          <div class="order-info flex-grow-1">
            <!-- IdOrden + EstadoTransito -->
            <h6 class="mb-1 order-title d-flex align-items-center gap-2 flex-wrap">
              <span>#${Number(o.IdOrden)}</span>
              <span class="${TRANSITO_BADGE_CLASS}">${escapeHtml(o.EstadoTransito || '')}</span>
            </h6>

            <!-- Total + Estatus -->
            <div class="d-flex align-items-center gap-2 flex-wrap">
              <span class="order-price fw-semibold">${mxn.format(total)}</span>
              <span class="${STATUS_BADGE_CLASS}">${escapeHtml(o.Estatus || '')}</span>
            </div>
          </div>

          <div class="d-flex">
            <!-- Eliminado el icono de borrar -->
            <a class="order-view text-danger" href="${detalleURL}" target="_blank" rel="noopener" title="Ver detalle">
              <span class="material-icons-outlined">visibility</span>
            </a>
          </div>
        </div>`;
    }).join('');

    $list.html(html);
  }

  function escapeHtml(str) {
    return String(str)
      .replaceAll('&','&amp;').replaceAll('<','&lt;')
      .replaceAll('>','&gt;').replaceAll('"','&quot;')
      .replaceAll("'",'&#039;');
  }
  function escapeAttr(str) {
    return escapeHtml(str).replaceAll('`','&#096;');
  }
}



  /* sticky header */

  $(document).ready(function () {

    var tema = $("#colortema").val();
    $(window).on("scroll", function () {
      if ($(this).scrollTop() > 60) {
        $('.top-header .navbar').addClass('sticky-header');
      } else {
        $('.top-header .navbar').removeClass('sticky-header');
      }
    });
    
    if(tema == 1){
      $("html").attr("data-bs-theme", "dark")
      
    }
    if(tema == 2){
      $("html").attr("data-bs-theme", "blue-theme")
      
    }
    if(tema == 3){
      $("html").attr("data-bs-theme", "semi-dark")
      
    }
    if(tema == 4){
     $("html").attr("data-bs-theme", "bodered-theme")
      
    }

    traerordenesporvendedor();

  });


  /* email */

  $(".email-toggle-btn").on("click", function() {
    $(".email-wrapper").toggleClass("email-toggled")
  }), $(".email-toggle-btn-mobile").on("click", function() {
    $(".email-wrapper").removeClass("email-toggled")
  }), $(".compose-mail-btn").on("click", function() {
    $(".compose-mail-popup").show()
  }), $(".compose-mail-close").on("click", function() {
    $(".compose-mail-popup").hide()
  }), 


  /* chat */

  $(".chat-toggle-btn").on("click", function() {
    $(".chat-wrapper").toggleClass("chat-toggled")
  }), $(".chat-toggle-btn-mobile").on("click", function() {
    $(".chat-wrapper").removeClass("chat-toggled")
  }),



  /* switcher */

  


  $("#BlueTheme").on("click", function () {
    $("html").attr("data-bs-theme", "blue-theme")
    temaselected(2);
  }),

  $("#LightTheme").on("click", function () {
    $("html").attr("data-bs-theme", "light")
    temaselected(0);
  }),

    $("#DarkTheme").on("click", function () {
      $("html").attr("data-bs-theme", "dark")
      temaselected(1);
    }),

    $("#SemiDarkTheme").on("click", function () {
      $("html").attr("data-bs-theme", "semi-dark")
      temaselected(3);
    }),

    $("#BoderedTheme").on("click", function () {
      $("html").attr("data-bs-theme", "bodered-theme")
      temaselected(4);
    })



  /* search control */

  $(".search-control").click(function () {
    $(".search-popup").addClass("d-block");
    $(".search-close").addClass("d-block");
  });


  $(".search-close").click(function () {
    $(".search-popup").removeClass("d-block");
    $(".search-close").removeClass("d-block");
  });


  $(".mobile-search-btn").click(function () {
    $(".search-popup").addClass("d-block");
  });


  $(".mobile-search-close").click(function () {
    $(".search-popup").removeClass("d-block");
  });



/* menu active (no expandir ramas si está colapsado) */
(function () {
  var here = window.location.href.split("#")[0];
  var $a = $(".metismenu li a").filter(function () {
    return this.href.split("#")[0] === here;
  });
  var $li = $a.parent().addClass("mm-active");

  // Solo expandir si NO está colapsado
  if (!$("body").hasClass("toggled")) {
    $li.parents("ul").addClass("mm-show")
       .parents("li").addClass("mm-active");
  } else {
    // Garantiza que no reabra estando colapsado
    $li.parents("ul").removeClass("mm-show")
       .parents("li").removeClass("mm-active");
  }
})();


});
