/* primary2danger.js - convierte todos los botones primary -> danger (incluye futuros nodos) */
(function () {
  function swap(el) {
    if (!el || el.nodeType !== 1) return;
    const cl = el.classList;
    if (cl.contains('btn-primary')) cl.replace('btn-primary', 'btn-danger');
    if (cl.contains('btn-outline-primary')) cl.replace('btn-outline-primary', 'btn-outline-danger');
  }

  function scan(root = document) {
    root.querySelectorAll('.btn-primary, .btn-outline-primary').forEach(swap);
  }

  const observer = new MutationObserver(muts => {
    muts.forEach(m => {
      m.addedNodes.forEach(n => {
        if (n.nodeType !== 1) return;
        if (n.matches && (n.matches('.btn-primary') || n.matches('.btn-outline-primary'))) swap(n);
        if (n.querySelectorAll) scan(n);
      });
    });
  });

  function boot() {
    scan();
    observer.observe(document.documentElement, { childList: true, subtree: true });
  }

  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', boot);
  } else {
    boot();
  }

  // Exponer helper por si quieres forzar el reemplazo manualmente:
  window.forcePrimaryToDanger = () => scan();
})();