// /assets/js/upload.js
// expone una función global para subir un Blob de imagen al servidor (PHP)

window.uploadPhoto = async function uploadPhoto(blob, filename = 'foto.jpg', url = '/subir.php') {
  if (!(blob instanceof Blob)) throw new Error('No hay foto para subir.');
  const fd = new FormData();
  fd.append('foto', blob, filename);

  const resp = await fetch(url, { method: 'POST', body: fd });
  const contentType = resp.headers.get('content-type') || '';
  const payload = contentType.includes('application/json') ? await resp.json() : await resp.text();

  if (!resp.ok) {
    const msg = typeof payload === 'string' ? payload : (payload && payload.error) || 'Error al subir';
    throw new Error(msg);
  }
  return payload; // puede ser JSON o texto, según tu PHP
};
