/***********************************************
 *  PUNTO DE VENTA — RENDER HTML COMPLETO (CON TIPO DE ORDEN)
 ***********************************************/
const PUNTO_VENTA_HTML = `
<div class="row g-3">

  <!-- ===========================
       COLUMNA IZQUIERDA
       =========================== -->
  <div class="col-lg-8">

    <!-- ===========================
         BUSQUEDA DE PRODUCTOS
         =========================== -->
    <div class="card mb-3 border-danger rounded-3">
      <div class="card-header bg-danger text-white fw-bold">
        Buscar Productos
      </div>
      <div class="card-body">

        <!-- SELECTOR TIPO DE BUSQUEDA -->
        <div class="mb-2">
          <label class="form-label fw-bold">Tipo de búsqueda</label>
          <div class="form-check">
            <input class="form-check-input" type="checkbox" id="chkBuscarNombre">
            <label class="form-check-label" for="chkBuscarNombre">
              Buscar por nombre (con coincidencias y vista previa)
            </label>
          </div>
          <small class="text-muted">
            Si NO está marcado → la búsqueda será exclusivamente por SKU.
          </small>
        </div>

        <!-- BUSQUEDA -->
        <div class="input-group mb-3">
          <span class="input-group-text bg-danger text-white">Buscar</span>
          <input type="text" id="inputBusquedaProducto" class="form-control"
                 placeholder="Ejemplo: 12345 o 'reca man 4.5kg'">
        </div>

        <!-- RESULTADOS AUTOCOMPLETE -->
        <select id="selectResultados" class="form-select mt-2" size="8" style="display:none;"></select>

      </div>
    </div>

    <!-- ===========================
         CARRITO / DETALLE
         =========================== -->
    <div class="card border-danger rounded-3">
      <div class="card-header bg-danger text-white fw-bold">
        Productos en la Venta
      </div>
      <div class="card-body" id="carritoContainer">
        <p class="text-muted">No hay productos agregados.</p>
      </div>
    </div>

  </div>

  <!-- ===========================
       COLUMNA DERECHA
       =========================== -->
  <div class="col-lg-4">

    <!-- ===========================
         CLIENTE
         =========================== -->
    <div class="card mb-3 border-danger rounded-3">
      <div class="card-header bg-danger text-white fw-bold d-flex justify-content-between">
        Cliente
        <button class="btn btn-sm btn-outline-light" id="btnCambiarCliente">
          Cambiar
        </button>
      </div>

      <div class="card-body" id="clienteContainer">
        <p class="fw-bold mb-1">Público general</p>
        <p class="mb-0 text-muted">ID Cliente: 7052</p>
      </div>
    </div>

    <!-- ===========================
         DOMICILIO
         =========================== -->
    <div class="card mb-3 border-danger rounded-3">
      <div class="card-header bg-danger text-white fw-bold d-flex justify-content-between">
        Domicilio
        <button class="btn btn-sm btn-outline-light" id="btnSeleccionarDomicilio">
          Seleccionar
        </button>
      </div>

      <div class="card-body" id="domicilioContainer">
        <p class="text-muted mb-0">Ningún domicilio seleccionado.</p>
      </div>
    </div>

    <!-- ===========================
         TIPO DE ORDEN (NUEVO)
         =========================== -->
    <div class="card mb-3 border-danger rounded-3">
      <div class="card-header bg-danger text-white fw-bold">
        Tipo de Orden
      </div>
      <div class="card-body">
        <select class="form-select" id="selectTipoOrden">
          <option value="1">Equipo nuevo</option>
          <option value="2">Recarga y mantenimiento</option>
          <option value="3">Capacitaciones</option>
          <option value="6">PIPC</option>
          <option value="7">Proyecto especial</option>
          <option value="8">Solicitud taller</option>
        </select>
      </div>
    </div>

    <!-- ===========================
         SIN IVA
         =========================== -->
    <div class="form-check mb-3">
      <input class="form-check-input" type="checkbox" id="chkSinIVA">
      <label class="form-check-label fw-bold" for="chkSinIVA">
        Venta sin IVA
      </label>
    </div>

    <!-- ===========================
         MÉTODO DE PAGO
         =========================== -->
    <div class="card mb-3 border-danger rounded-3">
      <div class="card-header bg-danger text-white fw-bold">
        Método de Pago
      </div>
      <div class="card-body">

        <select class="form-select" id="selectMetodoPago">
          <option value="01">Efectivo</option>
          <option value="03">Transferencia</option>
          <option value="04">Tarjeta de Crédito</option>
          <option value="28">Tarjeta de Débito</option>
          <option value="02">Cheque</option>
          <option value="99">Crédito / Por definir</option>
        </select>

      </div>
    </div>

    <!-- ===========================
         TOTALES
         =========================== -->
    <div class="card border-danger rounded-3">
      <div class="card-header bg-danger text-white fw-bold">
        Totales
      </div>
      <div class="card-body">

        <div class="d-flex justify-content-between mb-1">
          <span class="fw-bold">Subtotal:</span>
          <span id="lblSubtotal">$0.00</span>
        </div>

        <div class="d-flex justify-content-between mb-1">
          <span class="fw-bold">IVA (16%):</span>
          <span id="lblIVA">$0.00</span>
        </div>

        <hr>

        <div class="d-flex justify-content-between fs-5 fw-bold">
          <span>Total:</span>
          <span id="lblTotal">$0.00</span>
        </div>

      </div>
    </div>

    <!-- BOTON VENTA PENDIENTE -->
    <button id="btnVentaPendiente" class="btn btn-secondary w-100 mt-3" disabled>
      Venta pendiente encontrada
    </button>
    <button id="btnBorradorTMP" class="btn btn-warning w-100 mt-2" style="display:none;">
    Borrador encontrado — Cargar
</button>

<button id="btnBorrarTMP" class="btn btn-outline-warning w-100 mt-2" style="display:none;">
    Eliminar borrador
</button>

    <!-- FINALIZAR -->
    <button id="btnFinalizarVenta" class="btn btn-danger w-100 mt-3">
      Finalizar Venta
    </button>

  </div>

</div>
`;

document.getElementById("puntodeventa-card-body").innerHTML = PUNTO_VENTA_HTML;


/*****************************************************************
 * VARIABLES GLOBALES DEL POS (UNIFICADAS + SISTEMA TEMPORAL)
 *****************************************************************/

// Tu estructura existente
let carrito = [];
let clienteSeleccionado = { id: 7052, nombre: "Público general", RFC: "" };
let domicilioSeleccionado = null;

// ===============================
// NUEVAS PARA ORDENES_TMP
// ===============================

let tmpKey = null;               // Identificador único de venta temporal
let metodoPagoActual = "01";     // Sincroniza con selectMetodoPago
let sinIVA = 0;                  // Sin IVA 0/1
let tipoOrdenActual = 1;         // Tipo de orden seleccionado

// ===============================
// Inicializar tmpKey en cada sesión del POS
// ===============================
function iniciarTmpKey() {
    // Si ya existe en sessionStorage, se mantiene
    tmpKey = sessionStorage.getItem("tmpKey");

    if (!tmpKey) {
        tmpKey = "TMP-" + Date.now();   // Ej: TMP-1699991231234
        sessionStorage.setItem("tmpKey", tmpKey);
    }

    console.log("🔑 tmpKey actual:", tmpKey);
}

// Llamamos la inicialización al cargar el POS
iniciarTmpKey();

function verificarTMP() {

    const fd = new FormData();
    fd.append("hook", "codi_hook");
    fd.append("action", "load");   // ✔ acción válida
       
    fetch("https://grupoxtinfire.com/admin/ajax/puntodeventa_tmpgetuser", {
        method: "POST",
        body: fd
    })
    .then(r => r.json())
    .then(json => {

        if (json.status !== 200 || !json.data || !json.data.jsonData) {
            return;
        }

        // Mostrar botones
        document.getElementById("btnBorradorTMP").style.display = "block";
        document.getElementById("btnBorrarTMP").style.display = "block";

        // BTN: cargar TMP
        document.getElementById("btnBorradorTMP").onclick = () => {
            cargarTMPDesdeJSON(json.data.jsonData);
        };

        // BTN: eliminar TMP
        document.getElementById("btnBorrarTMP").onclick = eliminarTMP;
    });
}


verificarTMP();

function cargarTMPDesdeJSON(jsonString) {

    let data = null;

    try {
        data = JSON.parse(jsonString);
    } catch (e) {
        console.error("❌ TMP JSON inválido:", e);
        return;
    }

    // ======================
    // CLIENTE
    // ======================
    if (data.cliente) {
        clienteSeleccionado = data.cliente;

        document.getElementById("clienteContainer").innerHTML = `
            <p class="fw-bold">${clienteSeleccionado.nombre}</p>
            <p class="text-muted small">ID: ${clienteSeleccionado.id}</p>
            <p class="text-muted small">RFC: ${clienteSeleccionado.RFC}</p>
        `;
    }

    // ======================
    // DOMICILIO
    // ======================
    if (data.domicilio) {

        domicilioSeleccionado = data.domicilio;

        const d = domicilioSeleccionado;
        const texto = `${d.EntCalle} ${d.EntNExt ?? ""} ${d.EntNInt ?? ""}, 
                        ${d.EntColonia}, ${d.EntCP}, 
                        ${d.EntMunicipio}, ${d.EntEstado}`;

        document.getElementById("domicilioContainer").innerHTML = `
            <p class="fw-bold mb-1">Domicilio seleccionado:</p>
            <p class="text-muted small">${texto}</p>
        `;
    }

    // ======================
    // CARRITO
    // ======================
    carrito = Array.isArray(data.carrito) ? data.carrito : [];
    renderCarrito();

    // ======================
    // TIPO ORDEN
    // ======================
    if (data.tipoOrden) {
        selectTipoOrden.value = data.tipoOrden;
    }

    // ======================
    // MÉTODO DE PAGO
    // ======================
    if (data.metodoPago) {
        document.getElementById("selectMetodoPago").value = data.metodoPago;
    }

    // ======================
    // SIN IVA
    // ======================
    document.getElementById("chkSinIVA").checked = (data.sinIVA == 1);

    // Ocultar select resultados
    document.getElementById("selectResultados").style.display = "none";

    console.log("✔ TMP restaurado exitosamente");
}



function eliminarTMP() {

    const fd = new FormData();
    fd.append("hook", "codi_hook");
    fd.append("action", "delete");

    fetch("https://grupoxtinfire.com/admin/ajax/puntodeventa_tmpDeleteUser", {
        method: "POST",
        body: fd
    })
    .then(r => r.json())
    .then(json => {

        if (json.status === 200) {
            alert("✔ Borrador eliminado.");

            document.getElementById("btnBorradorTMP").style.display = "none";
            document.getElementById("btnBorrarTMP").style.display = "none";
        }
    });
}



/*****************************************************************
 * CARGAR ORDEN TEMPORAL DESDE MYSQL
 *****************************************************************/
cargarTmp();

function cargarTmp() {

    const fd = new FormData();
    fd.append("hook", "codi_hook");
    fd.append("action", "load");

    fetch("https://grupoxtinfire.com/admin/ajax/puntodeventa_tmpgetuser", {
        method: "POST",
        body: fd
    })
    .then(r => r.json())
    .then(json => {

        if (json.status !== 200 || !json.data || !json.data.jsonData) {
            return;
        }

        let data = null;

        try {
            data = JSON.parse(json.data.jsonData);
        } catch (e) {
            console.error("❌ JSON TMP inválido:", e);
            return;
        }

        // =============================
        // VALIDACIONES Y RESTAURACIÓN
        // =============================

        // CLIENTE
        if (data.cliente) {
            clienteSeleccionado = data.cliente;

            document.getElementById("clienteContainer").innerHTML = `
                <p class="fw-bold">${clienteSeleccionado.nombre}</p>
                <p class="text-muted small">ID: ${clienteSeleccionado.id}</p>
                <p class="text-muted small">RFC: ${clienteSeleccionado.RFC}</p>
            `;
        }

        // DOMICILIO
        if (data.domicilio) {
            domicilioSeleccionado = data.domicilio;

            const d = domicilioSeleccionado;
            const texto = `${d.EntCalle} ${d.EntNExt ?? ""} ${d.EntNInt ?? ""}, ${d.EntColonia}, ${d.EntCP}, ${d.EntMunicipio}, ${d.EntEstado}`;

            document.getElementById("domicilioContainer").innerHTML = `
                <p class="fw-bold mb-1">Domicilio seleccionado:</p>
                <p class="text-muted small">${texto}</p>
            `;
        }

        // CARRITO
        carrito = Array.isArray(data.carrito) ? data.carrito : [];
        renderCarrito();

        // TIPO DE ORDEN
        if (data.tipoOrden) {
            selectTipoOrden.value = data.tipoOrden;
        }

        // MÉTODO DE PAGO
        if (data.metodoPago) {
            document.getElementById("selectMetodoPago").value = data.metodoPago;
        }

        // SIN IVA
        document.getElementById("chkSinIVA").checked = (data.sinIVA == 1);

    })
    .catch(err => console.error("Error cargarTmp:", err));
}



/*****************************************************************
 * GUARDAR ORDEN TEMPORAL EN MYSQL
 *****************************************************************/
function guardarTmp() {

    const data = {
        cliente: clienteSeleccionado ?? null,
        domicilio: domicilioSeleccionado ?? null,
        carrito: Array.isArray(carrito) ? carrito : [],
        tipoOrden: selectTipoOrden.value,
        metodoPago: document.getElementById("selectMetodoPago").value,
        sinIVA: document.getElementById("chkSinIVA").checked ? 1 : 0
    };

    const fd = new FormData();
    fd.append("hook", "codi_hook");
    fd.append("action", "update");   // ✔ SOLO ACCIONES PERMITIDAS
    fd.append("venta", JSON.stringify(data));

    fetch("https://grupoxtinfire.com/admin/ajax/puntodeventa_tmpGuardarUser", {
        method: "POST",
        body: fd
    })
    .catch(err => console.error("Error guardarTmp:", err));
}






/*****************************************************************
 * ELEMENTOS DOM
 *****************************************************************/
const inputBusqueda = document.getElementById("inputBusquedaProducto");
const chkBuscarNombre = document.getElementById("chkBuscarNombre");
const selectTipoOrden = document.getElementById("selectTipoOrden");

/*****************************************************************
 * EVENTOS QUE GUARDAN TMP AUTOMÁTICO
 *****************************************************************/

// Tipo de orden
selectTipoOrden.addEventListener("change", () => {
    guardarTmp();
});

// Método de pago
document.getElementById("selectMetodoPago")
    .addEventListener("change", guardarTmp);

// SIN IVA
document.getElementById("chkSinIVA")
    .addEventListener("change", guardarTmp);

/*****************************************************************
 * BUSCADOR DE PRODUCTOS (CON TIPO DE ORDEN)
 *****************************************************************/
let searchTimeout = null;

inputBusqueda.addEventListener("keyup", () => {

    const texto = inputBusqueda.value.trim();
    const select = document.getElementById("selectResultados");

    if (texto.length === 0) {
        select.innerHTML = "";
        select.style.display = "none";
        return;
    }

    clearTimeout(searchTimeout);
    searchTimeout = setTimeout(() => buscarProductos(texto), 350);
});

function buscarProductos(texto) {

    const tipoOrden = selectTipoOrden.value;

    const fd = new FormData();
    fd.append("action", "load");
    fd.append("hook", "codi_hook");
    fd.append("buscar", texto);
    fd.append("porNombre", chkBuscarNombre.checked ? 1 : 0);
    fd.append("tipoOrden", tipoOrden);

    fetch("https://grupoxtinfire.com/admin/ajax/puntodeventa_productos", {
        method: "POST",
        body: fd
    })
    .then(r => r.json())
    .then(json => {
        if (json.status !== 200) return;
        mostrarResultados(json.data);
    });
}

function mostrarResultados(productos) {

    const select = document.getElementById("selectResultados");

    if (!Array.isArray(productos) || productos.length === 0) {
        select.style.display = "none";
        select.innerHTML = "";
        return;
    }

    let html = "";

    productos.forEach(p => {
        html += `
        <option value="${p.proId}">
            ${p.proTitulo} — SKU ${p.proSku}
        </option>`;
    });

    select.innerHTML = html;
    select.style.display = "block";

    select.onchange = () => {
        const id = select.value;
        if (!id) return;

        if (!validarStockJS(id)) {
            return;
        }

        agregarProducto(parseInt(id));
    };
}

/*****************************************************************
 * AGREGAR PRODUCTO AL CARRITO
 *****************************************************************/
function agregarProducto(id) {

  if (carrito.length >= 80 && delta > 0) {
      alert("⚠ Límite máximo de productos por orden alcanzado.");
      return;
  }

    const fd = new FormData();
    fd.append("action", "load");
    fd.append("hook", "codi_hook");
    fd.append("idProducto", id);

    fetch("https://grupoxtinfire.com/admin/ajax/puntodeventa_getProducto", {
        method: "POST",
        body: fd
    })
    .then(r => r.json())
    .then(json => {

        if (json.status !== 200) return;

        const p = json.data[0];

        // 🔥 VALIDACIÓN DE STOCK
        if (p.proExistencia <= 0 ) {
            alert("❌ No hay stock disponible para este producto.");
            return;
        }

        const existe = carrito.find(x => x.id === p.proId);

        if (existe) {
            if (existe.cantidad + 1 > p.proExistencia) {
                alert(`❌ Stock insuficiente. Solo quedan ${p.proExistencia} unidades.`);
                return;
            }
            existe.cantidad++;
        } else {
            carrito.push({
                id: p.proId,
                nombre: p.proTitulo,
                sku: p.proSku,
                precio: parseFloat(p.proPrecioventa),
                img: p.proImagen,
                stock: p.proExistencia, // nuevo
                cantidad: 1
            });
        }

        renderCarrito();
        guardarTmp();
        document.getElementById("selectResultados").style.display = "none";
        inputBusqueda.value = "";
    })
    .catch(err => console.error(err));
}



function renderCarrito() {
    const div = document.getElementById("carritoContainer");

    if (carrito.length === 0) {
        div.innerHTML = `<p class="text-muted">No hay productos agregados.</p>`;
        actualizarTotales();
        return;
    }

    let html = "";

    carrito.forEach(item => {
        html += `
        <div class="d-flex justify-content-between align-items-center border-bottom py-2">
            <div class="d-flex">
                <img src="${item.img}" style="width:48px;height:48px;border-radius:6px;">
                <div class="ms-2">
                    <div class="fw-bold">${item.nombre}</div>
                    <small class="text-muted">SKU: ${item.sku}</small>
                </div>
            </div>

            <div class="text-end">

                <div class="input-group input-group-sm mb-1" style="width:120px;">
                    <button class="btn btn-danger" onclick="cambiarCantidad(${item.id}, -1)">-</button>
                    <input class="form-control text-center" readonly value="${item.cantidad}">
                    <button class="btn btn-danger" onclick="cambiarCantidad(${item.id}, 1)">+</button>
                </div>

                <strong>$${(item.precio * item.cantidad).toFixed(2)}</strong>
                <br>
                <a href="javascript:;" class="text-danger small" onclick="eliminarProducto(${item.id})">
                    Quitar
                </a>
            </div>
        </div>`;
    });

    div.innerHTML = html;
    actualizarTotales();
}

function cambiarCantidad(id, delta) {
    const item = carrito.find(x => x.id === id);
    if (!item) return;

    // 🔥 Nueva validación
    if (delta > 0 && item.cantidad + 1 > item.stock) {
        alert(`❌ Stock insuficiente. Solo quedan ${item.stock} unidades.`);
        return;
    }

    item.cantidad += delta;
    if (item.cantidad <= 0) carrito = carrito.filter(x => x.id !== id);

    renderCarrito();
    guardarTmp();
}

function eliminarProducto(id) {
    carrito = carrito.filter(x => x.id !== id);
    renderCarrito();
    guardarTmp();

}

/*****************************************************************
 * TOTALES
 *****************************************************************/
function actualizarTotales() {
    const sinIVA = document.getElementById("chkSinIVA").checked;

    let subtotal = 0;
    carrito.forEach(i => subtotal += i.precio * i.cantidad);

    const iva = sinIVA ? 0 : subtotal * 0.16;
    const total = subtotal + iva;

    document.getElementById("lblSubtotal").textContent = "$" + subtotal.toFixed(2);
    document.getElementById("lblIVA").textContent = "$" + iva.toFixed(2);
    document.getElementById("lblTotal").textContent = "$" + total.toFixed(2);
}

/*****************************************************************
 * CLIENTES (BÚSQUEDA + MODAL)
 *****************************************************************/
const modalClientesHTML = `
<div class="modal fade" id="modalBuscarCliente" tabindex="-1">
  <div class="modal-dialog modal-lg modal-dialog-scrollable">
    <div class="modal-content">

      <div class="modal-header bg-danger text-white">
        <h5 class="modal-title">Buscar Cliente</h5>
        <button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>

      <div class="modal-body">
        <div class="mb-2">
          <label class="fw-bold">Buscar (RFC o Nombre)</label>
          <input type="text" class="form-control" id="inputBuscarCliente">
        </div>

        <div class="form-check mb-3">
          <input type="checkbox" class="form-check-input" id="chkBuscarPorNombreCliente">
          <label class="form-check-label" for="chkBuscarPorNombreCliente">Buscar por Nombre</label>
        </div>

        <div id="containerResultadosClientes">
          <p class="text-muted">Escribe para buscar.</p>
        </div>

      </div>

    </div>
  </div>
</div>
`;

document.body.insertAdjacentHTML("beforeend", modalClientesHTML);

/*****************************************************************
 * ABRIR MODAL CLIENTES
 *****************************************************************/
document.getElementById("btnCambiarCliente").addEventListener("click", () => {
    new bootstrap.Modal(document.getElementById("modalBuscarCliente")).show();
});

let timeoutCliente = null;

document.addEventListener("keyup", e => {
    if (e.target.id === "inputBuscarCliente") {
        const valor = e.target.value.trim();
        if (valor.length < 2) {
            document.getElementById("containerResultadosClientes").innerHTML =
                `<p class="text-muted">Escribe al menos 2 caracteres.</p>`;
            return;
        }

        clearTimeout(timeoutCliente);
        timeoutCliente = setTimeout(() => buscarClientes(valor), 300);
    }
});

function buscarClientes(b) {

    const fd = new FormData();
    fd.append("action", "load");
    fd.append("hook", "codi_hook");
    fd.append("buscar", b);
    fd.append("porNombre", document.getElementById("chkBuscarPorNombreCliente").checked ? 1 : 0);

    fetch("https://grupoxtinfire.com/admin/ajax/puntodeventa_clientes", {
        method: "POST",
        body: fd
    })
    .then(r => r.json())
    .then(json => {
        if (json.status !== 200) {
            document.getElementById("containerResultadosClientes").innerHTML =
                `<p class='text-danger'>No encontrado.</p>`;
            return;
        }

        renderResultadosClientes(json.data);
    });
}

function renderResultadosClientes(list) {

    let html = `
    <table class="table table-striped">
      <thead><tr>
        <th>Cliente</th>
        <th>RFC</th>
        <th>Municipio</th>
        <th></th>
      </tr></thead>
      <tbody>
    `;

    list.forEach(cli => {
        html += `
        <tr>
          <td>${cli.Nombre} <br> ${cli.Moroso == 1 ? "<span class='badge bg-danger'>Moroso</span>" : ""}</td>
          <td>${cli.RFC}</td>
          <td>${cli.FisMunicipio ?? "-"}</td>
          <td>
            <button class="btn btn-danger btn-sm" onclick='seleccionarCliente(${JSON.stringify(cli)})'>
              Seleccionar
            </button>
          </td>
        </tr>`;
    });

    html += "</tbody></table>";

    document.getElementById("containerResultadosClientes").innerHTML = html;
}

function seleccionarCliente(cli) {

    if (cli.Moroso == 1) {
        alert("⚠ Cliente MOROSO: solo paga CONTADO.");
    }

    clienteSeleccionado = {
        id: cli.IdCliente,
        nombre: cli.Nombre,
        RFC: cli.RFC
    };

    document.getElementById("clienteContainer").innerHTML = `
      <p class="fw-bold">${cli.Nombre}</p>
      <p class="text-muted small">ID: ${cli.IdCliente}</p>
      <p class="text-muted small">RFC: ${cli.RFC}</p>
    `;

    bootstrap.Modal.getInstance(document.getElementById("modalBuscarCliente")).hide();

    cargarDomicilios(cli.IdCliente);
    guardarTmp();

}

/*****************************************************************
 * MODAL DOMICILIOS
 *****************************************************************/
const modalDomicilioHTML = `
<div class="modal fade" id="modalDomicilio" tabindex="-1">
  <div class="modal-dialog modal-lg modal-dialog-scrollable">
    <div class="modal-content">

      <div class="modal-header bg-danger text-white">
        <h5 class="modal-title">Domicilios</h5>
        <button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>

      <div class="modal-body" id="bodyDomicilios">
        <p class="text-muted">Seleccione un cliente.</p>
      </div>

    </div>
  </div>
</div>
`;

document.body.insertAdjacentHTML("beforeend", modalDomicilioHTML);

document.getElementById("btnSeleccionarDomicilio").addEventListener("click", () => {
    new bootstrap.Modal(document.getElementById("modalDomicilio")).show();
});

/*****************************************************************
 * CARGAR DOMICILIOS DEL CLIENTE
 *****************************************************************/
function cargarDomicilios(idCliente) {

    const fd = new FormData();
    fd.append("action", "load");
    fd.append("hook", "codi_hook");
    fd.append("idCliente", idCliente);

    fetch("https://grupoxtinfire.com/admin/ajax/puntodeventa_domicilios", {
        method: "POST",
        body: fd
    })
    .then(r => r.json())
    .then(json => {
        if (json.status !== 200) return;
        renderDomicilios(json.data);
    });
}

function renderDomicilios(list) {

    let html = "<table class='table table-striped'><tbody>";

    list.forEach(d => {

        const texto = `${d.EntCalle} ${d.EntNExt ?? ""} ${d.EntNInt ?? ""}, ${d.EntColonia}, ${d.EntCP}, ${d.EntMunicipio}, ${d.EntEstado}`;

        html += `
        <tr>
          <td>${texto}</td>
          <td width="120">
            <button class="btn btn-danger btn-sm"
                    onclick='seleccionarDomicilio(${JSON.stringify(d)})'>
              Seleccionar
            </button>
          </td>
        </tr>`;
    });

    html += "</tbody></table>";

    document.getElementById("bodyDomicilios").innerHTML = html;
}

function seleccionarDomicilio(d) {

    domicilioSeleccionado = d;

    const texto = `${d.EntCalle} ${d.EntNExt ?? ""} ${d.EntNInt ?? ""}, ${d.EntColonia}, ${d.EntCP}, ${d.EntMunicipio}, ${d.EntEstado}`;

    document.getElementById("domicilioContainer").innerHTML = `
        <p class="fw-bold mb-1">Domicilio seleccionado:</p>
        <p class="text-muted small">${texto}</p>
    `;

    bootstrap.Modal.getInstance(document.getElementById("modalDomicilio")).hide();
    guardarTmp();

}

/*****************************************************************
 * LOCAL STORAGE — VENTA PENDIENTE
 *****************************************************************/
function guardarVentaPendiente() {

    const data = {
        carrito,
        cliente: clienteSeleccionado,
        domicilio: domicilioSeleccionado,
        tipoOrden: selectTipoOrden.value,
        metodoPago: document.getElementById("selectMetodoPago").value,
        sinIVA: document.getElementById("chkSinIVA").checked
    };

    localStorage.setItem("ventaPendientePOS", JSON.stringify(data));
}

function cargarVentaPendiente() {
    const v = localStorage.getItem("ventaPendientePOS");
    if (!v) return;

    document.getElementById("btnVentaPendiente").disabled = false;
    document.getElementById("btnVentaPendiente").addEventListener("click", () => {

        const data = JSON.parse(v);

        carrito = data.carrito ?? [];
        clienteSeleccionado = data.cliente ?? clienteSeleccionado;
        domicilioSeleccionado = data.domicilio ?? null;

        selectTipoOrden.value = data.tipoOrden ?? 1;
        document.getElementById("selectMetodoPago").value = data.metodoPago ?? "01";
        document.getElementById("chkSinIVA").checked = data.sinIVA ?? false;

        renderCarrito();

        document.getElementById("clienteContainer").innerHTML = `
            <p class="fw-bold">${clienteSeleccionado.nombre}</p>
            <p class="text-muted small">ID: ${clienteSeleccionado.id}</p>
        `;

        if (domicilioSeleccionado) {
            seleccionarDomicilio(domicilioSeleccionado);
        }
    });
}

cargarVentaPendiente();

/*****************************************************************
 * FINALIZAR VENTA — CREAR ORDEN REAL
 *****************************************************************/
document.getElementById("btnFinalizarVenta").addEventListener("click", () => {

    if (carrito.length === 0) {
        alert("No hay productos en el carrito.");
        return;
    }

    if (!domicilioSeleccionado) {
        alert("Selecciona un domicilio.");
        return;
    }

    const payload = {
        cliente: clienteSeleccionado,
        domicilio: domicilioSeleccionado,
        carrito: carrito,
        metodoPago: document.getElementById("selectMetodoPago").value,
        sinIVA: document.getElementById("chkSinIVA").checked ? 1 : 0,
        tipoOrden: selectTipoOrden.value
    };
    
    if (clienteSeleccionado.Moroso == 1 && document.getElementById("selectMetodoPago").value !== "01") {
        alert("⚠ Cliente MOROSO: solo puede pagar en efectivo.");
        return;
    }


    const fd = new FormData();
    fd.append("hook", "codi_hook");
    fd.append("action", "add");
    fd.append("venta", JSON.stringify(payload));

    fetch("https://grupoxtinfire.com/admin/ajax/puntodeventa_crearorden", {
        method: "POST",
        body: fd
    })
    .then(r => r.json())
    .then(json => {

        if (json.status !== 200) {
            alert("❌ Error: " + json.message);
            return;
        }

        localStorage.removeItem("ventaPendientePOS");

        alert("✔ Orden creada.\nFolio: " + json.data.FolioOrden);
    })
    .catch(err => {
        console.error(err);
        alert("Error inesperado.");
    });

});

function verificarOrdenesActivas() {

    const fd = new FormData();
    fd.append("action", "load");
    fd.append("hook", "codi_hook");

    fetch("https://grupoxtinfire.com/admin/ajax/puntodeventa_ordenesactivas", {
        method: "POST",
        body: fd
    })
    .then(r => r.json())
    .then(json => {

        if (json.code !== 200) return;

        const ordenes = json.data;

        if (!Array.isArray(ordenes) || ordenes.length === 0) {
            document.getElementById("btnVentaPendiente").disabled = true;
            return;
        }

        document.getElementById("btnVentaPendiente").disabled = false;

        // Al hacer clic abrir modal con las ordenes
        document.getElementById("btnVentaPendiente").onclick = () => {
            mostrarModalOrdenesActivas(ordenes);
        };
    });
}

verificarOrdenesActivas();


const modalOrdenesActivasHTML = `
<div class="modal fade" id="modalOrdenesActivas" tabindex="-1">
  <div class="modal-dialog modal-lg modal-dialog-scrollable">
    <div class="modal-content">

      <div class="modal-header bg-danger text-white">
        <h5 class="modal-title">Órdenes activas</h5>
        <button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>

      <div class="modal-body" id="modalOrdenesActivasBody">
        <p class="text-muted">Cargando...</p>
      </div>

    </div>
  </div>
</div>
`;

document.body.insertAdjacentHTML("beforeend", modalOrdenesActivasHTML);

function mostrarModalOrdenesActivas(list) {

    let html = `
    <table class="table table-striped">
      <thead>
        <tr>
          <th>Folio</th>
          <th>Fecha</th>
          <th>Total</th>
          <th></th>
        </tr>
      </thead>
      <tbody>
    `;

    list.forEach(o => {
        html += `
        <tr>
          <td>${o.FolioOrden}</td>
          <td>${o.Fecha}</td>
          <td>$${parseFloat(o.Total).toFixed(2)}</td>
          <td>
            <button class="btn btn-danger btn-sm"
                    onclick='cargarOrdenActiva(${o.IdOrden})'>
              Cargar
            </button>
          </td>
        </tr>`;
    });

    html += "</tbody></table>";

    document.getElementById("modalOrdenesActivasBody").innerHTML = html;

    new bootstrap.Modal(document.getElementById("modalOrdenesActivas")).show();
}

function cargarOrdenActiva(idOrden) {

    const fd = new FormData();
    fd.append("action", "load");
    fd.append("hook", "codi_hook");
    fd.append("idOrden", idOrden);

    fetch("https://grupoxtinfire.com/admin/ajax/puntodeventa_getOrden", {
        method: "POST",
        body: fd
    })
    .then(r => r.json())
    .then(json => {

        if (json.code !== 200) {
            alert("Error al cargar la orden");
            return;
        }

        const data = json.data;

        // ==============================
        // CARGAR CLIENTE
        // ==============================
        clienteSeleccionado = {
            id: data.cliente.IdCliente,
            nombre: data.cliente.Nombre,
            RFC: data.cliente.RFC
        };

        document.getElementById("clienteContainer").innerHTML = `
            <p class="fw-bold">${data.cliente.Nombre}</p>
            <p class="text-muted small">ID: ${data.cliente.IdCliente}</p>
            <p class="text-muted small">RFC: ${data.cliente.RFC}</p>
        `;

        // ==============================
        // CARGAR DOMICILIO
        // ==============================
        domicilioSeleccionado = data.domicilio;

        const textoDom = `${data.domicilio.EntCalle} ${data.domicilio.EntNExt ?? ""} ${data.domicilio.EntNInt ?? ""}, ${data.domicilio.EntColonia}, ${data.domicilio.EntCP}, ${data.domicilio.EntMunicipio}, ${data.domicilio.EntEstado}`;

        document.getElementById("domicilioContainer").innerHTML = `
            <p class="fw-bold mb-1">Domicilio seleccionado:</p>
            <p class="text-muted small">${textoDom}</p>
        `;

        // ==============================
        // CARGAR TIPO ORDEN Y SI ES SIN IVA
        // ==============================
        selectTipoOrden.value = data.cabecera.TipoOrden;
        document.getElementById("chkSinIVA").checked = (data.cabecera.Siniva == 1);

        // Método de pago
        document.getElementById("selectMetodoPago").value = data.cabecera.TipoPago;

        // ==============================
        // CARGAR CARRITO
        // ==============================
        carrito = [];

        data.detalle.forEach(p => {
            carrito.push({
                id: p.IdProducto,
                nombre: p.proTitulo,
                sku: p.proSku,
                precio: parseFloat(p.proPrecioventa),
                img: p.proImagen,
                cantidad: parseInt(p.Cantidad)
            });
        });

        renderCarrito();

        bootstrap.Modal.getInstance(document.getElementById("modalOrdenesActivas")).hide();
    });
}

function flashSaveIndicator() {
    let el = document.createElement("div");
    el.innerHTML = "Guardado...";
    el.style.position = "fixed";
    el.style.bottom = "20px";
    el.style.right = "20px";
    el.style.background = "#dc3545";
    el.style.padding = "8px 14px";
    el.style.borderRadius = "6px";
    el.style.color = "white";
    el.style.zIndex = "9999";
    el.style.opacity = "0.95";

    document.body.appendChild(el);

    setTimeout(() => el.remove(), 1000);
}

function validarStockJS(producto) {

    // tipoOrden seleccionado en el POS
    const tipo = parseInt(selectTipoOrden.value);

    // Tipo 2 siempre permite negativos
    if (tipo === 2) {
        return true;
    }

    // Si no estamos validando stock aún → permitir todo
    const validarStock = window.VALIDAR_STOCK_POS ?? false;
    if (!validarStock) {
        return true;
    }

    // Validación real
    const existencia = Number(producto.proExistencia ?? 0);
    if (existencia <= 0) {
        Swal.fire({
            icon: "warning",
            title: "Sin existencia",
            text: "Este producto no tiene stock disponible.",
        });
        return false;
    }

    return true;
}

function actualizarCantidad(pos, nuevaCantidad) {

    const item = carrito[pos];
    const existencia = Number(item.proExistencia ?? 0);
    const tipo = parseInt(selectTipoOrden.value);
    const validarStock = window.VALIDAR_STOCK_POS ?? false;

    // Tipo 2 → permite siempre
    if (tipo !== 2 && validarStock) {
        if (nuevaCantidad > existencia) {
            Swal.fire({
                icon: "warning",
                title: "Cantidad no disponible",
                text: "No hay suficiente stock para esta cantidad.",
            });
            return;
        }
    }

    carrito[pos].cantidad = nuevaCantidad;
    renderCarrito();
    guardarTmp();
}


