// ========================================
//       LOADER XTINFIRE PRO CONTROLLER
// ========================================

window.dashboardLoading = false;
window.dashboardLoadedModules = 0;
window.dashboardTotalModules = 4;
window.dashboardStartTime = 0;

function dashboardShowLoader() {

    window.dashboardStartTime = Date.now();   // ⏱ Marca inicio

    const loader = document.getElementById("xtf-loader");
    if (loader) {
        loader.classList.remove("d-none");
        loader.style.opacity = 1;
    }

    // Frases dinámicas
    const frases = [
        "Procesando ventas…",
        "Actualizando gráficas…",
        "Calculando totales…",
        "Cargando desempeño del equipo…",
        "Optimizando dashboard…"
    ];

    let i = 0;
    const txt = document.getElementById("xtf-loading-text");

    window.xtfTextInterval = setInterval(() => {
        txt.innerText = frases[i];
        i = (i + 1) % frases.length;
    }, 1200);

    window.dashboardLoadedModules = 0;
    window.dashboardLoading = true;
}

function dashboardModuleLoaded() {

    window.dashboardLoadedModules++;

    // ¿Ya terminó todo?
    if (window.dashboardLoadedModules >= window.dashboardTotalModules) {

        const elapsed = Date.now() - window.dashboardStartTime;
        const minTime = 2000; // 2 segundos

        const remaining = Math.max(0, minTime - elapsed);

        setTimeout(() => {
            const loader = document.getElementById("xtf-loader");
            if (loader) {
                loader.style.opacity = 0;
                setTimeout(() => loader.classList.add("d-none"), 300);
            }

            clearInterval(window.xtfTextInterval);
            window.dashboardLoading = false;

        }, remaining);
    }
}
