// ===============================
//   CHART MANAGER GLOBAL
// ===============================
window.ChartManager = {
    charts: {},

    /**
     * Crea o reemplaza un Chart.js en un canvas
     * @param {string} idCanvas 
     * @param {object} config 
     */
    render(idCanvas, config) {
        const canvas = document.getElementById(idCanvas);

        if (!canvas) {
            console.error("❌ Canvas no encontrado:", idCanvas);
            return;
        }

        // Destruir si ya existe uno
        if (this.charts[idCanvas] instanceof Chart) {
            this.charts[idCanvas].destroy();
        }

        // Crear nuevo chart
        const ctx = canvas.getContext("2d");
        this.charts[idCanvas] = new Chart(ctx, config);
    },

    /**
     * Destruir un chart
     */
    destroy(idCanvas) {
        if (this.charts[idCanvas] instanceof Chart) {
            this.charts[idCanvas].destroy();
            delete this.charts[idCanvas];
        }
    }
};
