// =============================================
//   DASHBOARD — DONUT POR TIPO DE ORDEN
// =============================================

document.addEventListener("DOMContentLoaded", () => {
    loadDashboardDonut();
});

function loadDashboardDonut() {

    let formData = new FormData();
    formData.append("hook", "codi_hook");
    formData.append("action", "load");

    // Filtros globales
    if (window.dashboardFiltros) {
        formData.append("vendedor", window.dashboardFiltros.vendedor);
        formData.append("tipo", window.dashboardFiltros.tipo);
        formData.append("fechaInicio", window.dashboardFiltros.fechaInicio + " 00:00:00");
        formData.append("fechaFin", window.dashboardFiltros.fechaFin + " 23:59:59");
    }

    fetch("https://grupoxtinfire.com/admin/ajax/dashboard_donut_read", {
        method: "POST",
        body: formData
    })
    .then(r => r.json())
    .then(json => {

        const rows = json.data;

        if (!Array.isArray(rows)) {
            console.error("❌ Error: backend no regresó arreglo");
            return;
        }

        // Construir labels y values
        const labels = rows.map(r => getTipoNombre(r.TipoOrden));
        const values = rows.map(r => Number(r.TotalOrdenes));

        // Generar colores automáticos
        const colors = generateColors(values.length);

        console.log("DONUT LABELS:", labels);
        console.log("DONUT VALUES:", values);
        console.log("DONUT COLORS:", colors);

        renderDonutTipo(labels, values, colors);
    }).then(() => dashboardModuleLoaded())
    .catch(err => console.error("Error donut:", err));
}



function renderDonutTipo(labels, values, colors) {

    const canvas = document.getElementById("chartDonutTipo");
    if (!canvas) {
        console.error("❌ canvas chartDonutTipo no existe");
        return;
    }

    canvas.parentElement.style.height = "280px";

    ChartManager.render("chartDonutTipo", {
        type: "doughnut",
        data: {
            labels: labels,
            datasets: [{
                data: values,
                backgroundColor: colors,
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: "bottom",
                    labels: { usePointStyle: true }
                }
            }
        }
    });
}



// ======================================================
// MÉTODOS DE APOYO
// ======================================================

// Traducción TipoOrden → Texto
function getTipoNombre(tipo) {
    const mapa = {
        0: "Sin tipo",
        1: "Equipo Nuevo",
        2: "Recarga y Mantenimiento",
        3: "Capacitaciones",
        6: "PIPC",
        7: "Proyectos Especiales"
    };
    return mapa[tipo] || ("Tipo " + tipo);
}


// Genera colores dinámicos
function generateColors(n) {
    const colors = [];
    for (let i = 0; i < n; i++) {
        const hue = (i * 55) % 360;
        colors.push(`hsl(${hue}, 70%, 55%)`);
    }
    return colors;
}
