// =============================================
//   DASHBOARD — TENDENCIA MENSUAL (12 MESES)
// =============================================

document.addEventListener("DOMContentLoaded", () => {
    loadTendenciaMensual();
});

function loadTendenciaMensual() {

    let formData = new FormData();
    formData.append("hook", "codi_hook");
    formData.append("action", "load");

    // Filtros globales
    if (window.dashboardFiltros) {
        formData.append("vendedor", window.dashboardFiltros.vendedor);
        formData.append("tipo", window.dashboardFiltros.tipo);
        formData.append("fechaInicio", window.dashboardFiltros.fechaInicio + " 00:00:00");
        formData.append("fechaFin", window.dashboardFiltros.fechaFin + " 23:59:59");
    }

    fetch("https://grupoxtinfire.com/admin/ajax/dashboard_tendencia_read", {
        method: "POST",
        body: formData
    })
        .then(r => r.json())
        .then(json => {
            const rows = json.data;

            if (!Array.isArray(rows)) {
                console.error("❌ Tendencia Mensual: el backend no envió arreglo.", json);
                return;
            }

            console.log("RAW TENDENCIA:", rows);

            const labels = rows.map(r => formatearMes(r.Mes));
            const ordenes = rows.map(r => Number(r.TotalOrdenes));
            const dinero = rows.map(r => Number(r.TotalDinero));

            const datasets = [
                {
                    label: "Órdenes",
                    data: ordenes,
                    borderColor: "#dc3545",
                    backgroundColor: "rgba(220,53,69,0.3)",
                    tension: 0.3,
                    borderWidth: 2
                },
                {
                    label: "Dinero",
                    data: dinero,
                    borderColor: "#0d6efd",
                    backgroundColor: "rgba(13,110,253,0.3)",
                    tension: 0.3,
                    borderWidth: 2,
                    yAxisID: "y1"
                }
            ];

            renderTendenciaMensual(labels, datasets);
        }).then(() => dashboardModuleLoaded())
        .catch(err => console.error("Error tendencia:", err));
}


// ========================================================
//      DIBUJAR LA GRÁFICA DE TENDENCIA
// ========================================================

function renderTendenciaMensual(labels, datasets) {

    const canvas = document.getElementById("chartTendenciaMensual");
    if (!canvas) {
        console.error("❌ Canvas chartTendenciaMensual no existe");
        return;
    }

    // Corrección del height infinito
    canvas.parentElement.style.height = "350px";

    ChartManager.render("chartTendenciaMensual", {
        type: "line",
        data: {
            labels: labels,
            datasets: datasets
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            interaction: { mode: "index" },
            scales: {
                y: {
                    beginAtZero: true,
                    title: { text: "Órdenes", display: true }
                },
                y1: {
                    beginAtZero: true,
                    position: "right",
                    grid: { drawOnChartArea: false },
                    title: { text: "Dinero", display: true }
                }
            },
            plugins: {
                tooltip: { enabled: true },
                legend: { position: "top" }
            }
        }
    });
}



// ========================================================
//      FORMATEAR MES (2025-02 → feb 2025)
// ========================================================

function formatearMes(cadena) {
    const [anio, mes] = cadena.split("-");
    const meses = ["Ene","Feb","Mar","Abr","May","Jun","Jul","Ago","Sep","Oct","Nov","Dic"];
    return `${meses[Number(mes) - 1]} ${anio}`;
}
