// ============================================================
//           F I L T R O S    A V A N Z A D O S
// ============================================================

document.addEventListener("DOMContentLoaded", function () {

    cargarVendedoresFiltro();

    document.getElementById("filtroPeriodo").addEventListener("change", mostrarRangoCustom);

    document.getElementById("btnAplicarFiltros").addEventListener("click", function () {
        recargarDashboards();
    });
});

// --- Cargar vendedores en el select ---
function cargarVendedoresFiltro() {
    let formData = new FormData();
    formData.append("hook", "codi_hook");
    formData.append("action", "load");

    fetch("https://grupoxtinfire.com/admin/ajax/dashboard_get_vendedores_read", {
        method: "POST",
        body: formData
    })
        .then(r => r.json())
        .then(json => {
            const data = json.data || json.rows || json;
            const sel = document.getElementById("filtroVendedor");

            data.forEach(v => {
                sel.innerHTML += `<option value="${v.IdUsuario}">${v.Usuario}</option>`;
            });
        });
}

// --- Mostrar campos de fecha si elige rango personalizado ---
function mostrarRangoCustom() {
    const periodo = document.getElementById("filtroPeriodo").value;
    const divInicio = document.getElementById("divInicio");
    const divFin = document.getElementById("divFin");

    if (periodo === "custom") {
        divInicio.classList.remove("d-none");
        divFin.classList.remove("d-none");
    } else {
        divInicio.classList.add("d-none");
        divFin.classList.add("d-none");
    }
}

// --- Obtener las fechas finales según el periodo seleccionado ---
function obtenerFechasPorPeriodo() {
    const periodo = document.getElementById("filtroPeriodo").value;
    const hoy = new Date();

    let inicio, fin,texto;

    switch (periodo) {
        case "3m":
            texto = "Últimos 3 meses";
            inicio = new Date(hoy.getFullYear(), hoy.getMonth() - 2, 1);
            break;
        case "6m":
            texto = "Últimos 6 meses";
            inicio = new Date(hoy.getFullYear(), hoy.getMonth() - 5, 1);
            break;
        case "12m":
            texto = "Últimos 12 meses";
            inicio = new Date(hoy.getFullYear(), hoy.getMonth() - 11, 1);
            break;
        case "ytd":
            texto = "Año actual";
            inicio = new Date(hoy.getFullYear(), 0, 1);
            break;
        case "trimestre":
            texto = "Trimestral";
            const trimestre = Math.floor(hoy.getMonth() / 3);
            inicio = new Date(hoy.getFullYear(), trimestre * 3, 1);
            break;
        case "custom":
            
            inicio = new Date(document.getElementById("filtroFechaInicio").value);
            fin = new Date(document.getElementById("filtroFechaFin").value);
            texto = inicio + " " + fin;
            break;
    }

    if (!fin) fin = hoy;

    return {
        fechaInicio: inicio.toISOString().split("T")[0],
        fechaFin: fin.toISOString().split("T")[0],
        texto : texto
    };
}

// --- Recargar TODOS los dashboards ---
function recargarDashboards() {
    dashboardShowLoader(); // <- 🔥 Mostrar loader al iniciar
    const filtroVendedor = document.getElementById("filtroVendedor").value;
    const filtroTipo = document.getElementById("filtroTipo").value;
    const fechas = obtenerFechasPorPeriodo();

    // Enviar filtros globales
    window.dashboardFiltros = {
        vendedor: filtroVendedor,
        tipo: filtroTipo,
        fechaInicio: fechas.fechaInicio,
        fechaFin: fechas.fechaFin
    };
    $(".textper").text(fechas.texto);
    // Recargar módulos
    loadTendenciaMensual();   // Módulo A
    loadDashboardDonut();     // Módulo B
    loadStackedChart();       // Módulo C
    loadRankingVendedores();  // Módulo D
}
