/* ADD-ON: Modal de Cierre de Caja (no rompe tu JS existente)
   - Pégalo al final de tu archivo actual.
   - Llama window.openModalCierreCaja() desde tu botón "Cierre".
*/
(() => {
  const API_BASE = 'https://grupoxtinfire.com/admin/ajax/';
  const HOOK = 'codi_hook';
  const ACTION = 'load';

  const $ = (sel, ctx=document) => ctx.querySelector(sel);
  const fmtMoney = n => (Number(n)||0).toLocaleString('es-MX',{style:'currency',currency:'MXN'});
  const parseNum = v => {
    if (typeof v === 'number') return v;
    const s = String(v||'').trim().replace(/\s+/g,'');
    if (/^\d{1,3}(\.\d{3})*,\d{1,2}$/.test(s)) return parseFloat(s.replace(/\./g,'').replace(',','.'))||0;
    return parseFloat(s.replace(/,/g,''))||0;
  };
  const isEfectivo = (tipo) => {
    const t = (tipo||'').toString().toLowerCase();
    return t.startsWith('efect') || t.includes('efectivo') || t === '01' || t.includes('(01)');
  };

  const apiPost = async (fnName, params={}) => {
    const body = new URLSearchParams({hook:HOOK, action:ACTION, ...params});
    const res = await fetch(API_BASE + fnName, { method:'POST', headers:{'Content-Type':'application/x-www-form-urlencoded;charset=UTF-8'}, body });
    const json = await res.json().catch(()=>({status:400,error:true,msg:'JSON inválido'}));
    if (!res.ok || !json || json.status !== 200 || json.error) {
      throw new Error(json?.data || json?.msg || ('HTTP '+res.status+' @'+fnName));
    }
    return json.data || [];
  };

  // Crea el modal sólo si no existe
  function ensureModalCierre() {
    let modal = $('#modal-cierre-caja');
    if (!modal) {
      const tpl = document.createElement('div');
      tpl.innerHTML = `
      <div class="modal fade" id="modal-cierre-caja" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-xl modal-dialog-scrollable">
          <div class="modal-content">
            <div class="modal-header">
              <h5 class="modal-title">Cierre de caja</h5>
              <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
            </div>
            <div class="modal-body" id="modal-cierre-caja-body">Cargando…</div>
            <div class="modal-footer">
              <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancelar</button>
              <button type="button" id="btnSolicitarCierre" class="btn btn-danger">Solicitar cierre</button>
            </div>
          </div>
        </div>
      </div>`;
      document.body.appendChild(tpl.firstElementChild);
      modal = $('#modal-cierre-caja');
    }
    return modal;
  }

  async function fetchSesionActual() {
    const IdUsuario = $('#Idusu')?.value || $('#Idusuario')?.value || '';
    const Departamento = $('#depparanoti')?.value || '';
    if (!IdUsuario || !Departamento) throw new Error('Faltan IdUsuario o Departamento');
    const ses = await apiPost('caja_session_today', { IdUsuario, Departamento });
    const row = Array.isArray(ses) ? ses[0] : ses;
    if (!row || !row.idSesion) throw new Error('No hay sesión de caja abierta hoy.');
    return { idSesion: row.idSesion, saldo_inicial: Number(row.saldo_inicial||0) };
  }

  function rangoHoy() {
    const now = new Date();
    const ini = new Date(now.getFullYear(), now.getMonth(), now.getDate(), 0,0,0);
    const fin = new Date(now.getFullYear(), now.getMonth(), now.getDate()+1, 0,0,0);
    const fmt = d => `${d.getFullYear()}-${String(d.getMonth()+1).padStart(2,'0')}-${String(d.getDate()).padStart(2,'0')} ${String(d.getHours()).padStart(2,'0')}:${String(d.getMinutes()).padStart(2,'0')}:${String(d.getSeconds()).padStart(2,'0')}`;
    return { ini: fmt(ini), fin: fmt(fin) };
  }

  async function openModalCierreCaja() {
    const modalEl = ensureModalCierre();
    const body = $('#modal-cierre-caja-body');
    const btn = $('#btnSolicitarCierre');

    try {
      body.innerHTML = 'Cargando…';

      // Sesión + rango de hoy
      const ses = window.CAJA_SESION || await fetchSesionActual();
      window.CAJA_SESION = ses;
      const { ini, fin } = rangoHoy();

      const IdUsuario = $('#Idusu')?.value || $('#Idusuario')?.value || '';
      if (!IdUsuario) throw new Error('Falta IdUsuario');

      // Resumen que SÍ cuenta a caja (y categorías informativas que llegan del endpoint)
      const resumen = await apiPost('caja_resumen_pagos_hoy', { IdUsuario, ini, fin });

      // UI: saldo inicial
      const head = document.createElement('div');
      head.className = 'alert alert-light d-flex justify-content-between align-items-center';
      head.innerHTML = `
        <div>
          <div class="small text-muted">Saldo inicial (Efectivo)</div>
          <div class="fw-bold fs-5">${fmtMoney(ses.saldo_inicial||0)}</div>
        </div>
        <div class="small text-muted text-end">
          En <b>Efectivo</b>, el <b>Esperado</b> = Ventas netas ± Movs. manuales + Saldo inicial.
        </div>`;

      // Tabla de conteo (solo categoría CAJA)
      const caja = (resumen||[]).filter(r => (r.categoria||'').toUpperCase()==='CAJA');
      const card = document.createElement('div');
      card.className = 'card';
      const cardBody = document.createElement('div');
      cardBody.className = 'card-body';
      const title = document.createElement('h6');
      title.className = 'mb-3'; title.textContent = 'Resumen por forma de pago — Conteo para cierre';
      const table = document.createElement('table');
      table.className = 'table align-middle';
      table.innerHTML = `
        <thead>
          <tr>
            <th>Forma de pago</th>
            <th class="text-end">Esperado</th>
            <th class="text-end">Contado</th>
            <th class="text-end">Diferencia</th>
          </tr>
        </thead>
        <tbody></tbody>`;
      const tbody = table.querySelector('tbody');

      const inputs = new Map();
      caja.forEach(r => {
        const tipo = r.tipo_pago || 'SinTipodePago';
        const baseEsperado = Number(r.total_caja_hoy || 0); // viene del backend
        const esperado = isEfectivo(tipo) ? (baseEsperado + (ses.saldo_inicial||0)) : baseEsperado;

        const tr = document.createElement('tr');
        const tdTipo = document.createElement('td'); tdTipo.textContent = isEfectivo(tipo) ? `${tipo} (incluye saldo inicial)` : tipo;
        const tdEsp  = document.createElement('td'); tdEsp.className='text-end fw-semibold'; tdEsp.textContent = fmtMoney(esperado);
        const tdInp  = document.createElement('td'); tdInp.className='text-end';
        const inp = document.createElement('input');
        inp.type='number'; inp.step='0.01'; inp.min='0'; inp.className='form-control form-control-sm text-end'; inp.placeholder='0.00';
        tdInp.appendChild(inp);
        const tdDif  = document.createElement('td'); tdDif.className='text-end fw-semibold'; tdDif.textContent = fmtMoney(0);

        tr.append(tdTipo, tdEsp, tdInp, tdDif);
        tbody.appendChild(tr);

        inputs.set(tipo, { inp, esperado, tdDif, get contado(){ return parseNum(inp.value); } });
      });

      const totals = document.createElement('div');
      totals.className = 'd-flex justify-content-end gap-4 mt-3';
      const t1 = document.createElement('div'); const t2 = document.createElement('div'); const t3 = document.createElement('div');
      t1.innerHTML = `<div class="small text-muted">Esperado</div><div id="sumEsperado"></div>`;
      t2.innerHTML = `<div class="small text-muted">Contado</div><div id="sumContado"></div>`;
      t3.innerHTML = `<div class="small text-muted">Diferencia</div><div id="sumDiff" class="fw-bold"></div>`;
      totals.append(t1,t2,t3);

      const recompute = () => {
        let sumE=0, sumC=0;
        inputs.forEach(({ esperado, contado, tdDif }) => {
          const diff = contado - esperado;
          tdDif.textContent = fmtMoney(diff);
          tdDif.classList.toggle('text-danger', diff<0);
          tdDif.classList.toggle('text-success', diff>0);
          sumE += esperado; sumC += contado;
        });
        $('#sumEsperado').textContent = fmtMoney(sumE);
        $('#sumContado').textContent  = fmtMoney(sumC);
        const d = sumC - sumE;
        const el = $('#sumDiff'); el.textContent = fmtMoney(d);
        el.className = 'fw-bold ' + (d===0?'text-success':'text-danger');
        return { sumE, sumC, diff:d };
      };
      inputs.forEach(({inp})=> inp.addEventListener('input',recompute));
      // Montaje
      cardBody.append(title, table, totals);
      card.appendChild(cardBody);

      // Bloques informativos (Pago Parcial / Crédito), opcional mostrar
      const infoWrap = document.createElement('div');
      const parciales = (resumen||[]).filter(r => (r.categoria||'').toUpperCase()==='PARCIAL');
      const credito   = (resumen||[]).filter(r => (r.categoria||'').toUpperCase()==='CREDITO');
      if (parciales.length || credito.length) {
        infoWrap.className = 'mt-3';
        if (parciales.length) {
          const b = document.createElement('div'); b.className='alert alert-warning';
          const totalParc = parciales.reduce((a,b)=>a+Number(b.total_pagadas||0),0);
          b.innerHTML = `<b>Pago Parcial (informativo):</b> ${fmtMoney(totalParc)}`;
          infoWrap.appendChild(b);
        }
        if (credito.length) {
          const b = document.createElement('div'); b.className='alert alert-info';
          const totalCred = credito.reduce((a,b)=>a+Number(b.total_pagadas||0),0);
          b.innerHTML = `<b>Crédito (informativo):</b> ${fmtMoney(totalCred)}`;
          infoWrap.appendChild(b);
        }
      }

      body.innerHTML = '';
      body.appendChild(head);
      body.appendChild(card);
      if (infoWrap.childElementCount) body.appendChild(infoWrap);
      recompute();

      btn.onclick = async () => {
        try {
          const { sumE, sumC, diff } = recompute();
          const detalle = [];
          inputs.forEach((o, tipo) => {
            detalle.push({
              tipo_pago: tipo,
              esperado: Number(o.esperado.toFixed(2)),
              contado:  Number(o.contado.toFixed(2)),
              diferencia: Number((o.contado - o.esperado).toFixed(2))
            });
          });
          const resumen_json = JSON.stringify({
            saldo_inicial: Number((ses.saldo_inicial||0).toFixed(2)),
            total_esperado: Number(sumE.toFixed(2)),
            total_contado:  Number(sumC.toFixed(2)),
            diferencia:     Number(diff.toFixed(2)),
            detalle
          });
          await apiPost('caja_solicitar_cierre', {
            idSesion: ses.idSesion,
            IdUsuario,
            resumen_json
          });
          body.innerHTML = `<div class="alert alert-success">Solicitud de cierre enviada para aprobación del supervisor.</div>`;
          setTimeout(()=> bootstrap.Modal.getInstance(modalEl)?.hide(), 1200);
        } catch (e) {
          alert('No se pudo solicitar el cierre: ' + e.message);
        }
      };

      new bootstrap.Modal(modalEl).show();
    } catch (e) {
      body.innerHTML = `<div class="alert alert-danger">Error: ${e.message}</div>`;
      new bootstrap.Modal(ensureModalCierre()).show();
    }
  }

  // Expón la función sin romper si ya existe
  if (!window.openModalCierreCaja) {
    window.openModalCierreCaja = openModalCierreCaja;
  } else {
    // Si ya existía, la re-asigno a la nueva versión para incluir el saldo inicial correcto
    window.openModalCierreCaja = openModalCierreCaja;
  }
})();
