
function codi_get_productos(NioApp) {
    var wrapper = $('.tabla_wrapper_almacenes'),
        hook = 'codi_hook',
        action = 'load';
    console.log('reaad')

    // AJAX Productos Get
    $.ajax({
        url: 'ajax/codi_get_almacenes',
        type: 'POST',
        dataType: 'json',
        cache: false,
        data: { hook, action },
        beforeSend: function () {
            // wrapper.waitMe();
        }
    }).done(function (res) {
        if (res.status === 200) {
            wrapper.html(res.data);
            $('.datatable-init').DataTable({
                responsive: true,
                orderCellsTop: true,
                fixedHeader: true,
                dom: 'Blfrtip',
                buttons: ['copy', 'excel', 'csv', 'pdf'],
                language: {
                    url: 'https://cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json'
                },
                "bDestroy": true
            });

        } else {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion',
                showConfirmButton: false,
                timer: 1500
            })
            wrapper.html('');

        }
    })
        .fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion'.err,
                showConfirmButton: false,
                timer: 1500
            })
            wrapper.html('');
        })
        .always(function () {
            // wrapper.waitMe('hide');
        });

}

function codi_add_almacen(event) {
    console.log('r')
    event.preventDefault();
    var form = $('.codi_add_almacen'),
        hook = 'codi_hook',
        action = 'add',


        data = new FormData(form.get(0)),
        almNombre = $('#almNombre').val(),
        almEstatus = $('#almEstatus').val();

    data.append('hook', hook);
    data.append('action', action);

    // AJAX Productos
    $.ajax({
        url: 'ajax/codi_add_almacen',
        type: 'POST',
        dataType: 'json',
        contentType: false,
        processData: false,
        cache: false,
        data: data,
        beforeSend: function () {
            // form.waitMe();
        }
    }).done(function (res) {
        if (res.status === 201) {
            Swal.fire({
                icon: 'success',
                title: res.msg,
                showConfirmButton: false,
                timer: 1500
            })
            form.trigger('reset');
            window.location.href = "";

        } else {
            Swal.fire({
                icon: 'error',
                title: res.msg,
                showConfirmButton: false,
                timer: 1500
            })
        }
    })
        .fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion'.err,
                showConfirmButton: false,
                timer: 1500
            })
        })
        .always(function () {
            // form.waitMe('hide');
        });


}
function codi_update_almacen(event) {
    event.preventDefault();

    var form = $('.codi_update_almacen'),
        hook = 'codi_hook',
        action = 'update',
        data = new FormData(form.get(0));
    data.append('hook', hook);
    data.append('action', action);
    /*for (var pair of data.entries()) {
        console.log(pair[0]+ ', ' + pair[1]); 
    }*/
    // AJAX Almacen
    $.ajax({
        url: 'ajax/codi_update_almacen',
        type: 'POST',
        dataType: 'json',
        contentType: false,
        processData: false,
        cache: false,
        data: data,
        beforeSend: function () {
            // form.waitMe();
        }
    }).done(function (res) {
        if (res.status === 200) {
            Swal.fire({
                icon: 'success',
                title: res.msg,
                showConfirmButton: false,
                timer: 1500
            })
            form.trigger('reset');
            location.reload()
        } else {
            Swal.fire({
                icon: 'error',
                title: res.msg,
                showConfirmButton: false,
                timer: 1500
            })
        }
    })
        .fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion'.err,
                showConfirmButton: false,
                timer: 1500
            })
        })
        .always(function () {
            // form.waitMe('hide');
        });

}

function codi_get_almacen_select() {
    var wrapper = $('.select_wrapper_almacen'),
        hook = 'codi_hook',
        action = 'load';
    const w = document.querySelectorAll('.select_wrapper_almacen');
    // AJAX Usuarios Get
    $.ajax({
        url: 'ajax/codi_get_almacenes_select',
        type: 'POST',
        dataType: 'json',
        cache: false,
        data: { hook, action },
        beforeSend: function () {

        }
    }).done(function (res) {
        if (res.status === 200) {
            w.forEach(element => {
                element.innerHTML = res.data
            });
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion',
                showConfirmButton: false,
                timer: 6500
            })
            wrapper.html('');

        }
    })
        .fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion' + err,
                showConfirmButton: false,
                timer: 6500
            })
            wrapper.html('');
        })
        .always(function () {

        });

}
function codi_delete_almacen(event) {
    event.preventDefault();
    var almid = $('#almid').val()
    var EalmNombre = $('#EalmNombre').val()
    var totalPro = $('#totalPro').val()
    var proAlmacen = $('#proAlmacen').val()
    console.log(proAlmacen)

    if (totalPro != "0" && proAlmacen == almid) {
        Swal.fire({
            icon: 'error',
            title: 'Seleccione un almacén distinto al que se va a eliminar.',
            showConfirmButton: false,
            timer: 5500
        })
    } else if (totalPro != "0" && (proAlmacen == "" || proAlmacen == undefined)) {
        Swal.fire({
            icon: 'error',
            title: 'Seleccione un almacén para transferir los productos.',
            showConfirmButton: false,
            timer: 5500
        })
    } else {
        var form = $('.codi_delete_almacen'),
            hook = 'codi_hook',
            action = 'update',
            data = new FormData();
        data.append('hook', hook);
        data.append('action', action);
        data.append('EalmNombre', EalmNombre);
        data.append('almid', almid)
        data.append('totalPro', totalPro)
        data.append('proAlmacen', proAlmacen)
        // AJAX Almacen
        $.ajax({
            url: 'ajax/codi_delete_almacen',
            type: 'POST',
            dataType: 'json',
            contentType: false,
            processData: false,
            cache: false,
            data: data,
            beforeSend: function () {
                // form.waitMe();
            }
        }).done(function (res) {
            if (res.status === 201) {
                Swal.fire({
                    icon: 'success',
                    title: res.msg,
                    showConfirmButton: false,
                    timer: 1500
                })
                form.trigger('reset');
                window.location.reload()
            } else {
                Swal.fire({
                    icon: 'error',
                    title: res.msg,
                    showConfirmButton: false,
                    timer: 1500
                })
            }
        })
            .fail(function (err) {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion'.err,
                    showConfirmButton: false,
                    timer: 1500
                })
            })
            .always(function () {
                // form.waitMe('hide');
            });
    }
}

function eliminaralm() {
    var totalProductos = $('#totalPro').val()

    //Mostrarlos cuando se seleccione orden 
    /*

    $('#traspPro').hide();
    $('#eliminarB').hide();
    if (totalProductos != "0") {
        $('#traspPro').show();
        $('#eliminarB').hide();
    } else {
        $('#eliminarB').show();
        $('#traspPro').hide();
    }
    */
}

function validar_nalmacen() {
    var proAlmacen = $('#proAlmacen').val();
    var almid = $('#almid').val();
    if (proAlmacen == almid) {
        Swal.fire({
            icon: 'error',
            title: 'Seleccione un almacén distinto al que se va a eliminar.',
            showConfirmButton: false,
            timer: 6500
        })
        return;
    }
}

$(document).ready(function () {
    eliminaralm();
    codi_get_almacen_select();
    codi_get_productos(NioApp);

    $('.codi_add_almacen').on('submit', codi_add_almacen);
    //Obtener Moviemientos

    $('#editForm').on('show.bs.modal', function (event) {
        var button = $(event.relatedTarget) // Button that triggered the modal
        var id = button.data('id');

        var nombre = button.data('nombre');
        var categoria = button.data('categoria');

        // If necessary, you could initiate an AJAX request here (and then do the updating in a callback).
        // Update the modal's content. We'll use jQuery here, but you could use a data binding library or other methods instead.
        var modal = $(this)
        modal.find('#id').val(id)
        modal.find('#nombre').val(nombre)
        modal.find('#categoria').val(categoria)
    })

    $('#modalAlert2').on('show.bs.modal', function (event) {
        var button = $(event.relatedTarget) // Button that triggered the modal
        var id = button.data('id');
        var an = button.data('almnombre');
        var tp = button.data('almprod');
        // If necessary, you could initiate an AJAX request here (and then do the updating in a callback).
        // Update the modal's content. We'll use jQuery here, but you could use a data binding library or other methods instead.
        var modal = $(this)
        modal.find('#almid').val(id)
        modal.find('#EalmNombre').text(an)
        modal.find('#totalPro').val(tp)

        if (tp != "0") {
            $('#eliminarB').hide();
            $('#advertencia1').hide();
            $('#traspPro').show();
            $('#advertencia2').show();
        } else {
            $('#eliminarB').show();
            $('#advertencia1').show();
            $('#traspPro').hide();
            $('#advertencia2').hide();
        }
    })

    $('.codi_update_almacen').on('submit', codi_update_almacen);
    $('.codi_delete_almacen').on('click', codi_delete_almacen);
})