var apibase = "https://grupoxtinfire.com/admin/";

//Agregar user
$('.codi_add_cliente').on('submit', codi_add_cliente);
function codi_add_cliente(event) {
    //event.preventDefault();

    var form = $('.codi_add_cliente'),
        hook = 'codi_hook',
        action = 'add',
        data = new FormData(form.get(0)),
        //Datos generales
        Nombre = $('#CNombre').val(),
        RFC = $('#CRFC').val(),
        FisTelefono = $('#CFisTelefono').val(),
        FisEmail = $('#CFisEmail').val(),
        //Domicilio Fiscal
        FisCalle = $('#CFisCalle').val(),
        FisNExt = $('#CFisNExt').val(),
        FisNInt = $('#CFisNInt').val(),
        FisColonia = $('#CFisColonia').val(),
        FisCP = $('#CFisCP').val(),
        FisMunicipio = $('#CFisMunicipio').val(),
        FisEstado = $('#CFisEstado').val(),
        //Domicilio Entrega
        EntCalle = $('#CEntCalle').val(),
        EntNExt = $('#CEntNExt').val(),
        EntNInt = $('#CEntNInt').val(),
        EntColonia = $('#CEntColonia').val(),
        EntCP = $('#CEntCP').val(),
        EntMunicipio = $('#CEntMunicipio').val(),
        EntEstado = $('#CEntEstado').val(),
        EntGiro = $('#CEntGiro').val(),
        EntDesde = $('#CEntDesde').val(),
        EntHasta = $('#CEntHasta').val(),
        EntCruces = $('#CEntCruces').val(),
        EntObservaciones = $('#CEntObservaciones').val()
    data.append('hook', hook);
    data.append('action', action);

    //validar que este seleccionado una opcion Usuario
    if (Nombre === '' || FisEmail === '') {
        Swal.fire({
            icon: 'error',
            title: 'El nombre del cliente y el email no pueden estar vacio',
            showConfirmButton: false,
            timer: 5500
        })

        return
    }

    // AJAX Usuarios
    $.ajax({
        url: 'ajax/codi_add_cliente',
        type: 'POST',
        dataType: 'json',
        contentType: false,
        processData: false,
        cache: false,
        data: data,
        beforeSend: function () {
            // form.waitMe();
        }
    }).done(function (res) {
        if (res.status === 201) {
            Swal.fire({
                icon: 'success',
                title: res.msg,
                showConfirmButton: false,
                timer: 5500
            })
            form.trigger('reset');
            window.location.href = "";

        } else {
            Swal.fire({
                icon: 'error',
                title: res.msg,
                showConfirmButton: false,
                timer: 5500
            })
        }
    })
        .fail(function (err) {
            console.log(err)
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion',
                showConfirmButton: false,
                timer: 5500
            })
        })
        .always(function () {
            // form.waitMe('hide');
        });
}

$('#modalAlert2').on('show.bs.modal', function (event) {
    var button = $(event.relatedTarget) // Button that triggered the modal
    var id = button.data('idclte');
    var nom = button.data('nombre');
    // If necessary, you could initiate an AJAX request here (and then do the updating in a callback).
    // Update the modal's content. We'll use jQuery here, but you could use a data binding library or other methods instead.
    var modal = $(this)
    modal.find('#idCliente').val(id)
    modal.find('#ENombre').text(nom)
})

function copiar_domicilio() {
    var CFisCalle = $('#CFisCalle').val();
    var CFisNExt = $('#CFisNExt').val();
    var CFisNInt = $('#CFisNInt').val();
    var CFisColonia = $('#CFisColonia').val();
    var CFisCP = $('#CFisCP').val();
    var CFisMunicipio = $('#CFisMunicipio').val();
    var CFisEstado = $('#CFisEstado').val();

    $('#CEntCalle').val(CFisCalle)
    $('#CEntNExt').val(CFisNExt)
    $('#CEntNInt').val(CFisNInt)
    $('#CEntColonia').val(CFisColonia)
    $('#CEntCP').val(CFisCP)
    $('#CEntMunicipio').val(CFisMunicipio)
    $('#CEntEstado').val(CFisEstado)
}

//Edita cliente
function codi_update_cliente(event) {
    //event.preventDefault();
    var form = $('.codi_update_cliente'),
        hook = 'codi_hook',
        action = 'update',
        data = new FormData(form.get(0));
    console.log(data)

    data.append('hook', hook);
    data.append('action', action);
    /*for (var pair of data.entries()) {
        console.log(pair[0]+ ', ' + pair[1]); 
    }*/

    // AJAX Usuarios
    $.ajax({
        url: 'ajax/codi_update_cliente',
        type: 'POST',
        dataType: 'json',
        contentType: false,
        processData: false,
        cache: false,
        data: data,
        beforeSend: function () {
            // form.waitMe();
        }
    }).done(function (res) {
        if (res.status === 200) {
            Swal.fire({
                icon: 'success',
                title: res.msg,
                showConfirmButton: false,
                timer: 5500
            })
            form.trigger('reset');
            window.location.href = "";

        } else {
            Swal.fire({
                icon: 'error',
                title: res.msg,
                showConfirmButton: false,
                timer: 5500
            })
        }
    })
        .fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion'.err,
                showConfirmButton: false,
                timer: 5500
            })
        })
        .always(function () {
            // form.waitMe('hide');
        });
}

function codi_get_usocfdi(persona) {
    var wrapper = $('.select_wrapper_usocfdi'),
        hook = 'codi_hook',
        action = 'load';

    // AJAX Usuarios Get
    $.ajax({
        url: apibase + 'ajax/codi_get_usocfdi',
        type: 'POST',
        dataType: 'json',
        cache: false,
        data: { hook, action, persona },
        beforeSend: function () {

        }
    }).done(function (res) {
        if (res.status === 200) {
            wrapper.html(res.data);
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion',
                showConfirmButton: false,
                timer: 5500
            })
            wrapper.html('');

        }
    })
        .fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion' + err,
                showConfirmButton: false,
                timer: 5500
            })
            wrapper.html('');
        })
        .always(function () {

        });

}

function codi_get_regimenfiscal(persona) {
    var wrapper = $('.select_wrapper_regimenfiscal'),
        hook = 'codi_hook',
        action = 'load';

    // AJAX Usuarios Get
    $.ajax({
        url: apibase + 'ajax/codi_get_regimenfiscal',
        type: 'POST',
        dataType: 'json',
        cache: false,
        data: { hook, action, persona },
        beforeSend: function () {

        }
    }).done(function (res) {
        if (res.status === 200) {
            wrapper.html(res.data);
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion',
                showConfirmButton: false,
                timer: 5500
            })
            wrapper.html('');

        }
    })
        .fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion' + err,
                showConfirmButton: false,
                timer: 5500
            })
            wrapper.html('');
        })
        .always(function () {

        });

}

function cargarcat(persona) {
    console.log(persona)
    codi_get_usocfdi(persona);
    codi_get_regimenfiscal(persona);
}

$(document).ready(function () {

    codi_get_usocfdi('fisica');
    codi_get_regimenfiscal('fisica');

    //Obtener Moviemientos
    codi_get_clientes2();
    function codi_get_clientes() {
        var wrapper = $('.tabla_wrapper_clientes'),
            hook = 'codi_hook',
            action = 'load';


        // AJAX Usuarios Get
        $.ajax({
            url: 'ajax/codi_get_clientes',
            type: 'POST',
            dataType: 'json',
            cache: false,
            data: { hook, action },
            beforeSend: function () {

            }
        }).done(function (res) {
            if (res.status === 200) {
                wrapper.html(res.data);
                $('.datatable-init').DataTable({
                    responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    dom: 'Blfrtip',
                    buttons: ['copy', 'excel', 'csv', 'pdf'],
                    language: {
                        url: 'https://cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json'
                    }
                });

            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion',
                    showConfirmButton: false,
                    timer: 5500
                })
                wrapper.html('');

            }
        })
            .fail(function (err) {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion' + err,
                    showConfirmButton: false,
                    timer: 5500
                })
                wrapper.html('');
            })
            .always(function () {

            });

    }

    function codi_get_clientes2() {

        var wrapper = $('.tabla_wrapper_clientes'),
            hook = 'codi_hook',
            action = 'load';

            var table = $('.datatable-init').DataTable({
                "searching" : true,
                "processing": true,
                "serverSide": true,
                "responsive": true,
                "dom": 'Blfrtip',
        "orderCellsTop": true,
        "fixedHeader": true,
        language: {
          url: 'https://cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json'
        },
                columns: [
                    { data: "IdCliente" },
                    { data: "Nombre" },
                    { data: "RFC" },
                    { data: "FisEmail" },
                    { data: "FisTelefono" },
                    { data: "FisMunicipio" },
                    { data: "Acción", bSortable:false,"mRender": function(data, type, value) {
            return `<ul class="nk-tb-actions gx-1 my-n1 text-center">
                    <li class="me-n1 text-center">
                        <div class="dropdown">
                            <a href="#" class="dropdown-toggle btn btn-icon btn-trigger" data-bs-toggle="dropdown"><em class="icon ni ni-more-h"></em></a>
                            <div class="dropdown-menu dropdown-menu-end">
                                <ul class="link-list-opt no-bdr">
                                    <li><a href="#" data-bs-toggle="modal" data-bs-target="#editForm" data-idcliente="${value["IdCliente"]}" data-clave="${value["Clave"]}" data-persona="${value["Persona"]}" data-cfdi="${value["CFDI"]}" data-regimenfiscal="${value["RegimenFiscal"]}" data-tipopago="${value["TipoPago"]}" data-nombre="${value["Nombre"]}" data-rfc="${value["RFC"]}" data-fistelefono="${value["FisTelefono"]}" data-fisemail="${value["FisEmail"]}" data-fiscalle="${value["FisCalle"]}" data-fisnext="${value["FisNExt"]}" data-fisnint="${value["FisNInt"]}" data-fiscolonia="${value["FisColonia"]}" data-fiscp="${value["FisCP"]}" data-fismunicipio="${value["FisMunicipio"]}" data-fisestado="${value["FisEstado"]}" data-iddomicilio="${value["IdDomicilio"]}" data-entcalle="${value["EntCalle"]}" data-entnext="${value["EntNExt"]}" data-entnint="${value["EntNInt"]}" data-entcolonia="${value["EntColonia"]}" data-entcp="${value["EntCP"]}" data-entmunicipio="${value["EntMunicipio"]}" data-entestado="${value["EntEstado"]}" data-entgiro="${value["Descripcion"]}" data-entdesde="${value["EntDesde"]}" data-enthasta="${value["EntHasta"]}" data-entcruces="${value["EntCruces"]}" data-entobservaciones="${value["EntObservaciones"]}"><em class="icon ni ni-edit"></em><span>Editar Cliente</span></a></li>
                                    <!--<li><a href="#"><em class="icon ni ni-eye"></em><span>Ver Cliente</span></a></li>-->
                                    <li><a href="#" data-bs-toggle="modal" data-bs-target="#modalAlert2" data-idclte="${value["IdCliente"]}" data-nombre="${value["Nombre"]}"><em class="icon ni ni-trash"></em><span>Eliminar Cliente</span></a></li>
                                </ul>
                            </div>
                        </div>
                    </li>
                </ul>`;
        } }
                    ],
                "columnDefs": [{
            "targets": [6],
            "data": null,
            "defaultContent":
             `<ul class="nk-tb-actions gx-1 my-n1 text-center">
                    <li class="me-n1 text-center">
                        <div class="dropdown">
                            <a href="#" class="dropdown-toggle btn btn-icon btn-trigger" data-bs-toggle="dropdown"><em class="icon ni ni-more-h"></em></a>
                            <div class="dropdown-menu dropdown-menu-end">
                                <ul class="link-list-opt no-bdr">
                                    <li><a href="#" data-bs-toggle="modal" data-bs-target="#editForm" data-idcliente="<?php echo $clte->IdCliente; ?>" data-clave="<?php echo $clte->Clave; ?>" data-persona="<?php echo $clte->Persona; ?>" data-cfdi="<?php echo $clte->CFDI; ?>" data-regimenfiscal="<?php echo $clte->RegimenFiscal; ?>" data-tipopago="<?php echo $clte->TipoPago; ?>" data-nombre="<?php echo $clte->Nombre; ?>" data-rfc="<?php echo $clte->RFC; ?>" data-fistelefono="<?php echo $clte->FisTelefono; ?>" data-fisemail="<?php echo $clte->FisEmail; ?>" data-fiscalle="<?php echo $clte->FisCalle; ?>" data-fisnext="<?php echo $clte->FisNExt; ?>" data-fisnint="<?php echo $clte->FisNInt; ?>" data-fiscolonia="<?php echo $clte->FisColonia; ?>" data-fiscp="<?php echo $clte->FisCP; ?>" data-fismunicipio="<?php echo $clte->FisMunicipio; ?>" data-fisestado="<?php echo $clte->FisEstado; ?>" data-iddomicilio="<?php echo $clte->IdDomicilio; ?>" data-entcalle="<?php echo $clte->EntCalle; ?>" data-entnext="<?php echo $clte->EntNExt; ?>" data-entnint="<?php echo $clte->EntNInt; ?>" data-entcolonia="<?php echo $clte->EntColonia; ?>" data-entcp="<?php echo $clte->EntCP; ?>" data-entmunicipio="<?php echo $clte->EntMunicipio; ?>" data-entestado="<?php echo $clte->EntEstado; ?>" data-entgiro="<?php echo $clte->EntGiro; ?>" data-entdesde="<?php echo $clte->EntDesde; ?>" data-enthasta="<?php echo $clte->EntHasta; ?>" data-entcruces="<?php echo $clte->EntCruces; ?>" data-entobservaciones="<?php echo $clte->EntObservaciones; ?>"><em class="icon ni ni-edit"></em><span>Editar Cliente</span></a></li>
                                    <!--<li><a href="#"><em class="icon ni ni-eye"></em><span>Ver Cliente</span></a></li>-->
                                    <li><a href="#" data-bs-toggle="modal" data-bs-target="#modalAlert2" data-idclte="<?php echo $clte->IdCliente; ?>" data-nombre="<?php echo $clte->Nombre; ?>"><em class="icon ni ni-trash"></em><span>Eliminar Cliente</span></a></li>
                                </ul>
                            </div>
                        </div>
                    </li>
                </ul>`
          }],
          "buttons": [
          'copy', 'csv', 'excel', 'pdf'
        ],
        "lengthMenu": [
          [50, 100, 200, -1],
          ['50', '100', '200', 'Mostrar todo']
        ],
                "ajax":{
                    "url": 'ajax/codi_get_clientes2',
                    "type": 'POST',
                    'data' : { 'hook' : hook, 'action':action },
                    'dataFilter': function (json) {
                        var resultado = JSON.parse(json);
                        var data = resultado.data;
                        console.log(data)
                        return data;
                    }.bind(this)
                    
                }
            });

           
    }

    codi_get_tipospago();
    function codi_get_tipospago() {
        var wrapper = $('.select_wrapper_tipospago'),
            hook = 'codi_hook',
            action = 'load';

        // AJAX Usuarios Get
        $.ajax({
            url: apibase + 'ajax/codi_get_tipospago',
            type: 'POST',
            dataType: 'json',
            cache: false,
            data: { hook, action },
            beforeSend: function () {

            }
        }).done(function (res) {
            if (res.status === 200) {
                wrapper.html(res.data);
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion',
                    showConfirmButton: false,
                    timer: 5500
                })
                wrapper.html('');

            }
        })
            .fail(function (err) {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion' + err,
                    showConfirmButton: false,
                    timer: 5500
                })
                wrapper.html('');
            })
            .always(function () {

            });

    }

    $('#editForm').on('show.bs.modal', function (event) {
        var button = $(event.relatedTarget) // Button that triggered the modal
        var id = button.data('idusu');
        console.log(button.data('nombre'))
        // If necessary, you could initiate an AJAX request here (and then do the updating in a callback).
        // Update the modal's content. We'll use jQuery here, but you could use a data binding library or other methods instead.
        var modal = $(this)
        modal.find('#ECIdCliente').val(button.data('idcliente'));
        modal.find('#ECClave').val(button.data('clave'));
        modal.find('#ECNombre').val(button.data('nombre'));
        modal.find('#ECRFC').val(button.data('rfc'));
        modal.find('#ECRazonSocial').val(button.data('persona')).trigger('change');
        modal.find('#ECTipoPago').val(button.data('tipopago')).trigger('change');

        modal.find('#ECFisTelefono').val(button.data('fistelefono'));
        modal.find('#ECFisEmail').val(button.data('fisemail'));
        modal.find('#ECFisCalle').val(button.data('fiscalle'));
        modal.find('#ECFisNExt').val(button.data('fisnext'));
        modal.find('#ECFisNInt').val(button.data('fisnint'));
        modal.find('#ECFisColonia').val(button.data('fiscolonia'));
        modal.find('#ECFisCP').val(button.data('fiscp'));
        modal.find('#ECFisMunicipio').val(button.data('fismunicipio'));
        modal.find('#ECFisEstado').val(button.data('fisestado'));

        modal.find('#ECIdDomicilio').val(button.data('iddomicilio'));
        modal.find('#ECEntCalle').val(button.data('entcalle'));
        modal.find('#ECEntNExt').val(button.data('entnext'));
        modal.find('#ECEntNInt').val(button.data('entnint'));
        modal.find('#ECEntColonia').val(button.data('entcolonia'));
        modal.find('#ECEntCP').val(button.data('entcp'));
        modal.find('#ECEntMunicipio').val(button.data('entmunicipio'));
        modal.find('#ECEntEstado').val(button.data('entestado'));
        modal.find('#ECEntGiro').val(button.data('entgiro'));
        modal.find('#ECEntDesde').val(button.data('entdesde'));
        modal.find('#ECEntHasta').val(button.data('enthasta'));
        modal.find('#ECEntCruces').val(button.data('entcruces'));
        modal.find('#ECEntObservaciones').val(button.data('entobservaciones'));
        modal.find('#ECcfdi').val(button.data('cfdi')).trigger('change');
        modal.find('#ECRegimenFiscal').val(button.data('regimenfiscal')).trigger('change');
    })

    //Obtener Moviemiento
    function codi_get_usuario() {

    }
    console.log("fuera de submit")

    //Actualizar Moviemiento
    $('.codi_update_cliente').on('submit', codi_update_cliente);

    $('#modalAlert2').on('show.bs.modal', function (event) {
        var button = $(event.relatedTarget) // Button that triggered the modal
        var id = button.data('idusu');
        // If necessary, you could initiate an AJAX request here (and then do the updating in a callback).
        // Update the modal's content. We'll use jQuery here, but you could use a data binding library or other methods instead.
        var modal = $(this)
        modal.find('#idUsuario').val(id)
    })


    //Eliminar Moviemiento
    $('.codi_delete_usuario').on('click', codi_delete_usuario);
    function codi_delete_usuario(event) {
        event.preventDefault();
        var idUsuario = $('#idUsuario').val()
        console.log(idUsuario)
        var form = $('.codi_delete_usuario'),
            hook = 'codi_hook',
            action = 'update',
            data = new FormData();
        data.append('hook', hook);
        data.append('action', action);
        data.append('activo', 0);
        data.append('idUsuario', idUsuario)
        /*for (var pair of data.entries()) {
            console.log(pair[0]+ ', ' + pair[1]); 
        }*/
        // AJAX Usuarios
        $.ajax({
            url: 'ajax/codi_delete_usuario',
            type: 'POST',
            dataType: 'json',
            contentType: false,
            processData: false,
            cache: false,
            data: data,
            beforeSend: function () {
                // form.waitMe();
            }
        }).done(function (res) {
            if (res.status === 200) {
                Swal.fire({
                    icon: 'success',
                    title: res.msg,
                    showConfirmButton: false,
                    timer: 5500
                })
                form.trigger('reset');
                window.location.reload()
            } else {
                Swal.fire({
                    icon: 'error',
                    title: res.msg,
                    showConfirmButton: false,
                    timer: 5500
                })
            }
        })
            .fail(function (err) {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion'.err,
                    showConfirmButton: false,
                    timer: 5500
                })
            })
            .always(function () {
                // form.waitMe('hide');
            });

    }


    //Eliminar Moviemiento
    $('.codi_delete_cliente').on('click', codi_delete_cliente);
    function codi_delete_cliente(event) {
        event.preventDefault();
        var idCliente = $('#idCliente').val()
        console.log(idCliente)
        var form = $('.codi_delete_cliente'),
            hook = 'codi_hook',
            action = 'update',
            data = new FormData();
        data.append('hook', hook);
        data.append('action', action);
        data.append('activo', 0);
        data.append('idCliente', idCliente)
        /*for (var pair of data.entries()) {
            console.log(pair[0]+ ', ' + pair[1]); 
        }*/
        // AJAX Usuarios
        $.ajax({
            url: 'ajax/codi_delete_cliente',
            type: 'POST',
            dataType: 'json',
            contentType: false,
            processData: false,
            cache: false,
            data: data,
            beforeSend: function () {
                // form.waitMe();
            }
        }).done(function (res) {
            if (res.status === 200) {
                Swal.fire({
                    icon: 'success',
                    title: res.msg,
                    showConfirmButton: false,
                    timer: 5500
                })
                form.trigger('reset');
                window.location.reload()
            } else {
                Swal.fire({
                    icon: 'error',
                    title: res.msg,
                    showConfirmButton: false,
                    timer: 5500
                })
            }
        })
            .fail(function (err) {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion'.err,
                    showConfirmButton: false,
                    timer: 5500
                })
            })
            .always(function () {
                // form.waitMe('hide');
            });

    }

})