var apibase = "https://grupoxtinfire.com/admin/";

//Crear descuento
function codi_add_descuento(event) {
    //event.preventDefault();

    var form = $('.codi_add_descuento'),
        hook = 'codi_hook',
        action = 'add',

        data = new FormData(form.get(0));
    data.append('hook', hook);
    data.append('action', action);

    // AJAX descuentos
    $.ajax({
        url: 'ajax/codi_add_descuento',
        type: 'POST',
        dataType: 'json',
        contentType: false,
        processData: false,
        cache: false,
        data: data,
        beforeSend: function () {
            // form.waitMe();
        }
    }).done(function (res) {
        if (res.status === 201) {
            Swal.fire({
                icon: 'success',
                title: res.msg,
                showConfirmButton: false,
                timer: 1500
            })
            form.trigger('reset');
        } else {
            Swal.fire({
                icon: 'error',
                title: res.msg,
                showConfirmButton: false,
                timer: 1500
            })
        }
    })
        .fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion'.err,
                showConfirmButton: false,
                timer: 1500
            })
        })
        .always(function () {
            // form.waitMe('hide');
        });

}

//Editar descuento
$('#editForm').on('show.bs.modal', function (event) {
    console.log("abrio el modal")
    var button = $(event.relatedTarget) // Button that triggered the modal
    var id = button.data('id');
    var depto = button.data('depto');
    var descuento = button.data('descuento');
    // If necessary, you could initiate an AJAX request here (and then do the updating in a callback).
    // Update the modal's content. We'll use jQuery here, but you could use a data binding library or other methods instead.
    var modal = $(this)
    modal.find('#iddescuento').val(id)
    modal.find('#eddepto').val(depto) //Este solo es informativo
    modal.find('#EdDescuento').val(descuento)
})

//Eliminar descuento
$('#deleteDescuento').on('show.bs.modal', function (event) {
    console.log("abrio el modal")
    var button = $(event.relatedTarget) // Button that triggered the modal
    var id = button.data('id');
    // If necessary, you could initiate an AJAX request here (and then do the updating in a callback).
    // Update the modal's content. We'll use jQuery here, but you could use a data binding library or other methods instead.
    var modal = $(this)
    modal.find('#iddescuentodelete').val(id)
})

//Editar descuento
function codi_update_descuento(event) {
    //event.preventDefault();
    var form = $('.codi_update_descuento'),
        hook = 'codi_hook',
        action = 'update',
        data = new FormData(form.get(0));
    console.log(data)

    data.append('hook', hook);
    data.append('action', action);
    /*for (var pair of data.entries()) {
        console.log(pair[0]+ ', ' + pair[1]); 
    }*/

    // AJAX Usuarios
    $.ajax({
        url: 'ajax/codi_update_descuento',
        type: 'POST',
        dataType: 'json',
        contentType: false,
        processData: false,
        cache: false,
        data: data,
        beforeSend: function () {
            // form.waitMe();
        }
    }).done(function (res) {
        if (res.status === 200) {
            Swal.fire({
                icon: 'success',
                title: res.msg,
                showConfirmButton: false,
                timer: 1500
            })
            form.trigger('reset');
            window.location.href = "";

        } else {
            Swal.fire({
                icon: 'error',
                title: res.msg,
                showConfirmButton: false,
                timer: 1500
            })
        }
    })
        .fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion'.err,
                showConfirmButton: false,
                timer: 1500
            })
        })
        .always(function () {
            // form.waitMe('hide');
        });
}

//Eliminar Descuento
$('#deleteDescuento').on('show.bs.modal', function (event) {
    var button = $(event.relatedTarget) // Button that triggered the modal
    var id = button.data('id');
    // If necessary, you could initiate an AJAX request here (and then do the updating in a callback).
    // Update the modal's content. We'll use jQuery here, but you could use a data binding library or other methods instead.
    var modal = $(this)
    modal.find('#iddescuento').val(id)
})

//Eliminar Descuento
function codi_delete_descuento(event) {
    //event.preventDefault();
    var iddescuento = $('#iddescuentodelete').val();
    var form = $('.codi_delete_descuento'),
        hook = 'codi_hook',
        action = 'update',
        data = new FormData();
    data.append('hook', hook);
    data.append('action', action);
    data.append('iddescuento', iddescuento);
    /*for (var pair of data.entries()) {
        console.log(pair[0]+ ', ' + pair[1]); 
    }*/
    // AJAX Usuarios
    $.ajax({
        url: 'ajax/codi_delete_descuento',
        type: 'POST',
        dataType: 'json',
        contentType: false,
        processData: false,
        cache: false,
        data: data,
        beforeSend: function () {
            // form.waitMe();
        }
    }).done(function (res) {
        console.log(res)

        if (res.status === 200) {
            Swal.fire({
                icon: 'success',
                title: res.msg,
                showConfirmButton: false,
                timer: 1500
            })
            form.trigger('reset');
            location.reload()
        } else {
            Swal.fire({
                icon: 'error',
                title: res.msg,
                showConfirmButton: false,
                timer: 1500
            })
        }

    })
        .fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion'.err,
                showConfirmButton: false,
                timer: 1500
            })
        })
        .always(function () {
            // form.waitMe('hide');
        });

}

$(document).ready(function () {
    codi_get_descuentos();
    function codi_get_descuentos() {
        var wrapper = $('.tabla_wrapper_descuentos'),
            hook = 'codi_hook',
            action = 'load';

        // AJAX Usuarios Get
        $.ajax({
            url: apibase + 'ajax/codi_get_descuentos',
            type: 'POST',
            dataType: 'json',
            cache: false,
            data: { hook, action },
            beforeSend: function () {

            }
        }).done(function (res) {
            if (res.status === 200) {
                wrapper.html(res.data);
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion',
                    showConfirmButton: false,
                    timer: 1500
                })
                wrapper.html('');

            }
        })
            .fail(function (err) {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion' + err,
                    showConfirmButton: false,
                    timer: 1500
                })
                wrapper.html('');
            })
            .always(function () {

            });

    }

    codi_get_departamento_select();
    function codi_get_departamento_select() {
        var wrapper = $('.select_wrapper_departamento'),
            hook = 'codi_hook',
            action = 'load';
        const w = document.querySelectorAll('.select_wrapper_departamento');

        $.ajax({
            url: 'ajax/codi_get_departamento_select',
            type: 'POST',
            dataType: 'json',
            cache: false,
            data: { hook, action },
            beforeSend: function () {

            }
        }).done(function (res) {
            if (res.status === 200) {
                w.forEach(element => {
                    element.innerHTML = res.data
                });
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion',
                    showConfirmButton: false,
                    timer: 1500
                })
                wrapper.html('');

            }
        })
            .fail(function (err) {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion' + err,
                    showConfirmButton: false,
                    timer: 1500
                })
                wrapper.html('');
            })
            .always(function () {

            });

    }

})