var apibase = "https://grupoxtinfire.com/admin/";
function codi_add_extintor() {
    var form = $('.codi_add_extintor'),
        hook = 'codi_hook',
        action = 'add',
        data = new FormData(form.get(0));

    data.append('hook', hook);
    data.append('action', action);
    console.log(data)

    // AJAX Ordenes
    $.ajax({
        url: apibase + 'ajax/codi_add_extintor',
        type: 'POST',
        dataType: 'json',
        contentType: false,
        processData: false,
        cache: false,
        data: data,
        beforeSend: function () {
            /*
            Swal.fire({
                icon: 'info',
                title: "Asignando extintor, por favor espere.",
                showConfirmButton: false,
            })*/
        }
    }).done(function (res) {
        console.log(res)
        if (res.status === 201) {
            Swal.fire({
                icon: 'success',
                title: res.msg,
                showConfirmButton: false,
                timer: 3500
            })
            //Wform.trigger('reset');
            window.location.href = "";

        } else {
            Swal.fire({
                icon: 'error',
                title: res.msg,
                showConfirmButton: false,
                timer: 1500
            })
        }
    })
        .fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion'.err,
                showConfirmButton: false,
                timer: 1500
            })
        })
        .always(function () {
            // form.waitMe('hide');
        });
}

function codi_update_extintor() {
    var form = $('.codi_update_extintor'),
        hook = 'codi_hook',
        action = 'add',
        data = new FormData(form.get(0));

    data.append('hook', hook);
    data.append('action', action);
    console.log(data)

    // AJAX Ordenes
    $.ajax({
        url: apibase + 'ajax/codi_update_extintor',
        type: 'POST',
        dataType: 'json',
        contentType: false,
        processData: false,
        cache: false,
        data: data,
        beforeSend: function () {
            /*
            Swal.fire({
                icon: 'info',
                title: "Asignando extintor, por favor espere.",
                showConfirmButton: false,
            })*/
        }
    }).done(function (res) {
        console.log(res)
        if (res.status === 201) {
            Swal.fire({
                icon: 'success',
                title: res.msg,
                showConfirmButton: false,
                timer: 3500
            })
            //Wform.trigger('reset');
            window.location.href = "";

        } else {
            Swal.fire({
                icon: 'error',
                title: res.msg,
                showConfirmButton: false,
                timer: 1500
            })
        }
    })
        .fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion'.err,
                showConfirmButton: false,
                timer: 1500
            })
        })
        .always(function () {
            // form.waitMe('hide');
        });
}

$(document).ready(function () {
    codi_get_extintores();
    function codi_get_extintores() {
        var wrapper = $('.tabla_wrapper_extintores'),
            hook = 'codi_hook',
            action = 'load';

        // AJAX Usuarios Get
        $.ajax({
            url: apibase + 'ajax/codi_get_extintores',
            type: 'POST',
            dataType: 'json',
            cache: false,
            data: { hook, action },
            beforeSend: function () {

            }
        }).done(function (res) {
            if (res.status === 200) {
                wrapper.html(res.data);
                $('.datatable-init').DataTable({
                    responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    dom: 'Blfrtip',
                    buttons: ['copy', 'excel', 'csv', 'pdf'],
                    order: [[0, 'desc']],
                    language: {
                        url: 'https://cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json'
                    },
                    "bDestroy": true
                });
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion',
                    showConfirmButton: false,
                    timer: 1500
                })
                wrapper.html('');

            }
        })
            .fail(function (err) {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion' + err,
                    showConfirmButton: false,
                    timer: 1500
                })
                wrapper.html('');
            })
            .always(function () {

            });

    }

    codi_get_clientes_select();
    function codi_get_clientes_select() {
        var wrapper = $('.select_wrapper_clientes'),
            hook = 'codi_hook',
            action = 'load';


        // AJAX Usuarios Get
        $.ajax({
            url: apibase + 'ajax/codi_get_clientes_select',
            type: 'POST',
            dataType: 'json',
            cache: false,
            data: { hook, action },
            beforeSend: function () {

            }
        }).done(function (res) {
            if (res.status === 200) {
                wrapper.html(res.data);
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion',
                    showConfirmButton: false,
                    timer: 1500
                })
                wrapper.html('');

            }
        })
            .fail(function (err) {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion' + err,
                    showConfirmButton: false,
                    timer: 1500
                })
                wrapper.html('');
            })
            .always(function () {

            });

    }

    codi_get_productos_select();
    function codi_get_productos_select() {
        var wrapper = $('.select_wrapper_productos'),
            hook = 'codi_hook',
            action = 'load';


        // AJAX Usuarios Get
        $.ajax({
            url: apibase + 'ajax/codi_get_productos_select',
            type: 'POST',
            dataType: 'json',
            cache: false,
            data: { hook, action },
            beforeSend: function () {

            }
        }).done(function (res) {
            if (res.status === 200) {
                wrapper.html(res.data);
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion',
                    showConfirmButton: false,
                    timer: 1500
                })
                wrapper.html('');

            }
        })
            .fail(function (err) {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion' + err,
                    showConfirmButton: false,
                    timer: 1500
                })
                wrapper.html('');
            })
            .always(function () {

            });

    }

    codi_get_ordenes_select();
    function codi_get_ordenes_select() {
        var wrapper = $('.select_wrapper_ordenes'),
            hook = 'codi_hook',
            action = 'load';


        // AJAX Usuarios Get
        $.ajax({
            url: apibase + 'ajax/codi_get_ordenesfolio_select',
            type: 'POST',
            dataType: 'json',
            cache: false,
            data: { hook, action },
            beforeSend: function () {

            }
        }).done(function (res) {
            if (res.status === 200) {
                wrapper.html(res.data);
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion',
                    showConfirmButton: false,
                    timer: 1500
                })
                wrapper.html('');

            }
        })
            .fail(function (err) {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion' + err,
                    showConfirmButton: false,
                    timer: 1500
                })
                wrapper.html('');
            })
            .always(function () {

            });

    }

    $('#updateExtint').on('show.bs.modal', function (event) {
        var button = $(event.relatedTarget) // Button that triggered the modal
        // If necessary, you could initiate an AJAX request here (and then do the updating in a callback).
        // Update the modal's content. We'll use jQuery here, but you could use a data binding library or other methods instead.
        var modal = $(this)
        modal.find('#Uidextintor').val(button.data('idextintor'));
        modal.find('#Uclaveextintor').val(button.data('claveextintor'));
        modal.find('#Uubicacion').val(button.data('ubicacion'));
        modal.find('#Ufechaentrega').val(button.data('fechaentrega'));
        modal.find('#Uestatus').val(button.data('estatus')).trigger('change');
        modal.find('#Uproducto').val(button.data('producto')).trigger('change');
        modal.find('#Uorden').val(button.data('orden')).trigger('change');
        modal.find('#Ucliente').val(button.data('cliente')).trigger('change');
    })
})