var apibase = "https://grupoxtinfire.com/admin/";

function codi_get_producto(select) {
    var proId = select.value;
    if (proId) {
        wrapper = $('.wrapper_insert_productos'),
            hook = 'codi_hook',
            action = 'load';

        // AJAX Usuarios Get
        $.ajax({
            url: apibase + 'ajax/codi_get_producto',
            type: 'POST',
            dataType: 'json',
            cache: false,
            data: { hook, action, proId: proId },
            beforeSend: function () {

            }
        }).done(function (res) {
            if (res.status === 200) {
                var IdProducto = res.data.proId;
                var PrecioVenta = res.data.proPrecioventa;
                codi_add_detalleorden(IdProducto, PrecioVenta)
				$("#selectprods").val("").trigger('change');
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion',
                    showConfirmButton: false,
                    timer: 1500
                })
            }
        }).fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion. Código: 3004',
                showConfirmButton: false,
                timer: 1500
            })
        }).always(function () {

        });
    }
}

function pagarfactura(mespartida,ordeninvoice,estatus){

            hook = 'codi_hook';
            action = 'update';
        // AJAX Usuarios Get
        $.ajax({
            url: apibase + 'ajax/codi_update_estatus_pago_fact',
            type: 'POST',
            dataType: 'json',
            cache: false,
            data: { hook, action, mespartida, ordeninvoice, estatus },
            beforeSend: function () {

            }
        }).done(function (res) {
            if (res.status === 200) {
                Swal.fire({
                    icon: 'success',
                    title: 'Pago registrado',
                    showConfirmButton: false,
                    timer: 1500
                })
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion',
                    showConfirmButton: false,
                    timer: 1500
                })

            }
        })
            .fail(function (err) {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion. Código: 3001',
                    showConfirmButton: false,
                    timer: 1500
                })
                wrapper.html('');
            })
            .always(function () {

            });

}

function eliminartodos(ordeninvoice){

            hook = 'codi_hook';
            action = 'update';
        // AJAX Usuarios Get
        $.ajax({
            url: apibase + 'ajax/codi_update_eliminar_pago',
            type: 'POST',
            dataType: 'json',
            cache: false,
            data: { hook, action, ordeninvoice},
            beforeSend: function () {

            }
        }).done(function (res) {
            if (res.status === 200) {
                Swal.fire({
                    icon: 'success',
                    title: 'Pago registrado',
                    showConfirmButton: false,
                    timer: 1500
                })
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion',
                    showConfirmButton: false,
                    timer: 1500
                })

            }
        })
            .fail(function (err) {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion. Código: 3001',
                    showConfirmButton: false,
                    timer: 1500
                })
                wrapper.html('');
            })
            .always(function () {

            });

}

function codi_get_productos_almacen_select() {
    var almacen = $('#proAlmacen').val();
    var nombrepagina = $('#nombrepagina').val();
    if (nombrepagina == "orden") {
        if (almacen == "") {
            Swal.fire({
                icon: 'error',
                title: 'Por favor seleccione un almacen.',
                showConfirmButton: false,
                timer: 3500
            })
            return;
        }
        var wrapper = $('.select_wrapper_productos'),
            hook = 'codi_hook',
            action = 'load';


        // AJAX Usuarios Get
        $.ajax({
            url: apibase + 'ajax/codi_get_productos_almacen_select',
            type: 'POST',
            dataType: 'json',
            cache: false,
            data: { hook, action, almacen: almacen },
            beforeSend: function () {

            }
        }).done(function (res) {
            if (res.status === 200) {
                wrapper.html(res.data);
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion',
                    showConfirmButton: false,
                    timer: 1500
                })
                wrapper.html('');

            }
        })
            .fail(function (err) {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion. Código: 3001',
                    showConfirmButton: false,
                    timer: 1500
                })
                wrapper.html('');
            })
            .always(function () {

            });
    }
}

function codi_add_detalleorden(IdProducto, PrecioVenta) {
    var IdOrden = $('#IdOrden').val();
    var FolioOrden = $('#FolioOrden').val();
    var Partida = "0";
    var Cantidad = "1";

    wrapper = $('.wrapper_insert_productos'),
        hook = 'codi_hook',
        action = 'load';

    // AJAX Usuarios Get
    $.ajax({
        url: apibase + 'ajax/codi_add_detalleorden',
        type: 'POST',
        dataType: 'json',
        cache: false,
        data: {
            hook, action,
            IdOrden: IdOrden,
            FolioOrden: FolioOrden,
            Partida: Partida,
            IdProducto: IdProducto,
            Cantidad: Cantidad,
            PrecioVenta: PrecioVenta,
        },
        beforeSend: function () {

        }
    }).done(function (res) {
        if (res.status === 201) {
            $("#selectprods").val("").trigger('change')

            codi_get_detalleorden();
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion',
                showConfirmButton: false,
                timer: 1500
            })
        }
    }).fail(function (err) {
        Swal.fire({
            icon: 'error',
            title: 'Hubo un error en la peticion. Código: 3002',
            showConfirmButton: false,
            timer: 1500
        })
    }).always(function () {

    });
}

function codi_get_detalleorden() {
    var wrapper = $('.tabla_wrapper_detalleorden'),
        hook = 'codi_hook',
        action = 'load';
    var IdOrden = $('#IdOrden').val();
    var suma = $("#sumaproval").val();
    var IdCompraphp = 0;
    var contador = 0;
    var contadororiginal = null;
    var partidacincuenta = $("#partidacincuentaval").val();
    var partidainvoice = $("#partidaordendesfactual").val();
    var nounir = $("#separarproductosindividual").val();
    if(partidacincuenta == 1 && partidainvoice == 2){
       partidainvoice = 1;
    }
    var ordenrelacionada = $("#ordrela").val();
    // AJAX Usuarios Get
    $.ajax({
        url: apibase + 'ajax/codi_get_detalleorden_factura',
        type: 'POST',
        dataType: 'json',
        cache: false,
        data: { hook, action, IdOrden: IdOrden, IdCompraphp:IdCompraphp,contador:contador,contadororiginal:contadororiginal,partidainvoice,ordenrelacionada, suma, nounir },
        beforeSend: function () {

        }
    }).done(function (res) {
        if (res.status === 200) {
            wrapper.html(res.data);
            $('.datatable-init').DataTable({
                responsive: true,
                orderCellsTop: true,
                fixedHeader: true,
                dom: 'Blfrtip',
                buttons: ['copy', 'excel', 'csv', 'pdf'],
                language: {
                    url: 'https://cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json'
                }
            });
			calcular_total();
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion',
                showConfirmButton: false,
                timer: 1500
            })
            wrapper.html('');

        }
    })
        .fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion. Código: 3003',
                showConfirmButton: false,
                timer: 1500
            })
            wrapper.html('');
        })
        .always(function () {

        });

}

function codi_get_almacen_select() {
    var wrapper = $('.select_wrapper_almacen'),
        hook = 'codi_hook',
        action = 'load';
    const w = document.querySelectorAll('.select_wrapper_almacen');
    // AJAX Usuarios Get
    $.ajax({
        url: apibase + 'ajax/codi_get_almacenes_select',
        type: 'POST',
        dataType: 'json',
        cache: false,
        data: { hook, action },
        beforeSend: function () {

        }
    }).done(function (res) {
        if (res.status === 200) {
            w.forEach(element => {
                element.innerHTML = res.data
            });
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion',
                showConfirmButton: false,
                timer: 6500
            })
            wrapper.html('');

        }
    })
        .fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion: Error en el servidor',
                showConfirmButton: false,
                timer: 6500
            })
            wrapper.html('');
        })
        .always(function () {

        });

}

function botones() {
    //botones
    var plus = document.querySelectorAll("[data-number='plus']");
    var minus = document.querySelectorAll("[data-number='minus']");

    plus.forEach(function (item, index, arr) {
        var parent = plus[index].parentNode;
        plus[index].addEventListener("click", function () {
            var child = plus[index].parentNode.children;
            child.forEach(function (item, index, arr) {
                if (child[index].classList.contains("number-spinner")) {
                    var value = !child[index].value == "" ? parseInt(child[index].value) : 0;
                    var step = !child[index].step == "" ? parseInt(child[index].step) : 1;
                    var max = !child[index].max == "" ? parseInt(child[index].max) : Infinity;
                    if (max + 1 > value + step) {
                        child[index].value = value + step;
                    } else {
                        child[index].value = value;
                    }
                }
            });
        });
    });
    minus.forEach(function (item, index, arr) {
        var parent = minus[index].parentNode;
        minus[index].addEventListener("click", function () {
            var child = minus[index].parentNode.children;
            child.forEach(function (item, index, arr) {
                if (child[index].classList.contains("number-spinner")) {
                    var value = !child[index].value == "" ? parseInt(child[index].value) : 0;
                    var step = !child[index].step == "" ? parseInt(child[index].step) : 1;
                    var min = !child[index].min == "" ? parseInt(child[index].min) : 0;
                    if (min - 1 < value - step) {
                        child[index].value = value - step;
                    } else {
                        child[index].value = value;
                    }
                }
            });
        });
    });
    //botones
}

function codi_update_orden() {
    //event.preventDefault();

    //Detalle de la orden
    var filas = [];
    var i = 1;
    $('#tbl_orden tbody tr').each(function () {
        var id = $(this).find('td').eq(0).text();
        var clave = $(this).find('td').eq(1).text();
        var descripcion = $(this).find('td').eq(2).text();
        var existencia = $(this).find('td').eq(3).text();
        var disponibles = $(this).find('td').eq(5).text();
        var precio = $(this).find('td').eq(6).find('input').val();
        var cantidad = $(this).find('td').eq(7).find('input').val();
        var descuento = $(this).find('td').eq(8).find('select').val();
        var descuentopesos = $(this).find('td').eq(9).find('input').val();
        var monto = parseFloat(precio) * parseFloat(cantidad);
		var neto = $(this).find('td').eq(10).find('input').val();
		var entregados = $(this).find('td').eq(11).find('input').val();
        var iddetalle = $(this).find('td').eq(13).text();
        var extintor = $(this).find('td').eq(14).text();
        var partida = i;

        var fila = {
            iddetalle,
            id,
            clave,
            descripcion,
            existencia,
            disponibles,
            cantidad,
            precio,
            monto,
            partida,
            entregados,
            extintor,
            descuento,
            descuentopesos,
            neto
        };
        filas.push(fila);
        i++;
    });

    var form = $('.codi_add_orden'),
        hook = 'codi_hook',
        action = 'add',
        data = new FormData(form.get(0));
    var estatus = $('#UEstatus').val();
    var transito = $('#Utransito').val();
    var folioorden = $('#FolioOrden').val();
    var idorden = $('#UIdOrden').val();
    var tipo_orden = $('#tipo_orden').val();
    var tipo_servicio = $('#tipo_servicio').val();
    var EstatusOriginal = $('#EstatusOriginal').val();
    var Descripcion = $('#CDescripcion').val();

    data.append('hook', hook);
    data.append('action', action);
    data.append('estatus', estatus);
    data.append('transito', transito);
    data.append('idorden', idorden);
    data.append('folioorden', folioorden);
    data.append('tipo_orden', tipo_orden);
    data.append('tipo_servicio', tipo_servicio);
    data.append('EstatusOriginal', EstatusOriginal);
    data.append('Descripcion', Descripcion);
    data.append('productos', JSON.stringify(filas));

    // AJAX Usuarios
    $.ajax({
        url: apibase + 'ajax/codi_update_orden',
        type: 'POST',
        dataType: 'json',
        contentType: false,
        processData: false,
        cache: false,
        data: data,
        beforeSend: function () {
            // form.waitMe();
            Swal.fire({
                icon: '',
                title: 'Actualizando Orden',
                text: 'Se está actualizando la orden, Por favor espere...',
                showConfirmButton: false,
            })
        }
    }).done(function (res) {
        if (res.status === 200) {
            Swal.fire({
                icon: 'success',
                title: res.msg,
                showConfirmButton: false,
                timer: 1500
            })
            form.trigger('reset');
            window.location.href = "";

        } else {
            Swal.fire({
                icon: 'error',
                title: res.msg,
                showConfirmButton: false,
                timer: 1500
            })
        }
    })
        .fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion',
                showConfirmButton: false,
                timer: 1500
            })
        })
        .always(function () {
            // form.waitMe('hide');
        });
}

//Agregar user
    $('.codi_add_factura').on('submit', codi_add_factura);
    function codi_add_factura(event) {

        event.preventDefault();

        var form = $('.codi_add_factura'),
            hook = 'codi_hook',
            action = 'add',
            data = new FormData(form.get(0));
        data.append('hook', hook);
        data.append('action', action);
        var pdf = $('.upload-zone-pdf')[0].dropzone.getAcceptedFiles()[0] ? $('.upload-zone-pdf')[0].dropzone.getAcceptedFiles()[0] : null;
        var xml = $('.upload-zone-pdf')[0].dropzone.getAcceptedFiles()[1] ? $('.upload-zone-pdf')[0].dropzone.getAcceptedFiles()[1] : null;

        if(pdf == null || xml == undefined){
            Swal.fire({
                icon: 'warning',
                title: 'No se puede ejecutar la carga de archivos sin agregar el archivo PDF y XML',
                showConfirmButton: false,
                timer: 1500
            })

            return;
        }
        var idinvoice = $("#IdInvoice").val();
        data.append('pdf', pdf);
        data.append('xml', xml);
        data.append('idc', idinvoice);

        // AJAX Productos
        $.ajax({
            url: apibase + 'ajax/codi_add_factura_orden',
            type: 'POST',
            dataType: 'json',
            contentType: false,
            processData: false,
            cache: false,
            data: data,
            beforeSend: function () {
                // form.waitMe();
            }
        }).done(function (res) {
            if(res.status == 201){
                Swal.fire({
                    icon: 'success',
                    title: res.msg,
                    showConfirmButton: false,
                    timer: 3500
                })
                /*setTimeout(() => {
                  location.reload()
                }, 4000);*/
            }
            
        })
            .fail(function (err) {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion'.err,
                    showConfirmButton: false,
                    timer: 6500
                })
            })
            .always(function () {
                // form.waitMe('hide');
            });

    }

function codi_transformar_invoice() {
    //event.preventDefault();

    var form = $('.codi_add_orden'),
        hook = 'codi_hook',
        action = 'add',
        data = new FormData(form.get(0));
    var idorden = $('#FolioOrden').val();

    data.append('hook', hook);
    data.append('action', action);
    data.append('idorden', idorden);

    // AJAX Usuarios
    $.ajax({
        url: apibase + 'ajax/codi_transformar_invoice',
        type: 'POST',
        dataType: 'json',
        contentType: false,
        processData: false,
        cache: false,
        data: data,
        beforeSend: function () {
            // form.waitMe();
        }
    }).done(function (res) {
        if (res.status === 200) {
            Swal.fire({
                icon: 'success',
                title: res.msg,
                showConfirmButton: false,
                timer: 3500
            })
            form.trigger('reset');
            window.location.href = "";

        } else {
            Swal.fire({
                icon: 'error',
                title: res.msg,
                showConfirmButton: false,
                timer: 1500
            })
        }
    })
        .fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion',
                showConfirmButton: false,
                timer: 1500
            })
        })
        .always(function () {
            // form.waitMe('hide');
        });
}

//--------------------------INVOICES------------------------------------------
function cambiartipo() {
    var selectorden = document.querySelector("select[id=tipo_orden]");
    var tipoorden = selectorden.options[selectorden.selectedIndex].text;

    $('#TipoServicio').hide();
    if (tipoorden == "Recargas y Mantenimiento") {
        $('#TipoServicio').show();
    }
}

function mostrarGenerarComprobante() {
    var select = document.querySelector("select[id=Factura]");
    var select = $('input[name="Factura"]:checked').val();
    if (select == "SI") {
        $('#diggencomp').show();
    } else {
        $('#diggencomp').hide();
    }
}

function sumarDias(fecha, dias){
    fecha = new Date(fecha);
    fecha.setDate(fecha.getDate() + dias);
    fecha = formatDate(fecha);
    return fecha;
}

/*Genera la fecha en formato "YYYY-mm-dd"*/
function formatDate(date) {
  return [
    date.getFullYear(),
    padTo2Digits(date.getMonth() + 1),
    padTo2Digits(date.getDate()),
    
    
  ].join('-');
}
/*Funcion para poner 2 digitos a un numero de un solo digito, ejemplo: 01*/
function padTo2Digits(num) {
  return num.toString().padStart(2, '0');
}

//Agregar orden
function codi_update_invoice() {
    var filas = [];
    $('#tablameses tbody tr').each(function () {
        var numero = $(this).find('td').eq(0).find('label').text();
        var fecha = $(this).find('td').eq(1).find('input').val();
        var cantidad = $(this).find('td').eq(2).find('input').val();
        var nota = $(this).find('td').eq(3).find('input').val();

        var fila = {
            numero,
            fecha,
            cantidad,
            nota
        };
        filas.push(fila);
    });

    var IdOrden = $('#UIdOrden').val();
    var IdInvoice = $('#IdInvoice').val();
    var Pago = $('#Pago').val();
    var InicioPeriodoPago = $('#Pago').val();
    var Factura = $('input[name="Factura"]:checked').val();
    var GenerarComprobante = $('input[name="GenerarComprobante"]:checked').val();
    var Estatus = $('#UEstatus').val();
    var tipoOrden = $('#tipo_orden').val();

    var EstadoTransito = $('#Utransito').val();
    var form = $('.codi_add_orden'),
        hook = 'codi_hook',
        action = 'add',
        data = new FormData(form.get(0));

    data.append('hook', hook);
    data.append('action', action);
    data.append('filas', JSON.stringify(filas));

    data.append('IdOrden', IdOrden);
    data.append('IdInvoice', IdInvoice);
    data.append('Pago', Pago);
    data.append('InicioPeriodoPago', InicioPeriodoPago);
    data.append('Factura', Factura);
    data.append('GenerarComprobante', GenerarComprobante);
    data.append('Estatus', Estatus);
    data.append('EstadoTransito', EstadoTransito);
    data.append('tipoOrden', tipoOrden);
    const fechaini = new Date();
    const formatDate = (d) => {
      return d.getFullYear() + "-" + (d.getMonth() + 1) + "-" + d.getDate() ;
    }
    var fechainipipc = formatDate(fechaini);
    var fechafinpipc = sumarDias(fechainipipc,45);
    var IdOrden = $("#UIdOrden").val();
    // AJAX Ordenes
    $.ajax({
        url: apibase + 'ajax/codi_update_invoice',
        type: 'POST',
        dataType: 'json',
        contentType: false,
        processData: false,
        cache: false,
        data: data,
        beforeSend: function () {
            Swal.fire({
                icon: 'info',
                title: "Actualizando Invoice, por favor espere.",
                showConfirmButton: false,
            })
        }
    }).done(function (res) {
        if (res.status === 201) {
            console.log("Quiero saber cual soy " +tipoOrden)
            console.log("Quiero ser hook " +hook)
            console.log("Quiero ser action " +action)
            if(tipoOrden == 6){
                Swal.fire({
                  title: "¡Actualizado corretamente! ¡Esta orden es PIPC!",
                  text: "¿Deseas agregar la fecha inicio pipc y transferir la orden?",
                  icon: "success",
                  showCancelButton: true,
                  confirmButtonColor: "#3085d6",
                  cancelButtonColor: "#d33",
                  cancelButtonText: "Cancelar",
                  confirmButtonText: "Si hazlo"
                }).then((result) => {
                  if (result.isConfirmed) {
                        // AJAX pipc
                        $.ajax({
                            url: apibase + 'ajax/insertar_fechas_pipc',
                            type: 'POST',
                            dataType: 'json',
                            data: {hook, action,fechainipipc, fechafinpipc, IdOrden},
                            beforeSend: function () {
                                Swal.fire({
                                    icon: 'info',
                                    title: "Transfiriendo la orden y colocando fecha de inicio PIPC.",
                                    showConfirmButton: false,
                                })
                            }
                        }).done(function (res) {
                            if (res.status === 200) {
                                Swal.fire({
                                    icon: 'success',
                                    title: res.msg,
                                    showConfirmButton: false,
                                    timer: 5500
                                })
                                //Wform.trigger('reset');
                                window.location.href = "";

                            } else {
                                Swal.fire({
                                    icon: 'error',
                                    title: res.msg,
                                    showConfirmButton: false,
                                    timer: 5500
                                })
                            }
                        })
                        .fail(function (err) {
                            Swal.fire({
                                icon: 'error',
                                title: 'Hubo un error en la peticion. Code:3005',
                                showConfirmButton: false,
                                timer: 10500
                            })
                        })
                        .always(function () {
                            // form.waitMe('hide');
                        });
                  }
                });
            }else{
                Swal.fire({
                    icon: 'success',
                    title: res.msg,
                    showConfirmButton: false,
                    timer: 3500
                })
                window.location.href = "";  
            }
            
            
        } else {
            Swal.fire({
                icon: 'error',
                title: res.msg,
                showConfirmButton: false,
                timer: 1500
            })
        }
    })
        .fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion'.err,
                showConfirmButton: false,
                timer: 1500
            })
        })
        .always(function () {
            // form.waitMe('hide');
        });
}
//--------------------------------------EXTINTORES----------------------------------------
function codi_update_extintor_baja() {
    var form = $('.codi_update_extintor_baja'),
        hook = 'codi_hook',
        action = 'add',
        data = new FormData(form.get(0));

    data.append('hook', hook);
    data.append('action', action);
    data.append('BFolioOrden', $('#FolioOrden').val());
    data.append('BClaveExtintor', $('#BClaveExtintor').val());
    data.append('bmotivo', $('#bmotivo').val());
    data.append('BObservacion', $('#BObservacion').val());
    data.append('bOtroMotivo', $('#bOtroMotivo').val());
    data.append('BIdExtintor', $('#BIdExtintor').val());

    // AJAX Ordenes
    $.ajax({
        url: apibase + 'ajax/codi_update_extintor_baja',
        type: 'POST',
        dataType: 'json',
        contentType: false,
        processData: false,
        cache: false,
        data: data,
        beforeSend: function () {
        }
    }).done(function (res) {
        if (res.status === 201) {
            Swal.fire({
                icon: 'success',
                title: res.msg,
                showConfirmButton: false,
                timer: 5500
            })
            //Wform.trigger('reset');
            window.location.href = "";

        } else {
            Swal.fire({
                icon: 'error',
                title: res.msg,
                showConfirmButton: false,
                timer: 5500
            })
        }
    })
        .fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion. Code:3005',
                showConfirmButton: false,
                timer: 10500
            })
        })
        .always(function () {
            // form.waitMe('hide');
        });
}

function agregarMotivoBaja() {
    var selectorden = document.querySelector("select[id=bmotivo]");
    var movimiento = selectorden.options[selectorden.selectedIndex].text;

    $('#bOtroMotivo').hide();
    $('#bOtroMotivol').hide();
    if (movimiento == "OTRO MOTIVO") {
        $('#bOtroMotivo').show();
        $('#bOtroMotivol').show();
    } else {
        $('#bOtroMotivo').hide();
        $('#bOtroMotivol').hide();
    }
}
function sleep(time) {
    return new Promise((resolve) => setTimeout(resolve, time));
}

function selectdesc(event){

    var formato = new Intl.NumberFormat('es-MX', {
        style: 'currency',
        currency: 'MXN',
    });
   var descuentototal = $("#descuentototal").val();
   var tr = event.closest(`tr`);
   var preciocell = tr.cells[6].children[0].value;
   var cantidadcell = tr.cells[7].children[0].value;
   var porciento = event.value;
   var total = preciocell * cantidadcell;
   var porciento = total * (porciento / 100);
   var totalconsentrado = parseFloat(porciento) + parseFloat(descuentototal);
   var monto = total - porciento;
    $("#descuentototal").val(totalconsentrado);
    tr.cells[9].children[0].value = porciento.toFixed(2);
    tr.cells[10].children[0].value =  monto.toFixed(2);
	
    subtotal = $("#subtotal").text();
	if(subtotal == ""){
		subtotal = 0;
	}
    subtotal = subtotal.replace("$", "");
    subtotal = parseFloat(subtotal) - porciento;
    var cantiva = subtotal * (16 / 100);
    var total = parseFloat(subtotal) + parseFloat(cantiva);
	
    $("#descuentoT").text(formato.format(totalconsentrado));
    $("#subtotal").text(formato.format(subtotal));  
    $("#iva").text(formato.format(cantiva));
    $("#iva2").val(1);
    $("#total").text(formato.format(total));
    $("#neto").val(total);
	calcular_total();
}


function calcular_total(){
    
    var formato = new Intl.NumberFormat('es-MX', {
        style: 'currency',
        currency: 'MXN',
    });
    var totalconsentrado = 0;
    var subtotal = 0;
    var cantiva = 0;
    var total = 0;
    var descuentopesosTotal = 0;
    var ivatotal = 0;
    $('#tbl_orden tbody tr').each(function () {
        descuentopesos = $(this).find('td').eq(9).find('input').val();
        descuentopesos = descuentopesos.replace(",", ""); 
        var neto = $(this).find('td').eq(10).find('input').val();
        neto = neto.replace(/,/g, "");
        subtotal = parseFloat(neto) + parseFloat(subtotal) ;
        console.log("por que me das errror con la coma")
        console.log($(this).find('td').eq(11).find('input').val())
        var ivas = $(this).find('td').eq(11).find('input').val();
        ivas = ivas.replace(/,/g, "");
        ivatotal += parseFloat(ivas);
        descuentopesosTotal += parseFloat(descuentopesos);
        totalconsentrado = parseFloat(descuentopesos) + parseFloat(totalconsentrado) ;
    });
    
    cantiva = subtotal * (16 / 100);
    total = parseFloat(subtotal) + parseFloat(ivatotal);
    
    $("#descuentoT").text(formato.format(descuentopesosTotal));
    $("#subtotal").text(formato.format(subtotal));  
    $("#iva").text(formato.format(ivatotal));
    $("#iva2").val(ivatotal.toFixed(2));
    $("#total").text(formato.format(total));
    $("#neto").val(total);
    $("#subtotalT").text(formato.format((subtotal + descuentopesosTotal).toFixed(2)));
}
$(document).on('click', '.borrar', function (event) {
        event.preventDefault();
        $(this).closest('tr').remove();
        var parent = $(this).closest("tr");
        parent.find(".form-line").val((parent.find(".form-qty").val() * parent.find(".form-cost").val()).toFixed(2));
        var total = 0;
        var descuentototal = 0;
        $(".form-desc").removeAttr('disabled');
        $(".form-line").each(function () {
            total += parseFloat($(this).val() || 0);
        });
        $(".form-desc").each(function () {
            descuentototal += parseFloat($(this).val() || 0);
        });
        $(".form-desc").attr('disabled','disabled');
        $("#subtotal").text("$"+total.toFixed(2));
        $("#descuentoT").text("$"+descuentototal.toFixed(2));
        var iva = total*.16;
        $("#iva").text("$"+iva.toFixed(2));
        var totalgeneral = total+iva;
        $("#total").text("$"+totalgeneral.toFixed(2));


    });

function aceptarordenrecarga(idorden) {

        var hook = 'codi_hook';
        var action = 'update';
        var idordenval = idorden;
        
    // AJAX Ordenes
    $.ajax({
        url: apibase + 'ajax/codi_update_taller',
        type: 'POST',
        dataType: 'json',
        cache: false,
        data: {hook,action,idordenval},
        beforeSend: function () {
        }
    }).done(function (res) {

        if (res.status === 200) {
            Swal.fire({
                icon: 'success',
                title: res.msg,
                showConfirmButton: false,
                timer: 5500
            })
            //Wform.trigger('reset');
            location.reload();

        } else {
            Swal.fire({
                icon: 'error',
                title: res.msg,
                showConfirmButton: false,
                timer: 5500
            })
        }
    })
        .fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion. Code:3005',
                showConfirmButton: false,
                timer: 10500
            })
        })
        .always(function () {
            // form.waitMe('hide');
        });
}

function codi_update_baja_danado() {
    var form = $('.codi_update_baja_danado'),
        hook = 'codi_hook',
        action = 'add',
        data = new FormData(form.get(0));
        data.append('hook', hook);
        data.append('action', action);
        data.append('bobservacion', $('#bobservacion').val());
        data.append('bmotivo', $('#bmotivo').val());
        data.append('idordeno', $('#idOrdenO').val());
        data.append('folioorden', $('#FolioOrden').val());
        data.append('idproductoorden', $('#idproductoorden').val());
        data.append('cantidado', $('#cantidadO').val());
        data.append('cantidadeliminar', $('#cantidadEliminar').val());
        data.append('partida', $('#partidaE').val());
        data.append('trNombre', $('#trNombre').val());
        data.append('trSku', $('#trSku').val());
        data.append('trPreciocosto', $('#trPreciocosto').val());
        data.append('trPrecioventa', $('#trPrecioventa').val());
        data.append('trExistencia', $('#trExistencia').val());
        data.append('trCategoria', $('#trCategoria').val());
        data.append('trAlmId', $('#trAlmId').val());
        data.append('trImagen', $('#trImagen').val());
        data.append('trAlmacen', 4);
        data.append('trUsuario', $('#trUsuario').val());
        data.append('trPassword', $('#trPassword').val());
        
    // AJAX Ordenes
    $.ajax({
        url: apibase + 'ajax/codi_update_baja_danado',
        type: 'POST',
        dataType: 'json',
        contentType: false,
        processData: false,
        cache: false,
        data: data,
        beforeSend: function () {
        }
    }).done(function (res) {

        if (res.status === 201) {
            Swal.fire({
                icon: 'success',
                title: res.msg,
                showConfirmButton: false,
                timer: 5500
            })
            //Wform.trigger('reset');
            window.location.href = "";

        } else {
            Swal.fire({
                icon: 'error',
                title: res.msg,
                showConfirmButton: false,
                timer: 5500
            })
        }
    })
        .fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion. Code:3005',
                showConfirmButton: false,
                timer: 10500
            })
        })
        .always(function () {
            // form.waitMe('hide');
        });
}

function enviaramoroso(){
    var cliente = $("#idUcliente").val();
    var valcheck = $("#moroso").is(":checked");
    var moroso = 0;
    var hook = 'codi_hook';
    var action = 'update';
    if (valcheck == true) {
        moroso = 1;
    }

    // AJAX Usuarios Get
    $.ajax({
        url: apibase + 'ajax/codi_update_moroso',
        type: 'POST',
        dataType: 'json',
        cache: false,
        data: { hook, action, cliente, moroso},
        beforeSend: function () {

        }
    }).done(function (res) {
        if (res.status === 201) {
            Swal.fire({
                icon: 'success',
                title: res.msg,
                showConfirmButton: false,
                timer: 5500
            })
            //Wform.trigger('reset');
            window.location.href = "";
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion',
                showConfirmButton: false,
                timer: 1500
            })

        }
    })
        .fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion. Código: 3003',
                showConfirmButton: false,
                timer: 1500
            })
            wrapper.html('');
        })
        .always(function () {

        });

}

//------------------------------------------------------------------------------
$(document).ready(function () {

    //Obtener Moviemientos
    codi_get_detalleorden();
    codi_get_almacen_select();
    codi_get_productos_almacen_select();

    sleep(1500).then(() => {
        $('#proAlmacen').val(1).trigger('change');
    });

    $('#bajaExtintorForm').on('show.bs.modal', function (event) {
        var button = $(event.relatedTarget) // Button that triggered the modal
        var ce = button.data('claveextintor');
        var ie = button.data('idextintor');
        // If necessary, you could initiate an AJAX request here (and then do the updating in a callback).
        // Update the modal's content. We'll use jQuery here, but you could use a data binding library or other methods instead.
        var modal = $(this)
        modal.find('#BClaveExtintor').val(ce)
        modal.find('#BIdExtintor').val(ie)
    })

    $('#bajaDanadoForm').on('show.bs.modal', function (event) {
        var button = $(event.relatedTarget) // Button that triggered the modal
        var idOrden = button.data('idordeno');
        var productoid = button.data('productoid');
        var cantidaddanado = button.data('cantidaddanado');
        var nombre = button.data('nombre');
        var partida = button.data('partida');
        var precioventa = button.data('precioventa');
        var proalmid = button.data('proalmid');
        var propreciocosto = button.data('propreciocosto');
        var sku = button.data('sku');
        var proexistencia = button.data('proexistencia');
        var procatId = button.data('procatId');
        var proimagen = button.data('proimagen');
        // If necessary, you could initiate an AJAX request here (and then do the updating in a callback).
        // Update the modal's content. We'll use jQuery here, but you could use a data binding library or other methods instead.
        var modal = $(this)
        modal.find('#tituloPbaja').text("¿Está seguro que desea dar de baja el producto "+ nombre +"?");
        modal.find('#idproductoorden').val(productoid);
        modal.find('#cantidadO').val(cantidaddanado);
        modal.find('#idOrdenO').val(idOrden);
        modal.find('#partidaE').val(partida);
        modal.find('#trNombre').val(nombre);
        modal.find('#trSku').val(sku);
        modal.find('#trPreciocosto').val(propreciocosto);
        modal.find('#trPrecioventa').val(precioventa);
        modal.find('#trExistencia').val(proexistencia);
        modal.find('#trCategoria').val(procatId);
        modal.find('#trAlmId').val(proalmid);
        modal.find('#trImagen').val(proimagen);
        
        let cantidadEliminar = $('#cantidadEliminar');
        for(i=0;i<cantidaddanado;i++){
            var optionvalue = i+1;
            var option = document.createElement('option');
            option.value = optionvalue;
            option.text = optionvalue;
            cantidadEliminar.append(option);
        }
    })

    cambiartipo();
    mostrardivbotoncred();
    mostrarGenerarComprobante();
})