var apibase = "https://grupoxtinfire.com/admin/";

$(document).ready(function () {

    //Obtener Moviemientos
    codi_get_cotizacionesv2();

    function codi_get_cotizaciones() {
        var wrapper = $('.tabla_wrapper_cotizaciones'),
            hook = 'codi_hook',
            action = 'load';


        // AJAX Usuarios Get
        $.ajax({
            url: apibase + 'ajax/codi_get_cotizaciones',
            type: 'POST',
            dataType: 'json',
            cache: false,
            data: { hook, action },
            beforeSend: function () {

            }
        }).done(function (res) {
            if (res.status === 200) {
                wrapper.html(res.data);
                var table = $('.datatable-init').DataTable({
                    responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    pageLength: 50,
                    lengthMenu: [ [10, 25, 50, 75, 100, -1], [10, 25, 50,75, 100, "Mostrar Todos"]],
                    dom: 'Blfrtip',
                    buttons: ['copy', 'excel', 'csv', 'pdf'],
                    language: {
                        url: 'https://cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json'
                    },
                    initComplete: function() {
            this.api().columns([2,4]).every(function() {
                var column = this;

                var select = $('<select class="form-control"><option value="">Seleccionar</option></select>')
                    .appendTo($(column.header()))
                    .on('change', function() {
                        var val = $.fn.dataTable.util.escapeRegex(
                            $(this).val()
                        );
                         
                            column
                            .search(val ? '^' + val + '$' : '', true, false)
                            .draw();
                        
                        
                    });
                    //Este codigo sirve para que no se active el ordenamiento junto con el filtro
                $(select).click(function(e) {
                    e.stopPropagation();
                });
                //===================

                column.data().unique().sort().each(function(d, j) {
                    // select.append('<option value="' + d + '">' + d + '</option>')
                        d = d.replace( /(<([^>]+)>)/ig, '');
                        select.append('<option value="' + d + '">' + d + '</option>')
                    
                });

                

            });
        },
                    "order": [[0, 'desc']],
                });

                new $.fn.dataTable.FixedHeader( table );

            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion',
                    showConfirmButton: false,
                    timer: 1500
                })
                wrapper.html('');

            }
        })
            .fail(function (err) {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion' + err,
                    showConfirmButton: false,
                    timer: 1500
                })
                wrapper.html('');
            })
            .always(function () {

            });

    }


    function codi_get_cotizacionesv2() {

        var wrapper = $('.tabla_wrapper_cotizaciones'),
            hook = 'codi_hook',
            action = 'load';
            var formato = new Intl.NumberFormat('es-MX', {
        style: 'currency',
        currency: 'MXN',
    });
            var table = $('.datatable-init').DataTable({
                "searching" : true,
                "processing": true,
                "serverSide": true,
                "responsive": true,
                "dom": 'Blfrtip',
        "orderCellsTop": true,
        "fixedHeader": true,
        language: {
          url: 'https://cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json'
        },
                columns: [
                    { data: "IdCotizacion" },
                    { data: "Fecha" },
                    { data: "NombreEstatus" ,"mRender": function(data, type, value) {
                         var nombreestatus = value['NombreEstatus'];
                         var color = "bg-success";
                         if(nombreestatus == "Pendiente por Convertir"){
                            color = "bg-warning"
                         }
                        return `<span class="badge rounded-pill ${color}">${value['NombreEstatus']}</span>`;
                    } },
                    { data: "DeptoDescripcion" },
                    { data: "Usuario" },
                    { data: "Nombre" },
                    { data: "Items" },
                    { data: "Descuento" ,"mRender": function(data, type, value) {
                        return `<span class="text-danger">${formato.format(parseFloat(value['Descuento'],2).toFixed(2))}</span>`;
                    } },
                    { data: "TotalCotizacion" ,"mRender": function(data, type, value) {
                        return `<span class="text-danger">${formato.format(parseFloat((value['TotalCotizacion'] * 1.16),2).toFixed(2))}</span>`;
                    } },
                    { data: "Acción", bSortable:false,"mRender": function(data, type, value) {
            return `<ul class="nk-tb-actions gx-1 my-n1 text-center">
                    <li class="me-n1 text-center">
                        <div class="dropdown">
                            <a href="#" class="dropdown-toggle btn btn-icon btn-trigger" data-bs-toggle="dropdown"><em class="icon ni ni-more-h"></em></a>
                            <div class="dropdown-menu dropdown-menu-end">
                                <ul class="link-list-opt no-bdr">
                                    <li><a href="cotizaciones/detalle/${value['IdCotizacion']}"><em class="icon ni ni-eye"></em><span>Ver Cotización</span></a></li>
                                    <li><a href="#" data-bs-toggle="modal" data-bs-target="#modalAlert2" data-idclte="${value["IdCotizacion"]}" data-idvendedor="${value["IdUsuario"]}" data-foliocotizacion="${value["FolioCotizacion"]}"><em class="icon ni ni-trash"></em><span>Eliminar Cotización</span></a></li>
                                </ul>
                            </div>
                        </div>
                    </li>
                </ul>`;
        } }
                    ],
                "columnDefs": [{
            "targets": [9],
            "data": null,
            "defaultContent":
             `<ul class="nk-tb-actions gx-1 my-n1 text-center">
                    <li class="me-n1 text-center">
                        <div class="dropdown">
                            <a href="#" class="dropdown-toggle btn btn-icon btn-trigger" data-bs-toggle="dropdown"><em class="icon ni ni-more-h"></em></a>
                            <div class="dropdown-menu dropdown-menu-end">
                                <ul class="link-list-opt no-bdr">
                                    <li><a href="#" data-bs-toggle="modal" data-bs-target="#editForm" data-idcliente="<?php echo $clte->IdCliente; ?>" data-clave="<?php echo $clte->Clave; ?>" data-persona="<?php echo $clte->Persona; ?>" data-cfdi="<?php echo $clte->CFDI; ?>" data-regimenfiscal="<?php echo $clte->RegimenFiscal; ?>" data-tipopago="<?php echo $clte->TipoPago; ?>" data-nombre="<?php echo $clte->Nombre; ?>" data-rfc="<?php echo $clte->RFC; ?>" data-fistelefono="<?php echo $clte->FisTelefono; ?>" data-fisemail="<?php echo $clte->FisEmail; ?>" data-fiscalle="<?php echo $clte->FisCalle; ?>" data-fisnext="<?php echo $clte->FisNExt; ?>" data-fisnint="<?php echo $clte->FisNInt; ?>" data-fiscolonia="<?php echo $clte->FisColonia; ?>" data-fiscp="<?php echo $clte->FisCP; ?>" data-fismunicipio="<?php echo $clte->FisMunicipio; ?>" data-fisestado="<?php echo $clte->FisEstado; ?>" data-iddomicilio="<?php echo $clte->IdDomicilio; ?>" data-entcalle="<?php echo $clte->EntCalle; ?>" data-entnext="<?php echo $clte->EntNExt; ?>" data-entnint="<?php echo $clte->EntNInt; ?>" data-entcolonia="<?php echo $clte->EntColonia; ?>" data-entcp="<?php echo $clte->EntCP; ?>" data-entmunicipio="<?php echo $clte->EntMunicipio; ?>" data-entestado="<?php echo $clte->EntEstado; ?>" data-entgiro="<?php echo $clte->EntGiro; ?>" data-entdesde="<?php echo $clte->EntDesde; ?>" data-enthasta="<?php echo $clte->EntHasta; ?>" data-entcruces="<?php echo $clte->EntCruces; ?>" data-entobservaciones="<?php echo $clte->EntObservaciones; ?>"><em class="icon ni ni-edit"></em><span>Editar Cliente</span></a></li>
                                    <!--<li><a href="#"><em class="icon ni ni-eye"></em><span>Ver Cliente</span></a></li>-->
                                    <li><a href="#" data-bs-toggle="modal" data-bs-target="#modalAlert2" data-idclte="<?php echo $clte->IdCliente; ?>" data-nombre="<?php echo $clte->Nombre; ?>"><em class="icon ni ni-trash"></em><span>Eliminar Cliente</span></a></li>
                                </ul>
                            </div>
                        </div>
                    </li>
                </ul>`
          }],
          "buttons": [
          'copy', 'csv', 'excel', 'pdf'
        ],
        "order": [[1, 'desc']],
        "lengthMenu": [
          [50, 100, 200, -1],
          ['50', '100', '200', 'Mostrar todo']
        ],
                "ajax":{
                    "url": 'ajax/codi_get_cotizaciones2',
                    "type": 'POST',
                    'data' : { 'hook' : hook, 'action':action },
                    'dataFilter': function (json) {
                        var resultado = JSON.parse(json);
                        var data = resultado.data;
                        console.log(data)
                        return data;
                    }.bind(this)
                    
                }
            });

           
    }



    $('#modalAlert2').on('show.bs.modal', function (event) {
        var button = $(event.relatedTarget) // Button that triggered the modal
        var id = button.data('idclte');
        var fc = button.data('foliocotizacion');
        var idvendedorphp = button.data('idvendedor');
        var idvendedorinput = $("#vendor").val();
        console.log("soy el vendedor de php :" + idvendedorphp);
        console.log("soy el vendedor de input :" + idvendedorinput);
        if(idvendedorphp != idvendedorinput){
            $('#eli').attr("disabled", 'disabled');
            $("#textvendedor").text("No puedes eliminar una cotización que no creaste si es necesario eliminarla revísalo con tu Gerente de Ventas");
        }
        // If necessary, you could initiate an AJAX request here (and then do the updating in a callback).
        // Update the modal's content. We'll use jQuery here, but you could use a data binding library or other methods instead.
        var modal = $(this)
        modal.find('#idCotizacion').val(id)
        modal.find('#EFolioCotizacion').text(fc)
    })

    //Eliminar Moviemiento
    $('.codi_delete_cotizacion').on('click', codi_delete_cotizacion);
    function codi_delete_cotizacion(event) {
        event.preventDefault();
        var idUsuario = $('#idCotizacion').val()
        console.log(idUsuario)
        var form = $('.codi_delete_cotizacion'),
            hook = 'codi_hook',
            action = 'update',
            data = new FormData();
        data.append('hook', hook);
        data.append('action', action);
        data.append('activo', 400);
        data.append('idCotizacion', idUsuario)
        /*for (var pair of data.entries()) {
            console.log(pair[0]+ ', ' + pair[1]); 
        }*/
        // AJAX Usuarios
        $.ajax({
            url: 'ajax/codi_delete_cotizacion',
            type: 'POST',
            dataType: 'json',
            contentType: false,
            processData: false,
            cache: false,
            data: data,
            beforeSend: function () {
                // form.waitMe();
            }
        }).done(function (res) {
            if (res.status === 200) {
                Swal.fire({
                    icon: 'success',
                    title: res.msg,
                    showConfirmButton: false,
                    timer: 1500
                })
                form.trigger('reset');
                window.location.reload()
            } else {
                Swal.fire({
                    icon: 'error',
                    title: res.msg,
                    showConfirmButton: false,
                    timer: 1500
                })
            }
        })
            .fail(function (err) {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion'.err,
                    showConfirmButton: false,
                    timer: 1500
                })
            })
            .always(function () {
                // form.waitMe('hide');
            });

    }

})