var apibase = "https://grupoxtinfire.com/admin/";

function codi_get_producto(select) {
    var proId = select.value;
    console.log(proId)
    wrapper = $('.wrapper_insert_productos'),
        hook = 'codi_hook',
        action = 'load';

    // AJAX Usuarios Get
    $.ajax({
        url: apibase + 'ajax/codi_get_producto',
        type: 'POST',
        dataType: 'json',
        cache: false,
        data: { hook, action, proId: proId },
        beforeSend: function () {

        }
    }).done(function (res) {
        if (res.status === 200) {
            console.log(res)
            var IdProducto = res.data.proId;
            var PrecioVenta = res.data.proPrecioventa;
            codi_add_detalleorden(IdProducto, PrecioVenta)
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion',
                showConfirmButton: false,
                timer: 1500
            })
        }
    }).fail(function (err) {
        Swal.fire({
            icon: 'error',
            title: 'Hubo un error en la peticion' + err,
            showConfirmButton: false,
            timer: 1500
        })
    }).always(function () {

    });
}

function codi_add_detalleorden(IdProducto, PrecioVenta) {
    var IdOrden = $('#IdOrden').val();
    var FolioOrden = $('#FolioOrden').val();
    var Partida = "0";
    var Cantidad = "1";

    wrapper = $('.wrapper_insert_productos'),
        hook = 'codi_hook',
        action = 'load';

    // AJAX Usuarios Get
    $.ajax({
        url: apibase + 'ajax/codi_add_detalleorden',
        type: 'POST',
        dataType: 'json',
        cache: false,
        data: {
            hook, action,
            IdOrden: IdOrden,
            FolioOrden: FolioOrden,
            Partida: Partida,
            IdProducto: IdProducto,
            Cantidad: Cantidad,
            PrecioVenta: PrecioVenta,
        },
        beforeSend: function () {

        }
    }).done(function (res) {
        if (res.status === 201) {
            console.log(res)
            codi_get_detalleorden();
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion',
                showConfirmButton: false,
                timer: 1500
            })
        }
    }).fail(function (err) {
        Swal.fire({
            icon: 'error',
            title: 'Hubo un error en la peticion' + err,
            showConfirmButton: false,
            timer: 1500
        })
    }).always(function () {

    });
}

function codi_get_detalleorden() {
    var wrapper = $('.tabla_wrapper_detalleorden'),
        hook = 'codi_hook',
        action = 'load';
    var IdOrden = $('#IdOrden').val();

    // AJAX Usuarios Get
    $.ajax({
        url: apibase + 'ajax/codi_get_detalleorden',
        type: 'POST',
        dataType: 'json',
        cache: false,
        data: { hook, action, IdOrden: IdOrden },
        beforeSend: function () {

        }
    }).done(function (res) {
        if (res.status === 200) {
            wrapper.html(res.data);
            $('.datatable-init').DataTable({
                responsive: true,
                orderCellsTop: true,
                fixedHeader: true,
                dom: 'Blfrtip',
                buttons: ['copy', 'excel', 'csv', 'pdf'],
                language: {
                    url: 'https://cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json'
                }
            });
            botones();
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion',
                showConfirmButton: false,
                timer: 1500
            })
            wrapper.html('');

        }
    })
        .fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion' + err,
                showConfirmButton: false,
                timer: 1500
            })
            wrapper.html('');
        })
        .always(function () {

        });

}

function botones() {
    //botones
    var plus = document.querySelectorAll("[data-number='plus']");
    var minus = document.querySelectorAll("[data-number='minus']");
    
    plus.forEach(function (item, index, arr) {
        var parent = plus[index].parentNode;
        plus[index].addEventListener("click", function () {
            var child = plus[index].parentNode.children;
            child.forEach(function (item, index, arr) {
                if (child[index].classList.contains("number-spinner")) {
                    var value = !child[index].value == "" ? parseInt(child[index].value) : 0;
                    var step = !child[index].step == "" ? parseInt(child[index].step) : 1;
                    var max = !child[index].max == "" ? parseInt(child[index].max) : Infinity;
                    if (max + 1 > value + step) {
                        child[index].value = value + step;
                    } else {
                        child[index].value = value;
                    }
                }
            });
        });
    });
    minus.forEach(function (item, index, arr) {
        var parent = minus[index].parentNode;
        minus[index].addEventListener("click", function () {
            var child = minus[index].parentNode.children;
            child.forEach(function (item, index, arr) {
                if (child[index].classList.contains("number-spinner")) {
                    var value = !child[index].value == "" ? parseInt(child[index].value) : 0;
                    var step = !child[index].step == "" ? parseInt(child[index].step) : 1;
                    var min = !child[index].min == "" ? parseInt(child[index].min) : 0;
                    if (min - 1 < value - step) {
                        child[index].value = value - step;
                    } else {
                        child[index].value = value;
                    }
                }
            });
        });
    });
    //botones
}

$(document).ready(function () {

    //Obtener Moviemientos
    codi_get_detallecompra();

    codi_get_compras_select();
    function codi_getcompras_select() {
        var wrapper = $('.select_wrapper_compras'),
            hook = 'codi_hook',
            action = 'load';


        // AJAX Usuarios Get
        $.ajax({
            url: apibase + 'ajax/codi_getcompras_select',
            type: 'POST',
            dataType: 'json',
            cache: false,
            data: { hook, action },
            beforeSend: function () {

            }
        }).done(function (res) {
            if (res.status === 200) {
                wrapper.html(res.data);
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion',
                    showConfirmButton: false,
                    timer: 1500
                })
                wrapper.html('');

            }
        })
            .fail(function (err) {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion' + err,
                    showConfirmButton: false,
                    timer: 1500
                })
                wrapper.html('');
            })
            .always(function () {

            });

    }
})