var apibase = "https://grupoxtinfire.com/admin/";

function codi_get_producto(select) {
    var proId = select.value;
    console.log(proId)
    wrapper = $('.wrapper_insert_productos'),
        hook = 'codi_hook',
        action = 'load';

    // AJAX Usuarios Get
    $.ajax({
        url: apibase + 'ajax/codi_get_producto',
        type: 'POST',
        dataType: 'json',
        cache: false,
        data: { hook, action, proId: proId },
        beforeSend: function () {

        }
    }).done(function (res) {
        if (res.status === 200) {
            console.log(res)
            var IdProducto = res.data.proId;
            var PrecioVenta = res.data.proPrecioventa;
            codi_add_detallecotizacion(IdProducto, PrecioVenta)
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion',
                showConfirmButton: false,
                timer: 1500
            })
        }
    }).fail(function (err) {
        Swal.fire({
            icon: 'error',
            title: 'Hubo un error en la peticion' + err,
            showConfirmButton: false,
            timer: 1500
        })
    }).always(function () {

    });
}

function agregarleido(){
    var IdOrden = $("#IdCotizacion").val();
    var valcheck = $("#leidocheck").is(":checked");
    console.log(valcheck)
    var departamento = $("#Utransitooriginal").val();
    var leido = 0;
    var hook = 'codi_hook';
    var action = 'update';
    if (valcheck == false) {
        leido = 1;
    }

 
    // AJAX Usuarios Get
    $.ajax({
        url: apibase + 'ajax/codi_update_leido',
        type: 'POST',
        dataType: 'json',
        cache: false,
        data: { hook, action, IdOrden, leido, departamento},
        beforeSend: function () {

        }
    }).done(function (res) {
        if (res.status === 201) {
            Swal.fire({
                icon: 'success',
                title: res.msg,
                showConfirmButton: false,
                timer: 5500
            })
            //Wform.trigger('reset');
            //window.location.href = "";
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion',
                showConfirmButton: false,
                timer: 1500
            })

        }
    })
        .fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion. Código: 3003',
                showConfirmButton: false,
                timer: 1500
            })
            wrapper.html('');
        })
        .always(function () {

        });

}


function aceptarordenrecarga(){
    var hook = 'codi_hook',
        action = 'update';
    var IdCotizacion = $("#IdCotizacion").val();
    var loadin = $(".loadin");
    $.ajax({
        url: apibase + 'ajax/codi_update_aceptar_taller_cotizacion',
        type: 'POST',
        dataType: 'json',
        cache: false,
        data: {
            hook, action, IdCotizacion
        },
        beforeSend: function () {
            loadin.waitMe();
        }
    }).done(function (res) {
        if (res.status === 200) {
            Swal.fire({
                icon: 'success',
                title: 'Orden aceptada por taller',
                showConfirmButton: false,
                timer: 1500
            })
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion',
                showConfirmButton: false,
                timer: 1500
            })
        }
    }).fail(function (err) {
        Swal.fire({
            icon: 'error',
            title: 'Hubo un error en la peticion' + err,
            showConfirmButton: false,
            timer: 1500
        })
    }).always(function () {
        loadin.waitMe('hide');
        location.reload();

    });
}

function terminarordenrecarga(){
    var hook = 'codi_hook',
        action = 'update';
    var IdCotizacion = $("#IdCotizacion").val();
    var loadin = $(".loadin");
    $.ajax({
        url: apibase + 'ajax/codi_update_terminar_taller_cotizacion',
        type: 'POST',
        dataType: 'json',
        cache: false,
        data: {
            hook, action, IdCotizacion
        },
        beforeSend: function () {
            loadin.waitMe();
        }
    }).done(function (res) {
        if (res.status === 200) {
            Swal.fire({
                icon: 'success',
                title: 'Orden terminada por taller',
                showConfirmButton: false,
                timer: 1500
            })
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion',
                showConfirmButton: false,
                timer: 1500
            })
        }
    }).fail(function (err) {
        Swal.fire({
            icon: 'error',
            title: 'Hubo un error en la peticion' + err,
            showConfirmButton: false,
            timer: 1500
        })
    }).always(function () {
        loadin.waitMe('hide');
        location.reload();

    });
}

function actualizarfecha(){
    var hook = 'codi_hook',
        action = 'update';
    var IdCotizacion = $("#IdCotizacion").val();
    var loadin = $(".loadin");
    // AJAX Usuarios Get
    $.ajax({
        url: apibase + 'ajax/codi_update_fecha_cotizacion',
        type: 'POST',
        dataType: 'json',
        cache: false,
        data: {
            hook, action,
            IdCotizacion: IdCotizacion
        },
        beforeSend: function () {
            loadin.waitMe();
        }
    }).done(function (res) {
        if (res.status === 200) {
            Swal.fire({
                icon: 'success',
                title: 'Se actualizo la fecha al dia de hoy',
                showConfirmButton: false,
                timer: 1500
            })
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion',
                showConfirmButton: false,
                timer: 1500
            })
        }
    }).fail(function (err) {
        Swal.fire({
            icon: 'error',
            title: 'Hubo un error en la peticion' + err,
            showConfirmButton: false,
            timer: 1500
        })
    }).always(function () {
        loadin.waitMe('hide');
        location.reload();

    });

}


function codi_get_cotizacionevento(select, modo) {
    console.log("Si entre a la get ordne")
    var IdCotizacion = select;
    var wrapper = "wrapper",
        hook = 'codi_hook',
        action = 'load';
     if(IdCotizacion == '' || IdCotizacion == undefined || IdCotizacion == null){
        return;
     }
    // AJAX Usuarios Get
    $.ajax({
        url: apibase + 'ajax/codi_get_cotizacionevento',
        type: 'POST',
        dataType: 'json',
        cache: false,
        data: { hook, action, IdCotizacion },
        beforeSend: function () {

        }
    }).done(function (res) {
        console.log(res)
        if (res.status === 200) {
            var domiciliocom = "Calle " + res.data.EntCalle + " #" + res.data.EntNExt + " Colonia " + res.data.EntColonia +
                " C.P." + res.data.EntCP + " " + res.data.EntMunicipio + ", " + res.data.EntEstado

            if (modo == 'UPDATE') {
                $('#UIdOrden').val(res.data.IdCotizacion)
                $('#UIdCliente').val(res.data.IdCliente)
                $('#UIdDomicilio').val(res.data.IdDomicilio)
                $('#UNombre').text(res.data.Nombre)
                $('#UFisEmail').text(res.data.FisEmail)
                $('#UFisTelefono').text(res.data.FisTelefono)
                $('#UDomicilio').text(domiciliocom)
                $('#UEntCruces').text(res.data.EntCruces)
                $('#UEntObservaciones').text(res.data.EntObservaciones)
            } else {
                $('#IIdOrden').val(res.data.IdCotizacion)
                $('#IIdCliente').val(res.data.IdCliente)
                $('#IIdDomicilio').val(res.data.IdDomicilio)
                $('#INombre').text(res.data.Nombre)
                $('#IFisEmail').text(res.data.FisEmail)
                $('#IFisTelefono').text(res.data.FisTelefono)
                $('#IDomicilio').text(domiciliocom)
                $('#IEntCruces').text(res.data.EntCruces)
                $('#IEntObservaciones').text(res.data.EntObservaciones)
            }

        } else {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion',
                showConfirmButton: false,
                timer: 1500
            })
        }
    }).fail(function (err) {
        Swal.fire({
            icon: 'error',
            title: 'Hubo un error en la peticion' + err,
            showConfirmButton: false,
            timer: 1500
        })
    }).always(function () {

    });
}

function codi_get_vendedores_select() {
    var wrapper = $('.select_wrapper_vendedores'),
        hook = 'codi_hook',
        action = 'load';
    var IdVendedor = $("#IdVendedor").val();

    // AJAX Usuarios Get
    $.ajax({
        url: apibase + 'ajax/codi_get_vendedores_select',
        type: 'POST',
        dataType: 'json',
        cache: false,
        data: { hook, action },
        beforeSend: function () {

        }
    }).done(function (res) {
        if (res.status === 200) {
            wrapper.html(res.data);
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion',
                showConfirmButton: false,
                timer: 1500
            })
            wrapper.html('');

        }

        $("#IVendedor").val(IdVendedor).trigger('change');
    })
        .fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion' + err,
                showConfirmButton: false,
                timer: 1500
            })
            wrapper.html('');
        })
        .always(function () {

        });

}

function codi_get_instructores_select() {
    var wrapper = $('.select_wrapper_instructores'),
        hook = 'codi_hook',
        action = 'load';


    // AJAX Usuarios Get
    $.ajax({
        url: apibase + 'ajax/codi_get_instructores_select',
        type: 'POST',
        dataType: 'json',
        cache: false,
        data: { hook, action },
        beforeSend: function () {

        }
    }).done(function (res) {
        if (res.status === 200) {
            wrapper.html(res.data);
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion',
                showConfirmButton: false,
                timer: 1500
            })
            wrapper.html('');
        }
    })
        .fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion' + err,
                showConfirmButton: false,
                timer: 1500
            })
            wrapper.html('');
        })
        .always(function () {

        });

}

function select_wrapper_partidas() {
    var wrapper = $('.select_wrapper_partidas'),
        hook = 'codi_hook',
        action = 'load';
    var IdCotizacion = $("#UIdCotizacion").val();
 

    // AJAX Usuarios Get
    $.ajax({
        url: apibase + 'ajax/codi_get_partidas_select',
        type: 'POST',
        dataType: 'json',
        cache: false,
        data: { hook, action, IdCotizacion },
        beforeSend: function () {

        }
    }).done(function (res) {
        if (res.status === 200) {
            console.log(res)
            wrapper.html(res.data);
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion',
                showConfirmButton: false,
                timer: 1500
            })
            wrapper.html('');
        }
    })
        .fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion' + err,
                showConfirmButton: false,
                timer: 1500
            })
            wrapper.html('');
        })
        .always(function () {

        });

}

function enviarwhats(key,orden){
    var telefono = $("#telcliente").val();
    var tel = "52"+telefono;
    var men = $("#mensaje").val();
    var mensaje = "https://wa.me/"+telefono+"?text="+men + " https://grupoxtinfire.com/admin/ordenes/aceptar_orden/0/"+key+"/"+orden + " . Para poder ver la cotización en pdf de clic en el siguiente enlace: https://grupoxtinfire.com/admin/pdf/pdfcotizacion/"+orden;
    mensaje.replace(" ","%20");
    var cabecera = "grupoxtinfire orden : "+ orden;
    try {
        window.open(mensaje,cabecera, "width=1024, height=768");
    }catch(err){
        console.log(err)
    }
    
}


function enviarmail(key,orden){
    var mailspricipal = $("#mailcliente").val();
    var mailcc = $("#ccmails").val();
    var men = $("#mensaje").val();
    var mensaje = men+ " https://grupoxtinfire.com/admin/ordenes/aceptar_orden/0/"+key+"/"+orden + " . Para poder ver la cotización en pdf de clic en el siguiente enlace: https://grupoxtinfire.com/admin/pdf/pdfcotizacion/"+orden;
        console.log(mensaje)
    try {
        window.open("mailto:"+mailspricipal+'?cc='+mailcc+'&subject=Cotización '+orden+' Grupoxtinfire&body='+mensaje);
    }catch(err){
        console.log(err)
    }
    
}

function codi_add_detallecotizacion(IdProducto, PrecioVenta) {
    var IdCotizacion = $('#IdCotizacion').val();
    var FolioCotizacion = $('#FolioCotizacion').val();
    var Partida = "0";
    var Cantidad = "1";

    wrapper = $('.wrapper_insert_productos'),
        hook = 'codi_hook',
        action = 'load';

    // AJAX Usuarios Get
    $.ajax({
        url: apibase + 'ajax/codi_add_detallecotizacion',
        type: 'POST',
        dataType: 'json',
        cache: false,
        data: {
            hook, action,
            IdCotizacion: IdCotizacion,
            FolioCotizacion: FolioCotizacion,
            Partida: Partida,
            IdProducto: IdProducto,
            Cantidad: Cantidad,
            PrecioVenta: PrecioVenta,
        },
        beforeSend: function () {

        }
    }).done(function (res) {
        if (res.status === 201) {
            console.log(res)
            codi_get_detallecotizacion();
            setTimeout(() => {
                  codi_update_cotizacion();
                }, 4000);
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion',
                showConfirmButton: false,
                timer: 1500
            })
        }
    }).fail(function (err) {
        Swal.fire({
            icon: 'error',
            title: 'Hubo un error en la peticion' + err,
            showConfirmButton: false,
            timer: 1500
        })
    }).always(function () {

    });
}

function subirFile2(){
    var imagencontenedor = $("#pdfdocumentopago");
    var idc = $("#IdCotizacion").val();
    var hook = 'codi_hook',
        action = 'add';
        var loadin = $(".loadin");
    var data = new FormData(imagencontenedor.get(0));
    data.append("hook",hook);
    data.append("idc",idc);
    data.append("action",action);

    $.ajax({
        url: apibase + 'ajax/codi_add_factura_orden_pago_cotizacion',
        type: 'POST',
        dataType: 'json',
        contentType: false,
        processData: false,
        cache: false,
        data: data,
        beforeSend: function () {
            loadin.waitMe();
        }
    }).done(function (res) {
        if (res.status === 201) {
            Swal.fire({
                icon: 'success',
                title: res.msg,
                showConfirmButton: false,
                timer: 5500
            })
            window.location.reload();

        } else {
            Swal.fire({
                icon: 'error',
                title: res.msg,
                showConfirmButton: false,
                timer: 5500
            })
        }
    })
        .fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion',
                showConfirmButton: false,
                timer: 5500
            })
        }).always(function () {
                loadin.waitMe("hide");
            });
}

function codi_get_detallecotizacion() {
    var wrapper = $('.tabla_wrapper_detallecotizacion'),
        hook = 'codi_hook',
        action = 'load';
    var IdCotizacion = $('#IdCotizacion').val();
    var codicod = $(".codicod");
    // AJAX Usuarios Get
    $.ajax({
        url: apibase + 'ajax/codi_get_detallecotizacion',
        type: 'POST',
        dataType: 'json',
        cache: false,
        data: { hook, action, IdCotizacion: IdCotizacion },
        beforeSend: function () {
            codicod.waitMe();
        }
    }).done(function (res) {
        if (res.status === 200) {

            wrapper.html(res.data);
            $('.datatable-init').DataTable({
                responsive: true,
                orderCellsTop: true,
                fixedHeader: true,
                dom: 'Blfrtip',
                buttons: ['copy', 'excel', 'csv', 'pdf'],
                language: {
                    url: 'https://cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json'
                }
            });
            calcular_total();
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion',
                showConfirmButton: false,
                timer: 1500
            })
            wrapper.html('');

        }
    })
        .fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion' + err,
                showConfirmButton: false,
                timer: 1500
            })
            wrapper.html('');
        })
        .always(function () {
            codicod.waitMe('hide');
        });

}

function cursospref(){
    var hook = 'codi_hook',
        action = 'load';
    var IdCotizacion = $('#IdCotizacion').val();
    var textocursos = $("#textocursos").val();
    var codicod = $(".codicod");
    var alimentosli = 0; //alimentos
    var transporteli = 0; //transporte
    var dc3li = 0; //dc3
        
    if($("#alimentos").is(':checked')) { 
        alimentosli = 1;
    }
    if($("#transporte").is(':checked')){
        transporteli = 1;
    }
    if($("#dc3").is(':checked')){
        dc3li = 1; 
    }
    // AJAX Usuarios Get
    $.ajax({
        url: apibase + 'ajax/codi_update_prefcursos_cot',
        type: 'POST',
        dataType: 'json',
        cache: false,
        data: { hook, action, IdCotizacion, alimentosli, transporteli, dc3li, textocursos},
        beforeSend: function () {
            codicod.waitMe();
        }
    }).done(function (res) {
        if (res.status === 200) {
            Swal.fire({
                icon: 'success',
                title: 'Curso actualizado correctamente',
                showConfirmButton: false,
                timer: 1500
            })
            location.reload();
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion',
                showConfirmButton: false,
                timer: 1500
            })
        }
    })
        .fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion' + err,
                showConfirmButton: false,
                timer: 1500
            })
        })
        .always(function () {
            codicod.waitMe('hide');
        });
}

function codi_update_cotizacion() {
    //event.preventDefault();

    //Detalle de la cotizacion
    var filas = [];
    var i = 1;
    $('#tbl_cotizacion tbody tr').each(function () {
        var id = $(this).find('td').eq(0).text();
        var clave = $(this).find('td').eq(1).text();
        var descripcion = $(this).find('td').eq(2).text();
        var existencia = $(this).find('td').eq(3).text();
        var disponibles = $(this).find('td').eq(5).text();
        var precio = $(this).find('td').eq(6).find('input').val();
        precio = precio.replace("$", ""); 
        precio = precio.replace(",","");
        precio = parseFloat(precio);
        var cantidad = $(this).find('td').eq(7).find('input').val();
		var descuento = $(this).find('td').eq(8).find('select').val();
        descuento = descuento.replace("%", ""); 
        var comagenteind = $(this).find('td').eq(8).find('input').val();
        console.log("soy comision pesos" + comagenteind)
        var descuentopesos = $(this).find('td').eq(9).find('input').val();
        descuentopesos = descuentopesos.replace("$", "");
        descuentopesos = descuentopesos.replace(",","");
        descuentopesos = parseFloat(descuentopesos);
		var neto = $(this).find('td').eq(10).find('input').val();
        neto = neto.replace("$", "");
        neto = neto.replace(",","");
        neto = parseFloat(neto);
		var datetentativo = $(this).find('td').eq(11).find('input').val();
        var iddetalle = $(this).find('td').eq(12).text();
        var monto = parseFloat(precio) * parseFloat(cantidad);
        var partida = i;
        
        var fila = {
            id,
            clave,
            descripcion,
            existencia,
            disponibles,
            cantidad,
            precio,
            monto,
            partida,
            iddetalle,
            descuento,
            descuentopesos,
            comagenteind,
            datetentativo,
            neto
        };
        filas.push(fila);
        i++;
    });
    console.log(filas)

    var form = $('.codi_add_cotizacion'),
        hook = 'codi_hook',
        action = 'add',
        data = new FormData(form.get(0));
    var estatus = 1;
    var idcotizacion = $('#UIdCotizacion').val();
    var tipo_orden = $('#tipo_orden').val();
    var tipo_servicio = $('#tipo_servicio').val();
    var FisEmail = $('#FisEmail').val();
    var llaveOrden = $('#llaveOrden').val();
    var llaveOrdenAutorizacion = $('#llaveOrdenAutorizacion').val();
    var autorizacionOrden = $('#autorizacionOrden').val();
    var codicod = $(".codicod");
    console.log("estatus")
    console.log(estatus)

    data.append('hook', hook);
    data.append('action', action);
    data.append('estatus', estatus);
    data.append('idcotizacion', idcotizacion);
    data.append('tipo_orden', tipo_orden);
    data.append('tipo_servicio', tipo_servicio);
    data.append('FisEmail', FisEmail);
    data.append('llaveOrden', llaveOrden);
    data.append('llaveOrdenAutorizacion', llaveOrdenAutorizacion);
    data.append('autorizacionOrden', autorizacionOrden);
    data.append('productos', JSON.stringify(filas));

    console.log(data)

    // AJAX Usuarios
    $.ajax({
        url: apibase + 'ajax/codi_update_cotizacion',
        type: 'POST',
        dataType: 'json',
        contentType: false,
        processData: false,
        cache: false,
        data: data,
        beforeSend: function () {
            codicod.waitMe();
        }
    }).done(function (res) {
        if (res.status === 200) {
            Swal.fire({
                icon: 'success',
                title: res.msg,
                showConfirmButton: false,
                timer: 1500
            })
            form.trigger('reset');
            window.location.href = "";

        } else {
            Swal.fire({
                icon: 'error',
                title: res.msg,
                showConfirmButton: false,
                timer: 1500
            })
        }
    })
        .fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion',
                showConfirmButton: false,
                timer: 1500
            })
        })
        .always(function () {
            // form.waitMe('hide');
        });
}

/*
//Agregar orden
function codi_transformar_orden() {
    var filas = [];
    var i = 1;
    $('#tbl_cotizacion tbody tr').each(function () {
        var id = $(this).find('td').eq(0).text();
        var clave = $(this).find('td').eq(1).text();
        var descripcion = $(this).find('td').eq(2).text();
        var existencia = $(this).find('td').eq(3).text();
        var disponibles = $(this).find('td').eq(5).text();
        var precio = $(this).find('td').eq(6).find('input').val();
        var cantidad = $(this).find('td').eq(7).find('input').val();
        console.log(precio)
        console.log(cantidad)
        var monto = parseFloat(precio) * parseFloat(cantidad);
        var partida = i;

        var fila = {
            id,
            clave,
            descripcion,
            existencia,
            disponibles,
            cantidad,
            precio,
            monto,
            partida
        };
        filas.push(fila);
        i++;
    });
    console.log(filas)

    var form = $('.codi_transformar_orden'),
        hook = 'codi_hook',
        action = 'add',
        data = new FormData(form.get(0));

    data.append('hook', hook);
    data.append('action', action);

    data.append('IdCliente', $('#IdCliente').val());
    data.append('IdDomicilio', $('#IdDomicilio').val());
    data.append('Descripcion', $('#Descripcion').val());
    data.append('TipoPago', $('#TipoPago').val());
    data.append('Descuento', $('#Descuento').val());
    data.append('productos', JSON.stringify(filas));

    console.log(data)

    // AJAX Ordenes
    $.ajax({
        url: apibase + 'ajax/codi_transformar_orden',
        type: 'POST',
        dataType: 'json',
        contentType: false,
        processData: false,
        cache: false,
        data: data,
        beforeSend: function () {
            Swal.fire({
                icon: 'info',
                title: "Creando orden, por favor espere.",
                showConfirmButton: false,
            })
        }
    }).done(function (res) {
        if (res.status === 201) {
            Swal.fire({
                icon: 'success',
                title: res.msg,
                showConfirmButton: false,
                timer: 3500
            })
            form.trigger('reset');
            $('#UEstatus').val("2").trigger('change');
            codi_update_cotizacion();
            window.location.href = apibase + "ordenes";

        } else {
            Swal.fire({
                icon: 'error',
                title: res.msg,
                showConfirmButton: false,
                timer: 1500
            })
        }
    })
        .fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion'.err,
                showConfirmButton: false,
                timer: 1500
            })
        })
        .always(function () {
            // form.waitMe('hide');
        });
}
*/

function enviaraconvertir(){

    var moroso = $("#moroso").val();
    var urlpago = $("#urlpago").val();
    var UIdCotizacion = $("#UIdCotizacion").val();
 
    if(moroso == 1){
        console.log("Si entro a moroso 1")
        console.log(urlpago);
        if(urlpago != ""){
            if(urlpago != null){
                console.log("No soy ni null ni vacio")
                window.location.href = "https://grupoxtinfire.com/admin/ordenes/agregar/convertida/"+UIdCotizacion+"/1/1"
            }else{
                console.log("entre al que no es null")
                Swal.fire({
                    icon: 'warning',
                    title: 'No se puede convertir la orden aun no se recibe el pago, este cliente es moroso',
                    showConfirmButton: false,
                    timer: 3500
                })
            }
            
        }else{
            console.log("Si entro el swal no")
            Swal.fire({
                icon: 'warning',
                title: 'No se puede convertir la orden aun no se recibe el pago, este cliente es moroso',
                showConfirmButton: false,
                timer: 3500
            })
        } 
    }else{
        window.location.href = "https://grupoxtinfire.com/admin/ordenes/agregar/convertida/"+UIdCotizacion+"/1/1"
    }
}

function selectdesc(event){

    var formato = new Intl.NumberFormat('es-MX', {
        style: 'currency',
        currency: 'MXN',
    });
   var descuentototal = $("#descuentototal").val();
   var tr = event.closest(`tr`);

   var preciocell = tr.cells[6].children[0].value;
   preciocell = preciocell.replace("$", "");
   preciocell = preciocell.replace(",","");
   preciocell = parseFloat(preciocell);
   var cantidadcell = tr.cells[7].children[0].value;
   var porciento = event.value; 
   porciento = porciento.replace("%", "");
   var porciento2 = porciento;
   var total = preciocell * cantidadcell;
   console.log("soy total preciocell * cantidadcell" + total);
   var porciento = total * (porciento / 100);
   var tcomision = 0;
   console.log("soy dual porciento " + porciento);
   var totalconsentrado = parseFloat(porciento) + parseFloat(descuentototal);
   var monto = total - porciento;
    $("#descuentototal").val(totalconsentrado);
    tr.cells[9].children[0].value = "$"+porciento.toFixed(2);
    tr.cells[10].children[0].value =  "$"+monto.toFixed(2);
	var nuevacomision = 0;

          if(porciento2 >15){
        var totalparacomision = total * 0.10;
        tcomision = totalparacomision;
        var cuantorestar = tcomision/15;

        if(porciento2 == 16){
           nuevacomision = tcomision - (cuantorestar * 1)
        }else if(porciento2 == 17){
            nuevacomision = tcomision - (cuantorestar * 2)
        }else if(porciento2 == 18){
            nuevacomision = tcomision - (cuantorestar * 3)
        }else if(porciento2 == 19){
            nuevacomision = tcomision - (cuantorestar * 4)
        }else if(porciento2 == 20){
            nuevacomision = tcomision - (cuantorestar * 5)
        }else if(porciento2 == 21){
            nuevacomision = tcomision - (cuantorestar * 6)
        }else if(porciento2 == 22){
            nuevacomision = tcomision - (cuantorestar * 7)
        }else if(porciento2 == 23){
            nuevacomision = tcomision - (cuantorestar * 8)
        }else if(porciento2 == 24){
            nuevacomision = tcomision - (cuantorestar * 9)
        }else if(porciento2 == 25){
            nuevacomision = tcomision - (cuantorestar * 10)
        }else if(porciento2 == 26){
            nuevacomision = tcomision - (cuantorestar * 11)
        }else if(porciento2 == 27){
            nuevacomision = tcomision - (cuantorestar * 12)
        }else if(porciento2 == 28){
            nuevacomision = tcomision - (cuantorestar * 13)
        }else if(porciento2 == 29){
            nuevacomision = tcomision - (cuantorestar * 14)
        }else if(porciento2 == 30){
            nuevacomision = tcomision - (cuantorestar * 15)
        }
         
        if(porciento2 < 30){
            tr.cells[8].children[1].removeAttribute('class','badge bg-success');
            tr.cells[8].children[1].setAttribute('class','badge bg-warning');
        }else{
            tr.cells[8].children[1].removeAttribute('class','badge bg-success');
            tr.cells[8].children[1].setAttribute('class','badge bg-danger');
        }
        tr.cells[8].children[1].innerHTML = formato.format(nuevacomision.toFixed(2)) + " mxn";
        tr.cells[8].children[2].value = nuevacomision.toFixed(2);
      }else if(porciento2 <= 15){
        tr.cells[8].children[1].removeAttribute('class','badge bg-success');
        tr.cells[8].children[1].setAttribute('class','badge bg-success');
        tr.cells[8].children[2].value = (total * .10).toFixed(2);
        tr.cells[8].children[1].innerHTML = formato.format((total * .10).toFixed(2)) + " mxn";
      }
    subtotal = $("#subtotal").text();
	if(subtotal == ""){
		subtotal = "0";
	}
    subtotal = subtotal.replace("$", "");
    subtotal = parseFloat(subtotal) - porciento;
    var cantiva = subtotal * (16 / 100);
    var total = parseFloat(subtotal) + parseFloat(cantiva);
	
    $("#descuentoT").text(formato.format(totalconsentrado));
    $("#subtotal").text(formato.format(subtotal));  
    $("#iva").text(formato.format(cantiva));
    $("#iva2").val(cantiva);
    $("#total").text(formato.format(total));
    $("#neto").val(total);

	calcular_total();
}
function calcular_total(){
	
	var formato = new Intl.NumberFormat('es-MX', {
        style: 'currency',
        currency: 'MXN',
    });
	var totalconsentrado = 0;
	var subtotal = 0;
	var cantiva = 0;
	var total = 0;
	var descuentopesos = 0;
    var ivatotal = 0;
    var ivaindividual = 0;
	$('#tbl_cotizacion tbody tr').each(function () {
         descuentopesos = $(this).find('td').eq(9).find('input').val();
        descuentopesos = descuentopesos.replace("$", "");
		var neto = $(this).find('td').eq(10).find('input').val();
        neto = neto.replace("$", "");
        descuentopesos = descuentopesos.replace(/[^\d\.\-]/g, "")
        console.log("voy a entrar a iva ivaindividual")
        neto = neto.replace(/[^\d\.\-]/g, "")
        ivaindividual = (parseFloat(neto) * .16).toFixed(2);
        ivatotal += parseFloat(ivaindividual,2);
		subtotal = parseFloat(neto) + parseFloat(subtotal) ;
        console.log(parseFloat(neto));
        totalconsentrado += parseFloat(descuentopesos);
    });
	
	cantiva = subtotal * (16 / 100);
    total = parseFloat(subtotal) + parseFloat(ivatotal);
    
	$("#descuentoT").text(formato.format(totalconsentrado));
    $("#subtotalT").text(formato.format(subtotal + totalconsentrado));
    $("#subtotal").text(formato.format(subtotal));  
    $("#iva").text(formato.format(parseFloat(ivatotal)));
    $("#iva2").val(parseFloat(ivatotal));
    $("#total").text(formato.format(total));
    $("#neto").val(total);
}

$("#tbl_cotizacion").on("keyup", ".form-calc", function () {
        
        var parent = $(this).closest("tr");
        var childselec = parent.find(".childselec").val();
        childselec = childselec.replace("%", "");
        var cantidad = parent.find(".form-qty").val();
        var precio = parent.find(".form-cost").val();
        precio = precio.replace("$", "");
       precio = precio.replace(",","");
       precio = parseFloat(precio);
       var totalnoneto = cantidad * precio;
       console.log("soy childselec" + childselec)
        if(childselec == 0){
            parent.find(".form-line").val("$"+(cantidad*precio).toFixed(2));
        }else{   
            
           var porciento = totalnoneto * (childselec / 100);
           var monto = totalnoneto - porciento;
            parent.find(".form-line").val("$"+monto.toFixed(2));
            parent.find(".form-desc").val("$"+porciento.toFixed(2));
        }

        var total = 0;
        var descuentototal = 0;
        var porciento2 = childselec;
        var tcomision = 0;
        var nuevacomision = 0;
        var formato = new Intl.NumberFormat('es-MX', {
            style: 'currency',
            currency: 'MXN',
        });
        if(porciento2 >15){
        var totalparacomision = totalnoneto * 0.10;
            
        parent.eq(8).addClass('badge bg-warning');
        //tcomision = parent.find(".comreal").val();
        tcomision = totalparacomision;

        var cuantorestar = tcomision/15;

        // tcomision = totalneto*.10; cuantorestar = tcomision/15; F = tcomicion - (cuentorestar * 1) 
        if(porciento2 == 16){
           nuevacomision = tcomision - (cuantorestar * 1)
        }else if(porciento2 == 17){
            nuevacomision = tcomision - (cuantorestar * 2)
        }else if(porciento2 == 18){
            nuevacomision = tcomision - (cuantorestar * 3)
        }else if(porciento2 == 19){
            nuevacomision = tcomision - (cuantorestar * 4)
        }else if(porciento2 == 20){
            nuevacomision = tcomision - (cuantorestar * 5)

        }else if(porciento2 == 21){
            nuevacomision = tcomision - (cuantorestar * 6)
        }else if(porciento2 == 22){
            nuevacomision = tcomision - (cuantorestar * 7)
        }else if(porciento2 == 23){
            nuevacomision = tcomision - (cuantorestar * 8)
        }else if(porciento2 == 24){
            nuevacomision = tcomision - (cuantorestar * 9)
        }else if(porciento2 == 25){
            nuevacomision = tcomision - (cuantorestar * 10)
        }else if(porciento2 == 26){
            nuevacomision = tcomision - (cuantorestar * 11)
        }else if(porciento2 == 27){
            nuevacomision = tcomision - (cuantorestar * 12)
        }else if(porciento2 == 28){
            nuevacomision = tcomision - (cuantorestar * 13)
        }else if(porciento2 == 29){
            nuevacomision = tcomision - (cuantorestar * 14)
        }else if(porciento2 == 30){
            nuevacomision = tcomision - (cuantorestar * 15)
        }
        parent.eq(8).addClass('badge bg-warning');
        parent.find(".calcularchidden").text(formato.format(nuevacomision.toFixed(2)) + " mxn");
        parent.find(".comision").val(nuevacomision.toFixed(2));
      }else if(porciento2 <= 15){
        parent.eq(8).addClass('badge bg-success');
        parent.find(".calcularchidden").text(formato.format((totalnoneto* 0.10).toFixed(2)) + " mxn");
        console.log()
        parent.find(".comision").val((totalnoneto* 0.10).toFixed(2));
      }
        $(".form-desc").removeAttr('disabled');
        $(".form-line").each(function () {
            console.log($(this).val());
            total += parseFloat($(this).val() || 0);
        });
        $(".form-desc").each(function () {
            console.log($(this).val());
            descuentototal += parseFloat($(this).val() || 0);
        });
        $(".form-desc").attr('disabled','disabled');
        $("#subtotal").text("$"+total.toFixed(2));
        $("#descuentoT").text("$"+descuentototal.toFixed(2));
        var iva = total*.16;
        $("#iva").text("$"+iva.toFixed(2));
        var totalgeneral = total+iva;
        $("#total").text("$"+totalgeneral.toFixed(2));
        
        calcular_total();
    });

$(document).on('click', '.borrar', function (event) {
        event.preventDefault();
        $(this).closest('tr').remove();
        
        calcular_total();

    });

$(document).ready(function () {
    //Obtener Moviemientos
    $('#addEventPopupcot').on('show.bs.modal', function (event) {
        console.log("Estoy entrando")
        var button = $(event.relatedTarget) // Button that triggered the modal
        var idOrden = button.data('idordeno');
        var productoid = button.data('productoid');
        var partida = button.data('partida');
        var nombre = button.data('nombre');
        var fechaCalendario = button.data('fechacalendario');
        
        var modal = $(this)
        modal.find('#ordenp').text("Oden: "+idOrden);
        modal.find('#ncap').text(nombre);
        modal.find('#IevntFechaInicio').val(fechaCalendario);
        modal.find('#IevntFechaFin').val(fechaCalendario);
        modal.find("#partidaC").val(partida);
        modal.find("#tiposerviciooption").val(nombre);
        modal.find("#tiposerviciooption").text(nombre);
        
        
        
        codi_get_cotizacionevento(idOrden,'CREATE');
        codi_get_vendedores_select();
        codi_get_instructores_select();
        select_wrapper_partidas();
})
    codi_get_detallecotizacion();
    sleep(1500).then(() => {
        console.log("then")
        $('#proAlmacen').val(1).trigger('change');
    });
})

function sleep(time) {
    return new Promise((resolve) => setTimeout(resolve, time));
}

function codi_get_almacen_select(almacenMostrar) {
    var wrapper = $('.select_wrapper_almacen'),
        hook = 'codi_hook',
        action = 'load';
    const w = document.querySelectorAll('.select_wrapper_almacen');
    var mostrar = almacenMostrar ? almacenMostrar : 1;
    console.log(mostrar)
    // AJAX Usuarios Get
    $.ajax({
        url: apibase + 'ajax/codi_get_almacenes_select_ind',
        type: 'POST',
        dataType: 'json',
        cache: false,
        data: { hook, action,mostrar},
        beforeSend: function () {

        }
    }).done(function (res) {
        if (res.status === 200) {
            w.forEach(element => {
                element.innerHTML = res.data
            });
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion',
                showConfirmButton: false,
                timer: 6500
            })
            wrapper.html('');

        }
    })
        .fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion: Error en el servidor',
                showConfirmButton: false,
                timer: 6500
            })
            wrapper.html('');
        })
        .always(function () {

        });

}

function addEvent(){
        //Agregar Ajax
        var form = $('.codi_add_evento'),
            hook = 'codi_hook',
            action = 'add',
            data = new FormData(form.get(0));
        var partidaC = $('#partidaC').val();
        var alimentosli = 0; //alimentos
        var transporteli = 0; //transporte
        var dc3li = 0; //dc3
            
        if($("#alimentos").is(':checked')) { 
            alimentosli = 1;
        }
        if($("#transporte").is(':checked')){
            transporteli = 1;
        }
        if($("#dc3").is(':checked')){
            dc3li = 1; 
        }
        data.append('hook', hook);
        data.append('action', action);
        data.append('partidaC',partidaC);
        data.append('alimentos',alimentosli);
        data.append('transporte',transporteli);
        data.append('dc3',dc3li);
        var IevntTipoServicio = $('#IevntTipoServicio').val();
        var IIdDomicilio = $('#IIdDomicilio').val();
        var IIdCliente = $('#IIdCliente').val();
        var IDC3Cliente = $('#IDC3Cliente').val();
        var IVendedor = $('#IVendedor').val();
        var IIdOrden = $('#IIdOrden').val();
        var IParticipantes = $('#IParticipantes').val();
        var IObservaciones = $('#IObservaciones').val();
        var IevntFechaInicio = $('#IevntFechaInicio').val();
        var IevntHoraInicio = $('#IevntHoraInicio').val();
        var IevntFechaFin = $('#IevntFechaFin').val();
        var IevntHoraFin = $('#IevntHoraFin').val();
        var IevntEstatus = $('#IevntEstatus').val();
        var IInstructores = $('#IInstructores').val();
        //validar que este seleccionado una opcion Usuario
       /* if (IevntTipoServicio === '' || IIdDomicilio === '' || IIdCliente === '' || IVendedor === ''
            || IIdOrden === '' || IParticipantes === '' || IevntFechaInicio === '' || IevntHoraInicio === ''
            || IevntHoraFin === '' || IevntFechaFin === '' || IevntEstatus === '' || IInstructores === '') {

            Swal.fire({
                icon: 'error',
                title: 'Alguno de los datos obligatorrios se encuentra vacío.',
                showConfirmButton: false,
                timer: 1500
            })

            return
        }*/
        
        // AJAX Usuarios
        $.ajax({
            url: apibase + 'ajax/codi_add_evento_cotizacion',
            type: 'POST',
            dataType: 'json',
            contentType: false,
            processData: false,
            cache: false,
            data: data,
            beforeSend: function () {
                // form.waitMe();
            }
        }).done(function (res) {
            if (res.status === 201) {
                Swal.fire({
                    icon: 'success',
                    title: res.msg,
                    showConfirmButton: false,
                    timer: 1500
                })

                window.location.href = "";

            } else {
                Swal.fire({
                    icon: 'error',
                    title: res.msg,
                    showConfirmButton: false,
                    timer: 1500
                })
            }
        })
            .fail(function (err) {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion',
                    showConfirmButton: false,
                    timer: 1500
                })
            })
            .always(function () {
                // form.waitMe('hide');
            });
        $('#addEventPopupcot').modal('hide');
    };

function codi_get_productos_almacen_select() {
    var almacen = $('#proAlmacen').val() == null ? 1:$('#proAlmacen').val();
    var usuarioval = $("#usuarioval").val();
    if(usuarioval == 9 && almacen == 1){
        almacen = 5;
    }
    var nombrepagina = $('#nombrepagina').val();
    var tipoods = $('#tipo_orden').val();
    if (nombrepagina == "orden") {
        if (almacen == "") {
            Swal.fire({
                icon: 'error',
                title: 'Por favor seleccione un almacen.',
                showConfirmButton: false,
                timer: 3500
            })
            return;
        }
        console.log(almacen)
        var wrapper = $('.select_wrapper_productos'),
            hook = 'codi_hook',
            action = 'load';


        // AJAX Usuarios Get
        $.ajax({
            url: apibase + 'ajax/codi_get_productos_almacen_select_ind',
            type: 'POST',
            dataType: 'json',
            cache: false,
            data: { hook, action, almacen: almacen,tipoods:tipoods },
            beforeSend: function () {

            }
        }).done(function (res) {
            if (res.status === 200) {
                wrapper.html(res.data);
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion',
                    showConfirmButton: false,
                    timer: 1500
                })
                wrapper.html('');

            }
        })
            .fail(function (err) {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion. Código: 3001',
                    showConfirmButton: false,
                    timer: 1500
                })
                wrapper.html('');
            })
            .always(function () {

            });
    }
}
