var apibase = "https://grupoxtinfire.com/admin/";

function codi_get_producto(select) {
    var proId = select.value;
    if (proId) {
        wrapper = $('.wrapper_insert_productos'),
            hook = 'codi_hook',
            action = 'load';

        // AJAX Usuarios Get
        $.ajax({
            url: apibase + 'ajax/codi_get_producto',
            type: 'POST',
            dataType: 'json',
            cache: false,
            data: { hook, action, proId: proId },
            beforeSend: function () {

            }
        }).done(function (res) {
            if (res.status === 200) {
                var IdProducto = res.data.proId;
                var PrecioVenta = res.data.proPrecioventa;
                codi_add_detalleorden(IdProducto, PrecioVenta)
				$("#selectprods").val("").trigger('change');
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion',
                    showConfirmButton: false,
                    timer: 1500
                })
            }
        }).fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion. Código: 3004',
                showConfirmButton: false,
                timer: 1500
            })
        }).always(function () {

        });
    }
}
 
function calculardiasDiscount() {
    var timeStart = new Date();
    var timeEnd = new Date(document.getElementById("fechafinpipc").value);
    if (timeEnd > timeStart)
    {   console.log("Entre al primer if")
        var diff = timeEnd.getTime() - timeStart.getTime();
        var sumamath = Math.round(diff / (1000 * 60 * 60 * 24));
        $("#contadorentrega").html("Dias restantes <strong class='text-danger'>" + sumamath + "</strong> para la entrega.");

    }
    else if (timeEnd != null && timeEnd < timeStart) {
        alert("La fecha final de la promoción debe ser mayor a la fecha inicial");
        $("#contadorentrega").html("Dias restantes <strong class='text-danger'> Sin asignar </strong> para la entrega.");
    }
}

function entregacompleta(){
    var UEstatus = $("#UEstatus").val();
    var Utransito = $("#Utransito").val();
    if(UEstatus == 12 || UEstatus == 11 || UEstatus == 4 || UEstatus == 25 || UEstatus == 31){

    }else{
        Swal.fire({
                icon: 'warning',
                title: "Necesitas cambiar el estatus a Pagado, Pagado sin factura, Pagado con factura, Pagado contra entrega o Credito.",
                showConfirmButton: false,
                timer: 5500
            })

        return 0;
    }

    if(Utransito == 9 || Utransito == 14 || Utransito == 22){

    }else{
        Swal.fire({
                icon: 'warning',
                title: "Debes cambiar el estatus transito a Reparto 1, Reparto 2 o Tienda. El sistema no puede hacerlo en automatico por motivos de estadistica y cierres.",
                showConfirmButton: false,
                timer: 5500
            }) 

        return 0;
    }

    $('#tbl_orden tbody tr').each(function () {
        var cantidad = $(this).find('td').eq(7).find('input').val();
        $(this).find('td').eq(11).find('input').val(cantidad);
        
    })

    Swal.fire({
        icon: '',
        title: "Validando entrega espera un momento....",
        showConfirmButton: false,
        timer: 5500
    })


        Swal.fire({
          title: "Validando",
          text: "Estamos confirmado entrega!",
          icon: "info",
          showCancelButton: false,
          showConfirmButton: false,
          timer: 5500
        }).then((result) => {
          codi_update_orden()
        });
    
}

function agregarleido(){
    var IdOrden = $("#UIdOrden").val();
    var valcheck = $("#leidocheck").is(":checked");
    console.log(valcheck)
    var departamento = $("#Utransitooriginal").val();
    var leido = 0;
    var hook = 'codi_hook';
    var action = 'update';
    if (valcheck == false) {
        leido = 1;
    }

 
    // AJAX Usuarios Get
    $.ajax({
        url: apibase + 'ajax/codi_update_leido',
        type: 'POST',
        dataType: 'json',
        cache: false,
        data: { hook, action, IdOrden, leido, departamento},
        beforeSend: function () {

        }
    }).done(function (res) {
        if (res.status === 201) {
            Swal.fire({
                icon: 'success',
                title: res.msg,
                showConfirmButton: false,
                timer: 5500
            })
            //Wform.trigger('reset');
            window.location.href = "";
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion',
                showConfirmButton: false,
                timer: 1500
            })

        }
    })
        .fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion. Código: 3003',
                showConfirmButton: false,
                timer: 1500
            })
        })
}

function subirFile(){
    var imagencontenedor = $("#pdf");
    var idc = $("#idCliente").val();
    var hook = 'codi_hook',
        action = 'add';
    var loadin = $(".loadin");
    var data = new FormData(imagencontenedor.get(0));
    data.append("hook",hook);
    data.append("idc",idc);
    data.append("action",action);
    $.ajax({
        url: apibase + 'ajax/codi_add_factura_orden',
        type: 'POST',
        dataType: 'json',
        contentType: false,
        processData: false,
        cache: false,
        data: data,
        beforeSend: function () {
            loadin.waitMe();
        }
    }).done(function (res) {
        if (res.status === 201) {
            Swal.fire({
                icon: 'success',
                title: res.msg,
                showConfirmButton: false,
                timer: 5500
            })
            window.location.reload();

        } else {
            Swal.fire({
                icon: 'error',
                title: res.msg,
                showConfirmButton: false,
                timer: 5500
            })
        }
    })
        .fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion',
                showConfirmButton: false,
                timer: 5500
            })
        }).always(function () {
                loadin.waitMe("hide");
            });
}

function subirFile2(){
    var imagencontenedor = $("#pdfdocumentopago");
    var idc = $("#UIdOrden").val();
    var hook = 'codi_hook',
        action = 'add';
        var loadin = $(".loadin");
    var data = new FormData(imagencontenedor.get(0));
    data.append("hook",hook);
    data.append("idc",idc);
    data.append("action",action);

    $.ajax({
        url: apibase + 'ajax/codi_add_factura_orden_pago',
        type: 'POST',
        dataType: 'json',
        contentType: false,
        processData: false,
        cache: false,
        data: data,
        beforeSend: function () {
            loadin.waitMe();
        }
    }).done(function (res) {
        if (res.status === 201) {
            Swal.fire({
                icon: 'success',
                title: res.msg,
                showConfirmButton: false,
                timer: 5500
            })
            window.location.reload();

        } else {
            Swal.fire({
                icon: 'error',
                title: res.msg,
                showConfirmButton: false,
                timer: 5500
            })
        }
    })
        .fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion',
                showConfirmButton: false,
                timer: 5500
            })
        }).always(function () {
                loadin.waitMe("hide");
            });
}


function subirFile3(){
    var imagencontenedor = $("#pdfcroquis");
    var idc = $("#UIdOrden").val();
    var hook = 'codi_hook',
        action = 'add';
        var loadin = $(".loadin");
    var data = new FormData(imagencontenedor.get(0));
    data.append("hook",hook);
    data.append("idc",idc);
    data.append("action",action);
    $.ajax({
        url: apibase + 'ajax/codi_add_factura_orden_croquis',
        type: 'POST',
        dataType: 'json',
        contentType: false,
        processData: false,
        cache: false,
        data: data,
        beforeSend: function () {
            loadin.waitMe();
        }
    }).done(function (res) {
        if (res.status === 201) {
            Swal.fire({
                icon: 'success',
                title: res.msg,
                showConfirmButton: false,
                timer: 5500
            })
            window.location.reload();

        } else {
            Swal.fire({
                icon: 'error',
                title: res.msg,
                showConfirmButton: false,
                timer: 5500
            })
        }
    })
        .fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion',
                showConfirmButton: false,
                timer: 5500
            })
        }).always(function () {
                loadin.waitMe("hide");
            });
}

function enviarwhats(key,orden){
    var telefono = $("#telcliente").val();
    var tel = "52"+telefono;
    var men = $("#mensaje").val();
    var mensaje = "https://wa.me/"+telefono+"?text="+men + " https://grupoxtinfire.com/admin/ordenes/aceptar_orden/0/"+key+"/"+orden+" . Para poder ver la orden en pdf de clic en el siguiente enlace: " + "https://grupoxtinfire.com/admin/pdf/pdforden/"+orden;
    mensaje.replace(" ","%20");
    var cabecera = "grupoxtinfire orden : "+ orden;
    try {
        window.open(mensaje,cabecera, "width=1024, height=768");
    }catch(err){
        console.log(err)
    }
    
}

function codi_get_productos_almacen_select() {
    var almacen = $('#proAlmacen').val();
    var nombrepagina = $('#nombrepagina').val();
    if (nombrepagina == "orden") {
        if (almacen == "") {
            Swal.fire({
                icon: 'error',
                title: 'Por favor seleccione un almacen.',
                showConfirmButton: false,
                timer: 3500
            })
            return;
        }
        var wrapper = $('.select_wrapper_productos'),
            hook = 'codi_hook',
            action = 'load';


        // AJAX Usuarios Get
        $.ajax({
            url: apibase + 'ajax/codi_get_productos_almacen_select',
            type: 'POST',
            dataType: 'json',
            cache: false,
            data: { hook, action, almacen: almacen },
            beforeSend: function () {

            }
        }).done(function (res) {
            if (res.status === 200) {
                wrapper.html(res.data);
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion',
                    showConfirmButton: false,
                    timer: 1500
                })
                wrapper.html('');

            }
        })
            .fail(function (err) {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion. Código: 3001',
                    showConfirmButton: false,
                    timer: 1500
                })
                wrapper.html('');
            })
            .always(function () {

            });
    }
}

function codi_add_detalleorden(IdProducto, PrecioVenta) {
    var IdOrden = $('#IdOrden').val();
    var FolioOrden = $('#FolioOrden').val();
    var Partida =  parseInt($("#contarpartidas").val()) + 1;
    var Cantidad = $("#cproductoenviar").val();

    wrapper = $('.wrapper_insert_productos'),
        hook = 'codi_hook',
        action = 'load';

    // AJAX Usuarios Get
    $.ajax({
        url: apibase + 'ajax/codi_add_detalleorden',
        type: 'POST',
        dataType: 'json',
        cache: false,
        data: {
            hook, action,
            IdOrden: IdOrden,
            FolioOrden: FolioOrden,
            Partida: Partida,
            IdProducto: IdProducto,
            Cantidad: Cantidad,
            PrecioVenta: PrecioVenta,
        },
        beforeSend: function () {
            Swal.fire({
                title: 'Agregando producto',
                showConfirmButton: false,
                timer: 1500
            })
        }
    }).done(function (res) {
        if (res.status === 201) {
            $("#selectprods").val("").trigger('change')

            codi_get_detalleorden();
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion',
                showConfirmButton: false,
                timer: 1500
            })
        }
    }).fail(function (err) {
        Swal.fire({
            icon: 'error',
            title: 'Hubo un error en la peticion. Código: 3002',
            showConfirmButton: false,
            timer: 1500
        })
    }).always(function () {

    });
}

function codi_get_detalleorden() {
    var wrapper = $('.tabla_wrapper_detalleorden'),
        hook = 'codi_hook',
        action = 'load';
    var IdOrden = $('#IdOrden').val();
    var IdCompraphp = $('#IdCompraphp').val();
    var contador = $('#contador').val();
    var contadororiginal = $('#contadororiginal').val();
    var porqueunirnosirve = $("#separarproductosindividual").val();
    // AJAX Usuarios Get
    $.ajax({
        url: apibase + 'ajax/codi_get_detalleorden',
        type: 'POST',
        dataType: 'json',
        cache: false,
        data: { hook, action, IdOrden: IdOrden, IdCompraphp:IdCompraphp,contador:contador,contadororiginal:contadororiginal, porqueunirnosirve },
        beforeSend: function () {

        }
    }).done(function (res) {
        if (res.status === 200) {
            console.log(res)
            wrapper.html(res.data);
            $('.datatable-init').DataTable({
                responsive: true,
                orderCellsTop: true,
                fixedHeader: true,
                dom: 'Blfrtip',
                buttons: ['copy', 'excel', 'csv', 'pdf'],
                language: {
                    url: 'https://cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json'
                }
            });
            var divcontar = "";
            var contarprodporsku = $('#contarprodporsku');
            for (i=0; i<res.msg.length; i++) {

              divcontar += `<span>${res.msg[i].proTitulo}: Cantidad: ${res.msg[i].contarproductos} </span><br>`; 

            }
            $("#contarpartidas").val(res.msg.length);
            console.log(divcontar)
            contarprodporsku.html(divcontar);
			calcular_total();
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion',
                showConfirmButton: false,
                timer: 1500
            })
            wrapper.html('');

        }
    })
        .fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion. Código: 3003',
                showConfirmButton: false,
                timer: 1500
            })
            wrapper.html('');
        })
        .always(function () {

        });

}

function agregarordenancla(element){
    var cont = $("#contadorinput").val();
    var valorancla = element.value;
    const desfrag = valorancla.split("-");
    var vendedoractivo = desfrag[0];
    if(vendedoractivo == 0){
        return;
    }
    const node = document.createElement("span");
    const textnode = document.createTextNode(valorancla);
    node.className = "badge bg-outline-primary";
    node.id="span"+cont;
    node.appendChild(textnode);
    const crossnode = document.createElement("em");
    crossnode.className = "icon ni ni-cross-c";
    crossnode.id = "eli"+cont;
    crossnode.setAttribute("onclick", "eliminar("+cont+")");
    const input = document.createElement("input");
    input.value = valorancla;
    input.style = "display:none";
    input.id= "input"+cont;
    if(cont > 0){
        for(x= 0; x < cont; x++){
            
            var ip = $("#input"+x).val();
            const desfragip = ip.split("-");
            var idip = desfragip[0];
            var origenip = desfrag[0];
            if(origenip == idip){
                Swal.fire({
                icon: 'warning',
                title: 'No se puede agregar la orden '+desfrag[1]+' 2 veces',
                showConfirmButton: false,
                timer: 1500
                })
                return;
            }
        }
    }
    node.appendChild(crossnode);
    document.getElementById("agregarordenancla").appendChild(node);
    document.getElementById("agregarordenancla").appendChild(input);
    cont++;
    $("#contadorinput").val(cont);
}

function crearancla(){
    var numerodeanclas = $("#contadorinput").val();
    var Idorden = $("#IdOrden").val();
    var anclas = [{"anclas" : Idorden}];
    for (x=1;x <= numerodeanclas;x++) {
        var f = x-1;
        var valorinput = $("#input"+f).val();
        valorinput = valorinput.split("-");
        anclas.push({"anclas":valorinput[0]});
    }
    var hook = 'codi_hook',
        action = 'add';
    var anclasstring = JSON.stringify(anclas);
    // AJAX Usuarios Get
    $.ajax({
        url: apibase + 'ajax/codi_add_ancla',
        type: 'POST',
        dataType: 'json',
        cache: false,
        data: { hook, action, anclasstring},
        beforeSend: function () {

        }
    }).done(function (res) {
        if (res.status === 200) {
                let timerInterval;
                Swal.fire({
                  title: "Excelente",
                  html: "Hemos unido las ordenes correctamente espera unos segundos para terminar la union<b></b>.",
                  timer: 2000,
                  allowOutsideClick: false,
                  showConfirmButton: false,
                  timerProgressBar: true,
                  didOpen: () => {
                    Swal.showLoading();
                    const timer = Swal.getPopup().querySelector("b");
                    timerInterval = setInterval(() => {
                      timer.textContent = `${Swal.getTimerLeft()}`;
                    }, 100);
                  },
                  willClose: () => {
                    clearInterval(timerInterval);
                  }
                }).then((result) => {
                  /* Read more about handling dismissals below */
                  if (result.dismiss === Swal.DismissReason.timer) {
                       location.reload();
                  }
                });
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion',
                showConfirmButton: false,
                timer: 6500
            })

        }
    })
        .fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion: Error en el servidor',
                showConfirmButton: false,
                timer: 6500
            })
        })
}

function codi_get_almacen_select() {
    var wrapper = $('.select_wrapper_almacen'),
        hook = 'codi_hook',
        action = 'load';
        var tipoorden = $("#tipo_orden").val();
        var mostrar = 2;
        if(tipoorden == 1){
            mostrar = 1;
        }
    

    const w = document.querySelectorAll('.select_wrapper_almacen');
    // AJAX Usuarios Get
    $.ajax({
        url: apibase + 'ajax/codi_get_almacenes_select_ind2',
        type: 'POST',
        dataType: 'json',
        cache: false,
        data: { hook, action, mostrar},
        beforeSend: function () {

        }
    }).done(function (res) {
        if (res.status === 200) {
            w.forEach(element => {
                element.innerHTML = res.data
            });
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion',
                showConfirmButton: false,
                timer: 6500
            })
            wrapper.html('');

        }
    })
        .fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion: Error en el servidor',
                showConfirmButton: false,
                timer: 6500
            })
            wrapper.html('');
        })
        .always(function () {

        });

}

function botones() {
    //botones
    var plus = document.querySelectorAll("[data-number='plus']");
    var minus = document.querySelectorAll("[data-number='minus']");

    plus.forEach(function (item, index, arr) {
        var parent = plus[index].parentNode;
        plus[index].addEventListener("click", function () {
            var child = plus[index].parentNode.children;
            child.forEach(function (item, index, arr) {
                if (child[index].classList.contains("number-spinner")) {
                    var value = !child[index].value == "" ? parseInt(child[index].value) : 0;
                    var step = !child[index].step == "" ? parseInt(child[index].step) : 1;
                    var max = !child[index].max == "" ? parseInt(child[index].max) : Infinity;
                    if (max + 1 > value + step) {
                        child[index].value = value + step;
                    } else {
                        child[index].value = value;
                    }
                }
            });
        });
    });
    minus.forEach(function (item, index, arr) {
        var parent = minus[index].parentNode;
        minus[index].addEventListener("click", function () {
            var child = minus[index].parentNode.children;
            child.forEach(function (item, index, arr) {
                if (child[index].classList.contains("number-spinner")) {
                    var value = !child[index].value == "" ? parseInt(child[index].value) : 0;
                    var step = !child[index].step == "" ? parseInt(child[index].step) : 1;
                    var min = !child[index].min == "" ? parseInt(child[index].min) : 0;
                    if (min - 1 < value - step) {
                        child[index].value = value - step;
                    } else {
                        child[index].value = value;
                    }
                }
            });
        });
    });
    //botones
}

function cursospref(){
    var hook = 'codi_hook',
        action = 'load';
    var IdOrden = $('#UIdOrden').val();
    var textocursos = $("#textocursos").val();
    var codicod = $(".codicod");
    var alimentosli = 0; //alimentos
    var transporteli = 0; //transporte
    var dc3li = 0; //dc3
        
    if($("#alimentos").is(':checked')) { 
        alimentosli = 1;
    }
    if($("#transporte").is(':checked')){
        transporteli = 1;
    }
    if($("#dc3").is(':checked')){
        dc3li = 1; 
    }
    // AJAX Usuarios Get
    $.ajax({
        url: apibase + 'ajax/codi_update_prefcursos_ord',
        type: 'POST',
        dataType: 'json',
        cache: false,
        data: { hook, action, IdOrden, alimentosli, transporteli, dc3li, textocursos},
        beforeSend: function () {
            codicod.waitMe();
        }
    }).done(function (res) {
        if (res.status === 200) {
            Swal.fire({
                icon: 'success',
                title: 'Curso actualizado correctamente',
                showConfirmButton: false,
                timer: 1500
            })

            window.location.reload();
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion',
                showConfirmButton: false,
                timer: 1500
            })

        }
    })
        .fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion' + err,
                showConfirmButton: false,
                timer: 1500
            })
            wrapper.html('');
        })
        .always(function () {
            codicod.waitMe('hide');
        });
}

function codi_update_aceptar_orden(){
    var wrapper = "wrapper",
        hook = 'codi_hook',
        action = 'load';
    var IdOrden = $('#UIdOrden').val();
}

function codi_update_orden(){
    //event.preventDefault();

    //Detalle de la orden
    var filas = [];
    var i = 1;
    var valentregados = 1;
    $('#tbl_orden tbody tr').each(function () {
        var id = $(this).find('td').eq(0).text();
        var partida = $(this).find('td').eq(0).find('input').val();
        var clave = $(this).find('td').eq(1).text();
        var descripcion = $(this).find('td').eq(2).text();
        var tienecompra = $(this).find('td').eq(2).find('input').val();
        var existencia = $(this).find('td').eq(3).text();
        var disponibles = $(this).find('td').eq(5).text();
        var precio = $(this).find('td').eq(6).find('input').val();
        var cantidad = $(this).find('td').eq(7).find('input').val();
        var descuento = $(this).find('td').eq(8).find('select').val();
        var descuentopesos = $(this).find('td').eq(9).find('input').val();
        descuentopesos = descuentopesos.replace(/,/g, "");
        var monto =  $(this).find('td').eq(10).find('input').val();;
		var neto = $(this).find('td').eq(10).find('input').val();
		var entregados = $(this).find('td').eq(11).find('input').val();
        var eliminar = $(this).find('td').eq(12).find('input[type="checkbox"]').is(':checked');
        var eliminarval = $(this).find('td').eq(12).find('input').val();
        var iddetalle = $(this).find('td').eq(13).text();
        var extintor = $(this).find('td').eq(14).text();
        var comisionind = $(this).find('td').eq(16).find('input').val();
        var datetentativo = $(this).find('td').eq(12).find('.curso').val();
        if(eliminar == true){
            eliminar = 1;
            comisionind = 0;
            descuentopesos = 0;
        }else{
            if(eliminarval == 1){
            eliminar = 1;
            descuentopesos = 0;
            }else{
               eliminar = 0; 
            }  
        }

        if(entregados < cantidad){
            valentregados = 0;
        }

        var fila = {
            iddetalle,
            id,
            clave,
            descripcion,
            existencia,
            disponibles,
            cantidad,
            precio,
            monto,
            partida,
            entregados,
            extintor,
            descuento,
            descuentopesos,
            neto,
            eliminar,
            datetentativo,
            tienecompra,
            comisionind
        };
        filas.push(fila);
        i++;
    });

       var form = $('.codi_add_orden'),
        hook = 'codi_hook',
        action = 'add',
        data = new FormData(form.get(0));
    var estatus = $('#UEstatus').val();
    var transito = $('#Utransito').val();
    var transitooriginal = $("#Utransitooriginal").val();
    var folioorden = $('#FolioOrden').val();
    var idorden = $('#UIdOrden').val();
    var tipo_orden = $('#tipo_orden').val();
    var tipo_servicio = $('#tipo_servicio').val();
    var EstatusOriginal = $('#EstatusOriginal').val();
    var Descripcion = $('#CDescripcion').val();
    var pagadoono = $('#pagadoono').val();
    var tpago = $('#tpago').val();
    var valpagado = 0;
    if(valentregados == 1){
        transito = 27;
    }
    if(transito == 27 && valentregados == 0){

        estatus = 13;

    }else if(transito == 27 && valentregados == 1){
        estatus = 14;

    }

    if(transito == 27 && tipo_orden == 1 && pagadoono == 3){
       valpagado = 1;
    }else if(transito == 27 && tipo_orden == 1 && pagadoono == 11){
        valpagado = 1;
    }else if(transito == 27 && tipo_orden == 1 && pagadoono == 12){
        valpagado = 1;
    }else if(transito == 27 && tipo_orden == 1 && pagadoono == 25){
        valpagado = 1;
    }else if(transito == 27 && tipo_orden == 1 && pagadoono == 2){
         valpagado = 1;
    }else if(transito == 27 && tipo_orden == 1 && pagadoono == 31){
         valpagado = 1;
    }

    console.log("Quiero validar el swal transito: " + transito)
    console.log("Quiero validar el swal tipo_orden: " + tipo_orden)
    console.log("Quiero validar el swal pagadoono: " + pagadoono)

    if(transito == 27 && tipo_orden == 1 && valpagado != 1){
          Swal.fire({
                icon: 'warning',
                title: 'Entregando3',
                text: 'No se puede entregar orden no esta pagada',
                showConfirmButton: false,
            })

        return;
    }

   
    data.append('hook', hook);
    data.append('action', action);
    data.append('estatus', estatus);
    data.append('transito', transito);
    data.append('transitooriginal',transitooriginal);
    data.append('idorden', idorden);
    data.append('folioorden', folioorden);
    data.append('tipo_orden', tipo_orden);
    data.append('tipo_servicio', tipo_servicio);
    data.append('EstatusOriginal', EstatusOriginal);
    data.append('Descripcion', Descripcion);
    data.append('productos', JSON.stringify(filas));
    data.append('valentregados',valentregados);
    data.append('pagadoono',pagadoono);
    data.append('tpago',tpago)
  
    // AJAX Usuarios
    $.ajax({
        url: apibase + 'ajax/codi_update_orden',
        type: 'POST',
        dataType: 'json',
        contentType: false,
        processData: false,
        cache: false,
        data: data,
        beforeSend: function () {
            // form.waitMe();
            Swal.fire({
                icon: '',
                title: 'Actualizando Orden',
                text: 'Se está actualizando la orden, Por favor espere...',
                showConfirmButton: false,
            })
        }
    }).done(function (res) {
        if (res.status === 200) {
            Swal.fire({
                icon: 'success',
                title: res.msg,
                showConfirmButton: false,
                timer: 1500
            })
            form.trigger('reset');
            window.location.href = "";

        } else {
            Swal.fire({
                icon: 'error',
                title: res.msg,
                showConfirmButton: false,
                timer: 1500
            })
        }
    })
        .fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion',
                showConfirmButton: false,
                timer: 1500
            })
        })
        .always(function () {
            // form.waitMe('hide');
        });
}


function codi_transformar_invoice(event) {
    event.preventDefault();
    var loadin = $(".loadin");
    var form = $('.codi_add_orden'),
        hook = 'codi_hook',
        action = 'add',
        data = new FormData(form.get(0));
    var idorden = $('#FolioOrden').val();

    data.append('hook', hook);
    data.append('action', action);
    data.append('idorden', idorden);

    // AJAX Usuarios
    $.ajax({
        url: apibase + 'ajax/codi_transformar_invoice',
        type: 'POST',
        dataType: 'json',
        contentType: false,
        processData: false,
        cache: false,
        data: data,
        beforeSend: function () {
            loadin.waitMe();
        }
    }).done(function (res) {
        if (res.status === 200) {
            Swal.fire({
                icon: 'success',
                title: res.msg,
                showConfirmButton: false,
                timer: 3500
            })
            form.trigger('reset');
            window.location.href = "";

        } else {
            Swal.fire({
                icon: 'error',
                title: res.msg,
                showConfirmButton: false,
                timer: 1500
            })

        }
    })
        .fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion',
                showConfirmButton: false,
                timer: 1500
            })
        })
        .always(function () {
            loadin.waitMe('hide');
        });
}

//--------------------------INVOICES------------------------------------------
function cambiartipo() {
    var selectorden = document.querySelector("select[id=tipo_orden]");
    var tipoorden = selectorden.options[selectorden.selectedIndex].text;

    $('#TipoServicio').hide();
    if (tipoorden == "Recargas y Mantenimiento") {
        $('#TipoServicio').show();
    }
}

function mostrarGenerarComprobante() {
    var select = document.querySelector("select[id=Factura]");
    var select = $('input[name="Factura"]:checked').val();
    if (select == "SI") {
        $('#diggencomp').show();
    } else {
        $('#diggencomp').hide();
    }
}
//Agregar orden
function codi_update_invoice() {
    var filas = [];
    $('#tablameses tbody tr').each(function () {
        var numero = $(this).find('td').eq(0).find('label').text();
        var fecha = $(this).find('td').eq(1).find('input').val();
        var cantidad = $(this).find('td').eq(2).find('input').val();
        var nota = $(this).find('td').eq(3).find('input').val();

        var fila = {
            numero,
            fecha,
            cantidad,
            nota
        };
        filas.push(fila);
    });

    var IdOrden = $('#UIdOrden').val();
    var IdInvoice = $('#IdInvoice').val();
    var Pago = $('#Pago').val();
    var InicioPeriodoPago = $('#Pago').val();
    var Factura = $('input[name="Factura"]:checked').val();
    var GenerarComprobante = $('input[name="GenerarComprobante"]:checked').val();
    var Estatus = $('#UEstatus').val();
    var EstadoTransito = $('#Utransito').val();

    var form = $('.codi_add_orden'),
        hook = 'codi_hook',
        action = 'add',
        data = new FormData(form.get(0));

    data.append('hook', hook);
    data.append('action', action);
    data.append('filas', JSON.stringify(filas));

    data.append('IdOrden', IdOrden);
    data.append('IdInvoice', IdInvoice);
    data.append('Pago', Pago);
    data.append('InicioPeriodoPago', InicioPeriodoPago);
    data.append('Factura', Factura);
    data.append('GenerarComprobante', GenerarComprobante);
    data.append('Estatus', Estatus);
    data.append('EstadoTransito', EstadoTransito);

    // AJAX Ordenes
    $.ajax({
        url: apibase + 'ajax/codi_update_invoice',
        type: 'POST',
        dataType: 'json',
        contentType: false,
        processData: false,
        cache: false,
        data: data,
        beforeSend: function () {
            Swal.fire({
                icon: 'info',
                title: "Actualizando Invoice, por favor espere.",
                showConfirmButton: false,
            })
        }
    }).done(function (res) {
        if (res.status === 201) {
            Swal.fire({
                icon: 'success',
                title: res.msg,
                showConfirmButton: false,
                timer: 3500
            })
            window.location.href = "";
        } else {
            Swal.fire({
                icon: 'error',
                title: res.msg,
                showConfirmButton: false,
                timer: 1500
            })
        }
    })
        .fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion'.err,
                showConfirmButton: false,
                timer: 1500
            })
        })
        .always(function () {
            // form.waitMe('hide');
        });
}
//--------------------------------------EXTINTORES----------------------------------------
function codi_update_extintor_baja() {
    var form = $('.codi_update_extintor_baja'),
        hook = 'codi_hook',
        action = 'add',
        data = new FormData(form.get(0));

    data.append('hook', hook);
    data.append('action', action);
    data.append('BFolioOrden', $('#FolioOrden').val());
    data.append('BClaveExtintor', $('#BClaveExtintor').val());
    data.append('bmotivo', $('#bmotivo').val());
    data.append('BObservacion', $('#BObservacion').val());
    data.append('bOtroMotivo', $('#bOtroMotivo').val());
    data.append('BIdExtintor', $('#BIdExtintor').val());
    data.append('BPartida', $('#partidaextintor').val());

    // AJAX Ordenes
    $.ajax({
        url: apibase + 'ajax/codi_update_extintor_baja',
        type: 'POST',
        dataType: 'json',
        contentType: false,
        processData: false,
        cache: false,
        data: data,
        beforeSend: function () {
        }
    }).done(function (res) {
        if (res.status === 201) {
            Swal.fire({
                icon: 'success',
                title: res.msg,
                showConfirmButton: false,
                timer: 5500
            })
            //Wform.trigger('reset');
            window.location.href = "";

        } else {
            Swal.fire({
                icon: 'error',
                title: res.msg,
                showConfirmButton: false,
                timer: 5500
            })
        }
    })
        .fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion. Code:3005',
                showConfirmButton: false,
                timer: 10500
            })
        })
        .always(function () {
            // form.waitMe('hide');
        });
}

function agregarMotivoBaja() {
    var selectorden = document.querySelector("select[id=bmotivo]");
    var movimiento = selectorden.options[selectorden.selectedIndex].text;

    $('#bOtroMotivo').hide();
    $('#bOtroMotivol').hide();
    if (movimiento == "OTRO MOTIVO") {
        $('#bOtroMotivo').show();
        $('#bOtroMotivol').show();
    } else {
        $('#bOtroMotivo').hide();
        $('#bOtroMotivol').hide();
    }
}
function sleep(time) {
    return new Promise((resolve) => setTimeout(resolve, time));
}

function selectdesc(event){

    var formato = new Intl.NumberFormat('es-MX', {
        style: 'currency',
        currency: 'MXN',
    });
   var descuentototal = $("#descuentototal").val();
   var tr = event.closest(`tr`);
   var preciocell = tr.cells[6].children[0].value;
   var cantidadcell = tr.cells[7].children[0].value;
   var porciento = event.value;
   var total = preciocell * cantidadcell;
   var porciento = total * (porciento / 100);
   var totalconsentrado = parseFloat(porciento) + parseFloat(descuentototal);
   var monto = total - porciento;
   var ivatotal = 0;
    var ivaindividual = 0;
    $("#descuentototal").val(totalconsentrado);
    tr.cells[9].children[0].value = porciento.toFixed(2);
    tr.cells[10].children[0].value =  monto.toFixed(2);
	
    subtotal = $("#subtotal").text();
	if(subtotal == ""){
		subtotal = 0;
	}
    subtotal = subtotal.replace("$", "");
    subtotal = parseFloat(subtotal) - porciento;
    
    var cantiva = subtotal * (16 / 100);
    var total = parseFloat(subtotal) + parseFloat(cantiva);
	
    $("#descuentoT").text(formato.format(totalconsentrado));
    $("#subtotal").text(formato.format(subtotal));  
    $("#iva").text(formato.format(cantiva));
    $("#iva2").val(cantiva);
    $("#total").text(formato.format(total));
    $("#neto").val(total);
	calcular_total();
}
function calcular_total(){
	
	var formato = new Intl.NumberFormat('es-MX', {
        style: 'currency',
        currency: 'MXN',
    });
	var totalconsentrado = 0;
	var subtotal = 0;
	var cantiva = 0;
	var total = 0;
	var descuentopesosTotal = 0;
    var Idvendedor = $("#Idvendedor").val();
    var siniva = $("#siniva").val();
    var ivatotal = 0;
    var ivaindividual = 0;
	$('#tbl_orden tbody tr').each(function () {
        descuentopesos = $(this).find('td').eq(9).find('input').val();
        descuentopesos = descuentopesos.replace(",", ""); 
		var neto = $(this).find('td').eq(10).find('input').val();

        ivaindividual = (parseFloat(neto) * .16).toFixed(2);
		ivatotal += parseFloat(ivaindividual,2);
		subtotal = parseFloat(neto) + parseFloat(subtotal) ;
        descuentopesosTotal += parseFloat(descuentopesos);
        totalconsentrado = parseFloat(descuentopesos) + parseFloat(totalconsentrado) ;
    });
	
	cantiva = subtotal * (16 / 100);
    if(siniva == 1){
        var ivatotal = 0;
    var ivaindividual = 0;
    }
    total = parseFloat(subtotal) + parseFloat(ivatotal);
    
	$("#descuentoT").text(formato.format(descuentopesosTotal));
    $("#subtotal").text(formato.format(subtotal));  
    $("#iva").text(formato.format(parseFloat(ivatotal)));
    $("#iva2").val(parseFloat(ivatotal));
    $("#total").text(formato.format(total));
    $("#neto").val(total);
    $("#subtotalT").text(formato.format((subtotal + descuentopesosTotal).toFixed(2)));
}
$(document).on('click', '.borrar', function (event) {
        event.preventDefault();
        $(this).closest('tr').remove();
        var parent = $(this).closest("tr");
        parent.find(".form-line").val((parent.find(".form-qty").val() * parent.find(".form-cost").val()).toFixed(2));
        var total = 0;
        var descuentototal = 0;
        $(".form-desc").removeAttr('disabled');
        $(".form-line").each(function () {
            total += parseFloat($(this).val() || 0);
        });
        $(".form-desc").each(function () {
            descuentototal += parseFloat($(this).val() || 0);
        });
        $(".form-desc").attr('disabled','disabled');
        $("#subtotal").text("$"+total.toFixed(2));
        $("#descuentoT").text("$"+descuentototal.toFixed(2));
        var iva = total*.16;
        $("#iva").text("$"+iva.toFixed(2));
        var totalgeneral = total+iva;
        $("#total").text("$"+totalgeneral.toFixed(2));


    });

function aceptarordenrecarga(idorden) {

        var hook = 'codi_hook';
        var action = 'update';
        var idordenval = idorden;
        
    // AJAX Ordenes
    $.ajax({
        url: apibase + 'ajax/codi_update_taller',
        type: 'POST',
        dataType: 'json',
        cache: false,
        data: {hook,action,idordenval},
        beforeSend: function () {
        }
    }).done(function (res) {
        if (res.status === 200) {
            Swal.fire({
                icon: 'success',
                title: res.msg,
                showConfirmButton: false,
                timer: 5500
            })
            //Wform.trigger('reset');
            location.reload();

        } else {
            Swal.fire({
                icon: 'error',
                title: res.msg,
                showConfirmButton: false,
                timer: 5500
            })
        }
    })
        .fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion. Code:3005',
                showConfirmButton: false,
                timer: 10500
            })
        })
        .always(function () {
            // form.waitMe('hide');
        });
}

function guardarfechaspipc(){
    var fechainipipc = $("#fechainipipc").val();
    var fechafinpipc = $("#fechafinpipc").val();
    var IdOrden = $("#IdOrden").val();
    var hook = 'codi_hook';
        var action = 'update';
    // AJAX Ordenes
    $.ajax({
        url: apibase + 'ajax/insertar_fechas_pipc',
        type: 'POST',
        dataType: 'json',
        cache: false,
        data: {hook,action,fechainipipc,fechafinpipc,IdOrden},
        beforeSend: function () {
        }
    }).done(function (res) {
        if (res.status === 200) {
            Swal.fire({
                icon: 'success',
                title: res.msg,
                showConfirmButton: false,
                timer: 5500
            })
            //Wform.trigger('reset');
            location.reload();

        } else {
            Swal.fire({
                icon: 'error',
                title: res.msg,
                showConfirmButton: false,
                timer: 5500
            })
        }
    })
        .fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion. Code:3005',
                showConfirmButton: false,
                timer: 10500
            })
        })
        .always(function () {
            // form.waitMe('hide');
        });
}

function codi_update_baja_danado() {
    var form = $('.codi_update_baja_danado'),
        hook = 'codi_hook',
        action = 'add',
        data = new FormData(form.get(0));
        data.append('hook', hook);
        data.append('action', action);
        data.append('bobservacion', $('#bobservacion').val());
        data.append('bmotivo', $('#bmotivo').val());
        data.append('idordeno', $('#idOrdenO').val());
        data.append('folioorden', $('#FolioOrden').val());
        data.append('idproductoorden', $('#idproductoorden').val());
        data.append('cantidado', $('#cantidadO').val());
        data.append('cantidadeliminar', $('#cantidadEliminar').val());
        data.append('partida', $('#partidaE').val());
        data.append('trNombre', $('#trNombre').val());
        data.append('trSku', $('#trSku').val());
        data.append('trPreciocosto', $('#trPreciocosto').val());
        data.append('trPrecioventa', $('#trPrecioventa').val());
        data.append('trExistencia', $('#trExistencia').val());
        data.append('trCategoria', $('#trCategoria').val());
        data.append('trAlmId', $('#trAlmId').val());
        data.append('trImagen', $('#trImagen').val());
        data.append('trAlmacen', 4);
        data.append('trUsuario', $('#trUsuario').val());
        data.append('trPassword', $('#trPassword').val());
        data.append('trSubCategoria', $('#trSubCategoria').val());
        data.append('proMoneda', $('#proMoneda').val());

        if($('#cantidadO').val() < $('#cantidadEliminar').val()){
                    Swal.fire({
                icon: 'warning',
                title: 'No puedes eliminar una cantidad mayor a la que se ingreso en la orden',
                showConfirmButton: false,
                timer: 10500
            })

                    return;
        }

    // AJAX Ordenes
    $.ajax({
        url: apibase + 'ajax/codi_update_baja_danado',
        type: 'POST',
        dataType: 'json',
        contentType: false,
        processData: false,
        cache: false,
        data: data,
        beforeSend: function () {
        }
    }).done(function (res) {
        if (res.status === 201) {
            Swal.fire({
                icon: 'success',
                title: res.msg,
                showConfirmButton: false,
                timer: 5500
            })
            //Wform.trigger('reset');
            window.location.href = "";

        } else {
            Swal.fire({
                icon: 'error',
                title: res.msg,
                showConfirmButton: false,
                timer: 5500
            })
        }
    })
        .fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion. Code:3005',
                showConfirmButton: false,
                timer: 10500
            })
        })
        .always(function () {
            // form.waitMe('hide');
        });
}

function codi_get_orden(select, modo) {
    var IdOrden = select;
    var wrapper = "wrapper",
        hook = 'codi_hook',
        action = 'load';
     if(IdOrden == '' || IdOrden == undefined || IdOrden == null){
        return;
     }
    // AJAX Usuarios Get
    $.ajax({
        url: apibase + 'ajax/codi_get_orden',
        type: 'POST',
        dataType: 'json',
        cache: false,
        data: { hook, action, IdOrden: IdOrden },
        beforeSend: function () {

        }
    }).done(function (res) {
        if (res.status === 200) {
            var domiciliocom = "Calle " + res.data.EntCalle + " #" + res.data.EntNExt + " Colonia " + res.data.EntColonia +
                " C.P." + res.data.EntCP + " " + res.data.EntMunicipio + ", " + res.data.EntEstado

            if (modo == 'UPDATE') {
                $('#UIdOrden').val(res.data.IdOrden)
                $('#UIdCliente').val(res.data.IdCliente)
                $('#UIdDomicilio').val(res.data.IdDomicilio)
                $('#UNombre').text(res.data.Nombre)
                $('#UFisEmail').text(res.data.FisEmail)
                $('#UFisTelefono').text(res.data.FisTelefono)
                $('#UDomicilio').text(domiciliocom)
                $('#UEntCruces').text(res.data.EntCruces)
                $('#UEntObservaciones').text(res.data.EntObservaciones)
            } else {
                $('#IIdOrden').val(res.data.IdOrden)
                $('#IIdCliente').val(res.data.IdCliente)
                $('#IIdDomicilio').val(res.data.IdDomicilio)
                $('#INombre').text(res.data.Nombre)
                $('#IFisEmail').text(res.data.FisEmail)
                $('#IFisTelefono').text(res.data.FisTelefono)
                $('#IDomicilio').text(domiciliocom)
                $('#IEntCruces').text(res.data.EntCruces)
                $('#IEntObservaciones').text(res.data.EntObservaciones)
            }

        } else {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion',
                showConfirmButton: false,
                timer: 1500
            })
        }
    }).fail(function (err) {
        Swal.fire({
            icon: 'error',
            title: 'Hubo un error en la peticion' + err,
            showConfirmButton: false,
            timer: 1500
        })
    }).always(function () {

    });
}


function select_wrapper_partidas() {
    var wrapper = $('.select_wrapper_partidas'),
        hook = 'codi_hook',
        action = 'load';
    var IdOrden = $("#IdOrden").val();
 

    // AJAX Usuarios Get
    $.ajax({
        url: apibase + 'ajax/codi_get_partidas_select_orden',
        type: 'POST',
        dataType: 'json',
        cache: false,
        data: { hook, action, IdOrden },
        beforeSend: function () {

        }
    }).done(function (res) {
        if (res.status === 200) {
            console.log(res)
            wrapper.html(res.data);
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion',
                showConfirmButton: false,
                timer: 1500
            })
            wrapper.html('');
        }
    })
        .fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion' + err,
                showConfirmButton: false,
                timer: 1500
            })
            wrapper.html('');
        })
        .always(function () {

        });

}

function codi_get_vendedores_select() {
    var wrapper = $('.select_wrapper_vendedores'),
        hook = 'codi_hook',
        action = 'load';


    // AJAX Usuarios Get
    $.ajax({
        url: apibase + 'ajax/codi_get_vendedores_select',
        type: 'POST',
        dataType: 'json',
        cache: false,
        data: { hook, action },
        beforeSend: function () {

        }
    }).done(function (res) {
        if (res.status === 200) {
            wrapper.html(res.data);
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion',
                showConfirmButton: false,
                timer: 1500
            })
            wrapper.html('');
        }
    })
        .fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion' + err,
                showConfirmButton: false,
                timer: 1500
            })
            wrapper.html('');
        })
        .always(function () {

        });

}

function codi_get_orden_anclar(){
      var wrapper = $('.select_wrapper_ordenanclar'),
        hook = 'codi_hook',
        action = 'load';
        var idCliente = $("#idCliente").val();
    const w = document.querySelectorAll('.select_wrapper_ordenanclar');

    $.ajax({
        url: apibase + 'ajax/codi_get_ordenanclar',
        type: 'POST',
        dataType: 'json',
        cache: false,
        data: { hook, action, idCliente},
        beforeSend: function () {

        }
    }).done(function (res) {
        if (res.status === 200) {
            w.forEach(element => {
                element.innerHTML = res.data
            });
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion',
                showConfirmButton: false,
                timer: 6500
            })
            wrapper.html('');
        }
    }).fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion: Error en el servidor',
                showConfirmButton: false,
                timer: 6500
            })
            wrapper.html('');
        })
}

function codi_get_instructores_select() {
    var wrapper = $('.select_wrapper_instructores'),
        hook = 'codi_hook',
        action = 'load';


    // AJAX Usuarios Get
    $.ajax({
        url: apibase + 'ajax/codi_get_instructores_select',
        type: 'POST',
        dataType: 'json',
        cache: false,
        data: { hook, action },
        beforeSend: function () {

        }
    }).done(function (res) {
        if (res.status === 200) {
            wrapper.html(res.data);
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion',
                showConfirmButton: false,
                timer: 1500
            })
            wrapper.html('');
        }
    })
        .fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion' + err,
                showConfirmButton: false,
                timer: 1500
            })
            wrapper.html('');
        })
        .always(function () {

        });

}

function addEvent(){
        //Agregar Ajax
        var form = $('.codi_add_evento'),
            hook = 'codi_hook',
            action = 'add',
            data = new FormData(form.get(0));
        var partidaC = $('#partidaC').val();
        var alimentosli = 0; //alimentos
        var transporteli = 0; //transporte
        var dc3li = 0; //dc3

        if($("#IDAlimentosCliente").is(':checked')) { 
            alimentosli = 1;
        }
        if($("#IDTransporteCliente").is(':checked')){
            transporteli = 1;
        }
        if($("#IDC3Cliente").is(':checked')){
            dc3li = 1; 
        }
        data.append('hook', hook);
        data.append('action', action);
        data.append('partidaC',partidaC);
        data.append('alimentos',alimentosli);
        data.append('transporte',transporteli);
        data.append('dc3',dc3li);
        var IevntTipoServicio = $('#IevntTipoServicio').val();
        var IIdDomicilio = $('#IIdDomicilio').val();
        var IIdCliente = $('#IIdCliente').val();
        var IDC3Cliente = $('#IDC3Cliente').val();
        var IVendedor = $('#IVendedor').val();
        var IIdOrden = $('#IIdOrden').val();
        var IParticipantes = $('#IParticipantes').val();
        var IObservaciones = $('#IObservaciones').val();
        var IevntFechaInicio = $('#IevntFechaInicio').val();
        var IevntHoraInicio = $('#IevntHoraInicio').val();
        var IevntFechaFin = $('#IevntFechaFin').val();
        var IevntHoraFin = $('#IevntHoraFin').val();
        var IevntEstatus = $('#IevntEstatus').val();
        var IInstructores = $('#IInstructores').val();
        //validar que este seleccionado una opcion Usuario
       /* if (IevntTipoServicio === '' || IIdDomicilio === '' || IIdCliente === '' || IVendedor === ''
            || IIdOrden === '' || IParticipantes === '' || IevntFechaInicio === '' || IevntHoraInicio === ''
            || IevntHoraFin === '' || IevntFechaFin === '' || IevntEstatus === '' || IInstructores === '') {

            Swal.fire({
                icon: 'error',
                title: 'Alguno de los datos obligatorrios se encuentra vacío.',
                showConfirmButton: false,
                timer: 1500
            })

            return
        }*/
        
        // AJAX Usuarios
        $.ajax({
            url: apibase + 'ajax/codi_add_evento',
            type: 'POST',
            dataType: 'json',
            contentType: false,
            processData: false,
            cache: false,
            data: data,
            beforeSend: function () {
                // form.waitMe();
            }
        }).done(function (res) {
            if (res.status === 201) {
                Swal.fire({
                    icon: 'success',
                    title: res.msg,
                    showConfirmButton: false,
                    timer: 1500
                })

                window.location.href = "";

            } else {
                Swal.fire({
                    icon: 'error',
                    title: res.msg,
                    showConfirmButton: false,
                    timer: 1500
                })
            }
        })
            .fail(function (err) {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion',
                    showConfirmButton: false,
                    timer: 1500
                })
            })
            .always(function () {
                // form.waitMe('hide');
            });
        $('#addEventPopup').modal('hide');
    };


//------------------------------------------------------------------------------
$(document).ready(function () {

    //Obtener Moviemientos
    codi_get_detalleorden();
    codi_get_almacen_select();
    codi_get_productos_almacen_select();
    codi_get_orden_anclar();
    calculardiasDiscount();
    sleep(1500).then(() => {
        
        $('#proAlmacen').val(1).trigger('change');
    });

    $('#bajaExtintorForm').on('show.bs.modal', function (event) {
        var button = $(event.relatedTarget) // Button that triggered the modal
        var ce = button.data('claveextintor');
        var ie = button.data('idextintor');
        var par = button.data('partida');
        // If necessary, you could initiate an AJAX request here (and then do the updating in a callback).
        // Update the modal's content. We'll use jQuery here, but you could use a data binding library or other methods instead.
        var modal = $(this)
        modal.find('#BClaveExtintor').val(ce)
        modal.find('#BIdExtintor').val(ie)
        modal.find('#partidaextintor').val(par)
    })

    $('#bajaDanadoForm').on('show.bs.modal', function (event) {
        var button = $(event.relatedTarget) // Button that triggered the modal
        var idOrden = button.data('idordeno');
        var productoid = button.data('productoid');
        var cantidaddanado = button.data('cantidaddanado');
        var nombre = button.data('nombre');
        var partida = button.data('partida');
        var precioventa = button.data('precioventa');
        var proalmid = button.data('proalmid');
        var propreciocosto = button.data('propreciocosto');
        var sku = button.data('sku');
        var proexistencia = button.data('proexistencia');
        var procatId = button.data('procatid');
        var proimagen = button.data('proimagen');
        var subcategoria = button.data('subcategoria');
        var trmoneda = button.data('moneda');
        // If necessary, you could initiate an AJAX request here (and then do the updating in a callback).
        // Update the modal's content. We'll use jQuery here, but you could use a data binding library or other methods instead.
        var modal = $(this)
        modal.find('#tituloPbaja').text("¿Está seguro que desea dar de baja el producto "+ nombre +"?");
        modal.find('#idproductoorden').val(productoid);
        modal.find('#cantidadO').val(cantidaddanado);
        modal.find('#idOrdenO').val(idOrden);
        modal.find('#partidaE').val(partida);
        modal.find('#trNombre').val(nombre);
        modal.find('#trSku').val(sku);
        modal.find('#trPreciocosto').val(propreciocosto);
        modal.find('#trPrecioventa').val(precioventa);
        modal.find('#trExistencia').val(proexistencia);
        modal.find('#trCategoria').val(procatId);
        modal.find('#trAlmId').val(proalmid);
        modal.find('#trImagen').val(proimagen);
        modal.find('#trSubCategoria').val(subcategoria);
        modal.find('#proMoneda').val(trmoneda);
        
        /*let cantidadEliminar = $('#cantidadEliminar');
        for(i=0;i<cantidaddanado;i++){
            var optionvalue = i+1;
            var option = document.createElement('option');
            option.value = optionvalue;
            option.text = optionvalue;
            cantidadEliminar.append(option);
        }*/
    })

    $('#addEventPopup').on('show.bs.modal', function (event) {

        var button = $(event.relatedTarget) // Button that triggered the modal
        var idOrden = button.data('idordeno');
        var productoid = button.data('productoid');
        var partida = button.data('partida');
        var nombre = button.data('nombre');
        var fechaCalendario = button.data('fechacalendario');

        var modal = $(this)
        modal.find('#ordenp').text("Oden: "+idOrden);
        modal.find('#ncap').text(nombre);
        modal.find('#IevntFechaInicio').val(fechaCalendario);
        modal.find('#IevntFechaFin').val(fechaCalendario);
        modal.find("#partidaC").val(partida);
        modal.find("#tiposerviciooption").val(nombre);
        modal.find("#tiposerviciooption").text(nombre);
        codi_get_orden(idOrden,'CREATE');
        codi_get_vendedores_select();
        codi_get_instructores_select();
        select_wrapper_partidas();
})

    const $canvas = document.querySelector("#canvas"),
    $btnDescargar = document.querySelector("#btnDescargar"),
    $btnLimpiar = document.querySelector("#btnLimpiar"),
    $btnGenerarDocumento = document.querySelector("#btnGenerarDocumento");
const contexto = $canvas.getContext("2d");
const COLOR_PINCEL = "black";
const COLOR_FONDO = "#FAFAFA";
const GROSOR = 2;
let xAnterior = 0, yAnterior = 0, xActual = 0, yActual = 0;
const obtenerXReal = (clientX) => clientX - $canvas.getBoundingClientRect().left;
const obtenerYReal = (clientY) => clientY - $canvas.getBoundingClientRect().top;
let haComenzadoDibujo = false; // Bandera que indica si el usuario está presionando el botón del mouse sin soltarlo


const limpiarCanvas = () => {
    // Colocar color blanco en fondo de canvas
    contexto.fillStyle = COLOR_FONDO;
    contexto.fillRect(0, 0, $canvas.width, $canvas.height);
};
limpiarCanvas();
$btnLimpiar.onclick = limpiarCanvas;
// Escuchar clic del botón para descargar el canvas
$btnDescargar.onclick = () => {
    var img64 = $canvas.toDataURL();
    var IdOrden = $("#UIdOrden").val();
    var usuariopermitido = $("#usuval").val();
    var Nombrerecibe = $("#Nombrerecibe").val();
    var hook = 'codi_hook',
            action = 'load';
            var Utransito = $("#Utransito").val();
            console.log("Soy transito: " + Utransito)
    console.log("Soy usuario: " + usuariopermitido)
            if(Utransito == 14 && usuariopermitido == 14  || Utransito == 22 && usuariopermitido == 22 || Utransito == 22 && usuariopermitido == 24 || Utransito == 14 && usuariopermitido == 24 || Utransito == 22 && usuariopermitido == 1 || Utransito == 14 && usuariopermitido == 1 || Utransito == 9 && usuariopermitido == 9 || Utransito == 9 && usuariopermitido == 9 ){

            }else{
                Swal.fire({
                    icon: 'warning',
                    title: 'La orden debe estar en proceso de reparto o tener permiso para firmar. Para poder agregar la firma de entrega.',
                    timer: 5500
                })
                return 0;
            }

            if(Nombrerecibe == ''){
                Swal.fire({
                    icon: 'warning',
                    title: 'La orden no contiene nombre de receptor no se puede continuar.',
                    timer: 5500
                })
                return 0;
            }

        // AJAX Usuarios Get
        $.ajax({
            url: apibase + 'ajax/guardarfirma',
            type: 'POST',
            dataType: 'json',
            cache: false,
            data: { hook, action, img64, IdOrden,Nombrerecibe },
            beforeSend: function () {
                Swal.fire({
                    icon: '',
                    title: 'Guardando imagen',
                    text: 'Se esta creando la imagen de la firma',
                    showConfirmButton: false,
                    timer: 2500
                })
            }
        }).done(function (res) {
            Swal.fire({
                icon: 'success',
                title: 'Firma guardada correctamete',
                timer: 1500
            })

            setTimeout(location.reload(), 1500);
        }).fail(function (err) {
            Swal.fire({
                icon: 'error',
                title: 'Hubo un error en la peticion. Código: 3004',
                showConfirmButton: false,
                timer: 1500
            })
        }).always(function () {

        });
};

window.obtenerImagen = () => {
    return $canvas.toDataURL();
};

$btnGenerarDocumento.onclick = () => {
    window.open("documento.html");
};
const onClicOToqueIniciado = evento => {
    // En este evento solo se ha iniciado el clic, así que dibujamos un punto
    xAnterior = xActual;
    yAnterior = yActual;
    xActual = obtenerXReal(evento.clientX);
    yActual = obtenerYReal(evento.clientY);
    contexto.beginPath();
    contexto.fillStyle = COLOR_PINCEL;
    contexto.fillRect(xActual, yActual, GROSOR, GROSOR);
    contexto.closePath();
    // Y establecemos la bandera
    haComenzadoDibujo = true;
}

const onMouseODedoMovido = evento => {
    evento.preventDefault(); // Prevenir scroll en móviles
    if (!haComenzadoDibujo) {
        return;
    }
    // El mouse se está moviendo y el usuario está presionando el botón, así que dibujamos todo
    let target = evento;
    if (evento.type.includes("touch")) {
        target = evento.touches[0];
    }
    xAnterior = xActual;
    yAnterior = yActual;
    xActual = obtenerXReal(target.clientX);
    yActual = obtenerYReal(target.clientY);
    contexto.beginPath();
    contexto.moveTo(xAnterior, yAnterior);
    contexto.lineTo(xActual, yActual);
    contexto.strokeStyle = COLOR_PINCEL;
    contexto.lineWidth = GROSOR;
    contexto.stroke();
    contexto.closePath();
}
const onMouseODedoLevantado = () => {
    haComenzadoDibujo = false;
};

// Lo demás tiene que ver con pintar sobre el canvas en los eventos del mouse
["mousedown", "touchstart"].forEach(nombreDeEvento => {
    $canvas.addEventListener(nombreDeEvento, onClicOToqueIniciado);
});

["mousemove", "touchmove"].forEach(nombreDeEvento => {
    $canvas.addEventListener(nombreDeEvento, onMouseODedoMovido);
});
["mouseup", "touchend"].forEach(nombreDeEvento => {
    $canvas.addEventListener(nombreDeEvento, onMouseODedoLevantado);
});


    cambiartipo();
    agregarMotivoBaja();
    //  mostrardivbotoncred();
    mostrarGenerarComprobante();
})