var apibase = "https://grupoxtinfire.com/admin/";

$(document).ready(function () {
codi_get_invoices();
function codi_get_invoices() {

        var hook = 'codi_hook',
            action = 'load';
            var table = $('.datatable-init').DataTable({
                "searching" : true,
                "processing": true,
                "serverSide": true,
                "responsive": true,
                "dom": 'Blfrtip',
                "order": [[0, 'desc']],
        "orderCellsTop": true,
        "fixedHeader": true,
        language: {
          url: 'https://cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json'
        },
                columns: [
                    { data: "Fecha" },
                    { data: "IdOrden" },
                    { data: "PartidaOrden" },
                    { data: "NombreEstatus" ,"mRender": function(data, type, value) {
                        return (value['Estatus'] == 11) ? `<span class="badge rounded-pill bg-success">${value['NombreEstatus']}` : `<span class="badge rounded-pill bg-info">${value['NombreEstatus']}`; ``;
                    } },
                    { data: "NombreUsuario" },
                    { data: "DeptoDescripcion" },
                    { data: "Nombre" },
                    { data: "Items" },
                    { data: "TotalInvoice" ,"mRender": function(data, type, value) {
                        return ((parseFloat(value['TotalInvoice'],2)+ parseFloat(value['iva'],2)).toFixed(2));
                    } },
                    { data: "Acción", bSortable:false,"mRender": function(data, type, value) {
            return `<ul class="nk-tb-actions gx-1 my-n1 text-center">
                    <li class="me-n1 text-center">
                        <div class="dropdown">
                            <a href="#" class="dropdown-toggle btn btn-icon btn-trigger" data-bs-toggle="dropdown"><em class="icon ni ni-more-h"></em></a>
                            <div class="dropdown-menu dropdown-menu-end">
                                <ul class="link-list-opt no-bdr">
                                    <li><a href="${apibase}invoices/detalle/${value['IdInvoice']}" target="_blank"><em class="icon ni ni-eye"></em><span>Ver Factura</span></a></li>
                                    <li><a href="${apibase}ordenes/detalle/${value['IdOrden']}" target="_blank"><em class="icon ni ni-eye"></em><span>Ver Orden</span></a></li>
                                </ul>
                            </div>
                        </div>
                    </li>
                </ul>`;
        } }
                    ],
                "columnDefs": [{
            "targets": [9],
            "data": null,
            "defaultContent":
             `<ul class="nk-tb-actions gx-1 my-n1 text-center">
                    <li class="me-n1 text-center">
                        <div class="dropdown">
                            <a href="#" class="dropdown-toggle btn btn-icon btn-trigger" data-bs-toggle="dropdown"><em class="icon ni ni-more-h"></em></a>
                            <div class="dropdown-menu dropdown-menu-end">
                                <ul class="link-list-opt no-bdr">
                                    <li><a href="#" data-bs-toggle="modal" data-bs-target="#editForm" data-idcliente="<?php echo $clte->IdCliente; ?>" data-clave="<?php echo $clte->Clave; ?>" data-persona="<?php echo $clte->Persona; ?>" data-cfdi="<?php echo $clte->CFDI; ?>" data-regimenfiscal="<?php echo $clte->RegimenFiscal; ?>" data-tipopago="<?php echo $clte->TipoPago; ?>" data-nombre="<?php echo $clte->Nombre; ?>" data-rfc="<?php echo $clte->RFC; ?>" data-fistelefono="<?php echo $clte->FisTelefono; ?>" data-fisemail="<?php echo $clte->FisEmail; ?>" data-fiscalle="<?php echo $clte->FisCalle; ?>" data-fisnext="<?php echo $clte->FisNExt; ?>" data-fisnint="<?php echo $clte->FisNInt; ?>" data-fiscolonia="<?php echo $clte->FisColonia; ?>" data-fiscp="<?php echo $clte->FisCP; ?>" data-fismunicipio="<?php echo $clte->FisMunicipio; ?>" data-fisestado="<?php echo $clte->FisEstado; ?>" data-iddomicilio="<?php echo $clte->IdDomicilio; ?>" data-entcalle="<?php echo $clte->EntCalle; ?>" data-entnext="<?php echo $clte->EntNExt; ?>" data-entnint="<?php echo $clte->EntNInt; ?>" data-entcolonia="<?php echo $clte->EntColonia; ?>" data-entcp="<?php echo $clte->EntCP; ?>" data-entmunicipio="<?php echo $clte->EntMunicipio; ?>" data-entestado="<?php echo $clte->EntEstado; ?>" data-entgiro="<?php echo $clte->EntGiro; ?>" data-entdesde="<?php echo $clte->EntDesde; ?>" data-enthasta="<?php echo $clte->EntHasta; ?>" data-entcruces="<?php echo $clte->EntCruces; ?>" data-entobservaciones="<?php echo $clte->EntObservaciones; ?>"><em class="icon ni ni-edit"></em><span>Editar Cliente</span></a></li>
                                    <!--<li><a href="#"><em class="icon ni ni-eye"></em><span>Ver Cliente</span></a></li>-->
                                    <li><a href="#" data-bs-toggle="modal" data-bs-target="#modalAlert2" data-idclte="<?php echo $clte->IdCliente; ?>" data-nombre="<?php echo $clte->Nombre; ?>"><em class="icon ni ni-trash"></em><span>Eliminar Cliente</span></a></li>
                                </ul>
                            </div>
                        </div>
                    </li>
                </ul>`
          }],
          "buttons": [
          'copy', 'csv', 'excel', 'pdf'
        ],
        "lengthMenu": [
          [50, 100, 200, -1],
          ['50', '100', '200', 'Mostrar todo']
        ],
                "ajax":{
                    "url": 'ajax/codi_get_invoices2',
                    "type": 'POST',
                    'data' : { 'hook' : hook, 'action':action },
                    'dataFilter': function (json) {
                        var resultado = JSON.parse(json);
                        var data = resultado.data;
                        console.log(data)
                        return data;
                    }.bind(this)
                    
                }
            });

           
    }


    $('#modalAlert2').on('show.bs.modal', function (event) {
        var button = $(event.relatedTarget) // Button that triggered the modal
        var id = button.data('idclte');
        var fi = button.data('folioinvoice');
        // If necessary, you could initiate an AJAX request here (and then do the updating in a callback).
        // Update the modal's content. We'll use jQuery here, but you could use a data binding library or other methods instead.
        var modal = $(this)
        modal.find('#idOrden').val(id)
        modal.find('#EFolioInvoice').text(fi)
    })

    //Eliminar Moviemiento
    $('.codi_delete_orden').on('click', codi_delete_orden);
    function codi_delete_orden(event) {
        event.preventDefault();
        var idUsuario = $('#idOrden').val()
        console.log(idUsuario)
        var form = $('.codi_delete_orden'),
            hook = 'codi_hook',
            action = 'update',
            data = new FormData();
        data.append('hook', hook);
        data.append('action', action);
        data.append('activo', 400);
        data.append('idOrden', idUsuario)
        /*for (var pair of data.entries()) {
            console.log(pair[0]+ ', ' + pair[1]); 
        }*/
        // AJAX Usuarios
        $.ajax({
            url: 'ajax/codi_delete_orden',
            type: 'POST',
            dataType: 'json',
            contentType: false,
            processData: false,
            cache: false,
            data: data,
            beforeSend: function () {
                // form.waitMe();
            }
        }).done(function (res) {
            if (res.status === 200) {
                Swal.fire({
                    icon: 'success',
                    title: res.msg,
                    showConfirmButton: false,
                    timer: 1500
                })
                form.trigger('reset');
                window.location.reload()
            } else {
                Swal.fire({
                    icon: 'error',
                    title: res.msg,
                    showConfirmButton: false,
                    timer: 1500
                })
            }
        })
            .fail(function (err) {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion'.err,
                    showConfirmButton: false,
                    timer: 1500
                })
            })
            .always(function () {
                // form.waitMe('hide');
            });

    }

})