var apibase = "https://grupoxtinfire.com/admin/";

$(document).ready(function () {

    //Obtener Moviemientos 
    codi_get_ordenes_fecha();
    function codi_get_ordenes_fecha() {
        var wrapper = $('.tabla_wrapper_ordenes'), 
            hook = 'codi_hook',
            action = 'load';


        // AJAX Usuarios Get
        $.ajax({
            url: apibase + 'ajax/codi_get_ordenes_entrega_fecha',
            type: 'POST',
            dataType: 'json',
            cache: false,
            data: { hook, action },
            beforeSend: function () {

            }
        }).done(function (res) {
            if (res.status === 200) {
                console.log(res.data)
                wrapper.html(res.data);
                $('.datatable-init').DataTable({
                    responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    dom: 'Blfrtip',
                     lengthMenu: [
                        [50, 75, 100, -1],
                        [50, 75, 100, 'Todas las ordenes']
                    ],
                    buttons: ['copy', 'excel', 'csv', 'pdf'],
                    language: {
                        url: 'https://cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json'
                    },
                    "order": [[0, 'desc']],
                });

            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion',
                    showConfirmButton: false,
                    timer: 1500
                })
                wrapper.html('');

            }
        })
            .fail(function (err) {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion' + err,
                    showConfirmButton: false,
                    timer: 1500
                })
                wrapper.html('');
            })
            .always(function () {

            });

    }

})