var apibase = "https://grupoxtinfire.com/admin/";

$(document).ready(function () {
    codi_get_notificaciones();
    function codi_get_notificaciones() {
        var wrapper = $('.tabla_wrapper_notificaciones'),
            hook = 'codi_hook',
            action = 'load';
        var departamento = $("#departametonotificaciones").val();

        // AJAX Usuarios Get
        $.ajax({
            url: apibase + 'ajax/codi_get_notificaciones',
            type: 'POST',
            dataType: 'json',
            cache: false,
            data: { hook, action, departamento },
            beforeSend: function () {

            }
        }).done(function (res) {
            if (res.status === 200) {
                wrapper.html(res.data);
                $('.datatable-init').DataTable({
                    responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    order: [[0, 'desc']],
                    dom: 'Blfrtip',
                    buttons: ['copy', 'excel', 'csv', 'pdf'],
                    language: {
                        url: 'https://cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json'
                    }
                });
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion',
                    showConfirmButton: false,
                    timer: 1500
                })
                wrapper.html('');

            }
        })
            .fail(function (err) {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion' + err,
                    showConfirmButton: false,
                    timer: 1500
                })
                wrapper.html('');
            })
            .always(function () {

            });

    }
})