var apibase = "https://grupoxtinfire.com/admin/";
function mostrarcat() {
    var categoria = $('#selectcat').val();
    if (categoria == "1") {
        $('#rowextintores').show();
    } else {
        $('#rowextintores').hide();
    }
}

function esconder() {
    var tipo = document.querySelector('input[name="rbtipo"]:checked').value;
    if (tipo == "producto") {
        $('#rowproducto').show();
        $('#rowcategoria').hide();
        $('#rowextintores').hide();
    } else {
        $('#rowproducto').hide();
        $('#rowcategoria').show();
        $('#rowextintores').hide();
    }
}

function abrir_pdf(url) {
    var tipo = document.querySelector('input[name="rbtipo"]:checked').value;
    var conprecio = document.querySelector('input[name="rbprecio"]:checked').value;
    var extintor = document.querySelector('input[name="rbextintor"]:checked').value;
    var categoria = $('#selectcat').val();
    var claveprod = $('#selectprods').val();

    if (claveprod == null) {
        claveprod = 0;
    }
    if (categoria == null) {
        categoria = 0;
    }

    if (tipo == "producto" && claveprod == 0) {
        Swal.fire({
            icon: 'error',
            title: 'Por favor seleccione un producto.',
            showConfirmButton: false,
            timer: 1500
        })
    }
    else if (tipo == "categoria" && categoria == 0) {
        Swal.fire({
            icon: 'error',
            title: 'Por favor seleccione una categoría.',
            showConfirmButton: false,
            timer: 1500
        })
    } else {
        var redirigir = url + 'pdf/pdfqr/' + tipo + '/' + conprecio + '/' + categoria + '/' + extintor + '/' + claveprod;
        window.open(redirigir, '_blank');
    }
}

$(document).ready(function () {
    $('#rowproducto').show();
    $('#rowcategoria').hide();
    $('#rowextintores').hide();

    codi_get_productos_select();
    function codi_get_productos_select() {
        var wrapper = $('.select_wrapper_productos'),
            hook = 'codi_hook',
            action = 'load';


        // AJAX Usuarios Get
        $.ajax({
            url: apibase + 'ajax/codi_get_productos_select',
            type: 'POST',
            dataType: 'json',
            cache: false,
            data: { hook, action },
            beforeSend: function () {

            }
        }).done(function (res) {
            if (res.status === 200) {
                wrapper.html(res.data);
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion',
                    showConfirmButton: false,
                    timer: 1500
                })
                wrapper.html('');

            }
        })
            .fail(function (err) {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion' + err,
                    showConfirmButton: false,
                    timer: 1500
                })
                wrapper.html('');
            })
            .always(function () {

            });

    }

    codi_get_categoriap_select();
    function codi_get_categoriap_select() {
        var wrapper = $('.select_wrapper_categorias'),
            hook = 'codi_hook',
            action = 'load';


        // AJAX Usuarios Get
        $.ajax({
            url: apibase + 'ajax/codi_get_categoriap_select',
            type: 'POST',
            dataType: 'json',
            cache: false,
            data: { hook, action },
            beforeSend: function () {

            }
        }).done(function (res) {
            if (res.status === 200) {
                wrapper.html(res.data);
                mostrarcat();
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion',
                    showConfirmButton: false,
                    timer: 1500
                })
                wrapper.html('');

            }
        })
            .fail(function (err) {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion' + err,
                    showConfirmButton: false,
                    timer: 1500
                })
                wrapper.html('');
            })
            .always(function () {

            });

    }
})